import { Buffer } from 'buffer';
interface DhcpOptions {
    [key: number]: any;
}
export declare class Packet {
    op: number;
    htype: number;
    hlen: number;
    hops: number;
    xid: number;
    secs: number;
    flags: number;
    ciaddr: string;
    yiaddr: string;
    siaddr: string;
    giaddr: string;
    chaddr: string;
    sname: string;
    fname: string;
    options: DhcpOptions;
    constructor(init: Partial<Packet>);
    /**
     * Crea un oggetto Packet da un Buffer
     * @param b Il Buffer da cui leggere
     * @returns Un'istanza di Packet
     */
    static fromBuffer(b: Buffer): Packet;
    getRequestedIPAddress(): string;
    op_set(op: number): this;
    /**
     * Converte l'oggetto Packet in un Buffer
     * @returns Il Buffer DHCP
     */
    toBuffer(): Buffer;
}
export {};
