#ifndef IXXL_H
#define IXXL_H

#ifndef WIN32
#include "config.h"
#endif
#include "xxl.h"

#if !defined(XXL_WITHOUT_THREADS) && !defined(WIN32) && !defined(HAVE_PTHREAD_H)
#define XXL_WITHOUT_THREADS
#endif

#ifdef WIN32
#include <io.h>

extern HANDLE xxl_heap;

#ifdef XXL_WITHOUT_THREADS
#define XXL_IMALLOC(nbytes)  HeapAlloc(xxl_heap, HEAP_NO_SERIALIZE, (nbytes))
#define XXL_IFREE(ptr)       HeapFree(xxl_heap, HEAP_NO_SERIALIZE, (ptr))
#else
#define XXL_IMALLOC(nbytes)  HeapAlloc(xxl_heap, 0, (nbytes))
#define XXL_IFREE(ptr)       HeapFree(xxl_heap, 0, (ptr))
#endif
#else
#ifdef STDC_HEADERS
#include <stdio.h>          /* fprintf(), stderr */
#include <stdlib.h>         /* abort(), free(), malloc() */
#ifdef HAVE_UNISTD_H
#include <unistd.h>         /* close() */
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>          /* open() */
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>      /* needed by sys/socket.h */
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>     /* shutdown(), socket() */
#endif
#endif

#define XXL_IMALLOC(nbytes)  malloc((nbytes))
#define XXL_IFREE(ptr)       free((ptr))

#endif

#endif  /* IXXL_H */
