/*
 * This file is part of libwandio
 *
 * Copyright (c) 2007-2015 The University of Waikato, Hamilton, 
 * New Zealand.
 *
 * Authors: Perry Lorier
 *          Shane Alcock 
 *          
 * All rights reserved.
 *
 * This code has been developed by the University of Waikato WAND 
 * research group. For further information please see http://www.wand.net.nz/
 *
 * libwandio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libwandio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libwandio; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */

#ifndef WANDIO_INTERNAL_H 
#define WANDIO_INTERNAL_H 1 /**< Guard Define */
#include "config.h"
#include <sys/types.h>
#include <stdio.h>
#include <inttypes.h>


/** @name libwandioio options 
 * @{ */
extern int force_directio_read;
extern int force_directio_write;
extern uint64_t write_waits;
extern uint64_t read_waits;
extern unsigned int use_threads;
extern unsigned int max_buffers;
/* @} */

#endif
