#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1381
#define LARGE_STATE_COUNT 406
#define SYMBOL_COUNT 321
#define ALIAS_COUNT 1
#define TOKEN_COUNT 138
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 40
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 208

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  anon_sym_DQUOTE = 11,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 12,
  sym_string_fragment = 13,
  aux_sym__multiline_string_fragment_token1 = 14,
  aux_sym__multiline_string_fragment_token2 = 15,
  anon_sym_BSLASH_LBRACE = 16,
  anon_sym_RBRACE = 17,
  aux_sym__escape_sequence_token1 = 18,
  sym_escape_sequence = 19,
  sym_null_literal = 20,
  anon_sym_LPAREN = 21,
  anon_sym_RPAREN = 22,
  anon_sym_AMP = 23,
  anon_sym_EQ = 24,
  anon_sym_PLUS_EQ = 25,
  anon_sym_DASH_EQ = 26,
  anon_sym_STAR_EQ = 27,
  anon_sym_SLASH_EQ = 28,
  anon_sym_AMP_EQ = 29,
  anon_sym_PIPE_EQ = 30,
  anon_sym_CARET_EQ = 31,
  anon_sym_PERCENT_EQ = 32,
  anon_sym_LT_LT_EQ = 33,
  anon_sym_GT_GT_EQ = 34,
  anon_sym_GT_GT_GT_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_LT = 37,
  anon_sym_GT_EQ = 38,
  anon_sym_LT_EQ = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_BANG_EQ = 41,
  anon_sym_AMP_AMP = 42,
  anon_sym_PIPE_PIPE = 43,
  anon_sym_PLUS = 44,
  anon_sym_DASH = 45,
  anon_sym_STAR = 46,
  anon_sym_SLASH = 47,
  anon_sym_PIPE = 48,
  anon_sym_CARET = 49,
  anon_sym_PERCENT = 50,
  anon_sym_LT_LT = 51,
  anon_sym_GT_GT = 52,
  anon_sym_GT_GT_GT = 53,
  anon_sym_instanceof = 54,
  anon_sym_final = 55,
  anon_sym_DASH_GT = 56,
  anon_sym_COMMA = 57,
  anon_sym_QMARK = 58,
  anon_sym_COLON = 59,
  anon_sym_BANG = 60,
  anon_sym_TILDE = 61,
  anon_sym_PLUS_PLUS = 62,
  anon_sym_DASH_DASH = 63,
  anon_sym_new = 64,
  anon_sym_LBRACK = 65,
  anon_sym_RBRACK = 66,
  anon_sym_DOT = 67,
  anon_sym_class = 68,
  anon_sym_COLON_COLON = 69,
  anon_sym_extends = 70,
  anon_sym_switch = 71,
  anon_sym_LBRACE = 72,
  anon_sym_case = 73,
  anon_sym_default = 74,
  sym_underscore_pattern = 75,
  anon_sym_when = 76,
  anon_sym_SEMI = 77,
  anon_sym_assert = 78,
  anon_sym_do = 79,
  anon_sym_while = 80,
  anon_sym_break = 81,
  anon_sym_continue = 82,
  anon_sym_return = 83,
  anon_sym_yield = 84,
  anon_sym_synchronized = 85,
  anon_sym_throw = 86,
  anon_sym_try = 87,
  anon_sym_catch = 88,
  anon_sym_finally = 89,
  anon_sym_if = 90,
  anon_sym_else = 91,
  anon_sym_for = 92,
  anon_sym_AT = 93,
  anon_sym_open = 94,
  anon_sym_module = 95,
  anon_sym_requires = 96,
  anon_sym_transitive = 97,
  anon_sym_static = 98,
  anon_sym_exports = 99,
  anon_sym_to = 100,
  anon_sym_opens = 101,
  anon_sym_uses = 102,
  anon_sym_provides = 103,
  anon_sym_with = 104,
  anon_sym_package = 105,
  anon_sym_import = 106,
  anon_sym_enum = 107,
  anon_sym_public = 108,
  anon_sym_protected = 109,
  anon_sym_private = 110,
  anon_sym_abstract = 111,
  anon_sym_strictfp = 112,
  anon_sym_native = 113,
  anon_sym_transient = 114,
  anon_sym_volatile = 115,
  anon_sym_sealed = 116,
  anon_sym_non_DASHsealed = 117,
  anon_sym_implements = 118,
  anon_sym_permits = 119,
  anon_sym_record = 120,
  anon_sym_ATinterface = 121,
  anon_sym_interface = 122,
  anon_sym_byte = 123,
  anon_sym_short = 124,
  anon_sym_int = 125,
  anon_sym_long = 126,
  anon_sym_char = 127,
  anon_sym_float = 128,
  anon_sym_double = 129,
  sym_boolean_type = 130,
  sym_void_type = 131,
  anon_sym_DOT_DOT_DOT = 132,
  anon_sym_throws = 133,
  sym_this = 134,
  sym_super = 135,
  sym_line_comment = 136,
  sym_block_comment = 137,
  sym_program = 138,
  sym__toplevel_statement = 139,
  sym__literal = 140,
  sym_string_literal = 141,
  sym__string_literal = 142,
  sym__multiline_string_literal = 143,
  sym__multiline_string_fragment = 144,
  sym_string_interpolation = 145,
  sym__escape_sequence = 146,
  sym_expression = 147,
  sym_cast_expression = 148,
  sym_assignment_expression = 149,
  sym_binary_expression = 150,
  sym_instanceof_expression = 151,
  sym_lambda_expression = 152,
  sym_inferred_parameters = 153,
  sym_ternary_expression = 154,
  sym_unary_expression = 155,
  sym_update_expression = 156,
  sym_primary_expression = 157,
  sym_array_creation_expression = 158,
  sym_dimensions_expr = 159,
  sym_parenthesized_expression = 160,
  sym_condition = 161,
  sym_class_literal = 162,
  sym_object_creation_expression = 163,
  sym__unqualified_object_creation_expression = 164,
  sym_field_access = 165,
  sym_template_expression = 166,
  sym_array_access = 167,
  sym_method_invocation = 168,
  sym_argument_list = 169,
  sym_method_reference = 170,
  sym_type_arguments = 171,
  sym_wildcard = 172,
  sym__wildcard_bounds = 173,
  sym_dimensions = 174,
  sym_switch_expression = 175,
  sym_switch_block = 176,
  sym_switch_block_statement_group = 177,
  sym_switch_rule = 178,
  sym_switch_label = 179,
  sym_pattern = 180,
  sym_type_pattern = 181,
  sym_record_pattern = 182,
  sym_record_pattern_body = 183,
  sym_record_pattern_component = 184,
  sym_guard = 185,
  sym_statement = 186,
  sym_block = 187,
  sym_expression_statement = 188,
  sym_labeled_statement = 189,
  sym_assert_statement = 190,
  sym_do_statement = 191,
  sym_break_statement = 192,
  sym_continue_statement = 193,
  sym_return_statement = 194,
  sym_yield_statement = 195,
  sym_synchronized_statement = 196,
  sym_throw_statement = 197,
  sym_try_statement = 198,
  sym_catch_clause = 199,
  sym_catch_formal_parameter = 200,
  sym_catch_type = 201,
  sym_finally_clause = 202,
  sym_try_with_resources_statement = 203,
  sym_resource_specification = 204,
  sym_resource = 205,
  sym_if_statement = 206,
  sym_while_statement = 207,
  sym_for_statement = 208,
  sym_enhanced_for_statement = 209,
  sym__annotation = 210,
  sym_marker_annotation = 211,
  sym_annotation = 212,
  sym_annotation_argument_list = 213,
  sym_element_value_pair = 214,
  sym__element_value = 215,
  sym_element_value_array_initializer = 216,
  sym_declaration = 217,
  sym_module_declaration = 218,
  sym_module_body = 219,
  sym_module_directive = 220,
  sym_requires_module_directive = 221,
  sym_requires_modifier = 222,
  sym_exports_module_directive = 223,
  sym_opens_module_directive = 224,
  sym_uses_module_directive = 225,
  sym_provides_module_directive = 226,
  sym_package_declaration = 227,
  sym_import_declaration = 228,
  sym_asterisk = 229,
  sym_enum_declaration = 230,
  sym_enum_body = 231,
  sym_enum_body_declarations = 232,
  sym_enum_constant = 233,
  sym_class_declaration = 234,
  sym_modifiers = 235,
  sym_type_parameters = 236,
  sym_type_parameter = 237,
  sym_type_bound = 238,
  sym_superclass = 239,
  sym_super_interfaces = 240,
  sym_type_list = 241,
  sym_permits = 242,
  sym_class_body = 243,
  sym_static_initializer = 244,
  sym_constructor_declaration = 245,
  sym__constructor_declarator = 246,
  sym_constructor_body = 247,
  sym_explicit_constructor_invocation = 248,
  sym_scoped_identifier = 249,
  sym_field_declaration = 250,
  sym_record_declaration = 251,
  sym_annotation_type_declaration = 252,
  sym_annotation_type_body = 253,
  sym_annotation_type_element_declaration = 254,
  sym__default_value = 255,
  sym_interface_declaration = 256,
  sym_extends_interfaces = 257,
  sym_interface_body = 258,
  sym_constant_declaration = 259,
  sym__variable_declarator_list = 260,
  sym_variable_declarator = 261,
  sym__variable_declarator_id = 262,
  sym_array_initializer = 263,
  sym__type = 264,
  sym__unannotated_type = 265,
  sym_annotated_type = 266,
  sym_scoped_type_identifier = 267,
  sym_generic_type = 268,
  sym_array_type = 269,
  sym_integral_type = 270,
  sym_floating_point_type = 271,
  sym__method_header = 272,
  sym__method_declarator = 273,
  sym_formal_parameters = 274,
  sym_formal_parameter = 275,
  sym_receiver_parameter = 276,
  sym_spread_parameter = 277,
  sym_throws = 278,
  sym_local_variable_declaration = 279,
  sym_method_declaration = 280,
  sym_compact_constructor_declaration = 281,
  sym__reserved_identifier = 282,
  aux_sym_program_repeat1 = 283,
  aux_sym__string_literal_repeat1 = 284,
  aux_sym__multiline_string_literal_repeat1 = 285,
  aux_sym_cast_expression_repeat1 = 286,
  aux_sym_inferred_parameters_repeat1 = 287,
  aux_sym_array_creation_expression_repeat1 = 288,
  aux_sym_array_creation_expression_repeat2 = 289,
  aux_sym_argument_list_repeat1 = 290,
  aux_sym_type_arguments_repeat1 = 291,
  aux_sym_dimensions_repeat1 = 292,
  aux_sym_switch_block_repeat1 = 293,
  aux_sym_switch_block_repeat2 = 294,
  aux_sym_switch_block_statement_group_repeat1 = 295,
  aux_sym_switch_block_statement_group_repeat2 = 296,
  aux_sym_record_pattern_body_repeat1 = 297,
  aux_sym_try_statement_repeat1 = 298,
  aux_sym_catch_type_repeat1 = 299,
  aux_sym_resource_specification_repeat1 = 300,
  aux_sym_for_statement_repeat1 = 301,
  aux_sym_for_statement_repeat2 = 302,
  aux_sym_annotation_argument_list_repeat1 = 303,
  aux_sym_element_value_array_initializer_repeat1 = 304,
  aux_sym_module_body_repeat1 = 305,
  aux_sym_requires_module_directive_repeat1 = 306,
  aux_sym_exports_module_directive_repeat1 = 307,
  aux_sym_provides_module_directive_repeat1 = 308,
  aux_sym_enum_body_repeat1 = 309,
  aux_sym_enum_body_declarations_repeat1 = 310,
  aux_sym_modifiers_repeat1 = 311,
  aux_sym_type_parameters_repeat1 = 312,
  aux_sym_type_bound_repeat1 = 313,
  aux_sym_type_list_repeat1 = 314,
  aux_sym_annotation_type_body_repeat1 = 315,
  aux_sym_interface_body_repeat1 = 316,
  aux_sym__variable_declarator_list_repeat1 = 317,
  aux_sym_array_initializer_repeat1 = 318,
  aux_sym_formal_parameters_repeat1 = 319,
  aux_sym_receiver_parameter_repeat1 = 320,
  alias_sym_type_identifier = 321,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [sym_string_fragment] = "string_fragment",
  [aux_sym__multiline_string_fragment_token1] = "_multiline_string_fragment_token1",
  [aux_sym__multiline_string_fragment_token2] = "_multiline_string_fragment_token2",
  [anon_sym_BSLASH_LBRACE] = "\\{",
  [anon_sym_RBRACE] = "}",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_final] = "final",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_switch] = "switch",
  [anon_sym_LBRACE] = "{",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [sym_underscore_pattern] = "underscore_pattern",
  [anon_sym_when] = "when",
  [anon_sym_SEMI] = ";",
  [anon_sym_assert] = "assert",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_yield] = "yield",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_sealed] = "sealed",
  [anon_sym_non_DASHsealed] = "non-sealed",
  [anon_sym_implements] = "implements",
  [anon_sym_permits] = "permits",
  [anon_sym_record] = "record",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_program] = "program",
  [sym__toplevel_statement] = "_toplevel_statement",
  [sym__literal] = "_literal",
  [sym_string_literal] = "string_literal",
  [sym__string_literal] = "_string_literal",
  [sym__multiline_string_literal] = "_multiline_string_literal",
  [sym__multiline_string_fragment] = "multiline_string_fragment",
  [sym_string_interpolation] = "string_interpolation",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_expression] = "expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition] = "condition",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_template_expression] = "template_expression",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_block] = "switch_block",
  [sym_switch_block_statement_group] = "switch_block_statement_group",
  [sym_switch_rule] = "switch_rule",
  [sym_switch_label] = "switch_label",
  [sym_pattern] = "pattern",
  [sym_type_pattern] = "type_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_body] = "record_pattern_body",
  [sym_record_pattern_component] = "record_pattern_component",
  [sym_guard] = "guard",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym_declaration] = "declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_body] = "module_body",
  [sym_module_directive] = "module_directive",
  [sym_requires_module_directive] = "requires_module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_exports_module_directive] = "exports_module_directive",
  [sym_opens_module_directive] = "opens_module_directive",
  [sym_uses_module_directive] = "uses_module_directive",
  [sym_provides_module_directive] = "provides_module_directive",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_type_list] = "type_list",
  [sym_permits] = "permits",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_record_declaration] = "record_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_compact_constructor_declaration] = "compact_constructor_declaration",
  [sym__reserved_identifier] = "_reserved_identifier",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym__string_literal_repeat1] = "_string_literal_repeat1",
  [aux_sym__multiline_string_literal_repeat1] = "_multiline_string_literal_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_array_creation_expression_repeat2] = "array_creation_expression_repeat2",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_switch_block_repeat2] = "switch_block_repeat2",
  [aux_sym_switch_block_statement_group_repeat1] = "switch_block_statement_group_repeat1",
  [aux_sym_switch_block_statement_group_repeat2] = "switch_block_statement_group_repeat2",
  [aux_sym_record_pattern_body_repeat1] = "record_pattern_body_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_requires_module_directive_repeat1] = "requires_module_directive_repeat1",
  [aux_sym_exports_module_directive_repeat1] = "exports_module_directive_repeat1",
  [aux_sym_provides_module_directive_repeat1] = "provides_module_directive_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_type_list_repeat1] = "type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_receiver_parameter_repeat1] = "receiver_parameter_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [sym_string_fragment] = sym_string_fragment,
  [aux_sym__multiline_string_fragment_token1] = aux_sym__multiline_string_fragment_token1,
  [aux_sym__multiline_string_fragment_token2] = aux_sym__multiline_string_fragment_token2,
  [anon_sym_BSLASH_LBRACE] = anon_sym_BSLASH_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [sym_underscore_pattern] = sym_underscore_pattern,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_sealed] = anon_sym_sealed,
  [anon_sym_non_DASHsealed] = anon_sym_non_DASHsealed,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_permits] = anon_sym_permits,
  [anon_sym_record] = anon_sym_record,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_program] = sym_program,
  [sym__toplevel_statement] = sym__toplevel_statement,
  [sym__literal] = sym__literal,
  [sym_string_literal] = sym_string_literal,
  [sym__string_literal] = sym__string_literal,
  [sym__multiline_string_literal] = sym__multiline_string_literal,
  [sym__multiline_string_fragment] = sym__multiline_string_fragment,
  [sym_string_interpolation] = sym_string_interpolation,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_expression] = sym_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition] = sym_condition,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_template_expression] = sym_template_expression,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_block_statement_group] = sym_switch_block_statement_group,
  [sym_switch_rule] = sym_switch_rule,
  [sym_switch_label] = sym_switch_label,
  [sym_pattern] = sym_pattern,
  [sym_type_pattern] = sym_type_pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_body] = sym_record_pattern_body,
  [sym_record_pattern_component] = sym_record_pattern_component,
  [sym_guard] = sym_guard,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym_declaration] = sym_declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_body] = sym_module_body,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_module_directive] = sym_requires_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_exports_module_directive] = sym_exports_module_directive,
  [sym_opens_module_directive] = sym_opens_module_directive,
  [sym_uses_module_directive] = sym_uses_module_directive,
  [sym_provides_module_directive] = sym_provides_module_directive,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_type_list] = sym_type_list,
  [sym_permits] = sym_permits,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_record_declaration] = sym_record_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_compact_constructor_declaration] = sym_compact_constructor_declaration,
  [sym__reserved_identifier] = sym__reserved_identifier,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym__string_literal_repeat1] = aux_sym__string_literal_repeat1,
  [aux_sym__multiline_string_literal_repeat1] = aux_sym__multiline_string_literal_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_array_creation_expression_repeat2] = aux_sym_array_creation_expression_repeat2,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_switch_block_repeat2] = aux_sym_switch_block_repeat2,
  [aux_sym_switch_block_statement_group_repeat1] = aux_sym_switch_block_statement_group_repeat1,
  [aux_sym_switch_block_statement_group_repeat2] = aux_sym_switch_block_statement_group_repeat2,
  [aux_sym_record_pattern_body_repeat1] = aux_sym_record_pattern_body_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_requires_module_directive_repeat1] = aux_sym_requires_module_directive_repeat1,
  [aux_sym_exports_module_directive_repeat1] = aux_sym_exports_module_directive_repeat1,
  [aux_sym_provides_module_directive_repeat1] = aux_sym_provides_module_directive_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_type_list_repeat1] = aux_sym_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_receiver_parameter_repeat1] = aux_sym_receiver_parameter_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__multiline_string_fragment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_fragment_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [sym_underscore_pattern] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_non_DASHsealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_permits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__toplevel_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_string_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_template_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_type_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_body] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_component] = {
    .visible = true,
    .named = true,
  },
  [sym_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_requires_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_exports_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_opens_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_uses_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_provides_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_permits] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_record_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_compact_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__reserved_identifier] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_statement_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_statement_group_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requires_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exports_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_provides_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_receiver_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_init = 13,
  field_interfaces = 14,
  field_key = 15,
  field_left = 16,
  field_modifiers = 17,
  field_module = 18,
  field_modules = 19,
  field_name = 20,
  field_object = 21,
  field_operand = 22,
  field_operator = 23,
  field_package = 24,
  field_parameters = 25,
  field_pattern = 26,
  field_permits = 27,
  field_provided = 28,
  field_provider = 29,
  field_resources = 30,
  field_right = 31,
  field_scope = 32,
  field_superclass = 33,
  field_template_argument = 34,
  field_template_processor = 35,
  field_type = 36,
  field_type_arguments = 37,
  field_type_parameters = 38,
  field_update = 39,
  field_value = 40,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_modifiers] = "modifiers",
  [field_module] = "module",
  [field_modules] = "modules",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_permits] = "permits",
  [field_provided] = "provided",
  [field_provider] = "provider",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_superclass] = "superclass",
  [field_template_argument] = "template_argument",
  [field_template_processor] = "template_processor",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 2},
  [9] = {.index = 11, .length = 1},
  [10] = {.index = 12, .length = 2},
  [11] = {.index = 14, .length = 4},
  [12] = {.index = 18, .length = 5},
  [13] = {.index = 23, .length = 6},
  [14] = {.index = 29, .length = 3},
  [16] = {.index = 32, .length = 2},
  [17] = {.index = 34, .length = 2},
  [18] = {.index = 32, .length = 2},
  [19] = {.index = 34, .length = 2},
  [20] = {.index = 36, .length = 2},
  [21] = {.index = 38, .length = 2},
  [22] = {.index = 40, .length = 1},
  [23] = {.index = 41, .length = 1},
  [24] = {.index = 42, .length = 2},
  [25] = {.index = 44, .length = 2},
  [26] = {.index = 46, .length = 2},
  [27] = {.index = 48, .length = 2},
  [28] = {.index = 50, .length = 3},
  [29] = {.index = 53, .length = 2},
  [31] = {.index = 55, .length = 2},
  [32] = {.index = 57, .length = 2},
  [33] = {.index = 59, .length = 2},
  [34] = {.index = 61, .length = 3},
  [35] = {.index = 64, .length = 5},
  [36] = {.index = 69, .length = 6},
  [37] = {.index = 75, .length = 5},
  [38] = {.index = 80, .length = 2},
  [39] = {.index = 82, .length = 2},
  [40] = {.index = 84, .length = 2},
  [41] = {.index = 86, .length = 2},
  [43] = {.index = 88, .length = 3},
  [44] = {.index = 91, .length = 2},
  [45] = {.index = 93, .length = 1},
  [46] = {.index = 94, .length = 2},
  [47] = {.index = 96, .length = 3},
  [48] = {.index = 99, .length = 3},
  [49] = {.index = 96, .length = 3},
  [50] = {.index = 99, .length = 3},
  [51] = {.index = 102, .length = 3},
  [52] = {.index = 102, .length = 3},
  [53] = {.index = 105, .length = 2},
  [54] = {.index = 107, .length = 2},
  [55] = {.index = 105, .length = 2},
  [56] = {.index = 107, .length = 2},
  [57] = {.index = 109, .length = 3},
  [58] = {.index = 112, .length = 3},
  [59] = {.index = 115, .length = 3},
  [60] = {.index = 118, .length = 3},
  [61] = {.index = 121, .length = 2},
  [62] = {.index = 123, .length = 2},
  [63] = {.index = 125, .length = 3},
  [64] = {.index = 128, .length = 2},
  [65] = {.index = 130, .length = 3},
  [67] = {.index = 133, .length = 2},
  [68] = {.index = 135, .length = 2},
  [69] = {.index = 137, .length = 3},
  [70] = {.index = 140, .length = 2},
  [71] = {.index = 142, .length = 2},
  [72] = {.index = 144, .length = 5},
  [73] = {.index = 149, .length = 3},
  [74] = {.index = 152, .length = 1},
  [75] = {.index = 153, .length = 2},
  [76] = {.index = 155, .length = 3},
  [78] = {.index = 158, .length = 3},
  [79] = {.index = 161, .length = 3},
  [80] = {.index = 161, .length = 3},
  [81] = {.index = 164, .length = 3},
  [82] = {.index = 167, .length = 3},
  [83] = {.index = 164, .length = 3},
  [84] = {.index = 167, .length = 3},
  [85] = {.index = 170, .length = 3},
  [86] = {.index = 170, .length = 3},
  [87] = {.index = 173, .length = 2},
  [88] = {.index = 175, .length = 4},
  [89] = {.index = 179, .length = 4},
  [90] = {.index = 183, .length = 4},
  [91] = {.index = 187, .length = 4},
  [92] = {.index = 191, .length = 4},
  [93] = {.index = 195, .length = 4},
  [94] = {.index = 199, .length = 4},
  [95] = {.index = 203, .length = 2},
  [96] = {.index = 205, .length = 3},
  [97] = {.index = 208, .length = 1},
  [98] = {.index = 209, .length = 2},
  [99] = {.index = 211, .length = 1},
  [100] = {.index = 212, .length = 4},
  [101] = {.index = 216, .length = 4},
  [102] = {.index = 220, .length = 3},
  [103] = {.index = 223, .length = 3},
  [104] = {.index = 226, .length = 2},
  [105] = {.index = 228, .length = 4},
  [106] = {.index = 232, .length = 3},
  [107] = {.index = 235, .length = 3},
  [108] = {.index = 238, .length = 3},
  [109] = {.index = 241, .length = 3},
  [110] = {.index = 244, .length = 3},
  [111] = {.index = 247, .length = 3},
  [112] = {.index = 250, .length = 3},
  [113] = {.index = 253, .length = 2},
  [114] = {.index = 255, .length = 2},
  [115] = {.index = 257, .length = 3},
  [116] = {.index = 257, .length = 3},
  [117] = {.index = 260, .length = 4},
  [118] = {.index = 264, .length = 3},
  [119] = {.index = 267, .length = 4},
  [120] = {.index = 271, .length = 5},
  [121] = {.index = 276, .length = 5},
  [122] = {.index = 281, .length = 5},
  [123] = {.index = 286, .length = 5},
  [124] = {.index = 291, .length = 4},
  [125] = {.index = 295, .length = 2},
  [126] = {.index = 297, .length = 1},
  [127] = {.index = 298, .length = 2},
  [128] = {.index = 300, .length = 2},
  [129] = {.index = 302, .length = 1},
  [130] = {.index = 303, .length = 2},
  [131] = {.index = 305, .length = 1},
  [132] = {.index = 306, .length = 3},
  [133] = {.index = 309, .length = 5},
  [134] = {.index = 314, .length = 4},
  [135] = {.index = 318, .length = 3},
  [136] = {.index = 321, .length = 4},
  [137] = {.index = 325, .length = 4},
  [138] = {.index = 329, .length = 4},
  [139] = {.index = 333, .length = 4},
  [140] = {.index = 337, .length = 4},
  [141] = {.index = 341, .length = 4},
  [142] = {.index = 345, .length = 4},
  [143] = {.index = 349, .length = 4},
  [144] = {.index = 353, .length = 3},
  [145] = {.index = 356, .length = 3},
  [146] = {.index = 359, .length = 4},
  [147] = {.index = 363, .length = 6},
  [148] = {.index = 369, .length = 4},
  [149] = {.index = 373, .length = 1},
  [150] = {.index = 374, .length = 2},
  [151] = {.index = 376, .length = 2},
  [152] = {.index = 378, .length = 1},
  [153] = {.index = 379, .length = 2},
  [154] = {.index = 381, .length = 2},
  [155] = {.index = 383, .length = 2},
  [156] = {.index = 385, .length = 3},
  [157] = {.index = 388, .length = 3},
  [158] = {.index = 391, .length = 2},
  [159] = {.index = 393, .length = 3},
  [160] = {.index = 396, .length = 4},
  [161] = {.index = 400, .length = 5},
  [162] = {.index = 405, .length = 5},
  [163] = {.index = 410, .length = 5},
  [164] = {.index = 415, .length = 5},
  [165] = {.index = 420, .length = 5},
  [166] = {.index = 425, .length = 4},
  [167] = {.index = 429, .length = 2},
  [168] = {.index = 431, .length = 3},
  [169] = {.index = 434, .length = 3},
  [170] = {.index = 437, .length = 3},
  [171] = {.index = 440, .length = 3},
  [172] = {.index = 443, .length = 3},
  [173] = {.index = 446, .length = 5},
  [174] = {.index = 451, .length = 4},
  [175] = {.index = 455, .length = 4},
  [176] = {.index = 459, .length = 2},
  [177] = {.index = 461, .length = 1},
  [178] = {.index = 462, .length = 2},
  [179] = {.index = 464, .length = 6},
  [180] = {.index = 470, .length = 3},
  [181] = {.index = 473, .length = 4},
  [182] = {.index = 477, .length = 4},
  [183] = {.index = 481, .length = 4},
  [184] = {.index = 485, .length = 4},
  [185] = {.index = 489, .length = 4},
  [186] = {.index = 493, .length = 5},
  [187] = {.index = 498, .length = 5},
  [188] = {.index = 503, .length = 1},
  [189] = {.index = 504, .length = 3},
  [190] = {.index = 507, .length = 2},
  [191] = {.index = 509, .length = 1},
  [192] = {.index = 510, .length = 2},
  [193] = {.index = 512, .length = 2},
  [194] = {.index = 514, .length = 2},
  [195] = {.index = 516, .length = 1},
  [196] = {.index = 517, .length = 3},
  [197] = {.index = 520, .length = 3},
  [198] = {.index = 523, .length = 3},
  [199] = {.index = 526, .length = 5},
  [200] = {.index = 531, .length = 5},
  [201] = {.index = 536, .length = 5},
  [202] = {.index = 541, .length = 3},
  [203] = {.index = 544, .length = 3},
  [204] = {.index = 547, .length = 4},
  [205] = {.index = 551, .length = 4},
  [206] = {.index = 555, .length = 6},
  [207] = {.index = 561, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [18] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [23] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [29] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [32] =
    {field_arguments, 2},
    {field_type, 1},
  [34] =
    {field_dimensions, 2},
    {field_type, 1},
  [36] =
    {field_body, 2},
    {field_name, 1},
  [38] =
    {field_body, 2},
    {field_condition, 1},
  [40] =
    {field_body, 2},
  [41] =
    {field_body, 1},
  [42] =
    {field_body, 2},
    {field_resources, 1},
  [44] =
    {field_condition, 1},
    {field_consequence, 2},
  [46] =
    {field_arguments, 2},
    {field_name, 1},
  [48] =
    {field_field, 2},
    {field_object, 0},
  [50] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [53] =
    {field_body, 2},
    {field_parameters, 0},
  [55] =
    {field_left, 0},
    {field_pattern, 2},
  [57] =
    {field_left, 0},
    {field_right, 2},
  [59] =
    {field_template_argument, 2},
    {field_template_processor, 0},
  [61] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [64] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [69] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [75] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [80] =
    {field_dimensions, 1},
    {field_name, 0},
  [82] =
    {field_name, 0},
    {field_parameters, 1},
  [84] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [86] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [88] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [91] =
    {field_type, 1},
    {field_value, 3},
  [93] =
    {field_type, 1},
  [94] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [96] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [99] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [102] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [105] =
    {field_arguments, 3},
    {field_type, 2},
  [107] =
    {field_dimensions, 3},
    {field_type, 2},
  [109] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [112] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [115] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [118] =
    {field_body, 3},
    {field_name, 1},
    {field_permits, 2},
  [121] =
    {field_name, 2},
    {field_scope, 0},
  [123] =
    {field_body, 3},
    {field_name, 2},
  [125] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [128] =
    {field_body, 3},
    {field_name, 1},
  [130] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [133] =
    {field_left, 0},
    {field_pattern, 3},
  [135] =
    {field_left, 0},
    {field_right, 3},
  [137] =
    {field_left, 0},
    {field_name, 3},
    {field_right, 2},
  [140] =
    {field_array, 0},
    {field_index, 2},
  [142] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [144] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [149] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [152] =
    {field_declarator, 1},
  [153] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [155] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [158] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [161] =
    {field_arguments, 4},
    {field_type, 3},
    {field_type_arguments, 1},
  [164] =
    {field_dimensions, 3},
    {field_type, 2},
    {field_value, 4},
  [167] =
    {field_dimensions, 3},
    {field_dimensions, 4},
    {field_type, 2},
  [170] =
    {field_arguments, 4},
    {field_type, 3},
    {field_type_arguments, 2},
  [173] =
    {field_body, 1},
    {field_name, 0},
  [175] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [179] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [183] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [187] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
    {field_type_parameters, 2},
  [191] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [195] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
    {field_superclass, 2},
  [199] =
    {field_body, 4},
    {field_interfaces, 2},
    {field_name, 1},
    {field_permits, 3},
  [203] =
    {field_body, 1},
    {field_condition, 3},
  [205] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [208] =
    {field_init, 1},
  [209] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [211] =
    {field_modifiers, 0},
  [212] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [216] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_parameters, 2},
  [220] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [223] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
  [226] =
    {field_field, 4},
    {field_object, 0},
  [228] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [232] =
    {field_left, 0},
    {field_name, 4},
    {field_right, 3},
  [235] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [238] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [241] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [244] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [247] =
    {field_body, 4},
    {field_name, 2},
    {field_permits, 3},
  [250] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [253] =
    {field_body, 4},
    {field_name, 2},
  [255] =
    {field_body, 4},
    {field_name, 3},
  [257] =
    {field_arguments, 5},
    {field_type, 4},
    {field_type_arguments, 2},
  [260] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [264] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [267] =
    {field_body, 2},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [271] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [276] =
    {field_body, 5},
    {field_name, 1},
    {field_permits, 4},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [281] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 1},
    {field_permits, 4},
    {field_type_parameters, 2},
  [286] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 1},
    {field_permits, 4},
    {field_superclass, 2},
  [291] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [295] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [297] =
    {field_body, 5},
  [298] =
    {field_body, 5},
    {field_init, 2},
  [300] =
    {field_key, 0},
    {field_value, 2},
  [302] =
    {field_module, 1},
  [303] =
    {field_modifiers, 0, .inherited = true},
    {field_modifiers, 1, .inherited = true},
  [305] =
    {field_package, 1},
  [306] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [309] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [314] =
    {field_body, 5},
    {field_name, 1},
    {field_permits, 4},
    {field_type_parameters, 2},
  [318] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [321] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [325] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [329] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
    {field_type_parameters, 3},
  [333] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [337] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
    {field_superclass, 3},
  [341] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 2},
    {field_permits, 4},
  [345] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [349] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_parameters, 3},
  [353] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [356] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
  [359] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [363] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 1},
    {field_permits, 5},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [369] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [373] =
    {field_body, 4},
  [374] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [376] =
    {field_body, 6},
    {field_update, 4},
  [378] =
    {field_update, 1},
  [379] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [381] =
    {field_body, 6},
    {field_condition, 3},
  [383] =
    {field_body, 6},
    {field_init, 2},
  [385] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [388] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [391] =
    {field_modifiers, 1, .inherited = true},
    {field_module, 2},
  [393] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [396] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [400] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [405] =
    {field_body, 6},
    {field_name, 2},
    {field_permits, 5},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [410] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 2},
    {field_permits, 5},
    {field_type_parameters, 3},
  [415] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 2},
    {field_permits, 5},
    {field_superclass, 3},
  [420] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [425] =
    {field_body, 6},
    {field_name, 2},
    {field_permits, 5},
    {field_type_parameters, 3},
  [429] =
    {field_arguments, 1},
    {field_constructor, 0},
  [431] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [434] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [437] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [440] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [443] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [446] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [451] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [455] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [459] =
    {field_modules, 3},
    {field_package, 1},
  [461] =
    {field_provided, 1},
  [462] =
    {field_name, 1},
    {field_type, 0},
  [464] =
    {field_body, 7},
    {field_interfaces, 5},
    {field_name, 2},
    {field_permits, 6},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [470] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [473] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [477] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [481] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [485] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [489] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [493] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [498] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [503] =
    {field_modules, 1},
  [504] =
    {field_modules, 3},
    {field_modules, 4, .inherited = true},
    {field_package, 1},
  [507] =
    {field_modules, 0, .inherited = true},
    {field_modules, 1, .inherited = true},
  [509] =
    {field_provider, 1},
  [510] =
    {field_provided, 1},
    {field_provider, 4, .inherited = true},
  [512] =
    {field_provider, 0, .inherited = true},
    {field_provider, 1, .inherited = true},
  [514] =
    {field_name, 2},
    {field_type, 1},
  [516] =
    {field_value, 1},
  [517] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [520] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [523] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [526] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [531] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [536] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [541] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [544] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [547] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [551] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [555] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [561] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [15] = {
    [1] = alias_sym_type_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [19] = {
    [1] = alias_sym_type_identifier,
  },
  [30] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [42] = {
    [2] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
  },
  [52] = {
    [2] = alias_sym_type_identifier,
  },
  [55] = {
    [2] = alias_sym_type_identifier,
  },
  [56] = {
    [2] = alias_sym_type_identifier,
  },
  [66] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [77] = {
    [3] = alias_sym_type_identifier,
  },
  [80] = {
    [3] = alias_sym_type_identifier,
  },
  [83] = {
    [2] = alias_sym_type_identifier,
  },
  [84] = {
    [2] = alias_sym_type_identifier,
  },
  [86] = {
    [3] = alias_sym_type_identifier,
  },
  [116] = {
    [4] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 8,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 9,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 15,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 38,
  [40] = 40,
  [41] = 30,
  [42] = 42,
  [43] = 37,
  [44] = 36,
  [45] = 35,
  [46] = 34,
  [47] = 33,
  [48] = 32,
  [49] = 31,
  [50] = 29,
  [51] = 28,
  [52] = 26,
  [53] = 42,
  [54] = 40,
  [55] = 24,
  [56] = 23,
  [57] = 21,
  [58] = 16,
  [59] = 20,
  [60] = 17,
  [61] = 61,
  [62] = 61,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 63,
  [69] = 18,
  [70] = 19,
  [71] = 27,
  [72] = 67,
  [73] = 38,
  [74] = 40,
  [75] = 30,
  [76] = 42,
  [77] = 37,
  [78] = 36,
  [79] = 35,
  [80] = 34,
  [81] = 33,
  [82] = 32,
  [83] = 31,
  [84] = 29,
  [85] = 28,
  [86] = 26,
  [87] = 15,
  [88] = 24,
  [89] = 23,
  [90] = 21,
  [91] = 20,
  [92] = 17,
  [93] = 61,
  [94] = 16,
  [95] = 64,
  [96] = 65,
  [97] = 66,
  [98] = 67,
  [99] = 63,
  [100] = 18,
  [101] = 19,
  [102] = 27,
  [103] = 64,
  [104] = 65,
  [105] = 66,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 114,
  [117] = 117,
  [118] = 117,
  [119] = 117,
  [120] = 120,
  [121] = 120,
  [122] = 122,
  [123] = 122,
  [124] = 122,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 129,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 135,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 142,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 149,
  [151] = 151,
  [152] = 149,
  [153] = 151,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 155,
  [163] = 145,
  [164] = 164,
  [165] = 156,
  [166] = 154,
  [167] = 146,
  [168] = 168,
  [169] = 168,
  [170] = 164,
  [171] = 146,
  [172] = 156,
  [173] = 168,
  [174] = 157,
  [175] = 145,
  [176] = 176,
  [177] = 161,
  [178] = 154,
  [179] = 164,
  [180] = 161,
  [181] = 181,
  [182] = 160,
  [183] = 155,
  [184] = 157,
  [185] = 185,
  [186] = 148,
  [187] = 160,
  [188] = 176,
  [189] = 176,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 197,
  [200] = 200,
  [201] = 201,
  [202] = 193,
  [203] = 203,
  [204] = 192,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 191,
  [217] = 207,
  [218] = 212,
  [219] = 213,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 207,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 211,
  [233] = 208,
  [234] = 200,
  [235] = 214,
  [236] = 215,
  [237] = 220,
  [238] = 221,
  [239] = 222,
  [240] = 224,
  [241] = 230,
  [242] = 229,
  [243] = 226,
  [244] = 197,
  [245] = 223,
  [246] = 198,
  [247] = 231,
  [248] = 248,
  [249] = 110,
  [250] = 109,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 393,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 400,
  [402] = 402,
  [403] = 400,
  [404] = 404,
  [405] = 404,
  [406] = 132,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 413,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 417,
  [420] = 420,
  [421] = 420,
  [422] = 417,
  [423] = 420,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 412,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 439,
  [442] = 442,
  [443] = 443,
  [444] = 439,
  [445] = 430,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 440,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 285,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 356,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 429,
  [498] = 498,
  [499] = 499,
  [500] = 428,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 459,
  [507] = 507,
  [508] = 454,
  [509] = 509,
  [510] = 460,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 435,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 481,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 436,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 434,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 431,
  [584] = 493,
  [585] = 432,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 485,
  [626] = 505,
  [627] = 627,
  [628] = 501,
  [629] = 629,
  [630] = 620,
  [631] = 467,
  [632] = 627,
  [633] = 614,
  [634] = 622,
  [635] = 635,
  [636] = 621,
  [637] = 618,
  [638] = 619,
  [639] = 615,
  [640] = 640,
  [641] = 616,
  [642] = 617,
  [643] = 456,
  [644] = 644,
  [645] = 612,
  [646] = 457,
  [647] = 640,
  [648] = 624,
  [649] = 623,
  [650] = 650,
  [651] = 613,
  [652] = 652,
  [653] = 653,
  [654] = 653,
  [655] = 655,
  [656] = 120,
  [657] = 653,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 541,
  [663] = 521,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 661,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 538,
  [673] = 673,
  [674] = 660,
  [675] = 665,
  [676] = 669,
  [677] = 658,
  [678] = 659,
  [679] = 665,
  [680] = 670,
  [681] = 660,
  [682] = 671,
  [683] = 550,
  [684] = 669,
  [685] = 667,
  [686] = 667,
  [687] = 671,
  [688] = 670,
  [689] = 659,
  [690] = 658,
  [691] = 691,
  [692] = 577,
  [693] = 693,
  [694] = 694,
  [695] = 471,
  [696] = 696,
  [697] = 697,
  [698] = 468,
  [699] = 466,
  [700] = 472,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 452,
  [706] = 706,
  [707] = 462,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 711,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 477,
  [723] = 718,
  [724] = 724,
  [725] = 725,
  [726] = 725,
  [727] = 727,
  [728] = 728,
  [729] = 458,
  [730] = 727,
  [731] = 728,
  [732] = 713,
  [733] = 714,
  [734] = 734,
  [735] = 735,
  [736] = 727,
  [737] = 476,
  [738] = 735,
  [739] = 739,
  [740] = 463,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 744,
  [747] = 711,
  [748] = 748,
  [749] = 691,
  [750] = 713,
  [751] = 751,
  [752] = 735,
  [753] = 714,
  [754] = 718,
  [755] = 755,
  [756] = 756,
  [757] = 474,
  [758] = 475,
  [759] = 465,
  [760] = 760,
  [761] = 761,
  [762] = 485,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 132,
  [768] = 768,
  [769] = 769,
  [770] = 768,
  [771] = 771,
  [772] = 768,
  [773] = 773,
  [774] = 467,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 776,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 775,
  [787] = 787,
  [788] = 788,
  [789] = 777,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 541,
  [797] = 521,
  [798] = 798,
  [799] = 799,
  [800] = 795,
  [801] = 801,
  [802] = 802,
  [803] = 795,
  [804] = 538,
  [805] = 805,
  [806] = 806,
  [807] = 550,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 810,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 462,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 433,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 831,
  [833] = 438,
  [834] = 834,
  [835] = 831,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 465,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 842,
  [845] = 841,
  [846] = 846,
  [847] = 847,
  [848] = 843,
  [849] = 846,
  [850] = 850,
  [851] = 851,
  [852] = 442,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 448,
  [858] = 858,
  [859] = 859,
  [860] = 858,
  [861] = 861,
  [862] = 855,
  [863] = 863,
  [864] = 864,
  [865] = 447,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 868,
  [871] = 449,
  [872] = 448,
  [873] = 866,
  [874] = 874,
  [875] = 869,
  [876] = 451,
  [877] = 450,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 881,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 483,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 905,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 905,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 943,
  [962] = 962,
  [963] = 806,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 959,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 945,
  [977] = 954,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 960,
  [982] = 948,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 949,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 998,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1014,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1013,
  [1022] = 1022,
  [1023] = 1014,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1028,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1013,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 965,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1068,
  [1087] = 1071,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1068,
  [1095] = 1071,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1089,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1083,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1082,
  [1106] = 1076,
  [1107] = 1080,
  [1108] = 1078,
  [1109] = 1109,
  [1110] = 1092,
  [1111] = 1111,
  [1112] = 1089,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1083,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1092,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1126,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1093,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1078,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1133,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1134,
  [1167] = 1035,
  [1168] = 1082,
  [1169] = 1126,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1134,
  [1173] = 1080,
  [1174] = 1157,
  [1175] = 1175,
  [1176] = 1157,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1190,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 393,
  [1254] = 1254,
  [1255] = 1255,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1188,
  [1260] = 1260,
  [1261] = 1182,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1265,
  [1266] = 1266,
  [1267] = 1182,
  [1268] = 1188,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1320,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1306,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1337,
  [1338] = 1338,
  [1339] = 1339,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1343,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1346,
  [1347] = 1324,
  [1348] = 1330,
  [1349] = 1349,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1326,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1361,
  [1362] = 1362,
  [1363] = 1363,
  [1364] = 1364,
  [1365] = 1365,
  [1366] = 1366,
  [1367] = 1367,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 1330,
  [1372] = 1360,
  [1373] = 1369,
  [1374] = 1310,
  [1375] = 1375,
  [1376] = 1369,
  [1377] = 1309,
  [1378] = 1378,
  [1379] = 1308,
  [1380] = 1306,
};

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'a'
    ? (c < '?'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '?' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1488
          ? (c < 886
            ? (c < 216
              ? (c < 181
                ? (c < 'a'
                  ? (c >= '$' && c <= '_')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 192
                  ? c == 186
                  : c <= 214)))
              : (c <= 246 || (c < 748
                ? (c < 710
                  ? (c >= 248 && c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 880
                  ? c == 750
                  : c <= 884)))))
            : (c <= 887 || (c < 931
              ? (c < 904
                ? (c < 895
                  ? (c >= 890 && c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 910
                  ? c == 908
                  : c <= 929)))
              : (c <= 1013 || (c < 1329
                ? (c < 1162
                  ? (c >= 1015 && c <= 1153)
                  : c <= 1327)
                : (c <= 1366 || (c < 1376
                  ? c == 1369
                  : c <= 1416)))))))
          : (c <= 1514 || (c < 1994
            ? (c < 1774
              ? (c < 1649
                ? (c < 1568
                  ? (c >= 1519 && c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1765
                  ? c == 1749
                  : c <= 1766)))
              : (c <= 1775 || (c < 1810
                ? (c < 1791
                  ? (c >= 1786 && c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1969
                  ? (c >= 1869 && c <= 1957)
                  : c <= 1969)))))
            : (c <= 2026 || (c < 2112
              ? (c < 2074
                ? (c < 2042
                  ? (c >= 2036 && c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2088
                  ? c == 2084
                  : c <= 2088)))
              : (c <= 2136 || (c < 2185
                ? (c < 2160
                  ? (c >= 2144 && c <= 2154)
                  : c <= 2183)
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3200
                ? (c < 3165
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3293
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6103
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5984
                ? (c < 5919
                  ? (c >= 5888 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43261
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11492 || (c < 12704
          ? (c < 11720
            ? (c < 11631
              ? (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))
              : (c <= 11631 || (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))))
            : (c <= 11726 || (c < 12353
              ? (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66928
          ? (c < 66208
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : c <= 66204)))))
            : (c <= 66256 || (c < 66504
              ? (c < 66384
                ? (c < 66349
                  ? (c >= 66304 && c <= 66335)
                  : (c <= 66368 || (c >= 66370 && c <= 66377)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66776
                ? (c < 66736
                  ? (c >= 66560 && c <= 66717)
                  : c <= 66771)
                : (c <= 66811 || (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : c <= 66915)))))))
          : (c <= 66938 || (c < 67506
            ? (c < 67003
              ? (c < 66967
                ? (c < 66956
                  ? (c >= 66940 && c <= 66954)
                  : (c <= 66962 || (c >= 66964 && c <= 66965)))
                : (c <= 66977 || (c < 66995
                  ? (c >= 66979 && c <= 66993)
                  : c <= 67001)))
              : (c <= 67004 || (c < 67424
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : c <= 67413)
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= '$' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 6320
    ? (c < 2974
      ? (c < 2308
        ? (c < 1369
          ? (c < 748
            ? (c < 181
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= '_' || (c < 162
                  ? (c >= 'a' && c <= 'z')
                  : (c <= 162 || c == 170))))
              : (c <= 181 || (c < 248
                ? (c < 192
                  ? c == 186
                  : (c <= 214 || (c >= 216 && c <= 246)))
                : (c <= 705 || (c < 736
                  ? (c >= 710 && c <= 721)
                  : c <= 740)))))
            : (c <= 748 || (c < 904
              ? (c < 890
                ? (c < 880
                  ? c == 750
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 902
                  ? c == 895
                  : c <= 902)))
              : (c <= 906 || (c < 1015
                ? (c < 910
                  ? c == 908
                  : (c <= 929 || (c >= 931 && c <= 1013)))
                : (c <= 1153 || (c < 1329
                  ? (c >= 1162 && c <= 1327)
                  : c <= 1366)))))))
          : (c <= 1369 || (c < 1869
            ? (c < 1649
              ? (c < 1568
                ? (c < 1488
                  ? (c >= 1376 && c <= 1416)
                  : (c <= 1514 || (c >= 1519 && c <= 1522)))
                : (c <= 1610 || (c < 1646
                  ? (c >= 1632 && c <= 1641)
                  : c <= 1647)))
              : (c <= 1747 || (c < 1791
                ? (c < 1765
                  ? c == 1749
                  : (c <= 1766 || (c >= 1774 && c <= 1788)))
                : (c <= 1791 || (c < 1810
                  ? c == 1808
                  : c <= 1839)))))
            : (c <= 1957 || (c < 2084
              ? (c < 2042
                ? (c < 1984
                  ? c == 1969
                  : (c <= 2026 || (c >= 2036 && c <= 2037)))
                : (c <= 2042 || (c < 2074
                  ? (c >= 2048 && c <= 2069)
                  : c <= 2074)))
              : (c <= 2084 || (c < 2160
                ? (c < 2112
                  ? c == 2088
                  : (c <= 2136 || (c >= 2144 && c <= 2154)))
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2406
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2415 || (c < 2437
                  ? (c >= 2417 && c <= 2432)
                  : (c <= 2444 || (c >= 2447 && c <= 2448)))))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2534 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2654
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))
                : (c <= 2654 || (c < 2674
                  ? (c >= 2662 && c <= 2671)
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2858
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2821
                ? (c < 2790
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2799 || c == 2809))
                : (c <= 2828 || (c < 2835
                  ? (c >= 2831 && c <= 2832)
                  : c <= 2856)))))
            : (c <= 2864 || (c < 2929
              ? (c < 2908
                ? (c < 2869
                  ? (c >= 2866 && c <= 2867)
                  : (c <= 2873 || c == 2877))
                : (c <= 2909 || (c < 2918
                  ? (c >= 2911 && c <= 2913)
                  : c <= 2927)))
              : (c <= 2929 || (c < 2962
                ? (c < 2949
                  ? c == 2947
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))
                : (c <= 2965 || (c < 2972
                  ? (c >= 2969 && c <= 2970)
                  : c <= 2972)))))))))))
      : (c <= 2975 || (c < 3840
        ? (c < 3389
          ? (c < 3200
            ? (c < 3090
              ? (c < 3024
                ? (c < 2984
                  ? (c >= 2979 && c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))
                : (c <= 3024 || (c < 3077
                  ? (c >= 3046 && c <= 3055)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3165
                ? (c < 3133
                  ? (c >= 3114 && c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))
                : (c <= 3165 || (c < 3174
                  ? (c >= 3168 && c <= 3169)
                  : c <= 3183)))))
            : (c <= 3200 || (c < 3293
              ? (c < 3242
                ? (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))
                : (c <= 3251 || (c < 3261
                  ? (c >= 3253 && c <= 3257)
                  : c <= 3261)))
              : (c <= 3294 || (c < 3332
                ? (c < 3302
                  ? (c >= 3296 && c <= 3297)
                  : (c <= 3311 || (c >= 3313 && c <= 3314)))
                : (c <= 3340 || (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)))))))
          : (c <= 3389 || (c < 3648
            ? (c < 3482
              ? (c < 3430
                ? (c < 3412
                  ? c == 3406
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))
                : (c <= 3439 || (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : c <= 3478)))
              : (c <= 3505 || (c < 3558
                ? (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : (c <= 3517 || (c >= 3520 && c <= 3526)))
                : (c <= 3567 || (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : c <= 3635)))))
            : (c <= 3654 || (c < 3751
              ? (c < 3718
                ? (c < 3713
                  ? (c >= 3664 && c <= 3673)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3749
                  ? (c >= 3724 && c <= 3747)
                  : c <= 3749)))
              : (c <= 3760 || (c < 3782
                ? (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))
                : (c <= 3782 || (c < 3804
                  ? (c >= 3792 && c <= 3801)
                  : c <= 3807)))))))))
        : (c <= 3840 || (c < 4800
          ? (c < 4256
            ? (c < 4186
              ? (c < 3976
                ? (c < 3904
                  ? (c >= 3872 && c <= 3881)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : (c <= 4169 || (c >= 4176 && c <= 4181)))))
              : (c <= 4189 || (c < 4213
                ? (c < 4197
                  ? c == 4193
                  : (c <= 4198 || (c >= 4206 && c <= 4208)))
                : (c <= 4225 || (c < 4240
                  ? c == 4238
                  : c <= 4249)))))
            : (c <= 4293 || (c < 4696
              ? (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))
              : (c <= 4696 || (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))))))
          : (c <= 4800 || (c < 5888
            ? (c < 5024
              ? (c < 4882
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : (c <= 4822 || (c >= 4824 && c <= 4880)))
                : (c <= 4885 || (c < 4992
                  ? (c >= 4888 && c <= 4954)
                  : c <= 5007)))
              : (c <= 5109 || (c < 5761
                ? (c < 5121
                  ? (c >= 5112 && c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))
                : (c <= 5786 || (c < 5873
                  ? (c >= 5792 && c <= 5866)
                  : c <= 5880)))))
            : (c <= 5905 || (c < 6108
              ? (c < 5998
                ? (c < 5952
                  ? (c >= 5919 && c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))
                : (c <= 6000 || (c < 6103
                  ? (c >= 6016 && c <= 6067)
                  : c <= 6103)))
              : (c <= 6108 || (c < 6272
                ? (c < 6160
                  ? (c >= 6112 && c <= 6121)
                  : (c <= 6169 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))))))))))))
    : (c <= 6389 || (c < 43138
      ? (c < 8488
        ? (c < 7960
          ? (c < 7043
            ? (c < 6688
              ? (c < 6528
                ? (c < 6470
                  ? (c >= 6400 && c <= 6430)
                  : (c <= 6509 || (c >= 6512 && c <= 6516)))
                : (c <= 6571 || (c < 6608
                  ? (c >= 6576 && c <= 6601)
                  : (c <= 6617 || (c >= 6656 && c <= 6678)))))
              : (c <= 6740 || (c < 6917
                ? (c < 6800
                  ? (c >= 6784 && c <= 6793)
                  : (c <= 6809 || c == 6823))
                : (c <= 6963 || (c < 6992
                  ? (c >= 6981 && c <= 6988)
                  : c <= 7001)))))
            : (c <= 7072 || (c < 7357
              ? (c < 7245
                ? (c < 7168
                  ? (c >= 7086 && c <= 7141)
                  : (c <= 7203 || (c >= 7232 && c <= 7241)))
                : (c <= 7293 || (c < 7312
                  ? (c >= 7296 && c <= 7304)
                  : c <= 7354)))
              : (c <= 7359 || (c < 7418
                ? (c < 7406
                  ? (c >= 7401 && c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7680
                  ? (c >= 7424 && c <= 7615)
                  : c <= 7957)))))))
          : (c <= 7965 || (c < 8150
            ? (c < 8031
              ? (c < 8025
                ? (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))
              : (c <= 8061 || (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))))
            : (c <= 8155 || (c < 8450
              ? (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))
              : (c <= 8450 || (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))))))))
        : (c <= 8488 || (c < 12445
          ? (c < 11648
            ? (c < 11499
              ? (c < 8517
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : (c <= 8505 || (c >= 8508 && c <= 8511)))
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : (c <= 8580 || (c >= 11264 && c <= 11492)))))
              : (c <= 11502 || (c < 11565
                ? (c < 11520
                  ? (c >= 11506 && c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11631
                  ? (c >= 11568 && c <= 11623)
                  : c <= 11631)))))
            : (c <= 11670 || (c < 11728
              ? (c < 11704
                ? (c < 11688
                  ? (c >= 11680 && c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11720
                  ? (c >= 11712 && c <= 11718)
                  : c <= 11726)))
              : (c <= 11734 || (c < 12337
                ? (c < 11823
                  ? (c >= 11736 && c <= 11742)
                  : (c <= 11823 || (c >= 12293 && c <= 12294)))
                : (c <= 12341 || (c < 12353
                  ? (c >= 12347 && c <= 12348)
                  : c <= 12438)))))))
          : (c <= 12447 || (c < 42560
            ? (c < 13312
              ? (c < 12593
                ? (c < 12540
                  ? (c >= 12449 && c <= 12538)
                  : (c <= 12543 || (c >= 12549 && c <= 12591)))
                : (c <= 12686 || (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : c <= 12799)))
              : (c <= 13312 || (c < 42192
                ? (c < 19968
                  ? c == 19903
                  : (c <= 19968 || (c >= 40959 && c <= 42124)))
                : (c <= 42237 || (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : c <= 42539)))))
            : (c <= 42606 || (c < 42963
              ? (c < 42786
                ? (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : (c <= 42725 || (c >= 42775 && c <= 42783)))
                : (c <= 42888 || (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : c <= 42961)))
              : (c <= 42963 || (c < 43015
                ? (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)))))))))))
      : (c <= 43187 || (c < 65142
        ? (c < 43793
          ? (c < 43600
            ? (c < 43396
              ? (c < 43261
                ? (c < 43250
                  ? (c >= 43216 && c <= 43225)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43312
                  ? (c >= 43264 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))))
              : (c <= 43442 || (c < 43520
                ? (c < 43488
                  ? (c >= 43471 && c <= 43481)
                  : (c <= 43492 || (c >= 43494 && c <= 43518)))
                : (c <= 43560 || (c < 43588
                  ? (c >= 43584 && c <= 43586)
                  : c <= 43595)))))
            : (c <= 43609 || (c < 43712
              ? (c < 43697
                ? (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))
                : (c <= 43697 || (c < 43705
                  ? (c >= 43701 && c <= 43702)
                  : c <= 43709)))
              : (c <= 43712 || (c < 43762
                ? (c < 43739
                  ? c == 43714
                  : (c <= 43741 || (c >= 43744 && c <= 43754)))
                : (c <= 43764 || (c < 43785
                  ? (c >= 43777 && c <= 43782)
                  : c <= 43790)))))))
          : (c <= 43798 || (c < 64275
            ? (c < 44032
              ? (c < 43868
                ? (c < 43816
                  ? (c >= 43808 && c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))
                : (c <= 43881 || (c < 44016
                  ? (c >= 43888 && c <= 44002)
                  : c <= 44025)))
              : (c <= 44032 || (c < 63744
                ? (c < 55216
                  ? c == 55203
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64256
                  ? (c >= 64112 && c <= 64217)
                  : c <= 64262)))))
            : (c <= 64279 || (c < 64323
              ? (c < 64312
                ? (c < 64287
                  ? c == 64285
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64320
                  ? c == 64318
                  : c <= 64321)))
              : (c <= 64324 || (c < 64914
                ? (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))
                : (c <= 64967 || (c < 65136
                  ? (c >= 65008 && c <= 65019)
                  : c <= 65140)))))))))
        : (c <= 65276 || (c < 66816
          ? (c < 65664
            ? (c < 65498
              ? (c < 65382
                ? (c < 65313
                  ? (c >= 65296 && c <= 65305)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))
                : (c <= 65470 || (c < 65482
                  ? (c >= 65474 && c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))))
              : (c <= 65500 || (c < 65596
                ? (c < 65549
                  ? (c >= 65536 && c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))
                : (c <= 65597 || (c < 65616
                  ? (c >= 65599 && c <= 65613)
                  : c <= 65629)))))
            : (c <= 65786 || (c < 66432
              ? (c < 66349
                ? (c < 66208
                  ? (c >= 66176 && c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))
                : (c <= 66368 || (c < 66384
                  ? (c >= 66370 && c <= 66377)
                  : c <= 66421)))
              : (c <= 66461 || (c < 66720
                ? (c < 66504
                  ? (c >= 66464 && c <= 66499)
                  : (c <= 66511 || (c >= 66560 && c <= 66717)))
                : (c <= 66729 || (c < 66776
                  ? (c >= 66736 && c <= 66771)
                  : c <= 66811)))))))
          : (c <= 66855 || (c < 67463
            ? (c < 66979
              ? (c < 66956
                ? (c < 66928
                  ? (c >= 66864 && c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))
                : (c <= 66962 || (c < 66967
                  ? (c >= 66964 && c <= 66965)
                  : c <= 66977)))
              : (c <= 66993 || (c < 67392
                ? (c < 67003
                  ? (c >= 66995 && c <= 67001)
                  : (c <= 67004 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67456
                  ? (c >= 67424 && c <= 67431)
                  : c <= 67461)))))
            : (c <= 67504 || (c < 67647
              ? (c < 67594
                ? (c < 67584
                  ? (c >= 67506 && c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67644
                  ? (c >= 67639 && c <= 67640)
                  : c <= 67644)))
              : (c <= 67669 || (c < 67828
                ? (c < 67712
                  ? (c >= 67680 && c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (eof) ADVANCE(69);
      if (lookahead == '!') ADVANCE(180);
      if (lookahead == '"') ADVANCE(102);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '+') ADVANCE(156);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '.') ADVANCE(188);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(71);
      if (lookahead == ':') ADVANCE(179);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(147);
      if (lookahead == '=') ADVANCE(131);
      if (lookahead == '>') ADVANCE(144);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '\\') ADVANCE(43);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '^') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(200);
      if (lookahead == '{') ADVANCE(191);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(119);
      if (lookahead == '~') ADVANCE(181);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(73);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(201);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(180);
      if (lookahead == '"') ADVANCE(102);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '+') ADVANCE(156);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '.') ADVANCE(188);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(71);
      if (lookahead == ':') ADVANCE(179);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(147);
      if (lookahead == '=') ADVANCE(131);
      if (lookahead == '>') ADVANCE(144);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '^') ADVANCE(167);
      if (lookahead == '{') ADVANCE(191);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(119);
      if (lookahead == '~') ADVANCE(181);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(73);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(201);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(180);
      if (lookahead == '"') ADVANCE(102);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '+') ADVANCE(156);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '.') ADVANCE(189);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(71);
      if (lookahead == ':') ADVANCE(19);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(147);
      if (lookahead == '=') ADVANCE(131);
      if (lookahead == '>') ADVANCE(144);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '^') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(200);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(119);
      if (lookahead == '~') ADVANCE(181);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(73);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(201);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '%') ADVANCE(168);
      if (lookahead == '&') ADVANCE(128);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead == '+') ADVANCE(155);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == ':') ADVANCE(179);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(131);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == 'n') ADVANCE(200);
      if (lookahead == '|') ADVANCE(165);
      if (lookahead == '}') ADVANCE(119);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(201);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '%') ADVANCE(168);
      if (lookahead == '&') ADVANCE(128);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead == '+') ADVANCE(155);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == ':') ADVANCE(179);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == '{') ADVANCE(191);
      if (lookahead == '|') ADVANCE(165);
      if (lookahead == '}') ADVANCE(119);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(201);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(103);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(116);
      if (lookahead == '/') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(43);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(114);
      if (lookahead != 0) ADVANCE(115);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(117);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(101);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead == '\\') ADVANCE(44);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(108);
      if (lookahead != 0) ADVANCE(109);
      END_STATE();
    case 9:
      if (lookahead == '&') ADVANCE(127);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == ':') ADVANCE(179);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(146);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '>') ADVANCE(143);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '{') ADVANCE(191);
      if (lookahead == '|') ADVANCE(163);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(201);
      END_STATE();
    case 10:
      if (lookahead == '\'') ADVANCE(100);
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(202);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(203);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '_') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(197);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '<') ADVANCE(146);
      if (lookahead == '@') ADVANCE(37);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(201);
      END_STATE();
    case 18:
      if (lookahead == '0') ADVANCE(99);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 19:
      if (lookahead == ':') ADVANCE(190);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 22:
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(10);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == '_') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      END_STATE();
    case 27:
      if (lookahead == '_') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(35);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(195);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 36:
      if (lookahead == 'f') ADVANCE(29);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(34);
      END_STATE();
    case 39:
      if (lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(33);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 43:
      if (lookahead == 'u') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(65);
      if (lookahead == '{') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(121);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(122);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(65);
      if (lookahead == '{') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(124);
      if (lookahead != 0) ADVANCE(122);
      END_STATE();
    case 45:
      if (lookahead == '{') ADVANCE(118);
      END_STATE();
    case 46:
      if (lookahead == '{') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 47:
      if (lookahead == '}') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 48:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(18);
      if (lookahead == '0') ADVANCE(99);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 49:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 50:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(85);
      END_STATE();
    case 51:
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(82);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(83);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(14);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 66:
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 67:
      if (eof) ADVANCE(69);
      if (lookahead == '!') ADVANCE(180);
      if (lookahead == '"') ADVANCE(102);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '+') ADVANCE(156);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '.') ADVANCE(188);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '0') ADVANCE(71);
      if (lookahead == ':') ADVANCE(179);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(147);
      if (lookahead == '=') ADVANCE(131);
      if (lookahead == '>') ADVANCE(144);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '^') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(200);
      if (lookahead == '{') ADVANCE(191);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(119);
      if (lookahead == '~') ADVANCE(181);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(67)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(73);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(201);
      END_STATE();
    case 68:
      if (eof) ADVANCE(69);
      if (lookahead == '!') ADVANCE(180);
      if (lookahead == '"') ADVANCE(102);
      if (lookahead == '%') ADVANCE(168);
      if (lookahead == '&') ADVANCE(128);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead == '+') ADVANCE(155);
      if (lookahead == ',') ADVANCE(177);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(189);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == '0') ADVANCE(71);
      if (lookahead == ':') ADVANCE(179);
      if (lookahead == ';') ADVANCE(192);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(145);
      if (lookahead == '?') ADVANCE(178);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(184);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead == '^') ADVANCE(166);
      if (lookahead == 'n') ADVANCE(200);
      if (lookahead == '{') ADVANCE(191);
      if (lookahead == '|') ADVANCE(165);
      if (lookahead == '}') ADVANCE(119);
      if (lookahead == '~') ADVANCE(181);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(68)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(73);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(201);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(50);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(70);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(52);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(16);
      if (lookahead == '_') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(14);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(82);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(70);
      if (lookahead == '_') ADVANCE(24);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(70);
      if (lookahead == '_') ADVANCE(56);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(72);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(70);
      if (lookahead == '_') ADVANCE(23);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(75);
      if (lookahead == '_') ADVANCE(57);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(75);
      if (lookahead == '_') ADVANCE(25);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(75);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(79);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(75);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(18);
      if (lookahead == '.') ADVANCE(98);
      if (lookahead == '0') ADVANCE(78);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(75);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(81);
      if (lookahead == '_') ADVANCE(51);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(81);
      if (lookahead == '_') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(83);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(84);
      if (lookahead == '_') ADVANCE(50);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(55);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(49);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(63);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(97);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(63);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(97);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(59);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(97);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(97);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(58);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(95);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(18);
      if (lookahead == '0') ADVANCE(91);
      if (lookahead == '_') ADVANCE(63);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(97);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(93);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(97);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(92);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(90);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(5);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '\n') ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '/') ADVANCE(104);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(109);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '*') ADVANCE(106);
      if (lookahead == '/') ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(107);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '*') ADVANCE(106);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '/') ADVANCE(105);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(108);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(109);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '\n') ADVANCE(115);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(202);
      if (lookahead != 0) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(115);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(13);
      if (lookahead != 0) ADVANCE(113);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '*') ADVANCE(112);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(13);
      if (lookahead != 0) ADVANCE(113);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead == '/') ADVANCE(111);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(115);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(115);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token2);
      if (lookahead == '"') ADVANCE(5);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead != 0) ADVANCE(117);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym__multiline_string_fragment_token2);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(117);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_BSLASH_LBRACE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(123);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(122);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(123);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(153);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(153);
      if (lookahead == '=') ADVANCE(136);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(149);
      if (lookahead == '>') ADVANCE(172);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(149);
      if (lookahead == '>') ADVANCE(173);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(171);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(182);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(182);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '=') ADVANCE(133);
      if (lookahead == '>') ADVANCE(176);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(183);
      if (lookahead == '>') ADVANCE(176);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(202);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(202);
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(137);
      if (lookahead == '|') ADVANCE(154);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(154);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(141);
      if (lookahead == '>') ADVANCE(175);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(174);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(190);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(15);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_non_DASHsealed);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(41);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(201);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(198);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(201);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(199);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(201);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'c') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(5);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'o') ADVANCE(12);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(14);
      if (lookahead == 's') ADVANCE(15);
      if (lookahead == 't') ADVANCE(16);
      if (lookahead == 'u') ADVANCE(17);
      if (lookahead == 'v') ADVANCE(18);
      if (lookahead == 'w') ADVANCE(19);
      if (lookahead == 'y') ADVANCE(20);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_underscore_pattern);
      END_STATE();
    case 2:
      if (lookahead == 'b') ADVANCE(21);
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(24);
      if (lookahead == 'y') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(26);
      if (lookahead == 'h') ADVANCE(27);
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'l') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(39);
      if (lookahead == 'm') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(43);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 12:
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'e') ADVANCE(49);
      if (lookahead == 'r') ADVANCE(50);
      if (lookahead == 'u') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 't') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(56);
      if (lookahead == 'w') ADVANCE(57);
      if (lookahead == 'y') ADVANCE(58);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(59);
      if (lookahead == 'o') ADVANCE(60);
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 18:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 19:
      if (lookahead == 'h') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 20:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(68);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(69);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(72);
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(74);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 30:
      if (lookahead == 'f') ADVANCE(77);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(80);
      END_STATE();
    case 34:
      if (lookahead == 'p') ADVANCE(81);
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(83);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 40:
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(88);
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 43:
      if (lookahead == 'd') ADVANCE(91);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 45:
      if (lookahead == 'w') ADVANCE(93);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(94);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 48:
      if (lookahead == 'c') ADVANCE(96);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(98);
      if (lookahead == 'o') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 'b') ADVANCE(100);
      END_STATE();
    case 52:
      if (lookahead == 'c') ADVANCE(101);
      if (lookahead == 'q') ADVANCE(102);
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(104);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 56:
      if (lookahead == 'p') ADVANCE(108);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(109);
      END_STATE();
    case 58:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(113);
      if (lookahead == 'u') ADVANCE(114);
      if (lookahead == 'y') ADVANCE(115);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(117);
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(119);
      if (lookahead == 'i') ADVANCE(120);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(125);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(126);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(129);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 75:
      if (lookahead == 's') ADVANCE(131);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(133);
      END_STATE();
    case 78:
      if (lookahead == 'b') ADVANCE(134);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 80:
      if (lookahead == 'm') ADVANCE(136);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 83:
      if (lookahead == 's') ADVANCE(139);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(142);
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 90:
      if (lookahead == 'g') ADVANCE(146);
      END_STATE();
    case 91:
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(148);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(149);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 96:
      if (lookahead == 'k') ADVANCE(151);
      END_STATE();
    case 97:
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 98:
      if (lookahead == 'v') ADVANCE(153);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(154);
      if (lookahead == 'v') ADVANCE(155);
      END_STATE();
    case 100:
      if (lookahead == 'l') ADVANCE(156);
      END_STATE();
    case 101:
      if (lookahead == 'o') ADVANCE(157);
      END_STATE();
    case 102:
      if (lookahead == 'u') ADVANCE(158);
      END_STATE();
    case 103:
      if (lookahead == 'u') ADVANCE(159);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(160);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(161);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 107:
      if (lookahead == 'i') ADVANCE(163);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 110:
      if (lookahead == 'c') ADVANCE(166);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(167);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(170);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 116:
      if (lookahead == 's') ADVANCE(171);
      END_STATE();
    case 117:
      if (lookahead == 'd') ADVANCE(172);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(173);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(174);
      END_STATE();
    case 120:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 121:
      if (lookahead == 'h') ADVANCE(176);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(177);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 124:
      if (lookahead == 'r') ADVANCE(179);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 126:
      if (lookahead == 'k') ADVANCE(181);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 129:
      if (lookahead == 'h') ADVANCE(182);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 131:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 132:
      if (lookahead == 'i') ADVANCE(184);
      END_STATE();
    case 133:
      if (lookahead == 'u') ADVANCE(185);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(186);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 137:
      if (lookahead == 'r') ADVANCE(187);
      END_STATE();
    case 138:
      if (lookahead == 'n') ADVANCE(188);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 140:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 141:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 143:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(194);
      END_STATE();
    case 145:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(196);
      END_STATE();
    case 148:
      if (lookahead == 'v') ADVANCE(197);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(199);
      END_STATE();
    case 152:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(201);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 155:
      if (lookahead == 'i') ADVANCE(203);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(204);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(205);
      END_STATE();
    case 158:
      if (lookahead == 'i') ADVANCE(206);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(207);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(209);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(210);
      END_STATE();
    case 163:
      if (lookahead == 'c') ADVANCE(211);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 165:
      if (lookahead == 'c') ADVANCE(213);
      END_STATE();
    case 166:
      if (lookahead == 'h') ADVANCE(214);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 168:
      if (lookahead == 'w') ADVANCE(215);
      END_STATE();
    case 169:
      if (lookahead == 's') ADVANCE(216);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(217);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 175:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 177:
      if (lookahead == 'd') ADVANCE(219);
      END_STATE();
    case 178:
      if (lookahead == 'a') ADVANCE(220);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 180:
      if (lookahead == 'a') ADVANCE(222);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 184:
      if (lookahead == 'n') ADVANCE(223);
      END_STATE();
    case 185:
      if (lookahead == 'l') ADVANCE(224);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(226);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(227);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(228);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 192:
      if (lookahead == 'm') ADVANCE(229);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(230);
      END_STATE();
    case 194:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 195:
      if (lookahead == 'f') ADVANCE(232);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(234);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 199:
      if (lookahead == 'g') ADVANCE(235);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 202:
      if (lookahead == 'c') ADVANCE(238);
      END_STATE();
    case 203:
      if (lookahead == 'd') ADVANCE(239);
      END_STATE();
    case 204:
      if (lookahead == 'c') ADVANCE(240);
      END_STATE();
    case 205:
      if (lookahead == 'd') ADVANCE(241);
      END_STATE();
    case 206:
      if (lookahead == 'r') ADVANCE(242);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(243);
      END_STATE();
    case 208:
      if (lookahead == 'd') ADVANCE(244);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 210:
      if (lookahead == 'c') ADVANCE(245);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(246);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 213:
      if (lookahead == 'h') ADVANCE(247);
      END_STATE();
    case 214:
      if (lookahead == 'r') ADVANCE(248);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(249);
      END_STATE();
    case 216:
      if (lookahead == 'i') ADVANCE(250);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(251);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 220:
      if (lookahead == 'c') ADVANCE(252);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 223:
      if (lookahead == 'u') ADVANCE(254);
      END_STATE();
    case 224:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 226:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 227:
      if (lookahead == 's') ADVANCE(257);
      END_STATE();
    case 228:
      if (lookahead == 'y') ADVANCE(258);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(259);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 231:
      if (lookahead == 'c') ADVANCE(260);
      END_STATE();
    case 232:
      if (lookahead == 'a') ADVANCE(261);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 235:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 236:
      if (lookahead == 's') ADVANCE(263);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 238:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(266);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_record);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_sealed);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 246:
      if (lookahead == 'f') ADVANCE(268);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 248:
      if (lookahead == 'o') ADVANCE(269);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 250:
      if (lookahead == 'e') ADVANCE(270);
      if (lookahead == 't') ADVANCE(271);
      END_STATE();
    case 251:
      if (lookahead == 'l') ADVANCE(272);
      END_STATE();
    case 252:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 259:
      if (lookahead == 'n') ADVANCE(275);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 261:
      if (lookahead == 'c') ADVANCE(277);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_permits);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 265:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 266:
      if (lookahead == 's') ADVANCE(279);
      END_STATE();
    case 267:
      if (lookahead == 's') ADVANCE(280);
      END_STATE();
    case 268:
      if (lookahead == 'p') ADVANCE(281);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 270:
      if (lookahead == 'n') ADVANCE(283);
      END_STATE();
    case 271:
      if (lookahead == 'i') ADVANCE(284);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 275:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 276:
      if (lookahead == 'o') ADVANCE(287);
      END_STATE();
    case 277:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 278:
      if (lookahead == 'd') ADVANCE(289);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 282:
      if (lookahead == 'i') ADVANCE(290);
      END_STATE();
    case 283:
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 284:
      if (lookahead == 'v') ADVANCE(292);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 286:
      if (lookahead == 's') ADVANCE(293);
      END_STATE();
    case 287:
      if (lookahead == 'f') ADVANCE(294);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 290:
      if (lookahead == 'z') ADVANCE(295);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(296);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 295:
      if (lookahead == 'e') ADVANCE(297);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 297:
      if (lookahead == 'd') ADVANCE(298);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 0},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 0},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 68},
  [108] = {.lex_state = 68},
  [109] = {.lex_state = 68},
  [110] = {.lex_state = 68},
  [111] = {.lex_state = 68},
  [112] = {.lex_state = 68},
  [113] = {.lex_state = 68},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 2},
  [120] = {.lex_state = 68},
  [121] = {.lex_state = 68},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 1},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 1},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 1},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 2},
  [253] = {.lex_state = 2},
  [254] = {.lex_state = 2},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 2},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 3},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 1},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 1},
  [420] = {.lex_state = 1},
  [421] = {.lex_state = 1},
  [422] = {.lex_state = 1},
  [423] = {.lex_state = 1},
  [424] = {.lex_state = 1},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 1},
  [430] = {.lex_state = 1},
  [431] = {.lex_state = 4},
  [432] = {.lex_state = 4},
  [433] = {.lex_state = 4},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 1},
  [438] = {.lex_state = 4},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 1},
  [441] = {.lex_state = 1},
  [442] = {.lex_state = 4},
  [443] = {.lex_state = 1},
  [444] = {.lex_state = 1},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 4},
  [448] = {.lex_state = 4},
  [449] = {.lex_state = 4},
  [450] = {.lex_state = 4},
  [451] = {.lex_state = 4},
  [452] = {.lex_state = 4},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 4},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 4},
  [457] = {.lex_state = 4},
  [458] = {.lex_state = 4},
  [459] = {.lex_state = 4},
  [460] = {.lex_state = 4},
  [461] = {.lex_state = 1},
  [462] = {.lex_state = 4},
  [463] = {.lex_state = 4},
  [464] = {.lex_state = 1},
  [465] = {.lex_state = 4},
  [466] = {.lex_state = 4},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 4},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 2},
  [471] = {.lex_state = 4},
  [472] = {.lex_state = 4},
  [473] = {.lex_state = 4},
  [474] = {.lex_state = 4},
  [475] = {.lex_state = 4},
  [476] = {.lex_state = 4},
  [477] = {.lex_state = 4},
  [478] = {.lex_state = 4},
  [479] = {.lex_state = 4},
  [480] = {.lex_state = 2},
  [481] = {.lex_state = 4},
  [482] = {.lex_state = 2},
  [483] = {.lex_state = 4},
  [484] = {.lex_state = 2},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 4},
  [487] = {.lex_state = 4},
  [488] = {.lex_state = 4},
  [489] = {.lex_state = 4},
  [490] = {.lex_state = 4},
  [491] = {.lex_state = 4},
  [492] = {.lex_state = 4},
  [493] = {.lex_state = 4},
  [494] = {.lex_state = 4},
  [495] = {.lex_state = 4},
  [496] = {.lex_state = 4},
  [497] = {.lex_state = 4},
  [498] = {.lex_state = 4},
  [499] = {.lex_state = 4},
  [500] = {.lex_state = 4},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 4},
  [503] = {.lex_state = 4},
  [504] = {.lex_state = 4},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 9},
  [507] = {.lex_state = 4},
  [508] = {.lex_state = 9},
  [509] = {.lex_state = 4},
  [510] = {.lex_state = 9},
  [511] = {.lex_state = 4},
  [512] = {.lex_state = 4},
  [513] = {.lex_state = 4},
  [514] = {.lex_state = 4},
  [515] = {.lex_state = 4},
  [516] = {.lex_state = 4},
  [517] = {.lex_state = 4},
  [518] = {.lex_state = 4},
  [519] = {.lex_state = 4},
  [520] = {.lex_state = 4},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 4},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 4},
  [527] = {.lex_state = 4},
  [528] = {.lex_state = 4},
  [529] = {.lex_state = 4},
  [530] = {.lex_state = 4},
  [531] = {.lex_state = 4},
  [532] = {.lex_state = 4},
  [533] = {.lex_state = 4},
  [534] = {.lex_state = 4},
  [535] = {.lex_state = 4},
  [536] = {.lex_state = 4},
  [537] = {.lex_state = 4},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 4},
  [540] = {.lex_state = 4},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 4},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 4},
  [547] = {.lex_state = 4},
  [548] = {.lex_state = 4},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 4},
  [556] = {.lex_state = 4},
  [557] = {.lex_state = 4},
  [558] = {.lex_state = 4},
  [559] = {.lex_state = 4},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 4},
  [562] = {.lex_state = 4},
  [563] = {.lex_state = 4},
  [564] = {.lex_state = 4},
  [565] = {.lex_state = 4},
  [566] = {.lex_state = 4},
  [567] = {.lex_state = 4},
  [568] = {.lex_state = 4},
  [569] = {.lex_state = 4},
  [570] = {.lex_state = 4},
  [571] = {.lex_state = 4},
  [572] = {.lex_state = 4},
  [573] = {.lex_state = 4},
  [574] = {.lex_state = 4},
  [575] = {.lex_state = 4},
  [576] = {.lex_state = 4},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 9},
  [584] = {.lex_state = 4},
  [585] = {.lex_state = 9},
  [586] = {.lex_state = 4},
  [587] = {.lex_state = 4},
  [588] = {.lex_state = 4},
  [589] = {.lex_state = 4},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 4},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 4},
  [594] = {.lex_state = 4},
  [595] = {.lex_state = 4},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 4},
  [599] = {.lex_state = 4},
  [600] = {.lex_state = 4},
  [601] = {.lex_state = 4},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 4},
  [606] = {.lex_state = 4},
  [607] = {.lex_state = 4},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 4},
  [610] = {.lex_state = 4},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 4},
  [613] = {.lex_state = 4},
  [614] = {.lex_state = 4},
  [615] = {.lex_state = 4},
  [616] = {.lex_state = 4},
  [617] = {.lex_state = 4},
  [618] = {.lex_state = 4},
  [619] = {.lex_state = 4},
  [620] = {.lex_state = 4},
  [621] = {.lex_state = 4},
  [622] = {.lex_state = 4},
  [623] = {.lex_state = 4},
  [624] = {.lex_state = 4},
  [625] = {.lex_state = 2},
  [626] = {.lex_state = 2},
  [627] = {.lex_state = 4},
  [628] = {.lex_state = 2},
  [629] = {.lex_state = 4},
  [630] = {.lex_state = 4},
  [631] = {.lex_state = 2},
  [632] = {.lex_state = 4},
  [633] = {.lex_state = 4},
  [634] = {.lex_state = 4},
  [635] = {.lex_state = 4},
  [636] = {.lex_state = 4},
  [637] = {.lex_state = 4},
  [638] = {.lex_state = 4},
  [639] = {.lex_state = 4},
  [640] = {.lex_state = 4},
  [641] = {.lex_state = 4},
  [642] = {.lex_state = 4},
  [643] = {.lex_state = 9},
  [644] = {.lex_state = 1},
  [645] = {.lex_state = 4},
  [646] = {.lex_state = 9},
  [647] = {.lex_state = 4},
  [648] = {.lex_state = 4},
  [649] = {.lex_state = 4},
  [650] = {.lex_state = 4},
  [651] = {.lex_state = 4},
  [652] = {.lex_state = 1},
  [653] = {.lex_state = 4},
  [654] = {.lex_state = 4},
  [655] = {.lex_state = 2},
  [656] = {.lex_state = 4},
  [657] = {.lex_state = 4},
  [658] = {.lex_state = 4},
  [659] = {.lex_state = 4},
  [660] = {.lex_state = 4},
  [661] = {.lex_state = 9},
  [662] = {.lex_state = 2},
  [663] = {.lex_state = 2},
  [664] = {.lex_state = 4},
  [665] = {.lex_state = 4},
  [666] = {.lex_state = 4},
  [667] = {.lex_state = 4},
  [668] = {.lex_state = 9},
  [669] = {.lex_state = 4},
  [670] = {.lex_state = 4},
  [671] = {.lex_state = 4},
  [672] = {.lex_state = 2},
  [673] = {.lex_state = 4},
  [674] = {.lex_state = 4},
  [675] = {.lex_state = 4},
  [676] = {.lex_state = 4},
  [677] = {.lex_state = 4},
  [678] = {.lex_state = 4},
  [679] = {.lex_state = 4},
  [680] = {.lex_state = 4},
  [681] = {.lex_state = 4},
  [682] = {.lex_state = 4},
  [683] = {.lex_state = 2},
  [684] = {.lex_state = 4},
  [685] = {.lex_state = 4},
  [686] = {.lex_state = 4},
  [687] = {.lex_state = 4},
  [688] = {.lex_state = 4},
  [689] = {.lex_state = 4},
  [690] = {.lex_state = 4},
  [691] = {.lex_state = 4},
  [692] = {.lex_state = 2},
  [693] = {.lex_state = 2},
  [694] = {.lex_state = 1},
  [695] = {.lex_state = 9},
  [696] = {.lex_state = 4},
  [697] = {.lex_state = 1},
  [698] = {.lex_state = 9},
  [699] = {.lex_state = 9},
  [700] = {.lex_state = 9},
  [701] = {.lex_state = 17},
  [702] = {.lex_state = 4},
  [703] = {.lex_state = 4},
  [704] = {.lex_state = 4},
  [705] = {.lex_state = 9},
  [706] = {.lex_state = 4},
  [707] = {.lex_state = 9},
  [708] = {.lex_state = 2},
  [709] = {.lex_state = 4},
  [710] = {.lex_state = 4},
  [711] = {.lex_state = 4},
  [712] = {.lex_state = 4},
  [713] = {.lex_state = 4},
  [714] = {.lex_state = 4},
  [715] = {.lex_state = 4},
  [716] = {.lex_state = 4},
  [717] = {.lex_state = 4},
  [718] = {.lex_state = 4},
  [719] = {.lex_state = 4},
  [720] = {.lex_state = 1},
  [721] = {.lex_state = 1},
  [722] = {.lex_state = 9},
  [723] = {.lex_state = 4},
  [724] = {.lex_state = 1},
  [725] = {.lex_state = 4},
  [726] = {.lex_state = 4},
  [727] = {.lex_state = 4},
  [728] = {.lex_state = 4},
  [729] = {.lex_state = 9},
  [730] = {.lex_state = 4},
  [731] = {.lex_state = 4},
  [732] = {.lex_state = 4},
  [733] = {.lex_state = 4},
  [734] = {.lex_state = 17},
  [735] = {.lex_state = 4},
  [736] = {.lex_state = 4},
  [737] = {.lex_state = 9},
  [738] = {.lex_state = 4},
  [739] = {.lex_state = 4},
  [740] = {.lex_state = 9},
  [741] = {.lex_state = 1},
  [742] = {.lex_state = 4},
  [743] = {.lex_state = 4},
  [744] = {.lex_state = 4},
  [745] = {.lex_state = 4},
  [746] = {.lex_state = 4},
  [747] = {.lex_state = 4},
  [748] = {.lex_state = 4},
  [749] = {.lex_state = 4},
  [750] = {.lex_state = 4},
  [751] = {.lex_state = 17},
  [752] = {.lex_state = 4},
  [753] = {.lex_state = 4},
  [754] = {.lex_state = 4},
  [755] = {.lex_state = 1},
  [756] = {.lex_state = 1},
  [757] = {.lex_state = 9},
  [758] = {.lex_state = 9},
  [759] = {.lex_state = 9},
  [760] = {.lex_state = 1},
  [761] = {.lex_state = 1},
  [762] = {.lex_state = 1},
  [763] = {.lex_state = 1},
  [764] = {.lex_state = 1},
  [765] = {.lex_state = 1},
  [766] = {.lex_state = 1},
  [767] = {.lex_state = 1},
  [768] = {.lex_state = 1},
  [769] = {.lex_state = 2},
  [770] = {.lex_state = 1},
  [771] = {.lex_state = 1},
  [772] = {.lex_state = 1},
  [773] = {.lex_state = 1},
  [774] = {.lex_state = 1},
  [775] = {.lex_state = 1},
  [776] = {.lex_state = 1},
  [777] = {.lex_state = 1},
  [778] = {.lex_state = 1},
  [779] = {.lex_state = 1},
  [780] = {.lex_state = 1},
  [781] = {.lex_state = 1},
  [782] = {.lex_state = 1},
  [783] = {.lex_state = 17},
  [784] = {.lex_state = 1},
  [785] = {.lex_state = 1},
  [786] = {.lex_state = 1},
  [787] = {.lex_state = 1},
  [788] = {.lex_state = 1},
  [789] = {.lex_state = 1},
  [790] = {.lex_state = 1},
  [791] = {.lex_state = 1},
  [792] = {.lex_state = 1},
  [793] = {.lex_state = 1},
  [794] = {.lex_state = 1},
  [795] = {.lex_state = 1},
  [796] = {.lex_state = 1},
  [797] = {.lex_state = 1},
  [798] = {.lex_state = 1},
  [799] = {.lex_state = 1},
  [800] = {.lex_state = 1},
  [801] = {.lex_state = 17},
  [802] = {.lex_state = 1},
  [803] = {.lex_state = 1},
  [804] = {.lex_state = 1},
  [805] = {.lex_state = 1},
  [806] = {.lex_state = 1},
  [807] = {.lex_state = 1},
  [808] = {.lex_state = 1},
  [809] = {.lex_state = 1},
  [810] = {.lex_state = 1},
  [811] = {.lex_state = 1},
  [812] = {.lex_state = 1},
  [813] = {.lex_state = 1},
  [814] = {.lex_state = 1},
  [815] = {.lex_state = 1},
  [816] = {.lex_state = 1},
  [817] = {.lex_state = 1},
  [818] = {.lex_state = 1},
  [819] = {.lex_state = 1},
  [820] = {.lex_state = 1},
  [821] = {.lex_state = 1},
  [822] = {.lex_state = 1},
  [823] = {.lex_state = 1},
  [824] = {.lex_state = 1},
  [825] = {.lex_state = 1},
  [826] = {.lex_state = 1},
  [827] = {.lex_state = 1},
  [828] = {.lex_state = 9},
  [829] = {.lex_state = 1},
  [830] = {.lex_state = 1},
  [831] = {.lex_state = 1},
  [832] = {.lex_state = 1},
  [833] = {.lex_state = 9},
  [834] = {.lex_state = 1},
  [835] = {.lex_state = 1},
  [836] = {.lex_state = 1},
  [837] = {.lex_state = 1},
  [838] = {.lex_state = 1},
  [839] = {.lex_state = 1},
  [840] = {.lex_state = 1},
  [841] = {.lex_state = 1},
  [842] = {.lex_state = 1},
  [843] = {.lex_state = 1},
  [844] = {.lex_state = 1},
  [845] = {.lex_state = 1},
  [846] = {.lex_state = 1},
  [847] = {.lex_state = 1},
  [848] = {.lex_state = 1},
  [849] = {.lex_state = 1},
  [850] = {.lex_state = 1},
  [851] = {.lex_state = 1},
  [852] = {.lex_state = 1},
  [853] = {.lex_state = 1},
  [854] = {.lex_state = 1},
  [855] = {.lex_state = 1},
  [856] = {.lex_state = 1},
  [857] = {.lex_state = 1},
  [858] = {.lex_state = 1},
  [859] = {.lex_state = 1},
  [860] = {.lex_state = 1},
  [861] = {.lex_state = 1},
  [862] = {.lex_state = 1},
  [863] = {.lex_state = 1},
  [864] = {.lex_state = 1},
  [865] = {.lex_state = 1},
  [866] = {.lex_state = 1},
  [867] = {.lex_state = 1},
  [868] = {.lex_state = 1},
  [869] = {.lex_state = 1},
  [870] = {.lex_state = 1},
  [871] = {.lex_state = 1},
  [872] = {.lex_state = 1},
  [873] = {.lex_state = 1},
  [874] = {.lex_state = 1},
  [875] = {.lex_state = 1},
  [876] = {.lex_state = 1},
  [877] = {.lex_state = 1},
  [878] = {.lex_state = 1},
  [879] = {.lex_state = 1},
  [880] = {.lex_state = 1},
  [881] = {.lex_state = 1},
  [882] = {.lex_state = 1},
  [883] = {.lex_state = 1},
  [884] = {.lex_state = 1},
  [885] = {.lex_state = 1},
  [886] = {.lex_state = 1},
  [887] = {.lex_state = 1},
  [888] = {.lex_state = 1},
  [889] = {.lex_state = 6},
  [890] = {.lex_state = 6},
  [891] = {.lex_state = 1},
  [892] = {.lex_state = 1},
  [893] = {.lex_state = 1},
  [894] = {.lex_state = 6},
  [895] = {.lex_state = 1},
  [896] = {.lex_state = 1},
  [897] = {.lex_state = 1},
  [898] = {.lex_state = 1},
  [899] = {.lex_state = 1},
  [900] = {.lex_state = 1},
  [901] = {.lex_state = 1},
  [902] = {.lex_state = 1},
  [903] = {.lex_state = 1},
  [904] = {.lex_state = 1},
  [905] = {.lex_state = 1},
  [906] = {.lex_state = 1},
  [907] = {.lex_state = 1},
  [908] = {.lex_state = 9},
  [909] = {.lex_state = 1},
  [910] = {.lex_state = 1},
  [911] = {.lex_state = 1},
  [912] = {.lex_state = 1},
  [913] = {.lex_state = 1},
  [914] = {.lex_state = 1},
  [915] = {.lex_state = 1},
  [916] = {.lex_state = 1},
  [917] = {.lex_state = 1},
  [918] = {.lex_state = 1},
  [919] = {.lex_state = 1},
  [920] = {.lex_state = 1},
  [921] = {.lex_state = 1},
  [922] = {.lex_state = 1},
  [923] = {.lex_state = 1},
  [924] = {.lex_state = 1},
  [925] = {.lex_state = 1},
  [926] = {.lex_state = 1},
  [927] = {.lex_state = 1},
  [928] = {.lex_state = 1},
  [929] = {.lex_state = 1},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 1},
  [932] = {.lex_state = 1},
  [933] = {.lex_state = 1},
  [934] = {.lex_state = 1},
  [935] = {.lex_state = 1},
  [936] = {.lex_state = 1},
  [937] = {.lex_state = 1},
  [938] = {.lex_state = 1},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 1},
  [941] = {.lex_state = 1},
  [942] = {.lex_state = 1},
  [943] = {.lex_state = 1},
  [944] = {.lex_state = 1},
  [945] = {.lex_state = 1},
  [946] = {.lex_state = 1},
  [947] = {.lex_state = 1},
  [948] = {.lex_state = 1},
  [949] = {.lex_state = 1},
  [950] = {.lex_state = 1},
  [951] = {.lex_state = 1},
  [952] = {.lex_state = 1},
  [953] = {.lex_state = 1},
  [954] = {.lex_state = 1},
  [955] = {.lex_state = 1},
  [956] = {.lex_state = 1},
  [957] = {.lex_state = 1},
  [958] = {.lex_state = 1},
  [959] = {.lex_state = 1},
  [960] = {.lex_state = 1},
  [961] = {.lex_state = 1},
  [962] = {.lex_state = 1},
  [963] = {.lex_state = 1},
  [964] = {.lex_state = 1},
  [965] = {.lex_state = 6},
  [966] = {.lex_state = 8},
  [967] = {.lex_state = 1},
  [968] = {.lex_state = 1},
  [969] = {.lex_state = 1},
  [970] = {.lex_state = 1},
  [971] = {.lex_state = 1},
  [972] = {.lex_state = 1},
  [973] = {.lex_state = 8},
  [974] = {.lex_state = 1},
  [975] = {.lex_state = 8},
  [976] = {.lex_state = 1},
  [977] = {.lex_state = 1},
  [978] = {.lex_state = 1},
  [979] = {.lex_state = 6},
  [980] = {.lex_state = 1},
  [981] = {.lex_state = 1},
  [982] = {.lex_state = 1},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 1},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 9},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 1},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 1},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 9},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 1},
  [1008] = {.lex_state = 1},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 1},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 1},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 1},
  [1016] = {.lex_state = 1},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 1},
  [1020] = {.lex_state = 1},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 1},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 1},
  [1025] = {.lex_state = 1},
  [1026] = {.lex_state = 1},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 9},
  [1030] = {.lex_state = 1},
  [1031] = {.lex_state = 1},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 1},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 1},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 9},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 9},
  [1042] = {.lex_state = 8},
  [1043] = {.lex_state = 1},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 1},
  [1046] = {.lex_state = 1},
  [1047] = {.lex_state = 1},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 1},
  [1050] = {.lex_state = 1},
  [1051] = {.lex_state = 1},
  [1052] = {.lex_state = 1},
  [1053] = {.lex_state = 1},
  [1054] = {.lex_state = 1},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 9},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 1},
  [1060] = {.lex_state = 1},
  [1061] = {.lex_state = 1},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 9},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 1},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 1},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 1},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 9},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 1},
  [1091] = {.lex_state = 1},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 9},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 9},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 1},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 1},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 1},
  [1125] = {.lex_state = 1},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 9},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 9},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 1},
  [1139] = {.lex_state = 1},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 1},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 9},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 1},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 9},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 9},
  [1163] = {.lex_state = 1},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 9},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 1},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 1},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 1},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 1},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 1},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 1},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 9},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 9},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 1},
  [1227] = {.lex_state = 9},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 9},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 9},
  [1243] = {.lex_state = 1},
  [1244] = {.lex_state = 9},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 1},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 1},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 1},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 1},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 9},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 0},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 0},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 1},
  [1299] = {.lex_state = 1},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 1},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 1},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 1},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 1},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 1},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 1},
  [1332] = {.lex_state = 1},
  [1333] = {.lex_state = 1},
  [1334] = {.lex_state = 1},
  [1335] = {.lex_state = 1},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 1},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 1},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 1},
  [1364] = {.lex_state = 1},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 0},
  [1367] = {.lex_state = 1},
  [1368] = {.lex_state = 1},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [aux_sym__escape_sequence_token1] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [sym_underscore_pattern] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_sealed] = ACTIONS(1),
    [anon_sym_non_DASHsealed] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_permits] = ACTIONS(1),
    [anon_sym_record] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(1361),
    [sym__toplevel_statement] = STATE(3),
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(3),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(751),
    [sym_type_parameters] = STATE(788),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(765),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym__method_header] = STATE(1151),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym_method_declaration] = STATE(3),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_program_repeat1] = STATE(3),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(77),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__toplevel_statement] = STATE(2),
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(2),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(751),
    [sym_type_parameters] = STATE(788),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(765),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym__method_header] = STATE(1151),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym_method_declaration] = STATE(2),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_program_repeat1] = STATE(2),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [ts_builtin_sym_end] = ACTIONS(97),
    [sym_identifier] = ACTIONS(99),
    [sym_decimal_integer_literal] = ACTIONS(102),
    [sym_hex_integer_literal] = ACTIONS(102),
    [sym_octal_integer_literal] = ACTIONS(102),
    [sym_binary_integer_literal] = ACTIONS(105),
    [sym_decimal_floating_point_literal] = ACTIONS(105),
    [sym_hex_floating_point_literal] = ACTIONS(102),
    [sym_true] = ACTIONS(102),
    [sym_false] = ACTIONS(102),
    [sym_character_literal] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(108),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(111),
    [sym_null_literal] = ACTIONS(102),
    [anon_sym_LPAREN] = ACTIONS(114),
    [anon_sym_LT] = ACTIONS(117),
    [anon_sym_PLUS] = ACTIONS(120),
    [anon_sym_DASH] = ACTIONS(120),
    [anon_sym_final] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(126),
    [anon_sym_TILDE] = ACTIONS(126),
    [anon_sym_PLUS_PLUS] = ACTIONS(129),
    [anon_sym_DASH_DASH] = ACTIONS(129),
    [anon_sym_new] = ACTIONS(132),
    [anon_sym_class] = ACTIONS(135),
    [anon_sym_switch] = ACTIONS(138),
    [anon_sym_LBRACE] = ACTIONS(141),
    [anon_sym_default] = ACTIONS(123),
    [anon_sym_SEMI] = ACTIONS(144),
    [anon_sym_assert] = ACTIONS(147),
    [anon_sym_do] = ACTIONS(150),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_break] = ACTIONS(156),
    [anon_sym_continue] = ACTIONS(159),
    [anon_sym_return] = ACTIONS(162),
    [anon_sym_yield] = ACTIONS(165),
    [anon_sym_synchronized] = ACTIONS(168),
    [anon_sym_throw] = ACTIONS(171),
    [anon_sym_try] = ACTIONS(174),
    [anon_sym_if] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(180),
    [anon_sym_AT] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(186),
    [anon_sym_module] = ACTIONS(189),
    [anon_sym_static] = ACTIONS(123),
    [anon_sym_with] = ACTIONS(192),
    [anon_sym_package] = ACTIONS(195),
    [anon_sym_import] = ACTIONS(198),
    [anon_sym_enum] = ACTIONS(201),
    [anon_sym_public] = ACTIONS(123),
    [anon_sym_protected] = ACTIONS(123),
    [anon_sym_private] = ACTIONS(123),
    [anon_sym_abstract] = ACTIONS(123),
    [anon_sym_strictfp] = ACTIONS(123),
    [anon_sym_native] = ACTIONS(123),
    [anon_sym_transient] = ACTIONS(123),
    [anon_sym_volatile] = ACTIONS(123),
    [anon_sym_sealed] = ACTIONS(204),
    [anon_sym_non_DASHsealed] = ACTIONS(207),
    [anon_sym_record] = ACTIONS(210),
    [anon_sym_ATinterface] = ACTIONS(213),
    [anon_sym_interface] = ACTIONS(216),
    [anon_sym_byte] = ACTIONS(219),
    [anon_sym_short] = ACTIONS(219),
    [anon_sym_int] = ACTIONS(219),
    [anon_sym_long] = ACTIONS(219),
    [anon_sym_char] = ACTIONS(219),
    [anon_sym_float] = ACTIONS(222),
    [anon_sym_double] = ACTIONS(222),
    [sym_boolean_type] = ACTIONS(225),
    [sym_void_type] = ACTIONS(225),
    [sym_this] = ACTIONS(228),
    [sym_super] = ACTIONS(231),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__toplevel_statement] = STATE(2),
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(2),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(751),
    [sym_type_parameters] = STATE(788),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(765),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym__method_header] = STATE(1151),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym_method_declaration] = STATE(2),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_program_repeat1] = STATE(2),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [ts_builtin_sym_end] = ACTIONS(234),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(77),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_switch_label] = STATE(1322),
    [sym_statement] = STATE(7),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat1] = STATE(388),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(7),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(238),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_default] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(635),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_type_arguments] = STATE(1299),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(11),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_explicit_constructor_invocation] = STATE(13),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(11),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(250),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_LT] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(254),
    [sym_super] = ACTIONS(256),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(6),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(258),
    [sym_decimal_integer_literal] = ACTIONS(261),
    [sym_hex_integer_literal] = ACTIONS(261),
    [sym_octal_integer_literal] = ACTIONS(261),
    [sym_binary_integer_literal] = ACTIONS(264),
    [sym_decimal_floating_point_literal] = ACTIONS(264),
    [sym_hex_floating_point_literal] = ACTIONS(261),
    [sym_true] = ACTIONS(261),
    [sym_false] = ACTIONS(261),
    [sym_character_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(267),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(270),
    [anon_sym_RBRACE] = ACTIONS(273),
    [sym_null_literal] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(275),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_final] = ACTIONS(281),
    [anon_sym_BANG] = ACTIONS(284),
    [anon_sym_TILDE] = ACTIONS(284),
    [anon_sym_PLUS_PLUS] = ACTIONS(287),
    [anon_sym_DASH_DASH] = ACTIONS(287),
    [anon_sym_new] = ACTIONS(290),
    [anon_sym_class] = ACTIONS(293),
    [anon_sym_switch] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_case] = ACTIONS(302),
    [anon_sym_default] = ACTIONS(281),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_assert] = ACTIONS(307),
    [anon_sym_do] = ACTIONS(310),
    [anon_sym_while] = ACTIONS(313),
    [anon_sym_break] = ACTIONS(316),
    [anon_sym_continue] = ACTIONS(319),
    [anon_sym_return] = ACTIONS(322),
    [anon_sym_yield] = ACTIONS(325),
    [anon_sym_synchronized] = ACTIONS(328),
    [anon_sym_throw] = ACTIONS(331),
    [anon_sym_try] = ACTIONS(334),
    [anon_sym_if] = ACTIONS(337),
    [anon_sym_for] = ACTIONS(340),
    [anon_sym_AT] = ACTIONS(343),
    [anon_sym_open] = ACTIONS(346),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_static] = ACTIONS(281),
    [anon_sym_with] = ACTIONS(352),
    [anon_sym_package] = ACTIONS(355),
    [anon_sym_import] = ACTIONS(358),
    [anon_sym_enum] = ACTIONS(361),
    [anon_sym_public] = ACTIONS(281),
    [anon_sym_protected] = ACTIONS(281),
    [anon_sym_private] = ACTIONS(281),
    [anon_sym_abstract] = ACTIONS(281),
    [anon_sym_strictfp] = ACTIONS(281),
    [anon_sym_native] = ACTIONS(281),
    [anon_sym_transient] = ACTIONS(281),
    [anon_sym_volatile] = ACTIONS(281),
    [anon_sym_sealed] = ACTIONS(364),
    [anon_sym_non_DASHsealed] = ACTIONS(367),
    [anon_sym_record] = ACTIONS(370),
    [anon_sym_ATinterface] = ACTIONS(373),
    [anon_sym_interface] = ACTIONS(376),
    [anon_sym_byte] = ACTIONS(379),
    [anon_sym_short] = ACTIONS(379),
    [anon_sym_int] = ACTIONS(379),
    [anon_sym_long] = ACTIONS(379),
    [anon_sym_char] = ACTIONS(379),
    [anon_sym_float] = ACTIONS(382),
    [anon_sym_double] = ACTIONS(382),
    [sym_boolean_type] = ACTIONS(385),
    [sym_void_type] = ACTIONS(385),
    [sym_this] = ACTIONS(388),
    [sym_super] = ACTIONS(391),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(6),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(394),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_case] = ACTIONS(396),
    [anon_sym_default] = ACTIONS(396),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(6),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(398),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(10),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(10),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(400),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(6),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(402),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(6),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(404),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(6),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(406),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(12),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(12),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(404),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(8),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_switch_block_statement_group_repeat2] = STATE(8),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(408),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(365),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(376),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(262),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(362),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(371),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(383),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(380),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(1351),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(378),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(374),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(365),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(361),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(360),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(358),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(357),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(318),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(363),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(375),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(370),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(367),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(366),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(255),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(273),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(266),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(266),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(393),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(318),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(368),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(273),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(255),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(366),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(367),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(370),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(375),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(363),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(357),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(358),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(361),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(368),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(394),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(374),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(378),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(380),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(376),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(383),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(262),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(377),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(377),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(349),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(350),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(274),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(261),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(260),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(349),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(362),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(371),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(120),
    [sym_statement] = STATE(360),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(236),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(242),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(260),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(266),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [74] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(1253),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [75] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(318),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [76] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(368),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [77] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(273),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [78] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(255),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [79] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(366),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [80] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(367),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [81] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(370),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [82] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(375),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [83] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(363),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [84] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(357),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [85] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(358),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [86] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(361),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [87] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(365),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [88] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(374),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [89] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(378),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [90] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(380),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [91] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(383),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [92] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(262),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [93] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(377),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [94] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(376),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [95] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(350),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [96] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(274),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [97] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(261),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [98] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(260),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [99] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(349),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [100] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(362),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [101] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(371),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [102] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(656),
    [sym_statement] = STATE(360),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(412),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [103] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(350),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [104] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(274),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [105] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(121),
    [sym_statement] = STATE(261),
    [sym_block] = STATE(264),
    [sym_expression_statement] = STATE(264),
    [sym_labeled_statement] = STATE(264),
    [sym_assert_statement] = STATE(264),
    [sym_do_statement] = STATE(264),
    [sym_break_statement] = STATE(264),
    [sym_continue_statement] = STATE(264),
    [sym_return_statement] = STATE(264),
    [sym_yield_statement] = STATE(264),
    [sym_synchronized_statement] = STATE(264),
    [sym_throw_statement] = STATE(264),
    [sym_try_statement] = STATE(264),
    [sym_try_with_resources_statement] = STATE(264),
    [sym_if_statement] = STATE(264),
    [sym_while_statement] = STATE(264),
    [sym_for_statement] = STATE(264),
    [sym_enhanced_for_statement] = STATE(264),
    [sym__annotation] = STATE(577),
    [sym_marker_annotation] = STATE(577),
    [sym_annotation] = STATE(577),
    [sym_declaration] = STATE(264),
    [sym_module_declaration] = STATE(259),
    [sym_package_declaration] = STATE(259),
    [sym_import_declaration] = STATE(259),
    [sym_enum_declaration] = STATE(259),
    [sym_class_declaration] = STATE(259),
    [sym_modifiers] = STATE(783),
    [sym_record_declaration] = STATE(259),
    [sym_annotation_type_declaration] = STATE(259),
    [sym_interface_declaration] = STATE(259),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(773),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(264),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(741),
    [aux_sym_modifiers_repeat1] = STATE(505),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_class] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_default] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_assert] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_synchronized] = ACTIONS(53),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_try] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_open] = ACTIONS(65),
    [anon_sym_module] = ACTIONS(67),
    [anon_sym_static] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_package] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(73),
    [anon_sym_enum] = ACTIONS(75),
    [anon_sym_public] = ACTIONS(23),
    [anon_sym_protected] = ACTIONS(23),
    [anon_sym_private] = ACTIONS(23),
    [anon_sym_abstract] = ACTIONS(23),
    [anon_sym_strictfp] = ACTIONS(23),
    [anon_sym_native] = ACTIONS(23),
    [anon_sym_transient] = ACTIONS(23),
    [anon_sym_volatile] = ACTIONS(23),
    [anon_sym_sealed] = ACTIONS(248),
    [anon_sym_non_DASHsealed] = ACTIONS(79),
    [anon_sym_record] = ACTIONS(81),
    [anon_sym_ATinterface] = ACTIONS(83),
    [anon_sym_interface] = ACTIONS(85),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [106] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(717),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(775),
    [sym_marker_annotation] = STATE(775),
    [sym_annotation] = STATE(775),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_AMP] = ACTIONS(420),
    [anon_sym_EQ] = ACTIONS(420),
    [anon_sym_PLUS_EQ] = ACTIONS(422),
    [anon_sym_DASH_EQ] = ACTIONS(422),
    [anon_sym_STAR_EQ] = ACTIONS(422),
    [anon_sym_SLASH_EQ] = ACTIONS(422),
    [anon_sym_AMP_EQ] = ACTIONS(422),
    [anon_sym_PIPE_EQ] = ACTIONS(422),
    [anon_sym_CARET_EQ] = ACTIONS(422),
    [anon_sym_PERCENT_EQ] = ACTIONS(422),
    [anon_sym_LT_LT_EQ] = ACTIONS(422),
    [anon_sym_GT_GT_EQ] = ACTIONS(422),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(422),
    [anon_sym_GT] = ACTIONS(420),
    [anon_sym_LT] = ACTIONS(420),
    [anon_sym_GT_EQ] = ACTIONS(422),
    [anon_sym_LT_EQ] = ACTIONS(422),
    [anon_sym_EQ_EQ] = ACTIONS(422),
    [anon_sym_BANG_EQ] = ACTIONS(422),
    [anon_sym_AMP_AMP] = ACTIONS(422),
    [anon_sym_PIPE_PIPE] = ACTIONS(422),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(420),
    [anon_sym_SLASH] = ACTIONS(420),
    [anon_sym_PIPE] = ACTIONS(420),
    [anon_sym_CARET] = ACTIONS(420),
    [anon_sym_PERCENT] = ACTIONS(420),
    [anon_sym_LT_LT] = ACTIONS(420),
    [anon_sym_GT_GT] = ACTIONS(420),
    [anon_sym_GT_GT_GT] = ACTIONS(420),
    [anon_sym_instanceof] = ACTIONS(420),
    [anon_sym_DASH_GT] = ACTIONS(422),
    [anon_sym_QMARK] = ACTIONS(422),
    [anon_sym_BANG] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_DOT] = ACTIONS(420),
    [anon_sym_COLON_COLON] = ACTIONS(422),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(426),
    [sym_identifier] = ACTIONS(428),
    [sym_decimal_integer_literal] = ACTIONS(428),
    [sym_hex_integer_literal] = ACTIONS(428),
    [sym_octal_integer_literal] = ACTIONS(428),
    [sym_binary_integer_literal] = ACTIONS(426),
    [sym_decimal_floating_point_literal] = ACTIONS(426),
    [sym_hex_floating_point_literal] = ACTIONS(428),
    [sym_true] = ACTIONS(428),
    [sym_false] = ACTIONS(428),
    [sym_character_literal] = ACTIONS(426),
    [anon_sym_DQUOTE] = ACTIONS(428),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(426),
    [anon_sym_RBRACE] = ACTIONS(426),
    [sym_null_literal] = ACTIONS(428),
    [anon_sym_LPAREN] = ACTIONS(426),
    [anon_sym_RPAREN] = ACTIONS(426),
    [anon_sym_AMP] = ACTIONS(428),
    [anon_sym_GT] = ACTIONS(428),
    [anon_sym_LT] = ACTIONS(428),
    [anon_sym_GT_EQ] = ACTIONS(426),
    [anon_sym_LT_EQ] = ACTIONS(426),
    [anon_sym_EQ_EQ] = ACTIONS(426),
    [anon_sym_BANG_EQ] = ACTIONS(426),
    [anon_sym_AMP_AMP] = ACTIONS(426),
    [anon_sym_PIPE_PIPE] = ACTIONS(426),
    [anon_sym_PLUS] = ACTIONS(428),
    [anon_sym_DASH] = ACTIONS(428),
    [anon_sym_STAR] = ACTIONS(426),
    [anon_sym_SLASH] = ACTIONS(428),
    [anon_sym_PIPE] = ACTIONS(428),
    [anon_sym_CARET] = ACTIONS(426),
    [anon_sym_PERCENT] = ACTIONS(426),
    [anon_sym_LT_LT] = ACTIONS(426),
    [anon_sym_GT_GT] = ACTIONS(428),
    [anon_sym_GT_GT_GT] = ACTIONS(426),
    [anon_sym_instanceof] = ACTIONS(428),
    [anon_sym_final] = ACTIONS(428),
    [anon_sym_DASH_GT] = ACTIONS(426),
    [anon_sym_COMMA] = ACTIONS(426),
    [anon_sym_QMARK] = ACTIONS(426),
    [anon_sym_COLON] = ACTIONS(428),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(426),
    [anon_sym_PLUS_PLUS] = ACTIONS(426),
    [anon_sym_DASH_DASH] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(428),
    [anon_sym_LBRACK] = ACTIONS(426),
    [anon_sym_RBRACK] = ACTIONS(426),
    [anon_sym_DOT] = ACTIONS(428),
    [anon_sym_class] = ACTIONS(428),
    [anon_sym_COLON_COLON] = ACTIONS(426),
    [anon_sym_switch] = ACTIONS(428),
    [anon_sym_LBRACE] = ACTIONS(426),
    [anon_sym_case] = ACTIONS(428),
    [anon_sym_default] = ACTIONS(428),
    [anon_sym_when] = ACTIONS(428),
    [anon_sym_SEMI] = ACTIONS(426),
    [anon_sym_assert] = ACTIONS(428),
    [anon_sym_do] = ACTIONS(428),
    [anon_sym_while] = ACTIONS(428),
    [anon_sym_break] = ACTIONS(428),
    [anon_sym_continue] = ACTIONS(428),
    [anon_sym_return] = ACTIONS(428),
    [anon_sym_yield] = ACTIONS(428),
    [anon_sym_synchronized] = ACTIONS(428),
    [anon_sym_throw] = ACTIONS(428),
    [anon_sym_try] = ACTIONS(428),
    [anon_sym_if] = ACTIONS(428),
    [anon_sym_else] = ACTIONS(428),
    [anon_sym_for] = ACTIONS(428),
    [anon_sym_AT] = ACTIONS(428),
    [anon_sym_open] = ACTIONS(428),
    [anon_sym_module] = ACTIONS(428),
    [anon_sym_static] = ACTIONS(428),
    [anon_sym_with] = ACTIONS(428),
    [anon_sym_package] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(428),
    [anon_sym_enum] = ACTIONS(428),
    [anon_sym_public] = ACTIONS(428),
    [anon_sym_protected] = ACTIONS(428),
    [anon_sym_private] = ACTIONS(428),
    [anon_sym_abstract] = ACTIONS(428),
    [anon_sym_strictfp] = ACTIONS(428),
    [anon_sym_native] = ACTIONS(428),
    [anon_sym_transient] = ACTIONS(428),
    [anon_sym_volatile] = ACTIONS(428),
    [anon_sym_sealed] = ACTIONS(428),
    [anon_sym_non_DASHsealed] = ACTIONS(426),
    [anon_sym_record] = ACTIONS(428),
    [anon_sym_ATinterface] = ACTIONS(426),
    [anon_sym_interface] = ACTIONS(428),
    [anon_sym_byte] = ACTIONS(428),
    [anon_sym_short] = ACTIONS(428),
    [anon_sym_int] = ACTIONS(428),
    [anon_sym_long] = ACTIONS(428),
    [anon_sym_char] = ACTIONS(428),
    [anon_sym_float] = ACTIONS(428),
    [anon_sym_double] = ACTIONS(428),
    [sym_boolean_type] = ACTIONS(428),
    [sym_void_type] = ACTIONS(428),
    [sym_this] = ACTIONS(428),
    [sym_super] = ACTIONS(428),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(430),
    [sym_identifier] = ACTIONS(432),
    [sym_decimal_integer_literal] = ACTIONS(432),
    [sym_hex_integer_literal] = ACTIONS(432),
    [sym_octal_integer_literal] = ACTIONS(432),
    [sym_binary_integer_literal] = ACTIONS(430),
    [sym_decimal_floating_point_literal] = ACTIONS(430),
    [sym_hex_floating_point_literal] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_character_literal] = ACTIONS(430),
    [anon_sym_DQUOTE] = ACTIONS(432),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(430),
    [anon_sym_RBRACE] = ACTIONS(430),
    [sym_null_literal] = ACTIONS(432),
    [anon_sym_LPAREN] = ACTIONS(430),
    [anon_sym_RPAREN] = ACTIONS(430),
    [anon_sym_AMP] = ACTIONS(432),
    [anon_sym_GT] = ACTIONS(432),
    [anon_sym_LT] = ACTIONS(432),
    [anon_sym_GT_EQ] = ACTIONS(430),
    [anon_sym_LT_EQ] = ACTIONS(430),
    [anon_sym_EQ_EQ] = ACTIONS(430),
    [anon_sym_BANG_EQ] = ACTIONS(430),
    [anon_sym_AMP_AMP] = ACTIONS(430),
    [anon_sym_PIPE_PIPE] = ACTIONS(430),
    [anon_sym_PLUS] = ACTIONS(432),
    [anon_sym_DASH] = ACTIONS(432),
    [anon_sym_STAR] = ACTIONS(430),
    [anon_sym_SLASH] = ACTIONS(432),
    [anon_sym_PIPE] = ACTIONS(432),
    [anon_sym_CARET] = ACTIONS(430),
    [anon_sym_PERCENT] = ACTIONS(430),
    [anon_sym_LT_LT] = ACTIONS(430),
    [anon_sym_GT_GT] = ACTIONS(432),
    [anon_sym_GT_GT_GT] = ACTIONS(430),
    [anon_sym_instanceof] = ACTIONS(432),
    [anon_sym_final] = ACTIONS(432),
    [anon_sym_DASH_GT] = ACTIONS(430),
    [anon_sym_COMMA] = ACTIONS(430),
    [anon_sym_QMARK] = ACTIONS(430),
    [anon_sym_COLON] = ACTIONS(432),
    [anon_sym_BANG] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(430),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(430),
    [anon_sym_RBRACK] = ACTIONS(430),
    [anon_sym_DOT] = ACTIONS(432),
    [anon_sym_class] = ACTIONS(432),
    [anon_sym_COLON_COLON] = ACTIONS(430),
    [anon_sym_switch] = ACTIONS(432),
    [anon_sym_LBRACE] = ACTIONS(430),
    [anon_sym_case] = ACTIONS(432),
    [anon_sym_default] = ACTIONS(432),
    [anon_sym_when] = ACTIONS(432),
    [anon_sym_SEMI] = ACTIONS(430),
    [anon_sym_assert] = ACTIONS(432),
    [anon_sym_do] = ACTIONS(432),
    [anon_sym_while] = ACTIONS(432),
    [anon_sym_break] = ACTIONS(432),
    [anon_sym_continue] = ACTIONS(432),
    [anon_sym_return] = ACTIONS(432),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_synchronized] = ACTIONS(432),
    [anon_sym_throw] = ACTIONS(432),
    [anon_sym_try] = ACTIONS(432),
    [anon_sym_if] = ACTIONS(432),
    [anon_sym_else] = ACTIONS(432),
    [anon_sym_for] = ACTIONS(432),
    [anon_sym_AT] = ACTIONS(432),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_static] = ACTIONS(432),
    [anon_sym_with] = ACTIONS(432),
    [anon_sym_package] = ACTIONS(432),
    [anon_sym_import] = ACTIONS(432),
    [anon_sym_enum] = ACTIONS(432),
    [anon_sym_public] = ACTIONS(432),
    [anon_sym_protected] = ACTIONS(432),
    [anon_sym_private] = ACTIONS(432),
    [anon_sym_abstract] = ACTIONS(432),
    [anon_sym_strictfp] = ACTIONS(432),
    [anon_sym_native] = ACTIONS(432),
    [anon_sym_transient] = ACTIONS(432),
    [anon_sym_volatile] = ACTIONS(432),
    [anon_sym_sealed] = ACTIONS(432),
    [anon_sym_non_DASHsealed] = ACTIONS(430),
    [anon_sym_record] = ACTIONS(432),
    [anon_sym_ATinterface] = ACTIONS(430),
    [anon_sym_interface] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(432),
    [anon_sym_short] = ACTIONS(432),
    [anon_sym_int] = ACTIONS(432),
    [anon_sym_long] = ACTIONS(432),
    [anon_sym_char] = ACTIONS(432),
    [anon_sym_float] = ACTIONS(432),
    [anon_sym_double] = ACTIONS(432),
    [sym_boolean_type] = ACTIONS(432),
    [sym_void_type] = ACTIONS(432),
    [sym_this] = ACTIONS(432),
    [sym_super] = ACTIONS(432),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(434),
    [sym_identifier] = ACTIONS(436),
    [sym_decimal_integer_literal] = ACTIONS(436),
    [sym_hex_integer_literal] = ACTIONS(436),
    [sym_octal_integer_literal] = ACTIONS(436),
    [sym_binary_integer_literal] = ACTIONS(434),
    [sym_decimal_floating_point_literal] = ACTIONS(434),
    [sym_hex_floating_point_literal] = ACTIONS(436),
    [sym_true] = ACTIONS(436),
    [sym_false] = ACTIONS(436),
    [sym_character_literal] = ACTIONS(434),
    [anon_sym_DQUOTE] = ACTIONS(436),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(434),
    [anon_sym_RBRACE] = ACTIONS(434),
    [sym_null_literal] = ACTIONS(436),
    [anon_sym_LPAREN] = ACTIONS(434),
    [anon_sym_RPAREN] = ACTIONS(434),
    [anon_sym_AMP] = ACTIONS(436),
    [anon_sym_GT] = ACTIONS(436),
    [anon_sym_LT] = ACTIONS(436),
    [anon_sym_GT_EQ] = ACTIONS(434),
    [anon_sym_LT_EQ] = ACTIONS(434),
    [anon_sym_EQ_EQ] = ACTIONS(434),
    [anon_sym_BANG_EQ] = ACTIONS(434),
    [anon_sym_AMP_AMP] = ACTIONS(434),
    [anon_sym_PIPE_PIPE] = ACTIONS(434),
    [anon_sym_PLUS] = ACTIONS(436),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_STAR] = ACTIONS(434),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_PIPE] = ACTIONS(436),
    [anon_sym_CARET] = ACTIONS(434),
    [anon_sym_PERCENT] = ACTIONS(434),
    [anon_sym_LT_LT] = ACTIONS(434),
    [anon_sym_GT_GT] = ACTIONS(436),
    [anon_sym_GT_GT_GT] = ACTIONS(434),
    [anon_sym_instanceof] = ACTIONS(436),
    [anon_sym_final] = ACTIONS(436),
    [anon_sym_DASH_GT] = ACTIONS(434),
    [anon_sym_COMMA] = ACTIONS(434),
    [anon_sym_QMARK] = ACTIONS(434),
    [anon_sym_COLON] = ACTIONS(434),
    [anon_sym_BANG] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(434),
    [anon_sym_PLUS_PLUS] = ACTIONS(434),
    [anon_sym_DASH_DASH] = ACTIONS(434),
    [anon_sym_new] = ACTIONS(436),
    [anon_sym_RBRACK] = ACTIONS(434),
    [anon_sym_class] = ACTIONS(436),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_LBRACE] = ACTIONS(434),
    [anon_sym_case] = ACTIONS(436),
    [anon_sym_default] = ACTIONS(436),
    [anon_sym_when] = ACTIONS(436),
    [anon_sym_SEMI] = ACTIONS(434),
    [anon_sym_assert] = ACTIONS(436),
    [anon_sym_do] = ACTIONS(436),
    [anon_sym_while] = ACTIONS(436),
    [anon_sym_break] = ACTIONS(436),
    [anon_sym_continue] = ACTIONS(436),
    [anon_sym_return] = ACTIONS(436),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_synchronized] = ACTIONS(436),
    [anon_sym_throw] = ACTIONS(436),
    [anon_sym_try] = ACTIONS(436),
    [anon_sym_if] = ACTIONS(436),
    [anon_sym_else] = ACTIONS(436),
    [anon_sym_for] = ACTIONS(436),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_open] = ACTIONS(436),
    [anon_sym_module] = ACTIONS(436),
    [anon_sym_static] = ACTIONS(436),
    [anon_sym_with] = ACTIONS(436),
    [anon_sym_package] = ACTIONS(436),
    [anon_sym_import] = ACTIONS(436),
    [anon_sym_enum] = ACTIONS(436),
    [anon_sym_public] = ACTIONS(436),
    [anon_sym_protected] = ACTIONS(436),
    [anon_sym_private] = ACTIONS(436),
    [anon_sym_abstract] = ACTIONS(436),
    [anon_sym_strictfp] = ACTIONS(436),
    [anon_sym_native] = ACTIONS(436),
    [anon_sym_transient] = ACTIONS(436),
    [anon_sym_volatile] = ACTIONS(436),
    [anon_sym_sealed] = ACTIONS(436),
    [anon_sym_non_DASHsealed] = ACTIONS(434),
    [anon_sym_record] = ACTIONS(436),
    [anon_sym_ATinterface] = ACTIONS(434),
    [anon_sym_interface] = ACTIONS(436),
    [anon_sym_byte] = ACTIONS(436),
    [anon_sym_short] = ACTIONS(436),
    [anon_sym_int] = ACTIONS(436),
    [anon_sym_long] = ACTIONS(436),
    [anon_sym_char] = ACTIONS(436),
    [anon_sym_float] = ACTIONS(436),
    [anon_sym_double] = ACTIONS(436),
    [sym_boolean_type] = ACTIONS(436),
    [sym_void_type] = ACTIONS(436),
    [sym_this] = ACTIONS(436),
    [sym_super] = ACTIONS(436),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(438),
    [sym_identifier] = ACTIONS(440),
    [sym_decimal_integer_literal] = ACTIONS(440),
    [sym_hex_integer_literal] = ACTIONS(440),
    [sym_octal_integer_literal] = ACTIONS(440),
    [sym_binary_integer_literal] = ACTIONS(438),
    [sym_decimal_floating_point_literal] = ACTIONS(438),
    [sym_hex_floating_point_literal] = ACTIONS(440),
    [sym_true] = ACTIONS(440),
    [sym_false] = ACTIONS(440),
    [sym_character_literal] = ACTIONS(438),
    [anon_sym_DQUOTE] = ACTIONS(440),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(438),
    [sym_null_literal] = ACTIONS(440),
    [anon_sym_LPAREN] = ACTIONS(438),
    [anon_sym_RPAREN] = ACTIONS(438),
    [anon_sym_AMP] = ACTIONS(440),
    [anon_sym_GT] = ACTIONS(440),
    [anon_sym_LT] = ACTIONS(440),
    [anon_sym_GT_EQ] = ACTIONS(438),
    [anon_sym_LT_EQ] = ACTIONS(438),
    [anon_sym_EQ_EQ] = ACTIONS(438),
    [anon_sym_BANG_EQ] = ACTIONS(438),
    [anon_sym_AMP_AMP] = ACTIONS(438),
    [anon_sym_PIPE_PIPE] = ACTIONS(438),
    [anon_sym_PLUS] = ACTIONS(440),
    [anon_sym_DASH] = ACTIONS(440),
    [anon_sym_STAR] = ACTIONS(438),
    [anon_sym_SLASH] = ACTIONS(440),
    [anon_sym_PIPE] = ACTIONS(440),
    [anon_sym_CARET] = ACTIONS(438),
    [anon_sym_PERCENT] = ACTIONS(438),
    [anon_sym_LT_LT] = ACTIONS(438),
    [anon_sym_GT_GT] = ACTIONS(440),
    [anon_sym_GT_GT_GT] = ACTIONS(438),
    [anon_sym_instanceof] = ACTIONS(440),
    [anon_sym_final] = ACTIONS(440),
    [anon_sym_DASH_GT] = ACTIONS(438),
    [anon_sym_COMMA] = ACTIONS(438),
    [anon_sym_QMARK] = ACTIONS(438),
    [anon_sym_COLON] = ACTIONS(438),
    [anon_sym_BANG] = ACTIONS(440),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_PLUS_PLUS] = ACTIONS(438),
    [anon_sym_DASH_DASH] = ACTIONS(438),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_RBRACK] = ACTIONS(438),
    [anon_sym_class] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(440),
    [anon_sym_LBRACE] = ACTIONS(438),
    [anon_sym_case] = ACTIONS(440),
    [anon_sym_default] = ACTIONS(440),
    [anon_sym_when] = ACTIONS(440),
    [anon_sym_SEMI] = ACTIONS(438),
    [anon_sym_assert] = ACTIONS(440),
    [anon_sym_do] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(440),
    [anon_sym_break] = ACTIONS(440),
    [anon_sym_continue] = ACTIONS(440),
    [anon_sym_return] = ACTIONS(440),
    [anon_sym_yield] = ACTIONS(440),
    [anon_sym_synchronized] = ACTIONS(440),
    [anon_sym_throw] = ACTIONS(440),
    [anon_sym_try] = ACTIONS(440),
    [anon_sym_if] = ACTIONS(440),
    [anon_sym_else] = ACTIONS(440),
    [anon_sym_for] = ACTIONS(440),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_open] = ACTIONS(440),
    [anon_sym_module] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(440),
    [anon_sym_with] = ACTIONS(440),
    [anon_sym_package] = ACTIONS(440),
    [anon_sym_import] = ACTIONS(440),
    [anon_sym_enum] = ACTIONS(440),
    [anon_sym_public] = ACTIONS(440),
    [anon_sym_protected] = ACTIONS(440),
    [anon_sym_private] = ACTIONS(440),
    [anon_sym_abstract] = ACTIONS(440),
    [anon_sym_strictfp] = ACTIONS(440),
    [anon_sym_native] = ACTIONS(440),
    [anon_sym_transient] = ACTIONS(440),
    [anon_sym_volatile] = ACTIONS(440),
    [anon_sym_sealed] = ACTIONS(440),
    [anon_sym_non_DASHsealed] = ACTIONS(438),
    [anon_sym_record] = ACTIONS(440),
    [anon_sym_ATinterface] = ACTIONS(438),
    [anon_sym_interface] = ACTIONS(440),
    [anon_sym_byte] = ACTIONS(440),
    [anon_sym_short] = ACTIONS(440),
    [anon_sym_int] = ACTIONS(440),
    [anon_sym_long] = ACTIONS(440),
    [anon_sym_char] = ACTIONS(440),
    [anon_sym_float] = ACTIONS(440),
    [anon_sym_double] = ACTIONS(440),
    [sym_boolean_type] = ACTIONS(440),
    [sym_void_type] = ACTIONS(440),
    [sym_this] = ACTIONS(440),
    [sym_super] = ACTIONS(440),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(442),
    [sym_identifier] = ACTIONS(444),
    [sym_decimal_integer_literal] = ACTIONS(444),
    [sym_hex_integer_literal] = ACTIONS(444),
    [sym_octal_integer_literal] = ACTIONS(444),
    [sym_binary_integer_literal] = ACTIONS(442),
    [sym_decimal_floating_point_literal] = ACTIONS(442),
    [sym_hex_floating_point_literal] = ACTIONS(444),
    [sym_true] = ACTIONS(444),
    [sym_false] = ACTIONS(444),
    [sym_character_literal] = ACTIONS(442),
    [anon_sym_DQUOTE] = ACTIONS(444),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(442),
    [anon_sym_RBRACE] = ACTIONS(442),
    [sym_null_literal] = ACTIONS(444),
    [anon_sym_LPAREN] = ACTIONS(442),
    [anon_sym_RPAREN] = ACTIONS(442),
    [anon_sym_AMP] = ACTIONS(444),
    [anon_sym_GT] = ACTIONS(444),
    [anon_sym_LT] = ACTIONS(444),
    [anon_sym_GT_EQ] = ACTIONS(442),
    [anon_sym_LT_EQ] = ACTIONS(442),
    [anon_sym_EQ_EQ] = ACTIONS(442),
    [anon_sym_BANG_EQ] = ACTIONS(442),
    [anon_sym_AMP_AMP] = ACTIONS(442),
    [anon_sym_PIPE_PIPE] = ACTIONS(442),
    [anon_sym_PLUS] = ACTIONS(444),
    [anon_sym_DASH] = ACTIONS(444),
    [anon_sym_STAR] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_PIPE] = ACTIONS(444),
    [anon_sym_CARET] = ACTIONS(442),
    [anon_sym_PERCENT] = ACTIONS(442),
    [anon_sym_LT_LT] = ACTIONS(442),
    [anon_sym_GT_GT] = ACTIONS(444),
    [anon_sym_GT_GT_GT] = ACTIONS(442),
    [anon_sym_instanceof] = ACTIONS(444),
    [anon_sym_final] = ACTIONS(444),
    [anon_sym_DASH_GT] = ACTIONS(442),
    [anon_sym_COMMA] = ACTIONS(442),
    [anon_sym_QMARK] = ACTIONS(442),
    [anon_sym_COLON] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(442),
    [anon_sym_DASH_DASH] = ACTIONS(442),
    [anon_sym_new] = ACTIONS(444),
    [anon_sym_RBRACK] = ACTIONS(442),
    [anon_sym_class] = ACTIONS(444),
    [anon_sym_switch] = ACTIONS(444),
    [anon_sym_LBRACE] = ACTIONS(442),
    [anon_sym_case] = ACTIONS(444),
    [anon_sym_default] = ACTIONS(444),
    [anon_sym_when] = ACTIONS(444),
    [anon_sym_SEMI] = ACTIONS(442),
    [anon_sym_assert] = ACTIONS(444),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_while] = ACTIONS(444),
    [anon_sym_break] = ACTIONS(444),
    [anon_sym_continue] = ACTIONS(444),
    [anon_sym_return] = ACTIONS(444),
    [anon_sym_yield] = ACTIONS(444),
    [anon_sym_synchronized] = ACTIONS(444),
    [anon_sym_throw] = ACTIONS(444),
    [anon_sym_try] = ACTIONS(444),
    [anon_sym_if] = ACTIONS(444),
    [anon_sym_else] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(444),
    [anon_sym_AT] = ACTIONS(444),
    [anon_sym_open] = ACTIONS(444),
    [anon_sym_module] = ACTIONS(444),
    [anon_sym_static] = ACTIONS(444),
    [anon_sym_with] = ACTIONS(444),
    [anon_sym_package] = ACTIONS(444),
    [anon_sym_import] = ACTIONS(444),
    [anon_sym_enum] = ACTIONS(444),
    [anon_sym_public] = ACTIONS(444),
    [anon_sym_protected] = ACTIONS(444),
    [anon_sym_private] = ACTIONS(444),
    [anon_sym_abstract] = ACTIONS(444),
    [anon_sym_strictfp] = ACTIONS(444),
    [anon_sym_native] = ACTIONS(444),
    [anon_sym_transient] = ACTIONS(444),
    [anon_sym_volatile] = ACTIONS(444),
    [anon_sym_sealed] = ACTIONS(444),
    [anon_sym_non_DASHsealed] = ACTIONS(442),
    [anon_sym_record] = ACTIONS(444),
    [anon_sym_ATinterface] = ACTIONS(442),
    [anon_sym_interface] = ACTIONS(444),
    [anon_sym_byte] = ACTIONS(444),
    [anon_sym_short] = ACTIONS(444),
    [anon_sym_int] = ACTIONS(444),
    [anon_sym_long] = ACTIONS(444),
    [anon_sym_char] = ACTIONS(444),
    [anon_sym_float] = ACTIONS(444),
    [anon_sym_double] = ACTIONS(444),
    [sym_boolean_type] = ACTIONS(444),
    [sym_void_type] = ACTIONS(444),
    [sym_this] = ACTIONS(444),
    [sym_super] = ACTIONS(444),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(446),
    [sym_identifier] = ACTIONS(448),
    [sym_decimal_integer_literal] = ACTIONS(448),
    [sym_hex_integer_literal] = ACTIONS(448),
    [sym_octal_integer_literal] = ACTIONS(448),
    [sym_binary_integer_literal] = ACTIONS(446),
    [sym_decimal_floating_point_literal] = ACTIONS(446),
    [sym_hex_floating_point_literal] = ACTIONS(448),
    [sym_true] = ACTIONS(448),
    [sym_false] = ACTIONS(448),
    [sym_character_literal] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(448),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(446),
    [anon_sym_RBRACE] = ACTIONS(446),
    [sym_null_literal] = ACTIONS(448),
    [anon_sym_LPAREN] = ACTIONS(446),
    [anon_sym_RPAREN] = ACTIONS(446),
    [anon_sym_AMP] = ACTIONS(448),
    [anon_sym_GT] = ACTIONS(448),
    [anon_sym_LT] = ACTIONS(448),
    [anon_sym_GT_EQ] = ACTIONS(446),
    [anon_sym_LT_EQ] = ACTIONS(446),
    [anon_sym_EQ_EQ] = ACTIONS(446),
    [anon_sym_BANG_EQ] = ACTIONS(446),
    [anon_sym_AMP_AMP] = ACTIONS(446),
    [anon_sym_PIPE_PIPE] = ACTIONS(446),
    [anon_sym_PLUS] = ACTIONS(448),
    [anon_sym_DASH] = ACTIONS(448),
    [anon_sym_STAR] = ACTIONS(446),
    [anon_sym_SLASH] = ACTIONS(448),
    [anon_sym_PIPE] = ACTIONS(448),
    [anon_sym_CARET] = ACTIONS(446),
    [anon_sym_PERCENT] = ACTIONS(446),
    [anon_sym_LT_LT] = ACTIONS(446),
    [anon_sym_GT_GT] = ACTIONS(448),
    [anon_sym_GT_GT_GT] = ACTIONS(446),
    [anon_sym_instanceof] = ACTIONS(448),
    [anon_sym_final] = ACTIONS(448),
    [anon_sym_DASH_GT] = ACTIONS(446),
    [anon_sym_COMMA] = ACTIONS(446),
    [anon_sym_QMARK] = ACTIONS(446),
    [anon_sym_COLON] = ACTIONS(446),
    [anon_sym_BANG] = ACTIONS(448),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_new] = ACTIONS(448),
    [anon_sym_RBRACK] = ACTIONS(446),
    [anon_sym_class] = ACTIONS(448),
    [anon_sym_switch] = ACTIONS(448),
    [anon_sym_LBRACE] = ACTIONS(446),
    [anon_sym_case] = ACTIONS(448),
    [anon_sym_default] = ACTIONS(448),
    [anon_sym_when] = ACTIONS(448),
    [anon_sym_SEMI] = ACTIONS(446),
    [anon_sym_assert] = ACTIONS(448),
    [anon_sym_do] = ACTIONS(448),
    [anon_sym_while] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(448),
    [anon_sym_continue] = ACTIONS(448),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_yield] = ACTIONS(448),
    [anon_sym_synchronized] = ACTIONS(448),
    [anon_sym_throw] = ACTIONS(448),
    [anon_sym_try] = ACTIONS(448),
    [anon_sym_if] = ACTIONS(448),
    [anon_sym_else] = ACTIONS(448),
    [anon_sym_for] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(448),
    [anon_sym_open] = ACTIONS(448),
    [anon_sym_module] = ACTIONS(448),
    [anon_sym_static] = ACTIONS(448),
    [anon_sym_with] = ACTIONS(448),
    [anon_sym_package] = ACTIONS(448),
    [anon_sym_import] = ACTIONS(448),
    [anon_sym_enum] = ACTIONS(448),
    [anon_sym_public] = ACTIONS(448),
    [anon_sym_protected] = ACTIONS(448),
    [anon_sym_private] = ACTIONS(448),
    [anon_sym_abstract] = ACTIONS(448),
    [anon_sym_strictfp] = ACTIONS(448),
    [anon_sym_native] = ACTIONS(448),
    [anon_sym_transient] = ACTIONS(448),
    [anon_sym_volatile] = ACTIONS(448),
    [anon_sym_sealed] = ACTIONS(448),
    [anon_sym_non_DASHsealed] = ACTIONS(446),
    [anon_sym_record] = ACTIONS(448),
    [anon_sym_ATinterface] = ACTIONS(446),
    [anon_sym_interface] = ACTIONS(448),
    [anon_sym_byte] = ACTIONS(448),
    [anon_sym_short] = ACTIONS(448),
    [anon_sym_int] = ACTIONS(448),
    [anon_sym_long] = ACTIONS(448),
    [anon_sym_char] = ACTIONS(448),
    [anon_sym_float] = ACTIONS(448),
    [anon_sym_double] = ACTIONS(448),
    [sym_boolean_type] = ACTIONS(448),
    [sym_void_type] = ACTIONS(448),
    [sym_this] = ACTIONS(448),
    [sym_super] = ACTIONS(448),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(450),
    [sym_identifier] = ACTIONS(452),
    [sym_decimal_integer_literal] = ACTIONS(452),
    [sym_hex_integer_literal] = ACTIONS(452),
    [sym_octal_integer_literal] = ACTIONS(452),
    [sym_binary_integer_literal] = ACTIONS(450),
    [sym_decimal_floating_point_literal] = ACTIONS(450),
    [sym_hex_floating_point_literal] = ACTIONS(452),
    [sym_true] = ACTIONS(452),
    [sym_false] = ACTIONS(452),
    [sym_character_literal] = ACTIONS(450),
    [anon_sym_DQUOTE] = ACTIONS(452),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(450),
    [anon_sym_RBRACE] = ACTIONS(450),
    [sym_null_literal] = ACTIONS(452),
    [anon_sym_LPAREN] = ACTIONS(450),
    [anon_sym_RPAREN] = ACTIONS(450),
    [anon_sym_AMP] = ACTIONS(452),
    [anon_sym_GT] = ACTIONS(452),
    [anon_sym_LT] = ACTIONS(452),
    [anon_sym_GT_EQ] = ACTIONS(450),
    [anon_sym_LT_EQ] = ACTIONS(450),
    [anon_sym_EQ_EQ] = ACTIONS(450),
    [anon_sym_BANG_EQ] = ACTIONS(450),
    [anon_sym_AMP_AMP] = ACTIONS(450),
    [anon_sym_PIPE_PIPE] = ACTIONS(450),
    [anon_sym_PLUS] = ACTIONS(452),
    [anon_sym_DASH] = ACTIONS(452),
    [anon_sym_STAR] = ACTIONS(450),
    [anon_sym_SLASH] = ACTIONS(452),
    [anon_sym_PIPE] = ACTIONS(452),
    [anon_sym_CARET] = ACTIONS(450),
    [anon_sym_PERCENT] = ACTIONS(450),
    [anon_sym_LT_LT] = ACTIONS(450),
    [anon_sym_GT_GT] = ACTIONS(452),
    [anon_sym_GT_GT_GT] = ACTIONS(450),
    [anon_sym_instanceof] = ACTIONS(452),
    [anon_sym_final] = ACTIONS(452),
    [anon_sym_DASH_GT] = ACTIONS(450),
    [anon_sym_COMMA] = ACTIONS(450),
    [anon_sym_QMARK] = ACTIONS(450),
    [anon_sym_COLON] = ACTIONS(450),
    [anon_sym_BANG] = ACTIONS(452),
    [anon_sym_TILDE] = ACTIONS(450),
    [anon_sym_PLUS_PLUS] = ACTIONS(450),
    [anon_sym_DASH_DASH] = ACTIONS(450),
    [anon_sym_new] = ACTIONS(452),
    [anon_sym_RBRACK] = ACTIONS(450),
    [anon_sym_class] = ACTIONS(452),
    [anon_sym_switch] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(450),
    [anon_sym_case] = ACTIONS(452),
    [anon_sym_default] = ACTIONS(452),
    [anon_sym_when] = ACTIONS(452),
    [anon_sym_SEMI] = ACTIONS(450),
    [anon_sym_assert] = ACTIONS(452),
    [anon_sym_do] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_break] = ACTIONS(452),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_return] = ACTIONS(452),
    [anon_sym_yield] = ACTIONS(452),
    [anon_sym_synchronized] = ACTIONS(452),
    [anon_sym_throw] = ACTIONS(452),
    [anon_sym_try] = ACTIONS(452),
    [anon_sym_if] = ACTIONS(452),
    [anon_sym_else] = ACTIONS(452),
    [anon_sym_for] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(452),
    [anon_sym_open] = ACTIONS(452),
    [anon_sym_module] = ACTIONS(452),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_with] = ACTIONS(452),
    [anon_sym_package] = ACTIONS(452),
    [anon_sym_import] = ACTIONS(452),
    [anon_sym_enum] = ACTIONS(452),
    [anon_sym_public] = ACTIONS(452),
    [anon_sym_protected] = ACTIONS(452),
    [anon_sym_private] = ACTIONS(452),
    [anon_sym_abstract] = ACTIONS(452),
    [anon_sym_strictfp] = ACTIONS(452),
    [anon_sym_native] = ACTIONS(452),
    [anon_sym_transient] = ACTIONS(452),
    [anon_sym_volatile] = ACTIONS(452),
    [anon_sym_sealed] = ACTIONS(452),
    [anon_sym_non_DASHsealed] = ACTIONS(450),
    [anon_sym_record] = ACTIONS(452),
    [anon_sym_ATinterface] = ACTIONS(450),
    [anon_sym_interface] = ACTIONS(452),
    [anon_sym_byte] = ACTIONS(452),
    [anon_sym_short] = ACTIONS(452),
    [anon_sym_int] = ACTIONS(452),
    [anon_sym_long] = ACTIONS(452),
    [anon_sym_char] = ACTIONS(452),
    [anon_sym_float] = ACTIONS(452),
    [anon_sym_double] = ACTIONS(452),
    [sym_boolean_type] = ACTIONS(452),
    [sym_void_type] = ACTIONS(452),
    [sym_this] = ACTIONS(452),
    [sym_super] = ACTIONS(452),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [114] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(742),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(692),
    [sym_marker_annotation] = STATE(692),
    [sym_annotation] = STATE(692),
    [sym_modifiers] = STATE(836),
    [sym__type] = STATE(1028),
    [sym__unannotated_type] = STATE(694),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_formal_parameter] = STATE(1140),
    [sym_receiver_parameter] = STATE(1207),
    [sym_spread_parameter] = STATE(1140),
    [sym__reserved_identifier] = STATE(443),
    [aux_sym_array_creation_expression_repeat1] = STATE(794),
    [aux_sym_modifiers_repeat1] = STATE(626),
    [sym_identifier] = ACTIONS(454),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(456),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [115] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(742),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(692),
    [sym_marker_annotation] = STATE(692),
    [sym_annotation] = STATE(692),
    [sym_modifiers] = STATE(836),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(694),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_formal_parameter] = STATE(1140),
    [sym_receiver_parameter] = STATE(1207),
    [sym_spread_parameter] = STATE(1140),
    [sym__reserved_identifier] = STATE(443),
    [aux_sym_array_creation_expression_repeat1] = STATE(794),
    [aux_sym_modifiers_repeat1] = STATE(626),
    [sym_identifier] = ACTIONS(466),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(456),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [116] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(742),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(692),
    [sym_marker_annotation] = STATE(692),
    [sym_annotation] = STATE(692),
    [sym_modifiers] = STATE(836),
    [sym__type] = STATE(1032),
    [sym__unannotated_type] = STATE(694),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_formal_parameter] = STATE(1140),
    [sym_receiver_parameter] = STATE(1207),
    [sym_spread_parameter] = STATE(1140),
    [sym__reserved_identifier] = STATE(443),
    [aux_sym_array_creation_expression_repeat1] = STATE(794),
    [aux_sym_modifiers_repeat1] = STATE(626),
    [sym_identifier] = ACTIONS(454),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(456),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [117] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(669),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(692),
    [sym_marker_annotation] = STATE(692),
    [sym_annotation] = STATE(692),
    [sym_modifiers] = STATE(835),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(770),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(178),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [aux_sym_modifiers_repeat1] = STATE(626),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [118] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(676),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(692),
    [sym_marker_annotation] = STATE(692),
    [sym_annotation] = STATE(692),
    [sym_modifiers] = STATE(831),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(772),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(154),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [aux_sym_modifiers_repeat1] = STATE(626),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(470),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [119] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(684),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(692),
    [sym_marker_annotation] = STATE(692),
    [sym_annotation] = STATE(692),
    [sym_modifiers] = STATE(832),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(768),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym_local_variable_declaration] = STATE(166),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [aux_sym_modifiers_repeat1] = STATE(626),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(472),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_identifier] = ACTIONS(474),
    [sym_decimal_integer_literal] = ACTIONS(474),
    [sym_hex_integer_literal] = ACTIONS(474),
    [sym_octal_integer_literal] = ACTIONS(474),
    [sym_binary_integer_literal] = ACTIONS(476),
    [sym_decimal_floating_point_literal] = ACTIONS(476),
    [sym_hex_floating_point_literal] = ACTIONS(474),
    [sym_true] = ACTIONS(474),
    [sym_false] = ACTIONS(474),
    [sym_character_literal] = ACTIONS(476),
    [anon_sym_DQUOTE] = ACTIONS(474),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(476),
    [anon_sym_RBRACE] = ACTIONS(476),
    [sym_null_literal] = ACTIONS(474),
    [anon_sym_LPAREN] = ACTIONS(476),
    [anon_sym_AMP] = ACTIONS(478),
    [anon_sym_GT] = ACTIONS(478),
    [anon_sym_LT] = ACTIONS(478),
    [anon_sym_GT_EQ] = ACTIONS(480),
    [anon_sym_LT_EQ] = ACTIONS(480),
    [anon_sym_EQ_EQ] = ACTIONS(480),
    [anon_sym_BANG_EQ] = ACTIONS(480),
    [anon_sym_AMP_AMP] = ACTIONS(480),
    [anon_sym_PIPE_PIPE] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(482),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_STAR] = ACTIONS(480),
    [anon_sym_SLASH] = ACTIONS(478),
    [anon_sym_PIPE] = ACTIONS(478),
    [anon_sym_CARET] = ACTIONS(480),
    [anon_sym_PERCENT] = ACTIONS(480),
    [anon_sym_LT_LT] = ACTIONS(480),
    [anon_sym_GT_GT] = ACTIONS(478),
    [anon_sym_GT_GT_GT] = ACTIONS(480),
    [anon_sym_instanceof] = ACTIONS(478),
    [anon_sym_final] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(480),
    [anon_sym_BANG] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_new] = ACTIONS(474),
    [anon_sym_class] = ACTIONS(474),
    [anon_sym_switch] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(476),
    [anon_sym_case] = ACTIONS(474),
    [anon_sym_default] = ACTIONS(474),
    [anon_sym_SEMI] = ACTIONS(485),
    [anon_sym_assert] = ACTIONS(474),
    [anon_sym_do] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_break] = ACTIONS(474),
    [anon_sym_continue] = ACTIONS(474),
    [anon_sym_return] = ACTIONS(474),
    [anon_sym_yield] = ACTIONS(474),
    [anon_sym_synchronized] = ACTIONS(474),
    [anon_sym_throw] = ACTIONS(474),
    [anon_sym_try] = ACTIONS(474),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_else] = ACTIONS(474),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_AT] = ACTIONS(474),
    [anon_sym_open] = ACTIONS(474),
    [anon_sym_module] = ACTIONS(474),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_with] = ACTIONS(474),
    [anon_sym_package] = ACTIONS(474),
    [anon_sym_import] = ACTIONS(474),
    [anon_sym_enum] = ACTIONS(474),
    [anon_sym_public] = ACTIONS(474),
    [anon_sym_protected] = ACTIONS(474),
    [anon_sym_private] = ACTIONS(474),
    [anon_sym_abstract] = ACTIONS(474),
    [anon_sym_strictfp] = ACTIONS(474),
    [anon_sym_native] = ACTIONS(474),
    [anon_sym_transient] = ACTIONS(474),
    [anon_sym_volatile] = ACTIONS(474),
    [anon_sym_sealed] = ACTIONS(474),
    [anon_sym_non_DASHsealed] = ACTIONS(476),
    [anon_sym_record] = ACTIONS(474),
    [anon_sym_ATinterface] = ACTIONS(476),
    [anon_sym_interface] = ACTIONS(474),
    [anon_sym_byte] = ACTIONS(474),
    [anon_sym_short] = ACTIONS(474),
    [anon_sym_int] = ACTIONS(474),
    [anon_sym_long] = ACTIONS(474),
    [anon_sym_char] = ACTIONS(474),
    [anon_sym_float] = ACTIONS(474),
    [anon_sym_double] = ACTIONS(474),
    [sym_boolean_type] = ACTIONS(474),
    [sym_void_type] = ACTIONS(474),
    [sym_this] = ACTIONS(474),
    [sym_super] = ACTIONS(474),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(476),
    [sym_identifier] = ACTIONS(474),
    [sym_decimal_integer_literal] = ACTIONS(474),
    [sym_hex_integer_literal] = ACTIONS(474),
    [sym_octal_integer_literal] = ACTIONS(474),
    [sym_binary_integer_literal] = ACTIONS(476),
    [sym_decimal_floating_point_literal] = ACTIONS(476),
    [sym_hex_floating_point_literal] = ACTIONS(474),
    [sym_true] = ACTIONS(474),
    [sym_false] = ACTIONS(474),
    [sym_character_literal] = ACTIONS(476),
    [anon_sym_DQUOTE] = ACTIONS(474),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(476),
    [sym_null_literal] = ACTIONS(474),
    [anon_sym_LPAREN] = ACTIONS(476),
    [anon_sym_AMP] = ACTIONS(478),
    [anon_sym_GT] = ACTIONS(478),
    [anon_sym_LT] = ACTIONS(482),
    [anon_sym_GT_EQ] = ACTIONS(480),
    [anon_sym_LT_EQ] = ACTIONS(480),
    [anon_sym_EQ_EQ] = ACTIONS(480),
    [anon_sym_BANG_EQ] = ACTIONS(480),
    [anon_sym_AMP_AMP] = ACTIONS(480),
    [anon_sym_PIPE_PIPE] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(482),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_STAR] = ACTIONS(480),
    [anon_sym_SLASH] = ACTIONS(478),
    [anon_sym_PIPE] = ACTIONS(478),
    [anon_sym_CARET] = ACTIONS(480),
    [anon_sym_PERCENT] = ACTIONS(480),
    [anon_sym_LT_LT] = ACTIONS(480),
    [anon_sym_GT_GT] = ACTIONS(478),
    [anon_sym_GT_GT_GT] = ACTIONS(480),
    [anon_sym_instanceof] = ACTIONS(478),
    [anon_sym_final] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(480),
    [anon_sym_BANG] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_new] = ACTIONS(474),
    [anon_sym_class] = ACTIONS(474),
    [anon_sym_switch] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(476),
    [anon_sym_default] = ACTIONS(474),
    [anon_sym_SEMI] = ACTIONS(485),
    [anon_sym_assert] = ACTIONS(474),
    [anon_sym_do] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_break] = ACTIONS(474),
    [anon_sym_continue] = ACTIONS(474),
    [anon_sym_return] = ACTIONS(474),
    [anon_sym_yield] = ACTIONS(474),
    [anon_sym_synchronized] = ACTIONS(474),
    [anon_sym_throw] = ACTIONS(474),
    [anon_sym_try] = ACTIONS(474),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_else] = ACTIONS(474),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_AT] = ACTIONS(474),
    [anon_sym_open] = ACTIONS(474),
    [anon_sym_module] = ACTIONS(474),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_with] = ACTIONS(474),
    [anon_sym_package] = ACTIONS(474),
    [anon_sym_import] = ACTIONS(474),
    [anon_sym_enum] = ACTIONS(474),
    [anon_sym_public] = ACTIONS(474),
    [anon_sym_protected] = ACTIONS(474),
    [anon_sym_private] = ACTIONS(474),
    [anon_sym_abstract] = ACTIONS(474),
    [anon_sym_strictfp] = ACTIONS(474),
    [anon_sym_native] = ACTIONS(474),
    [anon_sym_transient] = ACTIONS(474),
    [anon_sym_volatile] = ACTIONS(474),
    [anon_sym_sealed] = ACTIONS(474),
    [anon_sym_non_DASHsealed] = ACTIONS(476),
    [anon_sym_record] = ACTIONS(474),
    [anon_sym_ATinterface] = ACTIONS(476),
    [anon_sym_interface] = ACTIONS(474),
    [anon_sym_byte] = ACTIONS(474),
    [anon_sym_short] = ACTIONS(474),
    [anon_sym_int] = ACTIONS(474),
    [anon_sym_long] = ACTIONS(474),
    [anon_sym_char] = ACTIONS(474),
    [anon_sym_float] = ACTIONS(474),
    [anon_sym_double] = ACTIONS(474),
    [sym_boolean_type] = ACTIONS(474),
    [sym_void_type] = ACTIONS(474),
    [sym_this] = ACTIONS(474),
    [sym_super] = ACTIONS(474),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [122] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(650),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(847),
    [sym_marker_annotation] = STATE(847),
    [sym_annotation] = STATE(847),
    [sym_element_value_pair] = STATE(1166),
    [sym__element_value] = STATE(1371),
    [sym_element_value_array_initializer] = STATE(1371),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(488),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(490),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [123] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(650),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(847),
    [sym_marker_annotation] = STATE(847),
    [sym_annotation] = STATE(847),
    [sym_element_value_pair] = STATE(1134),
    [sym__element_value] = STATE(1330),
    [sym_element_value_array_initializer] = STATE(1330),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(488),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(494),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [124] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(650),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(847),
    [sym_marker_annotation] = STATE(847),
    [sym_annotation] = STATE(847),
    [sym_element_value_pair] = STATE(1172),
    [sym__element_value] = STATE(1348),
    [sym_element_value_array_initializer] = STATE(1348),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(488),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_RPAREN] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [125] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(650),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(847),
    [sym_marker_annotation] = STATE(847),
    [sym_annotation] = STATE(847),
    [sym__element_value] = STATE(1128),
    [sym_element_value_array_initializer] = STATE(1128),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(498),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [126] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(748),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym_block] = STATE(1090),
    [sym_expression_statement] = STATE(1090),
    [sym_throw_statement] = STATE(1090),
    [sym__annotation] = STATE(775),
    [sym_marker_annotation] = STATE(775),
    [sym_annotation] = STATE(775),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(35),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_throw] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [127] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(673),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(775),
    [sym_marker_annotation] = STATE(775),
    [sym_annotation] = STATE(775),
    [sym_array_initializer] = STATE(1145),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(502),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(504),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(506),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [128] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(650),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_array_creation_expression] = STATE(574),
    [sym_parenthesized_expression] = STATE(574),
    [sym_class_literal] = STATE(574),
    [sym_object_creation_expression] = STATE(574),
    [sym__unqualified_object_creation_expression] = STATE(546),
    [sym_field_access] = STATE(440),
    [sym_template_expression] = STATE(574),
    [sym_array_access] = STATE(440),
    [sym_method_invocation] = STATE(574),
    [sym_method_reference] = STATE(574),
    [sym_switch_expression] = STATE(594),
    [sym__annotation] = STATE(847),
    [sym_marker_annotation] = STATE(847),
    [sym_annotation] = STATE(847),
    [sym__element_value] = STATE(1211),
    [sym_element_value_array_initializer] = STATE(1211),
    [sym__type] = STATE(1359),
    [sym__unannotated_type] = STATE(899),
    [sym_annotated_type] = STATE(908),
    [sym_scoped_type_identifier] = STATE(818),
    [sym_generic_type] = STATE(840),
    [sym_array_type] = STATE(758),
    [sym_integral_type] = STATE(758),
    [sym_floating_point_type] = STATE(758),
    [sym_formal_parameters] = STATE(1360),
    [sym__reserved_identifier] = STATE(430),
    [aux_sym_array_creation_expression_repeat1] = STATE(775),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(9),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(508),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(17),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_PLUS_PLUS] = ACTIONS(27),
    [anon_sym_DASH_DASH] = ACTIONS(27),
    [anon_sym_new] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_yield] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(69),
    [anon_sym_module] = ACTIONS(69),
    [anon_sym_with] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(87),
    [anon_sym_short] = ACTIONS(87),
    [anon_sym_int] = ACTIONS(87),
    [anon_sym_long] = ACTIONS(87),
    [anon_sym_char] = ACTIONS(87),
    [anon_sym_float] = ACTIONS(89),
    [anon_sym_double] = ACTIONS(89),
    [sym_boolean_type] = ACTIONS(91),
    [sym_void_type] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [129] = {
    [sym__literal] = STATE(574),
    [sym_string_literal] = STATE(522),
    [sym__string_literal] = STATE(526),
    [sym__multiline_string_literal] = STATE(526),
    [sym_expression] = STATE(664),
    [sym_cast_expression] = STATE(594),
    [sym_assignment_expression] = STATE(594),
    [sym_binary_expression] = STATE(594),
    [sym_instanceof_expression] = STATE(594),
    [sym_lambda_expression] = STATE(594),
    [sym_inferred_parameters] = STATE(1360),
    [sym_ternary_expression] = STATE(594),
    [sym_unary_expression] = STATE(594),
    [sym_update_expression] =