#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 8560
#define LARGE_STATE_COUNT 2329
#define SYMBOL_COUNT 477
#define ALIAS_COUNT 5
#define TOKEN_COUNT 200
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 47
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 211

enum {
  sym_identifier = 1,
  aux_sym_preproc_include_token1 = 2,
  aux_sym_preproc_include_token2 = 3,
  aux_sym_preproc_def_token1 = 4,
  anon_sym_LPAREN = 5,
  anon_sym_DOT_DOT_DOT = 6,
  anon_sym_COMMA = 7,
  anon_sym_RPAREN = 8,
  aux_sym_preproc_if_token1 = 9,
  anon_sym_LF = 10,
  aux_sym_preproc_if_token2 = 11,
  aux_sym_preproc_ifdef_token1 = 12,
  aux_sym_preproc_ifdef_token2 = 13,
  aux_sym_preproc_else_token1 = 14,
  aux_sym_preproc_elif_token1 = 15,
  aux_sym_preproc_elifdef_token1 = 16,
  aux_sym_preproc_elifdef_token2 = 17,
  sym_preproc_arg = 18,
  sym_preproc_directive = 19,
  anon_sym_LPAREN2 = 20,
  anon_sym_defined = 21,
  anon_sym_BANG = 22,
  anon_sym_TILDE = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_STAR = 26,
  anon_sym_SLASH = 27,
  anon_sym_PERCENT = 28,
  anon_sym_PIPE_PIPE = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE = 31,
  anon_sym_CARET = 32,
  anon_sym_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_GT = 36,
  anon_sym_GT_EQ = 37,
  anon_sym_LT_EQ = 38,
  anon_sym_LT = 39,
  anon_sym_LT_LT = 40,
  anon_sym_GT_GT = 41,
  anon_sym_SEMI = 42,
  anon_sym_typedef = 43,
  anon_sym_extern = 44,
  anon_sym___attribute__ = 45,
  anon_sym_COLON_COLON = 46,
  anon_sym_LBRACK_LBRACK = 47,
  anon_sym_RBRACK_RBRACK = 48,
  anon_sym___declspec = 49,
  anon_sym___based = 50,
  anon_sym___cdecl = 51,
  anon_sym___clrcall = 52,
  anon_sym___stdcall = 53,
  anon_sym___fastcall = 54,
  anon_sym___thiscall = 55,
  anon_sym___vectorcall = 56,
  sym_ms_restrict_modifier = 57,
  sym_ms_unsigned_ptr_modifier = 58,
  sym_ms_signed_ptr_modifier = 59,
  anon_sym__unaligned = 60,
  anon_sym___unaligned = 61,
  anon_sym_LBRACE = 62,
  anon_sym_RBRACE = 63,
  anon_sym_signed = 64,
  anon_sym_unsigned = 65,
  anon_sym_long = 66,
  anon_sym_short = 67,
  anon_sym_LBRACK = 68,
  anon_sym_RBRACK = 69,
  anon_sym_EQ = 70,
  anon_sym_static = 71,
  anon_sym_register = 72,
  anon_sym_inline = 73,
  anon_sym_thread_local = 74,
  anon_sym_const = 75,
  anon_sym_constexpr = 76,
  anon_sym_volatile = 77,
  anon_sym_restrict = 78,
  anon_sym___restrict__ = 79,
  anon_sym__Atomic = 80,
  anon_sym__Noreturn = 81,
  anon_sym_noreturn = 82,
  anon_sym_mutable = 83,
  anon_sym_constinit = 84,
  anon_sym_consteval = 85,
  sym_primitive_type = 86,
  anon_sym_enum = 87,
  anon_sym_class = 88,
  anon_sym_struct = 89,
  anon_sym_union = 90,
  anon_sym_COLON = 91,
  anon_sym_if = 92,
  anon_sym_else = 93,
  anon_sym_switch = 94,
  anon_sym_case = 95,
  anon_sym_default = 96,
  anon_sym_while = 97,
  anon_sym_do = 98,
  anon_sym_for = 99,
  anon_sym_return = 100,
  anon_sym_break = 101,
  anon_sym_continue = 102,
  anon_sym_goto = 103,
  anon_sym_QMARK = 104,
  anon_sym_STAR_EQ = 105,
  anon_sym_SLASH_EQ = 106,
  anon_sym_PERCENT_EQ = 107,
  anon_sym_PLUS_EQ = 108,
  anon_sym_DASH_EQ = 109,
  anon_sym_LT_LT_EQ = 110,
  anon_sym_GT_GT_EQ = 111,
  anon_sym_AMP_EQ = 112,
  anon_sym_CARET_EQ = 113,
  anon_sym_PIPE_EQ = 114,
  anon_sym_and_eq = 115,
  anon_sym_or_eq = 116,
  anon_sym_xor_eq = 117,
  anon_sym_not = 118,
  anon_sym_compl = 119,
  anon_sym_LT_EQ_GT = 120,
  anon_sym_or = 121,
  anon_sym_and = 122,
  anon_sym_bitor = 123,
  anon_sym_xor = 124,
  anon_sym_bitand = 125,
  anon_sym_not_eq = 126,
  anon_sym_DASH_DASH = 127,
  anon_sym_PLUS_PLUS = 128,
  anon_sym_sizeof = 129,
  anon_sym_offsetof = 130,
  anon_sym__Generic = 131,
  anon_sym_asm = 132,
  anon_sym___asm__ = 133,
  anon_sym_DOT = 134,
  anon_sym_DOT_STAR = 135,
  anon_sym_DASH_GT = 136,
  sym_number_literal = 137,
  anon_sym_L_SQUOTE = 138,
  anon_sym_u_SQUOTE = 139,
  anon_sym_U_SQUOTE = 140,
  anon_sym_u8_SQUOTE = 141,
  anon_sym_SQUOTE = 142,
  aux_sym_char_literal_token1 = 143,
  anon_sym_L_DQUOTE = 144,
  anon_sym_u_DQUOTE = 145,
  anon_sym_U_DQUOTE = 146,
  anon_sym_u8_DQUOTE = 147,
  anon_sym_DQUOTE = 148,
  aux_sym_string_literal_token1 = 149,
  sym_escape_sequence = 150,
  sym_system_lib_string = 151,
  sym_true = 152,
  sym_false = 153,
  anon_sym_NULL = 154,
  anon_sym_nullptr = 155,
  sym_comment = 156,
  sym_auto = 157,
  anon_sym_decltype = 158,
  anon_sym_final = 159,
  anon_sym_override = 160,
  anon_sym_virtual = 161,
  anon_sym_alignas = 162,
  anon_sym_explicit = 163,
  anon_sym_typename = 164,
  anon_sym_template = 165,
  anon_sym_GT2 = 166,
  anon_sym_operator = 167,
  anon_sym_try = 168,
  anon_sym_delete = 169,
  anon_sym_friend = 170,
  anon_sym_public = 171,
  anon_sym_private = 172,
  anon_sym_protected = 173,
  anon_sym_noexcept = 174,
  anon_sym_throw = 175,
  anon_sym_namespace = 176,
  anon_sym_using = 177,
  anon_sym_static_assert = 178,
  anon_sym_concept = 179,
  anon_sym_co_return = 180,
  anon_sym_co_yield = 181,
  anon_sym_catch = 182,
  anon_sym_R_DQUOTE = 183,
  anon_sym_LR_DQUOTE = 184,
  anon_sym_uR_DQUOTE = 185,
  anon_sym_UR_DQUOTE = 186,
  anon_sym_u8R_DQUOTE = 187,
  anon_sym_co_await = 188,
  anon_sym_new = 189,
  anon_sym_requires = 190,
  anon_sym_DASH_GT_STAR = 191,
  anon_sym_alignof = 192,
  anon_sym_LPAREN_RPAREN = 193,
  anon_sym_LBRACK_RBRACK = 194,
  anon_sym_DQUOTE_DQUOTE = 195,
  sym_this = 196,
  sym_literal_suffix = 197,
  sym_raw_string_delimiter = 198,
  sym_raw_string_content = 199,
  sym_translation_unit = 200,
  sym_preproc_include = 201,
  sym_preproc_def = 202,
  sym_preproc_function_def = 203,
  sym_preproc_params = 204,
  sym_preproc_call = 205,
  sym_preproc_if = 206,
  sym_preproc_ifdef = 207,
  sym_preproc_else = 208,
  sym_preproc_elif = 209,
  sym_preproc_elifdef = 210,
  sym_preproc_if_in_field_declaration_list = 211,
  sym_preproc_ifdef_in_field_declaration_list = 212,
  sym_preproc_else_in_field_declaration_list = 213,
  sym_preproc_elif_in_field_declaration_list = 214,
  sym__preproc_expression = 215,
  sym_preproc_parenthesized_expression = 216,
  sym_preproc_defined = 217,
  sym_preproc_unary_expression = 218,
  sym_preproc_call_expression = 219,
  sym_preproc_argument_list = 220,
  sym_preproc_binary_expression = 221,
  sym_function_definition = 222,
  sym_declaration = 223,
  sym_type_definition = 224,
  sym__declaration_modifiers = 225,
  sym__declaration_specifiers = 226,
  sym_linkage_specification = 227,
  sym_attribute_specifier = 228,
  sym_attribute = 229,
  sym_attribute_declaration = 230,
  sym_ms_declspec_modifier = 231,
  sym_ms_based_modifier = 232,
  sym_ms_call_modifier = 233,
  sym_ms_unaligned_ptr_modifier = 234,
  sym_ms_pointer_modifier = 235,
  sym_declaration_list = 236,
  sym__declarator = 237,
  sym__field_declarator = 238,
  sym__type_declarator = 239,
  sym__abstract_declarator = 240,
  sym_parenthesized_declarator = 241,
  sym_parenthesized_field_declarator = 242,
  sym_parenthesized_type_declarator = 243,
  sym_abstract_parenthesized_declarator = 244,
  sym_attributed_declarator = 245,
  sym_attributed_field_declarator = 246,
  sym_attributed_type_declarator = 247,
  sym_pointer_declarator = 248,
  sym_pointer_field_declarator = 249,
  sym_pointer_type_declarator = 250,
  sym_abstract_pointer_declarator = 251,
  sym_function_declarator = 252,
  sym_function_field_declarator = 253,
  sym_function_type_declarator = 254,
  sym_abstract_function_declarator = 255,
  sym_array_declarator = 256,
  sym_array_field_declarator = 257,
  sym_array_type_declarator = 258,
  sym_abstract_array_declarator = 259,
  sym_init_declarator = 260,
  sym_compound_statement = 261,
  sym_storage_class_specifier = 262,
  sym_type_qualifier = 263,
  sym__type_specifier = 264,
  sym_sized_type_specifier = 265,
  sym_enum_specifier = 266,
  sym_enumerator_list = 267,
  sym_struct_specifier = 268,
  sym_union_specifier = 269,
  sym_field_declaration_list = 270,
  sym__field_declaration_list_item = 271,
  sym_field_declaration = 272,
  sym_bitfield_clause = 273,
  sym_enumerator = 274,
  sym_parameter_list = 275,
  sym_parameter_declaration = 276,
  sym_attributed_statement = 277,
  sym_labeled_statement = 278,
  sym__top_level_expression_statement = 279,
  sym_expression_statement = 280,
  sym_if_statement = 281,
  sym_else_clause = 282,
  sym_switch_statement = 283,
  sym_case_statement = 284,
  sym_while_statement = 285,
  sym_do_statement = 286,
  sym_for_statement = 287,
  sym_return_statement = 288,
  sym_break_statement = 289,
  sym_continue_statement = 290,
  sym_goto_statement = 291,
  sym__expression = 292,
  sym__expression_not_binary = 293,
  sym_comma_expression = 294,
  sym_conditional_expression = 295,
  sym_assignment_expression = 296,
  sym_pointer_expression = 297,
  sym_unary_expression = 298,
  sym_binary_expression = 299,
  sym_update_expression = 300,
  sym_cast_expression = 301,
  sym_type_descriptor = 302,
  sym_sizeof_expression = 303,
  sym_offsetof_expression = 304,
  sym_generic_expression = 305,
  sym_subscript_expression = 306,
  sym_call_expression = 307,
  sym_gnu_asm_expression = 308,
  sym_gnu_asm_qualifier = 309,
  sym_gnu_asm_output_operand_list = 310,
  sym_gnu_asm_output_operand = 311,
  sym_gnu_asm_input_operand_list = 312,
  sym_gnu_asm_input_operand = 313,
  sym_gnu_asm_clobber_list = 314,
  sym_gnu_asm_goto_list = 315,
  sym_argument_list = 316,
  sym_field_expression = 317,
  sym_compound_literal_expression = 318,
  sym_parenthesized_expression = 319,
  sym_initializer_list = 320,
  sym_initializer_pair = 321,
  sym_subscript_designator = 322,
  sym_field_designator = 323,
  sym_char_literal = 324,
  sym_concatenated_string = 325,
  sym_string_literal = 326,
  sym_null = 327,
  sym__empty_declaration = 328,
  sym_placeholder_type_specifier = 329,
  sym_decltype_auto = 330,
  sym_decltype = 331,
  sym__class_declaration = 332,
  sym_class_specifier = 333,
  sym__class_name = 334,
  sym_virtual_specifier = 335,
  sym_virtual = 336,
  sym_alignas_specifier = 337,
  sym_explicit_function_specifier = 338,
  sym_base_class_clause = 339,
  sym__enum_base_clause = 340,
  sym_dependent_type = 341,
  sym_template_declaration = 342,
  sym_template_instantiation = 343,
  sym_template_parameter_list = 344,
  sym_type_parameter_declaration = 345,
  sym_variadic_type_parameter_declaration = 346,
  sym_optional_type_parameter_declaration = 347,
  sym_template_template_parameter_declaration = 348,
  sym_optional_parameter_declaration = 349,
  sym_variadic_parameter_declaration = 350,
  sym_variadic_declarator = 351,
  sym_variadic_reference_declarator = 352,
  sym_operator_cast = 353,
  sym_field_initializer_list = 354,
  sym_field_initializer = 355,
  sym_inline_method_definition = 356,
  sym__constructor_specifiers = 357,
  sym_operator_cast_definition = 358,
  sym_operator_cast_declaration = 359,
  sym_constructor_try_statement = 360,
  sym_constructor_or_destructor_definition = 361,
  sym_constructor_or_destructor_declaration = 362,
  sym_default_method_clause = 363,
  sym_delete_method_clause = 364,
  sym_friend_declaration = 365,
  sym_access_specifier = 366,
  sym_reference_declarator = 367,
  sym_reference_field_declarator = 368,
  sym_abstract_reference_declarator = 369,
  sym_structured_binding_declarator = 370,
  sym_ref_qualifier = 371,
  sym__function_declarator_seq = 372,
  sym_trailing_return_type = 373,
  sym_noexcept = 374,
  sym_throw_specifier = 375,
  sym_template_type = 376,
  sym_template_method = 377,
  sym_template_function = 378,
  sym_template_argument_list = 379,
  sym_namespace_definition = 380,
  sym_namespace_alias_definition = 381,
  sym__namespace_specifier = 382,
  sym_nested_namespace_specifier = 383,
  sym_using_declaration = 384,
  sym_alias_declaration = 385,
  sym_static_assert_declaration = 386,
  sym_concept_definition = 387,
  sym_for_range_loop = 388,
  sym_init_statement = 389,
  sym_condition_clause = 390,
  sym_condition_declaration = 391,
  sym_co_return_statement = 392,
  sym_co_yield_statement = 393,
  sym_throw_statement = 394,
  sym_try_statement = 395,
  sym_catch_clause = 396,
  sym_raw_string_literal = 397,
  sym_co_await_expression = 398,
  sym_new_expression = 399,
  sym_new_declarator = 400,
  sym_delete_expression = 401,
  sym_type_requirement = 402,
  sym_compound_requirement = 403,
  sym__requirement = 404,
  sym_requirement_seq = 405,
  sym_constraint_conjunction = 406,
  sym_constraint_disjunction = 407,
  sym__requirement_clause_constraint = 408,
  sym_requires_clause = 409,
  sym_requires_parameter_list = 410,
  sym_requires_expression = 411,
  sym_lambda_expression = 412,
  sym_lambda_capture_specifier = 413,
  sym_lambda_default_capture = 414,
  sym__fold_operator = 415,
  sym__binary_fold_operator = 416,
  sym__unary_left_fold = 417,
  sym__unary_right_fold = 418,
  sym__binary_fold = 419,
  sym_fold_expression = 420,
  sym_parameter_pack_expansion = 421,
  sym_type_parameter_pack_expansion = 422,
  sym_alignof_expression = 423,
  sym_destructor_name = 424,
  sym_dependent_identifier = 425,
  sym_dependent_field_identifier = 426,
  sym_dependent_type_identifier = 427,
  sym__scope_resolution = 428,
  sym_qualified_field_identifier = 429,
  sym_qualified_identifier = 430,
  sym_qualified_type_identifier = 431,
  sym_qualified_operator_cast_identifier = 432,
  sym_operator_name = 433,
  sym_user_defined_literal = 434,
  aux_sym_translation_unit_repeat1 = 435,
  aux_sym_preproc_params_repeat1 = 436,
  aux_sym_preproc_if_repeat1 = 437,
  aux_sym_preproc_if_in_field_declaration_list_repeat1 = 438,
  aux_sym_preproc_argument_list_repeat1 = 439,
  aux_sym_declaration_repeat1 = 440,
  aux_sym_type_definition_repeat1 = 441,
  aux_sym_type_definition_repeat2 = 442,
  aux_sym__declaration_specifiers_repeat1 = 443,
  aux_sym_attribute_declaration_repeat1 = 444,
  aux_sym_attributed_declarator_repeat1 = 445,
  aux_sym_pointer_declarator_repeat1 = 446,
  aux_sym_sized_type_specifier_repeat1 = 447,
  aux_sym_enumerator_list_repeat1 = 448,
  aux_sym_field_declaration_repeat1 = 449,
  aux_sym_parameter_list_repeat1 = 450,
  aux_sym_case_statement_repeat1 = 451,
  aux_sym_generic_expression_repeat1 = 452,
  aux_sym_gnu_asm_expression_repeat1 = 453,
  aux_sym_gnu_asm_output_operand_list_repeat1 = 454,
  aux_sym_gnu_asm_input_operand_list_repeat1 = 455,
  aux_sym_gnu_asm_clobber_list_repeat1 = 456,
  aux_sym_gnu_asm_goto_list_repeat1 = 457,
  aux_sym_argument_list_repeat1 = 458,
  aux_sym_initializer_list_repeat1 = 459,
  aux_sym_initializer_pair_repeat1 = 460,
  aux_sym_concatenated_string_repeat1 = 461,
  aux_sym_string_literal_repeat1 = 462,
  aux_sym__class_declaration_repeat1 = 463,
  aux_sym_base_class_clause_repeat1 = 464,
  aux_sym_template_parameter_list_repeat1 = 465,
  aux_sym_field_initializer_list_repeat1 = 466,
  aux_sym_operator_cast_definition_repeat1 = 467,
  aux_sym_constructor_try_statement_repeat1 = 468,
  aux_sym_structured_binding_declarator_repeat1 = 469,
  aux_sym__function_declarator_seq_repeat1 = 470,
  aux_sym__function_declarator_seq_repeat2 = 471,
  aux_sym_throw_specifier_repeat1 = 472,
  aux_sym_template_argument_list_repeat1 = 473,
  aux_sym_requirement_seq_repeat1 = 474,
  aux_sym_requires_parameter_list_repeat1 = 475,
  aux_sym_lambda_capture_specifier_repeat1 = 476,
  alias_sym_field_identifier = 477,
  alias_sym_namespace_identifier = 478,
  alias_sym_simple_requirement = 479,
  alias_sym_statement_identifier = 480,
  alias_sym_type_identifier = 481,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_preproc_include_token1] = "#include",
  [aux_sym_preproc_include_token2] = "preproc_include_token2",
  [aux_sym_preproc_def_token1] = "#define",
  [anon_sym_LPAREN] = "(",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_preproc_if_token1] = "#if",
  [anon_sym_LF] = "\n",
  [aux_sym_preproc_if_token2] = "#endif",
  [aux_sym_preproc_ifdef_token1] = "#ifdef",
  [aux_sym_preproc_ifdef_token2] = "#ifndef",
  [aux_sym_preproc_else_token1] = "#else",
  [aux_sym_preproc_elif_token1] = "#elif",
  [aux_sym_preproc_elifdef_token1] = "#elifdef",
  [aux_sym_preproc_elifdef_token2] = "#elifndef",
  [sym_preproc_arg] = "preproc_arg",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_defined] = "defined",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_SEMI] = ";",
  [anon_sym_typedef] = "typedef",
  [anon_sym_extern] = "extern",
  [anon_sym___attribute__] = "__attribute__",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym___declspec] = "__declspec",
  [anon_sym___based] = "__based",
  [anon_sym___cdecl] = "__cdecl",
  [anon_sym___clrcall] = "__clrcall",
  [anon_sym___stdcall] = "__stdcall",
  [anon_sym___fastcall] = "__fastcall",
  [anon_sym___thiscall] = "__thiscall",
  [anon_sym___vectorcall] = "__vectorcall",
  [sym_ms_restrict_modifier] = "ms_restrict_modifier",
  [sym_ms_unsigned_ptr_modifier] = "ms_unsigned_ptr_modifier",
  [sym_ms_signed_ptr_modifier] = "ms_signed_ptr_modifier",
  [anon_sym__unaligned] = "_unaligned",
  [anon_sym___unaligned] = "__unaligned",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_long] = "long",
  [anon_sym_short] = "short",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_static] = "static",
  [anon_sym_register] = "register",
  [anon_sym_inline] = "inline",
  [anon_sym_thread_local] = "thread_local",
  [anon_sym_const] = "const",
  [anon_sym_constexpr] = "constexpr",
  [anon_sym_volatile] = "volatile",
  [anon_sym_restrict] = "restrict",
  [anon_sym___restrict__] = "__restrict__",
  [anon_sym__Atomic] = "_Atomic",
  [anon_sym__Noreturn] = "_Noreturn",
  [anon_sym_noreturn] = "noreturn",
  [anon_sym_mutable] = "mutable",
  [anon_sym_constinit] = "constinit",
  [anon_sym_consteval] = "consteval",
  [sym_primitive_type] = "primitive_type",
  [anon_sym_enum] = "enum",
  [anon_sym_class] = "class",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_COLON] = ":",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_return] = "return",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym_QMARK] = "\?",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_and_eq] = "and_eq",
  [anon_sym_or_eq] = "or_eq",
  [anon_sym_xor_eq] = "xor_eq",
  [anon_sym_not] = "not",
  [anon_sym_compl] = "compl",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_bitor] = "bitor",
  [anon_sym_xor] = "xor",
  [anon_sym_bitand] = "bitand",
  [anon_sym_not_eq] = "not_eq",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym_offsetof] = "offsetof",
  [anon_sym__Generic] = "_Generic",
  [anon_sym_asm] = "asm",
  [anon_sym___asm__] = "__asm__",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_STAR] = ".*",
  [anon_sym_DASH_GT] = "->",
  [sym_number_literal] = "number_literal",
  [anon_sym_L_SQUOTE] = "L'",
  [anon_sym_u_SQUOTE] = "u'",
  [anon_sym_U_SQUOTE] = "U'",
  [anon_sym_u8_SQUOTE] = "u8'",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_literal_token1] = "character",
  [anon_sym_L_DQUOTE] = "L\"",
  [anon_sym_u_DQUOTE] = "u\"",
  [anon_sym_U_DQUOTE] = "U\"",
  [anon_sym_u8_DQUOTE] = "u8\"",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_system_lib_string] = "system_lib_string",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_NULL] = "NULL",
  [anon_sym_nullptr] = "nullptr",
  [sym_comment] = "comment",
  [sym_auto] = "auto",
  [anon_sym_decltype] = "decltype",
  [anon_sym_final] = "final",
  [anon_sym_override] = "override",
  [anon_sym_virtual] = "virtual",
  [anon_sym_alignas] = "alignas",
  [anon_sym_explicit] = "explicit",
  [anon_sym_typename] = "typename",
  [anon_sym_template] = "template",
  [anon_sym_GT2] = ">",
  [anon_sym_operator] = "operator",
  [anon_sym_try] = "try",
  [anon_sym_delete] = "delete",
  [anon_sym_friend] = "friend",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_noexcept] = "noexcept",
  [anon_sym_throw] = "throw",
  [anon_sym_namespace] = "namespace",
  [anon_sym_using] = "using",
  [anon_sym_static_assert] = "static_assert",
  [anon_sym_concept] = "concept",
  [anon_sym_co_return] = "co_return",
  [anon_sym_co_yield] = "co_yield",
  [anon_sym_catch] = "catch",
  [anon_sym_R_DQUOTE] = "R\"",
  [anon_sym_LR_DQUOTE] = "LR\"",
  [anon_sym_uR_DQUOTE] = "uR\"",
  [anon_sym_UR_DQUOTE] = "UR\"",
  [anon_sym_u8R_DQUOTE] = "u8R\"",
  [anon_sym_co_await] = "co_await",
  [anon_sym_new] = "new",
  [anon_sym_requires] = "requires",
  [anon_sym_DASH_GT_STAR] = "->*",
  [anon_sym_alignof] = "alignof",
  [anon_sym_LPAREN_RPAREN] = "()",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_DQUOTE_DQUOTE] = "\"\"",
  [sym_this] = "this",
  [sym_literal_suffix] = "literal_suffix",
  [sym_raw_string_delimiter] = "raw_string_delimiter",
  [sym_raw_string_content] = "raw_string_content",
  [sym_translation_unit] = "translation_unit",
  [sym_preproc_include] = "preproc_include",
  [sym_preproc_def] = "preproc_def",
  [sym_preproc_function_def] = "preproc_function_def",
  [sym_preproc_params] = "preproc_params",
  [sym_preproc_call] = "preproc_call",
  [sym_preproc_if] = "preproc_if",
  [sym_preproc_ifdef] = "preproc_ifdef",
  [sym_preproc_else] = "preproc_else",
  [sym_preproc_elif] = "preproc_elif",
  [sym_preproc_elifdef] = "preproc_elifdef",
  [sym_preproc_if_in_field_declaration_list] = "preproc_if",
  [sym_preproc_ifdef_in_field_declaration_list] = "preproc_ifdef",
  [sym_preproc_else_in_field_declaration_list] = "preproc_else",
  [sym_preproc_elif_in_field_declaration_list] = "preproc_elif",
  [sym__preproc_expression] = "_preproc_expression",
  [sym_preproc_parenthesized_expression] = "parenthesized_expression",
  [sym_preproc_defined] = "preproc_defined",
  [sym_preproc_unary_expression] = "unary_expression",
  [sym_preproc_call_expression] = "call_expression",
  [sym_preproc_argument_list] = "argument_list",
  [sym_preproc_binary_expression] = "binary_expression",
  [sym_function_definition] = "function_definition",
  [sym_declaration] = "declaration",
  [sym_type_definition] = "type_definition",
  [sym__declaration_modifiers] = "_declaration_modifiers",
  [sym__declaration_specifiers] = "_declaration_specifiers",
  [sym_linkage_specification] = "linkage_specification",
  [sym_attribute_specifier] = "attribute_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_declaration] = "attribute_declaration",
  [sym_ms_declspec_modifier] = "ms_declspec_modifier",
  [sym_ms_based_modifier] = "ms_based_modifier",
  [sym_ms_call_modifier] = "ms_call_modifier",
  [sym_ms_unaligned_ptr_modifier] = "ms_unaligned_ptr_modifier",
  [sym_ms_pointer_modifier] = "ms_pointer_modifier",
  [sym_declaration_list] = "declaration_list",
  [sym__declarator] = "_declarator",
  [sym__field_declarator] = "_field_declarator",
  [sym__type_declarator] = "_type_declarator",
  [sym__abstract_declarator] = "_abstract_declarator",
  [sym_parenthesized_declarator] = "parenthesized_declarator",
  [sym_parenthesized_field_declarator] = "parenthesized_declarator",
  [sym_parenthesized_type_declarator] = "parenthesized_declarator",
  [sym_abstract_parenthesized_declarator] = "abstract_parenthesized_declarator",
  [sym_attributed_declarator] = "attributed_declarator",
  [sym_attributed_field_declarator] = "attributed_declarator",
  [sym_attributed_type_declarator] = "attributed_declarator",
  [sym_pointer_declarator] = "pointer_declarator",
  [sym_pointer_field_declarator] = "pointer_declarator",
  [sym_pointer_type_declarator] = "pointer_type_declarator",
  [sym_abstract_pointer_declarator] = "abstract_pointer_declarator",
  [sym_function_declarator] = "function_declarator",
  [sym_function_field_declarator] = "function_declarator",
  [sym_function_type_declarator] = "function_declarator",
  [sym_abstract_function_declarator] = "abstract_function_declarator",
  [sym_array_declarator] = "array_declarator",
  [sym_array_field_declarator] = "array_declarator",
  [sym_array_type_declarator] = "array_declarator",
  [sym_abstract_array_declarator] = "abstract_array_declarator",
  [sym_init_declarator] = "init_declarator",
  [sym_compound_statement] = "compound_statement",
  [sym_storage_class_specifier] = "storage_class_specifier",
  [sym_type_qualifier] = "type_qualifier",
  [sym__type_specifier] = "_type_specifier",
  [sym_sized_type_specifier] = "sized_type_specifier",
  [sym_enum_specifier] = "enum_specifier",
  [sym_enumerator_list] = "enumerator_list",
  [sym_struct_specifier] = "struct_specifier",
  [sym_union_specifier] = "union_specifier",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym__field_declaration_list_item] = "_field_declaration_list_item",
  [sym_field_declaration] = "field_declaration",
  [sym_bitfield_clause] = "bitfield_clause",
  [sym_enumerator] = "enumerator",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_attributed_statement] = "attributed_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym__top_level_expression_statement] = "expression_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_case_statement] = "case_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_for_statement] = "for_statement",
  [sym_return_statement] = "return_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym__expression] = "_expression",
  [sym__expression_not_binary] = "_expression_not_binary",
  [sym_comma_expression] = "comma_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_pointer_expression] = "pointer_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_update_expression] = "update_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_type_descriptor] = "type_descriptor",
  [sym_sizeof_expression] = "sizeof_expression",
  [sym_offsetof_expression] = "offsetof_expression",
  [sym_generic_expression] = "generic_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_call_expression] = "call_expression",
  [sym_gnu_asm_expression] = "gnu_asm_expression",
  [sym_gnu_asm_qualifier] = "gnu_asm_qualifier",
  [sym_gnu_asm_output_operand_list] = "gnu_asm_output_operand_list",
  [sym_gnu_asm_output_operand] = "gnu_asm_output_operand",
  [sym_gnu_asm_input_operand_list] = "gnu_asm_input_operand_list",
  [sym_gnu_asm_input_operand] = "gnu_asm_input_operand",
  [sym_gnu_asm_clobber_list] = "gnu_asm_clobber_list",
  [sym_gnu_asm_goto_list] = "gnu_asm_goto_list",
  [sym_argument_list] = "argument_list",
  [sym_field_expression] = "field_expression",
  [sym_compound_literal_expression] = "compound_literal_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_initializer_list] = "initializer_list",
  [sym_initializer_pair] = "initializer_pair",
  [sym_subscript_designator] = "subscript_designator",
  [sym_field_designator] = "field_designator",
  [sym_char_literal] = "char_literal",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string_literal] = "string_literal",
  [sym_null] = "null",
  [sym__empty_declaration] = "_empty_declaration",
  [sym_placeholder_type_specifier] = "placeholder_type_specifier",
  [sym_decltype_auto] = "decltype",
  [sym_decltype] = "decltype",
  [sym__class_declaration] = "_class_declaration",
  [sym_class_specifier] = "class_specifier",
  [sym__class_name] = "_class_name",
  [sym_virtual_specifier] = "virtual_specifier",
  [sym_virtual] = "virtual",
  [sym_alignas_specifier] = "alignas_specifier",
  [sym_explicit_function_specifier] = "explicit_function_specifier",
  [sym_base_class_clause] = "base_class_clause",
  [sym__enum_base_clause] = "_enum_base_clause",
  [sym_dependent_type] = "dependent_type",
  [sym_template_declaration] = "template_declaration",
  [sym_template_instantiation] = "template_instantiation",
  [sym_template_parameter_list] = "template_parameter_list",
  [sym_type_parameter_declaration] = "type_parameter_declaration",
  [sym_variadic_type_parameter_declaration] = "variadic_type_parameter_declaration",
  [sym_optional_type_parameter_declaration] = "optional_type_parameter_declaration",
  [sym_template_template_parameter_declaration] = "template_template_parameter_declaration",
  [sym_optional_parameter_declaration] = "optional_parameter_declaration",
  [sym_variadic_parameter_declaration] = "variadic_parameter_declaration",
  [sym_variadic_declarator] = "variadic_declarator",
  [sym_variadic_reference_declarator] = "reference_declarator",
  [sym_operator_cast] = "operator_cast",
  [sym_field_initializer_list] = "field_initializer_list",
  [sym_field_initializer] = "field_initializer",
  [sym_inline_method_definition] = "function_definition",
  [sym__constructor_specifiers] = "_constructor_specifiers",
  [sym_operator_cast_definition] = "function_definition",
  [sym_operator_cast_declaration] = "declaration",
  [sym_constructor_try_statement] = "try_statement",
  [sym_constructor_or_destructor_definition] = "function_definition",
  [sym_constructor_or_destructor_declaration] = "declaration",
  [sym_default_method_clause] = "default_method_clause",
  [sym_delete_method_clause] = "delete_method_clause",
  [sym_friend_declaration] = "friend_declaration",
  [sym_access_specifier] = "access_specifier",
  [sym_reference_declarator] = "reference_declarator",
  [sym_reference_field_declarator] = "reference_declarator",
  [sym_abstract_reference_declarator] = "abstract_reference_declarator",
  [sym_structured_binding_declarator] = "structured_binding_declarator",
  [sym_ref_qualifier] = "ref_qualifier",
  [sym__function_declarator_seq] = "_function_declarator_seq",
  [sym_trailing_return_type] = "trailing_return_type",
  [sym_noexcept] = "noexcept",
  [sym_throw_specifier] = "throw_specifier",
  [sym_template_type] = "template_type",
  [sym_template_method] = "template_method",
  [sym_template_function] = "template_function",
  [sym_template_argument_list] = "template_argument_list",
  [sym_namespace_definition] = "namespace_definition",
  [sym_namespace_alias_definition] = "namespace_alias_definition",
  [sym__namespace_specifier] = "_namespace_specifier",
  [sym_nested_namespace_specifier] = "nested_namespace_specifier",
  [sym_using_declaration] = "using_declaration",
  [sym_alias_declaration] = "alias_declaration",
  [sym_static_assert_declaration] = "static_assert_declaration",
  [sym_concept_definition] = "concept_definition",
  [sym_for_range_loop] = "for_range_loop",
  [sym_init_statement] = "init_statement",
  [sym_condition_clause] = "condition_clause",
  [sym_condition_declaration] = "declaration",
  [sym_co_return_statement] = "co_return_statement",
  [sym_co_yield_statement] = "co_yield_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_raw_string_literal] = "raw_string_literal",
  [sym_co_await_expression] = "co_await_expression",
  [sym_new_expression] = "new_expression",
  [sym_new_declarator] = "new_declarator",
  [sym_delete_expression] = "delete_expression",
  [sym_type_requirement] = "type_requirement",
  [sym_compound_requirement] = "compound_requirement",
  [sym__requirement] = "_requirement",
  [sym_requirement_seq] = "requirement_seq",
  [sym_constraint_conjunction] = "constraint_conjunction",
  [sym_constraint_disjunction] = "constraint_disjunction",
  [sym__requirement_clause_constraint] = "_requirement_clause_constraint",
  [sym_requires_clause] = "requires_clause",
  [sym_requires_parameter_list] = "parameter_list",
  [sym_requires_expression] = "requires_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_lambda_capture_specifier] = "lambda_capture_specifier",
  [sym_lambda_default_capture] = "lambda_default_capture",
  [sym__fold_operator] = "_fold_operator",
  [sym__binary_fold_operator] = "_binary_fold_operator",
  [sym__unary_left_fold] = "_unary_left_fold",
  [sym__unary_right_fold] = "_unary_right_fold",
  [sym__binary_fold] = "_binary_fold",
  [sym_fold_expression] = "fold_expression",
  [sym_parameter_pack_expansion] = "parameter_pack_expansion",
  [sym_type_parameter_pack_expansion] = "parameter_pack_expansion",
  [sym_alignof_expression] = "alignof_expression",
  [sym_destructor_name] = "destructor_name",
  [sym_dependent_identifier] = "dependent_name",
  [sym_dependent_field_identifier] = "dependent_name",
  [sym_dependent_type_identifier] = "dependent_name",
  [sym__scope_resolution] = "_scope_resolution",
  [sym_qualified_field_identifier] = "qualified_identifier",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym_qualified_type_identifier] = "qualified_identifier",
  [sym_qualified_operator_cast_identifier] = "qualified_identifier",
  [sym_operator_name] = "operator_name",
  [sym_user_defined_literal] = "user_defined_literal",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_preproc_params_repeat1] = "preproc_params_repeat1",
  [aux_sym_preproc_if_repeat1] = "preproc_if_repeat1",
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = "preproc_if_in_field_declaration_list_repeat1",
  [aux_sym_preproc_argument_list_repeat1] = "preproc_argument_list_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym_type_definition_repeat2] = "type_definition_repeat2",
  [aux_sym__declaration_specifiers_repeat1] = "_declaration_specifiers_repeat1",
  [aux_sym_attribute_declaration_repeat1] = "attribute_declaration_repeat1",
  [aux_sym_attributed_declarator_repeat1] = "attributed_declarator_repeat1",
  [aux_sym_pointer_declarator_repeat1] = "pointer_declarator_repeat1",
  [aux_sym_sized_type_specifier_repeat1] = "sized_type_specifier_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym_field_declaration_repeat1] = "field_declaration_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_generic_expression_repeat1] = "generic_expression_repeat1",
  [aux_sym_gnu_asm_expression_repeat1] = "gnu_asm_expression_repeat1",
  [aux_sym_gnu_asm_output_operand_list_repeat1] = "gnu_asm_output_operand_list_repeat1",
  [aux_sym_gnu_asm_input_operand_list_repeat1] = "gnu_asm_input_operand_list_repeat1",
  [aux_sym_gnu_asm_clobber_list_repeat1] = "gnu_asm_clobber_list_repeat1",
  [aux_sym_gnu_asm_goto_list_repeat1] = "gnu_asm_goto_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym_initializer_pair_repeat1] = "initializer_pair_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym__class_declaration_repeat1] = "_class_declaration_repeat1",
  [aux_sym_base_class_clause_repeat1] = "base_class_clause_repeat1",
  [aux_sym_template_parameter_list_repeat1] = "template_parameter_list_repeat1",
  [aux_sym_field_initializer_list_repeat1] = "field_initializer_list_repeat1",
  [aux_sym_operator_cast_definition_repeat1] = "operator_cast_definition_repeat1",
  [aux_sym_constructor_try_statement_repeat1] = "constructor_try_statement_repeat1",
  [aux_sym_structured_binding_declarator_repeat1] = "structured_binding_declarator_repeat1",
  [aux_sym__function_declarator_seq_repeat1] = "_function_declarator_seq_repeat1",
  [aux_sym__function_declarator_seq_repeat2] = "_function_declarator_seq_repeat2",
  [aux_sym_throw_specifier_repeat1] = "throw_specifier_repeat1",
  [aux_sym_template_argument_list_repeat1] = "template_argument_list_repeat1",
  [aux_sym_requirement_seq_repeat1] = "requirement_seq_repeat1",
  [aux_sym_requires_parameter_list_repeat1] = "requires_parameter_list_repeat1",
  [aux_sym_lambda_capture_specifier_repeat1] = "lambda_capture_specifier_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_namespace_identifier] = "namespace_identifier",
  [alias_sym_simple_requirement] = "simple_requirement",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_preproc_include_token1] = aux_sym_preproc_include_token1,
  [aux_sym_preproc_include_token2] = aux_sym_preproc_include_token2,
  [aux_sym_preproc_def_token1] = aux_sym_preproc_def_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_preproc_if_token1] = aux_sym_preproc_if_token1,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_preproc_if_token2] = aux_sym_preproc_if_token2,
  [aux_sym_preproc_ifdef_token1] = aux_sym_preproc_ifdef_token1,
  [aux_sym_preproc_ifdef_token2] = aux_sym_preproc_ifdef_token2,
  [aux_sym_preproc_else_token1] = aux_sym_preproc_else_token1,
  [aux_sym_preproc_elif_token1] = aux_sym_preproc_elif_token1,
  [aux_sym_preproc_elifdef_token1] = aux_sym_preproc_elifdef_token1,
  [aux_sym_preproc_elifdef_token2] = aux_sym_preproc_elifdef_token2,
  [sym_preproc_arg] = sym_preproc_arg,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_defined] = anon_sym_defined,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym___attribute__] = anon_sym___attribute__,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym___declspec] = anon_sym___declspec,
  [anon_sym___based] = anon_sym___based,
  [anon_sym___cdecl] = anon_sym___cdecl,
  [anon_sym___clrcall] = anon_sym___clrcall,
  [anon_sym___stdcall] = anon_sym___stdcall,
  [anon_sym___fastcall] = anon_sym___fastcall,
  [anon_sym___thiscall] = anon_sym___thiscall,
  [anon_sym___vectorcall] = anon_sym___vectorcall,
  [sym_ms_restrict_modifier] = sym_ms_restrict_modifier,
  [sym_ms_unsigned_ptr_modifier] = sym_ms_unsigned_ptr_modifier,
  [sym_ms_signed_ptr_modifier] = sym_ms_signed_ptr_modifier,
  [anon_sym__unaligned] = anon_sym__unaligned,
  [anon_sym___unaligned] = anon_sym___unaligned,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_register] = anon_sym_register,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym_thread_local] = anon_sym_thread_local,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_constexpr] = anon_sym_constexpr,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_restrict] = anon_sym_restrict,
  [anon_sym___restrict__] = anon_sym___restrict__,
  [anon_sym__Atomic] = anon_sym__Atomic,
  [anon_sym__Noreturn] = anon_sym__Noreturn,
  [anon_sym_noreturn] = anon_sym_noreturn,
  [anon_sym_mutable] = anon_sym_mutable,
  [anon_sym_constinit] = anon_sym_constinit,
  [anon_sym_consteval] = anon_sym_consteval,
  [sym_primitive_type] = sym_primitive_type,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_and_eq] = anon_sym_and_eq,
  [anon_sym_or_eq] = anon_sym_or_eq,
  [anon_sym_xor_eq] = anon_sym_xor_eq,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_compl] = anon_sym_compl,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_bitor] = anon_sym_bitor,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_bitand] = anon_sym_bitand,
  [anon_sym_not_eq] = anon_sym_not_eq,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym_offsetof] = anon_sym_offsetof,
  [anon_sym__Generic] = anon_sym__Generic,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym___asm__] = anon_sym___asm__,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_STAR] = anon_sym_DOT_STAR,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_L_SQUOTE] = anon_sym_L_SQUOTE,
  [anon_sym_u_SQUOTE] = anon_sym_u_SQUOTE,
  [anon_sym_U_SQUOTE] = anon_sym_U_SQUOTE,
  [anon_sym_u8_SQUOTE] = anon_sym_u8_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_literal_token1] = aux_sym_char_literal_token1,
  [anon_sym_L_DQUOTE] = anon_sym_L_DQUOTE,
  [anon_sym_u_DQUOTE] = anon_sym_u_DQUOTE,
  [anon_sym_U_DQUOTE] = anon_sym_U_DQUOTE,
  [anon_sym_u8_DQUOTE] = anon_sym_u8_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_system_lib_string] = sym_system_lib_string,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_nullptr] = anon_sym_nullptr,
  [sym_comment] = sym_comment,
  [sym_auto] = sym_auto,
  [anon_sym_decltype] = anon_sym_decltype,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_virtual] = anon_sym_virtual,
  [anon_sym_alignas] = anon_sym_alignas,
  [anon_sym_explicit] = anon_sym_explicit,
  [anon_sym_typename] = anon_sym_typename,
  [anon_sym_template] = anon_sym_template,
  [anon_sym_GT2] = anon_sym_GT,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_friend] = anon_sym_friend,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_noexcept] = anon_sym_noexcept,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_static_assert] = anon_sym_static_assert,
  [anon_sym_concept] = anon_sym_concept,
  [anon_sym_co_return] = anon_sym_co_return,
  [anon_sym_co_yield] = anon_sym_co_yield,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_R_DQUOTE] = anon_sym_R_DQUOTE,
  [anon_sym_LR_DQUOTE] = anon_sym_LR_DQUOTE,
  [anon_sym_uR_DQUOTE] = anon_sym_uR_DQUOTE,
  [anon_sym_UR_DQUOTE] = anon_sym_UR_DQUOTE,
  [anon_sym_u8R_DQUOTE] = anon_sym_u8R_DQUOTE,
  [anon_sym_co_await] = anon_sym_co_await,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_DASH_GT_STAR] = anon_sym_DASH_GT_STAR,
  [anon_sym_alignof] = anon_sym_alignof,
  [anon_sym_LPAREN_RPAREN] = anon_sym_LPAREN_RPAREN,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE,
  [sym_this] = sym_this,
  [sym_literal_suffix] = sym_literal_suffix,
  [sym_raw_string_delimiter] = sym_raw_string_delimiter,
  [sym_raw_string_content] = sym_raw_string_content,
  [sym_translation_unit] = sym_translation_unit,
  [sym_preproc_include] = sym_preproc_include,
  [sym_preproc_def] = sym_preproc_def,
  [sym_preproc_function_def] = sym_preproc_function_def,
  [sym_preproc_params] = sym_preproc_params,
  [sym_preproc_call] = sym_preproc_call,
  [sym_preproc_if] = sym_preproc_if,
  [sym_preproc_ifdef] = sym_preproc_ifdef,
  [sym_preproc_else] = sym_preproc_else,
  [sym_preproc_elif] = sym_preproc_elif,
  [sym_preproc_elifdef] = sym_preproc_elifdef,
  [sym_preproc_if_in_field_declaration_list] = sym_preproc_if,
  [sym_preproc_ifdef_in_field_declaration_list] = sym_preproc_ifdef,
  [sym_preproc_else_in_field_declaration_list] = sym_preproc_else,
  [sym_preproc_elif_in_field_declaration_list] = sym_preproc_elif,
  [sym__preproc_expression] = sym__preproc_expression,
  [sym_preproc_parenthesized_expression] = sym_parenthesized_expression,
  [sym_preproc_defined] = sym_preproc_defined,
  [sym_preproc_unary_expression] = sym_unary_expression,
  [sym_preproc_call_expression] = sym_call_expression,
  [sym_preproc_argument_list] = sym_argument_list,
  [sym_preproc_binary_expression] = sym_binary_expression,
  [sym_function_definition] = sym_function_definition,
  [sym_declaration] = sym_declaration,
  [sym_type_definition] = sym_type_definition,
  [sym__declaration_modifiers] = sym__declaration_modifiers,
  [sym__declaration_specifiers] = sym__declaration_specifiers,
  [sym_linkage_specification] = sym_linkage_specification,
  [sym_attribute_specifier] = sym_attribute_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_declaration] = sym_attribute_declaration,
  [sym_ms_declspec_modifier] = sym_ms_declspec_modifier,
  [sym_ms_based_modifier] = sym_ms_based_modifier,
  [sym_ms_call_modifier] = sym_ms_call_modifier,
  [sym_ms_unaligned_ptr_modifier] = sym_ms_unaligned_ptr_modifier,
  [sym_ms_pointer_modifier] = sym_ms_pointer_modifier,
  [sym_declaration_list] = sym_declaration_list,
  [sym__declarator] = sym__declarator,
  [sym__field_declarator] = sym__field_declarator,
  [sym__type_declarator] = sym__type_declarator,
  [sym__abstract_declarator] = sym__abstract_declarator,
  [sym_parenthesized_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_field_declarator] = sym_parenthesized_declarator,
  [sym_parenthesized_type_declarator] = sym_parenthesized_declarator,
  [sym_abstract_parenthesized_declarator] = sym_abstract_parenthesized_declarator,
  [sym_attributed_declarator] = sym_attributed_declarator,
  [sym_attributed_field_declarator] = sym_attributed_declarator,
  [sym_attributed_type_declarator] = sym_attributed_declarator,
  [sym_pointer_declarator] = sym_pointer_declarator,
  [sym_pointer_field_declarator] = sym_pointer_declarator,
  [sym_pointer_type_declarator] = sym_pointer_type_declarator,
  [sym_abstract_pointer_declarator] = sym_abstract_pointer_declarator,
  [sym_function_declarator] = sym_function_declarator,
  [sym_function_field_declarator] = sym_function_declarator,
  [sym_function_type_declarator] = sym_function_declarator,
  [sym_abstract_function_declarator] = sym_abstract_function_declarator,
  [sym_array_declarator] = sym_array_declarator,
  [sym_array_field_declarator] = sym_array_declarator,
  [sym_array_type_declarator] = sym_array_declarator,
  [sym_abstract_array_declarator] = sym_abstract_array_declarator,
  [sym_init_declarator] = sym_init_declarator,
  [sym_compound_statement] = sym_compound_statement,
  [sym_storage_class_specifier] = sym_storage_class_specifier,
  [sym_type_qualifier] = sym_type_qualifier,
  [sym__type_specifier] = sym__type_specifier,
  [sym_sized_type_specifier] = sym_sized_type_specifier,
  [sym_enum_specifier] = sym_enum_specifier,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym_struct_specifier] = sym_struct_specifier,
  [sym_union_specifier] = sym_union_specifier,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym__field_declaration_list_item] = sym__field_declaration_list_item,
  [sym_field_declaration] = sym_field_declaration,
  [sym_bitfield_clause] = sym_bitfield_clause,
  [sym_enumerator] = sym_enumerator,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_attributed_statement] = sym_attributed_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym__top_level_expression_statement] = sym_expression_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_case_statement] = sym_case_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym__expression] = sym__expression,
  [sym__expression_not_binary] = sym__expression_not_binary,
  [sym_comma_expression] = sym_comma_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_pointer_expression] = sym_pointer_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_type_descriptor] = sym_type_descriptor,
  [sym_sizeof_expression] = sym_sizeof_expression,
  [sym_offsetof_expression] = sym_offsetof_expression,
  [sym_generic_expression] = sym_generic_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_gnu_asm_expression] = sym_gnu_asm_expression,
  [sym_gnu_asm_qualifier] = sym_gnu_asm_qualifier,
  [sym_gnu_asm_output_operand_list] = sym_gnu_asm_output_operand_list,
  [sym_gnu_asm_output_operand] = sym_gnu_asm_output_operand,
  [sym_gnu_asm_input_operand_list] = sym_gnu_asm_input_operand_list,
  [sym_gnu_asm_input_operand] = sym_gnu_asm_input_operand,
  [sym_gnu_asm_clobber_list] = sym_gnu_asm_clobber_list,
  [sym_gnu_asm_goto_list] = sym_gnu_asm_goto_list,
  [sym_argument_list] = sym_argument_list,
  [sym_field_expression] = sym_field_expression,
  [sym_compound_literal_expression] = sym_compound_literal_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_initializer_list] = sym_initializer_list,
  [sym_initializer_pair] = sym_initializer_pair,
  [sym_subscript_designator] = sym_subscript_designator,
  [sym_field_designator] = sym_field_designator,
  [sym_char_literal] = sym_char_literal,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string_literal] = sym_string_literal,
  [sym_null] = sym_null,
  [sym__empty_declaration] = sym__empty_declaration,
  [sym_placeholder_type_specifier] = sym_placeholder_type_specifier,
  [sym_decltype_auto] = sym_decltype,
  [sym_decltype] = sym_decltype,
  [sym__class_declaration] = sym__class_declaration,
  [sym_class_specifier] = sym_class_specifier,
  [sym__class_name] = sym__class_name,
  [sym_virtual_specifier] = sym_virtual_specifier,
  [sym_virtual] = sym_virtual,
  [sym_alignas_specifier] = sym_alignas_specifier,
  [sym_explicit_function_specifier] = sym_explicit_function_specifier,
  [sym_base_class_clause] = sym_base_class_clause,
  [sym__enum_base_clause] = sym__enum_base_clause,
  [sym_dependent_type] = sym_dependent_type,
  [sym_template_declaration] = sym_template_declaration,
  [sym_template_instantiation] = sym_template_instantiation,
  [sym_template_parameter_list] = sym_template_parameter_list,
  [sym_type_parameter_declaration] = sym_type_parameter_declaration,
  [sym_variadic_type_parameter_declaration] = sym_variadic_type_parameter_declaration,
  [sym_optional_type_parameter_declaration] = sym_optional_type_parameter_declaration,
  [sym_template_template_parameter_declaration] = sym_template_template_parameter_declaration,
  [sym_optional_parameter_declaration] = sym_optional_parameter_declaration,
  [sym_variadic_parameter_declaration] = sym_variadic_parameter_declaration,
  [sym_variadic_declarator] = sym_variadic_declarator,
  [sym_variadic_reference_declarator] = sym_reference_declarator,
  [sym_operator_cast] = sym_operator_cast,
  [sym_field_initializer_list] = sym_field_initializer_list,
  [sym_field_initializer] = sym_field_initializer,
  [sym_inline_method_definition] = sym_function_definition,
  [sym__constructor_specifiers] = sym__constructor_specifiers,
  [sym_operator_cast_definition] = sym_function_definition,
  [sym_operator_cast_declaration] = sym_declaration,
  [sym_constructor_try_statement] = sym_try_statement,
  [sym_constructor_or_destructor_definition] = sym_function_definition,
  [sym_constructor_or_destructor_declaration] = sym_declaration,
  [sym_default_method_clause] = sym_default_method_clause,
  [sym_delete_method_clause] = sym_delete_method_clause,
  [sym_friend_declaration] = sym_friend_declaration,
  [sym_access_specifier] = sym_access_specifier,
  [sym_reference_declarator] = sym_reference_declarator,
  [sym_reference_field_declarator] = sym_reference_declarator,
  [sym_abstract_reference_declarator] = sym_abstract_reference_declarator,
  [sym_structured_binding_declarator] = sym_structured_binding_declarator,
  [sym_ref_qualifier] = sym_ref_qualifier,
  [sym__function_declarator_seq] = sym__function_declarator_seq,
  [sym_trailing_return_type] = sym_trailing_return_type,
  [sym_noexcept] = sym_noexcept,
  [sym_throw_specifier] = sym_throw_specifier,
  [sym_template_type] = sym_template_type,
  [sym_template_method] = sym_template_method,
  [sym_template_function] = sym_template_function,
  [sym_template_argument_list] = sym_template_argument_list,
  [sym_namespace_definition] = sym_namespace_definition,
  [sym_namespace_alias_definition] = sym_namespace_alias_definition,
  [sym__namespace_specifier] = sym__namespace_specifier,
  [sym_nested_namespace_specifier] = sym_nested_namespace_specifier,
  [sym_using_declaration] = sym_using_declaration,
  [sym_alias_declaration] = sym_alias_declaration,
  [sym_static_assert_declaration] = sym_static_assert_declaration,
  [sym_concept_definition] = sym_concept_definition,
  [sym_for_range_loop] = sym_for_range_loop,
  [sym_init_statement] = sym_init_statement,
  [sym_condition_clause] = sym_condition_clause,
  [sym_condition_declaration] = sym_declaration,
  [sym_co_return_statement] = sym_co_return_statement,
  [sym_co_yield_statement] = sym_co_yield_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [sym_co_await_expression] = sym_co_await_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_new_declarator] = sym_new_declarator,
  [sym_delete_expression] = sym_delete_expression,
  [sym_type_requirement] = sym_type_requirement,
  [sym_compound_requirement] = sym_compound_requirement,
  [sym__requirement] = sym__requirement,
  [sym_requirement_seq] = sym_requirement_seq,
  [sym_constraint_conjunction] = sym_constraint_conjunction,
  [sym_constraint_disjunction] = sym_constraint_disjunction,
  [sym__requirement_clause_constraint] = sym__requirement_clause_constraint,
  [sym_requires_clause] = sym_requires_clause,
  [sym_requires_parameter_list] = sym_parameter_list,
  [sym_requires_expression] = sym_requires_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_lambda_capture_specifier] = sym_lambda_capture_specifier,
  [sym_lambda_default_capture] = sym_lambda_default_capture,
  [sym__fold_operator] = sym__fold_operator,
  [sym__binary_fold_operator] = sym__binary_fold_operator,
  [sym__unary_left_fold] = sym__unary_left_fold,
  [sym__unary_right_fold] = sym__unary_right_fold,
  [sym__binary_fold] = sym__binary_fold,
  [sym_fold_expression] = sym_fold_expression,
  [sym_parameter_pack_expansion] = sym_parameter_pack_expansion,
  [sym_type_parameter_pack_expansion] = sym_parameter_pack_expansion,
  [sym_alignof_expression] = sym_alignof_expression,
  [sym_destructor_name] = sym_destructor_name,
  [sym_dependent_identifier] = sym_dependent_identifier,
  [sym_dependent_field_identifier] = sym_dependent_identifier,
  [sym_dependent_type_identifier] = sym_dependent_identifier,
  [sym__scope_resolution] = sym__scope_resolution,
  [sym_qualified_field_identifier] = sym_qualified_identifier,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym_qualified_type_identifier] = sym_qualified_identifier,
  [sym_qualified_operator_cast_identifier] = sym_qualified_identifier,
  [sym_operator_name] = sym_operator_name,
  [sym_user_defined_literal] = sym_user_defined_literal,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_preproc_params_repeat1] = aux_sym_preproc_params_repeat1,
  [aux_sym_preproc_if_repeat1] = aux_sym_preproc_if_repeat1,
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = aux_sym_preproc_if_in_field_declaration_list_repeat1,
  [aux_sym_preproc_argument_list_repeat1] = aux_sym_preproc_argument_list_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym_type_definition_repeat2] = aux_sym_type_definition_repeat2,
  [aux_sym__declaration_specifiers_repeat1] = aux_sym__declaration_specifiers_repeat1,
  [aux_sym_attribute_declaration_repeat1] = aux_sym_attribute_declaration_repeat1,
  [aux_sym_attributed_declarator_repeat1] = aux_sym_attributed_declarator_repeat1,
  [aux_sym_pointer_declarator_repeat1] = aux_sym_pointer_declarator_repeat1,
  [aux_sym_sized_type_specifier_repeat1] = aux_sym_sized_type_specifier_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym_field_declaration_repeat1] = aux_sym_field_declaration_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_generic_expression_repeat1] = aux_sym_generic_expression_repeat1,
  [aux_sym_gnu_asm_expression_repeat1] = aux_sym_gnu_asm_expression_repeat1,
  [aux_sym_gnu_asm_output_operand_list_repeat1] = aux_sym_gnu_asm_output_operand_list_repeat1,
  [aux_sym_gnu_asm_input_operand_list_repeat1] = aux_sym_gnu_asm_input_operand_list_repeat1,
  [aux_sym_gnu_asm_clobber_list_repeat1] = aux_sym_gnu_asm_clobber_list_repeat1,
  [aux_sym_gnu_asm_goto_list_repeat1] = aux_sym_gnu_asm_goto_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym_initializer_pair_repeat1] = aux_sym_initializer_pair_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym__class_declaration_repeat1] = aux_sym__class_declaration_repeat1,
  [aux_sym_base_class_clause_repeat1] = aux_sym_base_class_clause_repeat1,
  [aux_sym_template_parameter_list_repeat1] = aux_sym_template_parameter_list_repeat1,
  [aux_sym_field_initializer_list_repeat1] = aux_sym_field_initializer_list_repeat1,
  [aux_sym_operator_cast_definition_repeat1] = aux_sym_operator_cast_definition_repeat1,
  [aux_sym_constructor_try_statement_repeat1] = aux_sym_constructor_try_statement_repeat1,
  [aux_sym_structured_binding_declarator_repeat1] = aux_sym_structured_binding_declarator_repeat1,
  [aux_sym__function_declarator_seq_repeat1] = aux_sym__function_declarator_seq_repeat1,
  [aux_sym__function_declarator_seq_repeat2] = aux_sym__function_declarator_seq_repeat2,
  [aux_sym_throw_specifier_repeat1] = aux_sym_throw_specifier_repeat1,
  [aux_sym_template_argument_list_repeat1] = aux_sym_template_argument_list_repeat1,
  [aux_sym_requirement_seq_repeat1] = aux_sym_requirement_seq_repeat1,
  [aux_sym_requires_parameter_list_repeat1] = aux_sym_requires_parameter_list_repeat1,
  [aux_sym_lambda_capture_specifier_repeat1] = aux_sym_lambda_capture_specifier_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_namespace_identifier] = alias_sym_namespace_identifier,
  [alias_sym_simple_requirement] = alias_sym_simple_requirement,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preproc_include_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_include_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_def_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_if_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_ifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_else_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elif_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_elifdef_token2] = {
    .visible = true,
    .named = false,
  },
  [sym_preproc_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defined] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___attribute__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___declspec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___based] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___cdecl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___clrcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___stdcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___fastcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___thiscall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___vectorcall] = {
    .visible = true,
    .named = false,
  },
  [sym_ms_restrict_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unsigned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_signed_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___unaligned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_register] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thread_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constexpr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___restrict__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Atomic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constinit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_consteval] = {
    .visible = true,
    .named = false,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_compl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bitor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bitand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__Generic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___asm__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_L_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_U_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_system_lib_string] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nullptr] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_auto] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_decltype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_virtual] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_explicit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typename] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_template] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_friend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noexcept] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_concept] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_co_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_co_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_R_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LR_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uR_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UR_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8R_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_co_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alignof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_include] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_params] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_if_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_ifdef_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_else_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_elif_in_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_preproc_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration_modifiers] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_linkage_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_declspec_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_based_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_call_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_unaligned_ptr_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ms_pointer_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__field_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__type_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__abstract_declarator] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_parenthesized_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_pointer_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_function_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_array_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_init_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_specifier] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_sized_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_union_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym__field_declaration_list_item] = {
    .visible = false,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_bitfield_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_attributed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__expression_not_binary] = {
    .visible = false,
    .named = true,
  },
  [sym_comma_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym_sizeof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_offsetof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_output_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_input_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_clobber_list] = {
    .visible = true,
    .named = true,
  },
  [sym_gnu_asm_goto_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_field_designator] = {
    .visible = true,
    .named = true,
  },
  [sym_char_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_placeholder_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decltype_auto] = {
    .visible = true,
    .named = true,
  },
  [sym_decltype] = {
    .visible = true,
    .named = true,
  },
  [sym__class_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_class_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__class_name] = {
    .visible = false,
    .named = true,
  },
  [sym_virtual_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_virtual] = {
    .visible = true,
    .named = true,
  },
  [sym_alignas_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_function_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_base_class_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_base_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_dependent_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_template_instantiation] = {
    .visible = true,
    .named = true,
  },
  [sym_template_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_template_template_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_specifiers] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_cast_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_cast_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_or_destructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_or_destructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_default_method_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_method_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_friend_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_access_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_field_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_reference_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_structured_binding_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym__function_declarator_seq] = {
    .visible = false,
    .named = true,
  },
  [sym_trailing_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_noexcept] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_method] = {
    .visible = true,
    .named = true,
  },
  [sym_template_function] = {
    .visible = true,
    .named = true,
  },
  [sym_template_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_alias_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__namespace_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym_nested_namespace_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_using_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_static_assert_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_concept_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_for_range_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_init_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_co_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_co_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_co_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_requirement] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_requirement] = {
    .visible = true,
    .named = true,
  },
  [sym__requirement] = {
    .visible = false,
    .named = true,
  },
  [sym_requirement_seq] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym__requirement_clause_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym_requires_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_capture_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_default_capture] = {
    .visible = true,
    .named = true,
  },
  [sym__fold_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_fold_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_left_fold] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_right_fold] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_fold] = {
    .visible = false,
    .named = true,
  },
  [sym_fold_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_pack_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_alignof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_destructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_dependent_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_dependent_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_dependent_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__scope_resolution] = {
    .visible = false,
    .named = true,
  },
  [sym_qualified_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_operator_cast_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_name] = {
    .visible = true,
    .named = true,
  },
  [sym_user_defined_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_if_in_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_specifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributed_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sized_type_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_output_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_input_operand_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_clobber_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gnu_asm_goto_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_pair_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_base_class_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_cast_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constructor_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_structured_binding_declarator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_declarator_seq_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_declarator_seq_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_throw_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requirement_seq_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requires_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lambda_capture_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_simple_requirement] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_assembly_code = 4,
  field_base = 5,
  field_body = 6,
  field_captures = 7,
  field_clobbers = 8,
  field_condition = 9,
  field_consequence = 10,
  field_constraint = 11,
  field_declarator = 12,
  field_default_type = 13,
  field_default_value = 14,
  field_delimiter = 15,
  field_designator = 16,
  field_directive = 17,
  field_field = 18,
  field_function = 19,
  field_goto_labels = 20,
  field_index = 21,
  field_initializer = 22,
  field_input_operands = 23,
  field_label = 24,
  field_left = 25,
  field_length = 26,
  field_member = 27,
  field_message = 28,
  field_name = 29,
  field_operand = 30,
  field_operator = 31,
  field_output_operands = 32,
  field_parameters = 33,
  field_path = 34,
  field_pattern = 35,
  field_placement = 36,
  field_prefix = 37,
  field_register = 38,
  field_requirements = 39,
  field_right = 40,
  field_scope = 41,
  field_size = 42,
  field_symbol = 43,
  field_template_parameters = 44,
  field_type = 45,
  field_update = 46,
  field_value = 47,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_assembly_code] = "assembly_code",
  [field_base] = "base",
  [field_body] = "body",
  [field_captures] = "captures",
  [field_clobbers] = "clobbers",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_declarator] = "declarator",
  [field_default_type] = "default_type",
  [field_default_value] = "default_value",
  [field_delimiter] = "delimiter",
  [field_designator] = "designator",
  [field_directive] = "directive",
  [field_field] = "field",
  [field_function] = "function",
  [field_goto_labels] = "goto_labels",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_input_operands] = "input_operands",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_member] = "member",
  [field_message] = "message",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_output_operands] = "output_operands",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_placement] = "placement",
  [field_prefix] = "prefix",
  [field_register] = "register",
  [field_requirements] = "requirements",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_size] = "size",
  [field_symbol] = "symbol",
  [field_template_parameters] = "template_parameters",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 2},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 2},
  [9] = {.index = 10, .length = 1},
  [10] = {.index = 11, .length = 1},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 1},
  [15] = {.index = 17, .length = 2},
  [16] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 1},
  [19] = {.index = 20, .length = 1},
  [20] = {.index = 21, .length = 1},
  [21] = {.index = 22, .length = 1},
  [22] = {.index = 23, .length = 2},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 1},
  [25] = {.index = 28, .length = 1},
  [26] = {.index = 29, .length = 1},
  [27] = {.index = 30, .length = 2},
  [28] = {.index = 16, .length = 1},
  [29] = {.index = 32, .length = 2},
  [30] = {.index = 34, .length = 1},
  [31] = {.index = 35, .length = 2},
  [32] = {.index = 35, .length = 2},
  [33] = {.index = 19, .length = 1},
  [34] = {.index = 37, .length = 1},
  [35] = {.index = 38, .length = 2},
  [36] = {.index = 40, .length = 2},
  [37] = {.index = 42, .length = 3},
  [38] = {.index = 45, .length = 1},
  [41] = {.index = 46, .length = 2},
  [42] = {.index = 48, .length = 1},
  [43] = {.index = 49, .length = 1},
  [44] = {.index = 50, .length = 1},
  [45] = {.index = 51, .length = 2},
  [46] = {.index = 53, .length = 2},
  [47] = {.index = 55, .length = 2},
  [48] = {.index = 57, .length = 2},
  [49] = {.index = 59, .length = 2},
  [50] = {.index = 61, .length = 1},
  [51] = {.index = 62, .length = 3},
  [52] = {.index = 65, .length = 1},
  [53] = {.index = 66, .length = 1},
  [54] = {.index = 67, .length = 1},
  [55] = {.index = 68, .length = 2},
  [57] = {.index = 51, .length = 2},
  [58] = {.index = 70, .length = 2},
  [59] = {.index = 72, .length = 2},
  [60] = {.index = 74, .length = 2},
  [62] = {.index = 76, .length = 2},
  [63] = {.index = 78, .length = 2},
  [64] = {.index = 80, .length = 3},
  [65] = {.index = 83, .length = 2},
  [66] = {.index = 85, .length = 2},
  [67] = {.index = 87, .length = 3},
  [68] = {.index = 87, .length = 3},
  [69] = {.index = 90, .length = 3},
  [70] = {.index = 93, .length = 3},
  [71] = {.index = 96, .length = 2},
  [72] = {.index = 98, .length = 2},
  [73] = {.index = 100, .length = 2},
  [74] = {.index = 102, .length = 1},
  [75] = {.index = 103, .length = 2},
  [76] = {.index = 105, .length = 2},
  [77] = {.index = 107, .length = 2},
  [78] = {.index = 109, .length = 3},
  [79] = {.index = 112, .length = 2},
  [80] = {.index = 114, .length = 1},
  [81] = {.index = 115, .length = 2},
  [82] = {.index = 117, .length = 2},
  [83] = {.index = 119, .length = 2},
  [84] = {.index = 121, .length = 2},
  [85] = {.index = 123, .length = 2},
  [86] = {.index = 125, .length = 2},
  [87] = {.index = 125, .length = 2},
  [89] = {.index = 127, .length = 2},
  [90] = {.index = 129, .length = 1},
  [91] = {.index = 129, .length = 1},
  [92] = {.index = 130, .length = 3},
  [94] = {.index = 133, .length = 2},
  [95] = {.index = 135, .length = 2},
  [96] = {.index = 137, .length = 3},
  [97] = {.index = 140, .length = 1},
  [99] = {.index = 141, .length = 3},
  [100] = {.index = 144, .length = 3},
  [101] = {.index = 147, .length = 3},
  [102] = {.index = 150, .length = 2},
  [103] = {.index = 152, .length = 3},
  [104] = {.index = 155, .length = 2},
  [105] = {.index = 157, .length = 3},
  [106] = {.index = 160, .length = 2},
  [107] = {.index = 17, .length = 2},
  [108] = {.index = 35, .length = 2},
  [109] = {.index = 162, .length = 2},
  [110] = {.index = 164, .length = 2},
  [111] = {.index = 166, .length = 2},
  [112] = {.index = 168, .length = 1},
  [113] = {.index = 169, .length = 4},
  [114] = {.index = 173, .length = 4},
  [115] = {.index = 177, .length = 2},
  [116] = {.index = 179, .length = 3},
  [117] = {.index = 182, .length = 2},
  [118] = {.index = 184, .length = 2},
  [119] = {.index = 186, .length = 1},
  [120] = {.index = 187, .length = 2},
  [121] = {.index = 189, .length = 3},
  [122] = {.index = 192, .length = 3},
  [123] = {.index = 195, .length = 3},
  [124] = {.index = 198, .length = 3},
  [125] = {.index = 201, .length = 2},
  [126] = {.index = 203, .length = 2},
  [127] = {.index = 205, .length = 3},
  [128] = {.index = 208, .length = 2},
  [129] = {.index = 210, .length = 2},
  [130] = {.index = 212, .length = 1},
  [131] = {.index = 213, .length = 2},
  [132] = {.index = 215, .length = 1},
  [133] = {.index = 216, .length = 3},
  [134] = {.index = 219, .length = 2},
  [135] = {.index = 221, .length = 3},
  [136] = {.index = 224, .length = 2},
  [137] = {.index = 226, .length = 1},
  [138] = {.index = 227, .length = 1},
  [139] = {.index = 228, .length = 2},
  [140] = {.index = 230, .length = 1},
  [142] = {.index = 231, .length = 1},
  [143] = {.index = 232, .length = 2},
  [144] = {.index = 234, .length = 2},
  [145] = {.index = 11, .length = 1},
  [146] = {.index = 11, .length = 1},
  [147] = {.index = 236, .length = 2},
  [148] = {.index = 238, .length = 1},
  [149] = {.index = 239, .length = 1},
  [150] = {.index = 240, .length = 4},
  [151] = {.index = 244, .length = 1},
  [152] = {.index = 245, .length = 2},
  [153] = {.index = 247, .length = 3},
  [154] = {.index = 250, .length = 1},
  [155] = {.index = 251, .length = 5},
  [156] = {.index = 256, .length = 2},
  [157] = {.index = 258, .length = 2},
  [158] = {.index = 260, .length = 3},
  [159] = {.index = 263, .length = 3},
  [160] = {.index = 266, .length = 2},
  [161] = {.index = 268, .length = 4},
  [162] = {.index = 272, .length = 3},
  [163] = {.index = 275, .length = 2},
  [164] = {.index = 277, .length = 2},
  [165] = {.index = 279, .length = 1},
  [166] = {.index = 280, .length = 2},
  [167] = {.index = 282, .length = 3},
  [168] = {.index = 285, .length = 1},
  [169] = {.index = 286, .length = 2},
  [170] = {.index = 288, .length = 2},
  [171] = {.index = 290, .length = 2},
  [172] = {.index = 292, .length = 3},
  [173] = {.index = 295, .length = 2},
  [174] = {.index = 297, .length = 2},
  [175] = {.index = 299, .length = 3},
  [176] = {.index = 302, .length = 2},
  [177] = {.index = 304, .length = 3},
  [178] = {.index = 307, .length = 4},
  [179] = {.index = 311, .length = 2},
  [180] = {.index = 313, .length = 2},
  [181] = {.index = 315, .length = 2},
  [182] = {.index = 317, .length = 2},
  [183] = {.index = 319, .length = 3},
  [184] = {.index = 322, .length = 3},
  [185] = {.index = 325, .length = 2},
  [186] = {.index = 327, .length = 2},
  [187] = {.index = 329, .length = 1},
  [188] = {.index = 330, .length = 4},
  [189] = {.index = 334, .length = 3},
  [190] = {.index = 337, .length = 2},
  [191] = {.index = 339, .length = 1},
  [192] = {.index = 340, .length = 4},
  [193] = {.index = 344, .length = 2},
  [194] = {.index = 346, .length = 3},
  [195] = {.index = 349, .length = 4},
  [196] = {.index = 353, .length = 4},
  [197] = {.index = 357, .length = 3},
  [198] = {.index = 360, .length = 3},
  [199] = {.index = 363, .length = 2},
  [200] = {.index = 365, .length = 2},
  [201] = {.index = 61, .length = 1},
  [202] = {.index = 367, .length = 5},
  [203] = {.index = 372, .length = 4},
  [204] = {.index = 376, .length = 4},
  [205] = {.index = 380, .length = 5},
  [206] = {.index = 385, .length = 2},
  [207] = {.index = 387, .length = 2},
  [208] = {.index = 389, .length = 5},
  [209] = {.index = 394, .length = 2},
  [210] = {.index = 396, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type, 0},
  [1] =
    {field_directive, 0},
  [2] =
    {field_argument, 1},
    {field_operator, 0},
  [4] =
    {field_declarator, 1},
  [5] =
    {field_name, 0},
  [6] =
    {field_arguments, 1},
    {field_function, 0},
  [8] =
    {field_type, 0},
    {field_value, 1},
  [10] =
    {field_body, 1},
  [11] =
    {field_name, 1},
  [12] =
    {field_body, 0},
  [13] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [15] =
    {field_value, 1},
  [16] =
    {field_scope, 0},
  [17] =
    {field_arguments, 1},
    {field_name, 0},
  [19] =
    {field_type, 1},
  [20] =
    {field_requirements, 1},
  [21] =
    {field_constraint, 1},
  [22] =
    {field_parameters, 0},
  [23] =
    {field_declarator, 0},
    {field_parameters, 1, .inherited = true},
  [25] =
    {field_body, 1},
    {field_declarator, 0},
  [27] =
    {field_declarator, 0},
  [28] =
    {field_constraint, 0},
  [29] =
    {field_pattern, 0},
  [30] =
    {field_argument, 0},
    {field_operator, 1},
  [32] =
    {field_body, 1},
    {field_captures, 0},
  [34] =
    {field_parameters, 0, .inherited = true},
  [35] =
    {field_name, 1},
    {field_scope, 0, .inherited = true},
  [37] =
    {field_path, 1},
  [38] =
    {field_argument, 1},
    {field_directive, 0},
  [40] =
    {field_declarator, 1},
    {field_type, 0},
  [42] =
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [45] =
    {field_declarator, 2},
  [46] =
    {field_body, 2},
    {field_value, 1},
  [48] =
    {field_type, 2},
  [49] =
    {field_body, 2},
  [50] =
    {field_name, 2},
  [51] =
    {field_body, 2},
    {field_name, 1},
  [53] =
    {field_base, 2, .inherited = true},
    {field_name, 1},
  [55] =
    {field_body, 1},
    {field_name, 0},
  [57] =
    {field_condition, 1},
    {field_consequence, 2},
  [59] =
    {field_body, 2},
    {field_condition, 1},
  [61] =
    {field_label, 1},
  [62] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [65] =
    {field_label, 0},
  [66] =
    {field_type, 0, .inherited = true},
  [67] =
    {field_parameters, 1},
  [68] =
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [70] =
    {field_arguments, 2},
    {field_type, 1},
  [72] =
    {field_declarator, 2},
    {field_type, 1},
  [74] =
    {field_placement, 1},
    {field_type, 2},
  [76] =
    {field_parameters, 1},
    {field_requirements, 2},
  [78] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [80] =
    {field_body, 2},
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
  [83] =
    {field_declarator, 0},
    {field_value, 1},
  [85] =
    {field_body, 2},
    {field_declarator, 0},
  [87] =
    {field_argument, 0},
    {field_field, 2},
    {field_operator, 1},
  [90] =
    {field_body, 2},
    {field_captures, 0},
    {field_declarator, 1},
  [93] =
    {field_body, 2},
    {field_captures, 0},
    {field_template_parameters, 1},
  [96] =
    {field_body, 2},
    {field_declarator, 1},
  [98] =
    {field_name, 1},
    {field_value, 2},
  [100] =
    {field_name, 1},
    {field_parameters, 2},
  [102] =
    {field_condition, 1},
  [103] =
    {field_alternative, 2},
    {field_name, 1},
  [105] =
    {field_declarator, 2},
    {field_type, 0},
  [107] =
    {field_left, 0},
    {field_right, 2},
  [109] =
    {field_left, 0},
    {field_operator, 1, .inherited = true},
    {field_right, 2},
  [112] =
    {field_type, 1},
    {field_value, 3},
  [114] =
    {field_declarator, 3},
  [115] =
    {field_declarator, 0},
    {field_parameters, 1},
  [117] =
    {field_arguments, 3},
    {field_type, 2},
  [119] =
    {field_declarator, 3},
    {field_type, 2},
  [121] =
    {field_placement, 2},
    {field_type, 3},
  [123] =
    {field_name, 2},
    {field_prefix, 0},
  [125] =
    {field_body, 3},
    {field_name, 2},
  [127] =
    {field_base, 3, .inherited = true},
    {field_name, 2},
  [129] =
    {field_base, 1},
  [130] =
    {field_base, 2, .inherited = true},
    {field_body, 3},
    {field_name, 1},
  [133] =
    {field_body, 2},
    {field_name, 0},
  [135] =
    {field_condition, 2},
    {field_consequence, 3},
  [137] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [140] =
    {field_assembly_code, 2},
  [141] =
    {field_arguments, 3},
    {field_declarator, 2},
    {field_type, 1},
  [144] =
    {field_arguments, 3},
    {field_placement, 1},
    {field_type, 2},
  [147] =
    {field_declarator, 3},
    {field_placement, 1},
    {field_type, 2},
  [150] =
    {field_declarator, 0},
    {field_value, 2},
  [152] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_type, 0, .inherited = true},
  [155] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [157] =
    {field_body, 3},
    {field_declarator, 2},
    {field_type, 1, .inherited = true},
  [160] =
    {field_declarator, 0},
    {field_size, 2},
  [162] =
    {field_argument, 0},
    {field_index, 2},
  [164] =
    {field_alternative, 3},
    {field_condition, 0},
  [166] =
    {field_declarator, 0},
    {field_default_value, 2},
  [168] =
    {field_size, 1},
  [169] =
    {field_body, 3},
    {field_captures, 0},
    {field_declarator, 2},
    {field_template_parameters, 1},
  [173] =
    {field_body, 3},
    {field_captures, 0},
    {field_constraint, 2},
    {field_template_parameters, 1},
  [177] =
    {field_body, 3},
    {field_declarator, 1},
  [179] =
    {field_name, 1},
    {field_parameters, 2},
    {field_value, 3},
  [182] =
    {field_alternative, 3},
    {field_condition, 1},
  [184] =
    {field_alternative, 3},
    {field_name, 1},
  [186] =
    {field_operator, 0},
  [187] =
    {field_declarator, 3},
    {field_type, 1},
  [189] =
    {field_declarator, 2},
    {field_declarator, 3, .inherited = true},
    {field_type, 1},
  [192] =
    {field_arguments, 4},
    {field_declarator, 3},
    {field_type, 2},
  [195] =
    {field_arguments, 4},
    {field_placement, 2},
    {field_type, 3},
  [198] =
    {field_declarator, 4},
    {field_placement, 2},
    {field_type, 3},
  [201] =
    {field_designator, 0},
    {field_value, 2},
  [203] =
    {field_name, 0},
    {field_value, 2},
  [205] =
    {field_base, 3, .inherited = true},
    {field_body, 4},
    {field_name, 2},
  [208] =
    {field_default_value, 1},
    {field_type, 0, .inherited = true},
  [210] =
    {field_body, 3},
    {field_name, 1},
  [212] =
    {field_body, 3},
  [213] =
    {field_body, 3},
    {field_name, 0},
  [215] =
    {field_name, 3},
  [216] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
    {field_value, 2},
  [219] =
    {field_initializer, 1},
    {field_value, 2},
  [221] =
    {field_alternative, 4},
    {field_condition, 2},
    {field_consequence, 3},
  [224] =
    {field_body, 1},
    {field_condition, 3},
  [226] =
    {field_value, 3},
  [227] =
    {field_operand, 1},
  [228] =
    {field_assembly_code, 2},
    {field_output_operands, 3},
  [230] =
    {field_assembly_code, 3},
  [231] =
    {field_default_type, 2},
  [232] =
    {field_default_value, 2},
    {field_type, 0, .inherited = true},
  [234] =
    {field_body, 2},
    {field_parameters, 1},
  [236] =
    {field_name, 1},
    {field_type, 3},
  [238] =
    {field_condition, 2},
  [239] =
    {field_length, 1},
  [240] =
    {field_arguments, 4},
    {field_declarator, 3},
    {field_placement, 1},
    {field_type, 2},
  [244] =
    {field_declarator, 4},
  [245] =
    {field_declarator, 0},
    {field_size, 3},
  [247] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [250] =
    {field_size, 2},
  [251] =
    {field_body, 4},
    {field_captures, 0},
    {field_constraint, 2},
    {field_declarator, 3},
    {field_template_parameters, 1},
  [256] =
    {field_declarator, 1},
    {field_default_value, 3},
  [258] =
    {field_alternative, 4},
    {field_condition, 1},
  [260] =
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_type, 1},
  [263] =
    {field_declarator, 3},
    {field_declarator, 4, .inherited = true},
    {field_type, 2},
  [266] =
    {field_declarator, 4},
    {field_type, 2},
  [268] =
    {field_arguments, 5},
    {field_declarator, 4},
    {field_placement, 2},
    {field_type, 3},
  [272] =
    {field_declarator, 1},
    {field_default_value, 2},
    {field_type, 0, .inherited = true},
  [275] =
    {field_body, 4},
    {field_name, 1},
  [277] =
    {field_body, 4},
    {field_name, 2},
  [279] =
    {field_body, 4},
  [280] =
    {field_body, 4},
    {field_name, 3},
  [282] =
    {field_declarator, 1},
    {field_type, 0, .inherited = true},
    {field_value, 3},
  [285] =
    {field_body, 5},
  [286] =
    {field_body, 5},
    {field_initializer, 2},
  [288] =
    {field_member, 4},
    {field_type, 2},
  [290] =
    {field_operand, 1},
    {field_operand, 2, .inherited = true},
  [292] =
    {field_assembly_code, 2},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [295] =
    {field_assembly_code, 3},
    {field_output_operands, 4},
  [297] =
    {field_default_type, 3},
    {field_name, 1},
  [299] =
    {field_declarator, 1},
    {field_default_value, 3},
    {field_type, 0, .inherited = true},
  [302] =
    {field_name, 1},
    {field_type, 4},
  [304] =
    {field_declarator, 4},
    {field_declarator, 5, .inherited = true},
    {field_type, 2},
  [307] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_default_value, 3},
    {field_type, 0, .inherited = true},
  [311] =
    {field_body, 5},
    {field_name, 2},
  [313] =
    {field_body, 5},
    {field_name, 3},
  [315] =
    {field_body, 6},
    {field_update, 4},
  [317] =
    {field_body, 6},
    {field_condition, 3},
  [319] =
    {field_body, 6},
    {field_initializer, 2},
    {field_update, 4},
  [322] =
    {field_body, 6},
    {field_condition, 3},
    {field_initializer, 2},
  [325] =
    {field_body, 6},
    {field_initializer, 2},
  [327] =
    {field_operand, 0, .inherited = true},
    {field_operand, 1, .inherited = true},
  [329] =
    {field_register, 1},
  [330] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [334] =
    {field_assembly_code, 3},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [337] =
    {field_condition, 2},
    {field_message, 4},
  [339] =
    {field_delimiter, 1},
  [340] =
    {field_declarator, 1},
    {field_declarator, 2, .inherited = true},
    {field_default_value, 4},
    {field_type, 0, .inherited = true},
  [344] =
    {field_body, 6},
    {field_name, 3},
  [346] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [349] =
    {field_body, 7},
    {field_condition, 3},
    {field_initializer, 2},
    {field_update, 5},
  [353] =
    {field_body, 7},
    {field_declarator, 3},
    {field_right, 5},
    {field_type, 2, .inherited = true},
  [357] =
    {field_body, 7},
    {field_initializer, 2},
    {field_update, 5},
  [360] =
    {field_body, 7},
    {field_condition, 4},
    {field_initializer, 2},
  [363] =
    {field_constraint, 0},
    {field_value, 2},
  [365] =
    {field_register, 1},
    {field_register, 2, .inherited = true},
  [367] =
    {field_assembly_code, 2},
    {field_clobbers, 5},
    {field_goto_labels, 6},
    {field_input_operands, 4},
    {field_output_operands, 3},
  [372] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [376] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
  [380] =
    {field_body, 8},
    {field_declarator, 4},
    {field_initializer, 2},
    {field_right, 6},
    {field_type, 3, .inherited = true},
  [385] =
    {field_register, 0, .inherited = true},
    {field_register, 1, .inherited = true},
  [387] =
    {field_label, 1},
    {field_label, 2, .inherited = true},
  [389] =
    {field_assembly_code, 3},
    {field_clobbers, 6},
    {field_goto_labels, 7},
    {field_input_operands, 5},
    {field_output_operands, 4},
  [394] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [396] =
    {field_constraint, 3},
    {field_symbol, 1},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [14] = {
    [0] = alias_sym_namespace_identifier,
  },
  [15] = {
    [0] = alias_sym_type_identifier,
  },
  [17] = {
    [0] = alias_sym_namespace_identifier,
  },
  [32] = {
    [1] = alias_sym_type_identifier,
  },
  [33] = {
    [1] = alias_sym_type_identifier,
  },
  [39] = {
    [0] = sym_primitive_type,
  },
  [40] = {
    [0] = sym_pointer_declarator,
  },
  [50] = {
    [1] = alias_sym_statement_identifier,
  },
  [52] = {
    [0] = alias_sym_statement_identifier,
  },
  [56] = {
    [1] = alias_sym_namespace_identifier,
  },
  [57] = {
    [1] = alias_sym_namespace_identifier,
  },
  [61] = {
    [0] = alias_sym_simple_requirement,
  },
  [67] = {
    [2] = alias_sym_field_identifier,
  },
  [86] = {
    [2] = alias_sym_namespace_identifier,
  },
  [88] = {
    [1] = alias_sym_field_identifier,
  },
  [90] = {
    [1] = alias_sym_type_identifier,
  },
  [93] = {
    [0] = alias_sym_field_identifier,
  },
  [98] = {
    [1] = alias_sym_type_identifier,
  },
  [107] = {
    [0] = alias_sym_field_identifier,
  },
  [108] = {
    [1] = alias_sym_field_identifier,
  },
  [141] = {
    [2] = alias_sym_type_identifier,
  },
  [145] = {
    [1] = alias_sym_namespace_identifier,
    [3] = alias_sym_namespace_identifier,
  },
  [146] = {
    [1] = alias_sym_namespace_identifier,
  },
  [147] = {
    [1] = alias_sym_type_identifier,
  },
  [170] = {
    [4] = alias_sym_field_identifier,
  },
  [174] = {
    [1] = alias_sym_type_identifier,
  },
  [176] = {
    [1] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_pointer_type_declarator, 2,
    sym_pointer_type_declarator,
    sym_pointer_declarator,
  sym_expression_statement, 2,
    sym_expression_statement,
    alias_sym_simple_requirement,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 2,
  [7] = 2,
  [8] = 2,
  [9] = 9,
  [10] = 3,
  [11] = 9,
  [12] = 3,
  [13] = 3,
  [14] = 3,
  [15] = 3,
  [16] = 3,
  [17] = 9,
  [18] = 9,
  [19] = 3,
  [20] = 9,
  [21] = 3,
  [22] = 22,
  [23] = 23,
  [24] = 22,
  [25] = 25,
  [26] = 22,
  [27] = 23,
  [28] = 23,
  [29] = 29,
  [30] = 22,
  [31] = 22,
  [32] = 32,
  [33] = 33,
  [34] = 23,
  [35] = 23,
  [36] = 36,
  [37] = 25,
  [38] = 38,
  [39] = 39,
  [40] = 25,
  [41] = 41,
  [42] = 39,
  [43] = 43,
  [44] = 39,
  [45] = 39,
  [46] = 39,
  [47] = 41,
  [48] = 43,
  [49] = 43,
  [50] = 50,
  [51] = 41,
  [52] = 50,
  [53] = 41,
  [54] = 50,
  [55] = 39,
  [56] = 50,
  [57] = 39,
  [58] = 43,
  [59] = 41,
  [60] = 39,
  [61] = 41,
  [62] = 50,
  [63] = 43,
  [64] = 41,
  [65] = 39,
  [66] = 41,
  [67] = 39,
  [68] = 25,
  [69] = 69,
  [70] = 41,
  [71] = 39,
  [72] = 41,
  [73] = 41,
  [74] = 39,
  [75] = 41,
  [76] = 39,
  [77] = 41,
  [78] = 39,
  [79] = 41,
  [80] = 39,
  [81] = 41,
  [82] = 39,
  [83] = 41,
  [84] = 41,
  [85] = 39,
  [86] = 39,
  [87] = 41,
  [88] = 39,
  [89] = 41,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 94,
  [98] = 96,
  [99] = 93,
  [100] = 92,
  [101] = 95,
  [102] = 93,
  [103] = 94,
  [104] = 95,
  [105] = 96,
  [106] = 92,
  [107] = 92,
  [108] = 95,
  [109] = 93,
  [110] = 95,
  [111] = 96,
  [112] = 94,
  [113] = 96,
  [114] = 93,
  [115] = 94,
  [116] = 92,
  [117] = 94,
  [118] = 93,
  [119] = 96,
  [120] = 92,
  [121] = 95,
  [122] = 122,
  [123] = 123,
  [124] = 123,
  [125] = 123,
  [126] = 123,
  [127] = 123,
  [128] = 123,
  [129] = 123,
  [130] = 130,
  [131] = 130,
  [132] = 130,
  [133] = 130,
  [134] = 130,
  [135] = 130,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 137,
  [140] = 137,
  [141] = 137,
  [142] = 142,
  [143] = 142,
  [144] = 142,
  [145] = 142,
  [146] = 142,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 148,
  [155] = 147,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 157,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 161,
  [168] = 168,
  [169] = 166,
  [170] = 162,
  [171] = 165,
  [172] = 164,
  [173] = 163,
  [174] = 150,
  [175] = 175,
  [176] = 176,
  [177] = 168,
  [178] = 178,
  [179] = 160,
  [180] = 178,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 160,
  [185] = 182,
  [186] = 149,
  [187] = 157,
  [188] = 158,
  [189] = 156,
  [190] = 181,
  [191] = 151,
  [192] = 175,
  [193] = 183,
  [194] = 175,
  [195] = 152,
  [196] = 147,
  [197] = 161,
  [198] = 165,
  [199] = 182,
  [200] = 181,
  [201] = 176,
  [202] = 166,
  [203] = 164,
  [204] = 163,
  [205] = 161,
  [206] = 162,
  [207] = 165,
  [208] = 164,
  [209] = 163,
  [210] = 150,
  [211] = 178,
  [212] = 149,
  [213] = 151,
  [214] = 183,
  [215] = 150,
  [216] = 175,
  [217] = 152,
  [218] = 178,
  [219] = 153,
  [220] = 148,
  [221] = 147,
  [222] = 156,
  [223] = 158,
  [224] = 160,
  [225] = 149,
  [226] = 176,
  [227] = 182,
  [228] = 181,
  [229] = 176,
  [230] = 183,
  [231] = 176,
  [232] = 168,
  [233] = 153,
  [234] = 176,
  [235] = 168,
  [236] = 148,
  [237] = 181,
  [238] = 151,
  [239] = 182,
  [240] = 161,
  [241] = 165,
  [242] = 164,
  [243] = 163,
  [244] = 150,
  [245] = 178,
  [246] = 168,
  [247] = 175,
  [248] = 162,
  [249] = 149,
  [250] = 157,
  [251] = 152,
  [252] = 151,
  [253] = 166,
  [254] = 166,
  [255] = 162,
  [256] = 162,
  [257] = 157,
  [258] = 152,
  [259] = 153,
  [260] = 168,
  [261] = 183,
  [262] = 147,
  [263] = 156,
  [264] = 157,
  [265] = 158,
  [266] = 153,
  [267] = 183,
  [268] = 158,
  [269] = 166,
  [270] = 156,
  [271] = 147,
  [272] = 148,
  [273] = 153,
  [274] = 160,
  [275] = 148,
  [276] = 152,
  [277] = 151,
  [278] = 149,
  [279] = 175,
  [280] = 178,
  [281] = 182,
  [282] = 150,
  [283] = 181,
  [284] = 161,
  [285] = 165,
  [286] = 166,
  [287] = 164,
  [288] = 163,
  [289] = 150,
  [290] = 178,
  [291] = 149,
  [292] = 151,
  [293] = 152,
  [294] = 153,
  [295] = 158,
  [296] = 147,
  [297] = 148,
  [298] = 156,
  [299] = 158,
  [300] = 163,
  [301] = 156,
  [302] = 164,
  [303] = 165,
  [304] = 161,
  [305] = 181,
  [306] = 182,
  [307] = 175,
  [308] = 160,
  [309] = 183,
  [310] = 160,
  [311] = 157,
  [312] = 162,
  [313] = 168,
  [314] = 314,
  [315] = 315,
  [316] = 315,
  [317] = 314,
  [318] = 314,
  [319] = 315,
  [320] = 314,
  [321] = 321,
  [322] = 314,
  [323] = 314,
  [324] = 315,
  [325] = 315,
  [326] = 315,
  [327] = 315,
  [328] = 328,
  [329] = 315,
  [330] = 314,
  [331] = 314,
  [332] = 314,
  [333] = 315,
  [334] = 334,
  [335] = 334,
  [336] = 336,
  [337] = 336,
  [338] = 336,
  [339] = 334,
  [340] = 336,
  [341] = 334,
  [342] = 342,
  [343] = 342,
  [344] = 342,
  [345] = 342,
  [346] = 346,
  [347] = 342,
  [348] = 342,
  [349] = 342,
  [350] = 342,
  [351] = 342,
  [352] = 342,
  [353] = 342,
  [354] = 342,
  [355] = 342,
  [356] = 356,
  [357] = 342,
  [358] = 342,
  [359] = 342,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 361,
  [366] = 361,
  [367] = 363,
  [368] = 362,
  [369] = 361,
  [370] = 370,
  [371] = 371,
  [372] = 362,
  [373] = 362,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 356,
  [378] = 378,
  [379] = 328,
  [380] = 380,
  [381] = 321,
  [382] = 346,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 388,
  [395] = 389,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 385,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 374,
  [406] = 406,
  [407] = 364,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 385,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 389,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 389,
  [436] = 436,
  [437] = 388,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 388,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 388,
  [452] = 452,
  [453] = 389,
  [454] = 385,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 385,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 385,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 385,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 388,
  [486] = 389,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 388,
  [509] = 389,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 371,
  [528] = 346,
  [529] = 380,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 378,
  [547] = 547,
  [548] = 548,
  [549] = 321,
  [550] = 550,
  [551] = 551,
  [552] = 328,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 356,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 376,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 346,
  [565] = 565,
  [566] = 566,
  [567] = 346,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 142,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 356,
  [593] = 593,
  [594] = 594,
  [595] = 356,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 519,
  [602] = 386,
  [603] = 489,
  [604] = 520,
  [605] = 605,
  [606] = 383,
  [607] = 404,
  [608] = 521,
  [609] = 513,
  [610] = 398,
  [611] = 523,
  [612] = 416,
  [613] = 488,
  [614] = 487,
  [615] = 481,
  [616] = 479,
  [617] = 364,
  [618] = 524,
  [619] = 525,
  [620] = 472,
  [621] = 491,
  [622] = 526,
  [623] = 478,
  [624] = 384,
  [625] = 445,
  [626] = 626,
  [627] = 477,
  [628] = 476,
  [629] = 626,
  [630] = 466,
  [631] = 430,
  [632] = 429,
  [633] = 461,
  [634] = 490,
  [635] = 492,
  [636] = 626,
  [637] = 428,
  [638] = 412,
  [639] = 424,
  [640] = 518,
  [641] = 517,
  [642] = 474,
  [643] = 465,
  [644] = 387,
  [645] = 516,
  [646] = 473,
  [647] = 374,
  [648] = 510,
  [649] = 484,
  [650] = 457,
  [651] = 522,
  [652] = 470,
  [653] = 605,
  [654] = 605,
  [655] = 626,
  [656] = 397,
  [657] = 515,
  [658] = 468,
  [659] = 401,
  [660] = 371,
  [661] = 661,
  [662] = 467,
  [663] = 505,
  [664] = 471,
  [665] = 402,
  [666] = 444,
  [667] = 443,
  [668] = 446,
  [669] = 448,
  [670] = 403,
  [671] = 499,
  [672] = 514,
  [673] = 449,
  [674] = 475,
  [675] = 413,
  [676] = 414,
  [677] = 450,
  [678] = 415,
  [679] = 418,
  [680] = 495,
  [681] = 681,
  [682] = 419,
  [683] = 371,
  [684] = 420,
  [685] = 460,
  [686] = 605,
  [687] = 374,
  [688] = 496,
  [689] = 626,
  [690] = 605,
  [691] = 364,
  [692] = 483,
  [693] = 455,
  [694] = 626,
  [695] = 422,
  [696] = 425,
  [697] = 605,
  [698] = 390,
  [699] = 605,
  [700] = 626,
  [701] = 482,
  [702] = 452,
  [703] = 511,
  [704] = 423,
  [705] = 494,
  [706] = 498,
  [707] = 507,
  [708] = 500,
  [709] = 391,
  [710] = 393,
  [711] = 506,
  [712] = 605,
  [713] = 512,
  [714] = 417,
  [715] = 459,
  [716] = 410,
  [717] = 409,
  [718] = 426,
  [719] = 501,
  [720] = 427,
  [721] = 408,
  [722] = 502,
  [723] = 463,
  [724] = 503,
  [725] = 433,
  [726] = 626,
  [727] = 406,
  [728] = 504,
  [729] = 464,
  [730] = 392,
  [731] = 626,
  [732] = 497,
  [733] = 605,
  [734] = 399,
  [735] = 431,
  [736] = 396,
  [737] = 432,
  [738] = 436,
  [739] = 438,
  [740] = 439,
  [741] = 441,
  [742] = 462,
  [743] = 456,
  [744] = 434,
  [745] = 493,
  [746] = 440,
  [747] = 442,
  [748] = 535,
  [749] = 598,
  [750] = 594,
  [751] = 584,
  [752] = 576,
  [753] = 589,
  [754] = 380,
  [755] = 579,
  [756] = 374,
  [757] = 588,
  [758] = 590,
  [759] = 551,
  [760] = 547,
  [761] = 376,
  [762] = 577,
  [763] = 578,
  [764] = 376,
  [765] = 580,
  [766] = 581,
  [767] = 591,
  [768] = 545,
  [769] = 586,
  [770] = 573,
  [771] = 555,
  [772] = 378,
  [773] = 328,
  [774] = 574,
  [775] = 328,
  [776] = 565,
  [777] = 557,
  [778] = 554,
  [779] = 321,
  [780] = 530,
  [781] = 532,
  [782] = 542,
  [783] = 543,
  [784] = 371,
  [785] = 597,
  [786] = 142,
  [787] = 585,
  [788] = 378,
  [789] = 544,
  [790] = 548,
  [791] = 572,
  [792] = 553,
  [793] = 561,
  [794] = 539,
  [795] = 531,
  [796] = 562,
  [797] = 537,
  [798] = 582,
  [799] = 538,
  [800] = 599,
  [801] = 587,
  [802] = 540,
  [803] = 541,
  [804] = 569,
  [805] = 575,
  [806] = 558,
  [807] = 563,
  [808] = 380,
  [809] = 321,
  [810] = 566,
  [811] = 570,
  [812] = 142,
  [813] = 600,
  [814] = 596,
  [815] = 376,
  [816] = 380,
  [817] = 536,
  [818] = 534,
  [819] = 378,
  [820] = 533,
  [821] = 559,
  [822] = 550,
  [823] = 568,
  [824] = 583,
  [825] = 593,
  [826] = 433,
  [827] = 404,
  [828] = 413,
  [829] = 429,
  [830] = 391,
  [831] = 459,
  [832] = 430,
  [833] = 522,
  [834] = 493,
  [835] = 497,
  [836] = 503,
  [837] = 505,
  [838] = 510,
  [839] = 460,
  [840] = 396,
  [841] = 399,
  [842] = 498,
  [843] = 511,
  [844] = 500,
  [845] = 501,
  [846] = 384,
  [847] = 526,
  [848] = 502,
  [849] = 504,
  [850] = 506,
  [851] = 507,
  [852] = 525,
  [853] = 524,
  [854] = 523,
  [855] = 512,
  [856] = 513,
  [857] = 521,
  [858] = 514,
  [859] = 406,
  [860] = 499,
  [861] = 520,
  [862] = 519,
  [863] = 515,
  [864] = 516,
  [865] = 517,
  [866] = 518,
  [867] = 517,
  [868] = 516,
  [869] = 515,
  [870] = 514,
  [871] = 408,
  [872] = 518,
  [873] = 409,
  [874] = 410,
  [875] = 142,
  [876] = 513,
  [877] = 422,
  [878] = 417,
  [879] = 425,
  [880] = 423,
  [881] = 496,
  [882] = 519,
  [883] = 428,
  [884] = 520,
  [885] = 512,
  [886] = 507,
  [887] = 521,
  [888] = 523,
  [889] = 524,
  [890] = 525,
  [891] = 506,
  [892] = 415,
  [893] = 504,
  [894] = 461,
  [895] = 452,
  [896] = 502,
  [897] = 526,
  [898] = 501,
  [899] = 500,
  [900] = 498,
  [901] = 390,
  [902] = 496,
  [903] = 416,
  [904] = 495,
  [905] = 418,
  [906] = 412,
  [907] = 384,
  [908] = 490,
  [909] = 511,
  [910] = 489,
  [911] = 510,
  [912] = 505,
  [913] = 488,
  [914] = 487,
  [915] = 481,
  [916] = 479,
  [917] = 478,
  [918] = 477,
  [919] = 522,
  [920] = 426,
  [921] = 476,
  [922] = 465,
  [923] = 457,
  [924] = 503,
  [925] = 402,
  [926] = 403,
  [927] = 404,
  [928] = 497,
  [929] = 493,
  [930] = 424,
  [931] = 474,
  [932] = 392,
  [933] = 492,
  [934] = 416,
  [935] = 495,
  [936] = 387,
  [937] = 491,
  [938] = 459,
  [939] = 383,
  [940] = 484,
  [941] = 398,
  [942] = 424,
  [943] = 472,
  [944] = 483,
  [945] = 412,
  [946] = 482,
  [947] = 462,
  [948] = 456,
  [949] = 475,
  [950] = 474,
  [951] = 427,
  [952] = 433,
  [953] = 492,
  [954] = 416,
  [955] = 387,
  [956] = 491,
  [957] = 424,
  [958] = 474,
  [959] = 499,
  [960] = 387,
  [961] = 398,
  [962] = 397,
  [963] = 445,
  [964] = 473,
  [965] = 383,
  [966] = 484,
  [967] = 483,
  [968] = 482,
  [969] = 440,
  [970] = 419,
  [971] = 436,
  [972] = 475,
  [973] = 473,
  [974] = 434,
  [975] = 471,
  [976] = 438,
  [977] = 396,
  [978] = 399,
  [979] = 471,
  [980] = 470,
  [981] = 468,
  [982] = 467,
  [983] = 432,
  [984] = 431,
  [985] = 470,
  [986] = 466,
  [987] = 397,
  [988] = 439,
  [989] = 464,
  [990] = 404,
  [991] = 403,
  [992] = 401,
  [993] = 402,
  [994] = 406,
  [995] = 499,
  [996] = 468,
  [997] = 499,
  [998] = 408,
  [999] = 467,
  [1000] = 452,
  [1001] = 409,
  [1002] = 461,
  [1003] = 410,
  [1004] = 466,
  [1005] = 452,
  [1006] = 417,
  [1007] = 463,
  [1008] = 494,
  [1009] = 461,
  [1010] = 455,
  [1011] = 450,
  [1012] = 386,
  [1013] = 423,
  [1014] = 449,
  [1015] = 448,
  [1016] = 446,
  [1017] = 444,
  [1018] = 390,
  [1019] = 442,
  [1020] = 441,
  [1021] = 439,
  [1022] = 441,
  [1023] = 464,
  [1024] = 391,
  [1025] = 390,
  [1026] = 391,
  [1027] = 463,
  [1028] = 438,
  [1029] = 436,
  [1030] = 494,
  [1031] = 455,
  [1032] = 427,
  [1033] = 426,
  [1034] = 425,
  [1035] = 443,
  [1036] = 422,
  [1037] = 460,
  [1038] = 450,
  [1039] = 420,
  [1040] = 419,
  [1041] = 418,
  [1042] = 415,
  [1043] = 414,
  [1044] = 413,
  [1045] = 431,
  [1046] = 386,
  [1047] = 413,
  [1048] = 414,
  [1049] = 415,
  [1050] = 418,
  [1051] = 419,
  [1052] = 420,
  [1053] = 460,
  [1054] = 422,
  [1055] = 425,
  [1056] = 393,
  [1057] = 426,
  [1058] = 427,
  [1059] = 433,
  [1060] = 436,
  [1061] = 438,
  [1062] = 439,
  [1063] = 444,
  [1064] = 441,
  [1065] = 442,
  [1066] = 444,
  [1067] = 446,
  [1068] = 448,
  [1069] = 449,
  [1070] = 450,
  [1071] = 432,
  [1072] = 455,
  [1073] = 443,
  [1074] = 449,
  [1075] = 494,
  [1076] = 448,
  [1077] = 463,
  [1078] = 398,
  [1079] = 396,
  [1080] = 464,
  [1081] = 466,
  [1082] = 467,
  [1083] = 468,
  [1084] = 470,
  [1085] = 471,
  [1086] = 473,
  [1087] = 490,
  [1088] = 472,
  [1089] = 475,
  [1090] = 462,
  [1091] = 482,
  [1092] = 456,
  [1093] = 483,
  [1094] = 484,
  [1095] = 383,
  [1096] = 491,
  [1097] = 399,
  [1098] = 492,
  [1099] = 401,
  [1100] = 434,
  [1101] = 489,
  [1102] = 472,
  [1103] = 462,
  [1104] = 493,
  [1105] = 497,
  [1106] = 503,
  [1107] = 505,
  [1108] = 510,
  [1109] = 511,
  [1110] = 488,
  [1111] = 384,
  [1112] = 526,
  [1113] = 525,
  [1114] = 524,
  [1115] = 523,
  [1116] = 521,
  [1117] = 520,
  [1118] = 519,
  [1119] = 518,
  [1120] = 517,
  [1121] = 487,
  [1122] = 516,
  [1123] = 392,
  [1124] = 515,
  [1125] = 514,
  [1126] = 522,
  [1127] = 513,
  [1128] = 512,
  [1129] = 507,
  [1130] = 506,
  [1131] = 504,
  [1132] = 502,
  [1133] = 501,
  [1134] = 500,
  [1135] = 498,
  [1136] = 496,
  [1137] = 495,
  [1138] = 412,
  [1139] = 490,
  [1140] = 481,
  [1141] = 489,
  [1142] = 488,
  [1143] = 487,
  [1144] = 481,
  [1145] = 479,
  [1146] = 478,
  [1147] = 477,
  [1148] = 476,
  [1149] = 465,
  [1150] = 457,
  [1151] = 459,
  [1152] = 479,
  [1153] = 456,
  [1154] = 393,
  [1155] = 478,
  [1156] = 406,
  [1157] = 443,
  [1158] = 445,
  [1159] = 401,
  [1160] = 477,
  [1161] = 397,
  [1162] = 440,
  [1163] = 434,
  [1164] = 423,
  [1165] = 432,
  [1166] = 431,
  [1167] = 386,
  [1168] = 476,
  [1169] = 417,
  [1170] = 430,
  [1171] = 429,
  [1172] = 428,
  [1173] = 440,
  [1174] = 465,
  [1175] = 445,
  [1176] = 410,
  [1177] = 392,
  [1178] = 446,
  [1179] = 442,
  [1180] = 393,
  [1181] = 430,
  [1182] = 429,
  [1183] = 409,
  [1184] = 428,
  [1185] = 420,
  [1186] = 457,
  [1187] = 402,
  [1188] = 403,
  [1189] = 408,
  [1190] = 414,
  [1191] = 541,
  [1192] = 589,
  [1193] = 574,
  [1194] = 586,
  [1195] = 573,
  [1196] = 581,
  [1197] = 577,
  [1198] = 583,
  [1199] = 587,
  [1200] = 585,
  [1201] = 593,
  [1202] = 598,
  [1203] = 576,
  [1204] = 579,
  [1205] = 580,
  [1206] = 530,
  [1207] = 578,
  [1208] = 577,
  [1209] = 530,
  [1210] = 555,
  [1211] = 565,
  [1212] = 557,
  [1213] = 591,
  [1214] = 545,
  [1215] = 545,
  [1216] = 591,
  [1217] = 573,
  [1218] = 554,
  [1219] = 570,
  [1220] = 566,
  [1221] = 563,
  [1222] = 553,
  [1223] = 559,
  [1224] = 576,
  [1225] = 550,
  [1226] = 586,
  [1227] = 572,
  [1228] = 589,
  [1229] = 553,
  [1230] = 547,
  [1231] = 584,
  [1232] = 581,
  [1233] = 532,
  [1234] = 542,
  [1235] = 533,
  [1236] = 555,
  [1237] = 575,
  [1238] = 587,
  [1239] = 580,
  [1240] = 579,
  [1241] = 534,
  [1242] = 536,
  [1243] = 578,
  [1244] = 539,
  [1245] = 531,
  [1246] = 535,
  [1247] = 539,
  [1248] = 537,
  [1249] = 568,
  [1250] = 540,
  [1251] = 538,
  [1252] = 575,
  [1253] = 572,
  [1254] = 558,
  [1255] = 569,
  [1256] = 597,
  [1257] = 594,
  [1258] = 574,
  [1259] = 565,
  [1260] = 557,
  [1261] = 554,
  [1262] = 596,
  [1263] = 599,
  [1264] = 551,
  [1265] = 600,
  [1266] = 585,
  [1267] = 582,
  [1268] = 551,
  [1269] = 532,
  [1270] = 547,
  [1271] = 568,
  [1272] = 543,
  [1273] = 544,
  [1274] = 548,
  [1275] = 583,
  [1276] = 588,
  [1277] = 562,
  [1278] = 590,
  [1279] = 561,
  [1280] = 562,
  [1281] = 561,
  [1282] = 558,
  [1283] = 590,
  [1284] = 588,
  [1285] = 597,
  [1286] = 542,
  [1287] = 548,
  [1288] = 582,
  [1289] = 598,
  [1290] = 584,
  [1291] = 544,
  [1292] = 600,
  [1293] = 596,
  [1294] = 599,
  [1295] = 543,
  [1296] = 569,
  [1297] = 541,
  [1298] = 540,
  [1299] = 594,
  [1300] = 593,
  [1301] = 563,
  [1302] = 538,
  [1303] = 537,
  [1304] = 535,
  [1305] = 531,
  [1306] = 536,
  [1307] = 534,
  [1308] = 566,
  [1309] = 533,
  [1310] = 550,
  [1311] = 559,
  [1312] = 570,
  [1313] = 599,
  [1314] = 572,
  [1315] = 555,
  [1316] = 536,
  [1317] = 568,
  [1318] = 534,
  [1319] = 531,
  [1320] = 588,
  [1321] = 590,
  [1322] = 535,
  [1323] = 537,
  [1324] = 538,
  [1325] = 533,
  [1326] = 584,
  [1327] = 550,
  [1328] = 582,
  [1329] = 583,
  [1330] = 587,
  [1331] = 540,
  [1332] = 541,
  [1333] = 585,
  [1334] = 593,
  [1335] = 598,
  [1336] = 543,
  [1337] = 544,
  [1338] = 548,
  [1339] = 539,
  [1340] = 559,
  [1341] = 563,
  [1342] = 591,
  [1343] = 566,
  [1344] = 594,
  [1345] = 597,
  [1346] = 570,
  [1347] = 574,
  [1348] = 530,
  [1349] = 547,
  [1350] = 600,
  [1351] = 589,
  [1352] = 565,
  [1353] = 557,
  [1354] = 575,
  [1355] = 596,
  [1356] = 554,
  [1357] = 551,
  [1358] = 553,
  [1359] = 581,
  [1360] = 558,
  [1361] = 569,
  [1362] = 545,
  [1363] = 562,
  [1364] = 586,
  [1365] = 577,
  [1366] = 578,
  [1367] = 579,
  [1368] = 561,
  [1369] = 542,
  [1370] = 573,
  [1371] = 532,
  [1372] = 1372,
  [1373] = 576,
  [1374] = 580,
  [1375] = 1375,
  [1376] = 1375,
  [1377] = 1377,
  [1378] = 1377,
  [1379] = 1377,
  [1380] = 1377,
  [1381] = 1377,
  [1382] = 1377,
  [1383] = 1377,
  [1384] = 1377,
  [1385] = 1377,
  [1386] = 1386,
  [1387] = 1386,
  [1388] = 1386,
  [1389] = 1386,
  [1390] = 1386,
  [1391] = 1386,
  [1392] = 1386,
  [1393] = 1386,
  [1394] = 1386,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1398,
  [1400] = 1400,
  [1401] = 1398,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1397,
  [1405] = 1397,
  [1406] = 1406,
  [1407] = 1398,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1397,
  [1411] = 1411,
  [1412] = 1403,
  [1413] = 1413,
  [1414] = 1406,
  [1415] = 1415,
  [1416] = 1400,
  [1417] = 1409,
  [1418] = 1418,
  [1419] = 1413,
  [1420] = 1420,
  [1421] = 1420,
  [1422] = 1422,
  [1423] = 1420,
  [1424] = 1422,
  [1425] = 1420,
  [1426] = 1420,
  [1427] = 1422,
  [1428] = 1428,
  [1429] = 1422,
  [1430] = 1420,
  [1431] = 1431,
  [1432] = 1422,
  [1433] = 1420,
  [1434] = 1420,
  [1435] = 1422,
  [1436] = 1422,
  [1437] = 1420,
  [1438] = 1422,
  [1439] = 1422,
  [1440] = 1440,
  [1441] = 1440,
  [1442] = 346,
  [1443] = 1440,
  [1444] = 1440,
  [1445] = 1440,
  [1446] = 1440,
  [1447] = 356,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1449,
  [1451] = 1449,
  [1452] = 1452,
  [1453] = 1449,
  [1454] = 1452,
  [1455] = 1452,
  [1456] = 1452,
  [1457] = 1452,
  [1458] = 1449,
  [1459] = 1449,
  [1460] = 1452,
  [1461] = 376,
  [1462] = 321,
  [1463] = 328,
  [1464] = 380,
  [1465] = 378,
  [1466] = 1466,
  [1467] = 489,
  [1468] = 495,
  [1469] = 491,
  [1470] = 383,
  [1471] = 484,
  [1472] = 483,
  [1473] = 482,
  [1474] = 475,
  [1475] = 473,
  [1476] = 471,
  [1477] = 416,
  [1478] = 503,
  [1479] = 470,
  [1480] = 468,
  [1481] = 467,
  [1482] = 1408,
  [1483] = 398,
  [1484] = 461,
  [1485] = 430,
  [1486] = 429,
  [1487] = 493,
  [1488] = 466,
  [1489] = 464,
  [1490] = 463,
  [1491] = 494,
  [1492] = 452,
  [1493] = 455,
  [1494] = 450,
  [1495] = 449,
  [1496] = 448,
  [1497] = 428,
  [1498] = 446,
  [1499] = 444,
  [1500] = 442,
  [1501] = 441,
  [1502] = 439,
  [1503] = 438,
  [1504] = 497,
  [1505] = 396,
  [1506] = 505,
  [1507] = 510,
  [1508] = 511,
  [1509] = 399,
  [1510] = 384,
  [1511] = 526,
  [1512] = 525,
  [1513] = 524,
  [1514] = 523,
  [1515] = 521,
  [1516] = 520,
  [1517] = 519,
  [1518] = 518,
  [1519] = 517,
  [1520] = 516,
  [1521] = 515,
  [1522] = 514,
  [1523] = 513,
  [1524] = 512,
  [1525] = 390,
  [1526] = 507,
  [1527] = 406,
  [1528] = 506,
  [1529] = 391,
  [1530] = 504,
  [1531] = 502,
  [1532] = 501,
  [1533] = 500,
  [1534] = 498,
  [1535] = 496,
  [1536] = 492,
  [1537] = 412,
  [1538] = 386,
  [1539] = 490,
  [1540] = 488,
  [1541] = 487,
  [1542] = 481,
  [1543] = 479,
  [1544] = 472,
  [1545] = 478,
  [1546] = 408,
  [1547] = 477,
  [1548] = 476,
  [1549] = 436,
  [1550] = 1431,
  [1551] = 433,
  [1552] = 427,
  [1553] = 465,
  [1554] = 426,
  [1555] = 425,
  [1556] = 422,
  [1557] = 460,
  [1558] = 420,
  [1559] = 419,
  [1560] = 418,
  [1561] = 415,
  [1562] = 462,
  [1563] = 457,
  [1564] = 414,
  [1565] = 413,
  [1566] = 456,
  [1567] = 409,
  [1568] = 445,
  [1569] = 440,
  [1570] = 434,
  [1571] = 432,
  [1572] = 431,
  [1573] = 424,
  [1574] = 474,
  [1575] = 387,
  [1576] = 410,
  [1577] = 392,
  [1578] = 417,
  [1579] = 404,
  [1580] = 423,
  [1581] = 397,
  [1582] = 402,
  [1583] = 401,
  [1584] = 403,
  [1585] = 459,
  [1586] = 1402,
  [1587] = 393,
  [1588] = 443,
  [1589] = 522,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1591,
  [1593] = 1591,
  [1594] = 1591,
  [1595] = 1595,
  [1596] = 1595,
  [1597] = 1595,
  [1598] = 1595,
  [1599] = 1595,
  [1600] = 1595,
  [1601] = 1591,
  [1602] = 1591,
  [1603] = 1591,
  [1604] = 1591,
  [1605] = 1591,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1608,
  [1611] = 1611,
  [1612] = 1608,
  [1613] = 1608,
  [1614] = 1606,
  [1615] = 1615,
  [1616] = 1611,
  [1617] = 1611,
  [1618] = 1606,
  [1619] = 1607,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1611,
  [1623] = 1609,
  [1624] = 1609,
  [1625] = 1607,
  [1626] = 1621,
  [1627] = 1609,
  [1628] = 1621,
  [1629] = 1606,
  [1630] = 1621,
  [1631] = 1631,
  [1632] = 1606,
  [1633] = 1607,
  [1634] = 1621,
  [1635] = 1635,
  [1636] = 1606,
  [1637] = 1607,
  [1638] = 1609,
  [1639] = 1609,
  [1640] = 1611,
  [1641] = 1611,
  [1642] = 1606,
  [1643] = 1607,
  [1644] = 1621,
  [1645] = 1607,
  [1646] = 1609,
  [1647] = 1621,
  [1648] = 1611,
  [1649] = 1609,
  [1650] = 1621,
  [1651] = 1611,
  [1652] = 1606,
  [1653] = 1621,
  [1654] = 1611,
  [1655] = 1606,
  [1656] = 1609,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1658,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1663,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1658,
  [1669] = 1669,
  [1670] = 1660,
  [1671] = 1659,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1661,
  [1675] = 1666,
  [1676] = 1659,
  [1677] = 1677,
  [1678] = 1666,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1660,
  [1682] = 1667,
  [1683] = 1661,
  [1684] = 1672,
  [1685] = 1658,
  [1686] = 1663,
  [1687] = 1667,
  [1688] = 1669,
  [1689] = 1666,
  [1690] = 1659,
  [1691] = 1661,
  [1692] = 1658,
  [1693] = 1663,
  [1694] = 1669,
  [1695] = 1659,
  [1696] = 1673,
  [1697] = 1669,
  [1698] = 1661,
  [1699] = 1672,
  [1700] = 1680,
  [1701] = 1669,
  [1702] = 1657,
  [1703] = 1703,
  [1704] = 1657,
  [1705] = 1658,
  [1706] = 1680,
  [1707] = 1680,
  [1708] = 1663,
  [1709] = 1664,
  [1710] = 1673,
  [1711] = 1669,
  [1712] = 1664,
  [1713] = 1659,
  [1714] = 1664,
  [1715] = 1673,
  [1716] = 1667,
  [1717] = 1664,
  [1718] = 1673,
  [1719] = 1664,
  [1720] = 1661,
  [1721] = 1666,
  [1722] = 1667,
  [1723] = 1723,
  [1724] = 1667,
  [1725] = 1672,
  [1726] = 1661,
  [1727] = 1666,
  [1728] = 1673,
  [1729] = 1666,
  [1730] = 1659,
  [1731] = 1669,
  [1732] = 1666,
  [1733] = 1663,
  [1734] = 1658,
  [1735] = 1660,
  [1736] = 1666,
  [1737] = 1667,
  [1738] = 1680,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1664,
  [1742] = 1673,
  [1743] = 1663,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1748,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1763,
  [1769] = 1763,
  [1770] = 1755,
  [1771] = 1771,
  [1772] = 1763,
  [1773] = 1773,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1763,
  [1779] = 1748,
  [1780] = 1748,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1755,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1792,
  [1794] = 1783,
  [1795] = 1755,
  [1796] = 1783,
  [1797] = 1797,
  [1798] = 1748,
  [1799] = 1799,
  [1800] = 1755,
  [1801] = 1783,
  [1802] = 1763,
  [1803] = 1755,
  [1804] = 1797,
  [1805] = 1744,
  [1806] = 1748,
  [1807] = 1763,
  [1808] = 1808,
  [1809] = 1773,
  [1810] = 1792,
  [1811] = 1763,
  [1812] = 1751,
  [1813] = 1755,
  [1814] = 1763,
  [1815] = 1783,
  [1816] = 1797,
  [1817] = 1797,
  [1818] = 1748,
  [1819] = 1744,
  [1820] = 1773,
  [1821] = 1792,
  [1822] = 1755,
  [1823] = 1748,
  [1824] = 1797,
  [1825] = 1755,
  [1826] = 1783,
  [1827] = 1797,
  [1828] = 1748,
  [1829] = 1745,
  [1830] = 1791,
  [1831] = 1744,
  [1832] = 1773,
  [1833] = 1781,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 1836,
  [1837] = 1837,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1841,
  [1844] = 1844,
  [1845] = 1845,
  [1846] = 1846,
  [1847] = 1836,
  [1848] = 1848,
  [1849] = 1849,
  [1850] = 1845,
  [1851] = 1834,
  [1852] = 1852,
  [1853] = 1853,
  [1854] = 1839,
  [1855] = 1846,
  [1856] = 1846,
  [1857] = 1842,
  [1858] = 1845,
  [1859] = 1844,
  [1860] = 1849,
  [1861] = 1834,
  [1862] = 1862,
  [1863] = 1852,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 1869,
  [1870] = 1870,
  [1871] = 1841,
  [1872] = 1840,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1852,
  [1876] = 1876,
  [1877] = 1877,
  [1878] = 1878,
  [1879] = 1879,
  [1880] = 1862,
  [1881] = 1881,
  [1882] = 1837,
  [1883] = 1834,
  [1884] = 1852,
  [1885] = 1885,
  [1886] = 1835,
  [1887] = 1839,
  [1888] = 1849,
  [1889] = 1848,
  [1890] = 1845,
  [1891] = 1842,
  [1892] = 1892,
  [1893] = 1844,
  [1894] = 1848,
  [1895] = 1895,
  [1896] = 1864,
  [1897] = 1881,
  [1898] = 1841,
  [1899] = 1844,
  [1900] = 1842,
  [1901] = 1842,
  [1902] = 1902,
  [1903] = 1844,
  [1904] = 1864,
  [1905] = 1845,
  [1906] = 1865,
  [1907] = 1846,
  [1908] = 1839,
  [1909] = 1849,
  [1910] = 1885,
  [1911] = 1848,
  [1912] = 1862,
  [1913] = 1866,
  [1914] = 1852,
  [1915] = 1867,
  [1916] = 1862,
  [1917] = 1868,
  [1918] = 1852,
  [1919] = 1881,
  [1920] = 1834,
  [1921] = 1869,
  [1922] = 1878,
  [1923] = 1877,
  [1924] = 1870,
  [1925] = 1874,
  [1926] = 1876,
  [1927] = 1874,
  [1928] = 1849,
  [1929] = 1870,
  [1930] = 1844,
  [1931] = 1869,
  [1932] = 1868,
  [1933] = 1852,
  [1934] = 1867,
  [1935] = 1862,
  [1936] = 1936,
  [1937] = 1866,
  [1938] = 1837,
  [1939] = 1862,
  [1940] = 1849,
  [1941] = 1852,
  [1942] = 1862,
  [1943] = 1849,
  [1944] = 1873,
  [1945] = 1885,
  [1946] = 1852,
  [1947] = 1876,
  [1948] = 1862,
  [1949] = 1849,
  [1950] = 1840,
  [1951] = 1835,
  [1952] = 1877,
  [1953] = 1846,
  [1954] = 1845,
  [1955] = 1841,
  [1956] = 1835,
  [1957] = 1853,
  [1958] = 1878,
  [1959] = 1881,
  [1960] = 1881,
  [1961] = 1841,
  [1962] = 1840,
  [1963] = 1839,
  [1964] = 1846,
  [1965] = 1835,
  [1966] = 1840,
  [1967] = 1842,
  [1968] = 1864,
  [1969] = 1881,
  [1970] = 1878,
  [1971] = 1835,
  [1972] = 1885,
  [1973] = 1881,
  [1974] = 1877,
  [1975] = 1876,
  [1976] = 1874,
  [1977] = 1902,
  [1978] = 1978,
  [1979] = 1870,
  [1980] = 1878,
  [1981] = 1981,
  [1982] = 1846,
  [1983] = 1869,
  [1984] = 1845,
  [1985] = 1868,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 1867,
  [1989] = 1877,
  [1990] = 1865,
  [1991] = 1866,
  [1992] = 1866,
  [1993] = 1865,
  [1994] = 1865,
  [1995] = 1867,
  [1996] = 1866,
  [1997] = 1853,
  [1998] = 1853,
  [1999] = 1864,
  [2000] = 1868,
  [2001] = 1885,
  [2002] = 1869,
  [2003] = 1870,
  [2004] = 1864,
  [2005] = 1874,
  [2006] = 1885,
  [2007] = 1876,
  [2008] = 1835,
  [2009] = 1840,
  [2010] = 1877,
  [2011] = 1878,
  [2012] = 1853,
  [2013] = 1853,
  [2014] = 1853,
  [2015] = 1864,
  [2016] = 1862,
  [2017] = 1834,
  [2018] = 1853,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 1853,
  [2022] = 1873,
  [2023] = 1865,
  [2024] = 1866,
  [2025] = 1881,
  [2026] = 1867,
  [2027] = 1876,
  [2028] = 1874,
  [2029] = 2029,
  [2030] = 1878,
  [2031] = 1877,
  [2032] = 1876,
  [2033] = 1874,
  [2034] = 1870,
  [2035] = 1868,
  [2036] = 1869,
  [2037] = 1840,
  [2038] = 1868,
  [2039] = 1867,
  [2040] = 1836,
  [2041] = 1835,
  [2042] = 1866,
  [2043] = 1864,
  [2044] = 1865,
  [2045] = 1869,
  [2046] = 2046,
  [2047] = 1870,
  [2048] = 1885,
  [2049] = 1870,
  [2050] = 1869,
  [2051] = 1874,
  [2052] = 1876,
  [2053] = 1868,
  [2054] = 1867,
  [2055] = 2055,
  [2056] = 1849,
  [2057] = 1877,
  [2058] = 1873,
  [2059] = 1878,
  [2060] = 1846,
  [2061] = 1845,
  [2062] = 1835,
  [2063] = 1836,
  [2064] = 1865,
  [2065] = 1840,
  [2066] = 1878,
  [2067] = 1885,
  [2068] = 1877,
  [2069] = 1876,
  [2070] = 1874,
  [2071] = 1870,
  [2072] = 1869,
  [2073] = 1868,
  [2074] = 1867,
  [2075] = 1866,
  [2076] = 1865,
  [2077] = 2077,
  [2078] = 1841,
  [2079] = 1846,
  [2080] = 1840,
  [2081] = 2029,
  [2082] = 1848,
  [2083] = 1839,
  [2084] = 1848,
  [2085] = 1841,
  [2086] = 1881,
  [2087] = 1885,
  [2088] = 1841,
  [2089] = 1864,
  [2090] = 1845,
  [2091] = 2091,
  [2092] = 2091,
  [2093] = 2091,
  [2094] = 2091,
  [2095] = 2091,
  [2096] = 2096,
  [2097] = 2097,
  [2098] = 2097,
  [2099] = 2099,
  [2100] = 2100,
  [2101] = 2101,
  [2102] = 2097,
  [2103] = 2096,
  [2104] = 2097,
  [2105] = 2096,
  [2106] = 2106,
  [2107] = 2107,
  [2108] = 2107,
  [2109] = 2100,
  [2110] = 2100,
  [2111] = 2097,
  [2112] = 2097,
  [2113] = 2113,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2096,
  [2118] = 2118,
  [2119] = 2096,
  [2120] = 2116,
  [2121] = 2118,
  [2122] = 2106,
  [2123] = 2118,
  [2124] = 2099,
  [2125] = 2101,
  [2126] = 2113,
  [2127] = 2100,
  [2128] = 2114,
  [2129] = 2107,
  [2130] = 2115,
  [2131] = 2118,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 530,
  [2135] = 585,
  [2136] = 2133,
  [2137] = 2114,
  [2138] = 2101,
  [2139] = 2115,
  [2140] = 2118,
  [2141] = 2116,
  [2142] = 2106,
  [2143] = 2099,
  [2144] = 2113,
  [2145] = 2099,
  [2146] = 2106,
  [2147] = 2115,
  [2148] = 2114,
  [2149] = 2113,
  [2150] = 2116,
  [2151] = 2101,
  [2152] = 2152,
  [2153] = 2152,
  [2154] = 2152,
  [2155] = 2152,
  [2156] = 2152,
  [2157] = 2157,
  [2158] = 2157,
  [2159] = 2157,
  [2160] = 2157,
  [2161] = 2157,
  [2162] = 2157,
  [2163] = 2157,
  [2164] = 2157,
  [2165] = 2157,
  [2166] = 2113,
  [2167] = 2116,
  [2168] = 2114,
  [2169] = 2115,
  [2170] = 2106,
  [2171] = 2101,
  [2172] = 2099,
  [2173] = 2115,
  [2174] = 2114,
  [2175] = 2113,
  [2176] = 2101,
  [2177] = 2177,
  [2178] = 2177,
  [2179] = 2179,
  [2180] = 2116,
  [2181] = 2106,
  [2182] = 2099,
  [2183] = 2100,
  [2184] = 2184,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2187,
  [2188] = 2188,
  [2189] = 2099,
  [2190] = 2116,
  [2191] = 2115,
  [2192] = 2192,
  [2193] = 2118,
  [2194] = 2118,
  [2195] = 2114,
  [2196] = 2196,
  [2197] = 2118,
  [2198] = 2198,
  [2199] = 2101,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 2100,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 2207,
  [2208] = 2208,
  [2209] = 2106,
  [2210] = 2113,
  [2211] = 2211,
  [2212] = 2212,
  [2213] = 2213,
  [2214] = 2118,
  [2215] = 2107,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 2218,
  [2219] = 2219,
  [2220] = 2220,
  [2221] = 2220,
  [2222] = 2220,
  [2223] = 2100,
  [2224] = 2224,
  [2225] = 2225,
  [2226] = 2116,
  [2227] = 2115,
  [2228] = 2101,
  [2229] = 2114,
  [2230] = 2118,
  [2231] = 2107,
  [2232] = 2232,
  [2233] = 2220,
  [2234] = 2113,
  [2235] = 2099,
  [2236] = 2106,
  [2237] = 2237,
  [2238] = 2238,
  [2239] = 2239,
  [2240] = 2240,
  [2241] = 2241,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 2245,
  [2246] = 374,
  [2247] = 2186,
  [2248] = 346,
  [2249] = 2118,
  [2250] = 2184,
  [2251] = 356,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 371,
  [2257] = 2118,
  [2258] = 2187,
  [2259] = 2259,
  [2260] = 2260,
  [2261] = 2186,
  [2262] = 2262,
  [2263] = 2263,
  [2264] = 2264,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2268,
  [2269] = 2269,
  [2270] = 2270,
  [2271] = 2263,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2274,
  [2275] = 2263,
  [2276] = 2276,
  [2277] = 2277,
  [2278] = 499,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2267,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2267,
  [2285] = 2285,
  [2286] = 2267,
  [2287] = 2184,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2290,
  [2291] = 2291,
  [2292] = 2267,
  [2293] = 2293,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 2296,
  [2297] = 2276,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2263,
  [2305] = 2267,
  [2306] = 2306,
  [2307] = 2267,
  [2308] = 2187,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2263,
  [2315] = 2315,
  [2316] = 2316,
  [2317] = 2267,
  [2318] = 2318,
  [2319] = 2319,
  [2320] = 2320,
  [2321] = 2321,
  [2322] = 2322,
  [2323] = 2322,
  [2324] = 2324,
  [2325] = 2267,
  [2326] = 2326,
  [2327] = 2327,
  [2328] = 2328,
  [2329] = 376,
  [2330] = 2118,
  [2331] = 374,
  [2332] = 371,
  [2333] = 356,
  [2334] = 328,
  [2335] = 321,
  [2336] = 346,
  [2337] = 575,
  [2338] = 585,
  [2339] = 541,
  [2340] = 540,
  [2341] = 2341,
  [2342] = 538,
  [2343] = 590,
  [2344] = 588,
  [2345] = 2321,
  [2346] = 537,
  [2347] = 535,
  [2348] = 404,
  [2349] = 531,
  [2350] = 600,
  [2351] = 539,
  [2352] = 591,
  [2353] = 403,
  [2354] = 596,
  [2355] = 2355,
  [2356] = 398,
  [2357] = 2326,
  [2358] = 2358,
  [2359] = 2359,
  [2360] = 2360,
  [2361] = 2361,
  [2362] = 542,
  [2363] = 581,
  [2364] = 532,
  [2365] = 2365,
  [2366] = 2366,
  [2367] = 586,
  [2368] = 2368,
  [2369] = 2186,
  [2370] = 2370,
  [2371] = 534,
  [2372] = 456,
  [2373] = 2237,
  [2374] = 2321,
  [2375] = 2375,
  [2376] = 462,
  [2377] = 472,
  [2378] = 569,
  [2379] = 558,
  [2380] = 553,
  [2381] = 536,
  [2382] = 572,
  [2383] = 2253,
  [2384] = 594,
  [2385] = 597,
  [2386] = 2326,
  [2387] = 2387,
  [2388] = 2254,
  [2389] = 2389,
  [2390] = 461,
  [2391] = 452,
  [2392] = 2392,
  [2393] = 547,
  [2394] = 2394,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 530,
  [2398] = 2398,
  [2399] = 2399,
  [2400] = 2400,
  [2401] = 2401,
  [2402] = 579,
  [2403] = 386,
  [2404] = 2187,
  [2405] = 2290,
  [2406] = 533,
  [2407] = 2290,
  [2408] = 584,
  [2409] = 550,
  [2410] = 2410,
  [2411] = 2277,
  [2412] = 573,
  [2413] = 402,
  [2414] = 559,
  [2415] = 390,
  [2416] = 580,
  [2417] = 577,
  [2418] = 578,
  [2419] = 2419,
  [2420] = 2420,
  [2421] = 391,
  [2422] = 587,
  [2423] = 583,
  [2424] = 2277,
  [2425] = 2425,
  [2426] = 2426,
  [2427] = 2427,
  [2428] = 2428,
  [2429] = 2429,
  [2430] = 2184,
  [2431] = 499,
  [2432] = 2432,
  [2433] = 2245,
  [2434] = 2434,
  [2435] = 2113,
  [2436] = 2436,
  [2437] = 2237,
  [2438] = 356,
  [2439] = 2179,
  [2440] = 2224,
  [2441] = 2441,
  [2442] = 2232,
  [2443] = 2253,
  [2444] = 2218,
  [2445] = 346,
  [2446] = 2254,
  [2447] = 2447,
  [2448] = 2219,
  [2449] = 2101,
  [2450] = 2290,
  [2451] = 2447,
  [2452] = 2447,
  [2453] = 2245,
  [2454] = 2447,
  [2455] = 2455,
  [2456] = 2447,
  [2457] = 2447,
  [2458] = 374,
  [2459] = 2099,
  [2460] = 2106,
  [2461] = 2447,
  [2462] = 346,
  [2463] = 2447,
  [2464] = 2455,
  [2465] = 2322,
  [2466] = 321,
  [2467] = 328,
  [2468] = 2116,
  [2469] = 2115,
  [2470] = 374,
  [2471] = 2114,
  [2472] = 2455,
  [2473] = 2455,
  [2474] = 376,
  [2475] = 2326,
  [2476] = 2447,
  [2477] = 2455,
  [2478] = 2276,
  [2479] = 2455,
  [2480] = 2321,
  [2481] = 371,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 2455,
  [2485] = 356,
  [2486] = 371,
  [2487] = 2277,
  [2488] = 542,
  [2489] = 2489,
  [2490] = 2276,
  [2491] = 577,
  [2492] = 578,
  [2493] = 579,
  [2494] = 580,
  [2495] = 581,
  [2496] = 584,
  [2497] = 452,
  [2498] = 398,
  [2499] = 2238,
  [2500] = 499,
  [2501] = 390,
  [2502] = 2322,
  [2503] = 586,
  [2504] = 573,
  [2505] = 472,
  [2506] = 462,
  [2507] = 456,
  [2508] = 585,
  [2509] = 404,
  [2510] = 403,
  [2511] = 402,
  [2512] = 530,
  [2513] = 386,
  [2514] = 2425,
  [2515] = 461,
  [2516] = 2516,
  [2517] = 2276,
  [2518] = 572,
  [2519] = 553,
  [2520] = 532,
  [2521] = 539,
  [2522] = 531,
  [2523] = 535,
  [2524] = 537,
  [2525] = 538,
  [2526] = 540,
  [2527] = 541,
  [2528] = 559,
  [2529] = 590,
  [2530] = 588,
  [2531] = 2322,
  [2532] = 600,
  [2533] = 2389,
  [2534] = 2387,
  [2535] = 2375,
  [2536] = 596,
  [2537] = 569,
  [2538] = 2489,
  [2539] = 558,
  [2540] = 536,
  [2541] = 534,
  [2542] = 2355,
  [2543] = 2358,
  [2544] = 2359,
  [2545] = 2365,
  [2546] = 2366,
  [2547] = 2368,
  [2548] = 2370,
  [2549] = 2419,
  [2550] = 550,
  [2551] = 533,
  [2552] = 2426,
  [2553] = 2427,
  [2554] = 391,
  [2555] = 2428,
  [2556] = 2429,
  [2557] = 2432,
  [2558] = 2361,
  [2559] = 2434,
  [2560] = 2360,
  [2561] = 2341,
  [2562] = 594,
  [2563] = 597,
  [2564] = 2410,
  [2565] = 2489,
  [2566] = 587,
  [2567] = 583,
  [2568] = 2568,
  [2569] = 2401,
  [2570] = 2400,
  [2571] = 2568,
  [2572] = 2399,
  [2573] = 2398,
  [2574] = 2396,
  [2575] = 2395,
  [2576] = 2394,
  [2577] = 2392,
  [2578] = 2489,
  [2579] = 575,
  [2580] = 547,
  [2581] = 499,
  [2582] = 591,
  [2583] = 2583,
  [2584] = 2219,
  [2585] = 321,
  [2586] = 2179,
  [2587] = 2587,
  [2588] = 376,
  [2589] = 2589,
  [2590] = 2590,
  [2591] = 2583,
  [2592] = 2326,
  [2593] = 2277,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 2277,
  [2597] = 2597,
  [2598] = 2224,
  [2599] = 2599,
  [2600] = 2600,
  [2601] = 2425,
  [2602] = 2425,
  [2603] = 2410,
  [2604] = 2232,
  [2605] = 2218,
  [2606] = 2606,
  [2607] = 2607,
  [2608] = 2587,
  [2609] = 2321,
  [2610] = 2590,
  [2611] = 2597,
  [2612] = 2612,
  [2613] = 2237,
  [2614] = 2254,
  [2615] = 2615,
  [2616] = 376,
  [2617] = 2589,
  [2618] = 2568,
  [2619] = 2619,
  [2620] = 2321,
  [2621] = 2621,
  [2622] = 2179,
  [2623] = 2615,
  [2624] = 2410,
  [2625] = 2625,
  [2626] = 2626,
  [2627] = 328,
  [2628] = 2621,
  [2629] = 2612,
  [2630] = 2630,
  [2631] = 2245,
  [2632] = 328,
  [2633] = 2633,
  [2634] = 2606,
  [2635] = 2253,
  [2636] = 2636,
  [2637] = 2607,
  [2638] = 321,
  [2639] = 2639,
  [2640] = 2626,
  [2641] = 2600,
  [2642] = 2642,
  [2643] = 2290,
  [2644] = 2326,
  [2645] = 2619,
  [2646] = 2646,
  [2647] = 2642,
  [2648] = 2599,
  [2649] = 2516,
  [2650] = 2633,
  [2651] = 2594,
  [2652] = 2290,
  [2653] = 2639,
  [2654] = 553,
  [2655] = 2219,
  [2656] = 391,
  [2657] = 594,
  [2658] = 600,
  [2659] = 2255,
  [2660] = 2419,
  [2661] = 537,
  [2662] = 2341,
  [2663] = 597,
  [2664] = 391,
  [2665] = 2276,
  [2666] = 535,
  [2667] = 573,
  [2668] = 559,
  [2669] = 586,
  [2670] = 559,
  [2671] = 550,
  [2672] = 579,
  [2673] = 390,
  [2674] = 533,
  [2675] = 531,
  [2676] = 539,
  [2677] = 2434,
  [2678] = 2358,
  [2679] = 587,
  [2680] = 583,
  [2681] = 402,
  [2682] = 532,
  [2683] = 575,
  [2684] = 594,
  [2685] = 2355,
  [2686] = 2360,
  [2687] = 2392,
  [2688] = 588,
  [2689] = 2218,
  [2690] = 581,
  [2691] = 581,
  [2692] = 580,
  [2693] = 2243,
  [2694] = 586,
  [2695] = 2360,
  [2696] = 452,
  [2697] = 597,
  [2698] = 2698,
  [2699] = 2232,
  [2700] = 2401,
  [2701] = 573,
  [2702] = 2361,
  [2703] = 572,
  [2704] = 578,
  [2705] = 577,
  [2706] = 2396,
  [2707] = 452,
  [2708] = 572,
  [2709] = 2224,
  [2710] = 580,
  [2711] = 2483,
  [2712] = 472,
  [2713] = 596,
  [2714] = 462,
  [2715] = 403,
  [2716] = 587,
  [2717] = 461,
  [2718] = 461,
  [2719] = 2239,
  [2720] = 2436,
  [2721] = 462,
  [2722] = 2359,
  [2723] = 591,
  [2724] = 2252,
  [2725] = 2366,
  [2726] = 2368,
  [2727] = 2387,
  [2728] = 2389,
  [2729] = 591,
  [2730] = 2370,
  [2731] = 456,
  [2732] = 541,
  [2733] = 2733,
  [2734] = 386,
  [2735] = 530,
  [2736] = 588,
  [2737] = 584,
  [2738] = 2179,
  [2739] = 553,
  [2740] = 2401,
  [2741] = 542,
  [2742] = 538,
  [2743] = 2361,
  [2744] = 590,
  [2745] = 2441,
  [2746] = 532,
  [2747] = 2389,
  [2748] = 2426,
  [2749] = 2427,
  [2750] = 584,
  [2751] = 536,
  [2752] = 534,
  [2753] = 2482,
  [2754] = 2242,
  [2755] = 398,
  [2756] = 2387,
  [2757] = 2370,
  [2758] = 2758,
  [2759] = 590,
  [2760] = 2392,
  [2761] = 2394,
  [2762] = 390,
  [2763] = 2428,
  [2764] = 2419,
  [2765] = 585,
  [2766] = 533,
  [2767] = 2394,
  [2768] = 2768,
  [2769] = 2341,
  [2770] = 2434,
  [2771] = 2322,
  [2772] = 2368,
  [2773] = 547,
  [2774] = 2375,
  [2775] = 569,
  [2776] = 2366,
  [2777] = 2400,
  [2778] = 2365,
  [2779] = 558,
  [2780] = 600,
  [2781] = 596,
  [2782] = 2395,
  [2783] = 2400,
  [2784] = 547,
  [2785] = 2432,
  [2786] = 2429,
  [2787] = 2240,
  [2788] = 2429,
  [2789] = 575,
  [2790] = 541,
  [2791] = 2399,
  [2792] = 540,
  [2793] = 2399,
  [2794] = 2398,
  [2795] = 538,
  [2796] = 537,
  [2797] = 535,
  [2798] = 2241,
  [2799] = 531,
  [2800] = 2375,
  [2801] = 2359,
  [2802] = 577,
  [2803] = 398,
  [2804] = 386,
  [2805] = 530,
  [2806] = 456,
  [2807] = 2365,
  [2808] = 2432,
  [2809] = 583,
  [2810] = 550,
  [2811] = 2179,
  [2812] = 402,
  [2813] = 404,
  [2814] = 2396,
  [2815] = 578,
  [2816] = 2428,
  [2817] = 2427,
  [2818] = 2395,
  [2819] = 569,
  [2820] = 2426,
  [2821] = 403,
  [2822] = 2238,
  [2823] = 2355,
  [2824] = 534,
  [2825] = 404,
  [2826] = 585,
  [2827] = 472,
  [2828] = 2358,
  [2829] = 539,
  [2830] = 579,
  [2831] = 536,
  [2832] = 542,
  [2833] = 540,
  [2834] = 558,
  [2835] = 2398,
  [2836] = 2310,
  [2837] = 2482,
  [2838] = 2838,
  [2839] = 2839,
  [2840] = 2840,
  [2841] = 2266,
  [2842] = 2232,
  [2843] = 2268,
  [2844] = 2844,
  [2845] = 2302,
  [2846] = 2846,
  [2847] = 2625,
  [2848] = 2289,
  [2849] = 2309,
  [2850] = 2315,
  [2851] = 2851,
  [2852] = 2260,
  [2853] = 2853,
  [2854] = 2238,
  [2855] = 2483,
  [2856] = 2279,
  [2857] = 2646,
  [2858] = 2410,
  [2859] = 2436,
  [2860] = 321,
  [2861] = 2291,
  [2862] = 2319,
  [2863] = 328,
  [2864] = 2864,
  [2865] = 2301,
  [2866] = 2219,
  [2867] = 2101,
  [2868] = 2868,
  [2869] = 2869,
  [2870] = 2870,
  [2871] = 2113,
  [2872] = 2099,
  [2873] = 2224,
  [2874] = 2625,
  [2875] = 2293,
  [2876] = 2274,
  [2877] = 2877,
  [2878] = 2851,
  [2879] = 2282,
  [2880] = 2880,
  [2881] = 2881,
  [2882] = 2882,
  [2883] = 2425,
  [2884] = 2288,
  [2885] = 2280,
  [2886] = 2886,
  [2887] = 2299,
  [2888] = 2595,
  [2889] = 2327,
  [2890] = 2328,
  [2891] = 2100,
  [2892] = 2106,
  [2893] = 2116,
  [2894] = 2300,
  [2895] = 2273,
  [2896] = 2115,
  [2897] = 2897,
  [2898] = 2294,
  [2899] = 2295,
  [2900] = 2900,
  [2901] = 2272,
  [2902] = 2114,
  [2903] = 2270,
  [2904] = 2298,
  [2905] = 2320,
  [2906] = 2318,
  [2907] = 2218,
  [2908] = 2303,
  [2909] = 2264,
  [2910] = 2262,
  [2911] = 2911,
  [2912] = 2296,
  [2913] = 2313,
  [2914] = 2316,
  [2915] = 2265,
  [2916] = 2269,
  [2917] = 2306,
  [2918] = 2285,
  [2919] = 2283,
  [2920] = 2324,
  [2921] = 2441,
  [2922] = 2238,
  [2923] = 2923,
  [2924] = 2311,
  [2925] = 2925,
  [2926] = 2224,
  [2927] = 2219,
  [2928] = 2642,
  [2929] = 2179,
  [2930] = 2113,
  [2931] = 2101,
  [2932] = 2114,
  [2933] = 2600,
  [2934] = 2934,
  [2935] = 2583,
  [2936] = 2219,
  [2937] = 2118,
  [2938] = 2232,
  [2939] = 2630,
  [2940] = 2621,
  [2941] = 2115,
  [2942] = 2594,
  [2943] = 2218,
  [2944] = 2116,
  [2945] = 2619,
  [2946] = 2607,
  [2947] = 2224,
  [2948] = 2590,
  [2949] = 2099,
  [2950] = 2595,
  [2951] = 2232,
  [2952] = 2636,
  [2953] = 2953,
  [2954] = 2106,
  [2955] = 2955,
  [2956] = 2956,
  [2957] = 2639,
  [2958] = 2958,
  [2959] = 2218,
  [2960] = 2960,
  [2961] = 2646,
  [2962] = 2962,
  [2963] = 2615,
  [2964] = 2589,
  [2965] = 2599,
  [2966] = 2597,
  [2967] = 2606,
  [2968] = 2118,
  [2969] = 2626,
  [2970] = 2612,
  [2971] = 2633,
  [2972] = 2587,
  [2973] = 2436,
  [2974] = 2633,
  [2975] = 2607,
  [2976] = 2630,
  [2977] = 2583,
  [2978] = 2621,
  [2979] = 2979,
  [2980] = 2980,
  [2981] = 2981,
  [2982] = 2100,
  [2983] = 2983,
  [2984] = 2238,
  [2985] = 2985,
  [2986] = 2986,
  [2987] = 2619,
  [2988] = 2597,
  [2989] = 2733,
  [2990] = 2252,
  [2991] = 2238,
  [2992] = 2100,
  [2993] = 2441,
  [2994] = 2612,
  [2995] = 2633,
  [2996] = 2587,
  [2997] = 1408,
  [2998] = 2698,
  [2999] = 2999,
  [3000] = 3000,
  [3001] = 2607,
  [3002] = 2983,
  [3003] = 2240,
  [3004] = 2241,
  [3005] = 2590,
  [3006] = 2758,
  [3007] = 2600,
  [3008] = 3008,
  [3009] = 2590,
  [3010] = 2600,
  [3011] = 3011,
  [3012] = 2583,
  [3013] = 2621,
  [3014] = 2594,
  [3015] = 2594,
  [3016] = 2619,
  [3017] = 2597,
  [3018] = 3018,
  [3019] = 2983,
  [3020] = 2983,
  [3021] = 3021,
  [3022] = 2612,
  [3023] = 2923,
  [3024] = 2482,
  [3025] = 3018,
  [3026] = 2606,
  [3027] = 2599,
  [3028] = 2242,
  [3029] = 2589,
  [3030] = 2615,
  [3031] = 2587,
  [3032] = 2483,
  [3033] = 1402,
  [3034] = 2636,
  [3035] = 2626,
  [3036] = 2239,
  [3037] = 3037,
  [3038] = 2639,
  [3039] = 2642,
  [3040] = 2626,
  [3041] = 3041,
  [3042] = 2255,
  [3043] = 2606,
  [3044] = 2243,
  [3045] = 2599,
  [3046] = 2589,
  [3047] = 2615,
  [3048] = 2639,
  [3049] = 3049,
  [3050] = 3050,
  [3051] = 2642,
  [3052] = 2768,
  [3053] = 2280,
  [3054] = 3054,
  [3055] = 3055,
  [3056] = 2255,
  [3057] = 2289,
  [3058] = 3058,
  [3059] = 2886,
  [3060] = 2846,
  [3061] = 2313,
  [3062] = 2274,
  [3063] = 3063,
  [3064] = 3064,
  [3065] = 3065,
  [3066] = 3066,
  [3067] = 2999,
  [3068] = 2273,
  [3069] = 3069,
  [3070] = 3070,
  [3071] = 2311,
  [3072] = 2186,
  [3073] = 3073,
  [3074] = 3074,
  [3075] = 2211,
  [3076] = 3076,
  [3077] = 2310,
  [3078] = 2184,
  [3079] = 3079,
  [3080] = 3080,
  [3081] = 2272,
  [3082] = 2270,
  [3083] = 3083,
  [3084] = 3084,
  [3085] = 3085,
  [3086] = 2255,
  [3087] = 2306,
  [3088] = 2303,
  [3089] = 2269,
  [3090] = 3090,
  [3091] = 3091,
  [3092] = 2243,
  [3093] = 3093,
  [3094] = 3094,
  [3095] = 3095,
  [3096] = 2768,
  [3097] = 3097,
  [3098] = 2300,
  [3099] = 2298,
  [3100] = 3100,
  [3101] = 2243,
  [3102] = 3102,
  [3103] = 2239,
  [3104] = 3104,
  [3105] = 2844,
  [3106] = 2625,
  [3107] = 2239,
  [3108] = 2296,
  [3109] = 2203,
  [3110] = 2201,
  [3111] = 2293,
  [3112] = 2262,
  [3113] = 2264,
  [3114] = 3114,
  [3115] = 3115,
  [3116] = 2266,
  [3117] = 2923,
  [3118] = 2268,
  [3119] = 3069,
  [3120] = 3120,
  [3121] = 3121,
  [3122] = 3102,
  [3123] = 3123,
  [3124] = 2425,
  [3125] = 3125,
  [3126] = 2118,
  [3127] = 3127,
  [3128] = 2205,
  [3129] = 2868,
  [3130] = 2198,
  [3131] = 2208,
  [3132] = 2758,
  [3133] = 3133,
  [3134] = 3134,
  [3135] = 3135,
  [3136] = 3069,
  [3137] = 3137,
  [3138] = 3102,
  [3139] = 2319,
  [3140] = 2240,
  [3141] = 2316,
  [3142] = 2294,
  [3143] = 2979,
  [3144] = 3144,
  [3145] = 2324,
  [3146] = 2241,
  [3147] = 2240,
  [3148] = 2870,
  [3149] = 2295,
  [3150] = 3150,
  [3151] = 3151,
  [3152] = 3152,
  [3153] = 2187,
  [3154] = 2242,
  [3155] = 3155,
  [3156] = 3156,
  [3157] = 3069,
  [3158] = 3102,
  [3159] = 2934,
  [3160] = 2207,
  [3161] = 2206,
  [3162] = 3162,
  [3163] = 3163,
  [3164] = 3164,
  [3165] = 3165,
  [3166] = 3166,
  [3167] = 3167,
  [3168] = 3168,
  [3169] = 3169,
  [3170] = 3170,
  [3171] = 3171,
  [3172] = 3172,
  [3173] = 2853,
  [3174] = 2923,
  [3175] = 2646,
  [3176] = 2302,
  [3177] = 2196,
  [3178] = 2216,
  [3179] = 2252,
  [3180] = 3069,
  [3181] = 2309,
  [3182] = 2315,
  [3183] = 2283,
  [3184] = 328,
  [3185] = 3185,
  [3186] = 3186,
  [3187] = 2285,
  [3188] = 3069,
  [3189] = 2698,
  [3190] = 2320,
  [3191] = 2318,
  [3192] = 3102,
  [3193] = 2410,
  [3194] = 2100,
  [3195] = 3195,
  [3196] = 3037,
  [3197] = 3197,
  [3198] = 2213,
  [3199] = 2212,
  [3200] = 2202,
  [3201] = 2953,
  [3202] = 2282,
  [3203] = 2955,
  [3204] = 2956,
  [3205] = 2958,
  [3206] = 2960,
  [3207] = 2962,
  [3208] = 2192,
  [3209] = 2265,
  [3210] = 3210,
  [3211] = 2241,
  [3212] = 3104,
  [3213] = 3213,
  [3214] = 2839,
  [3215] = 2869,
  [3216] = 2200,
  [3217] = 2733,
  [3218] = 3218,
  [3219] = 3219,
  [3220] = 2595,
  [3221] = 3221,
  [3222] = 3222,
  [3223] = 3223,
  [3224] = 3102,
  [3225] = 3225,
  [3226] = 2252,
  [3227] = 3227,
  [3228] = 3228,
  [3229] = 3229,
  [3230] = 3230,
  [3231] = 2328,
  [3232] = 2327,
  [3233] = 2260,
  [3234] = 3069,
  [3235] = 2291,
  [3236] = 3236,
  [3237] = 2279,
  [3238] = 2301,
  [3239] = 2242,
  [3240] = 2851,
  [3241] = 321,
  [3242] = 2288,
  [3243] = 2299,
  [3244] = 3244,
  [3245] = 2303,
  [3246] = 2273,
  [3247] = 2625,
  [3248] = 2626,
  [3249] = 2306,
  [3250] = 2639,
  [3251] = 2642,
  [3252] = 2851,
  [3253] = 2289,
  [3254] = 2600,
  [3255] = 2260,
  [3256] = 2590,
  [3257] = 2300,
  [3258] = 2279,
  [3259] = 2298,
  [3260] = 2282,
  [3261] = 2310,
  [3262] = 2285,
  [3263] = 2283,
  [3264] = 2324,
  [3265] = 2316,
  [3266] = 2294,
  [3267] = 2295,
  [3268] = 2302,
  [3269] = 2268,
  [3270] = 2266,
  [3271] = 2925,
  [3272] = 2309,
  [3273] = 2264,
  [3274] = 2262,
  [3275] = 2293,
  [3276] = 2607,
  [3277] = 2315,
  [3278] = 2296,
  [3279] = 2269,
  [3280] = 2270,
  [3281] = 2272,
  [3282] = 2615,
  [3283] = 2589,
  [3284] = 2599,
  [3285] = 2273,
  [3286] = 2274,
  [3287] = 2280,
  [3288] = 2606,
  [3289] = 2923,
  [3290] = 2320,
  [3291] = 2318,
  [3292] = 2319,
  [3293] = 2313,
  [3294] = 2265,
  [3295] = 3041,
  [3296] = 2311,
  [3297] = 2310,
  [3298] = 2306,
  [3299] = 2587,
  [3300] = 2303,
  [3301] = 2300,
  [3302] = 2298,
  [3303] = 2100,
  [3304] = 2633,
  [3305] = 2612,
  [3306] = 2636,
  [3307] = 2328,
  [3308] = 2327,
  [3309] = 2299,
  [3310] = 2625,
  [3311] = 2846,
  [3312] = 2853,
  [3313] = 2118,
  [3314] = 2597,
  [3315] = 2619,
  [3316] = 2621,
  [3317] = 2583,
  [3318] = 2288,
  [3319] = 2851,
  [3320] = 2301,
  [3321] = 2291,
  [3322] = 2839,
  [3323] = 2594,
  [3324] = 2294,
  [3325] = 2295,
  [3326] = 2886,
  [3327] = 2302,
  [3328] = 2309,
  [3329] = 2315,
  [3330] = 2320,
  [3331] = 2318,
  [3332] = 2265,
  [3333] = 2844,
  [3334] = 2328,
  [3335] = 2327,
  [3336] = 2299,
  [3337] = 2288,
  [3338] = 2311,
  [3339] = 2630,
  [3340] = 2301,
  [3341] = 2291,
  [3342] = 2289,
  [3343] = 2260,
  [3344] = 2870,
  [3345] = 2923,
  [3346] = 2279,
  [3347] = 2282,
  [3348] = 2313,
  [3349] = 2285,
  [3350] = 3041,
  [3351] = 2319,
  [3352] = 2283,
  [3353] = 2324,
  [3354] = 2316,
  [3355] = 2268,
  [3356] = 2266,
  [3357] = 2264,
  [3358] = 2262,
  [3359] = 2293,
  [3360] = 2296,
  [3361] = 2269,
  [3362] = 2270,
  [3363] = 2272,
  [3364] = 2923,
  [3365] = 2280,
  [3366] = 2274,
  [3367] = 3244,
  [3368] = 3165,
  [3369] = 3369,
  [3370] = 2953,
  [3371] = 2239,
  [3372] = 3227,
  [3373] = 2243,
  [3374] = 3049,
  [3375] = 3050,
  [3376] = 2956,
  [3377] = 2241,
  [3378] = 2900,
  [3379] = 2897,
  [3380] = 2881,
  [3381] = 459,
  [3382] = 2958,
  [3383] = 2960,
  [3384] = 2923,
  [3385] = 3385,
  [3386] = 2882,
  [3387] = 2240,
  [3388] = 2962,
  [3389] = 2255,
  [3390] = 3021,
  [3391] = 1402,
  [3392] = 3392,
  [3393] = 3041,
  [3394] = 2252,
  [3395] = 3095,
  [3396] = 3396,
  [3397] = 3397,
  [3398] = 2925,
  [3399] = 3399,
  [3400] = 3197,
  [3401] = 1408,
  [3402] = 2242,
  [3403] = 3063,
  [3404] = 3058,
  [3405] = 3150,
  [3406] = 2224,
  [3407] = 2232,
  [3408] = 3218,
  [3409] = 3000,
  [3410] = 3186,
  [3411] = 3411,
  [3412] = 2218,
  [3413] = 3076,
  [3414] = 3219,
  [3415] = 2864,
  [3416] = 3063,
  [3417] = 2877,
  [3418] = 3369,
  [3419] = 3396,
  [3420] = 2880,
  [3421] = 3244,
  [3422] = 3222,
  [3423] = 3223,
  [3424] = 2179,
  [3425] = 3135,
  [3426] = 2840,
  [3427] = 2838,
  [3428] = 2101,
  [3429] = 2113,
  [3430] = 2099,
  [3431] = 3431,
  [3432] = 2106,
  [3433] = 2219,
  [3434] = 2116,
  [3435] = 2934,
  [3436] = 2115,
  [3437] = 3115,
  [3438] = 3396,
  [3439] = 3172,
  [3440] = 3396,
  [3441] = 3397,
  [3442] = 2114,
  [3443] = 3171,
  [3444] = 2986,
  [3445] = 2955,
  [3446] = 3114,
  [3447] = 3156,
  [3448] = 3170,
  [3449] = 2980,
  [3450] = 2118,
  [3451] = 2238,
  [3452] = 3162,
  [3453] = 3169,
  [3454] = 3168,
  [3455] = 2911,
  [3456] = 3456,
  [3457] = 3164,
  [3458] = 522,
  [3459] = 3114,
  [3460] = 3167,
  [3461] = 3166,
  [3462] = 3163,
  [3463] = 3152,
  [3464] = 2291,
  [3465] = 3465,
  [3466] = 2886,
  [3467] = 1408,
  [3468] = 2844,
  [3469] = 2260,
  [3470] = 3156,
  [3471] = 2206,
  [3472] = 2986,
  [3473] = 3162,
  [3474] = 3163,
  [3475] = 2207,
  [3476] = 2279,
  [3477] = 2282,
  [3478] = 3478,
  [3479] = 3164,
  [3480] = 3165,
  [3481] = 3456,
  [3482] = 3100,
  [3483] = 3166,
  [3484] = 3167,
  [3485] = 3168,
  [3486] = 3169,
  [3487] = 3170,
  [3488] = 2285,
  [3489] = 2283,
  [3490] = 3097,
  [3491] = 2324,
  [3492] = 2316,
  [3493] = 3171,
  [3494] = 3172,
  [3495] = 3228,
  [3496] = 3369,
  [3497] = 2962,
  [3498] = 3229,
  [3499] = 3094,
  [3500] = 2245,
  [3501] = 2981,
  [3502] = 3155,
  [3503] = 3135,
  [3504] = 3186,
  [3505] = 2911,
  [3506] = 2118,
  [3507] = 2268,
  [3508] = 2266,
  [3509] = 3465,
  [3510] = 3144,
  [3511] = 3511,
  [3512] = 3236,
  [3513] = 2264,
  [3514] = 3230,
  [3515] = 3120,
  [3516] = 2953,
  [3517] = 2955,
  [3518] = 2956,
  [3519] = 2958,
  [3520] = 2211,
  [3521] = 2960,
  [3522] = 3225,
  [3523] = 2870,
  [3524] = 2262,
  [3525] = 1402,
  [3526] = 2900,
  [3527] = 3134,
  [3528] = 3133,
  [3529] = 2934,
  [3530] = 2208,
  [3531] = 2293,
  [3532] = 2296,
  [3533] = 3197,
  [3534] = 3058,
  [3535] = 2253,
  [3536] = 3049,
  [3537] = 2269,
  [3538] = 2196,
  [3539] = 3221,
  [3540] = 2198,
  [3541] = 2868,
  [3542] = 2625,
  [3543] = 3218,
  [3544] = 2205,
  [3545] = 3219,
  [3546] = 3127,
  [3547] = 3095,
  [3548] = 2216,
  [3549] = 3222,
  [3550] = 3223,
  [3551] = 3041,
  [3552] = 3021,
  [3553] = 3123,
  [3554] = 3227,
  [3555] = 3185,
  [3556] = 3151,
  [3557] = 2322,
  [3558] = 2289,
  [3559] = 2200,
  [3560] = 2980,
  [3561] = 3478,
  [3562] = 2869,
  [3563] = 2237,
  [3564] = 2201,
  [3565] = 2310,
  [3566] = 2301,
  [3567] = 3195,
  [3568] = 2203,
  [3569] = 2270,
  [3570] = 3080,
  [3571] = 2272,
  [3572] = 3511,
  [3573] = 2838,
  [3574] = 2881,
  [3575] = 2882,
  [3576] = 2840,
  [3577] = 3076,
  [3578] = 2273,
  [3579] = 2274,
  [3580] = 2280,
  [3581] = 2979,
  [3582] = 3115,
  [3583] = 2851,
  [3584] = 2288,
  [3585] = 3093,
  [3586] = 3091,
  [3587] = 2299,
  [3588] = 3090,
  [3589] = 2327,
  [3590] = 2328,
  [3591] = 3213,
  [3592] = 3085,
  [3593] = 3063,
  [3594] = 3210,
  [3595] = 3084,
  [3596] = 2265,
  [3597] = 2318,
  [3598] = 3083,
  [3599] = 3073,
  [3600] = 3074,
  [3601] = 2320,
  [3602] = 2192,
  [3603] = 3511,
  [3604] = 3478,
  [3605] = 3137,
  [3606] = 2864,
  [3607] = 3244,
  [3608] = 2877,
  [3609] = 3054,
  [3610] = 3037,
  [3611] = 3055,
  [3612] = 3121,
  [3613] = 3478,
  [3614] = 2853,
  [3615] = 2319,
  [3616] = 2315,
  [3617] = 2309,
  [3618] = 2302,
  [3619] = 3125,
  [3620] = 3050,
  [3621] = 3478,
  [3622] = 2202,
  [3623] = 2295,
  [3624] = 2294,
  [3625] = 2880,
  [3626] = 3064,
  [3627] = 3114,
  [3628] = 2897,
  [3629] = 3511,
  [3630] = 3065,
  [3631] = 321,
  [3632] = 3150,
  [3633] = 3066,
  [3634] = 2313,
  [3635] = 3511,
  [3636] = 2254,
  [3637] = 3000,
  [3638] = 2311,
  [3639] = 2212,
  [3640] = 2306,
  [3641] = 2303,
  [3642] = 2213,
  [3643] = 2300,
  [3644] = 2298,
  [3645] = 2999,
  [3646] = 3478,
  [3647] = 3079,
  [3648] = 3478,
  [3649] = 3465,
  [3650] = 3478,
  [3651] = 328,
  [3652] = 3070,
  [3653] = 3478,
  [3654] = 3654,
  [3655] = 3144,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 3229,
  [3659] = 3125,
  [3660] = 3121,
  [3661] = 3163,
  [3662] = 2999,
  [3663] = 3162,
  [3664] = 3135,
  [3665] = 2200,
  [3666] = 3221,
  [3667] = 3114,
  [3668] = 3156,
  [3669] = 3058,
  [3670] = 3095,
  [3671] = 3657,
  [3672] = 2868,
  [3673] = 3100,
  [3674] = 3097,
  [3675] = 3076,
  [3676] = 3094,
  [3677] = 3165,
  [3678] = 3213,
  [3679] = 3679,
  [3680] = 3244,
  [3681] = 3456,
  [3682] = 2186,
  [3683] = 3054,
  [3684] = 3055,
  [3685] = 3679,
  [3686] = 1408,
  [3687] = 3456,
  [3688] = 3679,
  [3689] = 3064,
  [3690] = 3065,
  [3691] = 3066,
  [3692] = 3210,
  [3693] = 3073,
  [3694] = 3074,
  [3695] = 2211,
  [3696] = 3079,
  [3697] = 2192,
  [3698] = 3083,
  [3699] = 3084,
  [3700] = 3085,
  [3701] = 3225,
  [3702] = 3151,
  [3703] = 2962,
  [3704] = 3654,
  [3705] = 2960,
  [3706] = 2958,
  [3707] = 3657,
  [3708] = 2208,
  [3709] = 2956,
  [3710] = 2955,
  [3711] = 2953,
  [3712] = 3063,
  [3713] = 3090,
  [3714] = 3091,
  [3715] = 3093,
  [3716] = 2205,
  [3717] = 3166,
  [3718] = 3654,
  [3719] = 2184,
  [3720] = 2203,
  [3721] = 2201,
  [3722] = 3654,
  [3723] = 3657,
  [3724] = 3127,
  [3725] = 2979,
  [3726] = 3656,
  [3727] = 3230,
  [3728] = 3657,
  [3729] = 2118,
  [3730] = 2198,
  [3731] = 3133,
  [3732] = 3134,
  [3733] = 2869,
  [3734] = 3167,
  [3735] = 3137,
  [3736] = 3654,
  [3737] = 3037,
  [3738] = 3679,
  [3739] = 1402,
  [3740] = 3070,
  [3741] = 3168,
  [3742] = 3679,
  [3743] = 3164,
  [3744] = 3228,
  [3745] = 3152,
  [3746] = 3155,
  [3747] = 2934,
  [3748] = 2207,
  [3749] = 2206,
  [3750] = 3656,
  [3751] = 3169,
  [3752] = 3115,
  [3753] = 3080,
  [3754] = 3170,
  [3755] = 2981,
  [3756] = 2196,
  [3757] = 2216,
  [3758] = 3123,
  [3759] = 3185,
  [3760] = 3150,
  [3761] = 3656,
  [3762] = 3227,
  [3763] = 3223,
  [3764] = 328,
  [3765] = 3236,
  [3766] = 3656,
  [3767] = 321,
  [3768] = 3222,
  [3769] = 2187,
  [3770] = 3219,
  [3771] = 2925,
  [3772] = 3218,
  [3773] = 3171,
  [3774] = 3120,
  [3775] = 2202,
  [3776] = 3195,
  [3777] = 2212,
  [3778] = 2213,
  [3779] = 3197,
  [3780] = 3186,
  [3781] = 3172,
  [3782] = 2106,
  [3783] = 2099,
  [3784] = 2113,
  [3785] = 2238,
  [3786] = 2232,
  [3787] = 2115,
  [3788] = 2114,
  [3789] = 3076,
  [3790] = 3095,
  [3791] = 2224,
  [3792] = 2218,
  [3793] = 3058,
  [3794] = 2101,
  [3795] = 3135,
  [3796] = 3156,
  [3797] = 2219,
  [3798] = 2106,
  [3799] = 2986,
  [3800] = 3162,
  [3801] = 2116,
  [3802] = 3163,
  [3803] = 3164,
  [3804] = 3165,
  [3805] = 3166,
  [3806] = 3167,
  [3807] = 3168,
  [3808] = 3169,
  [3809] = 3170,
  [3810] = 3171,
  [3811] = 3172,
  [3812] = 3186,
  [3813] = 3197,
  [3814] = 3218,
  [3815] = 3050,
  [3816] = 3219,
  [3817] = 3817,
  [3818] = 2116,
  [3819] = 2101,
  [3820] = 3222,
  [3821] = 3223,
  [3822] = 3456,
  [3823] = 2113,
  [3824] = 2099,
  [3825] = 3227,
  [3826] = 3397,
  [3827] = 2980,
  [3828] = 3828,
  [3829] = 2114,
  [3830] = 2115,
  [3831] = 3831,
  [3832] = 3213,
  [3833] = 3054,
  [3834] = 2277,
  [3835] = 2636,
  [3836] = 3085,
  [3837] = 2206,
  [3838] = 3838,
  [3839] = 2207,
  [3840] = 2410,
  [3841] = 3094,
  [3842] = 3097,
  [3843] = 3155,
  [3844] = 3100,
  [3845] = 3064,
  [3846] = 3065,
  [3847] = 3066,
  [3848] = 3152,
  [3849] = 3073,
  [3850] = 3144,
  [3851] = 3074,
  [3852] = 3137,
  [3853] = 3121,
  [3854] = 3125,
  [3855] = 2979,
  [3856] = 3134,
  [3857] = 3133,
  [3858] = 2290,
  [3859] = 2208,
  [3860] = 2198,
  [3861] = 2211,
  [3862] = 2868,
  [3863] = 2205,
  [3864] = 2999,
  [3865] = 3055,
  [3866] = 3127,
  [3867] = 2196,
  [3868] = 2216,
  [3869] = 3123,
  [3870] = 3185,
  [3871] = 2326,
  [3872] = 3195,
  [3873] = 321,
  [3874] = 3236,
  [3875] = 2321,
  [3876] = 2213,
  [3877] = 2212,
  [3878] = 3230,
  [3879] = 2202,
  [3880] = 2192,
  [3881] = 3079,
  [3882] = 3210,
  [3883] = 2203,
  [3884] = 3225,
  [3885] = 2425,
  [3886] = 3037,
  [3887] = 3083,
  [3888] = 3084,
  [3889] = 2201,
  [3890] = 3090,
  [3891] = 3221,
  [3892] = 3091,
  [3893] = 3093,
  [3894] = 2200,
  [3895] = 328,
  [3896] = 2869,
  [3897] = 2253,
  [3898] = 2276,
  [3899] = 3899,
  [3900] = 3900,
  [3901] = 2237,
  [3902] = 2245,
  [3903] = 3903,
  [3904] = 2254,
  [3905] = 3905,
  [3906] = 3905,
  [3907] = 2252,
  [3908] = 3905,
  [3909] = 3905,
  [3910] = 2425,
  [3911] = 2322,
  [3912] = 2851,
  [3913] = 2239,
  [3914] = 2240,
  [3915] = 2410,
  [3916] = 2255,
  [3917] = 2242,
  [3918] = 3905,
  [3919] = 2265,
  [3920] = 3920,
  [3921] = 2595,
  [3922] = 3920,
  [3923] = 2285,
  [3924] = 2283,
  [3925] = 2324,
  [3926] = 2316,
  [3927] = 2299,
  [3928] = 2630,
  [3929] = 2274,
  [3930] = 2313,
  [3931] = 2291,
  [3932] = 2636,
  [3933] = 3920,
  [3934] = 2280,
  [3935] = 2295,
  [3936] = 2266,
  [3937] = 2441,
  [3938] = 2268,
  [3939] = 2327,
  [3940] = 2311,
  [3941] = 2328,
  [3942] = 2310,
  [3943] = 2425,
  [3944] = 2294,
  [3945] = 2302,
  [3946] = 2319,
  [3947] = 2436,
  [3948] = 3920,
  [3949] = 2483,
  [3950] = 2243,
  [3951] = 3951,
  [3952] = 1402,
  [3953] = 1408,
  [3954] = 3954,
  [3955] = 2646,
  [3956] = 2241,
  [3957] = 2264,
  [3958] = 2296,
  [3959] = 3959,
  [3960] = 2320,
  [3961] = 2318,
  [3962] = 2289,
  [3963] = 2482,
  [3964] = 3964,
  [3965] = 2262,
  [3966] = 2410,
  [3967] = 3967,
  [3968] = 2293,
  [3969] = 3920,
  [3970] = 3920,
  [3971] = 2625,
  [3972] = 3900,
  [3973] = 2298,
  [3974] = 2301,
  [3975] = 3920,
  [3976] = 2315,
  [3977] = 3920,
  [3978] = 2273,
  [3979] = 3979,
  [3980] = 2272,
  [3981] = 2276,
  [3982] = 2309,
  [3983] = 2300,
  [3984] = 2270,
  [3985] = 2288,
  [3986] = 2238,
  [3987] = 2260,
  [3988] = 2279,
  [3989] = 3920,
  [3990] = 2282,
  [3991] = 2303,
  [3992] = 2306,
  [3993] = 2269,
  [3994] = 3994,
  [3995] = 3995,
  [3996] = 3996,
  [3997] = 3995,
  [3998] = 2482,
  [3999] = 3995,
  [4000] = 4000,
  [4001] = 3995,
  [4002] = 4002,
  [4003] = 4000,
  [4004] = 2192,
  [4005] = 2436,
  [4006] = 2206,
  [4007] = 4007,
  [4008] = 4007,
  [4009] = 4002,
  [4010] = 3996,
  [4011] = 4002,
  [4012] = 3996,
  [4013] = 4013,
  [4014] = 3995,
  [4015] = 4000,
  [4016] = 2441,
  [4017] = 2410,
  [4018] = 4018,
  [4019] = 4002,
  [4020] = 4007,
  [4021] = 3996,
  [4022] = 3995,
  [4023] = 2211,
  [4024] = 2425,
  [4025] = 3994,
  [4026] = 4000,
  [4027] = 2290,
  [4028] = 321,
  [4029] = 3996,
  [4030] = 3994,
  [4031] = 4007,
  [4032] = 4002,
  [4033] = 2202,
  [4034] = 3996,
  [4035] = 3995,
  [4036] = 3994,
  [4037] = 3994,
  [4038] = 2212,
  [4039] = 3828,
  [4040] = 2213,
  [4041] = 2201,
  [4042] = 2326,
  [4043] = 3996,
  [4044] = 2203,
  [4045] = 2277,
  [4046] = 4046,
  [4047] = 2216,
  [4048] = 2321,
  [4049] = 4000,
  [4050] = 2208,
  [4051] = 2200,
  [4052] = 3994,
  [4053] = 3994,
  [4054] = 3995,
  [4055] = 3996,
  [4056] = 3994,
  [4057] = 2205,
  [4058] = 4007,
  [4059] = 4002,
  [4060] = 3994,
  [4061] = 3995,
  [4062] = 2207,
  [4063] = 3996,
  [4064] = 2198,
  [4065] = 3996,
  [4066] = 2179,
  [4067] = 2196,
  [4068] = 4007,
  [4069] = 4000,
  [4070] = 3995,
  [4071] = 3996,
  [4072] = 3995,
  [4073] = 3817,
  [4074] = 328,
  [4075] = 2630,
  [4076] = 2483,
  [4077] = 4077,
  [4078] = 2321,
  [4079] = 4079,
  [4080] = 4080,
  [4081] = 4081,
  [4082] = 2326,
  [4083] = 4079,
  [4084] = 2436,
  [4085] = 4081,
  [4086] = 4086,
  [4087] = 4081,
  [4088] = 4080,
  [4089] = 4077,
  [4090] = 4080,
  [4091] = 4080,
  [4092] = 4081,
  [4093] = 2646,
  [4094] = 4081,
  [4095] = 3964,
  [4096] = 2277,
  [4097] = 4080,
  [4098] = 2254,
  [4099] = 4081,
  [4100] = 2290,
  [4101] = 4079,
  [4102] = 4080,
  [4103] = 4079,
  [4104] = 4077,
  [4105] = 2441,
  [4106] = 4077,
  [4107] = 4079,
  [4108] = 4079,
  [4109] = 4080,
  [4110] = 4086,
  [4111] = 4111,
  [4112] = 4081,
  [4113] = 4077,
  [4114] = 4114,
  [4115] = 4081,
  [4116] = 2625,
  [4117] = 4079,
  [4118] = 4118,
  [4119] = 4119,
  [4120] = 2483,
  [4121] = 4079,
  [4122] = 4079,
  [4123] = 4081,
  [4124] = 4081,
  [4125] = 4079,
  [4126] = 4080,
  [4127] = 4080,
  [4128] = 3951,
  [4129] = 2237,
  [4130] = 2595,
  [4131] = 4077,
  [4132] = 2482,
  [4133] = 4077,
  [4134] = 4111,
  [4135] = 4080,
  [4136] = 4079,
  [4137] = 4119,
  [4138] = 4081,
  [4139] = 4077,
  [4140] = 4080,
  [4141] = 4077,
  [4142] = 4114,
  [4143] = 4143,
  [4144] = 4118,
  [4145] = 4145,
  [4146] = 4119,
  [4147] = 4119,
  [4148] = 2646,
  [4149] = 4145,
  [4150] = 4143,
  [4151] = 2595,
  [4152] = 4086,
  [4153] = 2925,
  [4154] = 4145,
  [4155] = 4145,
  [4156] = 2118,
  [4157] = 4157,
  [4158] = 4143,
  [4159] = 4157,
  [4160] = 4086,
  [4161] = 4157,
  [4162] = 4145,
  [4163] = 4143,
  [4164] = 4157,
  [4165] = 4165,
  [4166] = 4157,
  [4167] = 4143,
  [4168] = 3050,
  [4169] = 2410,
  [4170] = 2589,
  [4171] = 2425,
  [4172] = 2587,
  [4173] = 2844,
  [4174] = 2240,
  [4175] = 3195,
  [4176] = 2980,
  [4177] = 2583,
  [4178] = 2621,
  [4179] = 3899,
  [4180] = 2619,
  [4181] = 2630,
  [4182] = 2612,
  [4183] = 2853,
  [4184] = 3090,
  [4185] = 2594,
  [4186] = 2639,
  [4187] = 2626,
  [4188] = 3073,
  [4189] = 2606,
  [4190] = 2597,
  [4191] = 4165,
  [4192] = 2633,
  [4193] = 2599,
  [4194] = 2870,
  [4195] = 2619,
  [4196] = 2600,
  [4197] = 2516,
  [4198] = 2252,
  [4199] = 2615,
  [4200] = 4200,
  [4201] = 2587,
  [4202] = 2986,
  [4203] = 2606,
  [4204] = 2621,
  [4205] = 4200,
  [4206] = 2583,
  [4207] = 2600,
  [4208] = 2590,
  [4209] = 2599,
  [4210] = 2607,
  [4211] = 2639,
  [4212] = 3903,
  [4213] = 2589,
  [4214] = 2239,
  [4215] = 3144,
  [4216] = 2607,
  [4217] = 3900,
  [4218] = 2594,
  [4219] = 2642,
  [4220] = 2626,
  [4221] = 2615,
  [4222] = 2633,
  [4223] = 2597,
  [4224] = 2642,
  [4225] = 2886,
  [4226] = 2636,
  [4227] = 2612,
  [4228] = 2590,
  [4229] = 2282,
  [4230] = 2285,
  [4231] = 2260,
  [4232] = 2853,
  [4233] = 4086,
  [4234] = 3125,
  [4235] = 4114,
  [4236] = 2886,
  [4237] = 3155,
  [4238] = 3100,
  [4239] = 3123,
  [4240] = 2279,
  [4241] = 3097,
  [4242] = 3079,
  [4243] = 4114,
  [4244] = 3156,
  [4245] = 3074,
  [4246] = 3223,
  [4247] = 4247,
  [4248] = 2298,
  [4249] = 2276,
  [4250] = 2280,
  [4251] = 2274,
  [4252] = 2636,
  [4253] = 4253,
  [4254] = 2844,
  [4255] = 4255,
  [4256] = 2273,
  [4257] = 3185,
  [4258] = 3094,
  [4259] = 2270,
  [4260] = 3121,
  [4261] = 2300,
  [4262] = 2303,
  [4263] = 2306,
  [4264] = 3066,
  [4265] = 2320,
  [4266] = 2269,
  [4267] = 4119,
  [4268] = 2318,
  [4269] = 2288,
  [4270] = 2272,
  [4271] = 3065,
  [4272] = 4119,
  [4273] = 2870,
  [4274] = 4118,
  [4275] = 3093,
  [4276] = 3221,
  [4277] = 2243,
  [4278] = 3064,
  [4279] = 2265,
  [4280] = 3085,
  [4281] = 2100,
  [4282] = 3134,
  [4283] = 4283,
  [4284] = 4086,
  [4285] = 2851,
  [4286] = 4119,
  [4287] = 2283,
  [4288] = 3133,
  [4289] = 3210,
  [4290] = 2289,
  [4291] = 3054,
  [4292] = 2324,
  [4293] = 2868,
  [4294] = 3230,
  [4295] = 3055,
  [4296] = 3171,
  [4297] = 3091,
  [4298] = 4086,
  [4299] = 4119,
  [4300] = 3218,
  [4301] = 3213,
  [4302] = 3137,
  [4303] = 2316,
  [4304] = 4086,
  [4305] = 4086,
  [4306] = 2291,
  [4307] = 3152,
  [4308] = 4119,
  [4309] = 2294,
  [4310] = 4118,
  [4311] = 4311,
  [4312] = 2310,
  [4313] = 2315,
  [4314] = 2309,
  [4315] = 2302,
  [4316] = 2296,
  [4317] = 3225,
  [4318] = 2301,
  [4319] = 4086,
  [4320] = 4119,
  [4321] = 3227,
  [4322] = 3084,
  [4323] = 2319,
  [4324] = 2241,
  [4325] = 3083,
  [4326] = 3236,
  [4327] = 2299,
  [4328] = 2293,
  [4329] = 2311,
  [4330] = 2313,
  [4331] = 2262,
  [4332] = 2869,
  [4333] = 2264,
  [4334] = 2327,
  [4335] = 2328,
  [4336] = 4336,
  [4337] = 4118,
  [4338] = 2266,
  [4339] = 2295,
  [4340] = 4114,
  [4341] = 3127,
  [4342] = 2268,
  [4343] = 2192,
  [4344] = 2615,
  [4345] = 3165,
  [4346] = 3164,
  [4347] = 3163,
  [4348] = 328,
  [4349] = 2196,
  [4350] = 4283,
  [4351] = 1402,
  [4352] = 3166,
  [4353] = 3167,
  [4354] = 3168,
  [4355] = 2886,
  [4356] = 3169,
  [4357] = 2607,
  [4358] = 2118,
  [4359] = 3170,
  [4360] = 2207,
  [4361] = 2206,
  [4362] = 2590,
  [4363] = 2630,
  [4364] = 2211,
  [4365] = 2844,
  [4366] = 4366,
  [4367] = 2208,
  [4368] = 2200,
  [4369] = 2600,
  [4370] = 4118,
  [4371] = 2646,
  [4372] = 3172,
  [4373] = 4119,
  [4374] = 4114,
  [4375] = 3197,
  [4376] = 3076,
  [4377] = 3219,
  [4378] = 3831,
  [4379] = 2198,
  [4380] = 2205,
  [4381] = 4381,
  [4382] = 2595,
  [4383] = 3162,
  [4384] = 2639,
  [4385] = 2642,
  [4386] = 3095,
  [4387] = 2626,
  [4388] = 2216,
  [4389] = 2589,
  [4390] = 2599,
  [4391] = 4119,
  [4392] = 2853,
  [4393] = 2202,
  [4394] = 3186,
  [4395] = 2606,
  [4396] = 2212,
  [4397] = 4255,
  [4398] = 2213,
  [4399] = 3058,
  [4400] = 3959,
  [4401] = 4086,
  [4402] = 4086,
  [4403] = 3222,
  [4404] = 2870,
  [4405] = 1408,
  [4406] = 2587,
  [4407] = 2516,
  [4408] = 2633,
  [4409] = 4409,
  [4410] = 2612,
  [4411] = 321,
  [4412] = 2597,
  [4413] = 2619,
  [4414] = 2621,
  [4415] = 2583,
  [4416] = 2594,
  [4417] = 2203,
  [4418] = 3135,
  [4419] = 2201,
  [4420] = 4366,
  [4421] = 4336,
  [4422] = 4422,
  [4423] = 4422,
  [4424] = 4422,
  [4425] = 4425,
  [4426] = 4366,
  [4427] = 4427,
  [4428] = 4422,
  [4429] = 4429,
  [4430] = 2595,
  [4431] = 4422,
  [4432] = 4432,
  [4433] = 4422,
  [4434] = 4434,
  [4435] = 4422,
  [4436] = 4436,
  [4437] = 4422,
  [4438] = 4438,
  [4439] = 4429,
  [4440] = 4432,
  [4441] = 2100,
  [4442] = 4422,
  [4443] = 2646,
  [4444] = 4422,
  [4445] = 4445,
  [4446] = 4434,
  [4447] = 4422,
  [4448] = 4422,
  [4449] = 4429,
  [4450] = 4450,
  [4451] = 4450,
  [4452] = 4452,
  [4453] = 3817,
  [4454] = 4422,
  [4455] = 4434,
  [4456] = 4429,
  [4457] = 4457,
  [4458] = 4450,
  [4459] = 4459,
  [4460] = 3828,
  [4461] = 4461,
  [4462] = 4461,
  [4463] = 4457,
  [4464] = 4464,
  [4465] = 4450,
  [4466] = 4429,
  [4467] = 2925,
  [4468] = 4468,
  [4469] = 4434,
  [4470] = 4450,
  [4471] = 4450,
  [4472] = 4422,
  [4473] = 4459,
  [4474] = 4422,
  [4475] = 4429,
  [4476] = 4445,
  [4477] = 4434,
  [4478] = 4422,
  [4479] = 2118,
  [4480] = 4434,
  [4481] = 3397,
  [4482] = 4429,
  [4483] = 4483,
  [4484] = 3135,
  [4485] = 4432,
  [4486] = 4486,
  [4487] = 4487,
  [4488] = 4488,
  [4489] = 4489,
  [4490] = 4490,
  [4491] = 4491,
  [4492] = 4114,
  [4493] = 3186,
  [4494] = 4494,
  [4495] = 4495,
  [4496] = 4483,
  [4497] = 4497,
  [4498] = 3058,
  [4499] = 3162,
  [4500] = 3163,
  [4501] = 3164,
  [4502] = 3165,
  [4503] = 4503,
  [4504] = 4504,
  [4505] = 4505,
  [4506] = 3166,
  [4507] = 4507,
  [4508] = 3167,
  [4509] = 3095,
  [4510] = 4510,
  [4511] = 4511,
  [4512] = 4512,
  [4513] = 4486,
  [4514] = 3168,
  [4515] = 3169,
  [4516] = 3170,
  [4517] = 4487,
  [4518] = 3172,
  [4519] = 4119,
  [4520] = 4118,
  [4521] = 4255,
  [4522] = 4522,
  [4523] = 4118,
  [4524] = 3186,
  [4525] = 3197,
  [4526] = 4119,
  [4527] = 2100,
  [4528] = 3171,
  [4529] = 3170,
  [4530] = 4489,
  [4531] = 3169,
  [4532] = 3168,
  [4533] = 3167,
  [4534] = 4336,
  [4535] = 3037,
  [4536] = 3166,
  [4537] = 4503,
  [4538] = 4538,
  [4539] = 3165,
  [4540] = 3164,
  [4541] = 4541,
  [4542] = 4542,
  [4543] = 3163,
  [4544] = 3162,
  [4545] = 4497,
  [4546] = 4483,
  [4547] = 4547,
  [4548] = 4505,
  [4549] = 4283,
  [4550] = 4503,
  [4551] = 3156,
  [4552] = 4552,
  [4553] = 3076,
  [4554] = 4494,
  [4555] = 4491,
  [4556] = 4490,
  [4557] = 4495,
  [4558] = 4488,
  [4559] = 4552,
  [4560] = 4489,
  [4561] = 4504,
  [4562] = 2100,
  [4563] = 4563,
  [4564] = 4507,
  [4565] = 4565,
  [4566] = 3172,
  [4567] = 4542,
  [4568] = 2425,
  [4569] = 4497,
  [4570] = 4541,
  [4571] = 2999,
  [4572] = 4497,
  [4573] = 4483,
  [4574] = 4494,
  [4575] = 4495,
  [4576] = 4503,
  [4577] = 4086,
  [4578] = 3197,
  [4579] = 4504,
  [4580] = 4489,
  [4581] = 4552,
  [4582] = 4490,
  [4583] = 4119,
  [4584] = 4488,
  [4585] = 4490,
  [4586] = 4586,
  [4587] = 4483,
  [4588] = 4541,
  [4589] = 4119,
  [4590] = 4483,
  [4591] = 4497,
  [4592] = 4512,
  [4593] = 4086,
  [4594] = 4086,
  [4595] = 3218,
  [4596] = 2979,
  [4597] = 4491,
  [4598] = 3219,
  [4599] = 4489,
  [4600] = 4488,
  [4601] = 3050,
  [4602] = 4491,
  [4603] = 2410,
  [4604] = 4542,
  [4605] = 4086,
  [4606] = 4606,
  [4607] = 3219,
  [4608] = 3222,
  [4609] = 4609,
  [4610] = 4522,
  [4611] = 3222,
  [4612] = 4612,
  [4613] = 4497,
  [4614] = 4552,
  [4615] = 4490,
  [4616] = 4488,
  [4617] = 4503,
  [4618] = 3223,
  [4619] = 4486,
  [4620] = 4487,
  [4621] = 4541,
  [4622] = 4552,
  [4623] = 4623,
  [4624] = 4541,
  [4625] = 4494,
  [4626] = 4626,
  [4627] = 4495,
  [4628] = 3227,
  [4629] = 3135,
  [4630] = 4507,
  [4631] = 4631,
  [4632] = 4490,
  [4633] = 4522,
  [4634] = 4488,
  [4635] = 4504,
  [4636] = 4504,
  [4637] = 4507,
  [4638] = 4522,
  [4639] = 4495,
  [4640] = 4507,
  [4641] = 4494,
  [4642] = 3076,
  [4643] = 4489,
  [4644] = 2980,
  [4645] = 4487,
  [4646] = 4486,
  [4647] = 4542,
  [4648] = 2630,
  [4649] = 4542,
  [4650] = 4522,
  [4651] = 4541,
  [4652] = 4522,
  [4653] = 4491,
  [4654] = 4552,
  [4655] = 4655,
  [4656] = 4491,
  [4657] = 4522,
  [4658] = 4486,
  [4659] = 4503,
  [4660] = 4487,
  [4661] = 4114,
  [4662] = 4486,
  [4663] = 4663,
  [4664] = 4487,
  [4665] = 4494,
  [4666] = 4432,
  [4667] = 3058,
  [4668] = 4495,
  [4669] = 4504,
  [4670] = 4497,
  [4671] = 4483,
  [4672] = 4507,
  [4673] = 4491,
  [4674] = 4486,
  [4675] = 4487,
  [4676] = 4336,
  [4677] = 3095,
  [4678] = 2986,
  [4679] = 4494,
  [4680] = 4495,
  [4681] = 4504,
  [4682] = 4489,
  [4683] = 4490,
  [4684] = 4488,
  [4685] = 4522,
  [4686] = 4542,
  [4687] = 4507,
  [4688] = 4503,
  [4689] = 4522,
  [4690] = 4541,
  [4691] = 4552,
  [4692] = 4692,
  [4693] = 4693,
  [4694] = 3144,
  [4695] = 4695,
  [4696] = 4696,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4699,
  [4700] = 4698,
  [4701] = 4701,
  [4702] = 4702,
  [4703] = 4703,
  [4704] = 4704,
  [4705] = 4695,
  [4706] = 4706,
  [4707] = 4707,
  [4708] = 4708,
  [4709] = 3090,
  [4710] = 4699,
  [4711] = 4711,
  [4712] = 4699,
  [4713] = 4699,
  [4714] = 3091,
  [4715] = 3093,
  [4716] = 4695,
  [4717] = 4717,
  [4718] = 3037,
  [4719] = 3085,
  [4720] = 4720,
  [4721] = 3084,
  [4722] = 3083,
  [4723] = 4699,
  [4724] = 4697,
  [4725] = 4725,
  [4726] = 3127,
  [4727] = 4707,
  [4728] = 4706,
  [4729] = 4729,
  [4730] = 4730,
  [4731] = 2868,
  [4732] = 4732,
  [4733] = 4733,
  [4734] = 3079,
  [4735] = 4735,
  [4736] = 4736,
  [4737] = 4697,
  [4738] = 4696,
  [4739] = 4739,
  [4740] = 4717,
  [4741] = 4741,
  [4742] = 4742,
  [4743] = 4708,
  [4744] = 4692,
  [4745] = 4745,
  [4746] = 4704,
  [4747] = 4745,
  [4748] = 4703,
  [4749] = 4702,
  [4750] = 4750,
  [4751] = 4695,
  [4752] = 3074,
  [4753] = 3073,
  [4754] = 3133,
  [4755] = 4693,
  [4756] = 4707,
  [4757] = 4711,
  [4758] = 3134,
  [4759] = 4706,
  [4760] = 4696,
  [4761] = 4697,
  [4762] = 4697,
  [4763] = 4696,
  [4764] = 4711,
  [4765] = 4711,
  [4766] = 4766,
  [4767] = 4706,
  [4768] = 4697,
  [4769] = 4711,
  [4770] = 3137,
  [4771] = 4706,
  [4772] = 4707,
  [4773] = 3066,
  [4774] = 4707,
  [4775] = 3065,
  [4776] = 4696,
  [4777] = 3064,
  [4778] = 4706,
  [4779] = 4693,
  [4780] = 4695,
  [4781] = 4695,
  [4782] = 4706,
  [4783] = 4697,
  [4784] = 4711,
  [4785] = 4730,
  [4786] = 4283,
  [4787] = 4729,
  [4788] = 4706,
  [4789] = 4697,
  [4790] = 4711,
  [4791] = 3055,
  [4792] = 4708,
  [4793] = 3054,
  [4794] = 2999,
  [4795] = 4702,
  [4796] = 4703,
  [4797] = 4693,
  [4798] = 4704,
  [4799] = 4704,
  [4800] = 4707,
  [4801] = 4745,
  [4802] = 4703,
  [4803] = 4702,
  [4804] = 3236,
  [4805] = 4805,
  [4806] = 4735,
  [4807] = 3152,
  [4808] = 3219,
  [4809] = 3155,
  [4810] = 3222,
  [4811] = 3076,
  [4812] = 3095,
  [4813] = 2118,
  [4814] = 4547,
  [4815] = 4717,
  [4816] = 4733,
  [4817] = 3094,
  [4818] = 4708,
  [4819] = 4720,
  [4820] = 3097,
  [4821] = 4717,
  [4822] = 4822,
  [4823] = 4255,
  [4824] = 4711,
  [4825] = 4825,
  [4826] = 3100,
  [4827] = 3135,
  [4828] = 4730,
  [4829] = 3162,
  [4830] = 3163,
  [4831] = 3058,
  [4832] = 3165,
  [4833] = 4732,
  [4834] = 2979,
  [4835] = 4717,
  [4836] = 3230,
  [4837] = 4837,
  [4838] = 4730,
  [4839] = 4702,
  [4840] = 4703,
  [4841] = 4538,
  [4842] = 3225,
  [4843] = 4699,
  [4844] = 4704,
  [4845] = 3166,
  [4846] = 4255,
  [4847] = 4707,
  [4848] = 3227,
  [4849] = 4750,
  [4850] = 4805,
  [4851] = 4732,
  [4852] = 4852,
  [4853] = 4853,
  [4854] = 386,
  [4855] = 4717,
  [4856] = 3121,
  [4857] = 4732,
  [4858] = 3125,
  [4859] = 3167,
  [4860] = 3168,
  [4861] = 4730,
  [4862] = 3169,
  [4863] = 530,
  [4864] = 4733,
  [4865] = 4735,
  [4866] = 3123,
  [4867] = 4735,
  [4868] = 3223,
  [4869] = 402,
  [4870] = 4730,
  [4871] = 3170,
  [4872] = 4745,
  [4873] = 3172,
  [4874] = 3186,
  [4875] = 4695,
  [4876] = 4711,
  [4877] = 3197,
  [4878] = 3218,
  [4879] = 3221,
  [4880] = 4696,
  [4881] = 4697,
  [4882] = 4882,
  [4883] = 403,
  [4884] = 4706,
  [4885] = 4707,
  [4886] = 3185,
  [4887] = 4720,
  [4888] = 404,
  [4889] = 4283,
  [4890] = 4698,
  [4891] = 4695,
  [4892] = 2646,
  [4893] = 4708,
  [4894] = 4894,
  [4895] = 4733,
  [4896] = 2595,
  [4897] = 3164,
  [4898] = 4510,
  [4899] = 4511,
  [4900] = 4730,
  [4901] = 4717,
  [4902] = 456,
  [4903] = 4702,
  [4904] = 4703,
  [4905] = 462,
  [4906] = 4704,
  [4907] = 472,
  [4908] = 2869,
  [4909] = 3171,
  [4910] = 4708,
  [4911] = 4707,
  [4912] = 3195,
  [4913] = 3156,
  [4914] = 3213,
  [4915] = 3210,
  [4916] = 4916,
  [4917] = 2132,
  [4918] = 585,
  [4919] = 398,
  [4920] = 4432,
  [4921] = 4253,
  [4922] = 2118,
  [4923] = 4923,
  [4924] = 4924,
  [4925] = 4432,
  [4926] = 4432,
  [4927] = 4283,
  [4928] = 4311,
  [4929] = 2276,
  [4930] = 4255,
  [4931] = 3900,
  [4932] = 4432,
  [4933] = 4432,
  [4934] = 3899,
  [4935] = 3903,
  [4936] = 4432,
  [4937] = 2516,
  [4938] = 2851,
  [4939] = 4432,
  [4940] = 4940,
  [4941] = 4941,
  [4942] = 4942,
  [4943] = 4943,
  [4944] = 4432,
  [4945] = 4547,
  [4946] = 4510,
  [4947] = 4511,
  [4948] = 4283,
  [4949] = 2420,
  [4950] = 4255,
  [4951] = 4538,
  [4952] = 4547,
  [4953] = 4511,
  [4954] = 4510,
  [4955] = 2630,
  [4956] = 4511,
  [4957] = 4283,
  [4958] = 4538,
  [4959] = 4255,
  [4960] = 4538,
  [4961] = 4547,
  [4962] = 2410,
  [4963] = 2425,
  [4964] = 2425,
  [4965] = 4510,
  [4966] = 2410,
  [4967] = 2410,
  [4968] = 2425,
  [4969] = 4969,
  [4970] = 4970,
  [4971] = 4971,
  [4972] = 4432,
  [4973] = 4432,
  [4974] = 4974,
  [4975] = 3831,
  [4976] = 4976,
  [4977] = 4970,
  [4978] = 4255,
  [4979] = 3951,
  [4980] = 4980,
  [4981] = 4255,
  [4982] = 4974,
  [4983] = 2646,
  [4984] = 4976,
  [4985] = 4970,
  [4986] = 4976,
  [4987] = 4971,
  [4988] = 4971,
  [4989] = 4974,
  [4990] = 4971,
  [4991] = 4970,
  [4992] = 4432,
  [4993] = 4970,
  [4994] = 4971,
  [4995] = 4970,
  [4996] = 4974,
  [4997] = 4974,
  [4998] = 4971,
  [4999] = 4976,
  [5000] = 2595,
  [5001] = 4971,
  [5002] = 3000,
  [5003] = 4976,
  [5004] = 4538,
  [5005] = 4510,
  [5006] = 3049,
  [5007] = 4976,
  [5008] = 4283,
  [5009] = 4976,
  [5010] = 4970,
  [5011] = 4974,
  [5012] = 4971,
  [5013] = 4970,
  [5014] = 4970,
  [5015] = 2276,
  [5016] = 4971,
  [5017] = 3959,
  [5018] = 4283,
  [5019] = 4971,
  [5020] = 4432,
  [5021] = 4970,
  [5022] = 2322,
  [5023] = 4971,
  [5024] = 4974,
  [5025] = 4511,
  [5026] = 4547,
  [5027] = 2420,
  [5028] = 4970,
  [5029] = 3964,
  [5030] = 3021,
  [5031] = 2321,
  [5032] = 2116,
  [5033] = 2179,
  [5034] = 2224,
  [5035] = 2232,
  [5036] = 2277,
  [5037] = 2218,
  [5038] = 4547,
  [5039] = 4538,
  [5040] = 2277,
  [5041] = 2219,
  [5042] = 2420,
  [5043] = 5043,
  [5044] = 2326,
  [5045] = 4511,
  [5046] = 4510,
  [5047] = 2326,
  [5048] = 2290,
  [5049] = 4969,
  [5050] = 2101,
  [5051] = 2113,
  [5052] = 2099,
  [5053] = 2106,
  [5054] = 2290,
  [5055] = 2321,
  [5056] = 2115,
  [5057] = 2114,
  [5058] = 5058,
  [5059] = 5059,
  [5060] = 5060,
  [5061] = 5058,
  [5062] = 5058,
  [5063] = 5060,
  [5064] = 5064,
  [5065] = 2238,
  [5066] = 5066,
  [5067] = 5067,
  [5068] = 5060,
  [5069] = 5060,
  [5070] = 5060,
  [5071] = 5071,
  [5072] = 5072,
  [5073] = 5073,
  [5074] = 5071,
  [5075] = 5075,
  [5076] = 5060,
  [5077] = 5067,
  [5078] = 5064,
  [5079] = 5071,
  [5080] = 5072,
  [5081] = 5067,
  [5082] = 5067,
  [5083] = 4283,
  [5084] = 5064,
  [5085] = 5059,
  [5086] = 5086,
  [5087] = 5064,
  [5088] = 5058,
  [5089] = 5060,
  [5090] = 5060,
  [5091] = 5064,
  [5092] = 5064,
  [5093] = 5071,
  [5094] = 5072,
  [5095] = 4547,
  [5096] = 5072,
  [5097] = 5071,
  [5098] = 4538,
  [5099] = 2646,
  [5100] = 5072,
  [5101] = 4511,
  [5102] = 5060,
  [5103] = 2595,
  [5104] = 5060,
  [5105] = 5073,
  [5106] = 5060,
  [5107] = 5060,
  [5108] = 5060,
  [5109] = 4511,
  [5110] = 5072,
  [5111] = 5058,
  [5112] = 5071,
  [5113] = 5060,
  [5114] = 5058,
  [5115] = 5115,
  [5116] = 4510,
  [5117] = 5115,
  [5118] = 2410,
  [5119] = 5119,
  [5120] = 5058,
  [5121] = 5072,
  [5122] = 5067,
  [5123] = 4547,
  [5124] = 5060,
  [5125] = 5060,
  [5126] = 5072,
  [5127] = 5067,
  [5128] = 5072,
  [5129] = 5060,
  [5130] = 5071,
  [5131] = 4255,
  [5132] = 2425,
  [5133] = 5064,
  [5134] = 5134,
  [5135] = 5135,
  [5136] = 5136,
  [5137] = 5137,
  [5138] = 5138,
  [5139] = 5139,
  [5140] = 5140,
  [5141] = 5136,
  [5142] = 5137,
  [5143] = 5143,
  [5144] = 5134,
  [5145] = 5137,
  [5146] = 4547,
  [5147] = 5143,
  [5148] = 5148,
  [5149] = 5136,
  [5150] = 5138,
  [5151] = 5135,
  [5152] = 4538,
  [5153] = 5134,
  [5154] = 4510,
  [5155] = 5139,
  [5156] = 5134,
  [5157] = 5143,
  [5158] = 5135,
  [5159] = 5148,
  [5160] = 5143,
  [5161] = 5135,
  [5162] = 5143,
  [5163] = 5135,
  [5164] = 5134,
  [5165] = 5137,
  [5166] = 5136,
  [5167] = 5140,
  [5168] = 5139,
  [5169] = 5134,
  [5170] = 5140,
  [5171] = 4511,
  [5172] = 5134,
  [5173] = 5143,
  [5174] = 5135,
  [5175] = 4510,
  [5176] = 4511,
  [5177] = 5139,
  [5178] = 5143,
  [5179] = 5138,
  [5180] = 5140,
  [5181] = 5137,
  [5182] = 5143,
  [5183] = 5148,
  [5184] = 5138,
  [5185] = 2420,
  [5186] = 5140,
  [5187] = 2630,
  [5188] = 5137,
  [5189] = 5137,
  [5190] = 5136,
  [5191] = 5138,
  [5192] = 5137,
  [5193] = 5193,
  [5194] = 5137,
  [5195] = 4547,
  [5196] = 5143,
  [5197] = 5197,
  [5198] = 5136,
  [5199] = 5140,
  [5200] = 5135,
  [5201] = 4538,
  [5202] = 5136,
  [5203] = 5138,
  [5204] = 5204,
  [5205] = 5140,
  [5206] = 5138,
  [5207] = 5137,
  [5208] = 5137,
  [5209] = 5135,
  [5210] = 5148,
  [5211] = 5139,
  [5212] = 5143,
  [5213] = 5148,
  [5214] = 5143,
  [5215] = 5135,
  [5216] = 5216,
  [5217] = 5217,
  [5218] = 5218,
  [5219] = 5219,
  [5220] = 5220,
  [5221] = 5217,
  [5222] = 5218,
  [5223] = 5223,
  [5224] = 5220,
  [5225] = 5220,
  [5226] = 5218,
  [5227] = 5223,
  [5228] = 5218,
  [5229] = 5216,
  [5230] = 2420,
  [5231] = 5216,
  [5232] = 5218,
  [5233] = 5219,
  [5234] = 5220,
  [5235] = 5217,
  [5236] = 5217,
  [5237] = 2595,
  [5238] = 5223,
  [5239] = 5218,
  [5240] = 5223,
  [5241] = 5219,
  [5242] = 5220,
  [5243] = 5216,
  [5244] = 5223,
  [5245] = 5223,
  [5246] = 5218,
  [5247] = 2646,
  [5248] = 2646,
  [5249] = 5220,
  [5250] = 5218,
  [5251] = 5223,
  [5252] = 5043,
  [5253] = 5220,
  [5254] = 2630,
  [5255] = 5216,
  [5256] = 2595,
  [5257] = 5218,
  [5258] = 5223,
  [5259] = 5220,
  [5260] = 5219,
  [5261] = 5223,
  [5262] = 5219,
  [5263] = 5217,
  [5264] = 5220,
  [5265] = 5217,
  [5266] = 5266,
  [5267] = 5267,
  [5268] = 5220,
  [5269] = 5218,
  [5270] = 5223,
  [5271] = 5218,
  [5272] = 5220,
  [5273] = 5216,
  [5274] = 5220,
  [5275] = 5223,
  [5276] = 5223,
  [5277] = 5223,
  [5278] = 5218,
  [5279] = 5220,
  [5280] = 5219,
  [5281] = 5216,
  [5282] = 5217,
  [5283] = 5218,
  [5284] = 5219,
  [5285] = 5218,
  [5286] = 5223,
  [5287] = 5220,
  [5288] = 5216,
  [5289] = 5219,
  [5290] = 5217,
  [5291] = 5218,
  [5292] = 5223,
  [5293] = 5220,
  [5294] = 5217,
  [5295] = 5218,
  [5296] = 5223,
  [5297] = 5220,
  [5298] = 5223,
  [5299] = 5219,
  [5300] = 5220,
  [5301] = 5218,
  [5302] = 5216,
  [5303] = 2646,
  [5304] = 2595,
  [5305] = 5305,
  [5306] = 5305,
  [5307] = 5305,
  [5308] = 4511,
  [5309] = 2590,
  [5310] = 2630,
  [5311] = 5305,
  [5312] = 2642,
  [5313] = 4510,
  [5314] = 2619,
  [5315] = 5305,
  [5316] = 2597,
  [5317] = 2615,
  [5318] = 2589,
  [5319] = 5319,
  [5320] = 5305,
  [5321] = 2612,
  [5322] = 5305,
  [5323] = 5305,
  [5324] = 2583,
  [5325] = 2633,
  [5326] = 5305,
  [5327] = 2607,
  [5328] = 5305,
  [5329] = 5305,
  [5330] = 5305,
  [5331] = 5305,
  [5332] = 2600,
  [5333] = 2639,
  [5334] = 5305,
  [5335] = 2621,
  [5336] = 2626,
  [5337] = 2587,
  [5338] = 2594,
  [5339] = 2599,
  [5340] = 5305,
  [5341] = 2606,
  [5342] = 5342,
  [5343] = 5305,
  [5344] = 4538,
  [5345] = 5305,
  [5346] = 5346,
  [5347] = 4547,
  [5348] = 2241,
  [5349] = 2239,
  [5350] = 2839,
  [5351] = 5342,
  [5352] = 2255,
  [5353] = 2252,
  [5354] = 2243,
  [5355] = 2646,
  [5356] = 2646,
  [5357] = 5346,
  [5358] = 5319,
  [5359] = 2240,
  [5360] = 2595,
  [5361] = 2595,
  [5362] = 2242,
  [5363] = 2306,
  [5364] = 2296,
  [5365] = 2311,
  [5366] = 2310,
  [5367] = 2282,
  [5368] = 2299,
  [5369] = 2280,
  [5370] = 2268,
  [5371] = 2279,
  [5372] = 2295,
  [5373] = 2274,
  [5374] = 2260,
  [5375] = 2273,
  [5376] = 2262,
  [5377] = 2289,
  [5378] = 5378,
  [5379] = 2300,
  [5380] = 5378,
  [5381] = 2319,
  [5382] = 2328,
  [5383] = 2630,
  [5384] = 5378,
  [5385] = 2851,
  [5386] = 2302,
  [5387] = 2316,
  [5388] = 2293,
  [5389] = 2285,
  [5390] = 2264,
  [5391] = 2288,
  [5392] = 2265,
  [5393] = 2318,
  [5394] = 2309,
  [5395] = 2266,
  [5396] = 2327,
  [5397] = 5267,
  [5398] = 2324,
  [5399] = 2272,
  [5400] = 2294,
  [5401] = 2298,
  [5402] = 5266,
  [5403] = 2315,
  [5404] = 5378,
  [5405] = 5378,
  [5406] = 2320,
  [5407] = 2301,
  [5408] = 2313,
  [5409] = 2270,
  [5410] = 2291,
  [5411] = 2269,
  [5412] = 5378,
  [5413] = 2283,
  [5414] = 2303,
  [5415] = 2625,
  [5416] = 4253,
  [5417] = 2606,
  [5418] = 2607,
  [5419] = 5346,
  [5420] = 5342,
  [5421] = 5319,
  [5422] = 5319,
  [5423] = 2590,
  [5424] = 5319,
  [5425] = 5346,
  [5426] = 2600,
  [5427] = 2626,
  [5428] = 2639,
  [5429] = 5342,
  [5430] = 4165,
  [5431] = 2642,
  [5432] = 5432,
  [5433] = 2615,
  [5434] = 2589,
  [5435] = 5346,
  [5436] = 2594,
  [5437] = 2599,
  [5438] = 2583,
  [5439] = 2621,
  [5440] = 2587,
  [5441] = 2633,
  [5442] = 2619,
  [5443] = 2276,
  [5444] = 5342,
  [5445] = 2597,
  [5446] = 2612,
  [5447] = 5319,
  [5448] = 5448,
  [5449] = 5449,
  [5450] = 5448,
  [5451] = 5451,
  [5452] = 5452,
  [5453] = 5346,
  [5454] = 4311,
  [5455] = 5455,
  [5456] = 5456,
  [5457] = 5342,
  [5458] = 5448,
  [5459] = 5459,
  [5460] = 5432,
  [5461] = 5461,
  [5462] = 5462,
  [5463] = 5448,
  [5464] = 2420,
  [5465] = 5465,
  [5466] = 5465,
  [5467] = 5467,
  [5468] = 5465,
  [5469] = 5467,
  [5470] = 5470,
  [5471] = 5452,
  [5472] = 5470,
  [5473] = 5470,
  [5474] = 5470,
  [5475] = 5465,
  [5476] = 5467,
  [5477] = 5465,
  [5478] = 5467,
  [5479] = 5465,
  [5480] = 5467,
  [5481] = 5467,
  [5482] = 5467,
  [5483] = 5465,
  [5484] = 5467,
  [5485] = 5467,
  [5486] = 5486,
  [5487] = 5465,
  [5488] = 5459,
  [5489] = 5456,
  [5490] = 5470,
  [5491] = 5455,
  [5492] = 5467,
  [5493] = 5467,
  [5494] = 5465,
  [5495] = 5467,
  [5496] = 5465,
  [5497] = 5486,
  [5498] = 5467,
  [5499] = 4165,
  [5500] = 5467,
  [5501] = 5465,
  [5502] = 5470,
  [5503] = 5465,
  [5504] = 5462,
  [5505] = 5470,
  [5506] = 5451,
  [5507] = 5465,
  [5508] = 5467,
  [5509] = 5449,
  [5510] = 5470,
  [5511] = 5465,
  [5512] = 5486,
  [5513] = 5461,
  [5514] = 5514,
  [5515] = 5465,
  [5516] = 5470,
  [5517] = 5517,
  [5518] = 5517,
  [5519] = 5342,
  [5520] = 5520,
  [5521] = 5514,
  [5522] = 5522,
  [5523] = 5522,
  [5524] = 5522,
  [5525] = 5319,
  [5526] = 5517,
  [5527] = 5432,
  [5528] = 5342,
  [5529] = 5346,
  [5530] = 5319,
  [5531] = 5346,
  [5532] = 5532,
  [5533] = 5533,
  [5534] = 5533,
  [5535] = 5535,
  [5536] = 5536,
  [5537] = 5537,
  [5538] = 5538,
  [5539] = 5539,
  [5540] = 5449,
  [5541] = 5462,
  [5542] = 5461,
  [5543] = 5543,
  [5544] = 5543,
  [5545] = 5543,
  [5546] = 5546,
  [5547] = 5538,
  [5548] = 5535,
  [5549] = 5432,
  [5550] = 5533,
  [5551] = 5551,
  [5552] = 5532,
  [5553] = 5533,
  [5554] = 5543,
  [5555] = 5555,
  [5556] = 5538,
  [5557] = 5543,
  [5558] = 2986,
  [5559] = 5559,
  [5560] = 5538,
  [5561] = 5533,
  [5562] = 5538,
  [5563] = 5537,
  [5564] = 5551,
  [5565] = 5455,
  [5566] = 5532,
  [5567] = 5538,
  [5568] = 5538,
  [5569] = 5535,
  [5570] = 5451,
  [5571] = 5543,
  [5572] = 5551,
  [5573] = 5573,
  [5574] = 5455,
  [5575] = 5532,
  [5576] = 5532,
  [5577] = 5537,
  [5578] = 5532,
  [5579] = 5532,
  [5580] = 5543,
  [5581] = 5533,
  [5582] = 5551,
  [5583] = 5551,
  [5584] = 5537,
  [5585] = 5543,
  [5586] = 5543,
  [5587] = 5551,
  [5588] = 5533,
  [5589] = 5537,
  [5590] = 5462,
  [5591] = 5559,
  [5592] = 5592,
  [5593] = 5532,
  [5594] = 5532,
  [5595] = 5533,
  [5596] = 5533,
  [5597] = 5537,
  [5598] = 5461,
  [5599] = 5551,
  [5600] = 5551,
  [5601] = 5537,
  [5602] = 5543,
  [5603] = 5603,
  [5604] = 5532,
  [5605] = 5532,
  [5606] = 5533,
  [5607] = 2516,
  [5608] = 5551,
  [5609] = 5543,
  [5610] = 5461,
  [5611] = 5462,
  [5612] = 5551,
  [5613] = 5456,
  [5614] = 5614,
  [5615] = 5543,
  [5616] = 5616,
  [5617] = 5538,
  [5618] = 5538,
  [5619] = 5532,
  [5620] = 5537,
  [5621] = 5621,
  [5622] = 5622,
  [5623] = 5603,
  [5624] = 5622,
  [5625] = 5543,
  [5626] = 5551,
  [5627] = 5449,
  [5628] = 5628,
  [5629] = 5533,
  [5630] = 5459,
  [5631] = 5452,
  [5632] = 5538,
  [5633] = 5537,
  [5634] = 5634,
  [5635] = 5533,
  [5636] = 5636,
  [5637] = 5537,
  [5638] = 5537,
  [5639] = 5451,
  [5640] = 5432,
  [5641] = 5641,
  [5642] = 5456,
  [5643] = 5537,
  [5644] = 5644,
  [5645] = 5645,
  [5646] = 5551,
  [5647] = 5537,
  [5648] = 5533,
  [5649] = 5649,
  [5650] = 5533,
  [5651] = 5546,
  [5652] = 5459,
  [5653] = 5603,
  [5654] = 5537,
  [5655] = 5551,
  [5656] = 5551,
  [5657] = 5657,
  [5658] = 5551,
  [5659] = 5533,
  [5660] = 5660,
  [5661] = 5661,
  [5662] = 5532,
  [5663] = 5537,
  [5664] = 5664,
  [5665] = 5665,
  [5666] = 5543,
  [5667] = 5535,
  [5668] = 5456,
  [5669] = 5452,
  [5670] = 5537,
  [5671] = 5671,
  [5672] = 5551,
  [5673] = 5533,
  [5674] = 5674,
  [5675] = 5537,
  [5676] = 5546,
  [5677] = 5538,
  [5678] = 5678,
  [5679] = 5538,
  [5680] = 5538,
  [5681] = 5681,
  [5682] = 5603,
  [5683] = 5683,
  [5684] = 5684,
  [5685] = 5683,
  [5686] = 5665,
  [5687] = 5687,
  [5688] = 5636,
  [5689] = 5634,
  [5690] = 5690,
  [5691] = 5681,
  [5692] = 5678,
  [5693] = 5551,
  [5694] = 5543,
  [5695] = 5695,
  [5696] = 5696,
  [5697] = 5697,
  [5698] = 5671,
  [5699] = 5532,
  [5700] = 5700,
  [5701] = 5701,
  [5702] = 5543,
  [5703] = 5532,
  [5704] = 5660,
  [5705] = 5459,
  [5706] = 5532,
  [5707] = 5707,
  [5708] = 5451,
  [5709] = 5645,
  [5710] = 5452,
  [5711] = 5711,
  [5712] = 5533,
  [5713] = 5455,
  [5714] = 5449,
  [5715] = 5715,
  [5716] = 5543,
  [5717] = 5717,
  [5718] = 5718,
  [5719] = 5628,
  [5720] = 5546,
  [5721] = 5535,
  [5722] = 5532,
  [5723] = 5536,
  [5724] = 5455,
  [5725] = 5725,
  [5726] = 5701,
  [5727] = 5697,
  [5728] = 5728,
  [5729] = 5696,
  [5730] = 5687,
  [5731] = 5725,
  [5732] = 5690,
  [5733] = 5733,
  [5734] = 5684,
  [5735] = 5735,
  [5736] = 5736,
  [5737] = 5664,
  [5738] = 5695,
  [5739] = 5739,
  [5740] = 5711,
  [5741] = 5456,
  [5742] = 5616,
  [5743] = 5449,
  [5744] = 5451,
  [5745] = 5641,
  [5746] = 5432,
  [5747] = 5452,
  [5748] = 5661,
  [5749] = 5459,
  [5750] = 5700,
  [5751] = 5707,
  [5752] = 5715,
  [5753] = 5621,
  [5754] = 2986,
  [5755] = 5555,
  [5756] = 5462,
  [5757] = 5461,
  [5758] = 5725,
  [5759] = 5759,
  [5760] = 5760,
  [5761] = 5717,
  [5762] = 5725,
  [5763] = 5649,
  [5764] = 5739,
  [5765] = 5760,
  [5766] = 5592,
  [5767] = 5725,
  [5768] = 5725,
  [5769] = 5760,
  [5770] = 5770,
  [5771] = 5539,
  [5772] = 5760,
  [5773] = 5760,
  [5774] = 5573,
  [5775] = 5739,
  [5776] = 5776,
  [5777] = 5718,
  [5778] = 5728,
  [5779] = 5779,
  [5780] = 5739,
  [5781] = 5432,
  [5782] = 5539,
  [5783] = 5573,
  [5784] = 5555,
  [5785] = 5573,
  [5786] = 2868,
  [5787] = 5787,
  [5788] = 5787,
  [5789] = 5449,
  [5790] = 5616,
  [5791] = 5451,
  [5792] = 2869,
  [5793] = 5793,
  [5794] = 5794,
  [5795] = 5793,
  [5796] = 5695,
  [5797] = 5432,
  [5798] = 5616,
  [5799] = 5539,
  [5800] = 5800,
  [5801] = 5690,
  [5802] = 5787,
  [5803] = 5787,
  [5804] = 5695,
  [5805] = 5805,
  [5806] = 5793,
  [5807] = 5800,
  [5808] = 5690,
  [5809] = 5452,
  [5810] = 5616,
  [5811] = 5811,
  [5812] = 5812,
  [5813] = 2410,
  [5814] = 5695,
  [5815] = 5800,
  [5816] = 5459,
  [5817] = 5462,
  [5818] = 5787,
  [5819] = 5800,
  [5820] = 5573,
  [5821] = 5452,
  [5822] = 5800,
  [5823] = 5461,
  [5824] = 5787,
  [5825] = 5825,
  [5826] = 5793,
  [5827] = 5793,
  [5828] = 5787,
  [5829] = 5787,
  [5830] = 5555,
  [5831] = 5432,
  [5832] = 5787,
  [5833] = 5455,
  [5834] = 5793,
  [5835] = 5835,
  [5836] = 5793,
  [5837] = 5837,
  [5838] = 5787,
  [5839] = 5800,
  [5840] = 5555,
  [5841] = 5455,
  [5842] = 5793,
  [5843] = 5456,
  [5844] = 5844,
  [5845] = 5794,
  [5846] = 5539,
  [5847] = 5793,
  [5848] = 5461,
  [5849] = 5800,
  [5850] = 5462,
  [5851] = 5851,
  [5852] = 5459,
  [5853] = 5800,
  [5854] = 2425,
  [5855] = 5800,
  [5856] = 5456,
  [5857] = 5800,
  [5858] = 5449,
  [5859] = 5451,
  [5860] = 5690,
  [5861] = 2213,
  [5862] = 5862,
  [5863] = 2211,
  [5864] = 5864,
  [5865] = 5865,
  [5866] = 2196,
  [5867] = 5867,
  [5868] = 2208,
  [5869] = 2868,
  [5870] = 321,
  [5871] = 2216,
  [5872] = 5872,
  [5873] = 5867,
  [5874] = 2205,
  [5875] = 5875,
  [5876] = 5862,
  [5877] = 2202,
  [5878] = 5878,
  [5879] = 5879,
  [5880] = 5880,
  [5881] = 5881,
  [5882] = 328,
  [5883] = 5695,
  [5884] = 5884,
  [5885] = 5885,
  [5886] = 5539,
  [5887] = 5887,
  [5888] = 5555,
  [5889] = 5889,
  [5890] = 5573,
  [5891] = 2206,
  [5892] = 5616,
  [5893] = 2207,
  [5894] = 5875,
  [5895] = 5895,
  [5896] = 2212,
  [5897] = 5690,
  [5898] = 5898,
  [5899] = 5872,
  [5900] = 2203,
  [5901] = 5889,
  [5902] = 5865,
  [5903] = 5862,
  [5904] = 5862,
  [5905] = 5905,
  [5906] = 5864,
  [5907] = 5864,
  [5908] = 5865,
  [5909] = 2869,
  [5910] = 2201,
  [5911] = 5911,
  [5912] = 5432,
  [5913] = 5864,
  [5914] = 2200,
  [5915] = 5865,
  [5916] = 5884,
  [5917] = 5917,
  [5918] = 5917,
  [5919] = 5911,
  [5920] = 5920,
  [5921] = 5864,
  [5922] = 5864,
  [5923] = 5881,
  [5924] = 2198,
  [5925] = 5865,
  [5926] = 5865,
  [5927] = 2192,
  [5928] = 5905,
  [5929] = 5432,
  [5930] = 5930,
  [5931] = 5885,
  [5932] = 2839,
  [5933] = 5880,
  [5934] = 5898,
  [5935] = 5930,
  [5936] = 5936,
  [5937] = 5930,
  [5938] = 5930,
  [5939] = 5930,
  [5940] = 5930,
  [5941] = 5930,
  [5942] = 5930,
  [5943] = 5943,
  [5944] = 5944,
  [5945] = 5930,
  [5946] = 5943,
  [5947] = 5930,
  [5948] = 5936,
  [5949] = 5949,
  [5950] = 5879,
  [5951] = 5930,
  [5952] = 5936,
  [5953] = 5930,
  [5954] = 5943,
  [5955] = 5943,
  [5956] = 5930,
  [5957] = 5936,
  [5958] = 5930,
  [5959] = 5930,
  [5960] = 5930,
  [5961] = 5943,
  [5962] = 5895,
  [5963] = 5943,
  [5964] = 5943,
  [5965] = 5936,
  [5966] = 5936,
  [5967] = 5936,
  [5968] = 5936,
  [5969] = 5969,
  [5970] = 5936,
  [5971] = 5971,
  [5972] = 5972,
  [5973] = 5887,
  [5974] = 5974,
  [5975] = 5975,
  [5976] = 5878,
  [5977] = 5977,
  [5978] = 5936,
  [5979] = 5930,
  [5980] = 5975,
  [5981] = 5981,
  [5982] = 5982,
  [5983] = 5983,
  [5984] = 5984,
  [5985] = 5985,
  [5986] = 5984,
  [5987] = 5432,
  [5988] = 5984,
  [5989] = 5989,
  [5990] = 5984,
  [5991] = 5991,
  [5992] = 5992,
  [5993] = 5993,
  [5994] = 5984,
  [5995] = 5995,
  [5996] = 2868,
  [5997] = 5981,
  [5998] = 5998,
  [5999] = 5999,
  [6000] = 6000,
  [6001] = 5998,
  [6002] = 6002,
  [6003] = 5984,
  [6004] = 6004,
  [6005] = 5984,
  [6006] = 5984,
  [6007] = 5993,
  [6008] = 5999,
  [6009] = 5995,
  [6010] = 5993,
  [6011] = 6011,
  [6012] = 6012,
  [6013] = 6013,
  [6014] = 5984,
  [6015] = 5969,
  [6016] = 6012,
  [6017] = 5981,
  [6018] = 5993,
  [6019] = 5974,
  [6020] = 5993,
  [6021] = 6000,
  [6022] = 6022,
  [6023] = 5984,
  [6024] = 6024,
  [6025] = 6025,
  [6026] = 5555,
  [6027] = 6027,
  [6028] = 6027,
  [6029] = 5989,
  [6030] = 6030,
  [6031] = 5984,
  [6032] = 6032,
  [6033] = 5539,
  [6034] = 6034,
  [6035] = 6004,
  [6036] = 6032,
  [6037] = 5993,
  [6038] = 6038,
  [6039] = 5984,
  [6040] = 6034,
  [6041] = 5981,
  [6042] = 5984,
  [6043] = 5981,
  [6044] = 5984,
  [6045] = 5977,
  [6046] = 6025,
  [6047] = 5983,
  [6048] = 2868,
  [6049] = 5993,
  [6050] = 5695,
  [6051] = 6051,
  [6052] = 5992,
  [6053] = 5539,
  [6054] = 2869,
  [6055] = 5573,
  [6056] = 6013,
  [6057] = 5984,
  [6058] = 6058,
  [6059] = 5944,
  [6060] = 5984,
  [6061] = 5555,
  [6062] = 5971,
  [6063] = 6063,
  [6064] = 5573,
  [6065] = 6063,
  [6066] = 5690,
  [6067] = 6030,
  [6068] = 5616,
  [6069] = 2869,
  [6070] = 6011,
  [6071] = 5993,
  [6072] = 6072,
  [6073] = 6073,
  [6074] = 6002,
  [6075] = 5984,
  [6076] = 5972,
  [6077] = 6077,
  [6078] = 6051,
  [6079] = 5690,
  [6080] = 5993,
  [6081] = 5695,
  [6082] = 6072,
  [6083] = 5616,
  [6084] = 6073,
  [6085] = 6077,
  [6086] = 5981,
  [6087] = 6087,
  [6088] = 2868,
  [6089] = 6089,
  [6090] = 6090,
  [6091] = 6091,
  [6092] = 6092,
  [6093] = 2201,
  [6094] = 5880,
  [6095] = 6089,
  [6096] = 2203,
  [6097] = 6097,
  [6098] = 6098,
  [6099] = 6099,
  [6100] = 6097,
  [6101] = 2207,
  [6102] = 2196,
  [6103] = 2198,
  [6104] = 6099,
  [6105] = 5879,
  [6106] = 6097,
  [6107] = 6091,
  [6108] = 321,
  [6109] = 6097,
  [6110] = 6089,
  [6111] = 5895,
  [6112] = 2216,
  [6113] = 5887,
  [6114] = 2212,
  [6115] = 5898,
  [6116] = 6099,
  [6117] = 2205,
  [6118] = 6099,
  [6119] = 6099,
  [6120] = 5879,
  [6121] = 5885,
  [6122] = 2768,
  [6123] = 6099,
  [6124] = 5898,
  [6125] = 6125,
  [6126] = 6126,
  [6127] = 6127,
  [6128] = 2698,
  [6129] = 6089,
  [6130] = 5878,
  [6131] = 5880,
  [6132] = 2208,
  [6133] = 6091,
  [6134] = 2211,
  [6135] = 328,
  [6136] = 2213,
  [6137] = 6091,
  [6138] = 6099,
  [6139] = 5885,
  [6140] = 2192,
  [6141] = 6125,
  [6142] = 6097,
  [6143] = 6099,
  [6144] = 2733,
  [6145] = 6125,
  [6146] = 6099,
  [6147] = 6147,
  [6148] = 6097,
  [6149] = 6149,
  [6150] = 5878,
  [6151] = 2200,
  [6152] = 6097,
  [6153] = 6153,
  [6154] = 6125,
  [6155] = 5887,
  [6156] = 6125,
  [6157] = 6097,
  [6158] = 2206,
  [6159] = 6125,
  [6160] = 6089,
  [6161] = 6089,
  [6162] = 6089,
  [6163] = 6089,
  [6164] = 6089,
  [6165] = 2758,
  [6166] = 6097,
  [6167] = 6091,
  [6168] = 2869,
  [6169] = 2202,
  [6170] = 5895,
  [6171] = 6091,
  [6172] = 2118,
  [6173] = 6173,
  [6174] = 3041,
  [6175] = 5898,
  [6176] = 2868,
  [6177] = 6177,
  [6178] = 6173,
  [6179] = 6177,
  [6180] = 5895,
  [6181] = 6177,
  [6182] = 6087,
  [6183] = 6183,
  [6184] = 6177,
  [6185] = 5985,
  [6186] = 6186,
  [6187] = 6177,
  [6188] = 6177,
  [6189] = 6177,
  [6190] = 6177,
  [6191] = 6186,
  [6192] = 6177,
  [6193] = 6186,
  [6194] = 5879,
  [6195] = 6173,
  [6196] = 2869,
  [6197] = 5944,
  [6198] = 5880,
  [6199] = 6058,
  [6200] = 6186,
  [6201] = 6177,
  [6202] = 5977,
  [6203] = 6177,
  [6204] = 6177,
  [6205] = 6177,
  [6206] = 6177,
  [6207] = 5975,
  [6208] = 6177,
  [6209] = 5887,
  [6210] = 5974,
  [6211] = 6022,
  [6212] = 2846,
  [6213] = 6213,
  [6214] = 5972,
  [6215] = 2839,
  [6216] = 5971,
  [6217] = 6217,
  [6218] = 5969,
  [6219] = 6177,
  [6220] = 6220,
  [6221] = 6186,
  [6222] = 6222,
  [6223] = 6173,
  [6224] = 5885,
  [6225] = 6024,
  [6226] = 6226,
  [6227] = 6177,
  [6228] = 6173,
  [6229] = 5878,
  [6230] = 5975,
  [6231] = 2962,
  [6232] = 6232,
  [6233] = 2882,
  [6234] = 6234,
  [6235] = 2880,
  [6236] = 6058,
  [6237] = 6232,
  [6238] = 6238,
  [6239] = 3063,
  [6240] = 6240,
  [6241] = 2911,
  [6242] = 2698,
  [6243] = 3244,
  [6244] = 6244,
  [6245] = 5985,
  [6246] = 5895,
  [6247] = 2868,
  [6248] = 6248,
  [6249] = 5944,
  [6250] = 2897,
  [6251] = 2900,
  [6252] = 2881,
  [6253] = 2864,
  [6254] = 2758,
  [6255] = 2733,
  [6256] = 6022,
  [6257] = 5972,
  [6258] = 5887,
  [6259] = 6259,
  [6260] = 2840,
  [6261] = 3114,
  [6262] = 6232,
  [6263] = 5971,
  [6264] = 6024,
  [6265] = 6265,
  [6266] = 2838,
  [6267] = 5974,
  [6268] = 6268,
  [6269] = 2698,
  [6270] = 6240,
  [6271] = 5977,
  [6272] = 6232,
  [6273] = 2877,
  [6274] = 5972,
  [6275] = 2733,
  [6276] = 6240,
  [6277] = 2758,
  [6278] = 6278,
  [6279] = 5878,
  [6280] = 2768,
  [6281] = 5969,
  [6282] = 6240,
  [6283] = 6232,
  [6284] = 6284,
  [6285] = 6285,
  [6286] = 5879,
  [6287] = 2953,
  [6288] = 6232,
  [6289] = 5885,
  [6290] = 2869,
  [6291] = 5898,
  [6292] = 6292,
  [6293] = 6293,
  [6294] = 5974,
  [6295] = 6240,
  [6296] = 2960,
  [6297] = 2958,
  [6298] = 2956,
  [6299] = 5969,
  [6300] = 2955,
  [6301] = 6232,
  [6302] = 6240,
  [6303] = 6232,
  [6304] = 5971,
  [6305] = 6240,
  [6306] = 5880,
  [6307] = 6240,
  [6308] = 6087,
  [6309] = 6309,
  [6310] = 2768,
  [6311] = 6232,
  [6312] = 5944,
  [6313] = 6240,
  [6314] = 5977,
  [6315] = 6315,
  [6316] = 2934,
  [6317] = 5975,
  [6318] = 6318,
  [6319] = 6319,
  [6320] = 6320,
  [6321] = 5969,
  [6322] = 6322,
  [6323] = 6323,
  [6324] = 5977,
  [6325] = 6320,
  [6326] = 5972,
  [6327] = 6327,
  [6328] = 5971,
  [6329] = 5975,
  [6330] = 6330,
  [6331] = 6322,
  [6332] = 5878,
  [6333] = 6320,
  [6334] = 5879,
  [6335] = 6320,
  [6336] = 6336,
  [6337] = 6320,
  [6338] = 6338,
  [6339] = 5895,
  [6340] = 3229,
  [6341] = 2846,
  [6342] = 6342,
  [6343] = 6320,
  [6344] = 6320,
  [6345] = 5944,
  [6346] = 6222,
  [6347] = 5880,
  [6348] = 5885,
  [6349] = 2846,
  [6350] = 6320,
  [6351] = 6351,
  [6352] = 6352,
  [6353] = 6353,
  [6354] = 6320,
  [6355] = 5898,
  [6356] = 6356,
  [6357] = 6357,
  [6358] = 6358,
  [6359] = 5974,
  [6360] = 6360,
  [6361] = 5887,
  [6362] = 6362,
  [6363] = 2115,
  [6364] = 5944,
  [6365] = 5977,
  [6366] = 6366,
  [6367] = 5975,
  [6368] = 5969,
  [6369] = 6369,
  [6370] = 5974,
  [6371] = 5991,
  [6372] = 6372,
  [6373] = 6373,
  [6374] = 6374,
  [6375] = 5972,
  [6376] = 6376,
  [6377] = 2868,
  [6378] = 6373,
  [6379] = 6369,
  [6380] = 6372,
  [6381] = 6374,
  [6382] = 6362,
  [6383] = 6374,
  [6384] = 2099,
  [6385] = 6366,
  [6386] = 6372,
  [6387] = 6369,
  [6388] = 6369,
  [6389] = 6374,
  [6390] = 6362,
  [6391] = 6373,
  [6392] = 6366,
  [6393] = 2114,
  [6394] = 6373,
  [6395] = 6372,
  [6396] = 5971,
  [6397] = 2116,
  [6398] = 6369,
  [6399] = 2106,
  [6400] = 6372,
  [6401] = 6362,
  [6402] = 6366,
  [6403] = 2869,
  [6404] = 6372,
  [6405] = 6373,
  [6406] = 6373,
  [6407] = 6362,
  [6408] = 6408,
  [6409] = 2113,
  [6410] = 6373,
  [6411] = 6372,
  [6412] = 6376,
  [6413] = 6376,
  [6414] = 6374,
  [6415] = 6374,
  [6416] = 6374,
  [6417] = 6374,
  [6418] = 2101,
  [6419] = 6366,
  [6420] = 6366,
  [6421] = 6374,
  [6422] = 6374,
  [6423] = 6374,
  [6424] = 6369,
  [6425] = 6366,
  [6426] = 6369,
  [6427] = 6372,
  [6428] = 6369,
  [6429] = 6373,
  [6430] = 6374,
  [6431] = 6372,
  [6432] = 6373,
  [6433] = 6369,
  [6434] = 6362,
  [6435] = 6374,
  [6436] = 6374,
  [6437] = 6362,
  [6438] = 6374,
  [6439] = 6374,
  [6440] = 6373,
  [6441] = 6372,
  [6442] = 6374,
  [6443] = 6369,
  [6444] = 6366,
  [6445] = 6374,
  [6446] = 6376,
  [6447] = 6366,
  [6448] = 6372,
  [6449] = 6376,
  [6450] = 6373,
  [6451] = 6369,
  [6452] = 5982,
  [6453] = 6374,
  [6454] = 6362,
  [6455] = 6366,
  [6456] = 6374,
  [6457] = 6366,
  [6458] = 6362,
  [6459] = 6459,
  [6460] = 6460,
  [6461] = 5974,
  [6462] = 6462,
  [6463] = 5975,
  [6464] = 6462,
  [6465] = 6465,
  [6466] = 5977,
  [6467] = 6465,
  [6468] = 6126,
  [6469] = 6469,
  [6470] = 6058,
  [6471] = 6092,
  [6472] = 6087,
  [6473] = 6473,
  [6474] = 6460,
  [6475] = 6475,
  [6476] = 6476,
  [6477] = 5944,
  [6478] = 6462,
  [6479] = 6469,
  [6480] = 6462,
  [6481] = 5972,
  [6482] = 6462,
  [6483] = 6483,
  [6484] = 6476,
  [6485] = 6485,
  [6486] = 6486,
  [6487] = 6022,
  [6488] = 6469,
  [6489] = 6460,
  [6490] = 5969,
  [6491] = 6153,
  [6492] = 6476,
  [6493] = 5971,
  [6494] = 5985,
  [6495] = 6462,
  [6496] = 6496,
  [6497] = 6462,
  [6498] = 6476,
  [6499] = 6469,
  [6500] = 6500,
  [6501] = 6024,
  [6502] = 6127,
  [6503] = 5982,
  [6504] = 6149,
  [6505] = 5991,
  [6506] = 6469,
  [6507] = 5972,
  [6508] = 5971,
  [6509] = 6469,
  [6510] = 6465,
  [6511] = 6462,
  [6512] = 6460,
  [6513] = 6465,
  [6514] = 6462,
  [6515] = 5977,
  [6516] = 6476,
  [6517] = 6469,
  [6518] = 6518,
  [6519] = 6465,
  [6520] = 6520,
  [6521] = 6521,
  [6522] = 2768,
  [6523] = 6523,
  [6524] = 6524,
  [6525] = 6525,
  [6526] = 6526,
  [6527] = 6521,
  [6528] = 5971,
  [6529] = 6521,
  [6530] = 6530,
  [6531] = 6531,
  [6532] = 5969,
  [6533] = 6533,
  [6534] = 5972,
  [6535] = 5969,
  [6536] = 6533,
  [6537] = 5975,
  [6538] = 5975,
  [6539] = 5977,
  [6540] = 5944,
  [6541] = 6541,
  [6542] = 5974,
  [6543] = 5974,
  [6544] = 6530,
  [6545] = 3011,
  [6546] = 2733,
  [6547] = 5944,
  [6548] = 6548,
  [6549] = 6530,
  [6550] = 6533,
  [6551] = 6521,
  [6552] = 2698,
  [6553] = 2985,
  [6554] = 5971,
  [6555] = 5972,
  [6556] = 6530,
  [6557] = 5977,
  [6558] = 6533,
  [6559] = 6521,
  [6560] = 6530,
  [6561] = 2758,
  [6562] = 3008,
  [6563] = 6563,
  [6564] = 6564,
  [6565] = 6565,
  [6566] = 6566,
  [6567] = 6564,
  [6568] = 6566,
  [6569] = 6569,
  [6570] = 6565,
  [6571] = 6565,
  [6572] = 6564,
  [6573] = 6564,
  [6574] = 6565,
  [6575] = 6315,
  [6576] = 6563,
  [6577] = 6565,
  [6578] = 6569,
  [6579] = 6564,
  [6580] = 6580,
  [6581] = 6563,
  [6582] = 6582,
  [6583] = 6563,
  [6584] = 6565,
  [6585] = 2846,
  [6586] = 6582,
  [6587] = 6582,
  [6588] = 6566,
  [6589] = 6566,
  [6590] = 6582,
  [6591] = 6565,
  [6592] = 6292,
  [6593] = 6593,
  [6594] = 6563,
  [6595] = 6595,
  [6596] = 6582,
  [6597] = 6597,
  [6598] = 6598,
  [6599] = 6564,
  [6600] = 6600,
  [6601] = 6564,
  [6602] = 6565,
  [6603] = 6563,
  [6604] = 6564,
  [6605] = 6564,
  [6606] = 6582,
  [6607] = 6607,
  [6608] = 6565,
  [6609] = 5974,
  [6610] = 6610,
  [6611] = 6611,
  [6612] = 6611,
  [6613] = 6613,
  [6614] = 5944,
  [6615] = 6615,
  [6616] = 6616,
  [6617] = 5977,
  [6618] = 6615,
  [6619] = 6619,
  [6620] = 6620,
  [6621] = 6615,
  [6622] = 6622,
  [6623] = 6623,
  [6624] = 5972,
  [6625] = 5971,
  [6626] = 6613,
  [6627] = 6627,
  [6628] = 6628,
  [6629] = 6629,
  [6630] = 5975,
  [6631] = 5969,
  [6632] = 6611,
  [6633] = 6615,
  [6634] = 6615,
  [6635] = 6635,
  [6636] = 6636,
  [6637] = 6635,
  [6638] = 6638,
  [6639] = 6639,
  [6640] = 6640,
  [6641] = 6641,
  [6642] = 6642,
  [6643] = 6640,
  [6644] = 6644,
  [6645] = 6645,
  [6646] = 6646,
  [6647] = 6645,
  [6648] = 6648,
  [6649] = 6649,
  [6650] = 6650,
  [6651] = 6651,
  [6652] = 6652,
  [6653] = 6638,
  [6654] = 6654,
  [6655] = 6655,
  [6656] = 6656,
  [6657] = 6657,
  [6658] = 6658,
  [6659] = 6636,
  [6660] = 6657,
  [6661] = 6658,
  [6662] = 6656,
  [6663] = 6655,
  [6664] = 6664,
  [6665] = 6635,
  [6666] = 6658,
  [6667] = 6657,
  [6668] = 6651,
  [6669] = 6645,
  [6670] = 6652,
  [6671] = 6671,
  [6672] = 6641,
  [6673] = 6673,
  [6674] = 6674,
  [6675] = 6675,
  [6676] = 6638,
  [6677] = 6644,
  [6678] = 6650,
  [6679] = 6644,
  [6680] = 6646,
  [6681] = 6646,
  [6682] = 6640,
  [6683] = 6642,
  [6684] = 6684,
  [6685] = 6636,
  [6686] = 6674,
  [6687] = 6687,
  [6688] = 6641,
  [6689] = 6673,
  [6690] = 6658,
  [6691] = 6657,
  [6692] = 6673,
  [6693] = 6654,
  [6694] = 6674,
  [6695] = 6644,
  [6696] = 6696,
  [6697] = 6671,
  [6698] = 6655,
  [6699] = 6651,
  [6700] = 6635,
  [6701] = 6648,
  [6702] = 6655,
  [6703] = 6645,
  [6704] = 6636,
  [6705] = 6656,
  [6706] = 6649,
  [6707] = 6656,
  [6708] = 6652,
  [6709] = 6644,
  [6710] = 6710,
  [6711] = 6638,
  [6712] = 6655,
  [6713] = 6640,
  [6714] = 6650,
  [6715] = 6636,
  [6716] = 6651,
  [6717] = 6649,
  [6718] = 6642,
  [6719] = 6673,
  [6720] = 6720,
  [6721] = 6648,
  [6722] = 6639,
  [6723] = 6687,
  [6724] = 6649,
  [6725] = 6674,
  [6726] = 6673,
  [6727] = 6654,
  [6728] = 6655,
  [6729] = 6729,
  [6730] = 6730,
  [6731] = 6652,
  [6732] = 6656,
  [6733] = 6640,
  [6734] = 6654,
  [6735] = 6639,
  [6736] = 6635,
  [6737] = 6687,
  [6738] = 6648,
  [6739] = 6739,
  [6740] = 6655,
  [6741] = 6635,
  [6742] = 6742,
  [6743] = 6743,
  [6744] = 6657,
  [6745] = 6636,
  [6746] = 6671,
  [6747] = 6658,
  [6748] = 6652,
  [6749] = 6658,
  [6750] = 6750,
  [6751] = 6656,
  [6752] = 6674,
  [6753] = 6753,
  [6754] = 6687,
  [6755] = 6755,
  [6756] = 6639,
  [6757] = 6655,
  [6758] = 6758,
  [6759] = 6687,
  [6760] = 6638,
  [6761] = 6641,
  [6762] = 6650,
  [6763] = 6687,
  [6764] = 6642,
  [6765] = 6641,
  [6766] = 6646,
  [6767] = 6640,
  [6768] = 6642,
  [6769] = 6642,
  [6770] = 6646,
  [6771] = 6671,
  [6772] = 6650,
  [6773] = 6640,
  [6774] = 6639,
  [6775] = 6687,
  [6776] = 6641,
  [6777] = 6655,
  [6778] = 6648,
  [6779] = 6639,
  [6780] = 6687,
  [6781] = 6658,
  [6782] = 6636,
  [6783] = 6657,
  [6784] = 6639,
  [6785] = 6687,
  [6786] = 6655,
  [6787] = 6654,
  [6788] = 6642,
  [6789] = 6639,
  [6790] = 6646,
  [6791] = 6651,
  [6792] = 6792,
  [6793] = 6687,
  [6794] = 6639,
  [6795] = 6687,
  [6796] = 6648,
  [6797] = 6639,
  [6798] = 6656,
  [6799] = 6657,
  [6800] = 6800,
  [6801] = 6801,
  [6802] = 6655,
  [6803] = 6650,
  [6804] = 6644,
  [6805] = 6658,
  [6806] = 6638,
  [6807] = 6649,
  [6808] = 6657,
  [6809] = 6635,
  [6810] = 6652,
  [6811] = 6656,
  [6812] = 6812,
  [6813] = 6635,
  [6814] = 6673,
  [6815] = 6674,
  [6816] = 6673,
  [6817] = 6639,
  [6818] = 6656,
  [6819] = 6674,
  [6820] = 6641,
  [6821] = 6645,
  [6822] = 6642,
  [6823] = 6651,
  [6824] = 6652,
  [6825] = 6644,
  [6826] = 6638,
  [6827] = 5982,
  [6828] = 6655,
  [6829] = 6645,
  [6830] = 6656,
  [6831] = 6671,
  [6832] = 6650,
  [6833] = 6641,
  [6834] = 6646,
  [6835] = 6646,
  [6836] = 6649,
  [6837] = 6638,
  [6838] = 6838,
  [6839] = 6642,
  [6840] = 6650,
  [6841] = 6658,
  [6842] = 6657,
  [6843] = 6645,
  [6844] = 6642,
  [6845] = 6657,
  [6846] = 6636,
  [6847] = 6655,
  [6848] = 6648,
  [6849] = 6673,
  [6850] = 6654,
  [6851] = 6851,
  [6852] = 6652,
  [6853] = 6674,
  [6854] = 6673,
  [6855] = 6640,
  [6856] = 6856,
  [6857] = 6651,
  [6858] = 6858,
  [6859] = 6636,
  [6860] = 6654,
  [6861] = 6644,
  [6862] = 6674,
  [6863] = 6673,
  [6864] = 6648,
  [6865] = 6865,
  [6866] = 6644,
  [6867] = 6642,
  [6868] = 6650,
  [6869] = 6638,
  [6870] = 6674,
  [6871] = 6646,
  [6872] = 6872,
  [6873] = 6652,
  [6874] = 6645,
  [6875] = 6645,
  [6876] = 6656,
  [6877] = 6674,
  [6878] = 6645,
  [6879] = 6673,
  [6880] = 6648,
  [6881] = 6654,
  [6882] = 6882,
  [6883] = 6658,
  [6884] = 6641,
  [6885] = 6638,
  [6886] = 6655,
  [6887] = 6640,
  [6888] = 6644,
  [6889] = 6646,
  [6890] = 6651,
  [6891] = 6650,
  [6892] = 6892,
  [6893] = 6650,
  [6894] = 6658,
  [6895] = 6657,
  [6896] = 6655,
  [6897] = 6651,
  [6898] = 6638,
  [6899] = 6655,
  [6900] = 6900,
  [6901] = 6901,
  [6902] = 6902,
  [6903] = 6903,
  [6904] = 6904,
  [6905] = 6905,
  [6906] = 6906,
  [6907] = 6907,
  [6908] = 6908,
  [6909] = 6909,
  [6910] = 6910,
  [6911] = 6911,
  [6912] = 378,
  [6913] = 6913,
  [6914] = 6909,
  [6915] = 6915,
  [6916] = 6916,
  [6917] = 6917,
  [6918] = 6918,
  [6919] = 6919,
  [6920] = 6920,
  [6921] = 6921,
  [6922] = 6922,
  [6923] = 6917,
  [6924] = 6918,
  [6925] = 6925,
  [6926] = 6926,
  [6927] = 6927,
  [6928] = 6928,
  [6929] = 6929,
  [6930] = 6900,
  [6931] = 6931,
  [6932] = 6908,
  [6933] = 6933,
  [6934] = 6934,
  [6935] = 6935,
  [6936] = 6922,
  [6937] = 6937,
  [6938] = 6938,
  [6939] = 6939,
  [6940] = 6940,
  [6941] = 6941,
  [6942] = 6942,
  [6943] = 6903,
  [6944] = 6904,
  [6945] = 6926,
  [6946] = 6946,
  [6947] = 6947,
  [6948] = 6948,
  [6949] = 6929,
  [6950] = 6950,
  [6951] = 6951,
  [6952] = 6939,
  [6953] = 6941,
  [6954] = 6954,
  [6955] = 6926,
  [6956] = 6956,
  [6957] = 6957,
  [6958] = 6958,
  [6959] = 6908,
  [6960] = 6934,
  [6961] = 6933,
  [6962] = 6962,
  [6963] = 6962,
  [6964] = 6964,
  [6965] = 6922,
  [6966] = 6966,
  [6967] = 6967,
  [6968] = 6968,
  [6969] = 6969,
  [6970] = 6970,
  [6971] = 6900,
  [6972] = 6972,
  [6973] = 6918,
  [6974] = 6974,
  [6975] = 6975,
  [6976] = 6976,
  [6977] = 6900,
  [6978] = 6978,
  [6979] = 6979,
  [6980] = 6922,
  [6981] = 6962,
  [6982] = 6982,
  [6983] = 6937,
  [6984] = 6984,
  [6985] = 6935,
  [6986] = 6986,
  [6987] = 6987,
  [6988] = 6937,
  [6989] = 6931,
  [6990] = 6918,
  [6991] = 6926,
  [6992] = 6908,
  [6993] = 6941,
  [6994] = 6968,
  [6995] = 6939,
  [6996] = 6996,
  [6997] = 6909,
  [6998] = 6929,
  [6999] = 6917,
  [7000] = 6918,
  [7001] = 7001,
  [7002] = 6964,
  [7003] = 6917,
  [7004] = 6900,
  [7005] = 7005,
  [7006] = 6904,
  [7007] = 6942,
  [7008] = 6903,
  [7009] = 6904,
  [7010] = 7010,
  [7011] = 6933,
  [7012] = 6903,
  [7013] = 6939,
  [7014] = 6941,
  [7015] = 6942,
  [7016] = 6934,
  [7017] = 6962,
  [7018] = 6966,
  [7019] = 6909,
  [7020] = 6913,
  [7021] = 6935,
  [7022] = 6908,
  [7023] = 6934,
  [7024] = 6933,
  [7025] = 6917,
  [7026] = 6919,
  [7027] = 7010,
  [7028] = 7028,
  [7029] = 6956,
  [7030] = 7030,
  [7031] = 6958,
  [7032] = 6909,
  [7033] = 6902,
  [7034] = 6900,
  [7035] = 6916,
  [7036] = 6922,
  [7037] = 6942,
  [7038] = 6903,
  [7039] = 6904,
  [7040] = 380,
  [7041] = 6939,
  [7042] = 6941,
  [7043] = 6908,
  [7044] = 6956,
  [7045] = 6962,
  [7046] = 6905,
  [7047] = 6918,
  [7048] = 6917,
  [7049] = 6908,
  [7050] = 6928,
  [7051] = 6942,
  [7052] = 6903,
  [7053] = 6909,
  [7054] = 6931,
  [7055] = 6941,
  [7056] = 7056,
  [7057] = 6904,
  [7058] = 6972,
  [7059] = 6909,
  [7060] = 6908,
  [7061] = 6942,
  [7062] = 6903,
  [7063] = 6904,
  [7064] = 6919,
  [7065] = 6919,
  [7066] = 6916,
  [7067] = 7067,
  [7068] = 6939,
  [7069] = 7069,
  [7070] = 6937,
  [7071] = 6908,
  [7072] = 7072,
  [7073] = 6931,
  [7074] = 7074,
  [7075] = 6908,
  [7076] = 6937,
  [7077] = 6909,
  [7078] = 7078,
  [7079] = 6942,
  [7080] = 6903,
  [7081] = 6904,
  [7082] = 7082,
  [7083] = 6937,
  [7084] = 7084,
  [7085] = 7085,
  [7086] = 7086,
  [7087] = 7087,
  [7088] = 6919,
  [7089] = 7056,
  [7090] = 7028,
  [7091] = 7056,
  [7092] = 6927,
  [7093] = 6909,
  [7094] = 6931,
  [7095] = 6942,
  [7096] = 6903,
  [7097] = 6904,
  [7098] = 7030,
  [7099] = 6929,
  [7100] = 6934,
  [7101] = 7101,
  [7102] = 6931,
  [7103] = 6908,
  [7104] = 7104,
  [7105] = 7105,
  [7106] = 6962,
  [7107] = 6958,
  [7108] = 6942,
  [7109] = 6909,
  [7110] = 7056,
  [7111] = 6942,
  [7112] = 6903,
  [7113] = 6904,
  [7114] = 6966,
  [7115] = 7010,
  [7116] = 6926,
  [7117] = 6941,
  [7118] = 6939,
  [7119] = 6916,
  [7120] = 6929,
  [7121] = 6902,
  [7122] = 7122,
  [7123] = 7123,
  [7124] = 6958,
  [7125] = 6909,
  [7126] = 6982,
  [7127] = 6942,
  [7128] = 6903,
  [7129] = 6904,
  [7130] = 6904,
  [7131] = 6903,
  [7132] = 6916,
  [7133] = 7028,
  [7134] = 7134,
  [7135] = 6942,
  [7136] = 6979,
  [7137] = 6919,
  [7138] = 6929,
  [7139] = 6913,
  [7140] = 6909,
  [7141] = 7141,
  [7142] = 7142,
  [7143] = 6915,
  [7144] = 7144,
  [7145] = 7145,
  [7146] = 6939,
  [7147] = 6962,
  [7148] = 6941,
  [7149] = 6933,
  [7150] = 6917,
  [7151] = 7151,
  [7152] = 6968,
  [7153] = 6900,
  [7154] = 6926,
  [7155] = 6908,
  [7156] = 6956,
  [7157] = 7157,
  [7158] = 6918,
  [7159] = 7134,
  [7160] = 7160,
  [7161] = 7161,
  [7162] = 6950,
  [7163] = 6948,
  [7164] = 6904,
  [7165] = 6922,
  [7166] = 6926,
  [7167] = 7167,
  [7168] = 6922,
  [7169] = 6900,
  [7170] = 6982,
  [7171] = 6979,
  [7172] = 6968,
  [7173] = 7173,
  [7174] = 6918,
  [7175] = 6964,
  [7176] = 6917,
  [7177] = 6933,
  [7178] = 6941,
  [7179] = 6909,
  [7180] = 6934,
  [7181] = 6939,
  [7182] = 7182,
  [7183] = 7134,
  [7184] = 6903,
  [7185] = 6956,
  [7186] = 6929,
  [7187] = 6905,
  [7188] = 7028,
  [7189] = 6919,
  [7190] = 6928,
  [7191] = 6902,
  [7192] = 6927,
  [7193] = 6942,
  [7194] = 6916,
  [7195] = 6942,
  [7196] = 6908,
  [7197] = 6903,
  [7198] = 6928,
  [7199] = 6908,
  [7200] = 6904,
  [7201] = 6931,
  [7202] = 6904,
  [7203] = 6903,
  [7204] = 7204,
  [7205] = 6942,
  [7206] = 6948,
  [7207] = 6950,
  [7208] = 6937,
  [7209] = 6928,
  [7210] = 6929,
  [7211] = 6905,
  [7212] = 6962,
  [7213] = 6905,
  [7214] = 6908,
  [7215] = 6939,
  [7216] = 7216,
  [7217] = 7056,
  [7218] = 6908,
  [7219] = 6941,
  [7220] = 7220,
  [7221] = 6926,
  [7222] = 7030,
  [7223] = 6908,
  [7224] = 6902,
  [7225] = 6934,
  [7226] = 6979,
  [7227] = 6948,
  [7228] = 6982,
  [7229] = 6966,
  [7230] = 7010,
  [7231] = 6950,
  [7232] = 6933,
  [7233] = 6964,
  [7234] = 7010,
  [7235] = 7235,
  [7236] = 6982,
  [7237] = 6979,
  [7238] = 6962,
  [7239] = 6956,
  [7240] = 6909,
  [7241] = 6966,
  [7242] = 6979,
  [7243] = 6982,
  [7244] = 6962,
  [7245] = 6968,
  [7246] = 6900,
  [7247] = 7247,
  [7248] = 6950,
  [7249] = 6948,
  [7250] = 7010,
  [7251] = 6913,
  [7252] = 6922,
  [7253] = 7253,
  [7254] = 6935,
  [7255] = 6918,
  [7256] = 6917,
  [7257] = 6909,
  [7258] = 6913,
  [7259] = 6950,
  [7260] = 7260,
  [7261] = 6900,
  [7262] = 6919,
  [7263] = 7028,
  [7264] = 6926,
  [7265] = 6941,
  [7266] = 6939,
  [7267] = 6948,
  [7268] = 6929,
  [7269] = 7269,
  [7270] = 6931,
  [7271] = 7271,
  [7272] = 6958,
  [7273] = 7273,
  [7274] = 7274,
  [7275] = 6902,
  [7276] = 7056,
  [7277] = 6916,
  [7278] = 6937,
  [7279] = 6904,
  [7280] = 6903,
  [7281] = 6942,
  [7282] = 6928,
  [7283] = 6905,
  [7284] = 6931,
  [7285] = 7285,
  [7286] = 7056,
  [7287] = 6927,
  [7288] = 6908,
  [7289] = 6966,
  [7290] = 6908,
  [7291] = 6962,
  [7292] = 6916,
  [7293] = 6956,
  [7294] = 6934,
  [7295] = 6902,
  [7296] = 7296,
  [7297] = 7297,
  [7298] = 6908,
  [7299] = 6933,
  [7300] = 6964,
  [7301] = 6937,
  [7302] = 6968,
  [7303] = 6900,
  [7304] = 7304,
  [7305] = 6931,
  [7306] = 7028,
  [7307] = 7030,
  [7308] = 7308,
  [7309] = 6922,
  [7310] = 6934,
  [7311] = 7311,
  [7312] = 6933,
  [7313] = 6918,
  [7314] = 6917,
  [7315] = 7056,
  [7316] = 6964,
  [7317] = 6919,
  [7318] = 7318,
  [7319] = 6913,
  [7320] = 6909,
  [7321] = 6968,
  [7322] = 6937,
  [7323] = 7323,
  [7324] = 7324,
  [7325] = 7030,
  [7326] = 7326,
  [7327] = 7327,
  [7328] = 7328,
  [7329] = 7329,
  [7330] = 7330,
  [7331] = 7327,
  [7332] = 7332,
  [7333] = 7333,
  [7334] = 7333,
  [7335] = 7335,
  [7336] = 7336,
  [7337] = 7335,
  [7338] = 7338,
  [7339] = 7339,
  [7340] = 7340,
  [7341] = 7341,
  [7342] = 7342,
  [7343] = 7343,
  [7344] = 7343,
  [7345] = 7345,
  [7346] = 7346,
  [7347] = 7347,
  [7348] = 7348,
  [7349] = 7349,
  [7350] = 7350,
  [7351] = 7351,
  [7352] = 7352,
  [7353] = 7353,
  [7354] = 7354,
  [7355] = 7355,
  [7356] = 7356,
  [7357] = 7357,
  [7358] = 7358,
  [7359] = 7342,
  [7360] = 7360,
  [7361] = 7340,
  [7362] = 7326,
  [7363] = 7363,
  [7364] = 7356,
  [7365] = 7332,
  [7366] = 7366,
  [7367] = 7358,
  [7368] = 7353,
  [7369] = 7354,
  [7370] = 7357,
  [7371] = 7328,
  [7372] = 7330,
  [7373] = 7352,
  [7374] = 7350,
  [7375] = 7330,
  [7376] = 7348,
  [7377] = 7377,
  [7378] = 7329,
  [7379] = 7328,
  [7380] = 7380,
  [7381] = 7332,
  [7382] = 7382,
  [7383] = 7333,
  [7384] = 7384,
  [7385] = 7385,
  [7386] = 7386,
  [7387] = 7330,
  [7388] = 7335,
  [7389] = 7333,
  [7390] = 7343,
  [7391] = 7332,
  [7392] = 7392,
  [7393] = 7393,
  [7394] = 7394,
  [7395] = 7366,
  [7396] = 7326,
  [7397] = 7355,
  [7398] = 7398,
  [7399] = 7351,
  [7400] = 7352,
  [7401] = 7401,
  [7402] = 7326,
  [7403] = 7357,
  [7404] = 7327,
  [7405] = 7349,
  [7406] = 7339,
  [7407] = 7356,
  [7408] = 7345,
  [7409] = 7341,
  [7410] = 7410,
  [7411] = 7335,
  [7412] = 7358,
  [7413] = 7353,
  [7414] = 7392,
  [7415] = 7335,
  [7416] = 7355,
  [7417] = 7326,
  [7418] = 7348,
  [7419] = 7354,
  [7420] = 7420,
  [7421] = 7350,
  [7422] = 7350,
  [7423] = 7353,
  [7424] = 7348,
  [7425] = 7340,
  [7426] = 7345,
  [7427] = 7345,
  [7428] = 7351,
  [7429] = 7342,
  [7430] = 7352,
  [7431] = 7355,
  [7432] = 7432,
  [7433] = 7366,
  [7434] = 7335,
  [7435] = 7348,
  [7436] = 7350,
  [7437] = 7357,
  [7438] = 7353,
  [7439] = 7358,
  [7440] = 7330,
  [7441] = 7441,
  [7442] = 7354,
  [7443] = 7420,
  [7444] = 7444,
  [7445] = 7340,
  [7446] = 7446,
  [7447] = 7363,
  [7448] = 7342,
  [7449] = 7356,
  [7450] = 7354,
  [7451] = 7330,
  [7452] = 7363,
  [7453] = 7446,
  [7454] = 7329,
  [7455] = 7455,
  [7456] = 7456,
  [7457] = 7457,
  [7458] = 7458,
  [7459] = 7333,
  [7460] = 7460,
  [7461] = 7336,
  [7462] = 7349,
  [7463] = 7463,
  [7464] = 7464,
  [7465] = 7358,
  [7466] = 7357,
  [7467] = 7467,
  [7468] = 7352,
  [7469] = 7469,
  [7470] = 7332,
  [7471] = 7355,
  [7472] = 7333,
  [7473] = 7335,
  [7474] = 7335,
  [7475] = 7326,
  [7476] = 7332,
  [7477] = 7366,
  [7478] = 7352,
  [7479] = 7357,
  [7480] = 7366,
  [7481] = 7358,
  [7482] = 7463,
  [7483] = 7326,
  [7484] = 7329,
  [7485] = 7355,
  [7486] = 7354,
  [7487] = 7341,
  [7488] = 7339,
  [7489] = 7351,
  [7490] = 7467,
  [7491] = 7339,
  [7492] = 7366,
  [7493] = 7464,
  [7494] = 7420,
  [7495] = 7326,
  [7496] = 7349,
  [7497] = 7366,
  [7498] = 7355,
  [7499] = 7460,
  [7500] = 7341,
  [7501] = 7457,
  [7502] = 7353,
  [7503] = 7350,
  [7504] = 7348,
  [7505] = 7353,
  [7506] = 7350,
  [7507] = 7339,
  [7508] = 7392,
  [7509] = 7348,
  [7510] = 7352,
  [7511] = 7511,
  [7512] = 7339,
  [7513] = 7410,
  [7514] = 7514,
  [7515] = 7345,
  [7516] = 7357,
  [7517] = 7342,
  [7518] = 7401,
  [7519] = 7519,
  [7520] = 7332,
  [7521] = 7393,
  [7522] = 7333,
  [7523] = 7343,
  [7524] = 7339,
  [7525] = 7358,
  [7526] = 7339,
  [7527] = 7339,
  [7528] = 7382,
  [7529] = 7363,
  [7530] = 7530,
  [7531] = 7336,
  [7532] = 7532,
  [7533] = 7345,
  [7534] = 7463,
  [7535] = 7354,
  [7536] = 7410,
  [7537] = 7366,
  [7538] = 7467,
  [7539] = 7346,
  [7540] = 7342,
  [7541] = 7541,
  [7542] = 7356,
  [7543] = 7353,
  [7544] = 7351,
  [7545] = 7350,
  [7546] = 7348,
  [7547] = 7547,
  [7548] = 7336,
  [7549] = 7345,
  [7550] = 7335,
  [7551] = 7551,
  [7552] = 7355,
  [7553] = 7340,
  [7554] = 7335,
  [7555] = 7410,
  [7556] = 7463,
  [7557] = 7339,
  [7558] = 7467,
  [7559] = 7340,
  [7560] = 7382,
  [7561] = 7330,
  [7562] = 7562,
  [7563] = 7563,
  [7564] = 7327,
  [7565] = 7393,
  [7566] = 7444,
  [7567] = 7330,
  [7568] = 7332,
  [7569] = 7339,
  [7570] = 7345,
  [7571] = 7446,
  [7572] = 7343,
  [7573] = 7410,
  [7574] = 7574,
  [7575] = 7340,
  [7576] = 7354,
  [7577] = 7420,
  [7578] = 7341,
  [7579] = 7463,
  [7580] = 7339,
  [7581] = 7467,
  [7582] = 7342,
  [7583] = 7335,
  [7584] = 7363,
  [7585] = 7328,
  [7586] = 7354,
  [7587] = 7327,
  [7588] = 7330,
  [7589] = 7356,
  [7590] = 7354,
  [7591] = 7467,
  [7592] = 7339,
  [7593] = 7354,
  [7594] = 7333,
  [7595] = 7340,
  [7596] = 7393,
  [7597] = 7332,
  [7598] = 7342,
  [7599] = 7457,
  [7600] = 7464,
  [7601] = 7356,
  [7602] = 7460,
  [7603] = 7410,
  [7604] = 7349,
  [7605] = 7356,
  [7606] = 7464,
  [7607] = 7349,
  [7608] = 7354,
  [7609] = 7467,
  [7610] = 7420,
  [7611] = 7335,
  [7612] = 7460,
  [7613] = 7339,
  [7614] = 7339,
  [7615] = 7341,
  [7616] = 7335,
  [7617] = 7463,
  [7618] = 7618,
  [7619] = 7382,
  [7620] = 7463,
  [7621] = 7329,
  [7622] = 7343,
  [7623] = 7354,
  [7624] = 7624,
  [7625] = 7464,
  [7626] = 7358,
  [7627] = 7457,
  [7628] = 7420,
  [7629] = 7333,
  [7630] = 7333,
  [7631] = 7357,
  [7632] = 7352,
  [7633] = 7633,
  [7634] = 7351,
  [7635] = 7332,
  [7636] = 7328,
  [7637] = 7352,
  [7638] = 7357,
  [7639] = 7392,
  [7640] = 7351,
  [7641] = 7393,
  [7642] = 7410,
  [7643] = 7444,
  [7644] = 7644,
  [7645] = 7363,
  [7646] = 7339,
  [7647] = 7401,
  [7648] = 7363,
  [7649] = 7393,
  [7650] = 7410,
  [7651] = 7651,
  [7652] = 7652,
  [7653] = 7345,
  [7654] = 7339,
  [7655] = 7354,
  [7656] = 7366,
  [7657] = 7326,
  [7658] = 7420,
  [7659] = 7659,
  [7660] = 7463,
  [7661] = 7355,
  [7662] = 7444,
  [7663] = 7335,
  [7664] = 7353,
  [7665] = 7350,
  [7666] = 7348,
  [7667] = 7467,
  [7668] = 7464,
  [7669] = 7669,
  [7670] = 7457,
  [7671] = 7348,
  [7672] = 7330,
  [7673] = 7350,
  [7674] = 7353,
  [7675] = 7345,
  [7676] = 7358,
  [7677] = 7339,
  [7678] = 7341,
  [7679] = 7393,
  [7680] = 7382,
  [7681] = 7335,
  [7682] = 7682,
  [7683] = 7363,
  [7684] = 7345,
  [7685] = 7444,
  [7686] = 7686,
  [7687] = 7348,
  [7688] = 7350,
  [7689] = 7410,
  [7690] = 7341,
  [7691] = 7353,
  [7692] = 7393,
  [7693] = 7392,
  [7694] = 7329,
  [7695] = 7339,
  [7696] = 7446,
  [7697] = 7697,
  [7698] = 7355,
  [7699] = 7326,
  [7700] = 7366,
  [7701] = 7457,
  [7702] = 7328,
  [7703] = 7401,
  [7704] = 7460,
  [7705] = 7330,
  [7706] = 7349,
  [7707] = 7707,
  [7708] = 7464,
  [7709] = 7709,
  [7710] = 7467,
  [7711] = 7420,
  [7712] = 7712,
  [7713] = 7355,
  [7714] = 7352,
  [7715] = 7326,
  [7716] = 7366,
  [7717] = 7463,
  [7718] = 7357,
  [7719] = 7444,
  [7720] = 7463,
  [7721] = 7329,
  [7722] = 7358,
  [7723] = 7723,
  [7724] = 7363,
  [7725] = 7358,
  [7726] = 7357,
  [7727] = 7467,
  [7728] = 7420,
  [7729] = 7464,
  [7730] = 7460,
  [7731] = 7352,
  [7732] = 7340,
  [7733] = 7457,
  [7734] = 7341,
  [7735] = 7339,
  [7736] = 7342,
  [7737] = 7392,
  [7738] = 7457,
  [7739] = 7739,
  [7740] = 7410,
  [7741] = 7351,
  [7742] = 7742,
  [7743] = 7743,
  [7744] = 7744,
  [7745] = 7351,
  [7746] = 7332,
  [7747] = 7393,
  [7748] = 7354,
  [7749] = 7446,
  [7750] = 7363,
  [7751] = 7333,
  [7752] = 7356,
  [7753] = 7753,
  [7754] = 7754,
  [7755] = 7755,
  [7756] = 7756,
  [7757] = 7757,
  [7758] = 7758,
  [7759] = 7759,
  [7760] = 7760,
  [7761] = 7761,
  [7762] = 7762,
  [7763] = 7763,
  [7764] = 7764,
  [7765] = 7765,
  [7766] = 7766,
  [7767] = 7767,
  [7768] = 7768,
  [7769] = 7769,
  [7770] = 7770,
  [7771] = 7771,
  [7772] = 7772,
  [7773] = 7773,
  [7774] = 7774,
  [7775] = 7775,
  [7776] = 7776,
  [7777] = 7777,
  [7778] = 7778,
  [7779] = 7779,
  [7780] = 7780,
  [7781] = 7781,
  [7782] = 7782,
  [7783] = 7783,
  [7784] = 7784,
  [7785] = 2237,
  [7786] = 7786,
  [7787] = 7787,
  [7788] = 7788,
  [7789] = 7789,
  [7790] = 7790,
  [7791] = 7790,
  [7792] = 7792,
  [7793] = 7793,
  [7794] = 7794,
  [7795] = 7795,
  [7796] = 7796,
  [7797] = 7797,
  [7798] = 7798,
  [7799] = 7799,
  [7800] = 7800,
  [7801] = 7787,
  [7802] = 7786,
  [7803] = 7803,
  [7804] = 7804,
  [7805] = 7805,
  [7806] = 7783,
  [7807] = 7792,
  [7808] = 7808,
  [7809] = 7755,
  [7810] = 7810,
  [7811] = 7811,
  [7812] = 7812,
  [7813] = 7782,
  [7814] = 7781,
  [7815] = 7759,
  [7816] = 7777,
  [7817] = 7817,
  [7818] = 7818,
  [7819] = 7819,
  [7820] = 7820,
  [7821] = 7821,
  [7822] = 7775,
  [7823] = 7762,
  [7824] = 7781,
  [7825] = 7773,
  [7826] = 7770,
  [7827] = 7827,
  [7828] = 7771,
  [7829] = 7772,
  [7830] = 7783,
  [7831] = 7771,
  [7832] = 7770,
  [7833] = 7833,
  [7834] = 7804,
  [7835] = 7767,
  [7836] = 7765,
  [7837] = 7837,
  [7838] = 7838,
  [7839] = 7839,
  [7840] = 7840,
  [7841] = 7762,
  [7842] = 7838,
  [7843] = 7787,
  [7844] = 7844,
  [7845] = 7845,
  [7846] = 7793,
  [7847] = 7847,
  [7848] = 7753,
  [7849] = 7839,
  [7850] = 7794,
  [7851] = 7851,
  [7852] = 7852,
  [7853] = 7853,
  [7854] = 7759,
  [7855] = 7754,
  [7856] = 7755,
  [7857] = 7857,
  [7858] = 7858,
  [7859] = 7859,
  [7860] = 7860,
  [7861] = 7787,
  [7862] = 7770,
  [7863] = 7863,
  [7864] = 7783,
  [7865] = 7865,
  [7866] = 7866,
  [7867] = 7867,
  [7868] = 7753,
  [7869] = 7869,
  [7870] = 7870,
  [7871] = 7852,
  [7872] = 7872,
  [7873] = 7873,
  [7874] = 7799,
  [7875] = 7875,
  [7876] = 7876,
  [7877] = 7787,
  [7878] = 7878,
  [7879] = 7879,
  [7880] = 7880,
  [7881] = 7881,
  [7882] = 7882,
  [7883] = 7883,
  [7884] = 7786,
  [7885] = 7885,
  [7886] = 7886,
  [7887] = 7887,
  [7888] = 7888,
  [7889] = 7889,
  [7890] = 7805,
  [7891] = 7783,
  [7892] = 7892,
  [7893] = 7870,
  [7894] = 7894,
  [7895] = 7895,
  [7896] = 7770,
  [7897] = 7897,
  [7898] = 7783,
  [7899] = 7759,
  [7900] = 7833,
  [7901] = 7901,
  [7902] = 7788,
  [7903] = 7779,
  [7904] = 7758,
  [7905] = 7778,
  [7906] = 7778,
  [7907] = 7758,
  [7908] = 7779,
  [7909] = 7787,
  [7910] = 7782,
  [7911] = 7782,
  [7912] = 5711,
  [7913] = 7767,
  [7914] = 7781,
  [7915] = 7851,
  [7916] = 7833,
  [7917] = 7777,
  [7918] = 7775,
  [7919] = 7773,
  [7920] = 7772,
  [7921] = 7892,
  [7922] = 7922,
  [7923] = 7870,
  [7924] = 5641,
  [7925] = 7770,
  [7926] = 7820,
  [7927] = 7927,
  [7928] = 7889,
  [7929] = 7771,
  [7930] = 7888,
  [7931] = 7886,
  [7932] = 7770,
  [7933] = 7879,
  [7934] = 7878,
  [7935] = 7935,
  [7936] = 7875,
  [7937] = 7847,
  [7938] = 7872,
  [7939] = 7939,
  [7940] = 7867,
  [7941] = 7866,
  [7942] = 7865,
  [7943] = 7837,
  [7944] = 7818,
  [7945] = 7945,
  [7946] = 7765,
  [7947] = 7947,
  [7948] = 7844,
  [7949] = 7892,
  [7950] = 7950,
  [7951] = 7951,
  [7952] = 7952,
  [7953] = 7882,
  [7954] = 7954,
  [7955] = 7955,
  [7956] = 7956,
  [7957] = 7957,
  [7958] = 7958,
  [7959] = 7878,
  [7960] = 7960,
  [7961] = 7961,
  [7962] = 7962,
  [7963] = 7963,
  [7964] = 7754,
  [7965] = 7762,
  [7966] = 7966,
  [7967] = 7967,
  [7968] = 7840,
  [7969] = 7969,
  [7970] = 7768,
  [7971] = 7880,
  [7972] = 7852,
  [7973] = 2254,
  [7974] = 7782,
  [7975] = 7975,
  [7976] = 7873,
  [7977] = 7885,
  [7978] = 7781,
  [7979] = 7979,
  [7980] = 7980,
  [7981] = 7981,
  [7982] = 7982,
  [7983] = 7883,
  [7984] = 7984,
  [7985] = 7821,
  [7986] = 7986,
  [7987] = 7847,
  [7988] = 7876,
  [7989] = 7844,
  [7990] = 7927,
  [7991] = 7837,
  [7992] = 7992,
  [7993] = 7993,
  [7994] = 7869,
  [7995] = 7995,
  [7996] = 7777,
  [7997] = 7997,
  [7998] = 7789,
  [7999] = 7999,
  [8000] = 7863,
  [8001] = 8001,
  [8002] = 7775,
  [8003] = 7999,
  [8004] = 7789,
  [8005] = 7773,
  [8006] = 7759,
  [8007] = 8007,
  [8008] = 8008,
  [8009] = 7772,
  [8010] = 7853,
  [8011] = 8011,
  [8012] = 8012,
  [8013] = 7755,
  [8014] = 7787,
  [8015] = 7851,
  [8016] = 7784,
  [8017] = 7817,
  [8018] = 7986,
  [8019] = 7812,
  [8020] = 7975,
  [8021] = 7858,
  [8022] = 8022,
  [8023] = 7811,
  [8024] = 8024,
  [8025] = 8025,
  [8026] = 7808,
  [8027] = 8027,
  [8028] = 7753,
  [8029] = 8029,
  [8030] = 7803,
  [8031] = 7787,
  [8032] = 7839,
  [8033] = 7927,
  [8034] = 7935,
  [8035] = 7838,
  [8036] = 8036,
  [8037] = 7800,
  [8038] = 8038,
  [8039] = 8039,
  [8040] = 7767,
  [8041] = 7803,
  [8042] = 7804,
  [8043] = 8043,
  [8044] = 7765,
  [8045] = 8045,
  [8046] = 7821,
  [8047] = 7820,
  [8048] = 7956,
  [8049] = 7794,
  [8050] = 7793,
  [8051] = 7792,
  [8052] = 7818,
  [8053] = 8053,
  [8054] = 7790,
  [8055] = 8055,
  [8056] = 7860,
  [8057] = 8057,
  [8058] = 8058,
  [8059] = 7799,
  [8060] = 8060,
  [8061] = 8061,
  [8062] = 7788,
  [8063] = 7798,
  [8064] = 7786,
  [8065] = 7776,
  [8066] = 7774,
  [8067] = 7756,
  [8068] = 7757,
  [8069] = 7760,
  [8070] = 7761,
  [8071] = 8071,
  [8072] = 7805,
  [8073] = 8073,
  [8074] = 7783,
  [8075] = 7761,
  [8076] = 7760,
  [8077] = 7757,
  [8078] = 7756,
  [8079] = 7774,
  [8080] = 8080,
  [8081] = 8081,
  [8082] = 7776,
  [8083] = 8083,
  [8084] = 8084,
  [8085] = 7788,
  [8086] = 7883,
  [8087] = 7795,
  [8088] = 7796,
  [8089] = 7798,
  [8090] = 8090,
  [8091] = 7853,
  [8092] = 7800,
  [8093] = 8093,
  [8094] = 7771,
  [8095] = 7777,
  [8096] = 7837,
  [8097] = 7865,
  [8098] = 7818,
  [8099] = 8099,
  [8100] = 7820,
  [8101] = 7821,
  [8102] = 7927,
  [8103] = 7775,
  [8104] = 7852,
  [8105] = 7773,
  [8106] = 7866,
  [8107] = 7819,
  [8108] = 7867,
  [8109] = 7804,
  [8110] = 7754,
  [8111] = 7838,
  [8112] = 7839,
  [8113] = 7765,
  [8114] = 7789,
  [8115] = 7865,
  [8116] = 7753,
  [8117] = 7851,
  [8118] = 7853,
  [8119] = 7755,
  [8120] = 7866,
  [8121] = 7789,
  [8122] = 7867,
  [8123] = 7997,
  [8124] = 7767,
  [8125] = 7875,
  [8126] = 8126,
  [8127] = 7878,
  [8128] = 7863,
  [8129] = 7879,
  [8130] = 7869,
  [8131] = 7772,
  [8132] = 8132,
  [8133] = 7886,
  [8134] = 7888,
  [8135] = 7889,
  [8136] = 8136,
  [8137] = 7935,
  [8138] = 7876,
  [8139] = 7892,
  [8140] = 7993,
  [8141] = 7800,
  [8142] = 7779,
  [8143] = 7880,
  [8144] = 7778,
  [8145] = 7758,
  [8146] = 7833,
  [8147] = 7870,
  [8148] = 7882,
  [8149] = 7883,
  [8150] = 7782,
  [8151] = 7781,
  [8152] = 7876,
  [8153] = 8036,
  [8154] = 7869,
  [8155] = 7883,
  [8156] = 7777,
  [8157] = 7775,
  [8158] = 8158,
  [8159] = 7773,
  [8160] = 7772,
  [8161] = 7870,
  [8162] = 8162,
  [8163] = 7863,
  [8164] = 7889,
  [8165] = 7789,
  [8166] = 7872,
  [8167] = 7789,
  [8168] = 7975,
  [8169] = 7833,
  [8170] = 7889,
  [8171] = 7853,
  [8172] = 7758,
  [8173] = 7770,
  [8174] = 7778,
  [8175] = 7779,
  [8176] = 7935,
  [8177] = 5536,
  [8178] = 7784,
  [8179] = 7817,
  [8180] = 7767,
  [8181] = 7875,
  [8182] = 7812,
  [8183] = 8183,
  [8184] = 7892,
  [8185] = 7878,
  [8186] = 7765,
  [8187] = 7945,
  [8188] = 7947,
  [8189] = 7851,
  [8190] = 7951,
  [8191] = 7952,
  [8192] = 7955,
  [8193] = 7886,
  [8194] = 7878,
  [8195] = 7889,
  [8196] = 7888,
  [8197] = 7840,
  [8198] = 7882,
  [8199] = 7768,
  [8200] = 7888,
  [8201] = 7886,
  [8202] = 7879,
  [8203] = 7878,
  [8204] = 7873,
  [8205] = 7885,
  [8206] = 7883,
  [8207] = 8183,
  [8208] = 7839,
  [8209] = 8209,
  [8210] = 7838,
  [8211] = 7997,
  [8212] = 7789,
  [8213] = 7999,
  [8214] = 7875,
  [8215] = 7811,
  [8216] = 7872,
  [8217] = 7986,
  [8218] = 7804,
  [8219] = 7975,
  [8220] = 7821,
  [8221] = 7808,
  [8222] = 7867,
  [8223] = 8024,
  [8224] = 7866,
  [8225] = 7762,
  [8226] = 7935,
  [8227] = 7865,
  [8228] = 8036,
  [8229] = 7927,
  [8230] = 7798,
  [8231] = 7986,
  [8232] = 8232,
  [8233] = 7892,
  [8234] = 7776,
  [8235] = 7774,
  [8236] = 8236,
  [8237] = 7760,
  [8238] = 7945,
  [8239] = 7757,
  [8240] = 7951,
  [8241] = 7955,
  [8242] = 7888,
  [8243] = 7779,
  [8244] = 7840,
  [8245] = 7768,
  [8246] = 7798,
  [8247] = 7886,
  [8248] = 7873,
  [8249] = 7885,
  [8250] = 7778,
  [8251] = 7879,
  [8252] = 7878,
  [8253] = 7999,
  [8254] = 8232,
  [8255] = 7796,
  [8256] = 7795,
  [8257] = 7986,
  [8258] = 7879,
  [8259] = 7975,
  [8260] = 8183,
  [8261] = 8261,
  [8262] = 8024,
  [8263] = 7882,
  [8264] = 7758,
  [8265] = 7935,
  [8266] = 8036,
  [8267] = 7761,
  [8268] = 7833,
  [8269] = 5700,
  [8270] = 7945,
  [8271] = 7756,
  [8272] = 7951,
  [8273] = 7955,
  [8274] = 7759,
  [8275] = 7882,
  [8276] = 7840,
  [8277] = 7768,
  [8278] = 7870,
  [8279] = 7800,
  [8280] = 7873,
  [8281] = 7885,
  [8282] = 7803,
  [8283] = 7875,
  [8284] = 7999,
  [8285] = 7754,
  [8286] = 7755,
  [8287] = 8287,
  [8288] = 7986,
  [8289] = 7837,
  [8290] = 7975,
  [8291] = 7852,
  [8292] = 7782,
  [8293] = 8024,
  [8294] = 7858,
  [8295] = 7781,
  [8296] = 7935,
  [8297] = 8036,
  [8298] = 7788,
  [8299] = 8299,
  [8300] = 7945,
  [8301] = 7776,
  [8302] = 7951,
  [8303] = 7955,
  [8304] = 8304,
  [8305] = 7986,
  [8306] = 7840,
  [8307] = 7768,
  [8308] = 7804,
  [8309] = 7847,
  [8310] = 7873,
  [8311] = 7885,
  [8312] = 7999,
  [8313] = 7844,
  [8314] = 7927,
  [8315] = 7837,
  [8316] = 8024,
  [8317] = 8036,
  [8318] = 7852,
  [8319] = 7945,
  [8320] = 7951,
  [8321] = 7754,
  [8322] = 8322,
  [8323] = 8287,
  [8324] = 7873,
  [8325] = 7777,
  [8326] = 7875,
  [8327] = 7975,
  [8328] = 7775,
  [8329] = 7945,
  [8330] = 7951,
  [8331] = 7872,
  [8332] = 7773,
  [8333] = 7772,
  [8334] = 7873,
  [8335] = 7774,
  [8336] = 7762,
  [8337] = 7879,
  [8338] = 7886,
  [8339] = 7945,
  [8340] = 7951,
  [8341] = 7888,
  [8342] = 7784,
  [8343] = 7817,
  [8344] = 7873,
  [8345] = 7812,
  [8346] = 8346,
  [8347] = 7811,
  [8348] = 7892,
  [8349] = 7945,
  [8350] = 7808,
  [8351] = 6629,
  [8352] = 7883,
  [8353] = 7758,
  [8354] = 7803,
  [8355] = 8355,
  [8356] = 7787,
  [8357] = 8357,
  [8358] = 8358,
  [8359] = 8359,
  [8360] = 7870,
  [8361] = 7800,
  [8362] = 8362,
  [8363] = 7858,
  [8364] = 7767,
  [8365] = 7882,
  [8366] = 7882,
  [8367] = 7876,
  [8368] = 8368,
  [8369] = 7765,
  [8370] = 7863,
  [8371] = 7956,
  [8372] = 8372,
  [8373] = 7853,
  [8374] = 7851,
  [8375] = 7839,
  [8376] = 7993,
  [8377] = 8377,
  [8378] = 7794,
  [8379] = 7997,
  [8380] = 7901,
  [8381] = 7793,
  [8382] = 8382,
  [8383] = 7799,
  [8384] = 7792,
  [8385] = 7838,
  [8386] = 7880,
  [8387] = 8387,
  [8388] = 7758,
  [8389] = 8389,
  [8390] = 7790,
  [8391] = 8391,
  [8392] = 7786,
  [8393] = 8393,
  [8394] = 7821,
  [8395] = 7860,
  [8396] = 7880,
  [8397] = 7805,
  [8398] = 7783,
  [8399] = 7798,
  [8400] = 7876,
  [8401] = 7761,
  [8402] = 8402,
  [8403] = 8403,
  [8404] = 8404,
  [8405] = 8405,
  [8406] = 8136,
  [8407] = 7760,
  [8408] = 7757,
  [8409] = 7803,
  [8410] = 7837,
  [8411] = 7875,
  [8412] = 7879,
  [8413] = 7799,
  [8414] = 7869,
  [8415] = 7886,
  [8416] = 8416,
  [8417] = 7955,
  [8418] = 7756,
  [8419] = 7863,
  [8420] = 7757,
  [8421] = 7878,
  [8422] = 7760,
  [8423] = 7888,
  [8424] = 8359,
  [8425] = 8358,
  [8426] = 7760,
  [8427] = 7863,
  [8428] = 7870,
  [8429] = 7882,
  [8430] = 7876,
  [8431] = 7863,
  [8432] = 7952,
  [8433] = 8433,
  [8434] = 7951,
  [8435] = 7771,
  [8436] = 7853,
  [8437] = 8437,
  [8438] = 7851,
  [8439] = 7869,
  [8440] = 7774,
  [8441] = 8441,
  [8442] = 8442,
  [8443] = 7786,
  [8444] = 7867,
  [8445] = 7839,
  [8446] = 7866,
  [8447] = 8357,
  [8448] = 7803,
  [8449] = 7865,
  [8450] = 7776,
  [8451] = 7838,
  [8452] = 7853,
  [8453] = 7804,
  [8454] = 7821,
  [8455] = 7876,
  [8456] = 8456,
  [8457] = 8357,
  [8458] = 8358,
  [8459] = 8359,
  [8460] = 7798,
  [8461] = 7795,
  [8462] = 7796,
  [8463] = 7798,
  [8464] = 7993,
  [8465] = 8465,
  [8466] = 7803,
  [8467] = 7997,
  [8468] = 7901,
  [8469] = 7760,
  [8470] = 7760,
  [8471] = 7757,
  [8472] = 7756,
  [8473] = 7876,
  [8474] = 8358,
  [8475] = 8359,
  [8476] = 8476,
  [8477] = 7803,
  [8478] = 7837,
  [8479] = 7993,
  [8480] = 7818,
  [8481] = 7997,
  [8482] = 7901,
  [8483] = 7875,
  [8484] = 7820,
  [8485] = 7922,
  [8486] = 7821,
  [8487] = 8358,
  [8488] = 8359,
  [8489] = 7879,
  [8490] = 7837,
  [8491] = 7886,
  [8492] = 7993,
  [8493] = 7803,
  [8494] = 7997,
  [8495] = 7901,
  [8496] = 7860,
  [8497] = 8024,
  [8498] = 7888,
  [8499] = 7803,
  [8500] = 8358,
  [8501] = 8359,
  [8502] = 7757,
  [8503] = 7819,
  [8504] = 7993,
  [8505] = 7901,
  [8506] = 7804,
  [8507] = 8358,
  [8508] = 8359,
  [8509] = 7993,
  [8510] = 8358,
  [8511] = 8359,
  [8512] = 7993,
  [8513] = 8358,
  [8514] = 8359,
  [8515] = 7993,
  [8516] = 7993,
  [8517] = 8357,
  [8518] = 8442,
  [8519] = 7881,
  [8520] = 7760,
  [8521] = 7947,
  [8522] = 7838,
  [8523] = 7839,
  [8524] = 8357,
  [8525] = 8442,
  [8526] = 7881,
  [8527] = 7870,
  [8528] = 7798,
  [8529] = 7821,
  [8530] = 7770,
  [8531] = 8357,
  [8532] = 8442,
  [8533] = 7881,
  [8534] = 7804,
  [8535] = 7753,
  [8536] = 7838,
  [8537] = 8357,
  [8538] = 8442,
  [8539] = 7881,
  [8540] = 7851,
  [8541] = 7760,
  [8542] = 7839,
  [8543] = 8442,
  [8544] = 7881,
  [8545] = 7853,
  [8546] = 8136,
  [8547] = 7945,
  [8548] = 7863,
  [8549] = 7789,
  [8550] = 7851,
  [8551] = 7876,
  [8552] = 7805,
  [8553] = 7757,
  [8554] = 7783,
  [8555] = 8441,
  [8556] = 8441,
  [8557] = 8441,
  [8558] = 8441,
  [8559] = 8441,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43471
    ? (c < 4096
      ? (c < 2649
        ? (c < 1791
          ? (c < 891
            ? (c < 186
              ? (c < 'o'
                ? (c < 'e'
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'a')
                  : (c <= 'e' || (c < 'j'
                    ? (c >= 'g' && c <= 'h')
                    : c <= 'l')))
                : (c <= 'o' || (c < 170
                  ? (c < 'w'
                    ? (c >= 'q' && c <= 'r')
                    : c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 736
                ? (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))))))
            : (c <= 893 || (c < 1376
              ? (c < 931
                ? (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))
                : (c <= 1013 || (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))))
              : (c <= 1416 || (c < 1649
                ? (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))))))))
          : (c <= 1791 || (c < 2417
            ? (c < 2088
              ? (c < 2036
                ? (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || (c < 1994
                    ? c == 1969
                    : c <= 2026)))
                : (c <= 2037 || (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || c == 2084))))
              : (c <= 2088 || (c < 2208
                ? (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))
                : (c <= 2249 || (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))))))
            : (c <= 2432 || (c < 2527
              ? (c < 2482
                ? (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))
                : (c <= 2482 || (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))))
              : (c <= 2529 || (c < 2579
                ? (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))))))))))
        : (c <= 2652 || (c < 3200
          ? (c < 2911
            ? (c < 2784
              ? (c < 2730
                ? (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)))
                : (c <= 2736 || (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || c == 2768))))
              : (c <= 2785 || (c < 2858
                ? (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))
                : (c <= 2864 || (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))))))
            : (c <= 2913 || (c < 2990
              ? (c < 2969
                ? (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)))
                : (c <= 2970 || (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))))
              : (c <= 3001 || (c < 3114
                ? (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))
                : (c <= 3129 || (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))))))))
          : (c <= 3200 || (c < 3517
            ? (c < 3342
              ? (c < 3261
                ? (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)))
                : (c <= 3261 || (c < 3313
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))))
              : (c <= 3344 || (c < 3423
                ? (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))
                : (c <= 3425 || (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))))))
            : (c <= 3517 || (c < 3751
              ? (c < 3713
                ? (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))))
              : (c <= 3760 || (c < 3804
                ? (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))
                : (c <= 3807 || (c < 3913
                  ? (c < 3904
                    ? c == 3840
                    : c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))))))))))))
      : (c <= 4138 || (c < 8118
        ? (c < 6016
          ? (c < 4786
            ? (c < 4301
              ? (c < 4206
                ? (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || (c < 4197
                    ? c == 4193
                    : c <= 4198)))
                : (c <= 4208 || (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || c == 4295))))
              : (c <= 4301 || (c < 4696
                ? (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))
                : (c <= 4696 || (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))))))
            : (c <= 4789 || (c < 5121
              ? (c < 4882
                ? (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))
                : (c <= 4885 || (c < 5024
                  ? (c < 4992
                    ? (c >= 4888 && c <= 4954)
                    : c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))))
              : (c <= 5740 || (c < 5888
                ? (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c >= 5870 && c <= 5880)))
                : (c <= 5905 || (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))))))))
          : (c <= 6067 || (c < 7245
            ? (c < 6576
              ? (c < 6320
                ? (c < 6176
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6108)
                  : (c <= 6264 || (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)))
                : (c <= 6389 || (c < 6512
                  ? (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))))
              : (c <= 6601 || (c < 6981
                ? (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7098
                  ? (c < 7086
                    ? (c >= 7043 && c <= 7072)
                    : c <= 7087)
                  : (c <= 7141 || (c >= 7168 && c <= 7203)))))))
            : (c <= 7247 || (c < 7680
              ? (c < 7401
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))
                : (c <= 7404 || (c < 7418
                  ? (c < 7413
                    ? (c >= 7406 && c <= 7411)
                    : c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))))
              : (c <= 7957 || (c < 8025
                ? (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))
                : (c <= 8025 || (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))))))))))
        : (c <= 8124 || (c < 11736
          ? (c < 8508
            ? (c < 8336
              ? (c < 8160
                ? (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)))
                : (c <= 8172 || (c < 8305
                  ? (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)
                  : (c <= 8305 || c == 8319))))
              : (c <= 8348 || (c < 8472
                ? (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c >= 8490 && c <= 8505)))))))
            : (c <= 8511 || (c < 11568
              ? (c < 11499
                ? (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c >= 11264 && c <= 11492)))
                : (c <= 11502 || (c < 11559
                  ? (c < 11520
                    ? (c >= 11506 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || c == 11565))))
              : (c <= 11623 || (c < 11696
                ? (c < 11680
                  ? (c < 11648
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))))))))
          : (c <= 11742 || (c < 42656
            ? (c < 12704
              ? (c < 12445
                ? (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))
              : (c <= 12735 || (c < 42240
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))))))
            : (c <= 42735 || (c < 43020
              ? (c < 42963
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 43011
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))
              : (c <= 43042 || (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))))))))))))
    : (c <= 43471 || (c < 70656
      ? (c < 66928
        ? (c < 64612
          ? (c < 43808
            ? (c < 43701
              ? (c < 43588
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))
                : (c <= 43595 || (c < 43646
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)
                  : (c <= 43695 || c == 43697))))
              : (c <= 43702 || (c < 43744
                ? (c < 43714
                  ? (c < 43712
                    ? (c >= 43705 && c <= 43709)
                    : c <= 43712)
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))
                : (c <= 43754 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))))))
            : (c <= 43814 || (c < 64275
              ? (c < 55216
                ? (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))))
              : (c <= 64279 || (c < 64318
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c >= 64467 && c <= 64605)))))))))
          : (c <= 64829 || (c < 65576
            ? (c < 65313
              ? (c < 65143
                ? (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65139
                    ? c == 65137
                    : c <= 65139)))
                : (c <= 65143 || (c < 65149
                  ? (c < 65147
                    ? c == 65145
                    : c <= 65147)
                  : (c <= 65149 || (c >= 65151 && c <= 65276)))))
              : (c <= 65338 || (c < 65482
                ? (c < 65440
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65437)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65536
                  ? (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))))))
            : (c <= 65594 || (c < 66384
              ? (c < 65856
                ? (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c >= 65664 && c <= 65786)))
                : (c <= 65908 || (c < 66304
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))))
              : (c <= 66421 || (c < 66560
                ? (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c >= 66513 && c <= 66517)))
                : (c <= 66717 || (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c >= 66864 && c <= 66915)))))))))))
        : (c <= 66938 || (c < 68800
          ? (c < 67712
            ? (c < 67456
              ? (c < 66995
                ? (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))
                : (c <= 67001 || (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))))
              : (c <= 67461 || (c < 67594
                ? (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c >= 67680 && c <= 67702)))))))
            : (c <= 67742 || (c < 68192
              ? (c < 68030
                ? (c < 67840
                  ? (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)
                  : (c <= 67861 || (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43471
    ? (c < 3976
      ? (c < 2616
        ? (c < 1786
          ? (c < 886
            ? (c < 181
              ? (c < 'j'
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'a' || (c < 'g'
                    ? c == 'e'
                    : c <= 'h')))
                : (c <= 'l' || (c < 'w'
                  ? (c < 'q'
                    ? c == 'o'
                    : c <= 'r')
                  : (c <= 'z' || c == 170))))
              : (c <= 181 || (c < 710
                ? (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c >= 880 && c <= 884)))))))
            : (c <= 887 || (c < 1369
              ? (c < 910
                ? (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)))
                : (c <= 929 || (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))))
              : (c <= 1369 || (c < 1646
                ? (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))))))))
          : (c <= 1788 || (c < 2392
            ? (c < 2084
              ? (c < 1994
                ? (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c < 1969
                    ? (c >= 1869 && c <= 1957)
                    : c <= 1969)))
                : (c <= 2026 || (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || c == 2074))))
              : (c <= 2084 || (c < 2185
                ? (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))
                : (c <= 2190 || (c < 2365
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))))))
            : (c <= 2401 || (c < 2524
              ? (c < 2474
                ? (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))
                : (c <= 2480 || (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))))
              : (c <= 2525 || (c < 2575
                ? (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))))))))))
        : (c <= 2617 || (c < 3168
          ? (c < 2908
            ? (c < 2768
              ? (c < 2707
                ? (c < 2674
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2676 || (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)))
                : (c <= 2728 || (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || c == 2749))))
              : (c <= 2768 || (c < 2835
                ? (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || c == 2877))))))
            : (c <= 2909 || (c < 2984
              ? (c < 2962
                ? (c < 2947
                  ? (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)
                  : (c <= 2947 || (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)))
                : (c <= 2965 || (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))))
              : (c <= 2986 || (c < 3090
                ? (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))
                : (c <= 3112 || (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))))))))
          : (c <= 3169 || (c < 3507
            ? (c < 3332
              ? (c < 3253
                ? (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))
                : (c <= 3257 || (c < 3296
                  ? (c < 3293
                    ? c == 3261
                    : c <= 3294)
                  : (c <= 3297 || (c >= 3313 && c <= 3314)))))
              : (c <= 3340 || (c < 3412
                ? (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))
                : (c <= 3414 || (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))))))
            : (c <= 3515 || (c < 3749
              ? (c < 3648
                ? (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))
                : (c <= 3654 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))))
              : (c <= 3749 || (c < 3782
                ? (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))
                : (c <= 3782 || (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))))))))))))
      : (c <= 3980 || (c < 8064
        ? (c < 5998
          ? (c < 4752
            ? (c < 4295
              ? (c < 4197
                ? (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c < 4193
                    ? (c >= 4186 && c <= 4189)
                    : c <= 4193)))
                : (c <= 4198 || (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c >= 4256 && c <= 4293)))))
              : (c <= 4295 || (c < 4688
                ? (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))))))
            : (c <= 4784 || (c < 5112
              ? (c < 4824
                ? (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))
                : (c <= 4880 || (c < 4992
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))))
              : (c <= 5117 || (c < 5870
                ? (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))
                : (c <= 5880 || (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5905)
                    : c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))))))))
          : (c <= 6000 || (c < 7168
            ? (c < 6528
              ? (c < 6314
                ? (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : c <= 6103)
                  : (c <= 6108 || (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)))
                : (c <= 6314 || (c < 6480
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6509 || (c >= 6512 && c <= 6516)))))
              : (c <= 6571 || (c < 6917
                ? (c < 6688
                  ? (c < 6656
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6678)
                  : (c <= 6740 || c == 6823))
                : (c <= 6963 || (c < 7086
                  ? (c < 7043
                    ? (c >= 6981 && c <= 6988)
                    : c <= 7072)
                  : (c <= 7087 || (c >= 7098 && c <= 7141)))))))
            : (c <= 7203 || (c < 7424
              ? (c < 7357
                ? (c < 7296
                  ? (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)
                  : (c <= 7304 || (c >= 7312 && c <= 7354)))
                : (c <= 7359 || (c < 7413
                  ? (c < 7406
                    ? (c >= 7401 && c <= 7404)
                    : c <= 7411)
                  : (c <= 7414 || c == 7418))))
              : (c <= 7615 || (c < 8016
                ? (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c >= 8008 && c <= 8013)))
                : (c <= 8023 || (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c >= 8031 && c <= 8061)))))))))))
        : (c <= 8116 || (c < 11736
          ? (c < 8490
            ? (c < 8319
              ? (c < 8150
                ? (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))
                : (c <= 8155 || (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || c == 8305))))
              : (c <= 8319 || (c < 8469
                ? (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))
                : (c <= 8469 || (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))))))
            : (c <= 8505 || (c < 11568
              ? (c < 11499
                ? (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))
                : (c <= 11502 || (c < 11559
                  ? (c < 11520
                    ? (c >= 11506 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || c == 11565))))
              : (c <= 11623 || (c < 11696
                ? (c < 11680
                  ? (c < 11648
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))))))))
          : (c <= 11742 || (c < 42656
            ? (c < 12704
              ? (c < 12445
                ? (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))
              : (c <= 12735 || (c < 42240
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))))))
            : (c <= 42735 || (c < 43020
              ? (c < 42963
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 43011
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))
              : (c <= 43042 || (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))))))))))))
    : (c <= 43471 || (c < 70656
      ? (c < 66928
        ? (c < 64612
          ? (c < 43808
            ? (c < 43701
              ? (c < 43588
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))
                : (c <= 43595 || (c < 43646
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)
                  : (c <= 43695 || c == 43697))))
              : (c <= 43702 || (c < 43744
                ? (c < 43714
                  ? (c < 43712
                    ? (c >= 43705 && c <= 43709)
                    : c <= 43712)
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))
                : (c <= 43754 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))))))
            : (c <= 43814 || (c < 64275
              ? (c < 55216
                ? (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))))
              : (c <= 64279 || (c < 64318
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c >= 64467 && c <= 64605)))))))))
          : (c <= 64829 || (c < 65576
            ? (c < 65313
              ? (c < 65143
                ? (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65139
                    ? c == 65137
                    : c <= 65139)))
                : (c <= 65143 || (c < 65149
                  ? (c < 65147
                    ? c == 65145
                    : c <= 65147)
                  : (c <= 65149 || (c >= 65151 && c <= 65276)))))
              : (c <= 65338 || (c < 65482
                ? (c < 65440
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65437)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65536
                  ? (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))))))
            : (c <= 65594 || (c < 66384
              ? (c < 65856
                ? (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c >= 65664 && c <= 65786)))
                : (c <= 65908 || (c < 66304
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))))
              : (c <= 66421 || (c < 66560
                ? (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c >= 66513 && c <= 66517)))
                : (c <= 66717 || (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c >= 66864 && c <= 66915)))))))))))
        : (c <= 66938 || (c < 68800
          ? (c < 67712
            ? (c < 67456
              ? (c < 66995
                ? (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))
                : (c <= 67001 || (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))))
              : (c <= 67461 || (c < 67594
                ? (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c >= 67680 && c <= 67702)))))))
            : (c <= 67742 || (c < 68192
              ? (c < 68030
                ? (c < 67840
                  ? (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)
                  : (c <= 67861 || (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 43396
    ? (c < 3913
      ? (c < 2613
        ? (c < 1774
          ? (c < 880
            ? (c < 170
              ? (c < 'j'
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'a' || (c < 'g'
                    ? c == 'e'
                    : c <= 'h')))
                : (c <= 'l' || (c < 't'
                  ? (c < 'q'
                    ? c == 'o'
                    : c <= 'r')
                  : (c <= 't' || (c >= 'w' && c <= 'z')))))
              : (c <= 170 || (c < 248
                ? (c < 192
                  ? (c < 186
                    ? c == 181
                    : c <= 186)
                  : (c <= 214 || (c >= 216 && c <= 246)))
                : (c <= 705 || (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || c == 750))))))
            : (c <= 884 || (c < 1329
              ? (c < 908
                ? (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 904
                    ? c == 902
                    : c <= 906)))
                : (c <= 908 || (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c >= 1162 && c <= 1327)))))
              : (c <= 1366 || (c < 1568
                ? (c < 1488
                  ? (c < 1376
                    ? c == 1369
                    : c <= 1416)
                  : (c <= 1514 || (c >= 1519 && c <= 1522)))
                : (c <= 1610 || (c < 1749
                  ? (c < 1649
                    ? (c >= 1646 && c <= 1647)
                    : c <= 1747)
                  : (c <= 1749 || (c >= 1765 && c <= 1766)))))))))
          : (c <= 1775 || (c < 2384
            ? (c < 2074
              ? (c < 1969
                ? (c < 1808
                  ? (c < 1791
                    ? (c >= 1786 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1808 || (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)))
                : (c <= 1969 || (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))))
              : (c <= 2074 || (c < 2160
                ? (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c >= 2144 && c <= 2154)))
                : (c <= 2183 || (c < 2308
                  ? (c < 2208
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2249)
                  : (c <= 2361 || c == 2365))))))
            : (c <= 2384 || (c < 2510
              ? (c < 2451
                ? (c < 2437
                  ? (c < 2417
                    ? (c >= 2392 && c <= 2401)
                    : c <= 2432)
                  : (c <= 2444 || (c >= 2447 && c <= 2448)))
                : (c <= 2472 || (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || c == 2493))))
              : (c <= 2510 || (c < 2565
                ? (c < 2544
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2529)
                  : (c <= 2545 || c == 2556))
                : (c <= 2570 || (c < 2602
                  ? (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)
                  : (c <= 2608 || (c >= 2610 && c <= 2611)))))))))))
        : (c <= 2614 || (c < 3165
          ? (c < 2877
            ? (c < 2749
              ? (c < 2703
                ? (c < 2654
                  ? (c < 2649
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2652)
                  : (c <= 2654 || (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))))
              : (c <= 2749 || (c < 2831
                ? (c < 2809
                  ? (c < 2784
                    ? c == 2768
                    : c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c >= 2869 && c <= 2873)))))))
            : (c <= 2877 || (c < 2979
              ? (c < 2958
                ? (c < 2929
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2913)
                  : (c <= 2929 || (c < 2949
                    ? c == 2947
                    : c <= 2954)))
                : (c <= 2960 || (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c >= 2974 && c <= 2975)))))
              : (c <= 2980 || (c < 3086
                ? (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))))))))
          : (c <= 3165 || (c < 3482
            ? (c < 3313
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c >= 3296 && c <= 3297)))))
              : (c <= 3314 || (c < 3406
                ? (c < 3346
                  ? (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3386 || c == 3389))
                : (c <= 3406 || (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))))))
            : (c <= 3505 || (c < 3724
              ? (c < 3634
                ? (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c >= 3585 && c <= 3632)))
                : (c <= 3634 || (c < 3716
                  ? (c < 3713
                    ? (c >= 3648 && c <= 3654)
                    : c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))))
              : (c <= 3747 || (c < 3776
                ? (c < 3762
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3760)
                  : (c <= 3762 || c == 3773))
                : (c <= 3780 || (c < 3840
                  ? (c < 3804
                    ? c == 3782
                    : c <= 3807)
                  : (c <= 3840 || (c >= 3904 && c <= 3911)))))))))))))
      : (c <= 3948 || (c < 8031
        ? (c < 5984
          ? (c < 4746
            ? (c < 4256
              ? (c < 4193
                ? (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)))
                : (c <= 4193 || (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || c == 4238))))
              : (c <= 4293 || (c < 4682
                ? (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))))))
            : (c <= 4749 || (c < 5024
              ? (c < 4808
                ? (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || (c < 4802
                    ? c == 4800
                    : c <= 4805)))
                : (c <= 4822 || (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))))
              : (c <= 5109 || (c < 5792
                ? (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))))))))
          : (c <= 5996 || (c < 7098
            ? (c < 6512
              ? (c < 6272
                ? (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || (c < 6176
                    ? c == 6108
                    : c <= 6264)))
                : (c <= 6312 || (c < 6400
                  ? (c < 6320
                    ? c == 6314
                    : c <= 6389)
                  : (c <= 6430 || (c >= 6480 && c <= 6509)))))
              : (c <= 6516 || (c < 6823
                ? (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))
                : (c <= 6823 || (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))))))
            : (c <= 7141 || (c < 7418
              ? (c < 7312
                ? (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))))
              : (c <= 7418 || (c < 8008
                ? (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))
                : (c <= 8013 || (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))))))))))
        : (c <= 8061 || (c < 11728
          ? (c < 8488
            ? (c < 8305
              ? (c < 8144
                ? (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)))
                : (c <= 8147 || (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))))
              : (c <= 8305 || (c < 8458
                ? (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))
                : (c <= 8467 || (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))))))
            : (c <= 8488 || (c < 11565
              ? (c < 11264
                ? (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || (c < 8544
                    ? c == 8526
                    : c <= 8584)))
                : (c <= 11492 || (c < 11520
                  ? (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)
                  : (c <= 11557 || c == 11559))))
              : (c <= 11565 || (c < 11688
                ? (c < 11648
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c >= 11720 && c <= 11726)))))))))
          : (c <= 11734 || (c < 42623
            ? (c < 12593
              ? (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)))
                : (c <= 12438 || (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c >= 12549 && c <= 12591)))))
              : (c <= 12686 || (c < 42192
                ? (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c >= 19968 && c <= 42124)))
                : (c <= 42237 || (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))))))
            : (c <= 42653 || (c < 43015
              ? (c < 42960
                ? (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42954)))
                : (c <= 42961 || (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))))
              : (c <= 43018 || (c < 43259
                ? (c < 43138
                  ? (c < 43072
                    ? (c >= 43020 && c <= 43042)
                    : c <= 43123)
                  : (c <= 43187 || (c >= 43250 && c <= 43255)))
                : (c <= 43259 || (c < 43312
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))))))))))))))
    : (c <= 43442 || (c < 70493
      ? (c < 66864
        ? (c < 64467
          ? (c < 43793
            ? (c < 43697
              ? (c < 43584
                ? (c < 43494
                  ? (c < 43488
                    ? c == 43471
                    : c <= 43492)
                  : (c <= 43503 || (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)))
                : (c <= 43586 || (c < 43642
                  ? (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)
                  : (c <= 43642 || (c >= 43646 && c <= 43695)))))
              : (c <= 43697 || (c < 43739
                ? (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))
                : (c <= 43741 || (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))))))
            : (c <= 43798 || (c < 64256
              ? (c < 44032
                ? (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)))
                : (c <= 55203 || (c < 63744
                  ? (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))))
              : (c <= 64262 || (c < 64312
                ? (c < 64287
                  ? (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64285)
                  : (c <= 64296 || (c >= 64298 && c <= 64310)))
                : (c <= 64316 || (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c >= 64326 && c <= 64433)))))))))
          : (c <= 64605 || (c < 65549
            ? (c < 65151
              ? (c < 65139
                ? (c < 64914
                  ? (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)
                  : (c <= 64967 || (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)))
                : (c <= 65139 || (c < 65147
                  ? (c < 65145
                    ? c == 65143
                    : c <= 65145)
                  : (c <= 65147 || c == 65149))))
              : (c <= 65276 || (c < 65474
                ? (c < 65382
                  ? (c < 65345
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65370)
                  : (c <= 65437 || (c >= 65440 && c <= 65470)))
                : (c <= 65479 || (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c >= 65536 && c <= 65547)))))))
            : (c <= 65574 || (c < 66349
              ? (c < 65664
                ? (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c >= 65616 && c <= 65629)))
                : (c <= 65786 || (c < 66208
                  ? (c < 66176
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))))
              : (c <= 66378 || (c < 66513
                ? (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66421)
                    : c <= 66461)
                  : (c <= 66499 || (c >= 66504 && c <= 66511)))
                : (c <= 66517 || (c < 66776
                  ? (c < 66736
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66771)
                  : (c <= 66811 || (c >= 66816 && c <= 66855)))))))))))
        : (c <= 66915 || (c < 68736
          ? (c < 67680
            ? (c < 67424
              ? (c < 66979
                ? (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))
                : (c <= 66993 || (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))))
              : (c <= 67431 || (c < 67592
                ? (c < 67506
                  ? (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)
                  : (c <= 67514 || (c >= 67584 && c <= 67589)))
                : (c <= 67592 || (c < 67644
                  ? (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)
                  : (c <= 67644 || (c >= 67647 && c <= 67669)))))))
            : (c <= 67702 || (c < 68121
              ? (c < 67968
                ? (c < 67828
                  ? (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)
                  : (c <= 67829 || (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)))
                : (c <= 68023 || (c < 68112
                  ? (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68096)
                  : (c <= 68115 || (c >= 68117 && c <= 68119)))))
              : (c <= 68149 || (c < 68352
                ? (c < 68288
                  ? (c < 68224
                    ? (c >= 68192 && c <= 68220)
                    : c <= 68252)
                  : (c <= 68295 || (c >= 68297 && c <= 68324)))
                : (c <= 68405 || (c < 68480
                  ? (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)
                  : (c <= 68497 || (c >= 68608 && c <= 68680)))))))))
          : (c <= 68786 || (c < 70019
            ? (c < 69635
              ? (c < 69415
                ? (c < 69248
                  ? (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68899)
                  : (c <= 69289 || (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)))
                : (c <= 69415 || (c < 69552
                  ? (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)
                  : (c <= 69572 || (c >= 69600 && c <= 69622)))))
              : (c <= 69687 || (c < 69891
                ? (c < 69763
                  ? (c < 69749
                    ? (c >= 69745 && c <= 69746)
                    : c <= 69749)
                  : (c <= 69807 || (c >= 69840 && c <= 69864)))
                : (c <= 69926 || (c < 69968
                  ? (c < 69959
                    ? c == 69956
                    : c <= 69959)
                  : (c <= 70002 || c == 70006))))))
            : (c <= 70066 || (c < 70303
              ? (c < 70163
                ? (c < 70108
                  ? (c < 70106
                    ? (c >= 70081 && c <= 70084)
                    : c <= 70106)
                  : (c <= 70108 || (c >= 70144 && c <= 70161)))
                : (c <= 70187 || (c < 70282
                  ? (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)
                  : (c <= 70285 || (c >= 70287 && c <= 70301)))))
              : (c <= 70312 || (c < 70442
                ? (c < 70415
                  ? (c < 70405
                    ? (c >= 70320 && c <= 70366)
                    : c <= 70412)
                  : (c <= 70416 || (c >= 70419 && c <= 70440)))
                : (c <= 70448 || (c < 70461
                  ? (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)
                  : (c <= 70461 || c == 70480))))))))))))
      : (c <= 70497 || (c < 119808
        ? (c < 73030
          ? (c < 71960
            ? (c < 71296
              ? (c < 70855
                ? (c < 70751
                  ? (c < 70727
                    ? (c >= 70656 && c <= 70708)
                    : c <= 70730)
                  : (c <= 70753 || (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)))
                : (c <= 70855 || (c < 71168
                  ? (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)
                  : (c <= 71215 || c == 71236))))
              : (c <= 71338 || (c < 71840
                ? (c < 71488
                  ? (c < 71424
                    ? c == 71352
                    : c <= 71450)
                  : (c <= 71494 || (c >= 71680 && c <= 71723)))
                : (c <= 71903 || (c < 71948
                  ? (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)
                  : (c <= 71955 || (c >= 71957 && c <= 71958)))))))
            : (c <= 71983 || (c < 72284
              ? (c < 72163
                ? (c < 72096
                  ? (c < 72001
                    ? c == 71999
                    : c <= 72001)
                  : (c <= 72103 || (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)))
                : (c <= 72163 || (c < 72250
                  ? (c < 72203
                    ? c == 72192
                    : c <= 72242)
                  : (c <= 72250 || c == 72272))))
              : (c <= 72329 || (c < 72768
                ? (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c >= 72714 && c <= 72750)))
                : (c <= 72768 || (c < 72968
                  ? (c < 72960
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72966)
                  : (c <= 72969 || (c >= 72971 && c <= 73008)))))))))
          : (c <= 73030 || (c < 93760
            ? (c < 77824
              ? (c < 73648
                ? (c < 73066
                  ? (c < 73063
                    ? (c >= 73056 && c <= 73061)
                    : c <= 73064)
                  : (c <= 73097 || (c < 73440
                    ? c == 73112
                    : c <= 73458)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c >= 77712 && c <= 77808)))))
              : (c <= 78894 || (c < 92880
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c >= 92784 && c <= 92862)))
                : (c <= 92909 || (c < 93027
                  ? (c < 92992
                    ? (c >= 92928 && c <= 92975)
                    : c <= 92995)
                  : (c <= 93047 || (c >= 93053 && c <= 93071)))))))
            : (c <= 93823 || (c < 110581
              ? (c < 94179
                ? (c < 94099
                  ? (c < 94032
                    ? (c >= 93952 && c <= 94026)
                    : c <= 94032)
                  : (c <= 94111 || (c >= 94176 && c <= 94177)))
                : (c <= 94179 || (c < 101632
                  ? (c < 100352
                    ? (c >= 94208 && c <= 100343)
                    : c <= 101589)
                  : (c <= 101640 || (c >= 110576 && c <= 110579)))))
              : (c <= 110587 || (c < 110960
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c >= 110948 && c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c >= 113808 && c <= 113817)))))))))))
        : (c <= 119892 || (c < 125259
          ? (c < 120540
            ? (c < 120077
              ? (c < 119982
                ? (c < 119970
                  ? (c < 119966
                    ? (c >= 119894 && c <= 119964)
                    : c <= 119967)
                  : (c <= 119970 || (c < 119977
                    ? (c >= 119973 && c <= 119974)
                    : c <= 119980)))
                : (c <= 119993 || (c < 120005
                  ? (c < 119997
                    ? c == 119995
                    : c <= 120003)
                  : (c <= 120069 || (c >= 120071 && c <= 120074)))))
              : (c <= 120084 || (c < 120134
                ? (c < 120123
                  ? (c < 120094
                    ? (c >= 120086 && c <= 120092)
                    : c <= 120121)
                  : (c <= 120126 || (c >= 120128 && c <= 120132)))
                : (c <= 120134 || (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c >= 120514 && c <= 120538)))))))
            : (c <= 120570 || (c < 123191
              ? (c < 120714
                ? (c < 120630
                  ? (c < 120598
                    ? (c >= 120572 && c <= 120596)
                    : c <= 120628)
                  : (c <= 120654 || (c < 120688
                    ? (c >= 120656 && c <= 120686)
                    : c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_5(int32_t c) {
  return (c < 43494
    ? (c < 4186
      ? (c < 2703
        ? (c < 1969
          ? (c < 908
            ? (c < 710
              ? (c < 181
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 't' || (c < 170
                    ? (c >= 'v' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))))
              : (c <= 721 || (c < 886
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c >= 880 && c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c >= 904 && c <= 906)))))))
            : (c <= 908 || (c < 1646
              ? (c < 1369
                ? (c < 1015
                  ? (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)
                  : (c <= 1153 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))
                : (c <= 1369 || (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))))
              : (c <= 1647 || (c < 1786
                ? (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))
                : (c <= 1788 || (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))))))))
          : (c <= 1969 || (c < 2474
            ? (c < 2185
              ? (c < 2084
                ? (c < 2042
                  ? (c < 2036
                    ? (c >= 1994 && c <= 2026)
                    : c <= 2037)
                  : (c <= 2042 || (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)))
                : (c <= 2084 || (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))))
              : (c <= 2190 || (c < 2392
                ? (c < 2365
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))))
            : (c <= 2480 || (c < 2575
              ? (c < 2524
                ? (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))))
              : (c <= 2576 || (c < 2616
                ? (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))
                : (c <= 2617 || (c < 2674
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2676 || (c >= 2693 && c <= 2701)))))))))))
        : (c <= 2705 || (c < 3218
          ? (c < 2958
            ? (c < 2835
              ? (c < 2768
                ? (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)))
                : (c <= 2768 || (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))))
              : (c <= 2856 || (c < 2908
                ? (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || c == 2877))
                : (c <= 2909 || (c < 2947
                  ? (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)
                  : (c <= 2947 || (c >= 2949 && c <= 2954)))))))
            : (c <= 2960 || (c < 3086
              ? (c < 2979
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c >= 2974 && c <= 2975)))
                : (c <= 2980 || (c < 3024
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))))
              : (c <= 3088 || (c < 3165
                ? (c < 3133
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))
                : (c <= 3165 || (c < 3205
                  ? (c < 3200
                    ? (c >= 3168 && c <= 3169)
                    : c <= 3200)
                  : (c <= 3212 || (c >= 3214 && c <= 3216)))))))))
          : (c <= 3240 || (c < 3634
            ? (c < 3406
              ? (c < 3313
                ? (c < 3261
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3261 || (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)))
                : (c <= 3314 || (c < 3346
                  ? (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3386 || c == 3389))))
              : (c <= 3406 || (c < 3482
                ? (c < 3450
                  ? (c < 3423
                    ? (c >= 3412 && c <= 3414)
                    : c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c >= 3585 && c <= 3632)))))))
            : (c <= 3634 || (c < 3776
              ? (c < 3724
                ? (c < 3716
                  ? (c < 3713
                    ? (c >= 3648 && c <= 3654)
                    : c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3762
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3760)
                  : (c <= 3762 || c == 3773))))
              : (c <= 3780 || (c < 3913
                ? (c < 3840
                  ? (c < 3804
                    ? c == 3782
                    : c <= 3807)
                  : (c <= 3840 || (c >= 3904 && c <= 3911)))
                : (c <= 3948 || (c < 4159
                  ? (c < 4096
                    ? (c >= 3976 && c <= 3980)
                    : c <= 4138)
                  : (c <= 4159 || (c >= 4176 && c <= 4181)))))))))))))
      : (c <= 4189 || (c < 8130
        ? (c < 6108
          ? (c < 4802
            ? (c < 4682
              ? (c < 4256
                ? (c < 4206
                  ? (c < 4197
                    ? c == 4193
                    : c <= 4198)
                  : (c <= 4208 || (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))))
              : (c <= 4685 || (c < 4746
                ? (c < 4698
                  ? (c < 4696
                    ? (c >= 4688 && c <= 4694)
                    : c <= 4696)
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4792
                  ? (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)
                  : (c <= 4798 || c == 4800))))))
            : (c <= 4805 || (c < 5761
              ? (c < 4992
                ? (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c >= 4888 && c <= 4954)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))))
              : (c <= 5786 || (c < 5952
                ? (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))))))))
          : (c <= 6108 || (c < 7296
            ? (c < 6688
              ? (c < 6480
                ? (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c >= 6656 && c <= 6678)))))
              : (c <= 6740 || (c < 7086
                ? (c < 6981
                  ? (c < 6917
                    ? c == 6823
                    : c <= 6963)
                  : (c <= 6988 || (c >= 7043 && c <= 7072)))
                : (c <= 7087 || (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))))))
            : (c <= 7304 || (c < 7968
              ? (c < 7413
                ? (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))
                : (c <= 7414 || (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))))
              : (c <= 8005 || (c < 8029
                ? (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))
                : (c <= 8029 || (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || c == 8126))))))))))
        : (c <= 8132 || (c < 12321
          ? (c < 8526
            ? (c < 8455
              ? (c < 8182
                ? (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))
                : (c <= 8188 || (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || c == 8450))))
              : (c <= 8455 || (c < 8486
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || c == 8484))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))))))
            : (c <= 8526 || (c < 11648
              ? (c < 11520
                ? (c < 11499
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || c == 11631))))
              : (c <= 11670 || (c < 11712
                ? (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c >= 12293 && c <= 12295)))))))))
          : (c <= 12329 || (c < 42786
            ? (c < 13312
              ? (c < 12540
                ? (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))
                : (c <= 12543 || (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))))
              : (c <= 19903 || (c < 42538
                ? (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c >= 42512 && c <= 42527)))
                : (c <= 42539 || (c < 42656
                  ? (c < 42623
                    ? (c >= 42560 && c <= 42606)
                    : c <= 42653)
                  : (c <= 42735 || (c >= 42775 && c <= 42783)))))))
            : (c <= 42888 || (c < 43138
              ? (c < 42994
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c >= 42965 && c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c >= 43072 && c <= 43123)))))
              : (c <= 43187 || (c < 43312
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43250 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))
                : (c <= 43334 || (c < 43471
                  ? (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)
                  : (c <= 43471 || (c >= 43488 && c <= 43492)))))))))))))))
    : (c <= 43503 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43824
            ? (c < 43712
              ? (c < 43642
                ? (c < 43584
                  ? (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)
                  : (c <= 43586 || (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)))
                : (c <= 43642 || (c < 43701
                  ? (c < 43697
                    ? (c >= 43646 && c <= 43695)
                    : c <= 43697)
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))))
              : (c <= 43712 || (c < 43777
                ? (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c >= 43816 && c <= 43822)))))))
            : (c <= 43866 || (c < 64287
              ? (c < 63744
                ? (c < 44032
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_6(int32_t c) {
  return (c < 43520
    ? (c < 4206
      ? (c < 2738
        ? (c < 2042
          ? (c < 1162
            ? (c < 880
              ? (c < 248
                ? (c < 186
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))
                : (c <= 705 || (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || c == 750))))
              : (c <= 884 || (c < 904
                ? (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 931
                  ? (c < 910
                    ? c == 908
                    : c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))))))
            : (c <= 1327 || (c < 1765
              ? (c < 1519
                ? (c < 1376
                  ? (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)
                  : (c <= 1416 || (c >= 1488 && c <= 1514)))
                : (c <= 1522 || (c < 1649
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1610)
                    : c <= 1647)
                  : (c <= 1747 || c == 1749))))
              : (c <= 1766 || (c < 1810
                ? (c < 1791
                  ? (c < 1786
                    ? (c >= 1774 && c <= 1775)
                    : c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1994
                  ? (c < 1969
                    ? (c >= 1869 && c <= 1957)
                    : c <= 1969)
                  : (c <= 2026 || (c >= 2036 && c <= 2037)))))))))
          : (c <= 2042 || (c < 2493
            ? (c < 2365
              ? (c < 2144
                ? (c < 2084
                  ? (c < 2074
                    ? (c >= 2048 && c <= 2069)
                    : c <= 2074)
                  : (c <= 2084 || (c < 2112
                    ? c == 2088
                    : c <= 2136)))
                : (c <= 2154 || (c < 2208
                  ? (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)
                  : (c <= 2249 || (c >= 2308 && c <= 2361)))))
              : (c <= 2365 || (c < 2447
                ? (c < 2417
                  ? (c < 2392
                    ? c == 2384
                    : c <= 2401)
                  : (c <= 2432 || (c >= 2437 && c <= 2444)))
                : (c <= 2448 || (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))))))
            : (c <= 2493 || (c < 2610
              ? (c < 2556
                ? (c < 2527
                  ? (c < 2524
                    ? c == 2510
                    : c <= 2525)
                  : (c <= 2529 || (c >= 2544 && c <= 2545)))
                : (c <= 2556 || (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c >= 2602 && c <= 2608)))))
              : (c <= 2611 || (c < 2674
                ? (c < 2649
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2652 || c == 2654))
                : (c <= 2676 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))))))))))
        : (c <= 2739 || (c < 3261
          ? (c < 2972
            ? (c < 2869
              ? (c < 2821
                ? (c < 2768
                  ? (c < 2749
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2749)
                  : (c <= 2768 || (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)))
                : (c <= 2828 || (c < 2858
                  ? (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)
                  : (c <= 2864 || (c >= 2866 && c <= 2867)))))
              : (c <= 2873 || (c < 2947
                ? (c < 2911
                  ? (c < 2908
                    ? c == 2877
                    : c <= 2909)
                  : (c <= 2913 || c == 2929))
                : (c <= 2947 || (c < 2962
                  ? (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)
                  : (c <= 2965 || (c >= 2969 && c <= 2970)))))))
            : (c <= 2972 || (c < 3133
              ? (c < 3024
                ? (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))
                : (c <= 3024 || (c < 3090
                  ? (c < 3086
                    ? (c >= 3077 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c >= 3114 && c <= 3129)))))
              : (c <= 3133 || (c < 3205
                ? (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3169 || c == 3200))
                : (c <= 3212 || (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))))))))
          : (c <= 3261 || (c < 3716
            ? (c < 3450
              ? (c < 3346
                ? (c < 3313
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3297)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3332 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3386 || (c < 3412
                  ? (c < 3406
                    ? c == 3389
                    : c <= 3406)
                  : (c <= 3414 || (c >= 3423 && c <= 3425)))))
              : (c <= 3455 || (c < 3520
                ? (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || c == 3517))
                : (c <= 3526 || (c < 3648
                  ? (c < 3634
                    ? (c >= 3585 && c <= 3632)
                    : c <= 3634)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))))))
            : (c <= 3716 || (c < 3840
              ? (c < 3762
                ? (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))
                : (c <= 3762 || (c < 3782
                  ? (c < 3776
                    ? c == 3773
                    : c <= 3780)
                  : (c <= 3782 || (c >= 3804 && c <= 3807)))))
              : (c <= 3840 || (c < 4159
                ? (c < 3976
                  ? (c < 3913
                    ? (c >= 3904 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3980 || (c >= 4096 && c <= 4138)))
                : (c <= 4159 || (c < 4193
                  ? (c < 4186
                    ? (c >= 4176 && c <= 4181)
                    : c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))))))))))))
      : (c <= 4208 || (c < 8150
        ? (c < 6314
          ? (c < 4882
            ? (c < 4698
              ? (c < 4304
                ? (c < 4256
                  ? (c < 4238
                    ? (c >= 4213 && c <= 4225)
                    : c <= 4238)
                  : (c <= 4293 || (c < 4301
                    ? c == 4295
                    : c <= 4301)))
                : (c <= 4346 || (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || c == 4696))))
              : (c <= 4701 || (c < 4792
                ? (c < 4752
                  ? (c < 4746
                    ? (c >= 4704 && c <= 4744)
                    : c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c >= 4824 && c <= 4880)))))))
            : (c <= 4885 || (c < 5888
              ? (c < 5121
                ? (c < 5024
                  ? (c < 4992
                    ? (c >= 4888 && c <= 4954)
                    : c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c >= 5870 && c <= 5880)))))
              : (c <= 5905 || (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5937)
                    : c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6176
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6108)
                  : (c <= 6264 || (c >= 6272 && c <= 6312)))))))))
          : (c <= 6314 || (c < 7401
            ? (c < 6981
              ? (c < 6576
                ? (c < 6480
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6823
                  ? (c < 6688
                    ? (c >= 6656 && c <= 6678)
                    : c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))))
              : (c <= 6988 || (c < 7245
                ? (c < 7098
                  ? (c < 7086
                    ? (c >= 7043 && c <= 7072)
                    : c <= 7087)
                  : (c <= 7141 || (c >= 7168 && c <= 7203)))
                : (c <= 7247 || (c < 7312
                  ? (c < 7296
                    ? (c >= 7258 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))))))
            : (c <= 7404 || (c < 8025
              ? (c < 7680
                ? (c < 7418
                  ? (c < 7413
                    ? (c >= 7406 && c <= 7411)
                    : c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))))
              : (c <= 8025 || (c < 8118
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c >= 8064 && c <= 8116)))
                : (c <= 8124 || (c < 8134
                  ? (c < 8130
                    ? c == 8126
                    : c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))))))))))
        : (c <= 8155 || (c < 12353
          ? (c < 11499
            ? (c < 8472
              ? (c < 8336
                ? (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8458
                  ? (c < 8455
                    ? c == 8450
                    : c <= 8455)
                  : (c <= 8467 || c == 8469))))
              : (c <= 8477 || (c < 8508
                ? (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c >= 8490 && c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c >= 11264 && c <= 11492)))))))
            : (c <= 11502 || (c < 11696
              ? (c < 11568
                ? (c < 11559
                  ? (c < 11520
                    ? (c >= 11506 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || c == 11565))
                : (c <= 11623 || (c < 11680
                  ? (c < 11648
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))))
              : (c <= 11702 || (c < 11736
                ? (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))
                : (c <= 11742 || (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c >= 12344 && c <= 12348)))))))))
          : (c <= 12438 || (c < 42960
            ? (c < 42192
              ? (c < 12593
                ? (c < 12540
                  ? (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)
                  : (c <= 12543 || (c >= 12549 && c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c >= 19968 && c <= 42124)))))
              : (c <= 42237 || (c < 42623
                ? (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42954)))))))
            : (c <= 42961 || (c < 43259
              ? (c < 43015
                ? (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43138
                  ? (c < 43072
                    ? (c >= 43020 && c <= 43042)
                    : c <= 43123)
                  : (c <= 43187 || (c >= 43250 && c <= 43255)))))
              : (c <= 43259 || (c < 43396
                ? (c < 43312
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43494
                  ? (c < 43488
                    ? c == 43471
                    : c <= 43492)
                  : (c <= 43503 || (c >= 43514 && c <= 43518)))))))))))))))
    : (c <= 43560 || (c < 70751
      ? (c < 66964
        ? (c < 65008
          ? (c < 43888
            ? (c < 43739
              ? (c < 43697
                ? (c < 43616
                  ? (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)
                  : (c <= 43638 || (c < 43646
                    ? c == 43642
                    : c <= 43695)))
                : (c <= 43697 || (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))))
              : (c <= 43741 || (c < 43793
                ? (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))))))
            : (c <= 44002 || (c < 64298
              ? (c < 64112
                ? (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))))
              : (c <= 64310 || (c < 64326
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))))))))
          : (c <= 65017 || (c < 65616
            ? (c < 65440
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))))
              : (c <= 65470 || (c < 65536
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))))))
            : (c <= 65629 || (c < 66504
              ? (c < 66304
                ? (c < 66176
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66421)
                  : (c <= 66461 || (c >= 66464 && c <= 66499)))))
              : (c <= 66511 || (c < 66816
                ? (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c >= 66776 && c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))))))))))
        : (c <= 66965 || (c < 69248
          ? (c < 67840
            ? (c < 67584
              ? (c < 67392
                ? (c < 66995
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)
                  : (c <= 67001 || (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)))
                : (c <= 67413 || (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c >= 67506 && c <= 67514)))))
              : (c <= 67589 || (c < 67647
                ? (c < 67639
                  ? (c < 67594
                    ? c == 67592
                    : c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67808
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)
                  : (c <= 67826 || (c >= 67828 && c <= 67829)))))))
            : (c <= 67861 || (c < 68288
              ? (c < 68112
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || c == 68096))
                : (c <= 68115 || (c < 68192
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68220 || (c >= 68224 && c <= 68252)))))
              : (c <= 68295 || (c < 68480
                ? (c < 68416
                  ? (c < 68352
                    ? (c >= 68297 && c <= 68324)
                    : c <= 68405)
                  : (c <= 68437 || (c >= 68448 && c <= 68466)))
                : (c <= 68497 || (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c >= 68864 && c <= 68899)))))))))
          : (c <= 69289 || (c < 70108
            ? (c < 69763
              ? (c < 69552
                ? (c < 69415
                  ? (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)
                  : (c <= 69415 || (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)))
                : (c <= 69572 || (c < 69745
                  ? (c < 69635
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69687)
                  : (c <= 69746 || c == 69749))))
              : (c <= 69807 || (c < 69968
                ? (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))
                : (c <= 70002 || (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))))))
            : (c <= 70108 || (c < 70415
              ? (c < 70282
                ? (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))
                : (c <= 70285 || (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))))
              : (c <= 70416 || (c < 70461
                ? (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c >= 70453 && c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c >= 70727 && c <= 70730)))))))))))))
      : (c <= 70753 || (c < 119966
        ? (c < 73063
          ? (c < 72096
            ? (c < 71488
              ? (c < 71168
                ? (c < 70855
                  ? (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)
                  : (c <= 70855 || (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)))
                : (c <= 71215 || (c < 71352
                  ? (c < 71296
                    ? c == 71236
                    : c <= 71338)
                  : (c <= 71352 || (c >= 71424 && c <= 71450)))))
              : (c <= 71494 || (c < 71948
                ? (c < 71935
                  ? (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)
                  : (c <= 71942 || c == 71945))
                : (c <= 71955 || (c < 71999
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71983)
                  : (c <= 71999 || c == 72001))))))
            : (c <= 72103 || (c < 72368
              ? (c < 72203
                ? (c < 72163
                  ? (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)
                  : (c <= 72163 || c == 72192))
                : (c <= 72242 || (c < 72284
                  ? (c < 72272
                    ? c == 72250
                    : c <= 72272)
                  : (c <= 72329 || c == 72349))))
              : (c <= 72440 || (c < 72960
                ? (c < 72768
                  ? (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72750)
                  : (c <= 72768 || (c >= 72818 && c <= 72847)))
                : (c <= 72966 || (c < 73030
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)
                  : (c <= 73030 || (c >= 73056 && c <= 73061)))))))))
          : (c <= 73064 || (c < 94032
            ? (c < 92160
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73112
                    ? (c >= 73066 && c <= 73097)
                    : c <= 73112)
                  : (c <= 73458 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 77824
                  ? (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)
                  : (c <= 78894 || (c >= 82944 && c <= 83526)))))
              : (c <= 92728 || (c < 92992
                ? (c < 92880
                  ? (c < 92784
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92862)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))
                : (c <= 92995 || (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))))))
            : (c <= 94032 || (c < 110592
              ? (c < 100352
                ? (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))
                : (c <= 101589 || (c < 110581
                  ? (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)
                  : (c <= 110587 || (c >= 110589 && c <= 110590)))))
              : (c <= 110882 || (c < 113776
                ? (c < 110960
                  ? (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)
                  : (c <= 111355 || (c >= 113664 && c <= 113770)))
                : (c <= 113788 || (c < 119808
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 119892 || (c >= 119894 && c <= 119964)))))))))))
        : (c <= 119967 || (c < 126464
          ? (c < 120598
            ? (c < 120094
              ? (c < 119997
                ? (c < 119977
                  ? (c < 119973
                    ? c == 119970
                    : c <= 119974)
                  : (c <= 119980 || (c < 119995
                    ? (c >= 119982 && c <= 119993)
                    : c <= 119995)))
                : (c <= 120003 || (c < 120077
                  ? (c < 120071
                    ? (c >= 120005 && c <= 120069)
                    : c <= 120074)
                  : (c <= 120084 || (c >= 120086 && c <= 120092)))))
              : (c <= 120121 || (c < 120146
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c >= 120138 && c <= 120144)))
                : (c <= 120485 || (c < 120540
                  ? (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)
                  : (c <= 120570 || (c >= 120572 && c <= 120596)))))))
            : (c <= 120628 || (c < 123214
              ? (c < 120746
                ? (c < 120688
                  ? (c < 120656
                    ? (c >= 120630 && c <= 120654)
                    : c <= 120686)
                  : (c <= 120712 || (c >= 120714 && c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c >= 123191 && c <= 123197)))))
              : (c <= 123214 || (c < 124909
                ? (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123565)
                    : c <= 123627)
                  : (c <= 124902 || (c >= 124904 && c <= 124907)))
                : (c <= 124910 || (c < 125184
                  ? (c < 124928
                    ? (c >= 124912 && c <= 124926)
                    : c <= 125124)
                  : (c <= 125251 || c == 125259))))))))
          : (c <= 126467 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126500
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)
                  : (c <= 126500 || c == 126503))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_7(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'v'
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 't')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_8(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_9(int32_t c) {
  return (c < 43471
    ? (c < 3976
      ? (c < 2616
        ? (c < 1786
          ? (c < 886
            ? (c < 181
              ? (c < 'o'
                ? (c < 'e'
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'a')
                  : (c <= 'e' || (c < 'j'
                    ? (c >= 'g' && c <= 'h')
                    : c <= 'l')))
                : (c <= 'o' || (c < 'w'
                  ? (c < 't'
                    ? (c >= 'q' && c <= 'r')
                    : c <= 't')
                  : (c <= 'z' || c == 170))))
              : (c <= 181 || (c < 710
                ? (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c >= 880 && c <= 884)))))))
            : (c <= 887 || (c < 1369
              ? (c < 910
                ? (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 902 || (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)))
                : (c <= 929 || (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))))
              : (c <= 1369 || (c < 1646
                ? (c < 1519
                  ? (c < 1488
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1765
                  ? (c < 1749
                    ? (c >= 1649 && c <= 1747)
                    : c <= 1749)
                  : (c <= 1766 || (c >= 1774 && c <= 1775)))))))))
          : (c <= 1788 || (c < 2392
            ? (c < 2084
              ? (c < 1994
                ? (c < 1810
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1808)
                  : (c <= 1839 || (c < 1969
                    ? (c >= 1869 && c <= 1957)
                    : c <= 1969)))
                : (c <= 2026 || (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || c == 2074))))
              : (c <= 2084 || (c < 2185
                ? (c < 2144
                  ? (c < 2112
                    ? c == 2088
                    : c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))
                : (c <= 2190 || (c < 2365
                  ? (c < 2308
                    ? (c >= 2208 && c <= 2249)
                    : c <= 2361)
                  : (c <= 2365 || c == 2384))))))
            : (c <= 2401 || (c < 2524
              ? (c < 2474
                ? (c < 2447
                  ? (c < 2437
                    ? (c >= 2417 && c <= 2432)
                    : c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))
                : (c <= 2480 || (c < 2493
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2493 || c == 2510))))
              : (c <= 2525 || (c < 2575
                ? (c < 2556
                  ? (c < 2544
                    ? (c >= 2527 && c <= 2529)
                    : c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2610
                  ? (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)
                  : (c <= 2611 || (c >= 2613 && c <= 2614)))))))))))
        : (c <= 2617 || (c < 3168
          ? (c < 2908
            ? (c < 2768
              ? (c < 2707
                ? (c < 2674
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2676 || (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)))
                : (c <= 2728 || (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || c == 2749))))
              : (c <= 2768 || (c < 2835
                ? (c < 2821
                  ? (c < 2809
                    ? (c >= 2784 && c <= 2785)
                    : c <= 2809)
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2869
                  ? (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)
                  : (c <= 2873 || c == 2877))))))
            : (c <= 2909 || (c < 2984
              ? (c < 2962
                ? (c < 2947
                  ? (c < 2929
                    ? (c >= 2911 && c <= 2913)
                    : c <= 2929)
                  : (c <= 2947 || (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)))
                : (c <= 2965 || (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))))
              : (c <= 2986 || (c < 3090
                ? (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))
                : (c <= 3112 || (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))))))))
          : (c <= 3169 || (c < 3507
            ? (c < 3332
              ? (c < 3253
                ? (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))
                : (c <= 3257 || (c < 3296
                  ? (c < 3293
                    ? c == 3261
                    : c <= 3294)
                  : (c <= 3297 || (c >= 3313 && c <= 3314)))))
              : (c <= 3340 || (c < 3412
                ? (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))
                : (c <= 3414 || (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))))))
            : (c <= 3515 || (c < 3749
              ? (c < 3648
                ? (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))
                : (c <= 3654 || (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))))
              : (c <= 3749 || (c < 3782
                ? (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))
                : (c <= 3782 || (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))))))))))))
      : (c <= 3980 || (c < 8064
        ? (c < 5998
          ? (c < 4752
            ? (c < 4295
              ? (c < 4197
                ? (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c < 4193
                    ? (c >= 4186 && c <= 4189)
                    : c <= 4193)))
                : (c <= 4198 || (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c >= 4256 && c <= 4293)))))
              : (c <= 4295 || (c < 4688
                ? (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))))))
            : (c <= 4784 || (c < 5112
              ? (c < 4824
                ? (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)))
                : (c <= 4880 || (c < 4992
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))))
              : (c <= 5117 || (c < 5870
                ? (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))
                : (c <= 5880 || (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5905)
                    : c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))))))))
          : (c <= 6000 || (c < 7168
            ? (c < 6528
              ? (c < 6314
                ? (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : c <= 6103)
                  : (c <= 6108 || (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)))
                : (c <= 6314 || (c < 6480
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6509 || (c >= 6512 && c <= 6516)))))
              : (c <= 6571 || (c < 6917
                ? (c < 6688
                  ? (c < 6656
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6678)
                  : (c <= 6740 || c == 6823))
                : (c <= 6963 || (c < 7086
                  ? (c < 7043
                    ? (c >= 6981 && c <= 6988)
                    : c <= 7072)
                  : (c <= 7087 || (c >= 7098 && c <= 7141)))))))
            : (c <= 7203 || (c < 7424
              ? (c < 7357
                ? (c < 7296
                  ? (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)
                  : (c <= 7304 || (c >= 7312 && c <= 7354)))
                : (c <= 7359 || (c < 7413
                  ? (c < 7406
                    ? (c >= 7401 && c <= 7404)
                    : c <= 7411)
                  : (c <= 7414 || c == 7418))))
              : (c <= 7615 || (c < 8016
                ? (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c >= 8008 && c <= 8013)))
                : (c <= 8023 || (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c >= 8031 && c <= 8061)))))))))))
        : (c <= 8116 || (c < 11736
          ? (c < 8490
            ? (c < 8319
              ? (c < 8150
                ? (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)))
                : (c <= 8155 || (c < 8182
                  ? (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)
                  : (c <= 8188 || c == 8305))))
              : (c <= 8319 || (c < 8469
                ? (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))
                : (c <= 8469 || (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))))))
            : (c <= 8505 || (c < 11568
              ? (c < 11499
                ? (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))
                : (c <= 11502 || (c < 11559
                  ? (c < 11520
                    ? (c >= 11506 && c <= 11507)
                    : c <= 11557)
                  : (c <= 11559 || c == 11565))))
              : (c <= 11623 || (c < 11696
                ? (c < 11680
                  ? (c < 11648
                    ? c == 11631
                    : c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11720
                  ? (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)
                  : (c <= 11726 || (c >= 11728 && c <= 11734)))))))))
          : (c <= 11742 || (c < 42656
            ? (c < 12704
              ? (c < 12445
                ? (c < 12337
                  ? (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12329)
                  : (c <= 12341 || (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)))
                : (c <= 12447 || (c < 12549
                  ? (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))))
              : (c <= 12735 || (c < 42240
                ? (c < 19968
                  ? (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c < 42538
                    ? (c >= 42512 && c <= 42527)
                    : c <= 42539)
                  : (c <= 42606 || (c >= 42623 && c <= 42653)))))))
            : (c <= 42735 || (c < 43020
              ? (c < 42963
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 43011
                  ? (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))))
              : (c <= 43042 || (c < 43261
                ? (c < 43250
                  ? (c < 43138
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43187)
                  : (c <= 43255 || c == 43259))
                : (c <= 43262 || (c < 43360
                  ? (c < 43312
                    ? (c >= 43274 && c <= 43301)
                    : c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))))))))))))
    : (c <= 43471 || (c < 70656
      ? (c < 66928
        ? (c < 64612
          ? (c < 43808
            ? (c < 43701
              ? (c < 43588
                ? (c < 43514
                  ? (c < 43494
                    ? (c >= 43488 && c <= 43492)
                    : c <= 43503)
                  : (c <= 43518 || (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)))
                : (c <= 43595 || (c < 43646
                  ? (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)
                  : (c <= 43695 || c == 43697))))
              : (c <= 43702 || (c < 43744
                ? (c < 43714
                  ? (c < 43712
                    ? (c >= 43705 && c <= 43709)
                    : c <= 43712)
                  : (c <= 43714 || (c >= 43739 && c <= 43741)))
                : (c <= 43754 || (c < 43785
                  ? (c < 43777
                    ? (c >= 43762 && c <= 43764)
                    : c <= 43782)
                  : (c <= 43790 || (c >= 43793 && c <= 43798)))))))
            : (c <= 43814 || (c < 64275
              ? (c < 55216
                ? (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)))
                : (c <= 55238 || (c < 64112
                  ? (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))))
              : (c <= 64279 || (c < 64318
                ? (c < 64298
                  ? (c < 64287
                    ? c == 64285
                    : c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c >= 64467 && c <= 64605)))))))))
          : (c <= 64829 || (c < 65576
            ? (c < 65313
              ? (c < 65143
                ? (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65139
                    ? c == 65137
                    : c <= 65139)))
                : (c <= 65143 || (c < 65149
                  ? (c < 65147
                    ? c == 65145
                    : c <= 65147)
                  : (c <= 65149 || (c >= 65151 && c <= 65276)))))
              : (c <= 65338 || (c < 65482
                ? (c < 65440
                  ? (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65437)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65536
                  ? (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)
                  : (c <= 65547 || (c >= 65549 && c <= 65574)))))))
            : (c <= 65594 || (c < 66384
              ? (c < 65856
                ? (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c >= 65664 && c <= 65786)))
                : (c <= 65908 || (c < 66304
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))))
              : (c <= 66421 || (c < 66560
                ? (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c >= 66513 && c <= 66517)))
                : (c <= 66717 || (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c >= 66864 && c <= 66915)))))))))))
        : (c <= 66938 || (c < 68800
          ? (c < 67712
            ? (c < 67456
              ? (c < 66995
                ? (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))
                : (c <= 67001 || (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c >= 67424 && c <= 67431)))))
              : (c <= 67461 || (c < 67594
                ? (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67647
                  ? (c < 67644
                    ? (c >= 67639 && c <= 67640)
                    : c <= 67644)
                  : (c <= 67669 || (c >= 67680 && c <= 67702)))))))
            : (c <= 67742 || (c < 68192
              ? (c < 68030
                ? (c < 67840
                  ? (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)
                  : (c <= 67861 || (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)))
                : (c <= 68031 || (c < 68117
                  ? (c < 68112
                    ? c == 68096
                    : c <= 68115)
                  : (c <= 68119 || (c >= 68121 && c <= 68149)))))
              : (c <= 68220 || (c < 68416
                ? (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68324 || (c >= 68352 && c <= 68405)))
                : (c <= 68437 || (c < 68608
                  ? (c < 68480
                    ? (c >= 68448 && c <= 68466)
                    : c <= 68497)
                  : (c <= 68680 || (c >= 68736 && c <= 68786)))))))))
          : (c <= 68850 || (c < 70081
            ? (c < 69745
              ? (c < 69424
                ? (c < 69296
                  ? (c < 69248
                    ? (c >= 68864 && c <= 68899)
                    : c <= 69289)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))
                : (c <= 69445 || (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69505)
                    : c <= 69572)
                  : (c <= 69622 || (c >= 69635 && c <= 69687)))))
              : (c <= 69746 || (c < 69956
                ? (c < 69840
                  ? (c < 69763
                    ? c == 69749
                    : c <= 69807)
                  : (c <= 69864 || (c >= 69891 && c <= 69926)))
                : (c <= 69956 || (c < 70006
                  ? (c < 69968
                    ? c == 69959
                    : c <= 70002)
                  : (c <= 70006 || (c >= 70019 && c <= 70066)))))))
            : (c <= 70084 || (c < 70320
              ? (c < 70272
                ? (c < 70144
                  ? (c < 70108
                    ? c == 70106
                    : c <= 70108)
                  : (c <= 70161 || (c >= 70163 && c <= 70187)))
                : (c <= 70278 || (c < 70287
                  ? (c < 70282
                    ? c == 70280
                    : c <= 70285)
                  : (c <= 70301 || (c >= 70303 && c <= 70312)))))
              : (c <= 70366 || (c < 70450
                ? (c < 70419
                  ? (c < 70415
                    ? (c >= 70405 && c <= 70412)
                    : c <= 70416)
                  : (c <= 70440 || (c >= 70442 && c <= 70448)))
                : (c <= 70451 || (c < 70480
                  ? (c < 70461
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70461)
                  : (c <= 70480 || (c >= 70493 && c <= 70497)))))))))))))
      : (c <= 70708 || (c < 119894
        ? (c < 73056
          ? (c < 71999
            ? (c < 71352
              ? (c < 71040
                ? (c < 70784
                  ? (c < 70751
                    ? (c >= 70727 && c <= 70730)
                    : c <= 70753)
                  : (c <= 70831 || (c < 70855
                    ? (c >= 70852 && c <= 70853)
                    : c <= 70855)))
                : (c <= 71086 || (c < 71236
                  ? (c < 71168
                    ? (c >= 71128 && c <= 71131)
                    : c <= 71215)
                  : (c <= 71236 || (c >= 71296 && c <= 71338)))))
              : (c <= 71352 || (c < 71935
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71424 && c <= 71450)
                    : c <= 71494)
                  : (c <= 71723 || (c >= 71840 && c <= 71903)))
                : (c <= 71942 || (c < 71957
                  ? (c < 71948
                    ? c == 71945
                    : c <= 71955)
                  : (c <= 71958 || (c >= 71960 && c <= 71983)))))))
            : (c <= 71999 || (c < 72349
              ? (c < 72192
                ? (c < 72106
                  ? (c < 72096
                    ? c == 72001
                    : c <= 72103)
                  : (c <= 72144 || (c < 72163
                    ? c == 72161
                    : c <= 72163)))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_10(int32_t c) {
  return (c < 43494
    ? (c < 4176
      ? (c < 2693
        ? (c < 1869
          ? (c < 904
            ? (c < 248
              ? (c < 170
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'e' || (c < 'u'
                    ? (c >= 'g' && c <= 's')
                    : c <= 'z')))
                : (c <= 170 || (c < 192
                  ? (c < 186
                    ? c == 181
                    : c <= 186)
                  : (c <= 214 || (c >= 216 && c <= 246)))))
              : (c <= 705 || (c < 880
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || c == 750))
                : (c <= 884 || (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || c == 902))))))
            : (c <= 906 || (c < 1568
              ? (c < 1329
                ? (c < 931
                  ? (c < 910
                    ? c == 908
                    : c <= 929)
                  : (c <= 1013 || (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)))
                : (c <= 1366 || (c < 1488
                  ? (c < 1376
                    ? c == 1369
                    : c <= 1416)
                  : (c <= 1514 || (c >= 1519 && c <= 1522)))))
              : (c <= 1610 || (c < 1774
                ? (c < 1749
                  ? (c < 1649
                    ? (c >= 1646 && c <= 1647)
                    : c <= 1747)
                  : (c <= 1749 || (c >= 1765 && c <= 1766)))
                : (c <= 1775 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1786 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1808 || (c >= 1810 && c <= 1839)))))))))
          : (c <= 1957 || (c < 2451
            ? (c < 2160
              ? (c < 2074
                ? (c < 2036
                  ? (c < 1994
                    ? c == 1969
                    : c <= 2026)
                  : (c <= 2037 || (c < 2048
                    ? c == 2042
                    : c <= 2069)))
                : (c <= 2074 || (c < 2112
                  ? (c < 2088
                    ? c == 2084
                    : c <= 2088)
                  : (c <= 2136 || (c >= 2144 && c <= 2154)))))
              : (c <= 2183 || (c < 2384
                ? (c < 2308
                  ? (c < 2208
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2249)
                  : (c <= 2361 || c == 2365))
                : (c <= 2384 || (c < 2437
                  ? (c < 2417
                    ? (c >= 2392 && c <= 2401)
                    : c <= 2432)
                  : (c <= 2444 || (c >= 2447 && c <= 2448)))))))
            : (c <= 2472 || (c < 2565
              ? (c < 2510
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2544
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2529)
                  : (c <= 2545 || c == 2556))))
              : (c <= 2570 || (c < 2613
                ? (c < 2602
                  ? (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)
                  : (c <= 2608 || (c >= 2610 && c <= 2611)))
                : (c <= 2614 || (c < 2654
                  ? (c < 2649
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2652)
                  : (c <= 2654 || (c >= 2674 && c <= 2676)))))))))))
        : (c <= 2701 || (c < 3214
          ? (c < 2949
            ? (c < 2831
              ? (c < 2749
                ? (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))
                : (c <= 2749 || (c < 2809
                  ? (c < 2784
                    ? c == 2768
                    : c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))))
              : (c <= 2832 || (c < 2877
                ? (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c >= 2869 && c <= 2873)))
                : (c <= 2877 || (c < 2929
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2913)
                  : (c <= 2929 || c == 2947))))))
            : (c <= 2954 || (c < 3077
              ? (c < 2974
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || c == 2972))
                : (c <= 2975 || (c < 2990
                  ? (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)
                  : (c <= 3001 || c == 3024))))
              : (c <= 3084 || (c < 3160
                ? (c < 3114
                  ? (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)
                  : (c <= 3129 || c == 3133))
                : (c <= 3162 || (c < 3200
                  ? (c < 3168
                    ? c == 3165
                    : c <= 3169)
                  : (c <= 3200 || (c >= 3205 && c <= 3212)))))))))
          : (c <= 3216 || (c < 3585
            ? (c < 3389
              ? (c < 3296
                ? (c < 3253
                  ? (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)
                  : (c <= 3257 || (c < 3293
                    ? c == 3261
                    : c <= 3294)))
                : (c <= 3297 || (c < 3342
                  ? (c < 3332
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)
                  : (c <= 3344 || (c >= 3346 && c <= 3386)))))
              : (c <= 3389 || (c < 3461
                ? (c < 3423
                  ? (c < 3412
                    ? c == 3406
                    : c <= 3414)
                  : (c <= 3425 || (c >= 3450 && c <= 3455)))
                : (c <= 3478 || (c < 3517
                  ? (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)
                  : (c <= 3517 || (c >= 3520 && c <= 3526)))))))
            : (c <= 3632 || (c < 3773
              ? (c < 3718
                ? (c < 3713
                  ? (c < 3648
                    ? c == 3634
                    : c <= 3654)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3760 || c == 3762))))
              : (c <= 3773 || (c < 3904
                ? (c < 3804
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3807 || c == 3840))
                : (c <= 3911 || (c < 4096
                  ? (c < 3976
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3980)
                  : (c <= 4138 || c == 4159))))))))))))
      : (c <= 4181 || (c < 8130
        ? (c < 6108
          ? (c < 4800
            ? (c < 4348
              ? (c < 4238
                ? (c < 4197
                  ? (c < 4193
                    ? (c >= 4186 && c <= 4189)
                    : c <= 4193)
                  : (c <= 4198 || (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)))
                : (c <= 4238 || (c < 4301
                  ? (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))))
              : (c <= 4680 || (c < 4704
                ? (c < 4696
                  ? (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)
                  : (c <= 4696 || (c >= 4698 && c <= 4701)))
                : (c <= 4744 || (c < 4786
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)
                  : (c <= 4789 || (c >= 4792 && c <= 4798)))))))
            : (c <= 4800 || (c < 5761
              ? (c < 4992
                ? (c < 4824
                  ? (c < 4808
                    ? (c >= 4802 && c <= 4805)
                    : c <= 4822)
                  : (c <= 4880 || (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)))
                : (c <= 5007 || (c < 5121
                  ? (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))))
              : (c <= 5786 || (c < 5952
                ? (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 6016
                  ? (c < 5998
                    ? (c >= 5984 && c <= 5996)
                    : c <= 6000)
                  : (c <= 6067 || c == 6103))))))))
          : (c <= 6108 || (c < 7296
            ? (c < 6688
              ? (c < 6480
                ? (c < 6314
                  ? (c < 6272
                    ? (c >= 6176 && c <= 6264)
                    : c <= 6312)
                  : (c <= 6314 || (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c >= 6656 && c <= 6678)))))
              : (c <= 6740 || (c < 7086
                ? (c < 6981
                  ? (c < 6917
                    ? c == 6823
                    : c <= 6963)
                  : (c <= 6988 || (c >= 7043 && c <= 7072)))
                : (c <= 7087 || (c < 7245
                  ? (c < 7168
                    ? (c >= 7098 && c <= 7141)
                    : c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))))))
            : (c <= 7304 || (c < 7968
              ? (c < 7413
                ? (c < 7401
                  ? (c < 7357
                    ? (c >= 7312 && c <= 7354)
                    : c <= 7359)
                  : (c <= 7404 || (c >= 7406 && c <= 7411)))
                : (c <= 7414 || (c < 7680
                  ? (c < 7424
                    ? c == 7418
                    : c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))))
              : (c <= 8005 || (c < 8029
                ? (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))
                : (c <= 8029 || (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || c == 8126))))))))))
        : (c <= 8132 || (c < 12321
          ? (c < 8526
            ? (c < 8455
              ? (c < 8182
                ? (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))
                : (c <= 8188 || (c < 8336
                  ? (c < 8319
                    ? c == 8305
                    : c <= 8319)
                  : (c <= 8348 || c == 8450))))
              : (c <= 8455 || (c < 8486
                ? (c < 8472
                  ? (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)
                  : (c <= 8477 || c == 8484))
                : (c <= 8486 || (c < 8508
                  ? (c < 8490
                    ? c == 8488
                    : c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))))))
            : (c <= 8526 || (c < 11648
              ? (c < 11520
                ? (c < 11499
                  ? (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || c == 11631))))
              : (c <= 11670 || (c < 11712
                ? (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11736
                  ? (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)
                  : (c <= 11742 || (c >= 12293 && c <= 12295)))))))))
          : (c <= 12329 || (c < 42786
            ? (c < 13312
              ? (c < 12540
                ? (c < 12353
                  ? (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)
                  : (c <= 12438 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))
                : (c <= 12543 || (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c >= 12784 && c <= 12799)))))
              : (c <= 19903 || (c < 42538
                ? (c < 42240
                  ? (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)
                  : (c <= 42508 || (c >= 42512 && c <= 42527)))
                : (c <= 42539 || (c < 42656
                  ? (c < 42623
                    ? (c >= 42560 && c <= 42606)
                    : c <= 42653)
                  : (c <= 42735 || (c >= 42775 && c <= 42783)))))))
            : (c <= 42888 || (c < 43138
              ? (c < 42994
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c >= 42965 && c <= 42969)))
                : (c <= 43009 || (c < 43020
                  ? (c < 43015
                    ? (c >= 43011 && c <= 43013)
                    : c <= 43018)
                  : (c <= 43042 || (c >= 43072 && c <= 43123)))))
              : (c <= 43187 || (c < 43312
                ? (c < 43261
                  ? (c < 43259
                    ? (c >= 43250 && c <= 43255)
                    : c <= 43259)
                  : (c <= 43262 || (c >= 43274 && c <= 43301)))
                : (c <= 43334 || (c < 43471
                  ? (c < 43396
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43442)
                  : (c <= 43471 || (c >= 43488 && c <= 43492)))))))))))))))
    : (c <= 43503 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43824
            ? (c < 43712
              ? (c < 43642
                ? (c < 43584
                  ? (c < 43520
                    ? (c >= 43514 && c <= 43518)
                    : c <= 43560)
                  : (c <= 43586 || (c < 43616
                    ? (c >= 43588 && c <= 43595)
                    : c <= 43638)))
                : (c <= 43642 || (c < 43701
                  ? (c < 43697
                    ? (c >= 43646 && c <= 43695)
                    : c <= 43697)
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))))
              : (c <= 43712 || (c < 43777
                ? (c < 43744
                  ? (c < 43739
                    ? c == 43714
                    : c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43808
                  ? (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)
                  : (c <= 43814 || (c >= 43816 && c <= 43822)))))))
            : (c <= 43866 || (c < 64287
              ? (c < 63744
                ? (c < 44032
                  ? (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44002)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_11(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_12(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'B'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_13(int32_t c) {
  return (c < 43642
    ? (c < 3784
      ? (c < 2759
        ? (c < 2048
          ? (c < 1155
            ? (c < 736
              ? (c < 183
                ? (c < 'a'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 183 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)))))
              : (c <= 740 || (c < 895
                ? (c < 768
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 910
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)))))))
            : (c <= 1159 || (c < 1552
              ? (c < 1471
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)))
                : (c <= 1471 || (c < 1479
                  ? (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)
                  : (c <= 1479 || (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)))))
              : (c <= 1562 || (c < 1791
                ? (c < 1749
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)
                  : (c <= 1756 || (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)))
                : (c <= 1791 || (c < 1984
                  ? (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)
                  : (c <= 2037 || (c < 2045
                    ? c == 2042
                    : c <= 2045)))))))))
          : (c <= 2093 || (c < 2561
            ? (c < 2474
              ? (c < 2275
                ? (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)
                  : (c <= 2183 || (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)))
                : (c <= 2403 || (c < 2437
                  ? (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)))))
              : (c <= 2480 || (c < 2519
                ? (c < 2492
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2500 || (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)))
                : (c <= 2519 || (c < 2534
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)
                  : (c <= 2545 || (c < 2558
                    ? c == 2556
                    : c <= 2558)))))))
            : (c <= 2563 || (c < 2641
              ? (c < 2613
                ? (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))
                : (c <= 2614 || (c < 2622
                  ? (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)
                  : (c <= 2626 || (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)))))
              : (c <= 2641 || (c < 2703
                ? (c < 2662
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2677 || (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))))))))
        : (c <= 2761 || (c < 3174
          ? (c < 2962
            ? (c < 2869
              ? (c < 2817
                ? (c < 2784
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)
                  : (c <= 2787 || (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)))
                : (c <= 2819 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)))))
              : (c <= 2873 || (c < 2911
                ? (c < 2891
                  ? (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)
                  : (c <= 2893 || (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)))
                : (c <= 2915 || (c < 2946
                  ? (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)
                  : (c <= 2947 || (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)))))))
            : (c <= 2965 || (c < 3046
              ? (c < 2990
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)))
                : (c <= 3001 || (c < 3018
                  ? (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))))
              : (c <= 3055 || (c < 3142
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)))
                : (c <= 3144 || (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3171)))))))))
          : (c <= 3183 || (c < 3457
            ? (c < 3296
              ? (c < 3253
                ? (c < 3214
                  ? (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))
                : (c <= 3257 || (c < 3274
                  ? (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)
                  : (c <= 3277 || (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)))))
              : (c <= 3299 || (c < 3398
                ? (c < 3328
                  ? (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)))
                : (c <= 3400 || (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))))))
            : (c <= 3459 || (c < 3585
              ? (c < 3530
                ? (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))
                : (c <= 3530 || (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))))
              : (c <= 3642 || (c < 3724
                ? (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || (c < 3718
                    ? c == 3716
                    : c <= 3722)))
                : (c <= 3747 || (c < 3776
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))))))))))
      : (c <= 3789 || (c < 8027
        ? (c < 5919
          ? (c < 4696
            ? (c < 3974
              ? (c < 3893
                ? (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))
                : (c <= 3893 || (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))))
              : (c <= 3991 || (c < 4295
                ? (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)))))))
            : (c <= 4696 || (c < 4888
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))
              : (c <= 4954 || (c < 5121
                ? (c < 4992
                  ? (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : c <= 4977)
                  : (c <= 5007 || (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)))
                : (c <= 5740 || (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))))))
          : (c <= 5940 || (c < 6752
            ? (c < 6272
              ? (c < 6103
                ? (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)
                  : (c <= 6000 || (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)))
                : (c <= 6103 || (c < 6155
                  ? (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)
                  : (c <= 6157 || (c < 6176
                    ? (c >= 6159 && c <= 6169)
                    : c <= 6264)))))
              : (c <= 6314 || (c < 6512
                ? (c < 6432
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6443 || (c < 6470
                    ? (c >= 6448 && c <= 6459)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6608
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6618 || (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)))))))
            : (c <= 6780 || (c < 7245
              ? (c < 6912
                ? (c < 6823
                  ? (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : c <= 6809)
                  : (c <= 6823 || (c < 6847
                    ? (c >= 6832 && c <= 6845)
                    : c <= 6862)))
                : (c <= 6988 || (c < 7040
                  ? (c < 7019
                    ? (c >= 6992 && c <= 7001)
                    : c <= 7027)
                  : (c <= 7155 || (c < 7232
                    ? (c >= 7168 && c <= 7223)
                    : c <= 7241)))))
              : (c <= 7293 || (c < 7424
                ? (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))))))))
        : (c <= 8027 || (c < 11728
          ? (c < 8469
            ? (c < 8182
              ? (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))))
              : (c <= 8188 || (c < 8400
                ? (c < 8305
                  ? (c < 8276
                    ? (c >= 8255 && c <= 8256)
                    : c <= 8276)
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8412 || (c < 8450
                  ? (c < 8421
                    ? c == 8417
                    : c <= 8432)
                  : (c <= 8450 || (c < 8458
                    ? c == 8455
                    : c <= 8467)))))))
            : (c <= 8469 || (c < 11520
              ? (c < 8508
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || (c < 8490
                    ? c == 8488
                    : c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11507)))))
              : (c <= 11557 || (c < 11680
                ? (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))))))
          : (c <= 11734 || (c < 42775
            ? (c < 12549
              ? (c < 12344
                ? (c < 12293
                  ? (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)
                  : (c <= 12295 || (c < 12337
                    ? (c >= 12321 && c <= 12335)
                    : c <= 12341)))
                : (c <= 12348 || (c < 12445
                  ? (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))))
              : (c <= 12591 || (c < 42192
                ? (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)))
                : (c <= 42237 || (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))))))
            : (c <= 42783 || (c < 43259
              ? (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43047 || (c < 43136
                  ? (c < 43072
                    ? c == 43052
                    : c <= 43123)
                  : (c <= 43205 || (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)))))
              : (c <= 43259 || (c < 43488
                ? (c < 43360
                  ? (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)))
                : (c <= 43518 || (c < 43600
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)
                  : (c <= 43609 || (c >= 43616 && c <= 43638)))))))))))))))
    : (c <= 43714 || (c < 71472
      ? (c < 67644
        ? (c < 65382
          ? (c < 64318
            ? (c < 44012
              ? (c < 43793
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)
                  : (c <= 43766 || (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)))))
              : (c <= 44013 || (c < 64112
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : c <= 55203)
                  : (c <= 55238 || (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))))))
            : (c <= 64318 || (c < 65101
              ? (c < 64848
                ? (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)))
                : (c <= 64911 || (c < 65024
                  ? (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)
                  : (c <= 65039 || (c < 65075
                    ? (c >= 65056 && c <= 65071)
                    : c <= 65076)))))
              : (c <= 65103 || (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65313
                  ? (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)
                  : (c <= 65338 || (c < 65345
                    ? c == 65343
                    : c <= 65370)))))))))
          : (c <= 65470 || (c < 66560
            ? (c < 65856
              ? (c < 65549
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)))
                : (c <= 65574 || (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66349
                ? (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))
                : (c <= 66378 || (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))))))
            : (c <= 66717 || (c < 66995
              ? (c < 66928
                ? (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)))
                : (c <= 66938 || (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))))
              : (c <= 67001 || (c < 67463
                ? (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)))
                : (c <= 67504 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))))))))))
        : (c <= 67644 || (c < 69968
          ? (c < 68480
            ? (c < 68108
              ? (c < 67840
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))
                : (c <= 67861 || (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)))))
              : (c <= 68115 || (c < 68224
                ? (c < 68152
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68154 || (c < 68192
                    ? c == 68159
                    : c <= 68220)))
                : (c <= 68252 || (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)
                  : (c <= 68405 || (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)))))))
            : (c <= 68497 || (c < 69488
              ? (c < 69248
                ? (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)))
                : (c <= 69289 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69456)))))
              : (c <= 69509 || (c < 69826
                ? (c < 69632
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69888
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)
                  : (c <= 69940 || (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)))))))))
          : (c <= 70003 || (c < 70471
            ? (c < 70287
              ? (c < 70144
                ? (c < 70089
                  ? (c < 70016
                    ? c == 70006
                    : c <= 70084)
                  : (c <= 70092 || (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)))
                : (c <= 70161 || (c < 70272
                  ? (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)
                  : (c <= 70278 || (c < 70282
                    ? c == 70280
                    : c <= 70285)))))
              : (c <= 70301 || (c < 70415
                ? (c < 70384
                  ? (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)
                  : (c <= 70393 || (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)))
                : (c <= 70416 || (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)))))))
            : (c <= 70472 || (c < 70864
              ? (c < 70512
                ? (c < 70487
                  ? (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))
                : (c <= 70516 || (c < 70750
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)
                  : (c <= 70753 || (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)))))
              : (c <= 70873 || (c < 71248
                ? (c < 71128
                  ? (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)
                  : (c <= 71133 || (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)))
                : (c <= 71257 || (c < 71424
                  ? (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)
                  : (c <= 71450 || (c >= 71453 && c <= 71467)))))))))))))
      : (c <= 71481 || (c < 119973
        ? (c < 82944
          ? (c < 72784
            ? (c < 72096
              ? (c < 71948
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71738)
                  : (c <= 71913 || (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)))
                : (c <= 71955 || (c < 71991
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71989)
                  : (c <= 71992 || (c < 72016
                    ? (c >= 71995 && c <= 72003)
                    : c <= 72025)))))
              : (c <= 72103 || (c < 72272
                ? (c < 72163
                  ? (c < 72154
                    ? (c >= 72106 && c <= 72151)
                    : c <= 72161)
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)))))))
            : (c <= 72793 || (c < 73063
              ? (c < 72971
                ? (c < 72873
                  ? (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)
                  : (c <= 72886 || (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)))
                : (c <= 73014 || (c < 73023
                  ? (c < 73020
                    ? c == 73018
                    : c <= 73021)
                  : (c <= 73031 || (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)))))
              : (c <= 73064 || (c < 73648
                ? (c < 73107
                  ? (c < 73104
                    ? (c >= 73066 && c <= 73102)
                    : c <= 73105)
                  : (c <= 73112 || (c < 73440
                    ? (c >= 73120 && c <= 73129)
                    : c <= 73462)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))))
          : (c <= 83526 || (c < 110581
            ? (c < 93053
              ? (c < 92880
                ? (c < 92768
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))
                : (c <= 92909 || (c < 92992
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : c <= 92982)
                  : (c <= 92995 || (c < 93027
                    ? (c >= 93008 && c <= 93017)
                    : c <= 93047)))))
              : (c <= 93071 || (c < 94179
                ? (c < 94031
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94087 || (c < 94176
                    ? (c >= 94095 && c <= 94111)
                    : c <= 94177)))
                : (c <= 94180 || (c < 100352
                  ? (c < 94208
                    ? (c >= 94192 && c <= 94193)
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))))))
            : (c <= 110587 || (c < 118576
              ? (c < 113664
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c < 118528
                    ? (c >= 113821 && c <= 113822)
                    : c <= 118573)))))
              : (c <= 118598 || (c < 119362
                ? (c < 119163
                  ? (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)
                  : (c <= 119170 || (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)))
                : (c <= 119364 || (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_14(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'b' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_15(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'y')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym_identifier_character_set_16(int32_t c) {
  return (c < 43739
    ? (c < 3804
      ? (c < 2768
        ? (c < 2160
          ? (c < 1369
            ? (c < 768
              ? (c < 216
                ? (c < 183
                  ? (c < 181
                    ? c == 170
                    : c <= 181)
                  : (c <= 183 || (c < 192
                    ? c == 186
                    : c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || (c < 750
                    ? c == 748
                    : c <= 750)))))
              : (c <= 884 || (c < 910
                ? (c < 895
                  ? (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)
                  : (c <= 895 || (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)))
                : (c <= 929 || (c < 1155
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1159 || (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)))))))
            : (c <= 1369 || (c < 1749
              ? (c < 1479
                ? (c < 1471
                  ? (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)
                  : (c <= 1471 || (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)))
                : (c <= 1479 || (c < 1552
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1562 || (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)))))
              : (c <= 1756 || (c < 1984
                ? (c < 1791
                  ? (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)
                  : (c <= 1791 || (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)))
                : (c <= 2037 || (c < 2048
                  ? (c < 2045
                    ? c == 2042
                    : c <= 2045)
                  : (c <= 2093 || (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)))))))))
          : (c <= 2183 || (c < 2579
            ? (c < 2492
              ? (c < 2437
                ? (c < 2275
                  ? (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)
                  : (c <= 2403 || (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || (c < 2486
                    ? c == 2482
                    : c <= 2489)))))
              : (c <= 2500 || (c < 2534
                ? (c < 2519
                  ? (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)
                  : (c <= 2519 || (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)))
                : (c <= 2545 || (c < 2561
                  ? (c < 2558
                    ? c == 2556
                    : c <= 2558)
                  : (c <= 2563 || (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)))))))
            : (c <= 2600 || (c < 2662
              ? (c < 2622
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)))
                : (c <= 2626 || (c < 2641
                  ? (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)
                  : (c <= 2641 || (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)))))
              : (c <= 2677 || (c < 2738
                ? (c < 2703
                  ? (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)
                  : (c <= 2705 || (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)))
                : (c <= 2739 || (c < 2759
                  ? (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)
                  : (c <= 2761 || (c >= 2763 && c <= 2765)))))))))))
        : (c <= 2768 || (c < 3205
          ? (c < 2972
            ? (c < 2887
              ? (c < 2831
                ? (c < 2809
                  ? (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)
                  : (c <= 2815 || (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)))
                : (c <= 2832 || (c < 2866
                  ? (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)
                  : (c <= 2867 || (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)))))
              : (c <= 2888 || (c < 2929
                ? (c < 2908
                  ? (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)
                  : (c <= 2909 || (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)))
                : (c <= 2929 || (c < 2958
                  ? (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)
                  : (c <= 2960 || (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)))))))
            : (c <= 2972 || (c < 3086
              ? (c < 3014
                ? (c < 2984
                  ? (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)
                  : (c <= 2986 || (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)))
                : (c <= 3016 || (c < 3031
                  ? (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)
                  : (c <= 3031 || (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)))))
              : (c <= 3088 || (c < 3157
                ? (c < 3132
                  ? (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)
                  : (c <= 3140 || (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)))
                : (c <= 3158 || (c < 3168
                  ? (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)
                  : (c <= 3171 || (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)))))))))
          : (c <= 3212 || (c < 3482
            ? (c < 3313
              ? (c < 3270
                ? (c < 3242
                  ? (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)
                  : (c <= 3251 || (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)))
                : (c <= 3272 || (c < 3293
                  ? (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)
                  : (c <= 3294 || (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)))))
              : (c <= 3314 || (c < 3412
                ? (c < 3346
                  ? (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)
                  : (c <= 3396 || (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)))
                : (c <= 3415 || (c < 3450
                  ? (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)
                  : (c <= 3455 || (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)))))))
            : (c <= 3505 || (c < 3664
              ? (c < 3542
                ? (c < 3520
                  ? (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)
                  : (c <= 3526 || (c < 3535
                    ? c == 3530
                    : c <= 3540)))
                : (c <= 3542 || (c < 3570
                  ? (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)
                  : (c <= 3571 || (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)))))
              : (c <= 3673 || (c < 3751
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)))
                : (c <= 3773 || (c < 3784
                  ? (c < 3782
                    ? (c >= 3776 && c <= 3780)
                    : c <= 3782)
                  : (c <= 3789 || (c >= 3792 && c <= 3801)))))))))))))
      : (c <= 3807 || (c < 8029
        ? (c < 5984
          ? (c < 4704
            ? (c < 4038
              ? (c < 3897
                ? (c < 3872
                  ? (c < 3864
                    ? c == 3840
                    : c <= 3865)
                  : (c <= 3881 || (c < 3895
                    ? c == 3893
                    : c <= 3895)))
                : (c <= 3897 || (c < 3953
                  ? (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)
                  : (c <= 3972 || (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)))))
              : (c <= 4038 || (c < 4304
                ? (c < 4256
                  ? (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)
                  : (c <= 4293 || (c < 4301
                    ? c == 4295
                    : c <= 4301)))
                : (c <= 4346 || (c < 4688
                  ? (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)
                  : (c <= 4694 || (c < 4698
                    ? c == 4696
                    : c <= 4701)))))))
            : (c <= 4744 || (c < 4969
              ? (c < 4802
                ? (c < 4786
                  ? (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)
                  : (c <= 4789 || (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)))
                : (c <= 4805 || (c < 4882
                  ? (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)
                  : (c <= 4885 || (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)))))
              : (c <= 4977 || (c < 5761
                ? (c < 5112
                  ? (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)
                  : (c <= 5117 || (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)))
                : (c <= 5786 || (c < 5888
                  ? (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)
                  : (c <= 5909 || (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)))))))))
          : (c <= 5996 || (c < 6800
            ? (c < 6400
              ? (c < 6112
                ? (c < 6016
                  ? (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)
                  : (c <= 6099 || (c < 6108
                    ? c == 6103
                    : c <= 6109)))
                : (c <= 6121 || (c < 6176
                  ? (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)
                  : (c <= 6264 || (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)))))
              : (c <= 6430 || (c < 6576
                ? (c < 6470
                  ? (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)
                  : (c <= 6509 || (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)))
                : (c <= 6601 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)
                  : (c <= 6750 || (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)))))))
            : (c <= 6809 || (c < 7312
              ? (c < 7019
                ? (c < 6847
                  ? (c < 6832
                    ? c == 6823
                    : c <= 6845)
                  : (c <= 6862 || (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)))
                : (c <= 7027 || (c < 7232
                  ? (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)
                  : (c <= 7241 || (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)))))
              : (c <= 7354 || (c < 7968
                ? (c < 7380
                  ? (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)
                  : (c <= 7418 || (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)))
                : (c <= 8005 || (c < 8025
                  ? (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)
                  : (c <= 8025 || c == 8027))))))))))
        : (c <= 8029 || (c < 11736
          ? (c < 8472
            ? (c < 8255
              ? (c < 8134
                ? (c < 8118
                  ? (c < 8064
                    ? (c >= 8031 && c <= 8061)
                    : c <= 8116)
                  : (c <= 8124 || (c < 8130
                    ? c == 8126
                    : c <= 8132)))
                : (c <= 8140 || (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))))
              : (c <= 8256 || (c < 8417
                ? (c < 8319
                  ? (c < 8305
                    ? c == 8276
                    : c <= 8305)
                  : (c <= 8319 || (c < 8400
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8412)))
                : (c <= 8417 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8421 && c <= 8432)
                    : c <= 8450)
                  : (c <= 8455 || (c < 8469
                    ? (c >= 8458 && c <= 8467)
                    : c <= 8469)))))))
            : (c <= 8477 || (c < 11559
              ? (c < 8517
                ? (c < 8488
                  ? (c < 8486
                    ? c == 8484
                    : c <= 8486)
                  : (c <= 8488 || (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)))
                : (c <= 8521 || (c < 11264
                  ? (c < 8544
                    ? c == 8526
                    : c <= 8584)
                  : (c <= 11492 || (c < 11520
                    ? (c >= 11499 && c <= 11507)
                    : c <= 11557)))))
              : (c <= 11559 || (c < 11688
                ? (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c < 11680
                    ? (c >= 11647 && c <= 11670)
                    : c <= 11686)))
                : (c <= 11694 || (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c < 11728
                    ? (c >= 11720 && c <= 11726)
                    : c <= 11734)))))))))
          : (c <= 11742 || (c < 42786
            ? (c < 12593
              ? (c < 12353
                ? (c < 12321
                  ? (c < 12293
                    ? (c >= 11744 && c <= 11775)
                    : c <= 12295)
                  : (c <= 12335 || (c < 12344
                    ? (c >= 12337 && c <= 12341)
                    : c <= 12348)))
                : (c <= 12438 || (c < 12449
                  ? (c < 12445
                    ? (c >= 12441 && c <= 12442)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))))
              : (c <= 12686 || (c < 42240
                ? (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c < 42192
                    ? (c >= 19968 && c <= 42124)
                    : c <= 42237)))
                : (c <= 42508 || (c < 42612
                  ? (c < 42560
                    ? (c >= 42512 && c <= 42539)
                    : c <= 42607)
                  : (c <= 42621 || (c < 42775
                    ? (c >= 42623 && c <= 42737)
                    : c <= 42783)))))))
            : (c <= 42888 || (c < 43261
              ? (c < 43052
                ? (c < 42963
                  ? (c < 42960
                    ? (c >= 42891 && c <= 42954)
                    : c <= 42961)
                  : (c <= 42963 || (c < 42994
                    ? (c >= 42965 && c <= 42969)
                    : c <= 43047)))
                : (c <= 43052 || (c < 43216
                  ? (c < 43136
                    ? (c >= 43072 && c <= 43123)
                    : c <= 43205)
                  : (c <= 43225 || (c < 43259
                    ? (c >= 43232 && c <= 43255)
                    : c <= 43259)))))
              : (c <= 43309 || (c < 43520
                ? (c < 43392
                  ? (c < 43360
                    ? (c >= 43312 && c <= 43347)
                    : c <= 43388)
                  : (c <= 43456 || (c < 43488
                    ? (c >= 43471 && c <= 43481)
                    : c <= 43518)))
                : (c <= 43574 || (c < 43616
                  ? (c < 43600
                    ? (c >= 43584 && c <= 43597)
                    : c <= 43609)
                  : (c <= 43638 || (c >= 43642 && c <= 43714)))))))))))))))
    : (c <= 43741 || (c < 71472
      ? (c < 67644
        ? (c < 65474
          ? (c < 64320
            ? (c < 44016
              ? (c < 43808
                ? (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43759)
                    : c <= 43766)
                  : (c <= 43782 || (c < 43793
                    ? (c >= 43785 && c <= 43790)
                    : c <= 43798)))
                : (c <= 43814 || (c < 43868
                  ? (c < 43824
                    ? (c >= 43816 && c <= 43822)
                    : c <= 43866)
                  : (c <= 43881 || (c < 44012
                    ? (c >= 43888 && c <= 44010)
                    : c <= 44013)))))
              : (c <= 44025 || (c < 64256
                ? (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c < 64112
                    ? (c >= 63744 && c <= 64109)
                    : c <= 64217)))
                : (c <= 64262 || (c < 64298
                  ? (c < 64285
                    ? (c >= 64275 && c <= 64279)
                    : c <= 64296)
                  : (c <= 64310 || (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)))))))
            : (c <= 64321 || (c < 65137
              ? (c < 64914
                ? (c < 64467
                  ? (c < 64326
                    ? (c >= 64323 && c <= 64324)
                    : c <= 64433)
                  : (c <= 64605 || (c < 64848
                    ? (c >= 64612 && c <= 64829)
                    : c <= 64911)))
                : (c <= 64967 || (c < 65056
                  ? (c < 65024
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65039)
                  : (c <= 65071 || (c < 65101
                    ? (c >= 65075 && c <= 65076)
                    : c <= 65103)))))
              : (c <= 65137 || (c < 65151
                ? (c < 65145
                  ? (c < 65143
                    ? c == 65139
                    : c <= 65143)
                  : (c <= 65145 || (c < 65149
                    ? c == 65147
                    : c <= 65149)))
                : (c <= 65276 || (c < 65343
                  ? (c < 65313
                    ? (c >= 65296 && c <= 65305)
                    : c <= 65338)
                  : (c <= 65343 || (c < 65382
                    ? (c >= 65345 && c <= 65370)
                    : c <= 65470)))))))))
          : (c <= 65479 || (c < 66720
            ? (c < 66045
              ? (c < 65576
                ? (c < 65498
                  ? (c < 65490
                    ? (c >= 65482 && c <= 65487)
                    : c <= 65495)
                  : (c <= 65500 || (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)))
                : (c <= 65594 || (c < 65616
                  ? (c < 65599
                    ? (c >= 65596 && c <= 65597)
                    : c <= 65613)
                  : (c <= 65629 || (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)))))
              : (c <= 66045 || (c < 66384
                ? (c < 66272
                  ? (c < 66208
                    ? (c >= 66176 && c <= 66204)
                    : c <= 66256)
                  : (c <= 66272 || (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)))
                : (c <= 66426 || (c < 66504
                  ? (c < 66464
                    ? (c >= 66432 && c <= 66461)
                    : c <= 66499)
                  : (c <= 66511 || (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)))))))
            : (c <= 66729 || (c < 67003
              ? (c < 66940
                ? (c < 66816
                  ? (c < 66776
                    ? (c >= 66736 && c <= 66771)
                    : c <= 66811)
                  : (c <= 66855 || (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)))
                : (c <= 66954 || (c < 66967
                  ? (c < 66964
                    ? (c >= 66956 && c <= 66962)
                    : c <= 66965)
                  : (c <= 66977 || (c < 66995
                    ? (c >= 66979 && c <= 66993)
                    : c <= 67001)))))
              : (c <= 67004 || (c < 67506
                ? (c < 67424
                  ? (c < 67392
                    ? (c >= 67072 && c <= 67382)
                    : c <= 67413)
                  : (c <= 67431 || (c < 67463
                    ? (c >= 67456 && c <= 67461)
                    : c <= 67504)))
                : (c <= 67514 || (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))))))))))
        : (c <= 67644 || (c < 69968
          ? (c < 68480
            ? (c < 68108
              ? (c < 67840
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))
                : (c <= 67861 || (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)))))
              : (c <= 68115 || (c < 68224
                ? (c < 68152
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68154 || (c < 68192
                    ? c == 68159
                    : c <= 68220)))
                : (c <= 68252 || (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)
                  : (c <= 68405 || (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)))))))
            : (c <= 68497 || (c < 69488
              ? (c < 69248
                ? (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)))
                : (c <= 69289 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69456)))))
              : (c <= 69509 || (c < 69826
                ? (c < 69632
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69888
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)
                  : (c <= 69940 || (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)))))))))
          : (c <= 70003 || (c < 70471
            ? (c < 70287
              ? (c < 70144
                ? (c < 70089
                  ? (c < 70016
                    ? c == 70006
                    : c <= 70084)
                  : (c <= 70092 || (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)))
                : (c <= 70161 || (c < 70272
                  ? (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)
                  : (c <= 70278 || (c < 70282
                    ? c == 70280
                    : c <= 70285)))))
              : (c <= 70301 || (c < 70415
                ? (c < 70384
                  ? (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)
                  : (c <= 70393 || (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)))
                : (c <= 70416 || (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)))))))
            : (c <= 70472 || (c < 70864
              ? (c < 70512
                ? (c < 70487
                  ? (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))
                : (c <= 70516 || (c < 70750
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)
                  : (c <= 70753 || (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)))))
              : (c <= 70873 || (c < 71248
                ? (c < 71128
                  ? (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)
                  : (c <= 71133 || (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)))
                : (c <= 71257 || (c < 71424
                  ? (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)
                  : (c <= 71450 || (c >= 71453 && c <= 71467)))))))))))))
      : (c <= 71481 || (c < 119973
        ? (c < 82944
          ? (c < 72784
            ? (c < 72096
              ? (c < 71948
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71738)
                  : (c <= 71913 || (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)))
                : (c <= 71955 || (c < 71991
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71989)
                  : (c <= 71992 || (c < 72016
                    ? (c >= 71995 && c <= 72003)
                    : c <= 72025)))))
              : (c <= 72103 || (c < 72272
                ? (c < 72163
                  ? (c < 72154
                    ? (c >= 72106 && c <= 72151)
                    : c <= 72161)
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)))))))
            : (c <= 72793 || (c < 73063
              ? (c < 72971
                ? (c < 72873
                  ? (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)
                  : (c <= 72886 || (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)))
                : (c <= 73014 || (c < 73023
                  ? (c < 73020
                    ? c == 73018
                    : c <= 73021)
                  : (c <= 73031 || (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)))))
              : (c <= 73064 || (c < 73648
                ? (c < 73107
                  ? (c < 73104
                    ? (c >= 73066 && c <= 73102)
                    : c <= 73105)
                  : (c <= 73112 || (c < 73440
                    ? (c >= 73120 && c <= 73129)
                    : c <= 73462)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))))
          : (c <= 83526 || (c < 110581
            ? (c < 93053
              ? (c < 92880
                ? (c < 92768
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))
                : (c <= 92909 || (c < 92992
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : c <= 92982)
                  : (c <= 92995 || (c < 93027
                    ? (c >= 93008 && c <= 93017)
                    : c <= 93047)))))
              : (c <= 93071 || (c < 94179
                ? (c < 94031
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94087 || (c < 94176
                    ? (c >= 94095 && c <= 94111)
                    : c <= 94177)))
                : (c <= 94180 || (c < 100352
                  ? (c < 94208
                    ? (c >= 94192 && c <= 94193)
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))))))
            : (c <= 110587 || (c < 118576
              ? (c < 113664
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c < 118528
                    ? (c >= 113821 && c <= 113822)
                    : c <= 118573)))))
              : (c <= 118598 || (c < 119362
                ? (c < 119163
                  ? (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)
                  : (c <= 119170 || (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)))
                : (c <= 119364 || (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(297);
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(258);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(301);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(376);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(365);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(295)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(150)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(150)
      if (lookahead == '\r') SKIP(1)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(159)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(159)
      if (lookahead == '\r') SKIP(3)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(158)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(158)
      if (lookahead == '\r') SKIP(5)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(162)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(162)
      if (lookahead == '\r') SKIP(7)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(160)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(160)
      if (lookahead == '\r') SKIP(9)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(163)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(163)
      if (lookahead == '\r') SKIP(11)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(152)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(152)
      if (lookahead == '\r') SKIP(13)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(151)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(151)
      if (lookahead == '\r') SKIP(15)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(153)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(153)
      if (lookahead == '\r') SKIP(17)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(164)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(164)
      if (lookahead == '\r') SKIP(19)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(220)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(220)
      if (lookahead == '\r') SKIP(21)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(176)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(176)
      if (lookahead == '\r') SKIP(23)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(219)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(219)
      if (lookahead == '\r') SKIP(25)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(221)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(221)
      if (lookahead == '\r') SKIP(27)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(156)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(156)
      if (lookahead == '\r') SKIP(29)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(185)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(185)
      if (lookahead == '\r') SKIP(31)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(178)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(178)
      if (lookahead == '\r') SKIP(33)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(177)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(177)
      if (lookahead == '\r') SKIP(35)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(187)
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(187)
      if (lookahead == '\r') SKIP(37)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(169)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(169)
      if (lookahead == '\r') SKIP(39)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(203)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(203)
      if (lookahead == '\r') SKIP(41)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(167)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(167)
      if (lookahead == '\r') SKIP(43)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(171)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(171)
      if (lookahead == '\r') SKIP(45)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(189)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(189)
      if (lookahead == '\r') SKIP(47)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(194)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(194)
      if (lookahead == '\r') SKIP(49)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(181)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(181)
      if (lookahead == '\r') SKIP(51)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(212)
      END_STATE();
    case 54:
      if (lookahead == '\n') SKIP(212)
      if (lookahead == '\r') SKIP(53)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 55:
      if (lookahead == '\n') SKIP(205)
      END_STATE();
    case 56:
      if (lookahead == '\n') SKIP(205)
      if (lookahead == '\r') SKIP(55)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 57:
      if (lookahead == '\n') SKIP(192)
      END_STATE();
    case 58:
      if (lookahead == '\n') SKIP(192)
      if (lookahead == '\r') SKIP(57)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 59:
      if (lookahead == '\n') SKIP(173)
      END_STATE();
    case 60:
      if (lookahead == '\n') SKIP(173)
      if (lookahead == '\r') SKIP(59)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 61:
      if (lookahead == '\n') SKIP(196)
      END_STATE();
    case 62:
      if (lookahead == '\n') SKIP(196)
      if (lookahead == '\r') SKIP(61)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 63:
      if (lookahead == '\n') SKIP(157)
      END_STATE();
    case 64:
      if (lookahead == '\n') SKIP(157)
      if (lookahead == '\r') SKIP(63)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 65:
      if (lookahead == '\n') SKIP(180)
      END_STATE();
    case 66:
      if (lookahead == '\n') SKIP(180)
      if (lookahead == '\r') SKIP(65)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 67:
      if (lookahead == '\n') SKIP(195)
      END_STATE();
    case 68:
      if (lookahead == '\n') SKIP(195)
      if (lookahead == '\r') SKIP(67)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 69:
      if (lookahead == '\n') SKIP(215)
      END_STATE();
    case 70:
      if (lookahead == '\n') SKIP(215)
      if (lookahead == '\r') SKIP(69)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 71:
      if (lookahead == '\n') SKIP(222)
      END_STATE();
    case 72:
      if (lookahead == '\n') SKIP(222)
      if (lookahead == '\r') SKIP(71)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 73:
      if (lookahead == '\n') SKIP(227)
      END_STATE();
    case 74:
      if (lookahead == '\n') SKIP(227)
      if (lookahead == '\r') SKIP(73)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 75:
      if (lookahead == '\n') SKIP(223)
      END_STATE();
    case 76:
      if (lookahead == '\n') SKIP(223)
      if (lookahead == '\r') SKIP(75)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 77:
      if (lookahead == '\n') SKIP(224)
      END_STATE();
    case 78:
      if (lookahead == '\n') SKIP(224)
      if (lookahead == '\r') SKIP(77)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 79:
      if (lookahead == '\n') SKIP(225)
      END_STATE();
    case 80:
      if (lookahead == '\n') SKIP(225)
      if (lookahead == '\r') SKIP(79)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 81:
      if (lookahead == '\n') SKIP(201)
      END_STATE();
    case 82:
      if (lookahead == '\n') SKIP(201)
      if (lookahead == '\r') SKIP(81)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 83:
      if (lookahead == '\n') SKIP(226)
      END_STATE();
    case 84:
      if (lookahead == '\n') SKIP(226)
      if (lookahead == '\r') SKIP(83)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 85:
      if (lookahead == '\n') SKIP(229)
      END_STATE();
    case 86:
      if (lookahead == '\n') SKIP(229)
      if (lookahead == '\r') SKIP(85)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 87:
      if (lookahead == '\n') SKIP(165)
      END_STATE();
    case 88:
      if (lookahead == '\n') SKIP(165)
      if (lookahead == '\r') SKIP(87)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 89:
      if (lookahead == '\n') SKIP(91)
      END_STATE();
    case 90:
      if (lookahead == '\n') SKIP(91)
      if (lookahead == '\r') SKIP(89)
      END_STATE();
    case 91:
      if (lookahead == '\n') ADVANCE(306);
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(374);
      if (lookahead == '-') ADVANCE(364);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '<') ADVANCE(409);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '\\') SKIP(90)
      if (lookahead == '^') ADVANCE(392);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      END_STATE();
    case 92:
      if (lookahead == '\n') SKIP(228)
      END_STATE();
    case 93:
      if (lookahead == '\n') SKIP(228)
      if (lookahead == '\r') SKIP(92)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 94:
      if (lookahead == '\n') SKIP(216)
      END_STATE();
    case 95:
      if (lookahead == '\n') SKIP(216)
      if (lookahead == '\r') SKIP(94)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 96:
      if (lookahead == '\n') SKIP(217)
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '/') ADVANCE(481);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(484);
      if (lookahead != 0) ADVANCE(485);
      END_STATE();
    case 97:
      if (lookahead == '\n') ADVANCE(487);
      if (lookahead == '\r') ADVANCE(486);
      if (lookahead == 'U') ADVANCE(293);
      if (lookahead == 'u') ADVANCE(285);
      if (lookahead == 'x') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(489);
      if (lookahead != 0) ADVANCE(486);
      END_STATE();
    case 98:
      if (lookahead == '\n') ADVANCE(299);
      if (lookahead == '\r') ADVANCE(102);
      if (lookahead == '(') ADVANCE(301);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(317);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(243)
      if (lookahead != 0) ADVANCE(321);
      END_STATE();
    case 99:
      if (lookahead == '\n') ADVANCE(299);
      if (lookahead == '\r') ADVANCE(102);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(317);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(243)
      if (lookahead != 0) ADVANCE(321);
      END_STATE();
    case 100:
      if (lookahead == '\n') ADVANCE(299);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '\\') SKIP(104)
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(230)
      END_STATE();
    case 101:
      if (lookahead == '\n') ADVANCE(299);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '\\') SKIP(104)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(230)
      END_STATE();
    case 102:
      if (lookahead == '\n') ADVANCE(299);
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(317);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(243)
      if (lookahead != 0) ADVANCE(321);
      END_STATE();
    case 103:
      if (lookahead == '\n') SKIP(230)
      END_STATE();
    case 104:
      if (lookahead == '\n') SKIP(230)
      if (lookahead == '\r') SKIP(103)
      END_STATE();
    case 105:
      if (lookahead == '\n') SKIP(242)
      if (lookahead == '/') ADVANCE(474);
      if (lookahead == '\\') ADVANCE(473);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(475);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(472);
      END_STATE();
    case 106:
      if (lookahead == '\n') SKIP(161)
      END_STATE();
    case 107:
      if (lookahead == '\n') SKIP(161)
      if (lookahead == '\r') SKIP(106)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 108:
      if (lookahead == '\n') SKIP(154)
      END_STATE();
    case 109:
      if (lookahead == '\n') SKIP(154)
      if (lookahead == '\r') SKIP(108)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 110:
      if (lookahead == '\n') SKIP(155)
      END_STATE();
    case 111:
      if (lookahead == '\n') SKIP(155)
      if (lookahead == '\r') SKIP(110)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 112:
      if (lookahead == '\n') SKIP(202)
      END_STATE();
    case 113:
      if (lookahead == '\n') SKIP(202)
      if (lookahead == '\r') SKIP(112)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 114:
      if (lookahead == '\n') SKIP(179)
      END_STATE();
    case 115:
      if (lookahead == '\n') SKIP(179)
      if (lookahead == '\r') SKIP(114)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 116:
      if (lookahead == '\n') SKIP(207)
      END_STATE();
    case 117:
      if (lookahead == '\n') SKIP(207)
      if (lookahead == '\r') SKIP(116)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 118:
      if (lookahead == '\n') SKIP(175)
      END_STATE();
    case 119:
      if (lookahead == '\n') SKIP(175)
      if (lookahead == '\r') SKIP(118)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 120:
      if (lookahead == '\n') SKIP(208)
      END_STATE();
    case 121:
      if (lookahead == '\n') SKIP(208)
      if (lookahead == '\r') SKIP(120)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 122:
      if (lookahead == '\n') SKIP(211)
      END_STATE();
    case 123:
      if (lookahead == '\n') SKIP(211)
      if (lookahead == '\r') SKIP(122)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 124:
      if (lookahead == '\n') SKIP(197)
      END_STATE();
    case 125:
      if (lookahead == '\n') SKIP(197)
      if (lookahead == '\r') SKIP(124)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 126:
      if (lookahead == '\n') SKIP(193)
      END_STATE();
    case 127:
      if (lookahead == '\n') SKIP(193)
      if (lookahead == '\r') SKIP(126)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 128:
      if (lookahead == '\n') SKIP(199)
      END_STATE();
    case 129:
      if (lookahead == '\n') SKIP(199)
      if (lookahead == '\r') SKIP(128)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 130:
      if (lookahead == '\n') SKIP(184)
      END_STATE();
    case 131:
      if (lookahead == '\n') SKIP(184)
      if (lookahead == '\r') SKIP(130)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 132:
      if (lookahead == '\n') SKIP(190)
      END_STATE();
    case 133:
      if (lookahead == '\n') SKIP(190)
      if (lookahead == '\r') SKIP(132)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 134:
      if (lookahead == '\n') SKIP(186)
      END_STATE();
    case 135:
      if (lookahead == '\n') SKIP(186)
      if (lookahead == '\r') SKIP(134)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 136:
      if (lookahead == '\n') SKIP(210)
      END_STATE();
    case 137:
      if (lookahead == '\n') SKIP(210)
      if (lookahead == '\r') SKIP(136)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 138:
      if (lookahead == '\n') SKIP(200)
      END_STATE();
    case 139:
      if (lookahead == '\n') SKIP(200)
      if (lookahead == '\r') SKIP(138)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 140:
      if (lookahead == '\n') SKIP(183)
      END_STATE();
    case 141:
      if (lookahead == '\n') SKIP(183)
      if (lookahead == '\r') SKIP(140)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 142:
      if (lookahead == '\n') SKIP(206)
      END_STATE();
    case 143:
      if (lookahead == '\n') SKIP(206)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 144:
      if (lookahead == '\n') SKIP(204)
      END_STATE();
    case 145:
      if (lookahead == '\n') SKIP(204)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 146:
      if (lookahead == '\n') SKIP(214)
      END_STATE();
    case 147:
      if (lookahead == '\n') SKIP(214)
      if (lookahead == '\r') SKIP(146)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 148:
      if (lookahead == '\n') SKIP(188)
      END_STATE();
    case 149:
      if (lookahead == '\n') SKIP(188)
      if (lookahead == '\r') SKIP(148)
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 150:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(258);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(376);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(365);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(150)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 151:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(376);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(365);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(151)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 152:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(376);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(366);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(152)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 153:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(376);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(366);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(18);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(153)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 154:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(367);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(109);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(154)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 155:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(367);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(155)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 156:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(218);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(231);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '[') ADVANCE(255);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(156)
      END_STATE();
    case 157:
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(218);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(231);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '[') ADVANCE(256);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(157)
      END_STATE();
    case 158:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(258);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(245);
      if (lookahead == '>') ADVANCE(248);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(6);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(389);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(158)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 159:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(264);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(448);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(257);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(271);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(159)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 160:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(267);
      if (lookahead == '&') ADVANCE(394);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(240);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(10);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(160)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 161:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(260);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '>') ADVANCE(250);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(107);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(161)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 162:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(262);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '>') ADVANCE(399);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(8);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(162)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 163:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(447);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(12);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(163)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 164:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '&') ADVANCE(394);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(447);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == ']') ADVANCE(424);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(164)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 165:
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '+') ADVANCE(379);
      if (lookahead == '-') ADVANCE(372);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == 'L') ADVANCE(512);
      if (lookahead == 'U') ADVANCE(513);
      if (lookahead == '\\') ADVANCE(88);
      if (sym_identifier_character_set_5(lookahead)) ADVANCE(583);
      if (lookahead == 'u') ADVANCE(514);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(165)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 166:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(598);
      if (lookahead == 'R') ADVANCE(599);
      if (lookahead == 'U') ADVANCE(600);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead == '^') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == 'u') ADVANCE(601);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(167)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 167:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(495);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'U') ADVANCE(499);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_5(lookahead)) ADVANCE(583);
      if (lookahead == 'u') ADVANCE(502);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(167)
      END_STATE();
    case 168:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(598);
      if (lookahead == 'R') ADVANCE(599);
      if (lookahead == 'U') ADVANCE(600);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == 'u') ADVANCE(601);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(169)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 169:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(495);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'U') ADVANCE(499);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_7(lookahead)) ADVANCE(583);
      if (lookahead == 'u') ADVANCE(502);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(169)
      END_STATE();
    case 170:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(598);
      if (lookahead == 'R') ADVANCE(599);
      if (lookahead == 'U') ADVANCE(600);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '^') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == 'u') ADVANCE(601);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(171)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 171:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(495);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'U') ADVANCE(499);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_5(lookahead)) ADVANCE(583);
      if (lookahead == 'u') ADVANCE(502);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(171)
      END_STATE();
    case 172:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(598);
      if (lookahead == 'R') ADVANCE(599);
      if (lookahead == 'U') ADVANCE(600);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == 'u') ADVANCE(601);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(173)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 173:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(495);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'U') ADVANCE(499);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_7(lookahead)) ADVANCE(583);
      if (lookahead == 'u') ADVANCE(502);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(173)
      END_STATE();
    case 174:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(598);
      if (lookahead == 'R') ADVANCE(599);
      if (lookahead == 'U') ADVANCE(600);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(119);
      if (lookahead == '^') ADVANCE(392);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == 'u') ADVANCE(601);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(175)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 175:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'L') ADVANCE(495);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'U') ADVANCE(499);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(119);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_5(lookahead)) ADVANCE(583);
      if (lookahead == 'u') ADVANCE(502);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(175)
      END_STATE();
    case 176:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '#') ADVANCE(263);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(374);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(364);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(409);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(176)
      END_STATE();
    case 177:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(177)
      END_STATE();
    case 178:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(178)
      END_STATE();
    case 179:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(115);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(179)
      END_STATE();
    case 180:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(180)
      END_STATE();
    case 181:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(181)
      END_STATE();
    case 182:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == '^') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(183)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 183:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(183)
      END_STATE();
    case 184:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(369);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(423);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(184)
      END_STATE();
    case 185:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(185)
      END_STATE();
    case 186:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(135);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(186)
      END_STATE();
    case 187:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(38);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(187)
      END_STATE();
    case 188:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(188)
      END_STATE();
    case 189:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(189)
      END_STATE();
    case 190:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_9(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(190)
      END_STATE();
    case 191:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(192)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 192:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(192)
      END_STATE();
    case 193:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(423);
      if (lookahead == '\\') ADVANCE(127);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(193)
      END_STATE();
    case 194:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(50);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(194)
      END_STATE();
    case 195:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(68);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(195)
      END_STATE();
    case 196:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(196)
      END_STATE();
    case 197:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(197)
      END_STATE();
    case 198:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(129);
      if (lookahead == '^') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(199)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 199:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(129);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(199)
      END_STATE();
    case 200:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(378);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(370);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(423);
      if (lookahead == '\\') ADVANCE(139);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(200)
      END_STATE();
    case 201:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(380);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(373);
      if (lookahead == '.') ADVANCE(232);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '<') ADVANCE(407);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(401);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(201)
      END_STATE();
    case 202:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(113);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(202)
      END_STATE();
    case 203:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_9(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(203)
      END_STATE();
    case 204:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(204)
      END_STATE();
    case 205:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(205)
      END_STATE();
    case 206:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(143);
      if (lookahead == ']') ADVANCE(257);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_9(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(206)
      END_STATE();
    case 207:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(117);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_9(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(207)
      END_STATE();
    case 208:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(121);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(208)
      END_STATE();
    case 209:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(210)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 210:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_8(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(210)
      END_STATE();
    case 211:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(123);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(211)
      END_STATE();
    case 212:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(212)
      END_STATE();
    case 213:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '^') ADVANCE(392);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(607);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(214)
      if (sym_identifier_character_set_6(lookahead)) ADVANCE(583);
      END_STATE();
    case 214:
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(375);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(371);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '<') ADVANCE(408);
      if (lookahead == '=') ADVANCE(247);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '|') ADVANCE(391);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(214)
      END_STATE();
    case 215:
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == 'L') ADVANCE(496);
      if (lookahead == 'U') ADVANCE(500);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(70);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(503);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(215)
      END_STATE();
    case 216:
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '<') ADVANCE(252);
      if (lookahead == 'L') ADVANCE(496);
      if (lookahead == 'U') ADVANCE(500);
      if (lookahead == '\\') ADVANCE(95);
      if (sym_identifier_character_set_5(lookahead)) ADVANCE(583);
      if (lookahead == 'u') ADVANCE(504);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(216)
      END_STATE();
    case 217:
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(217)
      END_STATE();
    case 218:
      if (lookahead == '"') ADVANCE(597);
      END_STATE();
    case 219:
      if (lookahead == '#') ADVANCE(265);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(26);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(219)
      END_STATE();
    case 220:
      if (lookahead == '#') ADVANCE(259);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(374);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(251);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(22);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(271);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(220)
      END_STATE();
    case 221:
      if (lookahead == '#') ADVANCE(261);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(28);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(221)
      END_STATE();
    case 222:
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(251);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(72);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(271);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(222)
      END_STATE();
    case 223:
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(251);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(76);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(271);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(223)
      END_STATE();
    case 224:
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(78);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(271);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(224)
      END_STATE();
    case 225:
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(80);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(225)
      END_STATE();
    case 226:
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '.') ADVANCE(239);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(84);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(271);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(226)
      END_STATE();
    case 227:
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(74);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(558);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 'u') ADVANCE(551);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(227)
      END_STATE();
    case 228:
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(429);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '[') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(93);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(583);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(228)
      END_STATE();
    case 229:
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == '[') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(86);
      if (sym_identifier_character_set_10(lookahead)) ADVANCE(583);
      if (lookahead == 'f') ADVANCE(530);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(229)
      END_STATE();
    case 230:
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '\\') SKIP(104)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(230)
      END_STATE();
    case 231:
      if (lookahead == ')') ADVANCE(595);
      END_STATE();
    case 232:
      if (lookahead == '*') ADVANCE(449);
      END_STATE();
    case 233:
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '/') ADVANCE(585);
      END_STATE();
    case 234:
      if (lookahead == '*') ADVANCE(594);
      END_STATE();
    case 235:
      if (lookahead == '*') ADVANCE(235);
      if (lookahead == '/') ADVANCE(584);
      if (lookahead != 0) ADVANCE(236);
      END_STATE();
    case 236:
      if (lookahead == '*') ADVANCE(235);
      if (lookahead != 0) ADVANCE(236);
      END_STATE();
    case 237:
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(453);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(454);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(463);
      END_STATE();
    case 238:
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(456);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 239:
      if (lookahead == '.') ADVANCE(241);
      END_STATE();
    case 240:
      if (lookahead == '.') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(452);
      END_STATE();
    case 241:
      if (lookahead == '.') ADVANCE(302);
      END_STATE();
    case 242:
      if (lookahead == '/') ADVANCE(233);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(242)
      END_STATE();
    case 243:
      if (lookahead == '/') ADVANCE(319);
      if (lookahead == '\\') ADVANCE(317);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(243)
      if (lookahead != 0) ADVANCE(321);
      END_STATE();
    case 244:
      if (lookahead == ':') ADVANCE(415);
      END_STATE();
    case 245:
      if (lookahead == '<') ADVANCE(410);
      if (lookahead == '=') ADVANCE(403);
      END_STATE();
    case 246:
      if (lookahead == '=') ADVANCE(398);
      END_STATE();
    case 247:
      if (lookahead == '=') ADVANCE(397);
      END_STATE();
    case 248:
      if (lookahead == '=') ADVANCE(402);
      if (lookahead == '>') ADVANCE(249);
      END_STATE();
    case 249:
      if (lookahead == '=') ADVANCE(438);
      END_STATE();
    case 250:
      if (lookahead == '>') ADVANCE(412);
      END_STATE();
    case 251:
      if (lookahead == '>') ADVANCE(450);
      END_STATE();
    case 252:
      if (lookahead == '>') ADVANCE(490);
      if (lookahead == '\\') ADVANCE(253);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(252);
      END_STATE();
    case 253:
      if (lookahead == '>') ADVANCE(491);
      if (lookahead == '\\') ADVANCE(253);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(252);
      END_STATE();
    case 254:
      if (lookahead == 'U') ADVANCE(292);
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 255:
      if (lookahead == '[') ADVANCE(416);
      if (lookahead == ']') ADVANCE(596);
      END_STATE();
    case 256:
      if (lookahead == ']') ADVANCE(596);
      END_STATE();
    case 257:
      if (lookahead == ']') ADVANCE(417);
      END_STATE();
    case 258:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'e') ADVANCE(353);
      if (lookahead == 'i') ADVANCE(339);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 259:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'e') ADVANCE(353);
      if (lookahead == 'i') ADVANCE(340);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 260:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'e') ADVANCE(356);
      if (lookahead == 'i') ADVANCE(339);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 261:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'e') ADVANCE(356);
      if (lookahead == 'i') ADVANCE(340);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 262:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'e') ADVANCE(355);
      if (lookahead == 'i') ADVANCE(339);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 263:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'e') ADVANCE(355);
      if (lookahead == 'i') ADVANCE(340);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 264:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'i') ADVANCE(339);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 265:
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == 'i') ADVANCE(340);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(265);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 266:
      if (lookahead == 'd') ADVANCE(269);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(270);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(267);
      END_STATE();
    case 268:
      if (lookahead == 'f') ADVANCE(307);
      END_STATE();
    case 269:
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 270:
      if (lookahead == 'n') ADVANCE(266);
      END_STATE();
    case 271:
      if (lookahead == '|') ADVANCE(387);
      END_STATE();
    case 272:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 273:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(452);
      END_STATE();
    case 274:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(454);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(463);
      END_STATE();
    case 275:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(583);
      END_STATE();
    case 276:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(460);
      END_STATE();
    case 277:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(463);
      END_STATE();
    case 278:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(458);
      END_STATE();
    case 279:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(486);
      END_STATE();
    case 280:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(275);
      END_STATE();
    case 281:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(279);
      END_STATE();
    case 282:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(280);
      END_STATE();
    case 283:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(281);
      END_STATE();
    case 284:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(282);
      END_STATE();
    case 285:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(283);
      END_STATE();
    case 286:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(284);
      END_STATE();
    case 287:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(285);
      END_STATE();
    case 288:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(286);
      END_STATE();
    case 289:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(287);
      END_STATE();
    case 290:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(288);
      END_STATE();
    case 291:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(289);
      END_STATE();
    case 292:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(290);
      END_STATE();
    case 293:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(291);
      END_STATE();
    case 294:
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '\\') ADVANCE(585);
      if (lookahead == '\r') ADVANCE(587);
      if (lookahead == '\\') ADVANCE(586);
      END_STATE();
    case 295:
      if (eof) ADVANCE(297);
      if (lookahead == '!') ADVANCE(362);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(258);
      if (lookahead == '%') ADVANCE(386);
      if (lookahead == '&') ADVANCE(396);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(382);
      if (lookahead == '+') ADVANCE(376);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(365);
      if (lookahead == '.') ADVANCE(446);
      if (lookahead == '/') ADVANCE(384);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(406);
      if (lookahead == '=') ADVANCE(426);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == '?') ADVANCE(431);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(424);
      if (lookahead == '^') ADVANCE(393);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(390);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(295)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 296:
      if (eof) ADVANCE(297);
      if (lookahead == '!') ADVANCE(361);
      if (lookahead == '"') ADVANCE(480);
      if (lookahead == '#') ADVANCE(264);
      if (lookahead == '%') ADVANCE(385);
      if (lookahead == '&') ADVANCE(395);
      if (lookahead == '\'') ADVANCE(471);
      if (lookahead == '(') ADVANCE(360);
      if (lookahead == ')') ADVANCE(304);
      if (lookahead == '*') ADVANCE(381);
      if (lookahead == '+') ADVANCE(377);
      if (lookahead == ',') ADVANCE(303);
      if (lookahead == '-') ADVANCE(368);
      if (lookahead == '.') ADVANCE(448);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == ':') ADVANCE(430);
      if (lookahead == ';') ADVANCE(414);
      if (lookahead == '<') ADVANCE(405);
      if (lookahead == '=') ADVANCE(425);
      if (lookahead == '>') ADVANCE(588);
      if (lookahead == 'F') ADVANCE(520);
      if (lookahead == 'L') ADVANCE(494);
      if (lookahead == 'R') ADVANCE(497);
      if (lookahead == 'T') ADVANCE(524);
      if (lookahead == 'U') ADVANCE(498);
      if (lookahead == '[') ADVANCE(421);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == ']') ADVANCE(257);
      if (lookahead == '^') ADVANCE(392);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(583);
      if (lookahead == 'b') ADVANCE(566);
      if (lookahead == 'c') ADVANCE(545);
      if (lookahead == 'd') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(529);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'm') ADVANCE(531);
      if (lookahead == 'n') ADVANCE(579);
      if (lookahead == 'p') ADVANCE(576);
      if (lookahead == 's') ADVANCE(546);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(501);
      if (lookahead == 'v') ADVANCE(563);
      if (lookahead == '{') ADVANCE(418);
      if (lookahead == '|') ADVANCE(271);
      if (lookahead == '}') ADVANCE(419);
      if (lookahead == '~') ADVANCE(363);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(296)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(aux_sym_preproc_include_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(aux_sym_preproc_include_token2);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(aux_sym_preproc_def_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(aux_sym_preproc_if_token1);
      if (lookahead == 'd') ADVANCE(335);
      if (lookahead == 'n') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(306);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(aux_sym_preproc_if_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(aux_sym_preproc_ifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(aux_sym_preproc_else_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (lookahead == 'd') ADVANCE(337);
      if (lookahead == 'n') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(aux_sym_preproc_elif_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(aux_sym_preproc_elifdef_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') ADVANCE(236);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '/') ADVANCE(584);
      if (lookahead == '\\') ADVANCE(322);
      if (lookahead != 0) ADVANCE(320);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(243)
      if (lookahead == '\r') ADVANCE(318);
      if (lookahead == '\\') ADVANCE(323);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(321);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\n') SKIP(243)
      if (lookahead == '\\') ADVANCE(323);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(321);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(320);
      if (lookahead == '/') ADVANCE(585);
      if (lookahead == '\\') ADVANCE(323);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(321);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '\\') ADVANCE(322);
      if (lookahead == '\n' ||
          lookahead == '/') ADVANCE(236);
      if (lookahead != 0) ADVANCE(320);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead == '\\') ADVANCE(323);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(321);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '*' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(320);
      if (lookahead == '\r') ADVANCE(324);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(321);
      if (lookahead == '\r') ADVANCE(325);
      if (lookahead == '\\') ADVANCE(323);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '*' &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(320);
      if (lookahead == '*') ADVANCE(316);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(322);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_preproc_arg);
      if (lookahead != 0 &&
          lookahead != '/' &&
          lookahead != '\\') ADVANCE(321);
      if (lookahead == '\\') ADVANCE(323);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'c') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'd') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'e') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(305);
      if (lookahead == 'n') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(308);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'f') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(342);
      if (lookahead == 's') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'i') ADVANCE(348);
      if (lookahead == 's') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(350);
      if (lookahead == 'n') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'l') ADVANCE(352);
      if (lookahead == 'n') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'n') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'u') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(359);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(398);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(443);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == '=') ADVANCE(436);
      if (lookahead == '>') ADVANCE(451);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(443);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == '=') ADVANCE(436);
      if (lookahead == '>') ADVANCE(450);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(443);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == '>') ADVANCE(450);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(443);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(443);
      if (lookahead == '=') ADVANCE(436);
      if (lookahead == '>') ADVANCE(451);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(443);
      if (lookahead == '=') ADVANCE(436);
      if (lookahead == '>') ADVANCE(450);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(443);
      if (lookahead == '>') ADVANCE(450);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(436);
      if (lookahead == '>') ADVANCE(234);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(444);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(444);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (lookahead == '=') ADVANCE(435);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(444);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(444);
      if (lookahead == '=') ADVANCE(435);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(273);
      if (lookahead == '0') ADVANCE(455);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(435);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(432);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '/') ADVANCE(585);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '/') ADVANCE(585);
      if (lookahead == '=') ADVANCE(433);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(434);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(441);
      if (lookahead == '|') ADVANCE(387);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(387);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(440);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(388);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(388);
      if (lookahead == '=') ADVANCE(439);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(402);
      if (lookahead == '>') ADVANCE(412);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(402);
      if (lookahead == '>') ADVANCE(413);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(442);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(411);
      if (lookahead == '=') ADVANCE(404);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(411);
      if (lookahead == '=') ADVANCE(403);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(410);
      if (lookahead == '=') ADVANCE(404);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(410);
      if (lookahead == '=') ADVANCE(403);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(437);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(438);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(416);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(416);
      if (lookahead == ']') ADVANCE(596);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(596);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(397);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '1') ADVANCE(519);
      if (lookahead == '3') ADVANCE(517);
      if (lookahead == '6') ADVANCE(518);
      if (lookahead == '8') ADVANCE(528);
      if (lookahead == '\\') ADVANCE(254);
      if (lookahead == 'p') ADVANCE(577);
      if (sym_identifier_character_set_11(lookahead)) ADVANCE(583);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_primitive_type);
      if (lookahead == '\\') ADVANCE(254);
      if (sym_identifier_character_set_11(lookahead)) ADVANCE(583);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(415);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '.') ADVANCE(241);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '.') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(452);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(452);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(452);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_DOT_STAR);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '*') ADVANCE(594);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(273);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(466);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(465);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(452);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '.') ADVANCE(464);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(463);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(466);
      if (lookahead == 'b') ADVANCE(462);
      if (lookahead == 'x') ADVANCE(277);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(461);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(465);
      if (('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(454);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(274);
      if (lookahead == '.') ADVANCE(464);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(463);
      if (lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(466);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(461);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(465);
      if (('A' <= lookahead && lookahead <= 'D') ||
          ('a' <= lookahead && lookahead <= 'd')) ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(454);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(272);
      if (lookahead == '.') ADVANCE(464);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(466);
      if (lookahead == 'b') ADVANCE(238);
      if (lookahead == 'x') ADVANCE(237);
      if (lookahead == 'E' ||
          lookahead == 'P' ||
          lookahead == 'e' ||
          lookahead == 'p') ADVANCE(465);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(457);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_number_literal);
      if (lookahead == '\'') ADVANCE(272);
      if (lookahead == '.') ADVANCE(464);
      if (lookahead == 'F' ||
          lookahead == 'L' ||
          lookahead == 'U' ||
          lookahead == 'f' ||
          lookahead == 'l' ||
          lookahead == 'u') ADVANCE(466);
      if (lookahead == 'b') ADVANCE(272);
      if (lookahead == 'x') ADVANCE(277);
      if (lookahead == 'E' ||