# Fish shell completion for StGit (stg)
#
# To use, copy this file to one of the paths in $fish_complete_path, e.g.:
#
#   ~/.config/fish/completions
#
# This file is autogenerated.

function __fish_stg_all_branches
    command git for-each-ref --format='%(refname)' \
        refs/heads/ refs/remotes/ 2>/dev/null \
        | string replace -r '^refs/heads/(.*)$' '$1\tLocal Branch' \
        | string replace -r '^refs/remotes/(.*)$' '$1\tRemote Branch'
end

function __fish_stg_stg_branches
    command stg branch --list 2>/dev/null \
        | string match -r ". s.\t\S+" \
        | string replace -r ". s.\t" ""
end

function __fish_stg_applied_patches
    command stg series --no-description --noprefix --applied 2>/dev/null
end

function __fish_stg_other_applied_patches
    set -l top (command stg top 2>/dev/null)
    command stg series --no-description --noprefix --applied 2>/dev/null \
        | string match --invert "$top"
end

function __fish_stg_unapplied_patches
    command stg series --no-description --noprefix --unapplied 2>/dev/null
end

function __fish_stg_hidden_patches
    command stg series --no-description --noprefix --hidden 2>/dev/null
end

function __fish_stg_tags
    command git tag --sort=-creatordate 2>/dev/null
end

function __fish_stg_commit
    __fish_stg_all_branches __fish_stg_tags
end

function __fish_stg_conflicting_files
    command git ls-files --unmerged \
        | string replace -rf '^.*\t(.*)$' '$1' \
        | sort -u
end

function __fish_stg_dirty_files
    command git diff-index --name-only HEAD 2>/dev/null
end

function __fish_stg_unknown_files
    command git ls-files --others --exclude-standard 2>/dev/null
end

function __fish_stg_known_files
    command git ls-files 2>/dev/null
end

function __fish_stg_mail_aliases
    command git config --name-only --get-regexp "^mail\.alias\." \
    | cut -d. -f 3
end

function __fish_stg_is_alias
    set --local tokens (commandline -opc) (commandline -ct)
    if test "$tokens[1]" = "stg"
        switch "$tokens[2]"
            case add mv resolved rm status
                return 0
            case '*'
                return 1
        end
    end
end

function __fish_stg_complete_alias
    set --local tokens (commandline -opc) (commandline -ct)
    set --local cmd "$tokens[2]"
    set --erase tokens[1 2]
    switch "$cmd"
        case add
            set --prepend tokens git add
        case mv
            set --prepend tokens git mv
        case resolved
            set --prepend tokens git add
        case rm
            set --prepend tokens git rm
        case status
            set --prepend tokens git status -s
    end
    complete -C"$tokens"
end

### Aliases: add mv resolved rm status
complete    -c stg -n '__fish_stg_is_alias' -x -a '(__fish_stg_complete_alias)'
complete    -c stg -n '__fish_use_subcommand' -x -a add -d 'Alias for "git add"'
complete    -c stg -n '__fish_use_subcommand' -x -a mv -d 'Alias for "git mv"'
complete    -c stg -n '__fish_use_subcommand' -x -a resolved -d 'Alias for "git add"'
complete    -c stg -n '__fish_use_subcommand' -x -a rm -d 'Alias for "git rm"'
complete    -c stg -n '__fish_use_subcommand' -x -a status -d 'Alias for "git status -s"'

### help
complete -f -c stg -n '__fish_use_subcommand' -x -a help -d 'print the detailed command usage'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a branch -d 'Branch operations: switch, list, create, rename, delete, ...'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a clean -d 'Delete the empty patches in the series'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a clone -d 'Make a local clone of a remote repository'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a commit -d 'Permanently store the applied patches into the stack base'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a delete -d 'Delete patches'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a diff -d 'Show the tree diff'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a edit -d 'Edit a patch description or diff'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a export -d 'Export patches to a directory'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a files -d 'Show the files modified by a patch (or the current patch)'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a float -d 'Push patches to the top, even if applied'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a fold -d 'Integrate a GNU diff patch into the current patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a goto -d 'Push or pop patches to the given one'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a hide -d 'Hide a patch in the series'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a id -d 'Print the git hash value of a StGit reference'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a import -d 'Import a GNU diff file as a new patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a init -d 'Initialise the current branch for use with StGit'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a log -d 'Display or optionally clear the patch changelog'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a mail -d 'Send a patch or series of patches by e-mail'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a new -d 'Create a new, empty patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a next -d 'Print the name of the next patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a patches -d 'Show the applied patches modifying a file'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a pick -d 'Import a patch from a different branch or a commit object'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a pop -d 'Pop one or more patches from the stack'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a prev -d 'Print the name of the previous patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a pull -d 'Pull changes from a remote repository'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a push -d 'Push one or more patches onto the stack'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a rebase -d 'Move the stack base to another point in history'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a redo -d 'Undo the last undo operation'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a refresh -d 'Generate a new commit for the current patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a rename -d 'Rename a patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a repair -d 'Fix StGit metadata if branch was modified with git commands'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a reset -d 'Reset the patch stack to an earlier state'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a series -d 'Print the patch series'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a show -d 'Show the commit corresponding to a patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a sink -d 'Send patches deeper down the stack'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a squash -d 'Squash two or more patches into one'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a sync -d 'Synchronise patches with a branch or a series'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a top -d 'Print the name of the top patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a uncommit -d 'Turn regular git commits into StGit patches'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a undo -d 'Undo the last operation'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a unhide -d 'Unhide a hidden patch'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a add -d 'Alias for "git add"'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a mv -d 'Alias for "git mv"'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a resolved -d 'Alias for "git add"'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a rm -d 'Alias for "git rm"'
complete -f -c stg -n '__fish_seen_subcommand_from help' -a status -d 'Alias for "git status -s"'

### branch
complete    -c stg -n '__fish_use_subcommand' -x -a branch -d 'Branch operations: switch, list, create, rename, delete, ...'
complete -f -c stg -n '__fish_seen_subcommand_from branch' -ra '(__fish_stg_all_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from branch' -s h -l help -d 'show detailed help for branch'
complete -f -c stg -n '__fish_seen_subcommand_from branch' -s l -l list -d 'List the branches contained in this repository' 
complete -f -c stg -n '__fish_seen_subcommand_from branch' -s c -l create -d 'Create (and switch to) a new branch' 
complete -f -c stg -n '__fish_seen_subcommand_from branch'      -l clone -d 'Clone the contents of the current branch' 
complete -f -c stg -n '__fish_seen_subcommand_from branch' -s r -l rename -d 'Rename an existing branch' 
complete -f -c stg -n '__fish_seen_subcommand_from branch' -s p -l protect -d 'Prevent StGit from modifying a branch' 
complete -f -c stg -n '__fish_seen_subcommand_from branch' -s u -l unprotect -d 'Allow StGit to modify a branch' 
complete -f -c stg -n '__fish_seen_subcommand_from branch'      -l delete -d 'Delete a branch' 
complete -f -c stg -n '__fish_seen_subcommand_from branch'      -l cleanup -d 'Clean up the StGit metadata for a branch' 
complete -r -c stg -n '__fish_seen_subcommand_from branch' -s d -l description -d 'Set the branch description' 
complete -f -c stg -n '__fish_seen_subcommand_from branch'      -l merge -d 'Merge work tree changes into the other branch' 
complete -f -c stg -n '__fish_seen_subcommand_from branch'      -l force -d 'Force a delete when the series is not empty' 

### clean
complete    -c stg -n '__fish_use_subcommand' -x -a clean -d 'Delete the empty patches in the series'
complete -f -c stg -n '__fish_seen_subcommand_from clean' 
complete -f -c stg -n '__fish_seen_subcommand_from clean' -s h -l help -d 'show detailed help for clean'
complete -f -c stg -n '__fish_seen_subcommand_from clean' -s a -l applied -d 'Delete the empty applied patches' 
complete -f -c stg -n '__fish_seen_subcommand_from clean' -s u -l unapplied -d 'Delete the empty unapplied patches' 

### clone
complete    -c stg -n '__fish_use_subcommand' -x -a clone -d 'Make a local clone of a remote repository'
complete -r -c stg -n '__fish_seen_subcommand_from clone' 
complete -f -c stg -n '__fish_seen_subcommand_from clone' -s h -l help -d 'show detailed help for clone'

### commit
complete    -c stg -n '__fish_use_subcommand' -x -a commit -d 'Permanently store the applied patches into the stack base'
complete -f -c stg -n '__fish_seen_subcommand_from commit' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from commit' -s h -l help -d 'show detailed help for commit'
complete -r -c stg -n '__fish_seen_subcommand_from commit' -s n -l number -d 'Commit the specified number of patches' 
complete -f -c stg -n '__fish_seen_subcommand_from commit' -s a -l all -d 'Commit all applied patches' 
complete -f -c stg -n '__fish_seen_subcommand_from commit'      -l allow-empty -d 'Allow empty patches to be committed' 

### delete
complete    -c stg -n '__fish_use_subcommand' -x -a delete -d 'Delete patches'
complete -f -c stg -n '__fish_seen_subcommand_from delete' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from delete' -s h -l help -d 'show detailed help for delete'
complete -f -c stg -n '__fish_seen_subcommand_from delete'      -l spill -d 'Spill patch contents to worktree and index' 
complete -f -c stg -n '__fish_seen_subcommand_from delete' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from delete' -s t -l top -d 'Delete top patch' 

### diff
complete    -c stg -n '__fish_use_subcommand' -x -a diff -d 'Show the tree diff'
complete -f -c stg -n '__fish_seen_subcommand_from diff' -ra '(__fish_stg_known_files) (__fish_stg_dirty_files)'
complete -f -c stg -n '__fish_seen_subcommand_from diff' -s h -l help -d 'show detailed help for diff'
complete -f -c stg -n '__fish_seen_subcommand_from diff' -s r -l range -d 'Show the diff between revisions' -xa '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from diff' -s s -l stat -d 'Show the stat instead of the diff' 
complete -f -c stg -n '__fish_seen_subcommand_from diff' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'

### edit
complete    -c stg -n '__fish_use_subcommand' -x -a edit -d 'Edit a patch description or diff'
complete -f -c stg -n '__fish_seen_subcommand_from edit' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from edit' -s h -l help -d 'show detailed help for edit'
complete -f -c stg -n '__fish_seen_subcommand_from edit' -s d -l diff -d 'Edit the patch diff' 
complete -f -c stg -n '__fish_seen_subcommand_from edit' -s e -l edit -d 'Invoke interactive editor' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l sign -d 'Add "Signed-off-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l sign-by -d 'Add "Signed-off-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l ack -d 'Add "Acked-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l ack-by -d 'Add "Acked-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l review -d 'Add "Reviewed-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l review-by -d 'Add "Reviewed-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from edit' -s m -l message -d 'Use MESSAGE instead of invoking the editor' 
complete -r -c stg -n '__fish_seen_subcommand_from edit' -s f -l file -d 'Use FILE instead of invoking the editor' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l save-template -d 'Save the message template to FILE and exit' 
complete -f -c stg -n '__fish_seen_subcommand_from edit'      -l no-verify -d 'Disable commit-msg hook' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l author -d 'Set the author details' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l authname -d 'Set the author name' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l authemail -d 'Set the author email' 
complete -r -c stg -n '__fish_seen_subcommand_from edit'      -l authdate -d 'Set the author date' 
complete -f -c stg -n '__fish_seen_subcommand_from edit' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'
complete -r -c stg -n '__fish_seen_subcommand_from edit' -s t -l set-tree -d 'Set the git tree of the patch to TREE-ISH' 

### export
complete    -c stg -n '__fish_use_subcommand' -x -a export -d 'Export patches to a directory'
complete -f -c stg -n '__fish_seen_subcommand_from export' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from export' -s h -l help -d 'show detailed help for export'
complete -r -c stg -n '__fish_seen_subcommand_from export' -s d -l dir -d 'Export patches to DIR instead of the default' 
complete -f -c stg -n '__fish_seen_subcommand_from export' -s p -l patch -d 'Append .patch to the patch names' 
complete -r -c stg -n '__fish_seen_subcommand_from export' -s e -l extension -d 'Append .EXTENSION to the patch names' 
complete -f -c stg -n '__fish_seen_subcommand_from export' -s n -l numbered -d 'Prefix the patch names with order numbers' 
complete -r -c stg -n '__fish_seen_subcommand_from export' -s t -l template -d 'Use FILE as a template' 
complete -f -c stg -n '__fish_seen_subcommand_from export' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from export' -s s -l stdout -d 'Dump the patches to the standard output' 
complete -f -c stg -n '__fish_seen_subcommand_from export' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'

### files
complete    -c stg -n '__fish_use_subcommand' -x -a files -d 'Show the files modified by a patch (or the current patch)'
complete -f -c stg -n '__fish_seen_subcommand_from files' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from files' -s h -l help -d 'show detailed help for files'
complete -f -c stg -n '__fish_seen_subcommand_from files' -s s -l stat -d 'Show the diffstat' 
complete -f -c stg -n '__fish_seen_subcommand_from files'      -l bare -d 'Bare file names (useful for scripting)' 
complete -f -c stg -n '__fish_seen_subcommand_from files' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'

### float
complete    -c stg -n '__fish_use_subcommand' -x -a float -d 'Push patches to the top, even if applied'
complete -f -c stg -n '__fish_seen_subcommand_from float' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from float' -s h -l help -d 'show detailed help for float'
complete -f -c stg -n '__fish_seen_subcommand_from float'      -l noapply -d 'Reorder patches by floating without applying' 
complete -r -c stg -n '__fish_seen_subcommand_from float' -s s -l series -d 'Rearrange according to the series FILE' 
complete -f -c stg -n '__fish_seen_subcommand_from float' -s k -l keep -d 'Keep the local changes' 

### fold
complete    -c stg -n '__fish_use_subcommand' -x -a fold -d 'Integrate a GNU diff patch into the current patch'
complete -r -c stg -n '__fish_seen_subcommand_from fold' 
complete -f -c stg -n '__fish_seen_subcommand_from fold' -s h -l help -d 'show detailed help for fold'
complete -f -c stg -n '__fish_seen_subcommand_from fold' -s t -l threeway -d 'Perform a three-way merge with the current patch' 
complete -f -c stg -n '__fish_seen_subcommand_from fold' -s b -l base -d 'Use BASE instead of HEAD when applying the patch' -xa '(__fish_stg_commit)'
complete -r -c stg -n '__fish_seen_subcommand_from fold' -s p -l strip -d 'Remove N leading slashes from diff paths (default 1)' 
complete -r -c stg -n '__fish_seen_subcommand_from fold' -s C  -d 'Ensure N lines of surrounding context for each change' 
complete -f -c stg -n '__fish_seen_subcommand_from fold'      -l reject -d 'Leave the rejected hunks in corresponding *.rej files' 

### goto
complete    -c stg -n '__fish_use_subcommand' -x -a goto -d 'Push or pop patches to the given one'
complete -f -c stg -n '__fish_seen_subcommand_from goto' -ra '(__fish_stg_other_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from goto' -s h -l help -d 'show detailed help for goto'
complete -f -c stg -n '__fish_seen_subcommand_from goto' -s k -l keep -d 'Keep the local changes' 
complete -f -c stg -n '__fish_seen_subcommand_from goto' -s m -l merged -d 'Check for patches merged upstream' 

### hide
complete    -c stg -n '__fish_use_subcommand' -x -a hide -d 'Hide a patch in the series'
complete -f -c stg -n '__fish_seen_subcommand_from hide' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from hide' -s h -l help -d 'show detailed help for hide'
complete -f -c stg -n '__fish_seen_subcommand_from hide' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'

### id
complete    -c stg -n '__fish_use_subcommand' -x -a id -d 'Print the git hash value of a StGit reference'
complete -f -c stg -n '__fish_seen_subcommand_from id' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from id' -s h -l help -d 'show detailed help for id'

### import
complete    -c stg -n '__fish_use_subcommand' -x -a import -d 'Import a GNU diff file as a new patch'
complete -r -c stg -n '__fish_seen_subcommand_from import' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s h -l help -d 'show detailed help for import'
complete -f -c stg -n '__fish_seen_subcommand_from import' -s m -l mail -d 'Import the patch from a standard e-mail file' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s M -l mbox -d 'Import a series of patches from an mbox file' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s s -l series -d 'Import a series of patches' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s u -l url -d 'Import a patch from a URL' 
complete -r -c stg -n '__fish_seen_subcommand_from import' -s n -l name -d 'Use NAME as the patch name' 
complete -r -c stg -n '__fish_seen_subcommand_from import' -s p -l strip -d 'Remove N leading slashes from diff paths (default 1)' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s t -l stripname -d 'Strip numbering and extension from patch name' 
complete -r -c stg -n '__fish_seen_subcommand_from import' -s C  -d 'Ensure N lines of surrounding context for each change' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s i -l ignore -d 'Ignore the applied patches in the series' 
complete -f -c stg -n '__fish_seen_subcommand_from import'      -l replace -d 'Replace the unapplied patches in the series' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s b -l base -d 'Use BASE instead of HEAD for file importing' -xa '(__fish_stg_commit)'
complete -f -c stg -n '__fish_seen_subcommand_from import'      -l reject -d 'Leave the rejected hunks in corresponding *.rej files' 
complete -f -c stg -n '__fish_seen_subcommand_from import'      -l keep-cr -d 'Do not remove "\r" from email lines ending with "\r\n"' 
complete -f -c stg -n '__fish_seen_subcommand_from import'      -l message-id -d 'Create Message-Id trailer from Message-ID header' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s e -l edit -d 'Invoke an editor for the patch description' 
complete -f -c stg -n '__fish_seen_subcommand_from import' -s d -l showdiff -d 'Show the patch content in the editor buffer' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l author -d 'Set the author details' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l authname -d 'Set the author name' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l authemail -d 'Set the author email' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l authdate -d 'Set the author date' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l sign -d 'Add "Signed-off-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l sign-by -d 'Add "Signed-off-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l ack -d 'Add "Acked-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l ack-by -d 'Add "Acked-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l review -d 'Add "Reviewed-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from import'      -l review-by -d 'Add "Reviewed-by:" trailer with custom VALUE' 

### init
complete    -c stg -n '__fish_use_subcommand' -x -a init -d 'Initialise the current branch for use with StGit'
complete -f -c stg -n '__fish_seen_subcommand_from init' 
complete -f -c stg -n '__fish_seen_subcommand_from init' -s h -l help -d 'show detailed help for init'

### log
complete    -c stg -n '__fish_use_subcommand' -x -a log -d 'Display or optionally clear the patch changelog'
complete -f -c stg -n '__fish_seen_subcommand_from log' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from log' -s h -l help -d 'show detailed help for log'
complete -f -c stg -n '__fish_seen_subcommand_from log' -s b -l branch -d 'Use BRANCH instead of the default one' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from log' -s d -l diff -d 'Show the refresh diffs' 
complete -r -c stg -n '__fish_seen_subcommand_from log' -s n -l number -d 'Limit the output to NUMBER commits' 
complete -f -c stg -n '__fish_seen_subcommand_from log' -s f -l full -d 'Show the full commit ids' 
complete -f -c stg -n '__fish_seen_subcommand_from log' -s g -l graphical -d 'Run gitk instead of printing' 
complete -f -c stg -n '__fish_seen_subcommand_from log'      -l clear -d 'Clear the log history' 

### mail
complete    -c stg -n '__fish_use_subcommand' -x -a mail -d 'Send a patch or series of patches by e-mail'
complete -f -c stg -n '__fish_seen_subcommand_from mail' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s h -l help -d 'show detailed help for mail'
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s a -l all -d 'E-mail all the applied patches' 
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l to -d 'Add TO to the To: list' -xa '(__fish_stg_mail_aliases)'
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l cc -d 'Add CC to the Cc: list' -xa '(__fish_stg_mail_aliases)'
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l bcc -d 'Add BCC to the Bcc: list' -xa '(__fish_stg_mail_aliases)'
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l auto -d 'Automatically cc the patch signers' 
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l no-thread -d 'Do not send subsequent messages as replies' 
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l unrelated -d 'Send patches without sequence numbering' 
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l attach -d 'Send a patch as attachment' 
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l attach-inline -d 'Send a patch inline and as an attachment' 
complete -r -c stg -n '__fish_seen_subcommand_from mail' -s v -l version -d 'Add VERSION to the [PATCH ...] prefix' 
complete -r -c stg -n '__fish_seen_subcommand_from mail'      -l prefix -d 'Add PREFIX to the [... PATCH ...] prefix' 
complete -r -c stg -n '__fish_seen_subcommand_from mail' -s t -l template -d 'Use FILE as the message template' 
complete -r -c stg -n '__fish_seen_subcommand_from mail' -s c -l cover -d 'Send FILE as the cover message' 
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s e -l edit-cover -d 'Edit the cover message before sending' 
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s E -l edit-patches -d 'Edit each patch before sending' 
complete -r -c stg -n '__fish_seen_subcommand_from mail' -s s -l sleep -d 'Sleep for SECONDS between e-mails sending' 
complete -r -c stg -n '__fish_seen_subcommand_from mail'      -l in-reply-to -d 'Use REFID as the reference id' 
complete -r -c stg -n '__fish_seen_subcommand_from mail'      -l smtp-server -d 'SMTP server or command to use for sending mail' 
complete -r -c stg -n '__fish_seen_subcommand_from mail' -s u -l smtp-user -d 'Username for SMTP authentication' 
complete -r -c stg -n '__fish_seen_subcommand_from mail' -s p -l smtp-password -d 'Password for SMTP authentication' 
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s T -l smtp-tls -d 'Use SMTP with TLS encryption' 
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s m -l mbox -d 'Generate an mbox file instead of sending' 
complete -r -c stg -n '__fish_seen_subcommand_from mail'      -l domain -d 'Use DOMAIN when generating message IDs (instead of the system hostname)' 
complete -f -c stg -n '__fish_seen_subcommand_from mail'      -l git -d 'Use git send-email (EXPERIMENTAL)' 
complete -f -c stg -n '__fish_seen_subcommand_from mail' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'

### new
complete    -c stg -n '__fish_use_subcommand' -x -a new -d 'Create a new, empty patch'
complete -f -c stg -n '__fish_seen_subcommand_from new' 
complete -f -c stg -n '__fish_seen_subcommand_from new' -s h -l help -d 'show detailed help for new'
complete -f -c stg -n '__fish_seen_subcommand_from new' -s v -l verbose -d 'show diff in patch commit message template' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l author -d 'Set the author details' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l authname -d 'Set the author name' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l authemail -d 'Set the author email' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l authdate -d 'Set the author date' 
complete -r -c stg -n '__fish_seen_subcommand_from new' -s m -l message -d 'Use MESSAGE instead of invoking the editor' 
complete -r -c stg -n '__fish_seen_subcommand_from new' -s f -l file -d 'Use FILE instead of invoking the editor' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l save-template -d 'Save the message template to FILE and exit' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l sign -d 'Add "Signed-off-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l sign-by -d 'Add "Signed-off-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l ack -d 'Add "Acked-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l ack-by -d 'Add "Acked-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l review -d 'Add "Reviewed-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from new'      -l review-by -d 'Add "Reviewed-by:" trailer with custom VALUE' 
complete -f -c stg -n '__fish_seen_subcommand_from new'      -l no-verify -d 'Disable commit-msg hook' 

### next
complete    -c stg -n '__fish_use_subcommand' -x -a next -d 'Print the name of the next patch'
complete -f -c stg -n '__fish_seen_subcommand_from next' 
complete -f -c stg -n '__fish_seen_subcommand_from next' -s h -l help -d 'show detailed help for next'
complete -f -c stg -n '__fish_seen_subcommand_from next' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'

### patches
complete    -c stg -n '__fish_use_subcommand' -x -a patches -d 'Show the applied patches modifying a file'
complete -f -c stg -n '__fish_seen_subcommand_from patches' -ra '(__fish_stg_known_files)'
complete -f -c stg -n '__fish_seen_subcommand_from patches' -s h -l help -d 'show detailed help for patches'
complete -f -c stg -n '__fish_seen_subcommand_from patches' -s d -l diff -d 'Show the diff for the given files' 
complete -f -c stg -n '__fish_seen_subcommand_from patches' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from patches' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'

### pick
complete    -c stg -n '__fish_use_subcommand' -x -a pick -d 'Import a patch from a different branch or a commit object'
complete -f -c stg -n '__fish_seen_subcommand_from pick' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from pick' -s h -l help -d 'show detailed help for pick'
complete -r -c stg -n '__fish_seen_subcommand_from pick' -s n -l name -d 'Use NAME as the patch name' 
complete -f -c stg -n '__fish_seen_subcommand_from pick' -s B -l ref-branch -d 'Pick patches from BRANCH' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from pick' -s r -l revert -d 'Revert the given commit object' 
complete -f -c stg -n '__fish_seen_subcommand_from pick' -s p -l parent -d 'Use COMMITID as parent' -xa '(__fish_stg_commit)'
complete -f -c stg -n '__fish_seen_subcommand_from pick' -s x -l expose -d 'Append the imported commit id to the patch log' 
complete -f -c stg -n '__fish_seen_subcommand_from pick'      -l fold -d 'Fold the commit object into the current patch' 
complete -f -c stg -n '__fish_seen_subcommand_from pick'      -l update -d 'Like fold but only update the current patch files' 
complete -r -c stg -n '__fish_seen_subcommand_from pick' -s f -l file -d 'Only fold the given file (can be used multiple times)' 
complete -f -c stg -n '__fish_seen_subcommand_from pick'      -l noapply -d 'Keep the patch unapplied' 

### pop
complete    -c stg -n '__fish_use_subcommand' -x -a pop -d 'Pop one or more patches from the stack'
complete -f -c stg -n '__fish_seen_subcommand_from pop' -ra '(__fish_stg_applied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from pop' -s h -l help -d 'show detailed help for pop'
complete -f -c stg -n '__fish_seen_subcommand_from pop' -s a -l all -d 'Pop all the applied patches' 
complete -f -c stg -n '__fish_seen_subcommand_from pop' -s s -l spill -d 'Pop a patch, keeping its modifications in the tree' 
complete -r -c stg -n '__fish_seen_subcommand_from pop' -s n -l number -d 'Pop the specified number of patches' 
complete -f -c stg -n '__fish_seen_subcommand_from pop' -s k -l keep -d 'Keep the local changes' 

### prev
complete    -c stg -n '__fish_use_subcommand' -x -a prev -d 'Print the name of the previous patch'
complete -f -c stg -n '__fish_seen_subcommand_from prev' 
complete -f -c stg -n '__fish_seen_subcommand_from prev' -s h -l help -d 'show detailed help for prev'
complete -f -c stg -n '__fish_seen_subcommand_from prev' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'

### pull
complete    -c stg -n '__fish_use_subcommand' -x -a pull -d 'Pull changes from a remote repository'
complete -r -c stg -n '__fish_seen_subcommand_from pull' 
complete -f -c stg -n '__fish_seen_subcommand_from pull' -s h -l help -d 'show detailed help for pull'
complete -f -c stg -n '__fish_seen_subcommand_from pull' -s n -l nopush -d 'Do not push the patches back after pulling' 
complete -f -c stg -n '__fish_seen_subcommand_from pull' -s m -l merged -d 'Check for patches merged upstream' 

### push
complete    -c stg -n '__fish_use_subcommand' -x -a push -d 'Push one or more patches onto the stack'
complete -f -c stg -n '__fish_seen_subcommand_from push' -ra '(__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from push' -s h -l help -d 'show detailed help for push'
complete -f -c stg -n '__fish_seen_subcommand_from push' -s a -l all -d 'Push all the unapplied patches' 
complete -r -c stg -n '__fish_seen_subcommand_from push' -s n -l number -d 'Push the specified number of patches' 
complete -f -c stg -n '__fish_seen_subcommand_from push'      -l reverse -d 'Push the patches in reverse order' 
complete -f -c stg -n '__fish_seen_subcommand_from push'      -l noapply -d 'Reorder patches by pushing without applying' 
complete -f -c stg -n '__fish_seen_subcommand_from push'      -l set-tree -d 'Push the patch with the original tree' 
complete -f -c stg -n '__fish_seen_subcommand_from push' -s k -l keep -d 'Keep the local changes' 
complete -f -c stg -n '__fish_seen_subcommand_from push' -s m -l merged -d 'Check for patches merged upstream' 

### rebase
complete    -c stg -n '__fish_use_subcommand' -x -a rebase -d 'Move the stack base to another point in history'
complete -f -c stg -n '__fish_seen_subcommand_from rebase' -ra '(__fish_stg_commit)'
complete -f -c stg -n '__fish_seen_subcommand_from rebase' -s h -l help -d 'show detailed help for rebase'
complete -f -c stg -n '__fish_seen_subcommand_from rebase' -s i -l interactive -d 'Open an interactive editor to manipulate patches' 
complete -f -c stg -n '__fish_seen_subcommand_from rebase' -s n -l nopush -d 'Do not push the patches back after rebasing' 
complete -f -c stg -n '__fish_seen_subcommand_from rebase' -s m -l merged -d 'Check for patches merged upstream' 
complete -f -c stg -n '__fish_seen_subcommand_from rebase'      -l autostash -d 'Stash changes before the rebase and apply them after' 

### redo
complete    -c stg -n '__fish_use_subcommand' -x -a redo -d 'Undo the last undo operation'
complete -f -c stg -n '__fish_seen_subcommand_from redo' 
complete -f -c stg -n '__fish_seen_subcommand_from redo' -s h -l help -d 'show detailed help for redo'
complete -r -c stg -n '__fish_seen_subcommand_from redo' -s n -l number -d 'Undo the last N undos' 
complete -f -c stg -n '__fish_seen_subcommand_from redo'      -l hard -d 'Discard changes in your index/worktree' 

### refresh
complete    -c stg -n '__fish_use_subcommand' -x -a refresh -d 'Generate a new commit for the current patch'
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -ra '(__fish_stg_dirty_files)'
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s h -l help -d 'show detailed help for refresh'
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s u -l update -d 'Only update the current patch files' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s i -l index -d 'Refresh from index instead of worktree' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s F -l force -d 'Force refresh even if index is dirty' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s p -l patch -d 'Refresh (applied) PATCH instead of the top patch' -xa '(__fish_stg_other_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s e -l edit -d 'Invoke an editor for the patch description' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s d -l diff -d 'Show diff when editing patch description' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh' -s a -l annotate -d 'Annotate the patch log entry' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s s -l submodules -d 'Include submodules when refreshing patch contents' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh'      -l no-submodules -d 'Exclude submodules when refreshing patch contents' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh'      -l spill -d 'Spill patch content to worktree and index, erasing patch content.' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh' -s m -l message -d 'Use MESSAGE instead of invoking the editor' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh' -s f -l file -d 'Use FILE instead of invoking the editor' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh'      -l no-verify -d 'Disable commit-msg hook' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l sign -d 'Add "Signed-off-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l sign-by -d 'Add "Signed-off-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l ack -d 'Add "Acked-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l ack-by -d 'Add "Acked-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l review -d 'Add "Reviewed-by:" trailer' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l review-by -d 'Add "Reviewed-by:" trailer with custom VALUE' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l author -d 'Set the author details' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l authname -d 'Set the author name' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l authemail -d 'Set the author email' 
complete -r -c stg -n '__fish_seen_subcommand_from refresh'      -l authdate -d 'Set the author date' 
complete -f -c stg -n '__fish_seen_subcommand_from refresh' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'

### rename
complete    -c stg -n '__fish_use_subcommand' -x -a rename -d 'Rename a patch'
complete -f -c stg -n '__fish_seen_subcommand_from rename' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from rename' -s h -l help -d 'show detailed help for rename'
complete -f -c stg -n '__fish_seen_subcommand_from rename' -s b -l branch -d 'use BRANCH instead of the default one' -xa '(__fish_stg_stg_branches)'

### repair
complete    -c stg -n '__fish_use_subcommand' -x -a repair -d 'Fix StGit metadata if branch was modified with git commands'
complete -f -c stg -n '__fish_seen_subcommand_from repair' 
complete -f -c stg -n '__fish_seen_subcommand_from repair' -s h -l help -d 'show detailed help for repair'

### reset
complete    -c stg -n '__fish_use_subcommand' -x -a reset -d 'Reset the patch stack to an earlier state'
complete -f -c stg -n '__fish_seen_subcommand_from reset' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from reset' -s h -l help -d 'show detailed help for reset'
complete -f -c stg -n '__fish_seen_subcommand_from reset'      -l hard -d 'Discard changes in your index/worktree' 

### series
complete    -c stg -n '__fish_use_subcommand' -x -a series -d 'Print the patch series'
complete -f -c stg -n '__fish_seen_subcommand_from series' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from series' -s h -l help -d 'show detailed help for series'
complete -f -c stg -n '__fish_seen_subcommand_from series' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from series' -s a -l all -d 'Show all patches, including the hidden ones' 
complete -f -c stg -n '__fish_seen_subcommand_from series' -s A -l applied -d 'Show the applied patches only' 
complete -f -c stg -n '__fish_seen_subcommand_from series' -s U -l unapplied -d 'Show the unapplied patches only' 
complete -f -c stg -n '__fish_seen_subcommand_from series' -s H -l hidden -d 'Show the hidden patches only' 
complete -f -c stg -n '__fish_seen_subcommand_from series' -s m -l missing -d 'Show patches in BRANCH missing in current' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from series' -s c -l count -d 'Print the number of patches in the series' 
complete -f -c stg -n '__fish_seen_subcommand_from series' -s d -l description -d 'Show a short description for each patch' 
complete -f -c stg -n '__fish_seen_subcommand_from series'      -l no-description -d 'Inverse of --description' 
complete -f -c stg -n '__fish_seen_subcommand_from series'      -l author -d 'Show the author name for each patch' 
complete -f -c stg -n '__fish_seen_subcommand_from series' -s e -l empty -d 'Check whether patches are empty' 
complete -f -c stg -n '__fish_seen_subcommand_from series'      -l showbranch -d 'Append the branch name to the listed patches' 
complete -f -c stg -n '__fish_seen_subcommand_from series'      -l noprefix -d 'Do not show the patch status prefix' 
complete -f -c stg -n '__fish_seen_subcommand_from series' -s s -l short -d 'List just the patches around the topmost patch' 

### show
complete    -c stg -n '__fish_use_subcommand' -x -a show -d 'Show the commit corresponding to a patch'
complete -f -c stg -n '__fish_seen_subcommand_from show' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches) (__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from show' -s h -l help -d 'show detailed help for show'
complete -f -c stg -n '__fish_seen_subcommand_from show' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'
complete -f -c stg -n '__fish_seen_subcommand_from show' -s a -l applied -d 'Show the applied patches' 
complete -f -c stg -n '__fish_seen_subcommand_from show' -s u -l unapplied -d 'Show the unapplied patches' 
complete -f -c stg -n '__fish_seen_subcommand_from show' -s s -l stat -d 'Show a diffstat summary of the specified patches' 
complete -f -c stg -n '__fish_seen_subcommand_from show' -s O -l diff-opts -d 'Extra options to pass to "git diff"' -xa '-M -C'

### sink
complete    -c stg -n '__fish_use_subcommand' -x -a sink -d 'Send patches deeper down the stack'
complete -f -c stg -n '__fish_seen_subcommand_from sink' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from sink' -s h -l help -d 'show detailed help for sink'
complete -f -c stg -n '__fish_seen_subcommand_from sink' -s n -l nopush -d 'Do not push the patches back after sinking' 
complete -f -c stg -n '__fish_seen_subcommand_from sink' -s t -l to -d 'Sink patches below the TARGET patch' -xa '(__fish_stg_applied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from sink' -s k -l keep -d 'Keep the local changes' 

### squash
complete    -c stg -n '__fish_use_subcommand' -x -a squash -d 'Squash two or more patches into one'
complete -f -c stg -n '__fish_seen_subcommand_from squash' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from squash' -s h -l help -d 'show detailed help for squash'
complete -r -c stg -n '__fish_seen_subcommand_from squash' -s n -l name -d 'Name of squashed patch' 
complete -r -c stg -n '__fish_seen_subcommand_from squash' -s m -l message -d 'Use MESSAGE instead of invoking the editor' 
complete -r -c stg -n '__fish_seen_subcommand_from squash' -s f -l file -d 'Use FILE instead of invoking the editor' 
complete -r -c stg -n '__fish_seen_subcommand_from squash'      -l save-template -d 'Save the message template to FILE and exit' 
complete -f -c stg -n '__fish_seen_subcommand_from squash'      -l no-verify -d 'Disable commit-msg hook' 

### sync
complete    -c stg -n '__fish_use_subcommand' -x -a sync -d 'Synchronise patches with a branch or a series'
complete -f -c stg -n '__fish_seen_subcommand_from sync' -ra '(__fish_stg_applied_patches) (__fish_stg_unapplied_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from sync' -s h -l help -d 'show detailed help for sync'
complete -f -c stg -n '__fish_seen_subcommand_from sync' -s a -l all -d 'Synchronise all the applied patches' 
complete -f -c stg -n '__fish_seen_subcommand_from sync' -s B -l ref-branch -d 'Syncronise patches with BRANCH' -xa '(__fish_stg_stg_branches)'
complete -r -c stg -n '__fish_seen_subcommand_from sync' -s s -l series -d 'Syncronise patches with SERIES' 

### top
complete    -c stg -n '__fish_use_subcommand' -x -a top -d 'Print the name of the top patch'
complete -f -c stg -n '__fish_seen_subcommand_from top' 
complete -f -c stg -n '__fish_seen_subcommand_from top' -s h -l help -d 'show detailed help for top'
complete -f -c stg -n '__fish_seen_subcommand_from top' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'

### uncommit
complete    -c stg -n '__fish_use_subcommand' -x -a uncommit -d 'Turn regular git commits into StGit patches'
complete -f -c stg -n '__fish_seen_subcommand_from uncommit' 
complete -f -c stg -n '__fish_seen_subcommand_from uncommit' -s h -l help -d 'show detailed help for uncommit'
complete -r -c stg -n '__fish_seen_subcommand_from uncommit' -s n -l number -d 'Uncommit the specified number of commits' 
complete -f -c stg -n '__fish_seen_subcommand_from uncommit' -s t -l to -d 'Uncommit to the specified commit' -xa '(__fish_stg_commit)'
complete -f -c stg -n '__fish_seen_subcommand_from uncommit' -s x -l exclusive -d 'Exclude the commit specified by the --to option' 

### undo
complete    -c stg -n '__fish_use_subcommand' -x -a undo -d 'Undo the last operation'
complete -f -c stg -n '__fish_seen_subcommand_from undo' 
complete -f -c stg -n '__fish_seen_subcommand_from undo' -s h -l help -d 'show detailed help for undo'
complete -r -c stg -n '__fish_seen_subcommand_from undo' -s n -l number -d 'Undo the last N commands' 
complete -f -c stg -n '__fish_seen_subcommand_from undo'      -l hard -d 'Discard changes in your index/worktree' 

### unhide
complete    -c stg -n '__fish_use_subcommand' -x -a unhide -d 'Unhide a hidden patch'
complete -f -c stg -n '__fish_seen_subcommand_from unhide' -ra '(__fish_stg_hidden_patches)'
complete -f -c stg -n '__fish_seen_subcommand_from unhide' -s h -l help -d 'show detailed help for unhide'
complete -f -c stg -n '__fish_seen_subcommand_from unhide' -s b -l branch -d 'Use BRANCH instead of the default branch' -xa '(__fish_stg_stg_branches)'
