/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.factory;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

import org.springframework.config.java.naming.BeanNamingStrategy;


/** TODO: Eliminate as part of SJC-209 */
public interface JavaConfigBeanFactory extends ConfigurableListableBeanFactory, BeanDefinitionRegistry {

    boolean isCurrentlyInCreation(String beanName);

    /**
     * Overridden to exploit covariant return type.
     */
    DefaultListableBeanFactory getParentBeanFactory();

    void registerSingleton(String beanName, Object bean, BeanVisibility visibility);

    void registerBeanDefinition(String beanName, BeanDefinition beanDef, BeanVisibility visibility);

    void registerAlias(String beanName, String alias, BeanVisibility visibility);

    boolean containsBeanDefinition(String beanName, BeanVisibility visibility);

    BeanDefinition getBeanDefinition(String beanName, BeanVisibility visibility);

    BeanNamingStrategy getBeanNamingStrategy();
}
