/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.aware;

import static org.junit.Assert.*;

import org.junit.Test;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.support.ConfigurationSupport;

import test.common.beans.ITestBean;
import test.common.beans.TestBean;

import test.common.config.BaseConfiguration;


/** TODO: JAVADOC */
public class BeanFactoryAwareTests {

    @Test
    public void testBeanFactoryAware() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(BaseConfiguration.class);

        assertTrue(ctx.containsBean(BaseConfiguration.class.getName()));

        TestBean becky = (TestBean) ctx.getBean("becky");
        assertEquals("becky", becky.getName());
        assertSame(ctx.getBeanFactory(), becky.getBeanFactory());
    }


    @Test
    public void testBeanFactoryAwareConfiguration() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(BeanFactoryAwareConfiguration.class);

        ITestBean marriedToInjection = ctx.getBean(ITestBean.class, "marriedToInjection");
        TestBean spouse = ctx.getBean(TestBean.class, "spouse");
        assertNotNull(marriedToInjection.getSpouse());
        assertSame(spouse, marriedToInjection.getSpouse());
    }

    public static class BeanFactoryAwareConfiguration extends ConfigurationSupport {
        @Bean
        public TestBean spouse() { return new TestBean("spouse"); }

        @Bean
        public TestBean marriedToInjection() {
            TestBean tb = new TestBean();
            tb.setSpouse((TestBean) getBeanFactory().getBean("spouse"));
            return tb;
        }
    }

}
