/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.aware;

import org.junit.Assert;
import org.junit.Test;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;


/** TODO: JAVADOC */
public class ApplicationContextAwareTests {

    @Test
    public void testApplicationContextAwareCallbackWithGenericApplicationContext() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(ApplicationContextAwareConfiguration.class);
        ApplicationContextAwareImpl acai = (ApplicationContextAwareImpl) ctx.getBean("ai");
        Assert.assertNotNull("ApplicationContextAware callback must be honoured", acai.applicationContext);
    }

    @Configuration
    public static class ApplicationContextAwareConfiguration {
        @Bean
        public ApplicationContextAwareImpl ai() { return new ApplicationContextAwareImpl(); }
    }

    public static class ApplicationContextAwareImpl implements ApplicationContextAware {
        public ApplicationContext applicationContext;

        public void setApplicationContext(ApplicationContext ac) { this.applicationContext = ac; }
    }

}
