/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class S3ServiceException
extends Exception {
    private static final long serialVersionUID = 4788682643946844474L;
    private String xmlMessage = null;
    private String s3ErrorCode = null;
    private String s3ErrorMessage = null;
    private String s3ErrorRequestId = null;
    private String s3ErrorHostId = null;

    public S3ServiceException(String message, String xmlMessage) {
        super(message);
        this.parseS3XmlMessage(xmlMessage);
    }

    public S3ServiceException() {
    }

    public S3ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public S3ServiceException(String message) {
        super(message);
    }

    public S3ServiceException(Throwable cause) {
        super(cause);
    }

    public String toString() {
        return super.toString() + (this.xmlMessage != null ? " XML Error Message: " + this.xmlMessage : "");
    }

    private String findXmlElementText(String xmlMessage, String elementName) {
        Pattern pattern = Pattern.compile(".*<" + elementName + ">(.*)</" + elementName + ">.*");
        Matcher matcher = pattern.matcher(xmlMessage);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private void parseS3XmlMessage(String xmlMessage) {
        this.xmlMessage = xmlMessage = xmlMessage.replaceAll("\n", "");
        this.s3ErrorCode = this.findXmlElementText(xmlMessage, "Code");
        this.s3ErrorMessage = this.findXmlElementText(xmlMessage, "Message");
        this.s3ErrorRequestId = this.findXmlElementText(xmlMessage, "RequestId");
        this.s3ErrorHostId = this.findXmlElementText(xmlMessage, "HostId");
    }

    public String getS3ErrorCode() {
        return this.s3ErrorCode;
    }

    public String getS3ErrorMessage() {
        return this.s3ErrorMessage;
    }

    public String getS3ErrorHostId() {
        return this.s3ErrorHostId;
    }

    public String getS3ErrorRequestId() {
        return this.s3ErrorRequestId;
    }

    public String getXmlMessage() {
        return this.xmlMessage;
    }
}

