/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.StatusLine;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.boot.cli.command.init.InitializrServiceMetadata;
import org.springframework.boot.cli.command.init.ProjectGenerationRequest;
import org.springframework.boot.cli.command.init.ProjectGenerationResponse;
import org.springframework.boot.cli.command.init.ReportableException;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

class InitializrService {
    private static final String FILENAME_HEADER_PREFIX = "filename=\"";
    public static final String ACCEPT_META_DATA = "application/vnd.initializr.v2.1+json,application/vnd.initializr.v2+json";
    public static final String ACCEPT_SERVICE_CAPABILITIES = "text/plain,application/vnd.initializr.v2.1+json,application/vnd.initializr.v2+json";
    private HttpClient http;

    InitializrService() {
    }

    InitializrService(HttpClient http) {
        this.http = http;
    }

    protected HttpClient getHttp() {
        if (this.http == null) {
            this.http = HttpClientBuilder.create().useSystemProperties().build();
        }
        return this.http;
    }

    ProjectGenerationResponse generate(ProjectGenerationRequest request) throws IOException {
        Log.info((String)("Using service at " + request.getServiceUrl()));
        InitializrServiceMetadata metadata = this.loadMetadata(request.getServiceUrl());
        URI url = request.generateUrl(metadata);
        ClassicHttpResponse httpResponse = this.executeProjectGenerationRequest(url);
        HttpEntity httpEntity = httpResponse.getEntity();
        this.validateResponse(httpResponse, request.getServiceUrl());
        return this.createResponse(httpResponse, httpEntity);
    }

    InitializrServiceMetadata loadMetadata(String serviceUrl) throws IOException {
        ClassicHttpResponse httpResponse = this.executeInitializrMetadataRetrieval(serviceUrl);
        this.validateResponse(httpResponse, serviceUrl);
        return this.parseJsonMetadata(httpResponse.getEntity());
    }

    Object loadServiceCapabilities(String serviceUrl) throws IOException {
        HttpGet request = new HttpGet(serviceUrl);
        request.setHeader((Header)new BasicHeader("Accept", (Object)ACCEPT_SERVICE_CAPABILITIES));
        ClassicHttpResponse httpResponse = this.execute((HttpUriRequest)request, URI.create(serviceUrl), "retrieve help");
        this.validateResponse(httpResponse, serviceUrl);
        HttpEntity httpEntity = httpResponse.getEntity();
        ContentType contentType = ContentType.create((String)httpEntity.getContentType());
        if (contentType.getMimeType().equals("text/plain")) {
            return this.getContent(httpEntity);
        }
        return this.parseJsonMetadata(httpEntity);
    }

    private InitializrServiceMetadata parseJsonMetadata(HttpEntity httpEntity) throws IOException {
        try {
            return new InitializrServiceMetadata(this.getContentAsJson(httpEntity));
        }
        catch (JSONException ex) {
            throw new ReportableException("Invalid content received from server (" + ex.getMessage() + ")", (Throwable)ex);
        }
    }

    private void validateResponse(ClassicHttpResponse httpResponse, String serviceUrl) {
        if (httpResponse.getEntity() == null) {
            throw new ReportableException("No content received from server '" + serviceUrl + "'");
        }
        if (httpResponse.getCode() != 200) {
            throw this.createException(serviceUrl, httpResponse);
        }
    }

    private ProjectGenerationResponse createResponse(ClassicHttpResponse httpResponse, HttpEntity httpEntity) throws IOException {
        ProjectGenerationResponse response = new ProjectGenerationResponse(ContentType.create((String)httpEntity.getContentType()));
        response.setContent(FileCopyUtils.copyToByteArray((InputStream)httpEntity.getContent()));
        String fileName = this.extractFileName(httpResponse.getFirstHeader("Content-Disposition"));
        if (fileName != null) {
            response.setFileName(fileName);
        }
        return response;
    }

    private ClassicHttpResponse executeProjectGenerationRequest(URI url) {
        return this.execute((HttpUriRequest)new HttpGet(url), url, "generate project");
    }

    private ClassicHttpResponse executeInitializrMetadataRetrieval(String url) {
        HttpGet request = new HttpGet(url);
        request.setHeader((Header)new BasicHeader("Accept", (Object)ACCEPT_META_DATA));
        return this.execute((HttpUriRequest)request, URI.create(url), "retrieve metadata");
    }

    private ClassicHttpResponse execute(HttpUriRequest request, URI url, String description) {
        try {
            HttpHost host = HttpHost.create((URI)url);
            request.addHeader("User-Agent", (Object)("SpringBootCli/" + this.getClass().getPackage().getImplementationVersion()));
            return this.getHttp().executeOpen(host, (ClassicHttpRequest)request, null);
        }
        catch (IOException ex) {
            throw new ReportableException("Failed to " + description + " from service at '" + String.valueOf(url) + "' (" + ex.getMessage() + ")");
        }
    }

    private ReportableException createException(String url, ClassicHttpResponse httpResponse) {
        StatusLine statusLine = new StatusLine((HttpResponse)httpResponse);
        String message = "Initializr service call failed using '" + url + "' - service returned " + statusLine.getReasonPhrase();
        String error = this.extractMessage(httpResponse.getEntity());
        if (StringUtils.hasText((String)error)) {
            message = message + ": '" + error + "'";
        } else {
            int statusCode = statusLine.getStatusCode();
            message = message + " (unexpected " + statusCode + " error)";
        }
        throw new ReportableException(message);
    }

    private String extractMessage(HttpEntity entity) {
        if (entity != null) {
            try {
                JSONObject error = this.getContentAsJson(entity);
                if (error.has("message")) {
                    return error.getString("message");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private JSONObject getContentAsJson(HttpEntity entity) throws IOException, JSONException {
        return new JSONObject(this.getContent(entity));
    }

    private String getContent(HttpEntity entity) throws IOException {
        ContentType contentType = ContentType.create((String)entity.getContentType());
        Charset charset = contentType.getCharset();
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        byte[] content = FileCopyUtils.copyToByteArray((InputStream)entity.getContent());
        return new String(content, charset);
    }

    private String extractFileName(Header header) {
        int end;
        String value;
        int start;
        if (header != null && (start = (value = header.getValue()).indexOf(FILENAME_HEADER_PREFIX)) != -1 && (end = (value = value.substring(start + FILENAME_HEADER_PREFIX.length())).indexOf(34)) != -1) {
            return value.substring(0, end);
        }
        return null;
    }
}

