/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpringIntegrationCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"EnableIntegration"}) || AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"MessageEndpoint"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.integration.config.EnableIntegration"}).add(new String[]{"spring-boot-starter-integration"});
    }

    public void applyImports(ImportCustomizer imports) {
        imports.addImports(new String[]{"org.springframework.messaging.Message", "org.springframework.messaging.MessageChannel", "org.springframework.messaging.PollableChannel", "org.springframework.messaging.SubscribableChannel", "org.springframework.messaging.MessageHeaders", "org.springframework.integration.support.MessageBuilder", "org.springframework.integration.channel.DirectChannel", "org.springframework.integration.channel.QueueChannel", "org.springframework.integration.channel.ExecutorChannel", "org.springframework.integration.core.MessagingTemplate", "org.springframework.integration.config.EnableIntegration"});
        imports.addStarImports(new String[]{"org.springframework.integration.annotation"});
    }
}

