/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.archive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.cli.command.archive.ResourceMatcher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.AntPathMatcher;

class ResourceMatcher {
    private static final String[] DEFAULT_INCLUDES = new String[]{"public/**", "resources/**", "static/**", "templates/**", "META-INF/**", "*"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{".*", "repository/**", "build/**", "target/**", "**/*.jar", "**/*.groovy"};
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final List<String> includes;
    private final List<String> excludes;

    ResourceMatcher(List<String> includes, List<String> excludes) {
        this.includes = this.getOptions(includes, DEFAULT_INCLUDES);
        this.excludes = this.getOptions(excludes, DEFAULT_EXCLUDES);
    }

    List<MatchedResource> find(List<File> roots) throws IOException {
        ArrayList<MatchedResource> matchedResources = new ArrayList<MatchedResource>();
        for (File root : roots) {
            if (root.isFile()) {
                matchedResources.add(new MatchedResource(root, null));
                continue;
            }
            matchedResources.addAll(this.findInDirectory(root));
        }
        return matchedResources;
    }

    private List<MatchedResource> findInDirectory(File directory) throws IOException {
        ArrayList<MatchedResource> matchedResources = new ArrayList<MatchedResource>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new DirectoryResourceLoader(directory));
        for (String include : this.includes) {
            for (Resource candidate : resolver.getResources(include)) {
                MatchedResource matchedResource;
                File file = candidate.getFile();
                if (!file.isFile() || this.isExcluded(matchedResource = new MatchedResource(directory, file, null))) continue;
                matchedResources.add(matchedResource);
            }
        }
        return matchedResources;
    }

    private boolean isExcluded(MatchedResource matchedResource) {
        for (String exclude : this.excludes) {
            if (!this.pathMatcher.match(exclude, matchedResource.getName())) continue;
            return true;
        }
        return false;
    }

    private List<String> getOptions(List<String> values, String[] defaults) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LinkedHashSet<String> minus = new LinkedHashSet<String>();
        boolean deltasFound = false;
        for (String value : values) {
            if (value.startsWith("+")) {
                deltasFound = true;
                value = value.substring(1);
                result.add(value);
                continue;
            }
            if (value.startsWith("-")) {
                deltasFound = true;
                value = value.substring(1);
                minus.add(value);
                continue;
            }
            if (value.trim().isEmpty()) continue;
            result.add(value);
        }
        for (String value : defaults) {
            if (minus.contains(value) && deltasFound) continue;
            result.add(value);
        }
        return new ArrayList<String>(result);
    }
}

