/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.util.Date;
import slothLib.web.search.IRankedElement;
import slothLib.web.search.IWebElement;

public class YahooJpWebElement
implements IWebElement,
IRankedElement {
    private static final long serialVersionUID = 1L;
    int rank;
    String title;
    String summary;
    String url;
    String clickUrl;
    String mimeType;
    String modificationDate;
    String cacheUrl;
    String cacheSize;

    public YahooJpWebElement(int rank, String title, String summary, String url, String clickUrl, String mimeType, String modificationDate, String cacheUrl, String cacheSize) {
        this.rank = rank;
        this.title = title;
        this.summary = summary;
        this.url = url;
        this.clickUrl = clickUrl;
        this.mimeType = mimeType;
        this.modificationDate = modificationDate;
        this.cacheUrl = cacheUrl;
        this.cacheSize = cacheSize;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getUrl() {
        return this.url;
    }

    public String getClickUrl() {
        return this.clickUrl;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Date getModificationDate() {
        if (this.modificationDate != null && this.modificationDate.length() != 0) {
            return new Date();
        }
        try {
            return new Date((long)Double.parseDouble(this.modificationDate) / 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            return new Date();
        }
    }

    public String getCacheUrl() {
        return this.cacheUrl;
    }

    public int getCacheSize() {
        if (this.cacheSize != null && this.cacheSize.length() != 0) {
            try {
                return Integer.parseInt(this.cacheSize);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String getURL() {
        return this.getUrl();
    }

    @Override
    public String getDescription() {
        return this.getSummary();
    }

    public String toString() {
        return "Title: " + this.title + "\r\n" + "URL: " + this.url + "\r\n" + "Summary: " + this.summary;
    }

    @Override
    public int getRank() {
        return this.rank;
    }
}

