/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import slothLib.NLP.IPosTagger;
import slothLib.NLP.PosTaggedWord;
import slothLib.NLP.PosTaggerResult;
import slothLib.SlothLib;
import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;
import slothLib.portUtil.Redirector;

public class SSTaggerServer
implements IPosTagger {
    private static final String ssTaggerPathPropKey = "slothLib.NLP.SSTagger.ssTaggerPath";
    private static final String SSTAGER_PATH_DEFAULT = "/usr/local/bin/tagger";
    private static Process p;
    private static PrintWriter pw;
    private static LineNumberReader lnr;
    private static String sstaggerPath;
    private static Object lockObject;

    static {
        SlothLib.init();
        p = null;
        sstaggerPath = System.getProperty(ssTaggerPathPropKey, SSTAGER_PATH_DEFAULT);
        lockObject = "";
    }

    public SSTaggerServer() {
    }

    public SSTaggerServer(String sstaggerPath) {
        SSTaggerServer.setSSTaggerPath(sstaggerPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PosTaggerResult doSSTagger(String text) throws SlothLibException {
        ArrayList<PosTaggedWord> result = new ArrayList<PosTaggedWord>();
        Object object = lockObject;
        synchronized (object) {
            if (p == null) {
                SSTaggerServer.startProcess();
            }
            String[] splitText = text.split("\\n");
            try {
                String[] stringArray = splitText;
                int n = splitText.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] words;
                    String input = stringArray[n2];
                    System.err.println(input);
                    pw.println(input.trim());
                    pw.flush();
                    String line = lnr.readLine();
                    String[] stringArray2 = words = line.split(" ");
                    int n3 = words.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String w = stringArray2[n4];
                        int locSlash = w.lastIndexOf(47);
                        if (locSlash >= 1 && locSlash < w.length() - 1) {
                            String raw = w.substring(0, locSlash);
                            String pos = w.substring(locSlash + 1);
                            PosTaggedWord ptw = new PosTaggedWord(pos, raw);
                            result.add(ptw);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new PosTaggerResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startProcess() throws SlothLibException {
        if (PortUtil.isNullOrEmpty(sstaggerPath)) {
            throw new SlothLibException("tagger\u306e\u30d1\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Object object = lockObject;
        synchronized (object) {
            if (p == null) {
                try {
                    String absPath = new File(sstaggerPath).getAbsolutePath();
                    String installedDir = absPath.substring(0, absPath.lastIndexOf(File.separatorChar));
                    ProcessBuilder pb = new ProcessBuilder(sstaggerPath);
                    pb.directory(new File(installedDir));
                    p = pb.start();
                    lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                    pw = new PrintWriter((Writer)new OutputStreamWriter(p.getOutputStream()), true);
                    Redirector.redirect(p.getErrorStream(), null);
                }
                catch (IOException e) {
                    p = null;
                    throw new SlothLibException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopProcess() {
        Object object = lockObject;
        synchronized (object) {
            if (p != null) {
                p.destroy();
                p = null;
            }
        }
    }

    public static String getSSTaggerPath() {
        return sstaggerPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSSTaggerPath(String value) {
        if (!PortUtil.fileExists(value)) {
            throw new RuntimeException("tagger\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + value);
        }
        Object object = lockObject;
        synchronized (object) {
            sstaggerPath = value;
        }
    }

    @Override
    public PosTaggerResult doTagging(String text) throws SlothLibException {
        return SSTaggerServer.doSSTagger(text);
    }
}

