/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import slothLib.web.search.GoogleSOAPSearchAPI;
import slothLib.web.search.IWebElement;
import slothLib.web.search.IWebSearch;
import slothLib.web.search.IWebSearchResult;
import slothLib.web.search.LiveWebSearch;
import slothLib.web.search.WebSearchException;
import slothLib.web.search.YahooJpWebSearch;

public class MultiSearch {
    private Shell sShell = null;
    private Text target = null;
    private Button go = null;
    private Combo combo = null;
    private Browser browser = null;
    private List list = null;
    private IWebElement[] elements;

    private void createCombo() {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.combo = new Combo((Composite)this.sShell, 512);
        this.combo.add("Google");
        this.combo.add("Yahoo");
        this.combo.add("LiveSearch");
        this.combo.setText("--select--");
        this.combo.setLayoutData((Object)gridData);
    }

    private void createBrowser() {
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        gridData3.horizontalSpan = 2;
        gridData3.grabExcessVerticalSpace = true;
        this.browser = new Browser((Composite)this.sShell, 0);
        this.browser.setLayoutData((Object)gridData3);
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        MultiSearch thisClass = new MultiSearch();
        thisClass.createSShell();
        thisClass.sShell.open();
        while (!thisClass.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void createSShell() {
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 2;
        gridData4.verticalAlignment = 4;
        gridData4.horizontalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.sShell = new Shell();
        this.sShell.setText("MultiSearch");
        this.sShell.setLayout((Layout)gridLayout);
        this.sShell.setSize(new Point(298, 298));
        this.target = new Text((Composite)this.sShell, 2048);
        this.target.setLayoutData((Object)gridData2);
        this.go = new Button((Composite)this.sShell, 0);
        this.go.setText("Go");
        this.go.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("widgetSelected()" + MultiSearch.this.combo.getText());
                MultiSearch.this.searchAndDisplay(MultiSearch.this.target.getText(), MultiSearch.this.combo.getText());
            }
        });
        this.createCombo();
        this.list = new List((Composite)this.sShell, 512);
        this.list.setLayoutData((Object)gridData4);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = MultiSearch.this.elements[MultiSearch.this.list.getSelectionIndex()].getURL();
                MultiSearch.this.browser.setUrl(url);
            }
        });
        this.createBrowser();
    }

    private void searchAndDisplay(String text, String engine) {
        try {
            this.list.removeAll();
            this.elements = this.search(text, engine);
            if (this.elements == null) {
                System.err.println("--- the engine is not available ---");
                return;
            }
            StringBuffer sb = new StringBuffer();
            IWebElement[] iWebElementArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                IWebElement element = iWebElementArray[n2];
                sb.append(String.valueOf(element.getTitle()) + "\n");
                ++n2;
            }
            System.err.println(sb.toString());
            int index = 0;
            IWebElement[] iWebElementArray2 = this.elements;
            int n3 = this.elements.length;
            n = 0;
            while (n < n3) {
                IWebElement element = iWebElementArray2[n];
                this.list.add(element.getTitle(), index++);
                ++n;
            }
        }
        catch (WebSearchException e) {
            System.err.println(e.getMessage());
        }
    }

    private IWebElement[] search(String text, String engine) throws WebSearchException {
        IWebSearch ws;
        if (engine.equals("Google")) {
            ws = new GoogleSOAPSearchAPI();
        } else if (engine.equals("Yahoo")) {
            ws = new YahooJpWebSearch("slothlib");
        } else if (engine.equals("LiveSearch")) {
            ws = new LiveWebSearch();
        } else {
            return null;
        }
        IWebSearchResult result = ws.doSearch(text, 10);
        return result.getResultElements();
    }
}

