###############################################################################
#                                                                             #
# Copyright (C) 2003-2015 Edward d'Auvergne                                   #
#                                                                             #
# This file is part of the program relax (http://www.nmr-relax.com).          #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
###############################################################################

# Dependencies.
import dep_check

# Python module imports.
if dep_check.wx_module:
    import wx

# relax module imports.
from data_store import Relax_data_store; ds = Relax_data_store()


def reset():
    """Reset relax."""

    # Run the relax data storage object reset method.
    ds.__reset__()

    # Clean up and reset the GUI.
    if dep_check.wx_module:
        # The wx application.
        app = wx.GetApp()

        # Nothing to do.
        if app == None or not hasattr(app, 'gui'):
            return

        # Call the GUI reset.
        if hasattr(app.gui, 'reset'):
            app.gui.reset()
