/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quickfix.StringField;
import quickfix.field.BeginString;
import quickfix.field.SenderCompID;
import quickfix.field.SenderLocationID;
import quickfix.field.SenderSubID;
import quickfix.field.TargetCompID;
import quickfix.field.TargetLocationID;
import quickfix.field.TargetSubID;

public class SessionID {
    private static Pattern pattern = Pattern.compile("(.*?):(.*?)(?:/(.*?)|)(?:/(.*?)|)->(.*?)(?:/(.*?)|)(?:/(.*?)|)(?::(.*)|)");
    public static final String NOT_SET = "";
    private final String id;
    private final String beginString;
    private final String senderCompID;
    private final String senderSubID;
    private final String senderLocationID;
    private final String targetCompID;
    private final String targetSubID;
    private final String targetLocationID;
    private final String sessionQualifier;

    public SessionID(String beginString, String senderCompID, String senderSubID, String senderLocationID, String targetCompID, String targetSubID, String targetLocationID, String sessionQualifier) {
        this.beginString = SessionID.value(beginString);
        this.senderCompID = SessionID.value(senderCompID);
        this.senderSubID = SessionID.value(senderSubID);
        this.senderLocationID = SessionID.value(senderLocationID);
        this.targetCompID = SessionID.value(targetCompID);
        this.targetSubID = SessionID.value(targetSubID);
        this.targetLocationID = SessionID.value(targetLocationID);
        this.sessionQualifier = SessionID.value(sessionQualifier);
        this.id = this.createID();
    }

    public SessionID(BeginString beginString, SenderCompID senderCompID, SenderSubID senderSubID, SenderLocationID senderLocationID, TargetCompID targetCompID, TargetSubID targetSubID, TargetLocationID targetLocationID, String qualifier) {
        this(SessionID.value(beginString), SessionID.value(senderCompID), SessionID.value(senderSubID), SessionID.value(senderLocationID), SessionID.value(targetCompID), SessionID.value(targetSubID), SessionID.value(targetLocationID), SessionID.value(qualifier));
    }

    public SessionID(String beginString, String senderCompID, String senderSubID, String targetCompID, String targetSubID) {
        this(beginString, senderCompID, senderSubID, NOT_SET, targetCompID, targetSubID, NOT_SET, NOT_SET);
    }

    public SessionID(BeginString beginString, SenderCompID senderCompID, SenderSubID senderSubID, TargetCompID targetCompID, TargetSubID targetSubID) {
        this(SessionID.value(beginString), SessionID.value(senderCompID), SessionID.value(senderSubID), SessionID.value(targetCompID), SessionID.value(targetSubID));
    }

    public SessionID(String beginString, String senderCompID, String targetCompID, String qualifier) {
        this(beginString, senderCompID, NOT_SET, NOT_SET, targetCompID, NOT_SET, NOT_SET, qualifier);
    }

    public SessionID(BeginString beginString, SenderCompID senderCompID, TargetCompID targetCompID, String qualifier) {
        this(SessionID.value(beginString), SessionID.value(senderCompID), SessionID.value(targetCompID), SessionID.value(qualifier));
    }

    public SessionID(String beginString, String senderCompID, String targetCompID) {
        this(beginString, senderCompID, NOT_SET, NOT_SET, targetCompID, NOT_SET, NOT_SET, NOT_SET);
    }

    public SessionID(BeginString beginString, SenderCompID senderCompID, TargetCompID targetCompID) {
        this(SessionID.value(beginString), SessionID.value(senderCompID), SessionID.value(targetCompID));
    }

    public SessionID() {
        throw new UnsupportedOperationException("Unsupported QuickFIX feature: use constructor with arguments");
    }

    public SessionID(String id) {
        Matcher matcher = pattern.matcher(id);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid session ID string: " + id);
        }
        this.beginString = matcher.group(1);
        this.senderCompID = matcher.group(2);
        this.senderSubID = SessionID.value(matcher.group(3));
        this.senderLocationID = SessionID.value(matcher.group(4));
        this.targetCompID = matcher.group(5);
        this.targetSubID = SessionID.value(matcher.group(6));
        this.targetLocationID = SessionID.value(matcher.group(7));
        this.sessionQualifier = SessionID.value(matcher.group(8));
        this.id = this.createID();
    }

    public String getBeginString() {
        return this.beginString;
    }

    public String getSenderCompID() {
        return this.senderCompID;
    }

    public String getTargetCompID() {
        return this.targetCompID;
    }

    public String getSenderSubID() {
        return this.senderSubID;
    }

    public String getSenderLocationID() {
        return this.senderLocationID;
    }

    public String getTargetSubID() {
        return this.targetSubID;
    }

    public String getTargetLocationID() {
        return this.targetLocationID;
    }

    public String getSessionQualifier() {
        return this.sessionQualifier;
    }

    public boolean equals(Object object) {
        return object != null ? this.toString().equals(object.toString()) : false;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private String createID() {
        return this.beginString + ":" + this.senderCompID + (this.isSet(this.senderSubID) ? "/" + this.senderSubID : NOT_SET) + (this.isSet(this.senderLocationID) ? "/" + this.senderLocationID : NOT_SET) + "->" + this.targetCompID + (this.isSet(this.targetSubID) ? "/" + this.targetSubID : NOT_SET) + (this.isSet(this.targetLocationID) ? "/" + this.targetLocationID : NOT_SET) + (this.sessionQualifier != null && !this.sessionQualifier.equals(NOT_SET) ? ":" + this.sessionQualifier : NOT_SET);
    }

    private boolean isSet(String value) {
        return !value.equals(NOT_SET);
    }

    private static String value(StringField f) {
        return f != null ? f.getValue() : NOT_SET;
    }

    private static String value(String s) {
        return s == null ? NOT_SET : s;
    }

    public boolean isFIXT() {
        return "FIXT.1.1".equals(this.beginString);
    }

    public String fromString(String sessionIDString) {
        throw new UnsupportedOperationException("Unsupported QuickFIX feature: use SessionID constructor instead.");
    }
}

