/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import quickfix.Application;
import quickfix.BusinessRejectReasonText;
import quickfix.DataDictionary;
import quickfix.DataDictionaryProvider;
import quickfix.DoNotSend;
import quickfix.FieldException;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.InvalidMessage;
import quickfix.ListenerSupport;
import quickfix.Log;
import quickfix.LogFactory;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStore;
import quickfix.MessageStoreFactory;
import quickfix.MessageUtils;
import quickfix.RejectLogon;
import quickfix.Responder;
import quickfix.SessionException;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SessionRejectReasonText;
import quickfix.SessionSchedule;
import quickfix.SessionState;
import quickfix.SessionStateListener;
import quickfix.SystemTime;
import quickfix.UnsupportedMessageType;
import quickfix.UnsupportedVersion;
import quickfix.field.ApplVerID;
import quickfix.field.DefaultApplVerID;
import quickfix.field.Text;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    public static final String SETTING_HEARTBTINT = "HeartBtInt";
    public static final String SETTING_CHECK_LATENCY = "CheckLatency";
    public static final String SETTING_CHECK_COMP_ID = "CheckCompID";
    public static final String SETTING_MAX_LATENCY = "MaxLatency";
    public static final String SETTING_TEST_REQUEST_DELAY_MULTIPLIER = "TestRequestDelayMultiplier";
    public static final String SETTING_START_DAY = "StartDay";
    public static final String SETTING_END_DAY = "EndDay";
    public static final String SETTING_TIMEZONE = "TimeZone";
    public static final String SETTING_START_TIME = "StartTime";
    public static final String SETTING_END_TIME = "EndTime";
    public static final String SETTING_USE_DATA_DICTIONARY = "UseDataDictionary";
    public static final String SETTING_DATA_DICTIONARY = "DataDictionary";
    public static final String SETTING_TRANSPORT_DATA_DICTIONARY = "TransportDataDictionary";
    public static final String SETTING_APP_DATA_DICTIONARY = "AppDataDictionary";
    public static final String SETTING_VALIDATE_FIELDS_OUT_OF_ORDER = "ValidateFieldsOutOfOrder";
    public static final String SETTING_VALIDATE_FIELDS_HAVE_VALUES = "ValidateFieldsHaveValues";
    public static final String SETTING_LOGON_TIMEOUT = "LogonTimeout";
    public static final String SETTING_LOGOUT_TIMEOUT = "LogoutTimeout";
    public static final String SETTING_RESET_ON_LOGOUT = "ResetOnLogout";
    public static final String SETTING_RESET_ON_DISCONNECT = "ResetOnDisconnect";
    public static final String SETTING_MILLISECONDS_IN_TIMESTAMP = "MillisecondsInTimeStamp";
    public static final String SETTING_VALIDATE_USER_DEFINED_FIELDS = "ValidateUserDefinedFields";
    public static final String SETTING_RESET_ON_LOGON = "ResetOnLogon";
    public static final String SETTING_DESCRIPTION = "Description";
    public static final String SETTING_REFRESH_ON_LOGON = "RefreshOnLogon";
    public static final String SETTING_SEND_REDUNDANT_RESEND_REQUEST = "SendRedundantResendRequests";
    public static final String SETTING_PERSIST_MESSAGES = "PersistMessages";
    public static final String USE_CLOSED_RESEND_INTERVAL = "ClosedResendInterval";
    public static final String SETTING_ALLOW_UNKNOWN_MSG_FIELDS = "AllowUnknownMsgFields";
    public static final String SETTING_DEFAULT_APPL_VER_ID = "DefaultApplVerID";
    private static final Map<SessionID, Session> sessions = new HashMap<SessionID, Session>();
    private final Application application;
    private final SessionID sessionID;
    private final SessionSchedule sessionSchedule;
    private final MessageFactory messageFactory;
    private final SessionState state;
    private boolean enabled;
    private final String responderSync = "SessionResponderSync";
    private Responder responder;
    private long lastSessionTimeCheck = 0L;
    private boolean lastSessionTimeResult = false;
    private final DataDictionaryProvider dataDictionaryProvider;
    private final boolean checkLatency;
    private final int maxLatency;
    private final boolean resetOnLogon;
    private final boolean resetOnLogout;
    private final boolean resetOnDisconnect;
    private final boolean millisecondsInTimeStamp;
    private final boolean refreshMessageStoreAtLogon;
    private final boolean redundantResentRequestsAllowed;
    private final boolean persistMessages;
    private final boolean checkCompID;
    private final boolean useClosedRangeForResend;
    private final ListenerSupport stateListeners;
    private final SessionStateListener stateListener;
    private final AtomicReference<ApplVerID> targetDefaultApplVerID;
    private final DefaultApplVerID senderDefaultApplVerID;
    public static final int DEFAULT_MAX_LATENCY = 120;
    public static final double DEFAULT_TEST_REQUEST_DELAY_MULTIPLIER = 0.5;
    static /* synthetic */ Class class$quickfix$SessionStateListener;

    Session(Application application, MessageStoreFactory messageStoreFactory, SessionID sessionID, DataDictionaryProvider dataDictionaryProvider, SessionSchedule sessionSchedule, LogFactory logFactory, MessageFactory messageFactory, int heartbeatInterval) {
        this(application, messageStoreFactory, sessionID, dataDictionaryProvider, sessionSchedule, logFactory, messageFactory, heartbeatInterval, true, 120, true, false, false, false, false, true, false, true, false, 0.5, null);
    }

    Session(Application application, MessageStoreFactory messageStoreFactory, SessionID sessionID, DataDictionaryProvider dataDictionaryProvider, SessionSchedule sessionSchedule, LogFactory logFactory, MessageFactory messageFactory, int heartbeatInterval, boolean checkLatency, int maxLatency, boolean millisecondsInTimeStamp, boolean resetOnLogon, boolean resetOnLogout, boolean resetOnDisconnect, boolean refreshMessageStoreAtLogon, boolean checkCompID, boolean redundantResentRequestsAllowed, boolean persistMessages, boolean useClosedRangeForResend, double testRequestDelayMultiplier, DefaultApplVerID senderDefaultApplVerID) {
        Class<?> clazz = class$quickfix$SessionStateListener;
        if (clazz == null) {
            clazz = class$quickfix$SessionStateListener = new SessionStateListener[0].getClass().getComponentType();
        }
        this.stateListeners = new ListenerSupport(clazz);
        this.stateListener = (SessionStateListener)this.stateListeners.getMulticaster();
        this.targetDefaultApplVerID = new AtomicReference();
        this.application = application;
        this.sessionID = sessionID;
        this.sessionSchedule = sessionSchedule;
        this.checkLatency = checkLatency;
        this.maxLatency = maxLatency;
        this.resetOnLogon = resetOnLogon;
        this.resetOnLogout = resetOnLogout;
        this.resetOnDisconnect = resetOnDisconnect;
        this.millisecondsInTimeStamp = millisecondsInTimeStamp;
        this.refreshMessageStoreAtLogon = refreshMessageStoreAtLogon;
        this.dataDictionaryProvider = dataDictionaryProvider;
        this.messageFactory = messageFactory;
        this.checkCompID = checkCompID;
        this.redundantResentRequestsAllowed = redundantResentRequestsAllowed;
        this.persistMessages = persistMessages;
        this.useClosedRangeForResend = useClosedRangeForResend;
        this.senderDefaultApplVerID = senderDefaultApplVerID;
        this.state = new SessionState(this, logFactory != null ? logFactory.create(sessionID) : null, heartbeatInterval, heartbeatInterval != 0, messageStoreFactory.create(sessionID), testRequestDelayMultiplier);
        Session.registerSession(this);
        this.getLog().onEvent(new StringBuffer().append("Session ").append(sessionID).append(" schedule is ").append(sessionSchedule).toString());
        try {
            if (!this.checkSessionTime()) {
                this.getLog().onEvent(new StringBuffer().append("Session state is not current; resetting ").append(sessionID).toString());
                this.reset();
            }
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.getLog(), "error during session construction", (Throwable)e);
        }
        this.setEnabled(true);
        this.getLog().onEvent(new StringBuffer().append("Created session: ").append(sessionID).toString());
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponder(Responder responder) {
        String string = "SessionResponderSync";
        synchronized ("SessionResponderSync") {
            this.responder = responder;
            if (responder != null) {
                this.stateListener.onConnect();
            } else {
                this.stateListener.onDisconnect();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Responder getResponder() {
        String string = "SessionResponderSync";
        synchronized ("SessionResponderSync") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.responder;
        }
    }

    public boolean hasResponder() {
        return this.getResponder() != null;
    }

    private synchronized boolean checkSessionTime() throws IOException {
        if (this.sessionSchedule == null) {
            return true;
        }
        Date date = SystemTime.getDate();
        if (date.getTime() - this.lastSessionTimeCheck >= 1000L) {
            Date getSessionCreationTime = this.state.getCreationTime();
            this.lastSessionTimeResult = this.sessionSchedule.isSameSession(SystemTime.getUtcCalendar(date), SystemTime.getUtcCalendar(getSessionCreationTime));
            this.lastSessionTimeCheck = date.getTime();
            return this.lastSessionTimeResult;
        }
        return this.lastSessionTimeResult;
    }

    public static boolean sendToTarget(Message message) throws SessionNotFound {
        return Session.sendToTarget(message, "");
    }

    public static boolean sendToTarget(Message message, String qualifier) throws SessionNotFound {
        try {
            String senderCompID = message.getHeader().getString(49);
            String targetCompID = message.getHeader().getString(56);
            return Session.sendToTarget(message, senderCompID, targetCompID, qualifier);
        }
        catch (FieldNotFound e) {
            throw new SessionNotFound("missing sender or target company ID");
        }
    }

    public static boolean sendToTarget(Message message, String senderCompID, String targetCompID) throws SessionNotFound {
        return Session.sendToTarget(message, senderCompID, targetCompID, "");
    }

    public static boolean sendToTarget(Message message, String senderCompID, String targetCompID, String qualifier) throws SessionNotFound {
        try {
            return Session.sendToTarget(message, new SessionID(message.getHeader().getString(8), senderCompID, targetCompID, qualifier));
        }
        catch (SessionNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public static boolean sendToTarget(Message message, SessionID sessionID) throws SessionNotFound {
        Session session = Session.lookupSession(sessionID);
        if (session == null) {
            throw new SessionNotFound();
        }
        message.setSessionID(sessionID);
        return session.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerSession(Session session) {
        Map<SessionID, Session> map = sessions;
        synchronized (map) {
            sessions.put(session.getSessionID(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterSessions(List<SessionID> sessionIds) {
        Map<SessionID, Session> map = sessions;
        synchronized (map) {
            for (SessionID sessionId : sessionIds) {
                sessions.remove(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session lookupSession(SessionID sessionID) {
        Map<SessionID, Session> map = sessions;
        synchronized (map) {
            return sessions.get(sessionID);
        }
    }

    public void logon() {
        this.state.clearLogoutReason();
        this.setEnabled(true);
    }

    private synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void initializeHeader(Message.Header header) {
        this.state.setLastSentTime(SystemTime.currentTimeMillis());
        header.setString(8, this.sessionID.getBeginString());
        header.setString(49, this.sessionID.getSenderCompID());
        this.optionallySetID(header, 50, this.sessionID.getSenderSubID());
        this.optionallySetID(header, 142, this.sessionID.getSenderLocationID());
        header.setString(56, this.sessionID.getTargetCompID());
        this.optionallySetID(header, 57, this.sessionID.getTargetSubID());
        this.optionallySetID(header, 143, this.sessionID.getTargetLocationID());
        header.setInt(34, this.getExpectedSenderNum());
        this.insertSendingTime(header);
    }

    private void optionallySetID(Message.Header header, int field, String value) {
        if (!value.equals("")) {
            header.setString(field, value);
        }
    }

    private void insertSendingTime(Message.Header header) {
        boolean includeMillis = this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0 && this.millisecondsInTimeStamp;
        header.setUtcTimeStamp(52, SystemTime.getDate(), includeMillis);
    }

    public void logout() {
        this.setEnabled(false);
    }

    public void logout(String reason) {
        this.state.setLogoutReason(reason);
        this.logout();
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public boolean sentLogon() {
        return this.state.isLogonSent();
    }

    public boolean receivedLogon() {
        return this.state.isLogonReceived();
    }

    public boolean sentLogout() {
        return this.state.isLogoutSent();
    }

    public boolean receivedLogout() {
        return this.state.isLogoutReceived();
    }

    public boolean isLoggedOn() {
        return this.sentLogon() && this.receivedLogon();
    }

    private boolean isResetNeeded() {
        return this.sessionID.getBeginString().compareTo("FIX.4.1") >= 0 && (this.resetOnLogon || this.resetOnLogout || this.resetOnDisconnect) && this.getExpectedSenderNum() == 1 && this.getExpectedTargetNum() == 1;
    }

    public void reset() throws IOException {
        if (this.hasResponder()) {
            this.generateLogout();
            this.disconnect();
        }
        this.resetState();
    }

    public void setNextSenderMsgSeqNum(int num) throws IOException {
        this.state.getMessageStore().setNextSenderMsgSeqNum(num);
    }

    public void setNextTargetMsgSeqNum(int num) throws IOException {
        this.state.getMessageStore().setNextTargetMsgSeqNum(num);
    }

    public int getExpectedSenderNum() {
        try {
            return this.state.getMessageStore().getNextSenderMsgSeqNum();
        }
        catch (IOException e) {
            this.getLog().onEvent(new StringBuffer().append("getNextSenderMsgSeqNum failed: ").append(e.getMessage()).toString());
            return -1;
        }
    }

    public int getExpectedTargetNum() {
        try {
            return this.state.getMessageStore().getNextTargetMsgSeqNum();
        }
        catch (IOException e) {
            this.getLog().onEvent(new StringBuffer().append("getNextTargetMsgSeqNum failed: ").append(e.getMessage()).toString());
            return -1;
        }
    }

    public Log getLog() {
        return this.state.getLog();
    }

    public MessageStore getStore() {
        return this.state.getMessageStore();
    }

    public void next(Message message) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.checkSessionTime()) {
            this.reset();
            return;
        }
        Message.Header header = message.getHeader();
        String msgType = header.getString(35);
        try {
            String beginString = header.getString(8);
            if (!beginString.equals(this.sessionID.getBeginString())) {
                throw new UnsupportedVersion();
            }
            if (msgType.equals("A")) {
                if (this.sessionID.isFIXT()) {
                    this.targetDefaultApplVerID.set((Object)new ApplVerID(message.getString(1137)));
                } else {
                    this.targetDefaultApplVerID.set((Object)MessageUtils.toApplVerID(beginString));
                }
            }
            if (this.dataDictionaryProvider != null) {
                DataDictionary sessionDataDictionary = this.dataDictionaryProvider.getSessionDataDictionary(beginString);
                String customApplVerID = header.isSetField(1129) ? header.getString(1129) : null;
                ApplVerID applVerID = header.isSetField(1128) ? new ApplVerID(header.getString(1128)) : (ApplVerID)this.targetDefaultApplVerID.get();
                DataDictionary applicationDataDictionary = this.isAdminMessage(msgType) ? this.dataDictionaryProvider.getSessionDataDictionary(beginString) : this.dataDictionaryProvider.getApplicationDataDictionary(applVerID, customApplVerID);
                DataDictionary.validate(message, sessionDataDictionary, applicationDataDictionary);
            }
            if (msgType.equals("A")) {
                this.nextLogon(message);
            } else if (msgType.equals("0")) {
                this.nextHeartBeat(message);
            } else if (msgType.equals("1")) {
                this.nextTestRequest(message);
            } else if (msgType.equals("4")) {
                this.nextSequenceReset(message);
            } else if (msgType.equals("5")) {
                this.nextLogout(message);
            } else if (msgType.equals("2")) {
                this.nextResendRequest(message);
            } else if (msgType.equals("3")) {
                this.nextReject(message);
            } else {
                if (!this.verify(message)) {
                    return;
                }
                this.state.incrNextTargetMsgSeqNum();
            }
        }
        catch (FieldException e) {
            this.generateReject(message, e.getSessionRejectReason(), e.getField());
        }
        catch (FieldNotFound e) {
            if (this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0 && message.isApp()) {
                this.generateBusinessReject(message, 5, e.field);
            } else if (msgType.equals("A")) {
                this.getLog().onEvent("Required field missing from logon");
                this.disconnect();
            } else {
                this.generateReject(message, 1, e.field);
            }
        }
        catch (IncorrectDataFormat e) {
            this.generateReject(message, 6, e.field);
        }
        catch (IncorrectTagValue e) {
            this.generateReject(message, 5, e.field);
        }
        catch (InvalidMessage e) {
            this.getLog().onEvent(new StringBuffer().append("Skipping invalid message: ").append(e.getMessage()).toString());
        }
        catch (RejectLogon e) {
            String rejectMessage = e.getMessage() != null ? new StringBuffer().append(": ").append(e.getMessage()).toString() : "";
            this.getLog().onEvent(new StringBuffer().append("Logon rejected").append(rejectMessage).toString());
            if (e.isLogoutBeforeDisconnect()) {
                this.generateLogout(e.getMessage());
            }
            this.state.incrNextTargetMsgSeqNum();
            this.disconnect();
        }
        catch (UnsupportedMessageType e) {
            if (this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0) {
                this.generateBusinessReject(message, 3, 0);
            } else {
                this.generateReject(message, "Unsupported message type");
            }
        }
        catch (UnsupportedVersion e) {
            if (msgType.equals("5")) {
                this.nextLogout(message);
            } else {
                this.generateLogout("Incorrect BeginString");
                this.state.incrNextTargetMsgSeqNum();
                this.disconnect();
            }
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, "error processing message", (Throwable)e);
        }
        this.nextQueued();
        if (this.isLoggedOn()) {
            this.next();
        }
    }

    private boolean isStateRefreshNeeded(String msgType) {
        return this.refreshMessageStoreAtLogon && !this.state.isInitiator() && msgType.equals("A");
    }

    private void nextReject(Message reject) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(reject, false, true)) {
            return;
        }
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    private void nextResendRequest(Message resendRequest) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, InvalidMessage {
        if (!this.verify(resendRequest, false, false)) {
            return;
        }
        int beginSeqNo = resendRequest.getInt(7);
        int endSeqNo = resendRequest.getInt(16);
        this.getLog().onEvent(new StringBuffer().append("Received ResendRequest FROM: ").append(beginSeqNo).append(" TO: ").append(this.formatEndSeqNum(endSeqNo)).toString());
        String beginString = this.sessionID.getBeginString();
        int expectedSenderNum = this.getExpectedSenderNum();
        if (beginString.compareTo("FIX.4.2") >= 0 && endSeqNo == 0 || beginString.compareTo("FIX.4.2") <= 0 && endSeqNo == 999999 || endSeqNo >= expectedSenderNum) {
            endSeqNo = expectedSenderNum - 1;
        }
        if (!this.persistMessages) {
            int next = this.state.getNextSenderMsgSeqNum();
            if (++endSeqNo > next) {
                endSeqNo = next;
            }
            this.generateSequenceReset(beginSeqNo, endSeqNo);
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        this.state.get(beginSeqNo, endSeqNo, messages);
        int msgSeqNum = 0;
        int begin = 0;
        int current = beginSeqNo;
        for (String message : messages) {
            String msgType;
            Message msg = this.parseMessage(message);
            msgSeqNum = msg.getHeader().getInt(34);
            if (current != msgSeqNum && begin == 0) {
                begin = current;
            }
            if (this.isAdminMessage(msgType = msg.getHeader().getString(35))) {
                if (begin == 0) {
                    begin = msgSeqNum;
                }
            } else {
                this.initializeResendFields(msg);
                if (this.resendApproved(msg)) {
                    if (begin != 0) {
                        this.generateSequenceReset(begin, msgSeqNum);
                    }
                    this.getLog().onEvent(new StringBuffer().append("Resending Message: ").append(msgSeqNum).toString());
                    this.send(msg.toString());
                    begin = 0;
                } else if (begin == 0) {
                    begin = msgSeqNum;
                }
            }
            current = msgSeqNum + 1;
        }
        if (begin != 0) {
            this.generateSequenceReset(begin, msgSeqNum + 1);
        }
        if (endSeqNo > msgSeqNum) {
            int next = this.state.getNextSenderMsgSeqNum();
            if (++endSeqNo > next) {
                endSeqNo = next;
            }
            this.generateSequenceReset(beginSeqNo, endSeqNo);
        }
        if (!this.isTargetTooHigh(msgSeqNum = resendRequest.getHeader().getInt(34)) && !this.isTargetTooLow(msgSeqNum)) {
            this.state.incrNextTargetMsgSeqNum();
        }
    }

    private String formatEndSeqNum(int seqNo) {
        return seqNo == 0 ? "infinity" : Integer.toString(seqNo);
    }

    private boolean isAdminMessage(String msgType) {
        return msgType.length() == 1 && "0A12345".indexOf(msgType) != -1;
    }

    private Message parseMessage(String messageData) throws InvalidMessage {
        return MessageUtils.parse(this, messageData);
    }

    private boolean isTargetTooLow(int msgSeqNum) throws IOException {
        return msgSeqNum < this.state.getNextTargetMsgSeqNum();
    }

    private void generateSequenceReset(int beginSeqNo, int endSeqNo) throws FieldNotFound {
        Message sequenceReset = this.messageFactory.create(this.sessionID.getBeginString(), "4");
        int newSeqNo = endSeqNo;
        Message.Header header = sequenceReset.getHeader();
        header.setBoolean(43, true);
        this.initializeHeader(header);
        header.setUtcTimeStamp(122, header.getUtcTimeStamp(52));
        header.setInt(34, beginSeqNo);
        sequenceReset.setInt(36, newSeqNo);
        sequenceReset.setBoolean(123, true);
        this.sendRaw(sequenceReset, beginSeqNo);
        this.getLog().onEvent(new StringBuffer().append("Sent SequenceReset TO: ").append(newSeqNo).toString());
    }

    private boolean resendApproved(Message message) throws FieldNotFound {
        try {
            this.application.toApp(message, this.sessionID);
        }
        catch (DoNotSend e) {
            return false;
        }
        catch (Throwable t) {
            this.logApplicationException("toApp() during resend", t);
        }
        return true;
    }

    private void initializeResendFields(Message message) throws FieldNotFound {
        Message.Header header = message.getHeader();
        Date sendingTime = header.getUtcTimeStamp(52);
        header.setUtcTimeStamp(122, sendingTime);
        header.setBoolean(43, true);
        this.insertSendingTime(header);
    }

    private void logApplicationException(String location, Throwable t) {
        LogUtil.logThrowable(this.getLog(), new StringBuffer().append("Application exception in ").append(location).toString(), t);
    }

    private void nextLogout(Message logout) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (!this.verify(logout, false, false)) {
            return;
        }
        if (!this.state.isLogoutSent()) {
            this.getLog().onEvent("Received logout request");
            this.generateLogout();
            this.getLog().onEvent("Sent logout response");
        } else {
            this.getLog().onEvent("Received logout response");
        }
        this.state.setLogoutReceived(true);
        this.state.incrNextTargetMsgSeqNum();
        if (this.resetOnLogout) {
            this.resetState();
        }
        this.disconnect();
    }

    private void generateLogout() {
        this.generateLogout(null);
    }

    private void generateLogout(String text) {
        Message logout = this.messageFactory.create(this.sessionID.getBeginString(), "5");
        this.initializeHeader(logout.getHeader());
        if (text != null && !"".equals(text)) {
            logout.setString(58, text);
        }
        this.sendRaw(logout, 0);
        this.state.setLogoutSent(true);
    }

    private void nextSequenceReset(Message sequenceReset) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        boolean isGapFill = false;
        if (sequenceReset.isSetField(123)) {
            isGapFill = sequenceReset.getBoolean(123);
        }
        if (!this.verify(sequenceReset, isGapFill, isGapFill)) {
            return;
        }
        if (sequenceReset.isSetField(36)) {
            int newSequence = sequenceReset.getInt(36);
            this.getLog().onEvent(new StringBuffer().append("Received SequenceReset FROM: ").append(this.getExpectedTargetNum()).append(" TO: ").append(newSequence).toString());
            if (newSequence > this.getExpectedTargetNum()) {
                this.state.setNextTargetMsgSeqNum(newSequence);
            } else if (newSequence < this.getExpectedTargetNum()) {
                this.generateReject(sequenceReset, 5, 0);
            }
        }
    }

    private void generateReject(Message message, String str) throws FieldNotFound, IOException {
        String beginString = this.sessionID.getBeginString();
        Message reject = this.messageFactory.create(beginString, "3");
        Message.Header header = message.getHeader();
        reject.reverseRoute(header);
        this.initializeHeader(reject.getHeader());
        String msgType = header.getString(35);
        String msgSeqNum = header.getString(34);
        if (beginString.compareTo("FIX.4.2") >= 0) {
            reject.setString(372, msgType);
        }
        reject.setString(45, msgSeqNum);
        if (!(msgType.equals("A") || msgType.equals("4") || this.isPossibleDuplicate(message))) {
            this.state.incrNextTargetMsgSeqNum();
        }
        reject.setString(58, str);
        this.sendRaw(reject, 0);
        this.getLog().onEvent(new StringBuffer().append("Message ").append(msgSeqNum).append(" Rejected: ").append(str).toString());
    }

    private boolean isPossibleDuplicate(Message message) throws FieldNotFound {
        Message.Header header = message.getHeader();
        return header.isSetField(43) && header.getBoolean(43);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReject(Message message, int err, int field) throws IOException, FieldNotFound {
        String reason = SessionRejectReasonText.getMessage(err);
        if (!this.state.isLogonReceived()) {
            String errorMessage = new StringBuffer().append("Tried to send a reject while not logged on: ").append(reason).append(" (field ").append(field).append(")").toString();
            throw new SessionException(errorMessage);
        }
        String beginString = this.sessionID.getBeginString();
        Message reject = this.messageFactory.create(beginString, "3");
        Message.Header header = message.getHeader();
        reject.reverseRoute(header);
        this.initializeHeader(reject.getHeader());
        reject.setField(new Text(reason));
        String msgType = "";
        if (header.isSetField(35)) {
            msgType = header.getString(35);
        }
        int msgSeqNum = 0;
        if (header.isSetField(34)) {
            msgSeqNum = header.getInt(34);
            reject.setInt(45, msgSeqNum);
        }
        if (beginString.compareTo("FIX.4.2") >= 0) {
            if (!msgType.equals("")) {
                reject.setString(372, msgType);
            }
            if (beginString.equals("FIX.4.2") && err <= 11 || beginString.compareTo("FIX.4.2") > 0) {
                reject.setInt(373, err);
            }
        }
        this.state.lockTargetMsgSeqNum();
        try {
            if (!(msgType.equals("A") || msgType.equals("4") || msgSeqNum != this.getExpectedTargetNum() && this.isPossibleDuplicate(message))) {
                this.state.incrNextTargetMsgSeqNum();
            }
        }
        finally {
            this.state.unlockTargetMsgSeqNum();
        }
        if (reason != null && (field > 0 || err == 0)) {
            this.setRejectReason(reject, field, reason, true);
            this.getLog().onEvent(new StringBuffer().append("Message ").append(msgSeqNum).append(" Rejected: ").append(reason).append(":").append(field).toString());
        } else if (reason != null) {
            this.setRejectReason(reject, reason);
            this.getLog().onEvent(new StringBuffer().append("Message ").append(msgSeqNum).append(" Rejected: ").append(reason).toString());
        } else {
            this.getLog().onEvent(new StringBuffer().append("Message ").append(msgSeqNum).append(" Rejected").toString());
        }
        this.sendRaw(reject, 0);
    }

    private void setRejectReason(Message reject, String reason) {
        reject.setString(58, reason);
    }

    private void setRejectReason(Message reject, int field, String reason, boolean includeFieldInReason) {
        boolean isRejectMessage;
        try {
            isRejectMessage = "3".equals(reject.getHeader().getString(35));
        }
        catch (FieldNotFound e) {
            isRejectMessage = false;
        }
        if (isRejectMessage && this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0) {
            reject.setInt(371, field);
            reject.setString(58, reason);
        } else {
            reject.setString(58, new StringBuffer().append(reason).append(includeFieldInReason ? new StringBuffer().append(" (").append(field).append(")").toString() : "").toString());
        }
    }

    private void generateBusinessReject(Message message, int err, int field) throws FieldNotFound, IOException {
        Message reject = this.messageFactory.create(this.sessionID.getBeginString(), "j");
        this.initializeHeader(reject.getHeader());
        String msgType = message.getHeader().getString(35);
        String msgSeqNum = message.getHeader().getString(34);
        reject.setString(372, msgType);
        reject.setString(45, msgSeqNum);
        reject.setInt(380, err);
        this.state.incrNextTargetMsgSeqNum();
        String reason = BusinessRejectReasonText.getMessage(err);
        this.setRejectReason(reject, field, reason, field != 0);
        this.getLog().onEvent(new StringBuffer().append("Message ").append(msgSeqNum).append(reason != null ? new StringBuffer().append(" Rejected: ").append(reason).toString() : "").append(field != 0 ? new StringBuffer().append(": tag=").append(field).toString() : "").toString());
        this.sendRaw(reject, 0);
    }

    private void nextTestRequest(Message testRequest) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(testRequest)) {
            return;
        }
        this.generateHeartbeat(testRequest);
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    private void generateHeartbeat(Message testRequest) throws FieldNotFound {
        Message heartbeat = this.messageFactory.create(this.sessionID.getBeginString(), "0");
        this.initializeHeader(heartbeat.getHeader());
        if (testRequest.isSetField(112)) {
            heartbeat.setString(112, testRequest.getString(112));
        }
        this.sendRaw(heartbeat, 0);
    }

    private void nextHeartBeat(Message heartBeat) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(heartBeat)) {
            return;
        }
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify(Message msg, boolean checkTooHigh, boolean checkTooLow) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        String msgType;
        block14: {
            this.state.setLastReceivedTime(SystemTime.currentTimeMillis());
            this.state.clearTestRequestCounter();
            try {
                Message.Header header = msg.getHeader();
                String senderCompID = header.getString(49);
                String targetCompID = header.getString(56);
                Date sendingTime = header.getUtcTimeStamp(52);
                msgType = header.getString(35);
                int msgSeqNum = 0;
                if (checkTooHigh || checkTooLow) {
                    msgSeqNum = header.getInt(34);
                }
                if (!this.validLogonState(msgType)) {
                    throw new SessionException(new StringBuffer().append("Logon state is not valid for message (MsgType=").append(msgType).append(")").toString());
                }
                if (!this.isGoodTime(sendingTime)) {
                    this.doBadTime(msg);
                    return false;
                }
                if (!this.isCorrectCompID(senderCompID, targetCompID)) {
                    this.doBadCompID(msg);
                    return false;
                }
                if (checkTooHigh && this.isTargetTooHigh(msgSeqNum)) {
                    this.doTargetTooHigh(msg);
                    return false;
                }
                if (checkTooLow && this.isTargetTooLow(msgSeqNum)) {
                    this.doTargetTooLow(msg);
                    return false;
                }
                if (this.isPossibleDuplicate(msg) && !this.validatePossDup(msg)) {
                    return false;
                }
                if (!checkTooHigh && !checkTooLow || !this.state.isResendRequested()) break block14;
                Object object = this.state.getLock();
                synchronized (object) {
                    int[] range = this.state.getResendRange();
                    if (msgSeqNum >= range[1]) {
                        this.getLog().onEvent(new StringBuffer().append("ResendRequest for messages FROM ").append(range[0]).append(" TO ").append(range[1]).append(" has been satisfied.").toString());
                        this.state.setResendRange(0, 0);
                    }
                }
            }
            catch (FieldNotFound e) {
                throw e;
            }
            catch (Exception e) {
                this.getLog().onEvent(new StringBuffer().append(e.getClass().getName()).append(" ").append(e.getMessage()).toString());
                this.disconnect();
                return false;
            }
        }
        this.fromCallback(msgType, msg, this.sessionID);
        return true;
    }

    private boolean doTargetTooLow(Message msg) throws FieldNotFound, IOException {
        if (!this.isPossibleDuplicate(msg)) {
            int msgSeqNum = msg.getHeader().getInt(34);
            String text = new StringBuffer().append("MsgSeqNum too low, expecting ").append(this.getExpectedTargetNum()).append(" but received ").append(msgSeqNum).toString();
            this.generateLogout(text);
            throw new SessionException(text);
        }
        return this.validatePossDup(msg);
    }

    private void doBadCompID(Message msg) throws IOException, FieldNotFound {
        this.generateReject(msg, 9, 0);
        this.generateLogout();
    }

    private void doBadTime(Message msg) throws IOException, FieldNotFound {
        try {
            this.generateReject(msg, 10, 0);
            this.generateLogout();
        }
        catch (SessionException ex) {
            this.generateLogout(ex.getMessage());
            throw ex;
        }
    }

    private boolean isGoodTime(Date sendingTime) {
        if (!this.checkLatency) {
            return true;
        }
        return Math.abs(SystemTime.currentTimeMillis() - sendingTime.getTime()) / 1000L <= (long)this.maxLatency;
    }

    private void fromCallback(String msgType, Message msg, SessionID sessionID2) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (this.isAdminMessage(msgType)) {
            this.application.fromAdmin(msg, this.sessionID);
        } else {
            this.application.fromApp(msg, this.sessionID);
        }
    }

    private synchronized boolean validLogonState(String msgType) {
        if (msgType.equals("A") && this.state.isResetSent() || this.state.isResetReceived()) {
            return true;
        }
        if (msgType.equals("A") && !this.state.isLogonReceived() || !msgType.equals("A") && this.state.isLogonReceived()) {
            return true;
        }
        if (msgType.equals("5") && this.state.isLogonSent()) {
            return true;
        }
        if (!msgType.equals("5") && this.state.isLogoutSent()) {
            return true;
        }
        if (msgType.equals("4")) {
            return true;
        }
        return msgType.equals("3");
    }

    private boolean verify(Message message) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        return this.verify(message, true, true);
    }

    public void next() throws IOException {
        if (!this.isEnabled()) {
            if (this.isLoggedOn()) {
                if (!this.state.isLogoutSent()) {
                    this.getLog().onEvent("Initiated logout request");
                    this.generateLogout(this.state.getLogoutReason());
                }
            } else {
                return;
            }
        }
        if (!this.checkSessionTime()) {
            this.reset();
            return;
        }
        if (!this.hasResponder()) {
            return;
        }
        if (!this.state.isLogonReceived()) {
            if (this.state.isLogonSendNeeded()) {
                if (this.generateLogon()) {
                    this.getLog().onEvent("Initiated logon request");
                } else {
                    this.getLog().onEvent("Error during logon request initiation");
                }
            } else if (this.state.isLogonAlreadySent() && this.state.isLogonTimedOut()) {
                this.getLog().onEvent("Timed out waiting for logon response");
                this.disconnect();
            }
            return;
        }
        if (this.state.getHeartBeatInterval() == 0) {
            return;
        }
        if (this.state.isLogoutTimedOut()) {
            this.getLog().onEvent("Timed out waiting for logout response");
            this.disconnect();
        }
        if (this.state.isWithinHeartBeat()) {
            return;
        }
        if (this.state.isTimedOut()) {
            this.getLog().onEvent("Timed out waiting for heartbeat");
            this.disconnect();
            this.stateListener.onHeartBeatTimeout();
        } else if (this.state.isTestRequestNeeded()) {
            this.generateTestRequest("TEST");
            this.getLog().onEvent("Sent test request TEST");
            this.stateListener.onMissedHeartBeat();
        } else if (this.state.isHeartBeatNeeded()) {
            this.generateHeartbeat();
        }
    }

    private void generateHeartbeat() {
        Message heartbeat = this.messageFactory.create(this.sessionID.getBeginString(), "0");
        this.initializeHeader(heartbeat.getHeader());
        this.sendRaw(heartbeat, 0);
    }

    private void generateTestRequest(String id) {
        this.state.incrementTestRequestCounter();
        Message testRequest = this.messageFactory.create(this.sessionID.getBeginString(), "1");
        this.initializeHeader(testRequest.getHeader());
        testRequest.setString(112, id);
        this.sendRaw(testRequest, 0);
    }

    private boolean generateLogon() throws IOException {
        Message logon = this.messageFactory.create(this.sessionID.getBeginString(), "A");
        logon.setInt(98, 0);
        logon.setInt(108, this.state.getHeartBeatInterval());
        if (this.sessionID.isFIXT()) {
            logon.setField(1137, this.senderDefaultApplVerID);
        }
        if (this.isStateRefreshNeeded("A")) {
            this.getLog().onEvent("Refreshing message/state store at logon");
            this.getStore().refresh();
            this.stateListener.onRefresh();
        }
        if (this.resetOnLogon) {
            this.resetState();
        }
        if (this.isResetNeeded()) {
            logon.setBoolean(141, true);
        }
        this.state.setLastReceivedTime(SystemTime.currentTimeMillis());
        this.state.clearTestRequestCounter();
        this.state.setLogonSent(true);
        return this.sendRaw(logon, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        String string = "SessionResponderSync";
        synchronized ("SessionResponderSync") {
            if (!this.hasResponder()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.getLog().onEvent("Disconnecting");
            this.responder.disconnect();
            this.setResponder(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            boolean logonReceived = this.state.isLogonReceived();
            boolean logonSent = this.state.isLogonSent();
            if (logonReceived || logonSent) {
                this.state.setLogonReceived(false);
                this.state.setLogonSent(false);
                try {
                    this.application.onLogout(this.sessionID);
                }
                catch (Throwable t) {
                    this.logApplicationException("onLogout()", t);
                }
                this.stateListener.onLogout();
            }
            this.state.setLogoutSent(false);
            this.state.setLogoutReceived(false);
            this.state.setResetReceived(false);
            this.state.setResetSent(false);
            this.state.clearQueue();
            this.state.clearLogoutReason();
            this.state.setResendRange(0, 0);
            if (this.resetOnDisconnect) {
                this.resetState();
            }
            return;
        }
    }

    private void nextLogon(Message logon) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        String senderCompID = logon.getHeader().getString(49);
        String targetCompID = logon.getHeader().getString(56);
        if (this.isStateRefreshNeeded("A")) {
            this.getLog().onEvent("Refreshing message/state store at logon");
            this.getStore().refresh();
            this.stateListener.onRefresh();
        }
        if (logon.isSetField(141)) {
            this.state.setResetReceived(logon.getBoolean(141));
        }
        if (this.state.isResetReceived()) {
            this.getLog().onEvent("Logon contains ResetSeqNumFlag=Y, resetting sequence numbers to 1");
            if (!this.state.isResetSent()) {
                this.resetState();
            }
        }
        if (this.state.isLogonSendNeeded() && !this.state.isResetReceived()) {
            this.getLog().onEvent("Received logon response before sending request");
            this.disconnect();
            return;
        }
        if (!this.state.isInitiator() && this.resetOnLogon) {
            this.resetState();
        }
        if (!this.verify(logon, false, true)) {
            return;
        }
        this.state.setLogonReceived(true);
        if (this.isCorrectCompID(senderCompID, targetCompID)) {
            this.state.setLogonReceived(true);
        }
        this.getLog().onEvent("Received logon request");
        if (!this.state.isInitiator()) {
            this.generateLogon(logon);
            this.getLog().onEvent("Responding to logon request");
        }
        if (this.state.isResetSent() && !this.state.isResetReceived()) {
            this.getLog().onEvent("Invalid sequence reset response in logon (missing 141=Y?): disconnecting");
            this.disconnect();
        }
        this.state.setResetSent(false);
        this.state.setResetReceived(false);
        int sequence = logon.getHeader().getInt(34);
        if (this.isTargetTooHigh(sequence) && !this.resetOnLogon) {
            this.doTargetTooHigh(logon);
        } else {
            this.state.incrNextTargetMsgSeqNum();
            this.nextQueued();
        }
        if (this.isLoggedOn()) {
            try {
                this.application.onLogon(this.sessionID);
            }
            catch (Throwable t) {
                this.logApplicationException("onLogon()", t);
            }
            this.stateListener.onLogon();
        }
    }

    private void nextQueued() throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        while (this.nextQueued(this.getExpectedTargetNum())) {
        }
    }

    private boolean nextQueued(int num) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        Message msg = this.state.dequeue(num);
        if (msg != null) {
            this.getLog().onEvent(new StringBuffer().append("Processing queued message: ").append(num).append(", pending: ").append(this.state.getQueuedSeqNums()).toString());
            String msgType = msg.getHeader().getString(35);
            if (msgType.equals("A") || msgType.equals("2")) {
                this.state.incrNextTargetMsgSeqNum();
            } else {
                this.next(msg.toString());
            }
            return true;
        }
        return false;
    }

    private void next(String msg) throws InvalidMessage, FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        try {
            this.next(this.parseMessage(msg));
        }
        catch (InvalidMessage e) {
            String message = e.getMessage();
            this.getLog().onEvent(message);
            if ("A".equals(MessageUtils.getMessageType(msg))) {
                this.getLog().onEvent("Logon message is not valid");
                this.disconnect();
            }
            throw e;
        }
    }

    private void doTargetTooHigh(Message msg) throws FieldNotFound {
        Message.Header header = msg.getHeader();
        String beginString = header.getString(8);
        int msgSeqNum = header.getInt(34);
        this.getLog().onEvent(new StringBuffer().append("MsgSeqNum too high, expecting ").append(this.getExpectedTargetNum()).append(" but received ").append(msgSeqNum).toString());
        this.state.enqueue(msgSeqNum, msg);
        if (this.state.isResendRequested()) {
            int[] range = this.state.getResendRange();
            if (!this.redundantResentRequestsAllowed && msgSeqNum >= range[0]) {
                this.getLog().onEvent(new StringBuffer().append("Already sent ResendRequest FROM: ").append(range[0]).append(" TO: ").append(range[1]).append(".  Not sending another.").toString());
                return;
            }
        }
        this.generateResendRequest(beginString, msgSeqNum);
    }

    private void generateResendRequest(String beginString, int msgSeqNum) {
        Message resendRequest = this.messageFactory.create(beginString, "2");
        int beginSeqNo = this.getExpectedTargetNum();
        int endSeqNo = msgSeqNum - 1;
        if (!this.useClosedRangeForResend) {
            if (beginString.compareTo("FIX.4.2") >= 0) {
                endSeqNo = 0;
            } else if (beginString.compareTo("FIX.4.1") <= 0) {
                endSeqNo = 999999;
            }
        }
        resendRequest.setInt(7, beginSeqNo);
        resendRequest.setInt(16, endSeqNo);
        this.initializeHeader(resendRequest.getHeader());
        this.sendRaw(resendRequest, 0);
        this.getLog().onEvent(new StringBuffer().append("Sent ResendRequest FROM: ").append(beginSeqNo).append(" TO: ").append(endSeqNo).toString());
        this.state.setResendRange(beginSeqNo, msgSeqNum - 1);
    }

    private boolean validatePossDup(Message msg) throws FieldNotFound, IOException {
        Message.Header header = msg.getHeader();
        String msgType = header.getString(35);
        Date sendingTime = header.getUtcTimeStamp(52);
        if (!msgType.equals("4")) {
            if (!header.isSetField(122)) {
                this.generateReject(msg, 1, 122);
                return false;
            }
            Date origSendingTime = header.getUtcTimeStamp(122);
            if (origSendingTime.compareTo(sendingTime) > 0) {
                this.generateReject(msg, 10, 0);
                this.generateLogout();
                return false;
            }
        }
        return true;
    }

    private boolean isTargetTooHigh(int sequence) throws IOException {
        return sequence > this.state.getNextTargetMsgSeqNum();
    }

    private void generateLogon(Message otherLogon) throws FieldNotFound {
        Message logon = this.messageFactory.create(this.sessionID.getBeginString(), "A");
        logon.setInt(98, 0);
        if (this.state.isResetReceived()) {
            logon.setBoolean(141, true);
        }
        logon.setInt(108, otherLogon.getInt(108));
        if (this.sessionID.isFIXT()) {
            logon.setField(this.senderDefaultApplVerID);
        }
        this.initializeHeader(logon.getHeader());
        this.sendRaw(logon, 0);
        this.state.setLogonSent(true);
    }

    /*
     * Exception decompiling
     */
    private boolean sendRaw(Message message, int num) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resetState() {
        this.state.reset();
        this.stateListener.onReset();
    }

    public boolean send(Message message) {
        message.getHeader().removeField(43);
        message.getHeader().removeField(122);
        return this.sendRaw(message, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean send(String messageString) {
        this.getLog().onOutgoing(messageString);
        String string = "SessionResponderSync";
        synchronized ("SessionResponderSync") {
            if (!this.hasResponder()) {
                this.getLog().onEvent("Attempt to send while not connected (message stored until connected).");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.getResponder().send(messageString);
        }
    }

    private boolean isCorrectCompID(String senderCompID, String targetCompID) {
        if (!this.checkCompID) {
            return true;
        }
        return this.sessionID.getSenderCompID().equals(targetCompID) && this.sessionID.getTargetCompID().equals(senderCompID);
    }

    public void setDataDictionary(DataDictionary dataDictionary) {
        throw new UnsupportedOperationException("Modification of session dictionary is not supported in QFJ");
    }

    public DataDictionary getDataDictionary() {
        if (!this.sessionID.isFIXT()) {
            return this.dataDictionaryProvider.getSessionDataDictionary(this.sessionID.getBeginString());
        }
        throw new SessionException("No default data dictionary for FIXT 1.1 and newer");
    }

    public DataDictionaryProvider getDataDictionaryProvider() {
        return this.dataDictionaryProvider;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public boolean isSessionTime() {
        return this.sessionSchedule.isSessionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesSessionExist(SessionID sessionID) {
        Map<SessionID, Session> map = sessions;
        synchronized (map) {
            return sessions.containsKey(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int numSessions() {
        Map<SessionID, Session> map = sessions;
        synchronized (map) {
            return sessions.size();
        }
    }

    public void setLogonTimeout(int seconds) {
        this.state.setLogonTimeout(seconds);
    }

    public void setLogoutTimeout(int seconds) {
        this.state.setLogoutTimeout(seconds);
    }

    public void setHeartBeatInterval(int heartbeatInterval) {
        this.state.setHeartBeatInterval(heartbeatInterval);
    }

    public boolean getCheckCompID() {
        return this.checkCompID;
    }

    public int getLogonTimeout() {
        return this.state.getLogonTimeout();
    }

    public int getLogoutTimeout() {
        return this.state.getLogoutTimeout();
    }

    public boolean getRedundantResentRequestsAllowed() {
        return this.redundantResentRequestsAllowed;
    }

    public boolean getRefreshOnLogon() {
        return this.refreshMessageStoreAtLogon;
    }

    public boolean getResetOnDisconnect() {
        return this.resetOnDisconnect;
    }

    public boolean getResetOnLogout() {
        return this.resetOnLogout;
    }

    public boolean isLogonAlreadySent() {
        return this.state.isLogonAlreadySent();
    }

    public boolean isLogonReceived() {
        return this.state.isLogonReceived();
    }

    public boolean isLogonSendNeeded() {
        return this.state.isLogonSendNeeded();
    }

    public boolean isLogonSent() {
        return this.state.isLogonSent();
    }

    public boolean isLogonTimedOut() {
        return this.state.isLogonTimedOut();
    }

    public boolean isLogoutReceived() {
        return this.state.isLogoutReceived();
    }

    public boolean isLogoutSent() {
        return this.state.isLogoutSent();
    }

    public boolean isLogoutTimedOut() {
        return this.state.isLogoutTimedOut();
    }

    public boolean isUsingDataDictionary() {
        return this.dataDictionaryProvider != null;
    }

    public Date getStartTime() throws IOException {
        return this.state.getCreationTime();
    }

    public double getTestRequestDelayMultiplier() {
        return this.state.getTestRequestDelayMultiplier();
    }

    public String toString() {
        String s = this.sessionID.toString();
        try {
            s = new StringBuffer().append(s).append("[in:").append(this.state.getNextTargetMsgSeqNum()).append(",out:").append(this.state.getNextSenderMsgSeqNum()).append("]").toString();
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, e.getMessage(), (Throwable)e);
        }
        return s;
    }

    public void addStateListener(SessionStateListener listener) {
        this.stateListeners.addListener(listener);
    }

    public void removeStateListener(SessionStateListener listener) {
        this.stateListeners.removeListener(listener);
    }

    public ApplVerID getSenderDefaultApplicationVersionID() {
        return new ApplVerID(this.senderDefaultApplVerID.getValue());
    }

    public ApplVerID getTargetDefaultApplicationVersionID() {
        return (ApplVerID)this.targetDefaultApplVerID.get();
    }
}

