/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang.Enum_;
import quickfix.SessionID;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static String fileAppendPath(String pathPrefix, String pathSuffix) {
        return new StringBuffer().append(pathPrefix).append(pathPrefix.endsWith(File.separator) ? "" : File.separator).append(pathSuffix).toString();
    }

    public static String sessionIdFileName(SessionID sessionID) {
        return new StringBuffer().append(sessionID.getBeginString()).append("-").append(sessionID.getSenderCompID()).append(FileUtil.optionalField("_", sessionID.getSenderSubID())).append(FileUtil.optionalField("_", sessionID.getSenderLocationID())).append("-").append(sessionID.getTargetCompID()).append(FileUtil.optionalField("_", sessionID.getTargetSubID())).append(FileUtil.optionalField("_", sessionID.getTargetLocationID())).append(FileUtil.optionalField("-", sessionID.getSessionQualifier())).toString();
    }

    private static String optionalField(String delim, String value) {
        return !value.equals("") ? new StringBuffer().append(delim).append(value).toString() : "";
    }

    public static InputStream open(Class<?> clazz, String name) {
        return FileUtil.open(clazz, name, new Location[]{Location.FILESYSTEM, Location.CONTEXT_RESOURCE, Location.CLASS_RESOURCE, Location.CLASSLOADER_RESOURCE, Location.URL});
    }

    public static InputStream open(Class<?> clazz, String name, Location[] locations) {
        InputStream in = null;
        for (int i = 0; i < locations.length; ++i) {
            switch (locations[i]) {
                case FILESYSTEM: {
                    try {
                        in = new FileInputStream(name);
                    }
                    catch (FileNotFoundException e) {}
                    break;
                }
                case CONTEXT_RESOURCE: {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    if (contextClassLoader == null) break;
                    in = contextClassLoader.getResourceAsStream(name);
                    break;
                }
                case CLASS_RESOURCE: {
                    if (clazz == null) break;
                    in = clazz.getResourceAsStream(name);
                    break;
                }
                case CLASSLOADER_RESOURCE: {
                    if (clazz == null) break;
                    in = clazz.getClassLoader().getResourceAsStream(name);
                    break;
                }
                case URL: {
                    try {
                        in = new URL(name).openStream();
                        break;
                    }
                    catch (MalformedURLException e) {
                        break;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (in != null) break;
        }
        return in;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Location
    extends Enum_<Location> {
        public static final Location FILESYSTEM = new Location("FILESYSTEM", 0);
        public static final Location CONTEXT_RESOURCE = new Location("CONTEXT_RESOURCE", 1);
        public static final Location CLASS_RESOURCE = new Location("CLASS_RESOURCE", 2);
        public static final Location CLASSLOADER_RESOURCE = new Location("CLASSLOADER_RESOURCE", 3);
        public static final Location URL = new Location("URL", 4);
        private static final /* synthetic */ Location[] $VALUES;
        static /* synthetic */ Class class$quickfix$FileUtil$Location;

        public static final Location[] values() {
            return (Location[])$VALUES.clone();
        }

        public static Location valueOf(String name) {
            Class<?> clazz = class$quickfix$FileUtil$Location;
            if (clazz == null) {
                clazz = class$quickfix$FileUtil$Location = new Location[0].getClass().getComponentType();
            }
            return (Location)Enum_.valueOf(clazz, name);
        }

        private Location() {
            super(var1_1, n);
        }

        static {
            $VALUES = new Location[]{FILESYSTEM, CONTEXT_RESOURCE, CLASS_RESOURCE, CLASSLOADER_RESOURCE, URL};
        }
    }
}

