/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.java4.net.sf.retrotranslator.runtime.format;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.Conversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.FormatContext;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang._Character;

abstract class DateTimeConversion
extends Conversion {
    DateTimeConversion() {
    }

    public static Map getConversions() {
        HashMap<Character, DateTimeConversion> map = new HashMap<Character, DateTimeConversion>();
        map.put(_Character.valueOf('H'), new PatternConversion("HH"));
        map.put(_Character.valueOf('I'), new PatternConversion("hh"));
        map.put(_Character.valueOf('k'), new PatternConversion("H"));
        map.put(_Character.valueOf('l'), new PatternConversion("h"));
        map.put(_Character.valueOf('M'), new PatternConversion("mm"));
        map.put(_Character.valueOf('S'), new PatternConversion("ss"));
        map.put(_Character.valueOf('L'), new PatternConversion("SSS"));
        map.put(_Character.valueOf('N'), new PatternConversion("SSS000000"));
        map.put(_Character.valueOf('p'), new PatternConversion("a", true));
        map.put(_Character.valueOf('z'), new TimeZoneOffsetConversion());
        map.put(_Character.valueOf('Z'), new PatternConversion("z"));
        map.put(_Character.valueOf('s'), new MillisConversion(1000L));
        map.put(_Character.valueOf('Q'), new MillisConversion(1L));
        map.put(_Character.valueOf('B'), new PatternConversion("MMMM"));
        map.put(_Character.valueOf('b'), new PatternConversion("MMM"));
        map.put(_Character.valueOf('h'), new PatternConversion("MMM"));
        map.put(_Character.valueOf('A'), new PatternConversion("EEEE"));
        map.put(_Character.valueOf('a'), new PatternConversion("EEE"));
        map.put(_Character.valueOf('C'), new CenturyConversion());
        map.put(_Character.valueOf('Y'), new PatternConversion("yyyy"));
        map.put(_Character.valueOf('y'), new PatternConversion("yy"));
        map.put(_Character.valueOf('j'), new PatternConversion("DDD"));
        map.put(_Character.valueOf('m'), new PatternConversion("MM"));
        map.put(_Character.valueOf('d'), new PatternConversion("dd"));
        map.put(_Character.valueOf('e'), new PatternConversion("d"));
        map.put(_Character.valueOf('R'), new PatternConversion("HH:mm"));
        map.put(_Character.valueOf('T'), new PatternConversion("HH:mm:ss"));
        map.put(_Character.valueOf('r'), new PatternConversion("hh:mm:ss a"));
        map.put(_Character.valueOf('D'), new PatternConversion("MM/dd/yy"));
        map.put(_Character.valueOf('F'), new PatternConversion("yyyy-MM-dd"));
        map.put(_Character.valueOf('c'), new PatternConversion("EEE MMM dd HH:mm:ss z yyyy"));
        return map;
    }

    public void format(FormatContext context) {
        context.assertNoPrecision();
        context.assertNoFlag('#');
        context.checkWidth();
        Object argument = context.getArgument();
        if (argument == null) {
            context.writePadded(String.valueOf(argument));
        } else {
            this.printf(context);
        }
    }

    protected abstract void printf(FormatContext var1);

    protected static Calendar getCalendar(FormatContext context) {
        Calendar calendar;
        Object argument = context.getArgument();
        if (argument instanceof Date) {
            calendar = new GregorianCalendar();
            calendar.setTime((Date)argument);
        } else if (argument instanceof Calendar) {
            calendar = (Calendar)argument;
        } else if (argument instanceof Long) {
            calendar = new GregorianCalendar();
            calendar.setTimeInMillis((Long)argument);
        } else {
            throw context.getConversionException();
        }
        return calendar;
    }

    private static class CenturyConversion
    extends DateTimeConversion {
        private CenturyConversion() {
        }

        protected void printf(FormatContext context) {
            int century = CenturyConversion.getCalendar(context).get(1) / 100;
            if (century < 10) {
                char[] chars = Integer.toString(century + 10).toCharArray();
                chars[0] = 48;
                context.writePadded(new String(chars));
            } else {
                context.writePadded(Integer.toString(century));
            }
        }
    }

    private static class TimeZoneOffsetConversion
    extends DateTimeConversion {
        private TimeZoneOffsetConversion() {
        }

        protected void printf(FormatContext context) {
            int offset = TimeZoneOffsetConversion.getCalendar(context).get(15) / 60000;
            StringBuffer builder = new StringBuffer(5).append(offset < 0 ? (char)'-' : '+');
            int value = offset < 0 ? -offset : offset;
            String s = Integer.toString(value / 60 * 100 + value % 60);
            for (int i = 4 - s.length(); i > 0; --i) {
                builder.append('0');
            }
            context.writePadded(builder.append(s).toString());
        }
    }

    private static class MillisConversion
    extends DateTimeConversion {
        private long divisor;

        public MillisConversion(long divisor) {
            this.divisor = divisor;
        }

        protected void printf(FormatContext context) {
            long millis;
            Object argument = context.getArgument();
            if (argument instanceof Date) {
                millis = ((Date)argument).getTime();
            } else if (argument instanceof Calendar) {
                millis = ((Calendar)argument).getTimeInMillis();
            } else if (argument instanceof Long) {
                millis = (Long)argument;
            } else {
                throw context.getConversionException();
            }
            context.writePadded(String.valueOf(millis / this.divisor));
        }
    }

    private static class PatternConversion
    extends DateTimeConversion {
        private String pattern;
        private boolean toLowerCase;

        public PatternConversion(String pattern) {
            this.pattern = pattern;
        }

        public PatternConversion(String pattern, boolean toLowerCase) {
            this.pattern = pattern;
            this.toLowerCase = toLowerCase;
        }

        protected void printf(FormatContext context) {
            Date date;
            Locale locale = context.getLocale();
            if (locale == null) {
                locale = Locale.US;
            }
            SimpleDateFormat format = new SimpleDateFormat(this.pattern, locale);
            Object argument = context.getArgument();
            if (argument instanceof Date) {
                date = (Date)argument;
            } else if (argument instanceof Calendar) {
                Calendar calendar = (Calendar)argument;
                format.setTimeZone(calendar.getTimeZone());
                date = calendar.getTime();
            } else if (argument instanceof Long) {
                date = new Date((Long)argument);
            } else {
                throw context.getConversionException();
            }
            String result = format.format(date);
            if (this.toLowerCase) {
                result = result.toLowerCase(locale);
            }
            context.writePadded(result);
        }
    }
}

