/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.DelayQueue;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.Executors;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.Future;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.RunnableScheduledFuture;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;

public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = Utils.nanoTime();

    final long now() {
        return Utils.nanoTime() - NANO_ORIGIN;
    }

    boolean canRunInCurrentRunState(boolean periodic) {
        return this.isRunningOrShutdown(periodic ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private void delayedExecute(RunnableScheduledFuture task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            super.getQueue().add(task);
            if (this.isShutdown() && !this.canRunInCurrentRunState(task.isPeriodic()) && this.remove(task)) {
                task.cancel(false);
            }
            this.prestartCoreThread();
        }
    }

    void reExecutePeriodic(RunnableScheduledFuture task) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(task);
            if (!this.canRunInCurrentRunState(true) && this.remove(task)) {
                task.cancel(false);
            }
            this.prestartCoreThread();
        }
    }

    void onShutdown() {
        BlockingQueue q = super.getQueue();
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            q.clear();
        } else {
            Object[] entries = q.toArray();
            for (int i = 0; i < entries.length; ++i) {
                RunnableScheduledFuture t;
                Object e = entries[i];
                if (!(e instanceof RunnableScheduledFuture) || !(!(t = (RunnableScheduledFuture)e).isPeriodic() ? !keepDelayed : !keepPeriodic) && !t.isCancelled() || !q.remove(t)) continue;
                t.cancel(false);
            }
        }
    }

    protected RunnableScheduledFuture decorateTask(Runnable runnable, RunnableScheduledFuture task) {
        return task;
    }

    protected RunnableScheduledFuture decorateTask(Callable callable, RunnableScheduledFuture task) {
        return task;
    }

    public ScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), handler);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, handler);
    }

    public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture t = this.decorateTask(callable, (RunnableScheduledFuture)new ScheduledFutureTask(callable, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(period)));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(-delay)));
        this.delayedExecute(t);
        return t;
    }

    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable task, Object result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Callable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
            this.tryTerminate();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
            this.tryTerminate();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void shutdown() {
        super.shutdown();
    }

    public List shutdownNow() {
        return super.shutdownNow();
    }

    public BlockingQueue getQueue() {
        return super.getQueue();
    }

    private static class DelayedWorkQueue
    extends AbstractCollection
    implements BlockingQueue {
        private final DelayQueue dq = new DelayQueue();

        private DelayedWorkQueue() {
        }

        public Object poll() {
            return this.dq.poll();
        }

        public Object peek() {
            return this.dq.peek();
        }

        public Object take() throws InterruptedException {
            return this.dq.take();
        }

        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.dq.poll(timeout, unit);
        }

        public boolean add(Object x) {
            return this.dq.add((RunnableScheduledFuture)x);
        }

        public boolean offer(Object x) {
            return this.dq.offer((RunnableScheduledFuture)x);
        }

        public void put(Object x) {
            this.dq.put((RunnableScheduledFuture)x);
        }

        public boolean offer(Object x, long timeout, TimeUnit unit) {
            return this.dq.offer((RunnableScheduledFuture)x, timeout, unit);
        }

        public Object remove() {
            return this.dq.remove();
        }

        public Object element() {
            return this.dq.element();
        }

        public void clear() {
            this.dq.clear();
        }

        public int drainTo(Collection c) {
            return this.dq.drainTo(c);
        }

        public int drainTo(Collection c, int maxElements) {
            return this.dq.drainTo(c, maxElements);
        }

        public int remainingCapacity() {
            return this.dq.remainingCapacity();
        }

        public boolean remove(Object x) {
            return this.dq.remove(x);
        }

        public boolean contains(Object x) {
            return this.dq.contains(x);
        }

        public int size() {
            return this.dq.size();
        }

        public boolean isEmpty() {
            return this.dq.isEmpty();
        }

        public Object[] toArray() {
            return this.dq.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.dq.toArray(array);
        }

        public Iterator iterator() {
            return new Iterator(){
                private Iterator it;
                {
                    this.it = dq.iterator();
                }

                public boolean hasNext() {
                    return this.it.hasNext();
                }

                public Object next() {
                    return this.it.next();
                }

                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    private class ScheduledFutureTask
    extends FutureTask
    implements RunnableScheduledFuture {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ScheduledFutureTask(Runnable r, Object result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, Object result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        public long getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return d;
        }

        public int compareTo(Object other) {
            Delayed otherd = (Delayed)other;
            if (otherd == this) {
                return 0;
            }
            if (otherd instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - otherd.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : ScheduledThreadPoolExecutor.this.now() - p;
        }

        public void run() {
            boolean periodic = this.isPeriodic();
            if (!ScheduledThreadPoolExecutor.this.canRunInCurrentRunState(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                ScheduledFutureTask.super.run();
            } else if (ScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                ScheduledThreadPoolExecutor.this.reExecutePeriodic(this);
            }
        }
    }
}

