/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.TransportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.FieldConvertError;
import quickfix.Initiator;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.field.converter.BooleanConverter;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.SessionConnector;
import quickfix.mina.initiator.IoSessionInitiator;
import quickfix.mina.ssl.SSLSupport;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSocketInitiator
extends SessionConnector
implements Initiator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<IoSessionInitiator> initiators = new HashSet<IoSessionInitiator>();

    protected AbstractSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory));
    }

    protected AbstractSocketInitiator(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        super(settings, sessionFactory);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers((boolean)false);
    }

    protected void createSessionInitiators(EventHandlingStrategy eventHandlingStrategy) throws ConfigError {
        try {
            this.createSessions();
            for (Session session : this.getSessionMap().values()) {
                SessionID sessionID = session.getSessionID();
                int reconnectingInterval = this.getReconnectIntervalInSeconds(sessionID);
                SocketAddress[] socketAddresses = this.getSocketAddresses(sessionID);
                if (socketAddresses.length == 0) {
                    throw new ConfigError("Must specify at least one socket address");
                }
                NetworkingOptions networkingOptions = new NetworkingOptions(this.getSettings().getSessionProperties(sessionID));
                boolean sslEnabled = false;
                if (this.getSettings().isSetting(sessionID, "SocketUseSSL")) {
                    sslEnabled = BooleanConverter.convert(this.getSettings().getString(sessionID, "SocketUseSSL"));
                }
                String keyStoreName = SSLSupport.getKeystoreName(this.getSettings(), sessionID);
                String keyStorePassword = SSLSupport.getKeystorePasswd(this.getSettings(), sessionID);
                IoSessionInitiator ioSessionInitiator = new IoSessionInitiator(session, socketAddresses, reconnectingInterval, this.getScheduledExecutorService(), networkingOptions, eventHandlingStrategy, this.getIoFilterChainBuilder(), sslEnabled, keyStoreName, keyStorePassword);
                this.initiators.add(ioSessionInitiator);
            }
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    private void createSessions() throws ConfigError, FieldConvertError {
        SessionSettings settings = this.getSettings();
        boolean continueInitOnError = false;
        if (settings.isSetting("ContinueInitializationOnError")) {
            continueInitOnError = settings.getBool("ContinueInitializationOnError");
        }
        HashMap<SessionID, Session> initiatorSessions = new HashMap<SessionID, Session>();
        Iterator<SessionID> i = settings.sectionIterator();
        while (i.hasNext()) {
            SessionID sessionID = i.next();
            if (!this.isInitiatorSession(sessionID)) continue;
            try {
                Session quickfixSession = this.createSession(sessionID);
                initiatorSessions.put(sessionID, quickfixSession);
            }
            catch (Throwable e) {
                if (continueInitOnError) {
                    this.log.error("error during session initialization, continuing...", e);
                    continue;
                }
                throw e instanceof ConfigError ? (ConfigError)e : new ConfigError("error during session initialization", e);
            }
        }
        if (initiatorSessions.isEmpty()) {
            throw new ConfigError("no initiators in settings");
        }
        this.setSessions(initiatorSessions);
    }

    private int getReconnectIntervalInSeconds(SessionID sessionID) throws ConfigError {
        int reconnectInterval = 30;
        SessionSettings settings = this.getSettings();
        if (settings.isSetting(sessionID, "ReconnectInterval")) {
            try {
                reconnectInterval = (int)settings.getLong(sessionID, "ReconnectInterval");
            }
            catch (FieldConvertError e) {
                throw new ConfigError(e);
            }
        }
        return reconnectInterval;
    }

    private SocketAddress[] getSocketAddresses(SessionID sessionID) throws ConfigError {
        SessionSettings settings = this.getSettings();
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        int index = 0;
        while (true) {
            try {
                String protocolKey = new StringBuffer().append("SocketConnectProtocol").append(index == 0 ? "" : Integer.toString(index)).toString();
                String hostKey = new StringBuffer().append("SocketConnectHost").append(index == 0 ? "" : Integer.toString(index)).toString();
                String portKey = new StringBuffer().append("SocketConnectPort").append(index == 0 ? "" : Integer.toString(index)).toString();
                TransportType transportType = TransportType.SOCKET;
                if (settings.isSetting(sessionID, protocolKey)) {
                    try {
                        transportType = TransportType.getInstance((String)settings.getString(sessionID, protocolKey));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ConfigError(e);
                    }
                }
                if (!settings.isSetting(sessionID, portKey)) break;
                String host = !this.isHostRequired(transportType) ? "localhost" : settings.getString(sessionID, hostKey);
                int port = (int)settings.getLong(sessionID, portKey);
                addresses.add(ProtocolFactory.createSocketAddress(transportType, host, port));
            }
            catch (FieldConvertError e) {
                throw (ConfigError)new ConfigError(e.getMessage()).initCause(e);
            }
            ++index;
        }
        return addresses.toArray(new SocketAddress[addresses.size()]);
    }

    private boolean isHostRequired(TransportType transportType) {
        return transportType != TransportType.VM_PIPE;
    }

    private boolean isInitiatorSession(Object sectionKey) throws ConfigError, FieldConvertError {
        SessionSettings settings = this.getSettings();
        return !settings.isSetting((SessionID)sectionKey, "ConnectionType") || settings.getString((SessionID)sectionKey, "ConnectionType").equals("initiator");
    }

    protected void startInitiators() {
        this.startSessionTimer();
        for (IoSessionInitiator initiator : this.initiators) {
            initiator.start();
        }
    }

    protected void stopInitiators() {
        for (IoSessionInitiator initiator : this.initiators) {
            initiator.stop();
        }
        super.stopSessionTimer();
    }

    public Set<IoSessionInitiator> getInitiators() {
        return Collections.unmodifiableSet(this.initiators);
    }
}

