/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;

public class OpenMBeanInfoSupport
extends MBeanInfo
implements OpenMBeanInfo,
Serializable {
    private static final long serialVersionUID = 4349395935420511492L;
    private transient int hashCode = 0;

    public OpenMBeanInfoSupport(String className, String description, OpenMBeanAttributeInfo[] openAttributes, OpenMBeanConstructorInfo[] openConstructors, OpenMBeanOperationInfo[] openOperations, MBeanNotificationInfo[] notifications) {
        super(className, description, OpenMBeanInfoSupport.createMBeanAttributes(openAttributes), OpenMBeanInfoSupport.createMBeanConstructors(openConstructors), OpenMBeanInfoSupport.createMBeanOperations(openOperations), notifications);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OpenMBeanInfo)) {
            return false;
        }
        OpenMBeanInfo other = (OpenMBeanInfo)obj;
        String thisClassName = this.getClassName();
        String otherClassName = other.getClassName();
        if (thisClassName != null ? !thisClassName.equals(otherClassName) : otherClassName != null) {
            return false;
        }
        if (!this.compare(this.getConstructors(), other.getConstructors())) {
            return false;
        }
        if (!this.compare(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        if (!this.compare(this.getOperations(), other.getOperations())) {
            return false;
        }
        return this.compare(this.getNotifications(), other.getNotifications());
    }

    private boolean compare(Object[] o1, Object[] o2) {
        return new HashSet<Object>(Arrays.asList(o1)).equals(new HashSet<Object>(Arrays.asList(o2)));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash;
            int n = hash = this.getClassName() == null ? 0 : this.getClassName().hashCode();
            if (this.getConstructors() != null) {
                hash += new HashSet<MBeanConstructorInfo>(Arrays.asList(this.getConstructors())).hashCode();
            }
            if (this.getAttributes() != null) {
                hash += new HashSet<MBeanAttributeInfo>(Arrays.asList(this.getAttributes())).hashCode();
            }
            if (this.getOperations() != null) {
                hash += new HashSet<MBeanOperationInfo>(Arrays.asList(this.getOperations())).hashCode();
            }
            if (this.getNotifications() != null) {
                hash += new HashSet<MBeanNotificationInfo>(Arrays.asList(this.getNotifications())).hashCode();
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    private static MBeanAttributeInfo[] createMBeanAttributes(OpenMBeanAttributeInfo[] attributes) throws ArrayStoreException {
        if (attributes == null) {
            return null;
        }
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[attributes.length];
        System.arraycopy(attributes, 0, attrInfo, 0, attrInfo.length);
        return attrInfo;
    }

    private static MBeanConstructorInfo[] createMBeanConstructors(OpenMBeanConstructorInfo[] constructors) throws ArrayStoreException {
        if (constructors == null) {
            return null;
        }
        MBeanConstructorInfo[] constInfo = new MBeanConstructorInfo[constructors.length];
        System.arraycopy(constructors, 0, constInfo, 0, constInfo.length);
        return constInfo;
    }

    private static MBeanOperationInfo[] createMBeanOperations(OpenMBeanOperationInfo[] operations) throws ArrayStoreException {
        if (operations == null) {
            return null;
        }
        MBeanOperationInfo[] operInfo = new MBeanOperationInfo[operations.length];
        System.arraycopy(operations, 0, operInfo, 0, operInfo.length);
        return operInfo;
    }
}

