/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SharedLatchImpl
implements SharedLatch {
    private String name = null;
    private List waiters = new ArrayList();
    private LatchStats stats = new LatchStats();
    private EnvironmentImpl env = null;
    private boolean noteLatch;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedLatchImpl(String name, EnvironmentImpl env) {
        this.name = name;
        this.env = env;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized void setNoteLatch(boolean noteLatch) {
        this.noteLatch = noteLatch;
    }

    public synchronized void acquireExclusive() throws DatabaseException {
        block11: {
            try {
                Thread thread = Thread.currentThread();
                int index = this.indexOf(thread);
                if (index >= 0) {
                    throw new LatchException(this.getNameString() + " reentrancy/upgrade not allowed");
                }
                Owner owner = new Owner(thread, 1);
                this.waiters.add(owner);
                if (this.waiters.size() == 1) {
                    ++this.stats.nAcquiresNoWaiters;
                } else {
                    ++this.stats.nAcquiresWithContention;
                    while (this.waiters.get(0) != owner) {
                        this.wait();
                    }
                }
                ++owner.nAcquires;
                if ($assertionsDisabled || !this.noteLatch) break block11;
                if (this.noteLatch()) {
                    break block11;
                }
                throw new AssertionError();
            }
            catch (InterruptedException e) {
                throw new RunRecoveryException(this.env, (Throwable)e);
            }
            finally {
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
            }
        }
    }

    public boolean acquireExclusiveNoWait() throws DatabaseException {
        try {
            Thread thread = Thread.currentThread();
            int index = this.indexOf(thread);
            if (index < 0) {
                if (this.waiters.size() == 0) {
                    Owner owner = new Owner(thread, 1);
                    this.waiters.add(owner);
                    ++owner.nAcquires;
                    ++this.stats.nAcquiresNoWaiters;
                    if (!$assertionsDisabled && this.noteLatch && !this.noteLatch()) {
                        throw new AssertionError();
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            throw new LatchException(this.getNameString() + " reentrancy/upgrade not allowed");
        }
        finally {
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    public synchronized void acquireShared() throws DatabaseException {
        block10: {
            try {
                Owner owner;
                Thread thread = Thread.currentThread();
                int index = this.indexOf(thread);
                if (index < 0) {
                    owner = new Owner(thread, 0);
                    this.waiters.add(owner);
                } else {
                    owner = (Owner)this.waiters.get(index);
                }
                while (this.indexOf(thread) > this.firstWriter()) {
                    this.wait();
                }
                ++owner.nAcquires;
                ++this.stats.nAcquireSharedSuccessful;
                if ($assertionsDisabled || !this.noteLatch) break block10;
                if (this.noteLatch()) {
                    break block10;
                }
                throw new AssertionError();
            }
            catch (InterruptedException e) {
                throw new RunRecoveryException(this.env, (Throwable)e);
            }
            finally {
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws LatchNotHeldException {
        try {
            Thread thread = Thread.currentThread();
            int index = this.indexOf(thread);
            if (index < 0 || index > this.firstWriter()) {
                return;
            }
            Owner owner = (Owner)this.waiters.get(index);
            --owner.nAcquires;
            if (owner.nAcquires == 0) {
                this.waiters.remove(index);
                if (!$assertionsDisabled && this.noteLatch && !this.unNoteLatch()) {
                    throw new AssertionError();
                }
                this.notifyAll();
            }
            ++this.stats.nReleases;
        }
        finally {
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    private int indexOf(Thread thread) {
        Iterator i = this.waiters.iterator();
        int index = 0;
        while (i.hasNext()) {
            Owner owner = (Owner)i.next();
            if (owner.thread == thread) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int firstWriter() {
        Iterator i = this.waiters.iterator();
        int index = 0;
        while (i.hasNext()) {
            Owner owner = (Owner)i.next();
            if (owner.type == 1) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    private String getNameString() {
        return LatchSupport.latchTable.getNameString(this.name);
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() throws LatchNotHeldException {
        return LatchSupport.latchTable.unNoteLatch(this, this.name);
    }

    public synchronized boolean isWriteLockedByCurrentThread() {
        if (this.waiters.size() > 0) {
            Owner curOwner = (Owner)this.waiters.get(0);
            return curOwner.thread == Thread.currentThread() && curOwner.type == 1;
        }
        return false;
    }

    static {
        $assertionsDisabled = !SharedLatchImpl.class.desiredAssertionStatus();
    }

    private static class Owner {
        static final int SHARED = 0;
        static final int EXCLUSIVE = 1;
        Thread thread;
        int type;
        int nAcquires;

        Owner(Thread thread, int type) {
            this.thread = thread;
            this.type = type;
        }
    }
}

