/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Iterator;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.SingleThreadedEventHandlingStrategy;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class SocketInitiator
extends AbstractSocketInitiator {
    private boolean isInitialized;
    private SingleThreadedEventHandlingStrategy eventHandlingStrategy = new SingleThreadedEventHandlingStrategy(this);

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    public SocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        if (settings == null) {
            throw new ConfigError("no settings");
        }
    }

    public SocketInitiator(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
    }

    public void block() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.block();
    }

    public void start() throws ConfigError, RuntimeError {
        this.initialize();
        this.eventHandlingStrategy.blockInThread();
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean forceDisconnect) {
        try {
            this.eventHandlingStrategy.stopHandlingMessages();
            this.logoutAllSessions(forceDisconnect);
            this.stopInitiators();
        }
        finally {
            Session.unregisterSessions(this.getSessions());
        }
    }

    private synchronized void initialize() throws ConfigError {
        if (!this.isInitialized) {
            this.createSessionInitiators(this.eventHandlingStrategy);
            this.isInitialized = true;
        } else {
            Iterator<Session> i$ = this.getSessionMap().values().iterator();
            while (i$.hasNext()) {
                Session session = i$.next();
                Session.registerSession(session);
            }
        }
        this.startInitiators();
    }
}

