/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.HashMap;
import java.util.Map;
import org.quickfixj.QFJException;
import quickfix.DataDictionary;
import quickfix.DataDictionaryProvider;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.field.ApplVerID;

public class MessageUtils {
    private static Map<String, String> applVerIDtoBeginString = new HashMap<String, String>(){
        {
            this.put("2", "FIX.4.0");
            this.put("3", "FIX.4.1");
            this.put("4", "FIX.4.2");
            this.put("5", "FIX.4.3");
            this.put("6", "FIX.4.4");
            this.put("7", "FIX.5.0");
        }
    };
    private static Map<String, ApplVerID> beginStringToApplVerID = new HashMap<String, ApplVerID>(){
        {
            this.put("FIX.4.0", new ApplVerID("2"));
            this.put("FIX.4.1", new ApplVerID("3"));
            this.put("FIX.4.2", new ApplVerID("4"));
            this.put("FIX.4.3", new ApplVerID("5"));
            this.put("FIX.4.4", new ApplVerID("6"));
            this.put("FIX.5.0", new ApplVerID("7"));
        }
    };

    public static SessionID getSessionID(Message fixMessage) {
        Message.Header header = fixMessage.getHeader();
        return new SessionID(MessageUtils.getFieldOrDefault(header, 8, null), MessageUtils.getFieldOrDefault(header, 49, null), MessageUtils.getFieldOrDefault(header, 50, null), MessageUtils.getFieldOrDefault(header, 142, null), MessageUtils.getFieldOrDefault(header, 56, null), MessageUtils.getFieldOrDefault(header, 57, null), MessageUtils.getFieldOrDefault(header, 143, null), null);
    }

    public static SessionID getSessionID(String messageString) {
        return new SessionID(MessageUtils.getStringField(messageString, 8), MessageUtils.getStringField(messageString, 49), MessageUtils.getStringField(messageString, 50), MessageUtils.getStringField(messageString, 142), MessageUtils.getStringField(messageString, 56), MessageUtils.getStringField(messageString, 57), MessageUtils.getStringField(messageString, 143), null);
    }

    public static SessionID getReverseSessionID(Message fixMessage) {
        Message.Header header = fixMessage.getHeader();
        return new SessionID(MessageUtils.getFieldOrDefault(header, 8, null), MessageUtils.getFieldOrDefault(header, 56, null), MessageUtils.getFieldOrDefault(header, 57, null), MessageUtils.getFieldOrDefault(header, 143, null), MessageUtils.getFieldOrDefault(header, 49, null), MessageUtils.getFieldOrDefault(header, 50, null), MessageUtils.getFieldOrDefault(header, 142, null), null);
    }

    public static SessionID getReverseSessionID(String messageString) {
        return new SessionID(MessageUtils.getStringField(messageString, 8), MessageUtils.getStringField(messageString, 56), MessageUtils.getStringField(messageString, 57), MessageUtils.getStringField(messageString, 143), MessageUtils.getStringField(messageString, 49), MessageUtils.getStringField(messageString, 50), MessageUtils.getStringField(messageString, 142), null);
    }

    private static String getFieldOrDefault(FieldMap fields, int tag, String defaultValue) {
        if (fields.isSetField(tag)) {
            try {
                return fields.getString(tag);
            }
            catch (FieldNotFound e) {
                return null;
            }
        }
        return defaultValue;
    }

    public static Message parse(MessageFactory messageFactory, DataDictionary dataDictionary, String messageString) throws InvalidMessage {
        String beginString = messageString.substring(2, 9);
        String messageType = MessageUtils.getMessageType(messageString);
        Message message = messageFactory.create(beginString, messageType);
        message.fromString(messageString, dataDictionary, dataDictionary != null);
        return message;
    }

    public static Message parse(Session session, String messageString) throws InvalidMessage {
        String beginString = MessageUtils.getStringField(messageString, 8);
        String msgType = MessageUtils.getMessageType(messageString);
        ApplVerID applVerID = null;
        String customApplVerID = null;
        if ("FIXT.1.1".equals(beginString)) {
            applVerID = MessageUtils.getApplVerID(session, messageString);
            customApplVerID = MessageUtils.getStringField(messageString, 1129);
        } else {
            applVerID = MessageUtils.toApplVerID(beginString);
        }
        MessageFactory messageFactory = session.getMessageFactory();
        DataDictionaryProvider ddProvider = session.getDataDictionaryProvider();
        DataDictionary sessionDataDictionary = ddProvider.getSessionDataDictionary(beginString);
        DataDictionary applicationDataDictionary = ddProvider.getApplicationDataDictionary(applVerID, customApplVerID);
        Message message = messageFactory.create(beginString, msgType);
        DataDictionary payloadDictionary = MessageUtils.isAdminMessage(msgType) ? sessionDataDictionary : applicationDataDictionary;
        message.parse(messageString, sessionDataDictionary, payloadDictionary, payloadDictionary != null);
        return message;
    }

    private static ApplVerID getApplVerID(Session session, String messageString) throws InvalidMessage {
        String defaultApplVerIdString;
        ApplVerID applVerID = null;
        String applVerIdString = MessageUtils.getStringField(messageString, 1128);
        if (applVerIdString != null) {
            applVerID = new ApplVerID(applVerIdString);
        }
        if (applVerID == null) {
            applVerID = session.getTargetDefaultApplicationVersionID();
        }
        if (applVerID == null && MessageUtils.isLogon(messageString) && (defaultApplVerIdString = MessageUtils.getStringField(messageString, 1137)) != null) {
            applVerID = new ApplVerID(defaultApplVerIdString);
        }
        if (applVerID == null) {
            throw new InvalidMessage("Can't determine ApplVerID for message");
        }
        return applVerID;
    }

    static boolean isAdminMessage(String msgType) {
        return msgType.length() == 1 && "0A12345".indexOf(msgType) != -1;
    }

    public static boolean isHeartbeat(String message) {
        return MessageUtils.isMessageType(message, "0");
    }

    public static boolean isLogon(String message) {
        return MessageUtils.isMessageType(message, "A");
    }

    private static boolean isMessageType(String message, String msgType) {
        try {
            return msgType.equals(MessageUtils.getMessageType(message));
        }
        catch (InvalidMessage e) {
            return false;
        }
    }

    public static String getMessageType(String messageString) throws InvalidMessage {
        String value = MessageUtils.getStringField(messageString, 35);
        if (value == null) {
            throw new InvalidMessage("missing or garbled message type");
        }
        return value;
    }

    public static String getStringField(String messageString, int tag) {
        String value = null;
        String tagString = Integer.toString(tag);
        int start = messageString.indexOf(tagString, 0);
        while (start != -1 && value == null) {
            int end;
            if ((start == 0 || messageString.charAt(start - 1) == '\u0001') && (end = start + tagString.length()) + 1 < messageString.length() && messageString.charAt(end) == '=') {
                start = ++end;
                while (end < messageString.length() && messageString.charAt(end) != '\u0001') {
                    ++end;
                }
                if (end == messageString.length()) {
                    return null;
                }
                value = messageString.substring(start, end);
            }
            start = messageString.indexOf(tagString, start + 1);
        }
        return value;
    }

    public static String toBeginString(ApplVerID applVerID) throws QFJException {
        String beginString = applVerIDtoBeginString.get(applVerID.getValue());
        if (beginString == null) {
            throw new QFJException("Unknown or unsupported ApplVerID: " + applVerID.getValue());
        }
        return beginString;
    }

    public static ApplVerID toApplVerID(String beginString) throws QFJException {
        ApplVerID applVerID = beginStringToApplVerID.get(beginString);
        if (applVerID == null) {
            throw new QFJException("Can't convert to ApplVerID: " + beginString);
        }
        return applVerID;
    }
}

