/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.java4.net.sf.retrotranslator.runtime.format;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.CharacterConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.DateTimeConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.DecimalIntegralConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.FloatingPointConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.FormatContext;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.GeneralConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.HexadecimalExponentialConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.LineSeparatorConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.NondecimalIntegralConversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.PercentConversion;

abstract class Conversion {
    private static Map map = new HashMap();

    Conversion() {
    }

    public static Conversion getInstance(String code) {
        return (Conversion)map.get(code);
    }

    public abstract void format(FormatContext var1);

    private static void put(String lower, String upper, Conversion value) {
        map.put(lower, value);
        if (upper != null) {
            map.put(upper, value);
        }
    }

    static {
        Conversion.put("b", "B", new GeneralConversion.BooleanConversion());
        Conversion.put("h", "H", new GeneralConversion.HashConversion());
        Conversion.put("s", "S", new GeneralConversion.StringConversion());
        Conversion.put("c", "C", new CharacterConversion());
        Conversion.put("d", null, new DecimalIntegralConversion());
        Conversion.put("o", null, new NondecimalIntegralConversion.OctalConversion());
        Conversion.put("x", "X", new NondecimalIntegralConversion.HexadecimalConversion());
        Conversion.put("e", "E", new FloatingPointConversion.ComputerizedScientificConversion());
        Conversion.put("f", null, new FloatingPointConversion.DecimalConversion());
        Conversion.put("g", "G", new FloatingPointConversion.GeneralScientificConversion());
        Conversion.put("a", "A", new HexadecimalExponentialConversion());
        Conversion.put("%", null, new PercentConversion());
        Conversion.put("n", null, new LineSeparatorConversion());
        Iterator i$ = DateTimeConversion.getConversions().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            Character c = (Character)entry.getKey();
            Conversion.put("t" + c, "T" + c, (Conversion)entry.getValue());
        }
    }
}

