#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
from __future__ import with_statement
import sys
import cPickle
import os
import os.path
import shutil

#The current data version
dataVersion = 2
#Version of pyfa
pyfaVersion = "git"

#Where to store data
paths = {'home': unicode(os.path.expanduser(os.path.join("~", ".pyfa")), sys.getfilesystemencoding( )),
         'root': unicode(os.path.join(".", "data"), sys.getfilesystemencoding( ))}
dataFolder = paths['home']

def setDataFolder(place):
    global dataFolder
    dataFolder = place in paths and paths[place] or unicode(place, sys.getfilesystemencoding( ))

#0 is a ASCII format handy for debugging, 2 is a binary format that's smaller.
#If you're debugging pick 0 else pick 2
pickle_protocol = 2

#Don't edit beyond this point
def checkCreateDataFolder():
    '''
    Check if the data folder exists and create it if it doesn't
    '''
    if not os.path.exists(dataFolder):
        os.mkdir(dataFolder)
        
def pickleObjToFile(obj, fileName, protocolOverride = None):
    '''
    Create a file containing the pickled representation of this passed object (location: ~/.pyfa/fileName
    @param obj: the object to pickle
    @param fileName: the filename to use
    @param protocolOverride: The pickle protocol to use, if this is not specified the default protocol specified in version.pickle_protocol is used
    '''
    checkCreateDataFolder()
    protocol = protocolOverride or pickle_protocol

    fileName = os.path.join(dataFolder, fileName)
    tmpFile = fileName + ".tmp"

    with open(tmpFile, "wb") as f:
        cPickle.dump((dataVersion, obj), f, protocol)

    shutil.move(tmpFile, fileName)

    return fileName

def pickleFileToObj(fileName):
    '''
    Fetch an object from a file. The file is assumed to be a valid "pickle" file. (location: ~/.pyfa/fileName)
    @param fileName: the filename to use
    '''
    checkCreateDataFolder()
    path = os.path.join(dataFolder, fileName)
    if not os.path.exists(path):
        return None  
    
    with open(path, "rb") as f:
        try:
            struct = cPickle.load(f)
        except Exception, e:
            print "error while loading", fileName
            raise
            return None
        
        if struct[0] < dataVersion: return None
        else: return struct[1]
