#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import sql
import graphic
from model.cache import cached_property, cached_query

baseQuery = '''
SELECT
categoryID,
categoryName,
description,
graphicID,
published,
iconID,
dataID
FROM invcategories
'''
searchCategoryQueryByName = baseQuery + " WHERE categoryName = ?"
searchCategoryQueryByID = baseQuery + " WHERE categoryID = ?"

class category(object):
    '''
    Class used for category info fetched from the database
    '''
    @cached_property
    def icon(self): return graphic.getIconName(self.iconID)
    
    def __init__(self, (ID, name, description, graphicID, published, iconID, dataID)):
        '''
        Constructor
        @param ID: the ID of this category [from database]
        @param name: the name of this category [from database]
        @param description: the description of this category [from database]
        @param graphicID: the graphicID of this category [from database]
        @param published: whether this category has been published [from database]
        @param iconID: the iconID of this category [from database]
        @param dataID: the dataID of this category [from database]
        '''
        self.ID = ID
        self.name = name
        self.description = description
        self.iconID = iconID
    
    def __str__(self, level = 0):
        '''
        The string representation of this class
        @param level: level of indentation
        '''
        formatting = ((level * 2) * " ") + "{0:15} = {1}\n"
        newline = ((level * 2) * " ") + "\n"
        str = formatting.format("ID", self.ID) + formatting.format("name", self.name) + formatting.format("description", self.description)
        return str
    
    
def getCategory(ID = None, name = None):
    '''
    Get a category from the database. Either name or ID must be passed NOT BOTH
    @param ID: the ID of the category
    @param name: the name of the category
    '''
    if ID != None and name == None: c = cached_query(searchCategoryQueryByID, (ID,))
    elif name != None: c = cached_query(searchCategoryQueryByName, (name,))
    else: return None
    row = c[0]
    if row == None: return None
    return category(row)