#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import gobject
from model import updater, dataFolder
from model.updater import builtinUpdaters
from gui import mainWindow
import sys
import os.path

class UpdaterDialog(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self, title="Update needed")
        if os.path.exists(os.path.join(dataFolder.dataFolder, "eve.db")):
            self.fresh = False
            buttonText = "Update"
            text = "There are updates available for pyfa, do you want to update?"
        else:
            self.fresh = True
            buttonText = "Download"
            text = "Pyfa cannot find files required for start. Download now?"
            
        self.add_button(buttonText, gtk.RESPONSE_ACCEPT)
        self.add_button("Cancel", gtk.RESPONSE_CANCEL)
        self.set_default_response(gtk.RESPONSE_ACCEPT)
        self.connect("response", self.processResponse)
        self.vbox.pack_start(gtk.Label(text), padding=5)
        self.show_all()

    def processResponse(self, dialog, response):        
        if response == gtk.RESPONSE_ACCEPT:
            ProgressDialog(self.fresh)
            
        dialog.hide_all()
        dialog.destroy()
        
        if response == gtk.RESPONSE_CANCEL and self.fresh:
            gtk.main_quit()
        
class ProgressDialog(gtk.Dialog):
    def __init__(self, fresh):
        gtk.Dialog.__init__(self, title="Downloading...")
        self.fresh = fresh
        self.add_button("Cancel", gtk.RESPONSE_CANCEL)
        self.resize(200, 50)
        hbox = gtk.HBox()
        self.progressBar = gtk.ProgressBar()
        self.statusLabel = gtk.Label()
        self.sectionLabel = gtk.Label()
        self.vbox.pack_start(self.sectionLabel, padding=1)
        self.vbox.pack_start(self.statusLabel, padding=5)
        hbox.pack_start(self.progressBar, True, True, 10)
        self.vbox.pack_start(hbox, False, False, 5)
        self.connect("response", self.processResponse)
        self.show_all()
        conn, process = updater.runAllUpdatersThreaded()
        self.process = process
        gobject.idle_add(self.poll, conn)
    
    def processResponse(self, dialog, response):
        if response == gtk.RESPONSE_CANCEL:
            self.process.terminate()
            dialog.hide_all()
            dialog.destroy()
            if self.fresh:
                gtk.main_quit()
    
    def poll(self, conn):
        if conn.poll():
            type, msg = conn.recv()
            if type == "status":
                self.statusLabel.set_text(msg.capitalize())
            elif type == "progress":
                self.progressBar.set_fraction(min(1,msg))
            elif type == "section":
                self.sectionLabel.set_text(msg)
                self.statusLabel.set_text("Checking")
            elif type == "done":
                self.hide_all()
                self.destroy()
                FinishDialog(self.fresh)
                return False
        return True

class FinishDialog(gtk.Dialog):
    def __init__(self, fresh):
        gtk.Dialog.__init__(self, title="All done!")
        self.resize(200, 50)
        hbox = gtk.HBox()
        if fresh:
            text = "You can start pyfa after closing this window."
        else:
            text = "Pyfa could use a restart."
            
        hbox.pack_start(gtk.Label("Download finished.\n%s" % text))
        self.vbox.pack_start(hbox, False, False, 5)
        self.add_button("Close pyfa", gtk.RESPONSE_ACCEPT)
        if not fresh: self.add_button("Continue anyway", gtk.RESPONSE_CANCEL)
        self.set_default_response(gtk.RESPONSE_ACCEPT)
        self.connect("response", self.processResponse)
        self.show_all()
                        
    def processResponse(self, dialog, response):
        if response == gtk.RESPONSE_ACCEPT:
            if mainWindow.mainWindow._instance is None:
                sys.exit()
            else:
                mainWindow.mainWindow._instance.exit()
        else:
            dialog.hide_all()
            dialog.destroy()
    
def checkAndRun():
    updater.scheduleForUpdate(builtinUpdaters.DataFolderUpdater())
    #updater.scheduleForUpdate(builtinUpdaters.PyfaUpdater())
    if updater.isUpdateNeeded():
        UpdaterDialog()