#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
from gui import pixbufLoader

def init(self):
    self.connect("fitting-changed", self.handleFittingChangedMissingSkills)
    
def handleFittingChangedMissingSkills(self, *stuff):
    fit = self.getActiveFit()
    char = self.getActiveCharacter()
    if fit == None: return
    missingSkills, itemsDone = self.buildMissingSkills(fit.ship, char)
    store = self.tvwModules.get_model()
    iter = store.get_iter_first()
    red = set()
    while iter:
        if store.get_value(iter, 10) != 'sepSlot':
            module = store.get_value(iter, 9)
            item, ammo = module.getItem(), module.getAmmo()
            #Missing skills for this mod
            if item == None:
                iter = store.iter_next(iter)
                continue
            sk, itemsDone = self.buildMissingSkills(item, char, itemsDone)
            missingSkills += sk
            if ammo: 
                ska, itemsDone = self.buildMissingSkills(ammo, char, itemsDone)
                missingSkills += ska
            else: ska = False
            if sk or ska: red.add(item)
            colorRed = item in red and char and char.name != "All 0"
            store.set(iter, 14, colorRed)
            iter = store.iter_next(iter)
            
            for drone in fit.drones:
                msdrone, itemsDone = self.buildMissingSkills(drone.getItem(), char, itemsDone)
                missingSkills += msdrone
        else:
            iter = store.iter_next(iter)

    if missingSkills:
        if char and char.name != "All 0": text = missingSkills.strip()
        else: text = None
        pixbuf = pixbufLoader.getPixbuf("skills_missing")
    else:
        text = "All prerequisites have been met"
        pixbuf = pixbufLoader.getPixbuf("skills_satisfied")
    
    self.imgSkillReq.set_from_pixbuf(pixbuf)
    self.imgSkillReq.set_tooltip_text(text)

def buildMissingSkills(self, item, char = None, itemsDone = None, str = "", indentLevel = 0, showPrefix = True):
    itemsDone = itemsDone or []
    if item in itemsDone: return str, itemsDone
    itemsDone.append(item)
    indent = "   "
    if char == None:
        store = self.cmbCharacter.get_model()
        path = self.cmbCharacter.get_active()
        if path == -1 or path == None:
            return " ", itemsDone
        else:
            iter = store.get_iter(path)
            char = store.get(iter, 1)[0]
        
    prefix = False
    for skill, level in item.requiredSkills.iteritems():
        level = level.getModifiedValue()
        missing = False
        if not skill in char.skills:
            missing = True
        else:
            if char.skills[skill] < level:
                missing = True
        if missing:
            if prefix == False and showPrefix:
                str += (indent * indentLevel) + item.name + ":\n"
                prefix = True
                
            str += ((indentLevel + 1) * indent)  + skill.name + " " + ("%d" % level) + "\n"
        if skill.requiredSkills:
            str, itemsDone = self.buildMissingSkills(skill, char, itemsDone, str, indentLevel + 1, False)
    #print str + "\n" + ("%d" % indentLevel) +"\n==========="
    return str, itemsDone