#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
import copy
from model import item, fitting
from gui import pixbufLoader
from gui.itemStatsWindow import itemStatsWindow
import groupBrowser

dependencies = (groupBrowser,)
def init(self):
    self.window.connect("key-press-event", self.checkControlPress)
    self.window.connect("key-release-event", self.checkControlRelease)
    self.itemBrowserTogglesPrepareMode = False
    self.itemBrowserTogglesMultiMode = False
    for tbn in (self.tbnNormal, self.tbnFaction, self.tbnComplex, self.tbnOfficer):
        tbn.connect("button-release-event", self.itemBrowserTogglesPress)
        tbn.set_active(False)
        tbn.set_sensitive(False)
        tbn.connect("toggled", self.itemBrowserFillView)

    self.itemStore = []
    store = gtk.ListStore(gtk.gdk.Pixbuf, str, str, object, str)
    self.tvwItems.set_model(store)
    self.tvwItems.set_tooltip_column(2)
    self.tvwItems.set_headers_visible(False)
    store.set_sort_column_id(1, gtk.SORT_ASCENDING)
    store.set_sort_func(1, self.sortItemBrowser)
    iconRenderer = gtk.CellRendererPixbuf()
    nameRenderer = gtk.CellRendererText()
    col = gtk.TreeViewColumn()
    col.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)
    col.pack_start(iconRenderer, False)
    col.pack_start(nameRenderer, True)
    col.add_attribute(iconRenderer, 'pixbuf', 0)
    col.add_attribute(nameRenderer, 'text', 1)
    self.tvwItems.append_column(col)
    self.tvwItems.connect("button-press-event", self.itemsClicked)
    
    self.itemBrowserSlotCol = gtk.TreeViewColumn("Slot")
    slotRenderer = gtk.CellRendererText()
    self.itemBrowserSlotCol.pack_start(slotRenderer, False)
    self.itemBrowserSlotCol.add_attribute(slotRenderer, 'text', 4)
    self.itemBrowserSlotColUsed = False

    self.itemBrowserItemMenuExternals = []
    self.itemStatsLabel = gtk.Label("Item Stats")
    self.itemStatsEntry = self.generateMenuItem(self.itemStatsLabel, self.itemStats)
    self.itemGroupLabel = gtk.Label("Item Market Group")
    self.itemGroupEntry = self.generateMenuItem(self.itemGroupLabel, self.itemGroup)
    self.itemAddToFavsLabel = gtk.Label("Add Item to Favorites")
    self.itemAddToFavsEntry = self.generateMenuItem(self.itemAddToFavsLabel, self.addFavorite)
    self.itemRemoveFromFavsLabel = gtk.Label("Remove Item from Favorites")
    self.itemRemoveFromFavsEntry = self.generateMenuItem(self.itemRemoveFromFavsLabel, self.removeFavorite)
    self.itemLoadAmmoLabel = gtk.Label("Load Item to All")
    self.itemLoadAmmoEntry = self.generateMenuItem(self.itemLoadAmmoLabel, self.itemLoadAmmo)
    self.itemBrowserMenu = self.generateMenu({})

def checkControlPress(self, widget, event):
    if gtk.gdk.keyval_name(event.keyval)[0:7] == "Control": self.itemBrowserTogglesMultiMode = True

def checkControlRelease(self, widget, event):
    if gtk.gdk.keyval_name(event.keyval)[0:7] == "Control": self.itemBrowserTogglesMultiMode = False
    
def itemBrowserTogglesPress(self, widget, event):
    tbns = (self.tbnNormal, self.tbnFaction, self.tbnComplex, self.tbnOfficer)
    #here we deselect all buttons without refilling item browser
    #clicked button will be toggled automatically anyways and emit
    #"toggled" signal which will fill item browser
    self.itemBrowserTogglesPrepareMode = True
    if not self.itemBrowserTogglesMultiMode:
        for tbn in tbns: tbn.set_active(False)
    self.itemBrowserTogglesPrepareMode = False

def itemFilter(self, item):
    if item == None: return False
    if item.metaGroupID not in (4, 5, 6) or not item.metaGroupID: return self.tbnNormal.get_active()
    elif item.metaGroupID == 4: return self.tbnFaction.get_active()
    elif item.metaGroupID == 5: return self.tbnOfficer.get_active()
    elif item.metaGroupID == 6: return self.tbnComplex.get_active()

def sortItemBrowser(self, store, iter1, iter2):
    grp = self.getSelectedGroup()
    slot1, name1 = store.get(iter1, 4, 1)
    slot2, name2 = store.get(iter2, 4, 1)
    if grp == "recent" or grp == "favorite" or self.itemSearchActive:
        item1 = store.get_value(iter1, 3)
        item2 = store.get_value(iter2, 3)
        if not item1 or not item2: return item1 and -1 or 1
        if grp == "recent" and not self.itemSearchActive:
            if item1.ID in self.recentItems and item2.ID in self.recentItems:
                return cmp(self.recentItems.index(item2.ID), self.recentItems.index(item1.ID))
            else: return 0
        else: return cmp(item1.group.name, item2.group.name) or cmp(name1, name2)
    else:
        if slot1 != None: slot1 = int(slot1)
        if slot2 != None: slot2 = int(slot2)
        if slot1 != None or slot2 != None:
            sort = cmp(slot1, slot2)
            if sort == 0: sort = cmp(name1, name2)
        else: sort = cmp(name1, name2)
        return sort

def addFavorite(self, *stuff): self.favoriteItems.add(self.getSelectedItem().ID)
def removeFavorite(self, *stuff):
    self.favoriteItems.remove(self.getSelectedItem().ID)
    self.groupSelected(self.tvwGroups)
    
def getSelectedItem(self):
    store, selected_rows = self.tvwItems.get_selection().get_selected_rows()
    if not selected_rows: return
    iter = store.get_iter(selected_rows[0])
    module = store.get_value(iter, 3)
    return module

def itemBrowserSetToggles(self, grp = None, *stuff):
    self.itemBrowserTogglesPrepareMode = True
    #compose list of metalvls
    metaIds = set()
    for i in self.itemStore:
        if i.metaGroupID: metaIds.add(i.metaGroupID)
        #if item doesn't have metaGroupID (like some t1 ammo) assign zero metaGroupID (not used by any items)
        else: metaIds.add(0)
    #set toggle buttons availability according to the items in the selected group
    normalMeta = False
    for meta in metaIds:
        if meta not in (4, 5, 6):
            normalMeta = True
            break
    if normalMeta:
        self.tbnNormal.set_sensitive(True)
    else:
        self.tbnNormal.set_sensitive(False)
        if self.tbnNormal.get_active(): self.tbnNormal.set_active(False)
    if 4 in metaIds:
        self.tbnFaction.set_sensitive(True)
    else:
        self.tbnFaction.set_sensitive(False)
        if self.tbnFaction.get_active(): self.tbnFaction.set_active(False)
    if 5 in metaIds:
        self.tbnOfficer.set_sensitive(True)
    else:
        self.tbnOfficer.set_sensitive(False)
        if self.tbnOfficer.get_active(): self.tbnOfficer.set_active(False)
    if 6 in metaIds:
        self.tbnComplex.set_sensitive(True)
    else:
        self.tbnComplex.set_sensitive(False)
        if self.tbnComplex.get_active(): self.tbnComplex.set_active(False)

    #make sure that at least 1 button of available is selected
    if grp != "recent" and grp != "favorite" and not self.itemSearchActive and not self.tbnNormal.get_active() and not\
    self.tbnFaction.get_active() and not self.tbnComplex.get_active() and not self.tbnOfficer.get_active():
        if normalMeta: self.tbnNormal.set_active(True)
        elif 4 in metaIds: self.tbnFaction.set_active(True)
        elif 6 in metaIds: self.tbnComplex.set_active(True)
        elif 5 in metaIds: self.tbnOfficer.set_active(True)
    #select all toggles for recent and favs groups and for search
    elif grp == "recent" or grp == "favorite" or self.itemSearchActive:
        if normalMeta: self.tbnNormal.set_active(True)
        if 4 in metaIds: self.tbnFaction.set_active(True)
        if 6 in metaIds: self.tbnComplex.set_active(True)
        if 5 in metaIds: self.tbnOfficer.set_active(True)
    self.itemBrowserTogglesPrepareMode = False

def itemBrowserFillView(self, *stuff):
    #do nothing if we're just preparing toggles to fill item browser afterwards
    if self.itemBrowserTogglesPrepareMode: return

    store = self.tvwItems.get_model()
    store.clear()
    #assume that all items we get are implants or boosters
    allImplantness = True
    allBoosterness = True
    for i in self.itemStore:
        if self.itemFilter(i):
            #if item doesn't have attribute reflecting its implant/booster slot set corresponding flag to off
            implantness = i.getModifiedAttribute("implantness")
            if allImplantness and not implantness: allImplantness = False
            boosterness = i.getModifiedAttribute("boosterness")
            if allBoosterness and not boosterness: allBoosterness = False
            pixbuf = pixbufLoader.getPixbuf(i.icon, True, "16x16")
            #it's very unlikely that there're any items with both attributes, but set implantness to highest priority anyway
            if implantness: slot = "%d" % i.getModifiedAttribute("implantness")
            elif boosterness: slot = "%d" % i.getModifiedAttribute("boosterness")
            else: slot = None
            store.append((pixbuf, i.name, i.description.replace("\\\"", "\""), i, slot))
    #show/hide slot column when we need/don't need it
    if (allImplantness or allBoosterness) and not self.itemBrowserSlotCol in self.tvwItems.get_columns():
        self.tvwItems.insert_column(self.itemBrowserSlotCol, 0)
    elif not (allImplantness or allBoosterness) and self.itemBrowserSlotCol in self.tvwItems.get_columns():
        self.tvwItems.remove_column(self.itemBrowserSlotCol)

def itemStats(self, *stuff): itemStatsWindow(self.getSelectedItem(), None, None)

def itemGroup(self, *stuff): self.expandToItem(self.getSelectedItem())

def itemLoadAmmo(self, *stuff):
    ammo = self.getSelectedItem()
    fit = self.getActiveFit()
    for module in fit.modules:
        if module.isValidAmmo(ammo): module.setAmmo(copy.deepcopy(ammo))
    self.emit("fitting-changed")

def itemsClicked(self, widget, event):
    widget.do_button_press_event(widget, event)
    stuff = widget.get_path_at_pos(int(event.x), int(event.y))
    if stuff == None: 
        widget.get_selection().unselect_all()
        return
    if event.button == 1:
        if event.type == gtk.gdk._2BUTTON_PRESS:
            self.addItem(widget)
    if event.button == 3:
        store, selected_rows = widget.get_selection().get_selected_rows()
        iter = store.get_iter(selected_rows[0])
        module = store.get_value(iter, 3)
        #Check if the selected item fits as ammo in any fitted module
        ammoShow = False
        fit = self.getActiveFit()
        if fit != None:
            for mod in fit.modules:
                if mod.isValidAmmo(module):
                    ammoShow = True
                    break

        for it in self.itemBrowserMenu: self.itemBrowserMenu.remove(it)

        grp = self.getSelectedGroup()
        itmCatName = self.getItemCategoryName(self.getSelectedItem()) or "Item"

        genGroup = []
        miscGroup = []
        favGroup = []

        self.itemStatsLabel.set_text(itmCatName + " Stats")
        genGroup.append(self.itemStatsEntry)

        if (self.itemSearchActive or grp == "favorite" or grp == "recent") and self.findMktGroup(self.getSelectedItem()):
            self.itemGroupLabel.set_text(itmCatName + " Market Group")
            genGroup.append(self.itemGroupEntry)

        if not grp == "favorite" or self.itemSearchActive:
            self.itemAddToFavsLabel.set_text("Add " + itmCatName + " to Favorites")
            favGroup.append(self.itemAddToFavsEntry)
        else:
            self.itemRemoveFromFavsLabel.set_text("Remove " + itmCatName + " from Favorites")
            favGroup.append(self.itemRemoveFromFavsEntry)

        if ammoShow:
            self.itemLoadAmmoLabel.set_text("Load " + itmCatName + " to All")
            miscGroup.append(self.itemLoadAmmoEntry)

        for menuItem in genGroup:
            self.itemBrowserMenu.append(menuItem)

        if genGroup and ((miscGroup or self.itemBrowserItemMenuExternals) or favGroup):
            self.itemBrowserMenu.append(gtk.SeparatorMenuItem())

        for menuItem in miscGroup:
            self.itemBrowserMenu.append(menuItem)
        for menuItem in self.itemBrowserItemMenuExternals:
            self.itemBrowserMenu.append(menuItem)

        if (miscGroup or self.itemBrowserItemMenuExternals) and favGroup:
            self.itemBrowserMenu.append(gtk.SeparatorMenuItem())

        for menuItem in favGroup:
            self.itemBrowserMenu.append(menuItem)

        self.itemBrowserMenu.show_all()
        self.itemBrowserMenu.popup(None, None, None, event.button, event.time)

def getItemCategoryName(self, itm, *stuff):
    try:
        catName = itm.group.category.name
    except:
        return None
    return catName
