#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
from gui.importExportWindow import importExportWindow
from gui.errorWindow import errorWindow
from model import fitting

def init(self):
    self.btnExportSetup.connect("clicked", self.exportFit)
    self.btnImportSetup.connect("clicked", self.importFit)

def importFit(self, *stuff):
    importExportWindow(self, "Fit ?", "import", self.importFitFinal)
    
def importFitFinal(self, type, importText):
    try:
        fit = fitting.fitting()
        if type == "eft": name = fit.importEft(importText)
        elif type == "xml": name = fit.importXml(importText)
        i = 1
        if fit.ship.group in self.fits and fit.ship in self.fits[fit.ship.group]:
            newName = name
            while newName in self.fits[fit.ship.group][fit.ship]:
                newName = name + " Import %d" % i
                i += 1
            name = newName
            
        self.newFit(name, fit)
        return True
    except:
        errorWindow(self, "Invalid fit")
        return False

def exportFit(self, *stuff):
    store = self.cmbSetup.get_model()
    if store == None: return
    iter = self.cmbSetup.get_active_iter()
    if iter == None: return
    name, fit = store.get(iter, 1, 2)
    importExportWindow(self, name, "export", fit)