#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
from gui import pixbufLoader
from gui.itemStatsWindow import itemStatsWindow

def init(self):
    self.tvwImplantsBoosters.connect("button-press-event", self.tvwImplantsBoostersClicked)
    self.connect("fitting-changed", self.handleFittingChangedImplantsBoosters)
    store = gtk.TreeStore(gtk.gdk.Pixbuf, str, str, str, object, str)
    self.tvwImplantsBoosters.set_model(store)
    self.tvwImplantsBoosters.set_tooltip_column(3)
    store.set_sort_column_id(2, gtk.SORT_ASCENDING)
    store.set_sort_func(2, self.sortBySlotness)
    iconRenderer = gtk.CellRendererPixbuf()
    nameRenderer = gtk.CellRendererText()
    slotRenderer = gtk.CellRendererText()
    
    nameCol = gtk.TreeViewColumn("Item")
    slotCol = gtk.TreeViewColumn("Slot")
    
    nameCol.pack_start(iconRenderer, False)
    nameCol.pack_start(nameRenderer, True)
    slotCol.pack_start(slotRenderer, False)
    
    nameCol.add_attribute(iconRenderer, 'pixbuf', 0)
    nameCol.add_attribute(nameRenderer, 'text', 1)
    slotCol.add_attribute(slotRenderer, 'text', 2)
    
    self.tvwImplantsBoosters.append_column(nameCol)
    self.tvwImplantsBoosters.append_column(slotCol)
    
    iterImplant = store.append(None, (pixbufLoader.getPixbuf("hardwiring"), "Implants", None, None, None, None))
    iterBooster = store.append(None, (pixbufLoader.getPixbuf("booster"), "Boosters", None, None, None, None))

    #Generate context menus
    self.implantsBoostersViewStatsLabel = gtk.Label("Implant Stats")
    self.implantsBoostersViewStatsEntry = self.generateMenuItem(self.implantsBoostersViewStatsLabel, self.implantsBoostersViewStats)
    self.implantsBoostersViewGroupLabel = gtk.Label("Implant Market Group")
    self.implantsBoostersViewGroupEntry = self.generateMenuItem(self.implantsBoostersViewGroupLabel, self.implantsBoostersViewGroup)
    self.implantsBoostersMenu = self.generateMenu({})

def handleFittingChangedImplantsBoosters(self, *stuff):
    self.updateImplantBrowser()
        
def getSelectedImplantBooster(self):
    store, selected_rows = self.tvwImplantsBoosters.get_selection().get_selected_rows()
    if not selected_rows: return
    iter = store.get_iter(selected_rows[0])
    implant = store.get_value(iter, 4)
    return implant
    
def implantsBoostersViewStats(self, *stuff):
    itemStatsWindow(self.getSelectedImplantBooster(), self.getActiveFit(), None)

def implantsBoostersViewGroup(self, *stuff):
    self.expandToItem(self.getSelectedImplantBooster())

def sortBySlotness(self, store, iter1, iter2):
    i1 = store.get_value(iter1, 4)
    i2 = store.get_value(iter2, 4)
    if i1 == None or i2 == None:
        if store.get_value(iter1, 1) == "Implants": return -1
        elif store.get_value(iter2, 1) == "Implants": return 1
        else: return 0
        
    col = store.get_sort_column_id()[0]
    slot1 = store.get_value(iter1, col)
    slot2 = store.get_value(iter2, col)
    if slot1 == None:
        return 1
    if slot2 == None:
        return -1
    
    slot1 = int(slot1)
    slot2 = int(slot2)
    if slot1 > slot2:
        return 1
    elif slot1 < slot2:
        return -1
    else:
        return 0
    
def updateImplantBrowser(self):
    store, selected_rows = self.tvwImplantsBoosters.get_selection().get_selected_rows()
    if len(store) >= 2:
        state1 = self.tvwImplantsBoosters.row_expanded((0,))\
            or not store.iter_has_child(store.get_iter((0,)))
        state2 = self.tvwImplantsBoosters.row_expanded((1,))\
            or not store.iter_has_child(store.get_iter((1,)))
    else:
        state1 = True
        state2 = True
    store.clear()
    fit = self.getActiveFit()
    iterBooster = store.append(None, (pixbufLoader.getPixbuf("booster"), "Boosters", None, None, None, None))
    iterImplant = store.append(None, (pixbufLoader.getPixbuf("hardwiring"), "Implants", None, None, None, None))
    if fit == None: return
    for slot, module in fit.implants.iteritems():
        pixbuf = pixbufLoader.getPixbuf(module.icon, True, "16x16")
        iter = iterImplant
        slot = module.getModifiedAttribute("implantness")
        store.append(iter, (pixbuf, module.name, "%d" % slot, module.description, module, None))
    
    for slot, (module, activeSideEffects) in fit.boosters.iteritems():
        pixbuf = pixbufLoader.getPixbuf(module.icon, True, "16x16")
        iter = iterBooster
        slot = module.getModifiedAttribute("boosterness")
        store.append(iter, (pixbuf, module.name, "%d" % slot, module.description, module, None))
        
    if state1: self.tvwImplantsBoosters.expand_row((0,), False)
    if state2: self.tvwImplantsBoosters.expand_row((1,), False)
    if selected_rows:
        selected_row = selected_rows[0]
        if len(selected_row) > 1:
            iter = store.get_iter(selected_row[:1])
            if store.iter_has_child(iter): self.tvwImplantsBoosters.get_selection().select_path(selected_row)
            else: self.tvwImplantsBoosters.get_selection().select_path(selected_row[:1])

def tvwImplantsBoostersClicked(self, widget, event):
    fit = self.getActiveFit()
    widget.do_button_press_event(widget, event)
    stuff = widget.get_path_at_pos(int(event.x), int(event.y))
    if stuff == None:
        widget.get_selection().unselect_all()
        return
    if fit == None: return
    if event.button == 3:
        store, selected_rows = self.tvwImplantsBoosters.get_selection().get_selected_rows()
        iter = store.get_iter(selected_rows[0])
        mod = store.get_value(iter, 4)
        if mod == None: return
        #Remove old menu entries
        for it in self.implantsBoostersMenu: self.implantsBoostersMenu.remove(it)

        implantCatName = self.getItemCategoryName(self.getSelectedImplantBooster()) or "Implant"

        self.implantsBoostersViewStatsLabel.set_text(implantCatName + " Stats")
        self.implantsBoostersMenu.append(self.implantsBoostersViewStatsEntry)

        if self.findMktGroup(self.getSelectedImplantBooster()):
            self.implantsBoostersViewGroupLabel.set_text(implantCatName + " Market Group")
            self.implantsBoostersMenu.append(self.implantsBoostersViewGroupEntry)

        #Add extra menu entries for enabling/disabling the side effects
        separator = False
        for effect in mod.effects:
            if "boosterSideEffect" in effect.type:
                if not separator:
                    self.implantsBoostersMenu.append(gtk.SeparatorMenuItem())
                    separator = True
                menuItem = gtk.MenuItem()
                menuItem.effect = effect.name
                check = gtk.CheckButton(effect.displayName or effect.name)
                slot = mod.getModifiedAttribute("boosterness")
                check.set_active(effect.name in fit.boosters[slot][1])
                menuItem.add(check)
                self.implantsBoostersMenu.append(menuItem)
                menuItem.connect("activate", self.toggleSideEffect, effect)
        
        self.implantsBoostersMenu.show_all()
        self.implantsBoostersMenu.popup(None, None, None, event.button, event.time)

    if event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS:
        store, selected_rows = self.tvwImplantsBoosters.get_selection().get_selected_rows()
        #it's possible to double-click expand/collapse arrow w/o selecting anything, so
        #we have to check if anything is selected
        if not selected_rows: return
        selected_row = selected_rows[0]
        iter = store.get_iter(selected_row)
        slot, mod = store.get(iter, 2, 4)
        if mod != None:
            if mod.group.name == "Booster": del fit.boosters[int(slot)]
            else: del fit.implants[int(slot)]
            self.manageRecent(mod)
            self.emit("fitting-changed")
        else:
            if self.tvwImplantsBoosters.row_expanded(selected_row):
                self.tvwImplantsBoosters.collapse_row(selected_row)
            else: self.tvwImplantsBoosters.expand_row(selected_row, False)
        
def toggleSideEffect(self, source, effect):
    booster = self.getSelectedImplantBooster()
    fit = self.getActiveFit()
    if fit == None: return
    slot = booster.getModifiedAttribute("boosterness")
    active = fit.boosters[slot][1]
    if effect.name in active: active.remove(effect.name)
    else: active.append(effect.name)
    self.emit("fitting-changed")
