#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
import gobject
from model import marketGroup, graphic, category, group, item
from gui import pixbufLoader
import copy
import re

def init(self):
    #Search stuff
    self.itemSearchActive = False
    self.entrySearchItem.connect("activate", self.scheduleSearch)
    self.entrySearchItem.connect("changed", self.scheduleSearch)
    self.btnSearchItem.connect("clicked", self.scheduleSearch)
    self.pendingSearch = None
    #Load favorites
    if not "favoriteItems" in self.guiSettings: self.guiSettings["favoriteItems"] = set()
    self.favoriteItems = self.guiSettings["favoriteItems"]
    #Check if favoriteItems is still in the old format and if so, convert
    newFavs = set()
    for i in self.favoriteItems:
        if isinstance(i, item.item):
            newFavs.add(i.ID)
    if len(newFavs) > 0: self.favoriteItems = newFavs
            
    if not "recentItems" in self.guiSettings: self.guiSettings["recentItems"] = []
    self.recentItems = self.guiSettings["recentItems"]
    for i in range(len(self.recentItems)):
        if isinstance(self.recentItems[i], item.item):
            self.recentItems[i] = self.recentItems[i].ID
    
    store = gtk.TreeStore(gtk.gdk.Pixbuf, str, object)
    store.set_sort_column_id(1, gtk.SORT_ASCENDING)
    store.set_sort_func(1, self.groupSort)
    self.tvwGroups.set_model(store)
    self.tvwGroups.set_tooltip_column(2)
    self.tvwGroups.set_headers_visible(False)
    
    imageRenderer = gtk.CellRendererPixbuf()
    nameRenderer = gtk.CellRendererText()
    col = gtk.TreeViewColumn()

    col.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)
    col.pack_start(imageRenderer, False)
    col.pack_start(nameRenderer, True)
    col.add_attribute(imageRenderer, 'pixbuf', 0)
    col.add_attribute(nameRenderer, 'text', 1)
    self.tvwGroups.append_column(col)
    #Modules
    mGroupMods = marketGroup.getMarketGroup(ID = 9)
    self.buildGroups(mGroupMods, None, True)
    #Rigs
    mGroupRigs = marketGroup.getMarketGroup(ID = 1111)
    self.buildGroups(mGroupRigs, None, True)
    #Drones
    mGroupDrones = marketGroup.getMarketGroup(ID = 157)
    self.buildGroups(mGroupDrones, None, True)
    #Ammo
    mGroupAmmo = marketGroup.getMarketGroup(ID = 11)
    self.buildGroups(mGroupAmmo, None, True)
    #Subsystems
    mGroupSubsystems = marketGroup.getMarketGroup(ID = 1112)
    self.buildGroups(mGroupSubsystems, None, True)
    #Implants & Boosters
    mGroupImplantsBoosters = marketGroup.getMarketGroup(ID = 24)
    iter = self.addGroup(mGroupImplantsBoosters.name, mGroupImplantsBoosters, None)
    cat = category.getCategory(name = "Implant")
    grps = group.getGroupsByCategory(cat.ID)
    for grp in grps:
        if grp.published == 1:
            if grp.name == "Booster":
                pixbuf = pixbufLoader.getPixbuf("booster")
            else:
                pixbuf = pixbufLoader.getPixbuf("hardwiring")
            store.append(iter, (pixbuf, grp.name, grp))
    
    #Wormhole effect beacons
    groupWH = group.getGroup(ID = 920)
    iter = store.append(None, (None, "Wormhole Effects", None))
    #We need to classify the wormhole effects into groups, we'll use a regex match for that
    groups = set()
    items = item.getItemsByGroup(group = groupWH.ID)
    effectBeaconRe = re.compile("(.*) Effect Beacon Class (.*)")
    for i in items:
        if re.search(effectBeaconRe, i.name):
            t, c = re.match(effectBeaconRe, i.name).groups()
            groups.add(t)
    
    #Add Red Giants manualy because their names are different for some reason
    groups.add("Red Giant")
    
    for g in groups: store.append(iter, (None, g, "wh"))
    
    #Favorites
    store.append(None, (None, "Favorites", "favorite"))
    #Recently used
    store.append(None, (None, "Recently Used", "recent"))
    
    #Connect events
    self.tvwGroups.connect("button-press-event", self.groupClicked)

def buildGroups(self, parentGroup, parentIter, includeParent = False):
    store  = self.tvwGroups.get_model()
    if includeParent:
        parentIter = self.addGroup(parentGroup.name, parentGroup, parentIter)
    
    if parentGroup.children:
        for name, mGroup in parentGroup.children.iteritems():
            if name != "Deployable Equipment":
                iter = self.addGroup(name, mGroup, parentIter)
                self.buildGroups(mGroup, iter, False)
        
    if includeParent: return parentIter

def addGroup(self, name, mGroup, iter):
    store = self.tvwGroups.get_model()
    icon = mGroup.icon
    if icon:
        pixbuf = pixbufLoader.getPixbuf(icon, True, "16x16")
    else:
        pixbuf = None
            
    return store.append(iter, (pixbuf, name, mGroup))

def groupSort(self, store, iter1, iter2):
    #Put stuff of type group or marketGroup at top, after then the rest
    grp1, grp2 = store.get_value(iter1, 2), store.get_value(iter2, 2)
    prio1 = isinstance(grp1, marketGroup.marketGroup) or isinstance(grp1, group.group) or grp1 == None
    prio2 = isinstance(grp2, marketGroup.marketGroup) or isinstance(grp2, group.group) or grp2 == None
    if prio1 != prio2: return prio1 and -1 or 1
    else:
        name1, name2 = store.get_value(iter1, 1), store.get_value(iter2, 1)
        return cmp(name1, name2)

def scheduleSearch(self, *stuff):
    text = self.entrySearchItem.get_text().encode("ascii", "replace")
    #search only if 3 or more symbols are typed
    if len(text) >= 3:
        if self.pendingSearch: gobject.source_remove(self.pendingSearch)
        self.pendingSearch = gobject.idle_add(self.searchItem, text)
    #if user deleted symbols, show contents of currently selected group
    elif len(text) == 0:
        self.groupSelected()
    #if some symbols were typed in but amount is not enough to start search, pass along empty list
    else:
        self.itemStore = []
        self.itemBrowserSetToggles()
        self.itemBrowserFillView()

def searchItem(self, text):
    self.pendingSearch = None
    if not self.itemSearchActive:
        self.itemSearchActive = True
    goodCats = ("Drone",
                "Module",
                "Subsystem",
                "Charge",
                "Implant")
    items = item.searchItem(text)
    self.itemStore = []
    for i in items:
        if i.published == 1 and i not in self.itemStore and (i.group.category.name in goodCats or i.group.name == "Effect Beacon"):
            self.itemStore.append(i)
    self.itemBrowserSetToggles()
    self.itemBrowserFillView()

def groupClicked(self, widget, event):
    widget.do_button_press_event(widget, event)
    stuff = widget.get_path_at_pos(int(event.x), int(event.y))
    if stuff == None:
        widget.get_selection().unselect_all()
        self.groupSelected()
        return
    if event.type == gtk.gdk.BUTTON_PRESS:
        self.groupSelected()
    if event.type == gtk.gdk._2BUTTON_PRESS and event.button == 1:
        store, selected_rows = self.tvwGroups.get_selection().get_selected_rows()
        selected_row = selected_rows[0]
        if self.tvwGroups.row_expanded(selected_row):
            self.tvwGroups.collapse_row(selected_row)
        else: self.tvwGroups.expand_row(selected_row, False)

def groupSelected(self, fillView = True, *stuff):
    #mark search as inactive - we've placed it here as this method is called if user
    #tries to view any non-search group using any way
    if self.itemSearchActive:
        self.itemSearchActive = False
    store, selected_rows = self.tvwGroups.get_selection().get_selected_rows()
    self.itemStore = []
    #if nothing is selected, pass it along anyway for further processing (like graying out togglebuttons)
    if not selected_rows:
        self.itemBrowserSetToggles()
        self.itemBrowserFillView()
        return
    iter = store.get_iter(selected_rows[0])
    name, grp = store.get(iter, 1, 2)

    #Normal items, those are in market groups so it's easy
    dovars = False
    if isinstance(grp, marketGroup.marketGroup):
        dovars = True
        items = item.getItemsByGroup(grp)
    elif isinstance(grp, group.group):
        dovars = True
        items = item.getItemsByGroup(group = grp)
    elif grp == "recent" or grp == "favorite":
        if grp == "recent":
            items = copy.copy(self.recentItems)
            for i in range(len(items)): items[i] = item.getItem(ID = items[i])
        elif grp == "favorite":
            items = []
            for i in self.favoriteItems: items.append(item.getItem(ID = i))
    elif grp == "wh":
        items = []
        effectBeaconRe = re.compile("%s Effect Beacon Class (.*)" % name)
        effectBeaconRe2 = re.compile("%s Beacon Class (.*)" % name)
        beacons = item.getItemsByGroup(group = 920)
        for i in beacons:
            if re.search(effectBeaconRe, i.name) or re.search(effectBeaconRe2, i.name):
                items.append(i)
    else: items = []

    for i in items:
        if i.published == 1 and i not in self.itemStore:
            self.itemStore.append(i)
        if dovars:
            for v in item.getVariations(i):
                if v.published == 1 and v not in self.itemStore and v.metaGroupID != 2:
                    self.itemStore.append(v)

    self.itemBrowserSetToggles(grp = grp)
    if fillView: self.itemBrowserFillView()

def getSelectedGroup(self):
    store, selected_rows = self.tvwGroups.get_selection().get_selected_rows()
    if not selected_rows: return
    iter = store.get_iter(selected_rows[0])
    group = store.get_value(iter, 2)
    return group

def lookForGroup(self, neededGroup, iter = None, store = None, i = 0):
    store = store or self.tvwGroups.get_model()
    iter = iter or store.get_iter((0,))
    while iter != None:
        group = store.get_value(iter, 2)
        if group == neededGroup: return store.get_path(iter)
        iterChild = store.iter_children(iter)
        if iterChild != None:
            inGroup = self.lookForGroup(neededGroup, iterChild, store, i + 1)
            if inGroup != None:
                return inGroup
        
        iter = store.iter_next(iter)

def expandToItem(self, itemList):
    if isinstance(itemList, list) or isinstance(itemList, tuple): itm = itemList[0]
    else: itm = itemList
    if not itm.marketGroupID: baseItem = item.getBase(itm.ID) or itm
    else: baseItem = itm
    path = self.lookForGroup(baseItem.marketGroup) or self.lookForGroup(baseItem.group)
    self.tvwGroups.expand_to_path(path)
    self.tvwGroups.scroll_to_cell(path, use_align=True, row_align=0.5)
    self.tvwGroups.get_selection().select_path(path)
    #we vill fill item browser view a bit later
    self.groupSelected(fillView = False)
    self.itemBrowserTogglesPrepareMode = True
    itemTabs = []
    if isinstance(itemList, list) or isinstance(itemList, tuple):
        for itm in itemList:
            metaGroup = itm.metaGroupID
            if metaGroup == 4 and not self.tbnFaction in itemTabs: itemTabs.append(self.tbnFaction)
            elif metaGroup == 5 and not self.tbnOfficer in itemTabs: itemTabs.append(self.tbnOfficer)
            elif metaGroup == 6 and not self.tbnComplex in itemTabs: itemTabs.append(self.tbnComplex)
            elif (metaGroup not in (4, 5, 6) or not metaGroup) and not self.tbnNormal in itemTabs: itemTabs.append(self.tbnNormal)
    else:
        metaGroup = itm.metaGroupID
        if metaGroup == 4: itemTabs.append(self.tbnFaction)
        elif metaGroup == 5: itemTabs.append(self.tbnOfficer)
        elif metaGroup == 6: itemTabs.append(self.tbnComplex)
        elif (metaGroup not in (4, 5, 6) or not metaGroup): itemTabs.append(self.tbnNormal)
    for candidate in (self.tbnNormal, self.tbnFaction, self.tbnComplex, self.tbnOfficer):
        if candidate in itemTabs: candidate.set_active(True)
        else: candidate.set_active(False)
    self.itemBrowserTogglesPrepareMode = False
    self.itemBrowserFillView()

def findMktGroup(self, itm, *stuff):
    itmMktGrp = itm.marketGroupID
    if not itmMktGrp:
        base =  item.getBase(itm.ID)
        if base:
            itmMktGrp = base.marketGroupID
    return itmMktGrp