#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
from gui import pixbufLoader
from gui.itemStatsWindow import itemStatsWindow

def init(self):
    self.tvwDrones.connect("button-press-event", self.tvwDronesClicked)
    
    store = gtk.ListStore(str, str, str, bool, object, str, str, str, str, str)
    self.tvwDrones.set_model(store)
    self.tvwDrones.set_tooltip_column(2)
    nameRenderer = gtk.CellRendererText()
    amountRenderer = gtk.CellRendererText()
    activeRenderer = gtk.CellRendererToggle()
    self.droneStateCol = gtk.TreeViewColumn()
    col = gtk.TreeViewColumn('Drones')
    self.droneStateCol.pack_start(activeRenderer, False)
    col.pack_start(amountRenderer, False)
    col.pack_start(nameRenderer, True)
    col.add_attribute(amountRenderer, 'text', 0)
    col.add_attribute(nameRenderer, 'text', 1)
    self.droneStateCol.add_attribute(activeRenderer, 'active', 3)
    activeRenderer.set_property("activatable", True)
    self.tvwDrones.append_column(self.droneStateCol)
    self.tvwDrones.append_column(col)
    #Drone dps col
    dpsRenderer = gtk.CellRendererText()
    imgDroneDps = gtk.image_new_from_pixbuf(pixbufLoader.getPixbuf("droneDps"))
    imgDroneDps.show()
    col = gtk.TreeViewColumn()
    col.set_widget(imgDroneDps)
    col.pack_start(dpsRenderer)
    col.add_attribute(dpsRenderer, 'text', 6)
    self.tvwDrones.append_column(col)
    #Drone range col
    rangeRenderer = gtk.CellRendererText()
    imgDroneRange = gtk.image_new_from_pixbuf(pixbufLoader.getPixbuf("range"))
    imgDroneRange.show()
    col = gtk.TreeViewColumn()
    col.set_widget(imgDroneRange)
    col.pack_start(rangeRenderer)
    col.add_attribute(rangeRenderer, 'text', 7)
    self.tvwDrones.append_column(col)
    #Drone tracking col
    trackingRenderer = gtk.CellRendererText()
    imgDroneTracking = gtk.image_new_from_pixbuf(pixbufLoader.getPixbuf("trackingSpeed"))
    imgDroneTracking.show()
    col = gtk.TreeViewColumn()
    col.set_widget(imgDroneTracking)
    col.pack_start(trackingRenderer)
    col.add_attribute(trackingRenderer, 'text', 8)
    self.tvwDrones.append_column(col)
    #Drone speed col
    speedRenderer = gtk.CellRendererText()
    imgDroneSpeed = gtk.image_new_from_pixbuf(pixbufLoader.getPixbuf("droneSpeed"))
    imgDroneSpeed.show()
    col = gtk.TreeViewColumn()
    col.set_widget(imgDroneSpeed)
    col.pack_start(speedRenderer)
    col.add_attribute(speedRenderer, 'text', 9)
    self.tvwDrones.append_column(col)
    
    #Generate context menus
    self.droneStatsLabel = gtk.Label("Drone Stats")
    self.droneStatsEntry = self.generateMenuItem(self.droneStatsLabel, self.droneStats)
    self.droneGroupLabel = gtk.Label("Drone Market Group")
    self.droneGroupEntry = self.generateMenuItem(self.droneGroupLabel, self.droneGroup)
    self.droneChargeStatsLabel = gtk.Label("Drone Charge Stats")
    self.droneChargeStatsEntry = self.generateMenuItem(self.droneChargeStatsLabel, self.droneChargeStats)
    self.droneMenu = self.generateMenu({})
    
    #state menu
    self.droneStateMenuItem = gtk.MenuItem()
    self.droneStateMenuLabel = gtk.Label()
    self.droneStateMenuLabel.set_alignment(0, 0.5)
    self.droneStateMenuItem.add(self.droneStateMenuLabel)
    self.droneStateMenuItem.connect("activate", self.spawnDroneSpinWindow)
    
    #Make the spin window
    self.spinWindow = gtk.Window()
    box = gtk.VBox()
    self.droneSpinLabel = gtk.Label()
    box.pack_start(self.droneSpinLabel)
    self.droneSpin = gtk.SpinButton(None, 0.0, 0)
    self.droneSpin.set_snap_to_ticks(True)
    self.droneSpin.set_numeric(True)
    self.droneSpin.set_sensitive(True)
    self.droneSpin.set_update_policy(gtk.UPDATE_IF_VALID)
    box.pack_start(self.droneSpin)
    button = gtk.Button(stock = gtk.STOCK_OK)
    button.connect("clicked", self.spinDrones)
    box.pack_start(button)
    self.spinWindow.add(box)
    
    #connect our fitting changed handler
    self.connect("fitting-changed", self.handleFittingChangedDroneBrowser)
    self.handleFittingChangedDroneBrowser()
    
def handleFittingChangedDroneBrowser(self, *stuff):
    fit = self.getActiveFit()
    if fit == None:
        self.tvwDrones.get_model().clear()
    else:
        droneStore = self.tvwDrones.get_model()
        droneStore.clear()
        for drone in fit.drones:
            item, active, amount = drone.getItem(), drone.getAmountActive(), drone.getAmountTotal()
            for num, toggle in ((active, True), (amount - active, False)):
                if num > 0:
                    maxRange = item.getModifiedAttribute("maxRange") or item.getModifiedAttribute("_maxRange")
                    falloff = item.getModifiedAttribute("falloff")
                    maxMissileRange = item.getModifiedAttribute("_maxMissileRange")
                    if maxRange != None:
                        maxRange = maxRange / 1000.0
                        if falloff != None and falloff != 0:
                            falloff = falloff / 1000.0
                            rangeStr = '%.1f + %.1fkm' % (maxRange, falloff)
                        else: rangeStr = '%.1fkm' % (maxRange)
                    elif maxMissileRange != None:
                        maxMissileRange = maxMissileRange / 1000.0
                        rangeStr = '%s%.1fkm' % ("<", maxMissileRange)
                    else:
                        rangeStr = None
                    trackingSpeed = item.getModifiedAttribute("trackingSpeed")
                    if trackingSpeed: tracking = "%.4f" % trackingSpeed
                    else: tracking = None
                    dps = item.getModifiedAttribute("_dps")
                    if dps: dmg = "%.1f" % (dps * num)
                    else: dmg = None
                    speed = item.getModifiedAttribute("maxVelocity")
                    if speed:
                        if speed > 1000: speed = '%.1f km/s' % (speed / 1000.0)
                        else: speed = '%.0f m/s' % speed
                    else: speed = None
                    droneStore.append(("%dx" % num, item.name, item.description, toggle, drone, None, dmg, rangeStr, trackingSpeed, speed))
                
        total = fit.ship.getModifiedAttribute("_maxActiveDrones")
        used = fit.getNumActiveDrones()
        if used > total:
            self.lblDronesUsed.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse('red'))
        else: self.lblDronesUsed.modify_fg(gtk.STATE_NORMAL, None)
        self.lblDronesUsed.set_text("%d" % used)
        self.lblDronesTotal.set_text("%d" % total)

def getSelectedDrone(self):
    store, selected_rows = self.tvwDrones.get_selection().get_selected_rows()
    if not selected_rows: return
    iter = store.get_iter(selected_rows[0])
    drone = store.get_value(iter, 4)
    return drone

def droneStats(self, *stuff):
    itemStatsWindow(self.getSelectedDrone().getItem(), self.getActiveFit(), ammo=self.getSelectedDrone().getAmmo())
    
def droneGroup(self, *stuff):
    self.expandToItem(self.getSelectedDrone().getItem())

def droneChargeStats(self, *stuff):
    itemStatsWindow(self.getSelectedDrone().getAmmo(), self.getActiveFit(), None)
	
def removeDrone(self, widget):
    #Get the drone
    store, selected_rows = self.tvwDrones.get_selection().get_selected_rows()
    if not selected_rows: return
    iter = store.get_iter(selected_rows[0])
    drone, active = store.get(iter, 4, 3)
    fit = self.getActiveFit()
    if fit == None: return
    f = fit.removeDrone(drone, active)
    self.manageRecent(drone.getItem())
    self.emit("fitting-changed")
    if not f: widget.get_selection().select_path(selected_rows[0])

def tvwDronesClicked(self, widget, event):
    widget.do_button_press_event(widget, event)
    stuff = widget.get_path_at_pos(int(event.x), int(event.y))
    if stuff == None: 
        if event.type == gtk.gdk.BUTTON_PRESS: widget.get_selection().unselect_all()
        return
    store, selected_rows = widget.get_selection().get_selected_rows()
    iter = store.get_iter(selected_rows[0])
    if event.button == 1:
        col = widget.get_path_at_pos(int(event.x), int(event.y))
        if col: col = col[1]
        else: return
        if event.type == gtk.gdk.BUTTON_PRESS and col == self.droneStateCol:
            drone, active = store.get(iter, 4, 3)
            fit = self.getActiveFit()
            if fit == None: return
            #We need to disable the active ones:
            if active: drone.setAmountActive(0)
            #We need to enable the inactive ones
            else: drone.setAmountActive(drone.getAmountTotal())
            self.emit("fitting-changed")
            widget.get_selection().select_path(selected_rows[0])
        elif event.type == gtk.gdk._2BUTTON_PRESS and col != self.droneStateCol:
            self.removeDrone(widget)
    elif event.button == 3:
        drone, active = store.get(iter, 4, 3)
        self.droneStateMenuLabel.set_text((active and "Disable" or "Enable") + " #")

        for it in self.droneMenu: self.droneMenu.remove(it)

        droneCatName = self.getItemCategoryName(self.getSelectedDrone().getItem()) or "Drone"
        droneAmmoCatName = self.getItemCategoryName(self.getSelectedDrone().getAmmo()) or "Charge"

        self.droneStatsLabel.set_text(droneCatName + " Stats")
        self.droneMenu.append(self.droneStatsEntry)
        self.droneGroupLabel.set_text(droneCatName + " Market Group")
        self.droneMenu.append(self.droneGroupEntry)
        if(self.getSelectedDrone().getAmmo()):
            self.droneChargeStatsLabel.set_text(droneCatName + " " + droneAmmoCatName + " Stats")
            self.droneMenu.append(self.droneChargeStatsEntry)
        self.droneMenu.append(gtk.SeparatorMenuItem())
        self.droneMenu.append(self.droneStateMenuItem)
        self.droneMenu.show_all()
        self.droneMenu.popup(None, None, None, event.button, event.time)


def spawnDroneSpinWindow(self, *stuff):
    store, selected_rows = self.tvwDrones.get_selection().get_selected_rows()
    iter = store.get_iter(selected_rows[0])
    active, drone = store.get(iter, 3, 4)
    q = active and "Disable" or "Enable"
    self.droneSpinLabel.set_text("Number of drones to " + q + "?")
    fit = self.getActiveFit()
    total, numActive = drone.getAmountTotal(), drone.getAmountActive()
    if not active: max = total - numActive
    else: max = numActive
    adj = gtk.Adjustment(0, 0, max, 1, 1)
    self.droneSpin.set_adjustment(adj)
    self.droneSpin.set_value(0)
    self.spinWindow.set_position(gtk.WIN_POS_MOUSE)
    self.spinWindow.show_all()

def spinDrones(self, *stuff):
    fit = self.getActiveFit()
    store, selected_rows = self.tvwDrones.get_selection().get_selected_rows()
    iter = store.get_iter(selected_rows[0])
    drone, active = store.get(iter, 4, 3)
    num = self.droneSpin.get_value_as_int()
    max, currActive = drone.getAmountTotal(), drone.getAmountActive()
    if active: currActive -= num
    else: currActive += num
    drone.setAmountActive(currActive)
    self.spinWindow.hide()
    self.emit("fitting-changed")
