#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
from model import dataFolder, fitting
from gui import pixbufLoader
from gui.damagePatternWindow import damagePatternWindow
import copy

def init(self):
    self.damagePatternMenu = gtk.Menu()
    p = dataFolder.pickleFileToObj("dmg") or \
            ("Uniform", {"Uniform" : copy.copy(fitting.defaultDamagePattern) })
    self.damagePatterns = p[1]
    self.activePattern = p[0]
    #Add raw if it isn't there already
    if not "Raw" in self.damagePatterns: self.damagePatterns["Raw"] = {}
    
    #Add 100% damage patterns if they're not already there
    for type in fitting.defaultDamagePattern.iterkeys():
        type = type.capitalize()
        if not type in self.damagePatterns:
            p = {}
            for tt in fitting.defaultDamagePattern.iterkeys():
                if tt.capitalize() == type: p[tt] = 100
                else: p[tt] = 0
            self.damagePatterns[type] = p
    
    self.updateDamagePatternMenu()
    self.eboxResistances.connect("button-press-event", self.tankWidgetClicked)
    self.eboxRechargeRates.connect("button-press-event", self.tankWidgetClicked)
    
    self.tvwItems.connect("button-press-event", self.manageAmmoProfileEntry)
    #Menu entry to set ammo as damage profile
    self.itemBrowserAmmoSetAsProfileLabel = gtk.Label("Set Item as Damage Pattern")
    self.itemBrowserAmmoSetAsProfileEntry = self.generateMenuItem(self.itemBrowserAmmoSetAsProfileLabel, self.setAmmoAsProfile)
    
def updateDamagePatternMenu(self):
    damagePatternOrder = ["em", "thermal", "kinetic", "explosive"]
    self.damagePatternMenu.foreach(lambda widget: self.damagePatternMenu.remove(widget))
    default = self.activePattern
    patterns = self.damagePatterns
    patList = []
    for name in patterns:
        if name != "Uniform" and name != "Raw": patList.append(name)
            
    patList.sort()
    patList.append("Uniform")
    patList.append("Raw")
    for name in patList:
        pattern = self.damagePatterns[name]
        menuItem = gtk.MenuItem()
        box = gtk.HBox()
        if default == name: box.pack_start(gtk.Label(u'\u2022'), False, False)
        else: box.pack_start(gtk.Label(" "), False, False)
        lbl = gtk.Label(name + (len(pattern) > 0 and ": " or ""))
        lbl.set_alignment(0, 0.5)
        box.pack_start(lbl, True, True)
        total = float(sum(pattern.values()))
        for type in damagePatternOrder:
            if type in pattern:
                amount = pattern[type]
                img = gtk.image_new_from_pixbuf(pixbufLoader.getPixbuf(type))
                box.pack_start(img, False, False)
                box.pack_start(gtk.Label("%.2f%%" % (amount / (total or 1) * 100)))
            
        menuItem.add(box)
        self.damagePatternMenu.append(menuItem)
        menuItem.connect("activate", self.selectDamagePattern, name)
    
    menuItem = gtk.MenuItem()
    lbl = gtk.Label("Edit Patterns")
    lbl.set_alignment(0, 0.5)
    menuItem.add(lbl)
    menuItem.connect("activate", lambda widget: damagePatternWindow(self))
    self.damagePatternMenu.append(menuItem)

def manageAmmoProfileEntry(self, widget, event):
    widget.do_button_press_event(widget, event)
    item = self.getSelectedItem()
    if item == None: return
    validity = False
    if item.group.category.name == "Charge":
        for type in ("em", "thermal", "kinetic", "explosive"):
            if item.getModifiedAttribute("%sDamage" % type):
                validity = True
                break

    if validity and not self.itemBrowserAmmoSetAsProfileEntry in self.itemBrowserItemMenuExternals:
        self.itemBrowserAmmoSetAsProfileLabel.set_text("Set " + (self.getItemCategoryName(item) or "Charge") + " as Damage Pattern")
        self.itemBrowserItemMenuExternals.append(self.itemBrowserAmmoSetAsProfileEntry)
    elif not validity and self.itemBrowserAmmoSetAsProfileEntry in self.itemBrowserItemMenuExternals:
        self.itemBrowserItemMenuExternals.remove(self.itemBrowserAmmoSetAsProfileEntry)

def setAmmoAsProfile(self, *stuff):
    pattern = {}
    item = self.getSelectedItem()
    for type in ("em", "thermal", "kinetic", "explosive"):
        pattern[type] = item.getModifiedAttribute("%sDamage" % type) or 0
    self.damagePatterns["Ammo"] = pattern
    self.activePattern = "Ammo"
    self.emit("fitting-changed")
    self.updateDamagePatternMenu()

def selectDamagePattern(self, widget, newPattern):
    self.activePattern = newPattern
    self.emit("fitting-changed")
    self.updateDamagePatternMenu()
    
def damagePatternsChanged(self):
    if not self.activePattern in self.damagePatterns:
        self.activePattern = "Uniform"
    self.updateDamagePatternMenu()

def tankWidgetClicked(self, widget, event):
    if event.button == 3:
        self.damagePatternMenu.show_all()
        self.damagePatternMenu.popup(None, None, None, event.button, event.time)
