#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
from gui.window import window
from gui.inputWindow import inputWindow
from gui.errorWindow import errorWindow
from gui.pluggable import pluggable
import copy
import gtk

class damagePatternWindow(window):
    def __init__(self, master):
        self.master = master
        signalsDict = {'exitRequest' : self.exit,
                       'delete' : self.exit,
                       'confirm' : self.confirm,
                       'patternChanged' : self.patternChanged,
                       'newPattern' : self.newPattern,
                       'deletePattern' : self.deletePattern,
                       'inputChanged' : self.inputChanged}
        
        window.__init__(self, "damagePatternWindow", signalsDict)
        self.initPluggable()
        store = gtk.ListStore(str, object)
        self.cmbCurrentPattern.set_model(store)
        nameRenderer = gtk.CellRendererText()
        self.cmbCurrentPattern.pack_start(nameRenderer, False)
        self.cmbCurrentPattern.add_attribute(nameRenderer, 'text', 0)
        store.set_sort_column_id(0, gtk.SORT_ASCENDING)
        self.damagePatterns = copy.deepcopy(master.damagePatterns)
        self.updateDamagePatterns(master.activePattern)
        self.initAllSections()
        self.window.show()
    
    def enable(self):
        self.cmbCurrentPattern.set_sensitive(True)
        self.btnNewPattern.set_sensitive(True)
        self.btnOk.set_sensitive(True)
        self.valid = True
        
    def disable(self):
        self.cmbCurrentPattern.set_sensitive(False)
        self.btnNewPattern.set_sensitive(False)
        self.btnOk.set_sensitive(False)
        self.valid = False
        
    def updateDamagePatterns(self, setActive = "Uniform"):
        store = self.cmbCurrentPattern.get_model()
        oldActive = self.cmbCurrentPattern.get_active()
        store.clear()
        for name, pattern in self.damagePatterns.iteritems():
            if name != "Raw":
                iter = store.append((name, pattern))
                if name == setActive:
                    path = store.get_path(iter)
                    self.cmbCurrentPattern.set_active(path[0])
        
        active = self.cmbCurrentPattern.get_active()
        if active == None or active == -1: self.cmbCurrentPattern.set_active(oldActive)
        
    def exit(self, *stuff):
        self.window.destroy()
    
    def confirm(self, *stuff):
        if self.valid == False:
            errorWindow(self, "The pattern contains invalid characters")
            return

        self.master.damagePatterns = self.damagePatterns
        self.master.damagePatternsChanged()
        self.window.destroy()
    
    def inputChanged(self, *stuff):
        self.enable()
        path = self.cmbCurrentPattern.get_active()
        if path == -1 or path == None: return
        store = self.cmbCurrentPattern.get_model()
        iter = store.get_iter(path)
        name, pattern = store.get(iter, 0, 1)
        for name in pattern:
            try:
                value = float(getattr(self, "entry" + name.capitalize()).get_text())
                pattern[name] = value
            except ValueError: self.disable()
        total = sum(pattern.values()) or 1
        for name, value in pattern.iteritems():
            getattr(self, "lbl" + name.capitalize() + "Perc").set_text("%.1f%%" % (value / total * 100))

    def patternChanged(self, *stuff):
        path = self.cmbCurrentPattern.get_active()
        if path == -1 or path == None: return
        store = self.cmbCurrentPattern.get_model()
        iter = store.get_iter(path)
        name, pattern = store.get(iter, 0, 1)
        self.btnDeletePattern.set_sensitive(not name == "Uniform")
        for type, amount in pattern.iteritems():
            entry = getattr(self, "entry" + type.capitalize())
            entry.handler_block_by_func(self.inputChanged)
            if name == "Uniform": entry.set_sensitive(False)
            else: entry.set_sensitive(True)
            entry.set_text("%.2f" % (amount))
            entry.handler_unblock_by_func(self.inputChanged)
        
        self.inputChanged()
            
    def newPattern(self, *stuff):
        inputWindow(self, "Name: ", self.newPatternConfirm)
    
    def newPatternConfirm(self, newName):
        if newName in self.damagePatterns:
            return False
        else:
            self.damagePatterns[newName] = {'em' : 0, 'explosive' : 0, 'kinetic' : 0, 'thermal' : 0}
            self.updateDamagePatterns(newName)
            return True
        
    def deletePattern(self, *stuff):
        path = self.cmbCurrentPattern.get_active()
        if path == -1 or path == None: return
        store = self.cmbCurrentPattern.get_model()
        iter = store.get_iter(path)
        name = store.get(iter, 0)[0]
        del self.damagePatterns[name]
        self.updateDamagePatterns()
        self.cmbCurrentPattern.set_active(path)
        
damagePatternWindow = pluggable(damagePatternWindow)