#!/usr/bin/env python

"""Setup script for the 'shellword.py'"""

from distutils.core import setup

description = "Parse a string into words like a POSIX shell does."
long_description = \
"""
This module parses a string into words according to the parings-rules
of a POSIX shell. These parsing rules are (quoted after 'man bash'):

1) Words are split at whitespace charakters; these are Space, Tab,
   Newline, Carriage-Return, Vertival-Tab (0B) and Form-Feet (0C).

   NB: Quotes do _not_ separate words! Thus
        "My"Fancy"Computer"
   will be parsed into a single word:
        MyFancyComputer

2) A non-quoted backslash (\) is the escape character. It preserves
   the literal value of the next character that follows.

3) Enclosing characters in single quotes preserves the literal value
   of each character within the quotes. A single quote may not occur
   between single quotes, even when preceded by a backslash.

   This means: baskslash (\) has no special meaning within single
   quotes. All charakters within single quotes are taken as-is.

4) Enclosing characters in double quotes preserves the literal value
   of all characters within the quotes, with the exception of \. The
   backslash retains its special meaning only when followed " or \. A
   double quote may be quoted within double quotes by preceding it
   with a backslash.
""" # " emacs happy

from distutils.command.bdist_rpm import bdist_rpm

class MyBDist_RPM(bdist_rpm):
    """Wrapper for 'bdist_rpm' handling 'python2'"""
    def finalize_options(self):
        if self.fix_python:
            import sys
            if sys.executable.endswith('/python2'):
                # this should be more sophisticated, but this
                # works for our needs here
                self.requires = self.requires.replace('python ', 'python2 ')
                self.build_requires = self.build_requires.replace('python ',
                                                                  'python2 ')
                self.release = (self.release or "1") + 'python2'
        bdist_rpm.finalize_options(self)


setup (name = "python-shellwords",
       version = "0.2",
       description = description,
       long_description = long_description,
       author = "Hartmut Goebel",
       author_email = "h.goebel@crazy-compilers.com",
       #maintainer = "Hartmut Goebel",
       #maintainer_email = "h.goebel@crazy-compilers.com",
       url = "http://www.crazy-compilers.com/py-lib/#shellwords",
       license = 'Python',
       platforms = ['POSIX'],
       keywords = ['shell', 'command-line', 'parsing'],
       py_modules = ['shellwords'],
       cmdclass = {'bdist_rpm': MyBDist_RPM},
      )
