/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import util.PVFile;
import util.StringOutputStream;

public class Cmd
extends Thread {
    public static String btExecutorTmp = "cr_run java -XX:-UsePerfData -Xmx400m -cp lib/cpsim.jar fr.imag.mescal.optft.sim.vmserver.TaskExecutor";
    public static String cp_Local_CMD;
    public static String rst_CMD;
    String[] threadInput;

    public Cmd(String[] input) {
        this.threadInput = input;
    }

    public Cmd(String input) {
        this.threadInput = input.split("\\s");
    }

    public static int CmdExec(String cmdline) {
        String[] cmd = cmdline.split("\\s");
        StringOutputStream sos = new StringOutputStream();
        StringOutputStream ses = new StringOutputStream();
        Cmd.CmdExec(cmd, sos, ses);
        if (!sos.getString().equals("")) {
            System.out.println(sos.getString());
        }
        if (!ses.getString().equals("")) {
            System.out.println(ses.getString());
            return 1;
        }
        return 0;
    }

    public static String CmdExec(String[] cmd) {
        StringOutputStream sos = new StringOutputStream();
        StringOutputStream ses = new StringOutputStream();
        Cmd.CmdExec(cmd, sos, ses);
        return sos.getString();
    }

    public static int CmdExec(String cmdline, StringOutputStream sos) {
        String[] cmd = cmdline.split("\\s");
        StringOutputStream ses = new StringOutputStream();
        Cmd.CmdExec(cmd, sos, ses);
        if (!ses.getString().equals("")) {
            System.out.println(ses.getString());
            return 1;
        }
        return 0;
    }

    public static int CmdExec(String[] cmdline, OutputStream os, OutputStream es) {
        try {
            Process p = Runtime.getRuntime().exec(cmdline);
            if (os != null && es != null) {
                BufferedInputStream input = new BufferedInputStream(p.getInputStream());
                BufferedInputStream error = new BufferedInputStream(p.getErrorStream());
                BufferedOutputStream output = new BufferedOutputStream(os);
                BufferedOutputStream errorOutput = new BufferedOutputStream(es);
                byte[] b = new byte[1024];
                int bytesRead = input.read(b);
                while (bytesRead != -1) {
                    output.write(b, 0, bytesRead);
                    bytesRead = input.read(b);
                }
                byte[] c = new byte[1024];
                int bytesRead2 = error.read(c);
                while (bytesRead2 != -1) {
                    errorOutput.write(c, 0, bytesRead2);
                    bytesRead2 = error.read(c);
                }
                output.close();
                errorOutput.close();
                input.close();
            } else {
                String lineError;
                String line;
                System.out.println("Getting input");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                System.out.println("Getting line");
                while ((line = input.readLine()) != null) {
                    System.out.println(line);
                }
                System.out.println("Getting error");
                while ((lineError = error.readLine()) != null) {
                    System.out.println(lineError);
                }
                System.out.println("closing");
                input.close();
            }
            p.waitFor();
            return p.exitValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 2;
        }
    }

    public static int CmdExec(String[] cmdline, OutputStream os) {
        try {
            System.out.println("Executing " + cmdline[0]);
            Process p = Runtime.getRuntime().exec(cmdline);
            if (os != null) {
                BufferedInputStream input = new BufferedInputStream(p.getInputStream());
                BufferedOutputStream output = new BufferedOutputStream(os);
                byte[] b = new byte[1024];
                int bytesRead = input.read(b);
                while (bytesRead != -1) {
                    output.write(b, 0, bytesRead);
                    bytesRead = input.read(b);
                }
                output.close();
                input.close();
            } else {
                String line;
                System.out.println("Getting input");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                System.out.println("Getting line");
                while ((line = input.readLine()) != null) {
                    System.out.println(line);
                }
                System.out.println("closing");
                input.close();
            }
            p.waitFor();
            return p.exitValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 2;
        }
    }

    public static int copy(String srcFile, String tgtDir) {
        String cmd = "cp " + srcFile + " " + tgtDir;
        int state = Cmd.CmdExec(cmd);
        return state;
    }

    public static int move(String srcFile, String tgtDir) {
        PVFile.checkCreateDir(tgtDir);
        String cmd = "mv " + srcFile + " " + tgtDir;
        int state = Cmd.CmdExec(cmd);
        return state;
    }

    public static String cr_checkpoint(String pid) {
        String cmd = "cr_checkpoint --pid " + pid;
        String[] input = cmd.split("\\s");
        StringOutputStream sos = new StringOutputStream();
        Cmd.CmdExec(input, (OutputStream)sos);
        return "context." + String.valueOf(pid);
    }

    public static String cr_checkpoint_specDir(String dir, String pid) {
        String cmd = "cr_checkpoint --pid " + pid + " -f " + dir + "/context." + pid;
        String[] input = cmd.split("\\s");
        Cmd.CmdExec(input);
        return "context." + String.valueOf(pid);
    }

    public static String cr_checkpoint_kill(String pid) {
        String cmd = "cr_checkpoint --pid " + pid + " --kill";
        String[] input = cmd.split("\\s");
        StringOutputStream sos = new StringOutputStream();
        Cmd.CmdExec(input, (OutputStream)sos);
        return "context." + String.valueOf(pid);
    }

    public static String cr_restart(String contextFile) {
        String cmd = rst_CMD.replace("CONTEXT", contextFile);
        String[] input = cmd.split("\\s");
        String error = Cmd.CmdExec(input);
        return error;
    }

    public static int getExeProcessID(String[] args) {
        String argString = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            argString = String.valueOf(argString) + s + " ";
            ++n2;
        }
        String keyword = String.valueOf(btExecutorTmp.replace("cr_run", "")) + " " + argString.trim();
        List<Integer> pidList = Cmd.getRunningPID(keyword.trim());
        if (pidList.isEmpty()) {
            return -1;
        }
        return pidList.get(0);
    }

    public static List<Integer> getRunningPID(String keyWord) {
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        String[] input = new String[]{"ps", "aux"};
        StringOutputStream sos = new StringOutputStream();
        StringOutputStream ses = new StringOutputStream();
        Cmd.CmdExec(input, sos, ses);
        if (!ses.getString().equals("")) {
            System.out.println(ses.getString());
        }
        String[] s = sos.getString().split("\\n");
        int i = 0;
        while (i < s.length) {
            if (s[i].contains(keyWord)) {
                String[] data = s[i].split("\\s+");
                pidList.add(new Integer(data[1]));
            }
            ++i;
        }
        return pidList;
    }

    @Override
    public void run() {
        String errMsg = Cmd.CmdExec(this.threadInput);
        if (errMsg != "") {
            System.out.println("[Cmd]error" + errMsg);
        }
    }

    public static float getRemainingMemSize() {
        StringOutputStream sos = new StringOutputStream();
        Cmd.CmdExec("free -m", sos);
        String[] s = sos.getString().split("\\n");
        int i = 0;
        while (i < s.length) {
            if (s[i].contains("buffers/cache:")) {
                String[] data = s[i].split("\\s+");
                int restSize = (int)Float.parseFloat(data[3]);
                System.out.println("[Cmd]rest mem Size = " + restSize);
                return restSize;
            }
            ++i;
        }
        return -1.0f;
    }

    public static void main(String[] args) {
        Cmd.CmdExec(new String[]{"source", "home/fti/.bashrc"});
    }
}

