/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import util.PVFile;

public class CheckConfiguration {
    static String configFile = "";
    static String SZ_rootPackage = "";
    static HashMap<String, String> configMap = new HashMap();
    static List<String> configKeyList = new ArrayList<String>();
    static HashMap<String, String> configMap2 = new HashMap();
    static List<String> configKeyList2 = new ArrayList<String>();
    static String versionNum2;
    static List<String> missingKeyList1;
    static List<String> missingKeyList2;

    static {
        missingKeyList1 = new ArrayList<String>();
        missingKeyList2 = new ArrayList<String>();
    }

    public static void listConfigMap(List<String> configKeyList, HashMap<String, String> configMap, String configSource) {
        Iterator<String> iter = configKeyList.iterator();
        if (!configSource.equals("missing")) {
            System.out.println("The list of configuration parameters in " + configSource + ":");
        }
        int i = 0;
        while (iter.hasNext()) {
            String key = iter.next();
            System.out.println(String.format("%2d: %-20s = %-10s\n", i, key, configMap.get(key)));
            ++i;
        }
    }

    public static void loadValidConfiguration(String SZ_rootPackage) {
        String major = null;
        String minor = null;
        String build = null;
        String revision = null;
        String configHeaderFile = String.valueOf(SZ_rootPackage) + "/sz/include/sz.h";
        List<String> lineList = PVFile.readFile(configHeaderFile);
        Iterator<String> iter = lineList.iterator();
        while (iter.hasNext()) {
            String[] s;
            String line = iter.next().trim();
            if (!line.startsWith("#define") || (s = line.split(" ")).length <= 2) continue;
            String key = s[1];
            String value = s[2];
            if (key.equals("SZ_VER_MAJOR")) {
                major = value;
            }
            if (key.equals("SZ_VER_MINOR")) {
                minor = value;
            }
            if (key.equals("SZ_VER_BUILD")) {
                build = value;
            }
            if (!key.equals("SZ_VER_REVISION")) continue;
            revision = value;
        }
        versionNum2 = String.valueOf(major) + "." + minor + "." + build + "." + revision;
        String configSourceFile = String.valueOf(SZ_rootPackage) + "/sz/src/conf.c";
        List<String> lineList2 = PVFile.readFile(configSourceFile);
        boolean getIntoReadConfFunction = false;
        boolean loadIniParser = false;
        iter = lineList2.iterator();
        while (iter.hasNext()) {
            String line = iter.next().trim();
            if (line.startsWith("//")) continue;
            if (line.startsWith("int SZ_ReadConf()")) {
                getIntoReadConfFunction = true;
            }
            if (getIntoReadConfFunction && line.contains("return SZ_SCES")) {
                loadIniParser = true;
            }
            if (loadIniParser && line.contains("iniparser_freedict(ini)")) break;
            if (!line.contains("iniparser_get") || !line.contains("=")) continue;
            String[] s = line.split(",");
            String key = s[1].trim().replace("\"", "").split(":")[1];
            String dftValue = s[2].trim().replace(");", "");
            configMap2.put(key, dftValue);
            configKeyList2.add(key);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java test.CheckConfiguration [configuration_file] [SZ_ROOT_Package]");
            System.out.println("Example: java test.CheckConfiguration /home/sdi/Development/SZ_C_Version/sz-1.4.9-beta-normalsize/example /home/sdi/Development/SZ_C_Version/sz-1.4.9-beta-normalsize");
            System.exit(0);
        }
        configFile = args[0];
        SZ_rootPackage = args[1];
        System.out.println("configFile:" + configFile);
        System.out.println("SZ package:" + SZ_rootPackage);
        System.out.println("------------------------------");
        List<String> lineList = PVFile.readFile(configFile);
        if (lineList == null) {
            System.out.println("Error: the configuration file is not readable.");
            System.exit(1);
        }
        Iterator<String> iter = lineList.iterator();
        while (iter.hasNext()) {
            String line = iter.next().trim();
            if (line.startsWith("#") || line.equals("[ENV]") || !line.contains("=")) continue;
            String[] s = line.split("=");
            String key = s[0].trim();
            String value = s[1].trim();
            configMap.put(key, value);
            configKeyList.add(key);
        }
        CheckConfiguration.listConfigMap(configKeyList, configMap, configFile);
        System.out.println("------------------------------");
        CheckConfiguration.loadValidConfiguration(SZ_rootPackage);
        CheckConfiguration.listConfigMap(configKeyList2, configMap2, String.valueOf(SZ_rootPackage) + " (" + versionNum2 + ")");
        System.out.println("------------------------------");
        for (String key : configKeyList) {
            if (configKeyList2.contains(key)) continue;
            missingKeyList1.add(key);
        }
        for (String key : configKeyList2) {
            if (configKeyList.contains(key)) continue;
            String riskLevel = "WARN";
            String dftValue = configMap2.get(key);
            if (PVFile.isNumeric(dftValue)) {
                double v = Double.parseDouble(dftValue);
                if (v <= 0.0) {
                    riskLevel = "FATAL";
                }
            } else if (dftValue.contentEquals("NULL")) {
                riskLevel = "FATAL";
            }
            missingKeyList2.add(String.valueOf(key) + " (dftValue:" + dftValue + ") risk level: " + riskLevel);
        }
        System.out.println("============================");
        System.out.println("Parameters are found in sz.config but missing in the new implementation code: ");
        CheckConfiguration.listConfigMap(missingKeyList1, configMap, "missing");
        System.out.println("============================");
        System.out.println("Parameters are found in the new implementation code but missing in sz.config: ");
        iter = missingKeyList2.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String v = iter.next();
            System.out.println(String.format("%2d: %-10s\n", i, v));
            ++i;
        }
        System.out.println("============================");
    }
}

