"""unit and ad-hoc testing for graphpath.

	python test.py [--option...]

Options:
	--prompt
		Run ad hoc testing.  Prompt for GraphPath expressions
		which are evaluated against the sample data.
		By default, unit tests are run against the sample data.
	--write-coverage
		Write *.coverage files for the unit tests.  Each coverage
		file reproduces a source file covered by the tests, with
		the lines not tested commented out with "##".
	--use-redland
		Use the redland python module as the underlying RDF framework.
	--use-rdflib
		Use the rdflib python module as the underlying RDF framework.

	By default a simple, built-in RDF framework is used for testing.

"""
import sys
from graphpath.util.testrunner import run, prompt, write_coverage
from graphpath import testcases

if __name__ == "__main__":
	if "--prompt" in sys.argv:
		from graphpath.entail import Sandbox
		print "population:"
		print "-----------"
		for subject in testcases.samples:
			print subject
			for predicate, value in testcases.samples[subject]:
				print "    has", predicate, "of", repr(value)
		print
		print "rules:"
		print "------"
		for rule in testcases.rules:
			print rule, "=", testcases.rules[rule]
		prompt( Sandbox( testcases.samples, testcases.rules ), testcases.__dict__)
	else:
		run(testcases.__dict__)
		if "--write-coverage" in sys.argv:
			write_coverage()
