"""Select a Set and ImmutableSet implementation."""
import sys
try:
	if "--use-altsets" in sys.argv:
		raise ImportError
		
	from sets import *

	def protect(s):
		# work around problem in standard __as_temporarily_immutable__
		r = ImmutableSet()
		r._data = s._data
		return r

except ImportError:
	from altsets import *

	def protect(s):
		return s.__as_temporarily_immutable__()
