/**********************************************************************
 * $hello example -- PLI application using TF/ACC routines
 *
 * C source to print "Hello World" as a PLI application.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $hello;
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_hello_calltf();
 *  /* table entries -/
 *   {usertask,                     /* type of PLI routine -/
 *     0,                           /* user_data value -/
 *     0,                           /* checktf routine -/
 *     0,                           /* sizetf routine -/
 *     PLIbook_hello_calltf,        /* calltf routine -/
 *     0,                           /* misctf routine -/
 *     "$hello",                    /* system task/function name -/
 *     1                            /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"  /* IEEE 1364 PLI TF routine library  */
#include "acc_user.h"  /* IEEE 1364 PLI ACC routine library */

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_hello_calltf()
{
  io_printf("\nHello World!\n\n");
  return(0);
}
