// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
// https://developers.google.com/protocol-buffers/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Author: kenton@google.com (Kenton Varda)
//  Based on original Protocol Buffers design by
//  Sanjay Ghemawat, Jeff Dean, and others.

#include <algorithm>
#include <google/protobuf/stubs/hash.h>
#include <limits>
#include <vector>

#include <google/protobuf/compiler/csharp/csharp_writer.h>
#include <google/protobuf/descriptor.pb.h>
#include <google/protobuf/io/printer.h>
#include <google/protobuf/wire_format.h>
#include <google/protobuf/stubs/strutil.h>
#include <google/protobuf/stubs/substitute.h>

#include <google/protobuf/compiler/csharp/csharp_field_base.h>
#include <google/protobuf/compiler/csharp/csharp_enum_field.h>
#include <google/protobuf/compiler/csharp/csharp_message_field.h>
#include <google/protobuf/compiler/csharp/csharp_primitive_field.h>
#include <google/protobuf/compiler/csharp/csharp_repeated_enum_field.h>
#include <google/protobuf/compiler/csharp/csharp_repeated_message_field.h>
#include <google/protobuf/compiler/csharp/csharp_repeated_primitive_field.h>

namespace google {
namespace protobuf {
namespace compiler {
namespace csharp {

Writer::Writer(google::protobuf::io::Printer* printer)
    : printer_(printer),
      newline_("\n") {
  // TODO(jtattermusch): make newline customizable.
}

Writer::~Writer() {
}

void Writer::Indent() {
  printer_->Indent();
}

void Writer::Outdent() {
  printer_->Outdent();
}

void Writer::Write(const char* text) {
  printer_->Print(text);
}

void Writer::Write(const char* text, const string& value0) {
  printer_->Print(text, "0", value0);
}

void Writer::Write(const char* text, const string& value0,
                   const string& value1) {
  printer_->Print(text, "0", value0, "1", value1);
}

void Writer::Write(const char* text, const string& value0, const string& value1,
                   const string& value2) {
  printer_->Print(text, "0", value0, "1", value1, "2", value2);
}

void Writer::Write(const char* text, const string& value0, const string& value1,
                   const string& value2, const string& value3) {
  printer_->Print(text, "0", value0, "1", value1, "2", value2, "3", value3);
}

void Writer::WriteLine() {
  printer_->Print(newline_);
}

void Writer::WriteLine(const char* text) {
  Write(text);
  WriteLine();
}

void Writer::WriteLine(const char* text, const string& value0) {
  Write(text, value0);
  WriteLine();
}

void Writer::WriteLine(const char* text, const string& value0,
                       const string& value1) {
  Write(text, value0, value1);
  WriteLine();
}

void Writer::WriteLine(const char* text, const string& value0,
                       const string& value1, const string& value2) {
  Write(text, value0, value1, value2);
  WriteLine();
}

void Writer::WriteLine(const char* text, const string& value0,
                       const string& value1, const string& value2,
                       const string& value3) {
  Write(text, value0, value1, value2, value3);
  WriteLine();
}

}  // namespace java
}  // namespace compiler
}  // namespace protobuf
}  // namespace google
