<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2017 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles\MediaPack;
class Renderer extends \s9e\TextFormatter\Renderers\PHP
{
	protected $params=['AMAZON_ASSOCIATE_TAG'=>'','AMAZON_ASSOCIATE_TAG_CA'=>'','AMAZON_ASSOCIATE_TAG_DE'=>'','AMAZON_ASSOCIATE_TAG_ES'=>'','AMAZON_ASSOCIATE_TAG_FR'=>'','AMAZON_ASSOCIATE_TAG_IN'=>'','AMAZON_ASSOCIATE_TAG_IT'=>'','AMAZON_ASSOCIATE_TAG_JP'=>'','AMAZON_ASSOCIATE_TAG_UK'=>''];
	protected function renderNode(\DOMNode $node)
	{
		switch($node->nodeName){case'ABCNEWS':$this->out.='<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//abcnews.go.com/video/embed?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'AMAZON':$this->out.='<span data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($node->getAttribute('tld')==='es'||$node->getAttribute('tld')==='it'){$this->out.='rcm-eu.amazon-adsystem.com/e/cm?lt1=_blank&amp;bc1=FFFFFF&amp;bg1=FFFFFF&amp;fc1=000000&amp;lc1=0000FF&amp;p=8&amp;l=as1&amp;f=ifr&amp;asins='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;o=';if($node->getAttribute('tld')==='es')$this->out.='30';else$this->out.='29';$this->out.='&amp;t=';if($node->getAttribute('tld')==='es'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_ES']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);elseif($node->getAttribute('tld')==='it'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_IT']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);else$this->out.='_';}else{$this->out.='ws-';if($node->getAttribute('tld')==='in')$this->out.='in';elseif($node->getAttribute('tld')==='jp')$this->out.='fe';elseif($node->hasAttribute('tld')&&(\strpos('desfrituk',$node->getAttribute('tld'))!==\false))$this->out.='eu';else$this->out.='na';$this->out.='.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&amp;OneJS=1&amp;Operation=GetAdHtml&amp;MarketPlace=';if($node->hasAttribute('tld'))$this->out.=\htmlspecialchars(\strtr($node->getAttribute('tld'),'acdefijknprstu','ACDEFIJBNPRSTG'),2);else$this->out.='US';$this->out.='&amp;ad_type=product_link&amp;tracking_id=';if($node->getAttribute('tld')==='ca')$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);elseif($node->getAttribute('tld')==='de')$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);elseif($node->getAttribute('tld')==='fr')$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);elseif($node->getAttribute('tld')==='in')$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IN'],2);elseif($node->getAttribute('tld')==='jp')$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);elseif($node->getAttribute('tld')==='uk')$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);elseif(!empty($this->params['AMAZON_ASSOCIATE_TAG']))$this->out.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);else$this->out.='-20';$this->out.='&amp;marketplace=amazon&amp;region=';if($node->hasAttribute('tld'))$this->out.=\htmlspecialchars(\strtr($node->getAttribute('tld'),'acdefijknprstu','ACDEFIJBNPRSTG'),2);else$this->out.='US';$this->out.='&amp;asins='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;show_border=true&amp;link_opens_in_new_window=true';}$this->out.='"></iframe></span></span>';break;case'AUDIOBOOM':$this->out.='<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" scrolling="no" src="//audioboom.com/posts/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>';break;case'AUDIOMACK':$this->out.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" scrolling="no"';if($node->getAttribute('mode')==='album')$this->out.=' src="https://www.audiomack.com/embed/album/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:400px;max-width:900px;width:100%"';else$this->out.=' src="https://www.audiomack.com/embed/song/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:252px;max-width:900px;width:100%"';$this->out.='></iframe>';break;case'BANDCAMP':$this->out.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if($node->hasAttribute('album_id')){$this->out.='album='.\htmlspecialchars($node->getAttribute('album_id'),2);if($node->hasAttribute('track_num'))$this->out.='/t='.\htmlspecialchars($node->getAttribute('track_num'),2);}else$this->out.='track='.\htmlspecialchars($node->getAttribute('track_id'),2);$this->out.='"></iframe></span></span>';break;case'BBCNEWS':$this->out.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com';if((\strpos($node->getAttribute('playlist'),'/news/')===0)&&(\strpos($node->getAttribute('playlist'),'A')!==\false))$this->out.=\htmlspecialchars(\strstr($node->getAttribute('playlist'),'A',\true),2);else$this->out.='/news/'.\htmlspecialchars($node->getAttribute('id'),2);$this->out.='/embed"></iframe></span></span>';break;case'BLAB':$this->out.='<span data-s9e-mediaembed="blab" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://blab.im/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BLEACHERREPORT':$this->out.='<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//bleacherreport.com/video_embed?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BREAK':$this->out.='<span data-s9e-mediaembed="break" style="display:inline-block;width:100%;max-width:464px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:60.344828%"><iframe allowfullscreen="" scrolling="no" src="//break.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BRIGHTCOVE':$this->out.='<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://link.brightcove.com/services/player/bcpid'.\htmlspecialchars($node->getAttribute('bcpid'),2).'?bckey='.\htmlspecialchars($node->getAttribute('bckey'),2).'&amp;bctid='.\htmlspecialchars($node->getAttribute('bctid'),2).'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=100%25&amp;width=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CBSNEWS':$this->out.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if($node->hasAttribute('pid'))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.\htmlspecialchars($node->getAttribute('pid'),2);else$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.\htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></object>';$this->out.='</span></span>';break;case'CNBC':$this->out.='<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:95%"><object data="//plus.cnbc.com/rssvideosearch/action/player/id/'.\htmlspecialchars($node->getAttribute('id'),2).'/code/cnbcplayershare" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>';break;case'CNN':$this->out.='<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//edition.cnn.com/video/api/embed.html#/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CNNMONEY':$this->out.='<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/'.\htmlspecialchars($node->getAttribute('id'),2).'&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'COLLEGEHUMOR':$this->out.='<span data-s9e-mediaembed="collegehumor" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.5%"><iframe allowfullscreen="" scrolling="no" src="//www.collegehumor.com/e/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'COMEDYCENTRAL':$this->out.='<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//media.mtvnservices.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'COUB':$this->out.='<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//coub.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'DAILYMOTION':$this->out.='<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dailymotion.com/embed/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'DEMOCRACYNOW':$this->out.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((\strpos($node->getAttribute('id'),'/headlines')!==\false))$this->out.='headlines/'.\htmlspecialchars(\strstr($node->getAttribute('id'),'/headlines',\true),2);elseif((\strpos($node->getAttribute('id'),'2')===0))$this->out.='story/'.\htmlspecialchars($node->getAttribute('id'),2);elseif((\strpos($node->getAttribute('id'),'shows/')===0))$this->out.='show/'.\htmlspecialchars(\substr(\strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=\htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></span></span>';break;case'DUMPERT':$this->out.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dumpert.nl/embed/'.\htmlspecialchars(\strtr($node->getAttribute('id'),'_','/'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'EIGHTTRACKS':$this->out.='<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//8tracks.com/mixes/'.\htmlspecialchars($node->getAttribute('id'),2).'/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ESPN':$this->out.='<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.espn.com/core/video/iframe?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FACEBOOK':$this->out.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/facebook.min.html#'.\htmlspecialchars($node->getAttribute('type').$node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'FLICKR':$this->out.='<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://www.flickr.com/photos/_/'.\htmlspecialchars($node->getAttribute('id'),2).'/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FORATV':$this->out.='<span data-s9e-mediaembed="foratv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//library.fora.tv/embed?id='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;type=c" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FOXNEWS':$this->out.='<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FUNNYORDIE':$this->out.='<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.funnyordie.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GAMESPOT':$this->out.='<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%"><iframe allowfullscreen="" scrolling="no" src="//www.gamespot.com/videos/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GAMETRAILERS':$this->out.='<span data-s9e-mediaembed="gametrailers" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if((\strpos($node->getAttribute('id'),'mgid:')===0))$this->out.='media.mtvnservices.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2);else$this->out.='embed.gametrailers.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'?embed=1&amp;suppressBumper=1';$this->out.='"></iframe></span></span>';break;case'GETTY':$this->out.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*($node->getAttribute('height')+49)/$node->getAttribute('width'),2).'%;padding-bottom:calc('.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'% + 49px)';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="//embed.gettyimages.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'?et='.\htmlspecialchars($node->getAttribute('et'),2).'&amp;sig='.\htmlspecialchars($node->getAttribute('sig'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GFYCAT':$this->out.='<span data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="//gfycat.com/iframe/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$this->out.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="//gifs.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIST':$this->out.='<iframe data-s9e-mediaembed="gist" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="" src="https://s9e.github.io/iframe/gist.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:180px;width:100%"></iframe>';break;case'GLOBALNEWS':$this->out.='<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:67.321429%"><iframe allowfullscreen="" scrolling="no" src="//globalnews.ca/video/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOFUNDME':$this->out.='<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:258px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:131.007752%"><object data="//funds.gofundme.com/Widgetflex.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="page='.\htmlspecialchars($node->getAttribute('id'),2).'"></object></span></span>';break;case'GOOGLEDRIVE':$this->out.='<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//drive.google.com/file/d/'.\htmlspecialchars($node->getAttribute('id'),2).'/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEPLUS':$this->out.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/googleplus.min.html#';if($node->hasAttribute('oid'))$this->out.=\htmlspecialchars($node->getAttribute('oid'),2);else$this->out.='+'.\htmlspecialchars($node->getAttribute('name'),2);$this->out.='/posts/'.\htmlspecialchars($node->getAttribute('pid'),2).'"></iframe>';break;case'GOOGLESHEETS':$this->out.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" scrolling="no" src="https://docs.google.com/spreadsheets/d/'.\htmlspecialchars($node->getAttribute('id'),2).'/pubhtml?widget=true&amp;headers=false#gid='.\htmlspecialchars($node->getAttribute('gid'),2).'" style="border:0;height:500px;resize:vertical;width:100%"></iframe>';break;case'HEALTHGURU':$this->out.='<span data-s9e-mediaembed="healthguru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.healthguru.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'HUDL':$this->out.='<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.hudl.com/embed/athlete/'.\htmlspecialchars($node->getAttribute('athlete'),2).'/highlights/'.\htmlspecialchars($node->getAttribute('highlight'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'HULU':$this->out.='<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://secure.hulu.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'HUMORTVNL':$this->out.='<span data-s9e-mediaembed="humortvnl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//humortv.vara.nl/embed.'.\htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IGN':$this->out.='<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMDB':$this->out.='<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.imdb.com/video/imdb/vi'.\htmlspecialchars($node->getAttribute('id'),2).'/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMGUR':$this->out.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" onload="var b=Math.random();window.addEventListener(\'message\',function(a){a.data.id==b&amp;&amp;(style.height=a.data.height+\'px\',style.width=a.data.width+\'px\')});contentWindow.postMessage(\'s9e:\'+b,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:450px;max-width:100%;width:568px" src="https://s9e.github.io/iframe/imgur.min.html#';if($node->getAttribute('type')==='album'&&!((\strpos($node->getAttribute('id'),'a/')===0)))$this->out.='a/';$this->out.=\htmlspecialchars($node->getAttribute('id'),2).'"></iframe>';break;case'INDIEGOGO':$this->out.='<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" scrolling="no" src="//www.indiegogo.com/project/'.\htmlspecialchars($node->getAttribute('id'),2).'/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'INSTAGRAM':$this->out.='<iframe data-s9e-mediaembed="instagram" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/instagram.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:640px;max-width:640px;width:100%"></iframe>';break;case'INTERNETARCHIVE':$this->out.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.\htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.\htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" scrolling="no" src="https://archive.org/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IZLESENE':$this->out.='<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.izlesene.com/embedplayer/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'JWPLATFORM':$this->out.='<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//content.jwplatform.com/players/'.\htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KHL':$this->out.='<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.khl.ru/iframe/feed/start/'.\htmlspecialchars($node->getAttribute('id'),2).'?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KICKSTARTER':$this->out.='<span data-s9e-mediaembed="kickstarter"';if($node->hasAttribute('video'))$this->out.=' style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.\htmlspecialchars($node->getAttribute('id'),2).'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$this->out.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.\htmlspecialchars($node->getAttribute('id'),2).'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$this->out.='</span>';break;case'KISSVIDEO':$this->out.='<span data-s9e-mediaembed="kissvideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kissvideo.click/embed.php?vid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'LIBSYN':$this->out.='<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/'.\htmlspecialchars($node->getAttribute('id'),2).'/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/" style="border:0;height:45px;max-width:900px;width:100%"></iframe>';break;case'LIVECAP':$this->out.='<span data-s9e-mediaembed="livecap" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.livecap.tv/s/embed/'.\htmlspecialchars($node->getAttribute('channel'),2).'/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'LIVELEAK':$this->out.='<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.liveleak.com/ll_embed?i='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'LIVESTREAM':$this->out.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($node->hasAttribute('clip_id'))$this->out.='cdn.livestream.com/embed/'.\htmlspecialchars($node->getAttribute('channel'),2).'?layout=4&amp;autoplay=false&amp;clip='.\htmlspecialchars($node->getAttribute('clip_id'),2);else{$this->out.='livestream.com/accounts/'.\htmlspecialchars($node->getAttribute('account_id'),2).'/events/'.\htmlspecialchars($node->getAttribute('event_id'),2);if($node->hasAttribute('video_id'))$this->out.='/videos/'.\htmlspecialchars($node->getAttribute('video_id'),2);$this->out.='/player?autoPlay=false';}$this->out.='"></iframe></span></span>';break;case'MAILRU':$this->out.='<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://my.mail.ru/video/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MEDIUM':$this->out.='<iframe data-s9e-mediaembed="medium" allowfullscreen="" onload="window.addEventListener(\'message\',function(a){a=a.data.split(\'::\');\'m\'===a[0]&amp;&amp;0&lt;src.indexOf(a[1])&amp;&amp;a[2]&amp;&amp;(style.height=a[2]+\'px\')})" scrolling="no" src="https://api.medium.com/embed?type=story&amp;path=%2F%2F'.\htmlspecialchars($node->getAttribute('id'),2).'&amp;id='.\htmlspecialchars(\strtr($node->getAttribute('id'),'abcdef','111111'),2).'" style="border:1px solid;border-color:#eee #ddd #bbb;border-radius:5px;box-shadow:rgba(0,0,0,.15) 0 1px 3px;height:400px;max-width:400px;width:100%"></iframe>';break;case'METACAFE':$this->out.='<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.metacafe.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MIXCLOUD':$this->out.='<span data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F'.\htmlspecialchars($node->getAttribute('id'),2).'%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MLB':$this->out.='<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//m.mlb.com/shared/video/embed/embed.html?content_id='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;width=640&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MRCTV':$this->out.='<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.mrctv.org/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MSNBC':$this->out.='<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:635px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:69.291339%"><iframe allowfullscreen="" scrolling="no" src="//player.theplatform.com/p/2E2eJC/EmbeddedOffSite?guid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NATGEOCHANNEL':$this->out.='<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//channel.nationalgeographic.com/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NATGEOVIDEO':$this->out.='<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCNEWS':$this->out.='<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.nbcnews.com/widget/video-embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCSPORTS':$this->out.='<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/'.\htmlspecialchars($node->getAttribute('id'),2).'?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NHL':$this->out.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if($node->hasAttribute('t'))$this->out.='/t-'.\htmlspecialchars($node->getAttribute('t'),2);if($node->hasAttribute('c'))$this->out.='/c-'.\htmlspecialchars($node->getAttribute('c'),2);$this->out.='?autostart=false"></iframe></span></span>';break;case'NPR':$this->out.='<iframe data-s9e-mediaembed="npr" allowfullscreen="" scrolling="no" src="//www.npr.org/player/embed/'.\htmlspecialchars($node->getAttribute('i'),2).'/'.\htmlspecialchars($node->getAttribute('m'),2).'" style="border:0;height:228px;max-width:800px;width:100%"></iframe>';break;case'NYTIMES':$this->out.='<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ODDSHOT':$this->out.='<span data-s9e-mediaembed="oddshot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://oddshot.tv/s/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ORFIUM':$this->out.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" scrolling="no" src="https://www.orfium.com/embedded/';if($node->hasAttribute('album_id'))$this->out.='album/'.\htmlspecialchars($node->getAttribute('album_id'),2);elseif($node->hasAttribute('playlist_id'))$this->out.='playlist/'.\htmlspecialchars($node->getAttribute('playlist_id'),2);elseif($node->hasAttribute('set_id'))$this->out.='live-set/'.\htmlspecialchars($node->getAttribute('set_id'),2);else$this->out.='track/'.\htmlspecialchars($node->getAttribute('track_id'),2);$this->out.='" style="border:0;height:';if($node->hasAttribute('album_id'))$this->out.='550';else$this->out.='275';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'PASTEBIN':$this->out.='<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" scrolling="" src="//pastebin.com/embed_iframe.php?i='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;resize:vertical;width:100%"></iframe>';break;case'PINTEREST':$this->out.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/pinterest.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:';if((\strpos($node->getAttribute('id'),'/')!==\false))$this->out.='730';else$this->out.='345';$this->out.='px;width:100%"></iframe>';break;case'PLAYSTV':$this->out.='<span data-s9e-mediaembed="playstv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//plays.tv/embeds/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'PODBEAN':$this->out.='<iframe data-s9e-mediaembed="podbean" allowfullscreen="" scrolling="no" src="//www.podbean.com/media/player/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100px;max-width:900px;width:100%"></iframe>';break;case'PREZI':$this->out.='<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" scrolling="no" src="//prezi.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'REDDIT':$this->out.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/reddit.min.html#'.\htmlspecialchars($node->getAttribute('path'),2).'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';break;case'RUTUBE':$this->out.='<span data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:720px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//rutube.ru/play/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SCRIBD':$this->out.='<iframe data-s9e-mediaembed="scribd" allowfullscreen="" scrolling="no" src="https://www.scribd.com/embeds/'.\htmlspecialchars($node->getAttribute('id'),2).'/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>';break;case'SLIDESHARE':$this->out.='<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:83.372365%"><iframe allowfullscreen="" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SOUNDCLOUD':$this->out.='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" scrolling="no" src="https://w.soundcloud.com/player/?url=';if($node->hasAttribute('playlist_id'))$this->out.='https%3A//api.soundcloud.com/playlists/'.\htmlspecialchars($node->getAttribute('playlist_id'),2);elseif($node->hasAttribute('track_id'))$this->out.='https%3A//api.soundcloud.com/tracks/'.\htmlspecialchars($node->getAttribute('track_id'),2).'&amp;secret_token='.\htmlspecialchars($node->getAttribute('secret_token'),2);else{if((\strpos($node->getAttribute('id'),'://')===\false))$this->out.='https%3A//soundcloud.com/';$this->out.=\htmlspecialchars($node->getAttribute('id'),2);}$this->out.='" style="border:0;height:';if($node->hasAttribute('playlist_id')||(\strpos($node->getAttribute('id'),'/sets/')!==\false))$this->out.='450';else$this->out.='166';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'SPORTSNET':$this->out.='<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://images.rogersdigitalmedia.com/video_service.php?videoId='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SPOTIFY':$this->out.='<span data-s9e-mediaembed="spotify" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:120%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://embed.spotify.com/?view=coverart&amp;uri=';if($node->hasAttribute('uri'))$this->out.=\htmlspecialchars($node->getAttribute('uri'),2);else$this->out.='spotify:'.\htmlspecialchars(\strtr($node->getAttribute('path'),'/',':'),2);$this->out.='"></iframe></span></span>';break;case'STEAMSTORE':$this->out.='<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" scrolling="no" src="//store.steampowered.com/widget/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:190px;max-width:900px;width:100%"></iframe>';break;case'STITCHER':$this->out.='<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" scrolling="no" src="//app.stitcher.com/splayer/f/'.\htmlspecialchars($node->getAttribute('fid'),2).'/'.\htmlspecialchars($node->getAttribute('eid'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'STRAWPOLL':$this->out.='<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="" src="//www.strawpoll.me/embed_1/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STREAMABLE':$this->out.='<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//streamable.com/e/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TEAMCOCO':$this->out.='<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.84375%"><iframe allowfullscreen="" scrolling="no" src="//teamcoco.com/embed/v/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TED':$this->out.='<span data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.\htmlspecialchars($node->getAttribute('id'),2);if((\strpos($node->getAttribute('id'),'.html')===\false))$this->out.='.html';$this->out.='"></iframe></span></span>';break;case'THEATLANTIC':$this->out.='<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theatlantic.com/video/iframe/'.\htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEGUARDIAN':$this->out.='<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//embed.theguardian.com/embed/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEONION':$this->out.='<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theonion.com/video_embed/?id='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TINYPIC':$this->out.='<span data-s9e-mediaembed="tinypic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:60.9375%;padding-bottom:calc(56.25% + 30px)"><object data="//tinypic.com/player.swf?file='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;s='.\htmlspecialchars($node->getAttribute('s'),2).'" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>';break;case'TMZ':$this->out.='<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TRAILERADDICT':$this->out.='<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//v.traileraddict.com/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TUMBLR':$this->out.='<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/tumblr.min.html#'.\htmlspecialchars($node->getAttribute('key'),2).'/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:180px;max-width:520px;width:100%"></iframe>';break;case'TWITCH':$this->out.='<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($node->hasAttribute('clip_id')){$this->out.='clips.twitch.tv/embed?autoplay=false&amp;clip=';if($node->hasAttribute('channel'))$this->out.=\htmlspecialchars($node->getAttribute('channel'),2).'/';$this->out.=\htmlspecialchars($node->getAttribute('clip_id'),2);}else{$this->out.='player.twitch.tv/?autoplay=false&amp;';if($node->hasAttribute('video_id'))$this->out.='video=v'.\htmlspecialchars($node->getAttribute('video_id'),2);else$this->out.='channel='.\htmlspecialchars($node->getAttribute('channel'),2);if($node->hasAttribute('t'))$this->out.='&amp;time='.\htmlspecialchars($node->getAttribute('t'),2);}$this->out.='"></iframe></span></span>';break;case'TWITTER':$this->out.='<iframe data-s9e-mediaembed="twitter" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/twitter.min.html#'.\htmlspecialchars($node->getAttribute('id'),2).'" style="background:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:186px;max-width:500px;width:100%"></iframe>';break;case'USTREAM':$this->out.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if($node->hasAttribute('vid'))$this->out.='recorded/'.\htmlspecialchars($node->getAttribute('vid'),2);else$this->out.=\htmlspecialchars($node->getAttribute('cid'),2);$this->out.='?html5ui"></iframe></span></span>';break;case'VBOX7':$this->out.='<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vbox7.com/emb/external.php?vid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VEOH':$this->out.='<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v'.\htmlspecialchars($node->getAttribute('id'),2).'&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>';break;case'VEVO':$this->out.='<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:575px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.347826%"><iframe allowfullscreen="" scrolling="no" src="//cache.vevo.com/m/html/embed.html?video='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIAGAME':$this->out.='<span data-s9e-mediaembed="viagame" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.25%"><iframe allowfullscreen="" scrolling="no" src="//www.viagame.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIDEODETECTIVE':$this->out.='<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIDEOMEGA':$this->out.='<span data-s9e-mediaembed="videomega" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//videomega.tv/iframe.php?ref='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIDME':$this->out.='<span data-s9e-mediaembed="vidme" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://vid.me/e/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIMEO':$this->out.='<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.vimeo.com/video/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VINE':$this->out.='<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://vine.co/v/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VK':$this->out.='<span data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:607px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:59.308072%"><iframe allowfullscreen="" scrolling="no" src="//vk.com/video_ext.php?oid='.\htmlspecialchars($node->getAttribute('oid'),2).'&amp;id='.\htmlspecialchars($node->getAttribute('vid'),2).'&amp;hash='.\htmlspecialchars($node->getAttribute('hash'),2).'&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VOCAROO':$this->out.='<span data-s9e-mediaembed="vocaroo" style="display:inline-block;width:100%;max-width:148px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:29.72973%"><object data="//vocaroo.com/player.swf?playMediaID='.\htmlspecialchars($node->getAttribute('id'),2).'&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>';break;case'VOX':$this->out.='<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WASHINGTONPOST':$this->out.='<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.washingtonpost.com/video/c/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WSHH':$this->out.='<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.worldstarhiphop.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WSJ':$this->out.='<span data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid='.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'XBOXCLIPS':$this->out.='<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxclips.com/'.\htmlspecialchars($node->getAttribute('user'),2).'/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'XBOXDVR':$this->out.='<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxdvr.com/gamer/'.\htmlspecialchars($node->getAttribute('user'),2).'/video/'.\htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YAHOOSCREEN':$this->out.='<span data-s9e-mediaembed="yahooscreen" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://screen.yahoo.com/'.\htmlspecialchars($node->getAttribute('id'),2).'.html?format=embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUKU':$this->out.='<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><iframe allowfullscreen="" scrolling="no" src="https://players.youku.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUTUBE':$this->out.='<span data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.\htmlspecialchars($node->getAttribute('id'),2).'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube.com/embed/'.\htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('list'))$this->out.='?list='.\htmlspecialchars($node->getAttribute('list'),2);if($node->hasAttribute('t')){if($node->hasAttribute('list'))$this->out.='&amp;';else$this->out.='?';$this->out.='start='.\htmlspecialchars($node->getAttribute('t'),2);}$this->out.='"></iframe></span></span>';break;case'ZIPPYSHARE':$this->out.='<object data-s9e-mediaembed="zippyshare" data="//api.zippyshare.com/api/player.swf" style="height:80px;max-width:900px;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="file='.\htmlspecialchars($node->getAttribute('file'),2).'&amp;server='.\htmlspecialchars($node->getAttribute('server'),2).'&amp;autostart=false"></object>';break;case'br':$this->out.='<br>';break;case'e':case'i':case's':break;case'p':$this->out.='<p>';$this->at($node);$this->out.='</p>';break;default:$this->at($node);}
	}
	public $enableQuickRenderer=\true;
	protected $static=[];
	protected $dynamic=['ABCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//abcnews.go.com/video/embed?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'AUDIOBOOM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" scrolling="no" src="//audioboom.com/posts/$1/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>'],'BLAB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="blab" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://blab.im/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BLEACHERREPORT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//bleacherreport.com/video_embed?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BREAK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="break" style="display:inline-block;width:100%;max-width:464px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:60.344828%"><iframe allowfullscreen="" scrolling="no" src="//break.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BRIGHTCOVE'=>['(^[^ ]+(?> (?!bc(?>key|pid|tid)=)[^=]+="[^"]*")*(?> bckey="([^"]*)")?(?> (?!bc[pt]id=)[^=]+="[^"]*")*(?> bcpid="([^"]*)")?(?> (?!bctid=)[^=]+="[^"]*")*(?> bctid="([^"]*)")?.*)s','<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://link.brightcove.com/services/player/bcpid$2?bckey=$1&amp;bctid=$3&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=100%25&amp;width=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNBC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:95%"><object data="//plus.cnbc.com/rssvideosearch/action/player/id/$1/code/cnbcplayershare" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>'],'CNN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//edition.cnn.com/video/api/embed.html#/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNNMONEY'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/$1&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'COLLEGEHUMOR'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="collegehumor" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.5%"><iframe allowfullscreen="" scrolling="no" src="//www.collegehumor.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'COMEDYCENTRAL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//media.mtvnservices.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'COUB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//coub.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'DAILYMOTION'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dailymotion.com/embed/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'EIGHTTRACKS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//8tracks.com/mixes/$1/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'ESPN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.espn.com/core/video/iframe?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FLICKR'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://www.flickr.com/photos/_/$1/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FORATV'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="foratv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//library.fora.tv/embed?id=$1&amp;type=c" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FOXNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FUNNYORDIE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.funnyordie.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GAMESPOT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%"><iframe allowfullscreen="" scrolling="no" src="//www.gamespot.com/videos/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GIST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="gist" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="" src="https://s9e.github.io/iframe/gist.min.html#$1" style="border:0;height:180px;width:100%"></iframe>'],'GLOBALNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:67.321429%"><iframe allowfullscreen="" scrolling="no" src="//globalnews.ca/video/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOFUNDME'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:258px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:131.007752%"><object data="//funds.gofundme.com/Widgetflex.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="page=$1"></object></span></span>'],'GOOGLEDRIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//drive.google.com/file/d/$1/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOOGLESHEETS'=>['(^[^ ]+(?> (?!g?id=)[^=]+="[^"]*")*(?> gid="([^"]*)")?(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" scrolling="no" src="https://docs.google.com/spreadsheets/d/$2/pubhtml?widget=true&amp;headers=false#gid=$1" style="border:0;height:500px;resize:vertical;width:100%"></iframe>'],'HEALTHGURU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="healthguru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.healthguru.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'HUDL'=>['(^[^ ]+(?> (?!(?>athlete|highlight)=)[^=]+="[^"]*")*(?> athlete="([^"]*)")?(?> (?!highlight=)[^=]+="[^"]*")*(?> highlight="([^"]*)")?.*)s','<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.hudl.com/embed/athlete/$1/highlights/$2" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'HULU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://secure.hulu.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'HUMORTVNL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="humortvnl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//humortv.vara.nl/embed.$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IGN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IMDB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.imdb.com/video/imdb/vi$1/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'INDIEGOGO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" scrolling="no" src="//www.indiegogo.com/project/$1/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'INSTAGRAM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="instagram" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/instagram.min.html#$1" style="border:0;height:640px;max-width:640px;width:100%"></iframe>'],'IZLESENE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.izlesene.com/embedplayer/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'JWPLATFORM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//content.jwplatform.com/players/$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'KHL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video.khl.ru/iframe/feed/start/$1?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'KISSVIDEO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="kissvideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kissvideo.click/embed.php?vid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'LIBSYN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/$1/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/" style="border:0;height:45px;max-width:900px;width:100%"></iframe>'],'LIVECAP'=>['(^[^ ]+(?> (?!(?>channel|id)=)[^=]+="[^"]*")*(?> channel="([^"]*)")?(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="livecap" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.livecap.tv/s/embed/$1/$2" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'LIVELEAK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.liveleak.com/ll_embed?i=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MAILRU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://my.mail.ru/video/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'METACAFE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.metacafe.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MIXCLOUD'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mixcloud" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F$1%2F&amp;embed_type=widget_standard" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MLB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//m.mlb.com/shared/video/embed/embed.html?content_id=$1&amp;width=640&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MRCTV'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://www.mrctv.org/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MSNBC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:635px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:69.291339%"><iframe allowfullscreen="" scrolling="no" src="//player.theplatform.com/p/2E2eJC/EmbeddedOffSite?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOCHANNEL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//channel.nationalgeographic.com/$1/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOVIDEO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.nbcnews.com/widget/video-embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCSPORTS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/$1?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NPR'=>['(^[^ ]+(?> (?![im]=)[^=]+="[^"]*")*(?> i="([^"]*)")?(?> (?!m=)[^=]+="[^"]*")*(?> m="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="npr" allowfullscreen="" scrolling="no" src="//www.npr.org/player/embed/$1/$2" style="border:0;height:228px;max-width:800px;width:100%"></iframe>'],'NYTIMES'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'ODDSHOT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="oddshot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://oddshot.tv/s/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'PASTEBIN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" scrolling="" src="//pastebin.com/embed_iframe.php?i=$1" style="border:0;height:300px;resize:vertical;width:100%"></iframe>'],'PLAYSTV'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="playstv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//plays.tv/embeds/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'PODBEAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="podbean" allowfullscreen="" scrolling="no" src="//www.podbean.com/media/player/$1" style="border:0;height:100px;max-width:900px;width:100%"></iframe>'],'PREZI'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" scrolling="no" src="//prezi.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'REDDIT'=>['(^[^ ]+(?> (?!path=)[^=]+="[^"]*")*(?> path="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="reddit" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/reddit.min.html#$1" style="border:0;height:165px;max-width:800px;width:100%"></iframe>'],'RUTUBE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:720px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//rutube.ru/play/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SCRIBD'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="scribd" allowfullscreen="" scrolling="no" src="https://www.scribd.com/embeds/$1/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>'],'SLIDESHARE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:427px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:83.372365%"><iframe allowfullscreen="" scrolling="no" src="//www.slideshare.net/slideshow/embed_code/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SPORTSNET'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://images.rogersdigitalmedia.com/video_service.php?videoId=$1&amp;playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&amp;autoStart=false&amp;width=100%25&amp;height=100%25" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STEAMSTORE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" scrolling="no" src="//store.steampowered.com/widget/$1" style="border:0;height:190px;max-width:900px;width:100%"></iframe>'],'STITCHER'=>['(^[^ ]+(?> (?![ef]id=)[^=]+="[^"]*")*(?> eid="([^"]*)")?(?> (?!fid=)[^=]+="[^"]*")*(?> fid="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" scrolling="no" src="//app.stitcher.com/splayer/f/$2/$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'STRAWPOLL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="" src="//www.strawpoll.me/embed_1/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STREAMABLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//streamable.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TEAMCOCO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.84375%"><iframe allowfullscreen="" scrolling="no" src="//teamcoco.com/embed/v/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEATLANTIC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theatlantic.com/video/iframe/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEGUARDIAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//embed.theguardian.com/embed/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEONION'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.theonion.com/video_embed/?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TINYPIC'=>['(^[^ ]+(?> (?!(?>s|id)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!s=)[^=]+="[^"]*")*(?> s="([^"]*)")?.*)s','<span data-s9e-mediaembed="tinypic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:60.9375%;padding-bottom:calc(56.25% + 30px)"><object data="//tinypic.com/player.swf?file=$1&amp;s=$2" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>'],'TMZ'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TRAILERADDICT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//v.traileraddict.com/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TUMBLR'=>['(^[^ ]+(?> (?!(?>id|key)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!key=)[^=]+="[^"]*")*(?> key="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/tumblr.min.html#$2/$1" style="border:0;height:180px;max-width:520px;width:100%"></iframe>'],'TWITTER'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="twitter" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/twitter.min.html#$1" style="background:url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%;border:0;height:186px;max-width:500px;width:100%"></iframe>'],'VBOX7'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//vbox7.com/emb/external.php?vid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VEOH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v$1&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>'],'VEVO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:575px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.347826%"><iframe allowfullscreen="" scrolling="no" src="//cache.vevo.com/m/html/embed.html?video=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIAGAME'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="viagame" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.25%"><iframe allowfullscreen="" scrolling="no" src="//www.viagame.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIDEODETECTIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIDEOMEGA'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="videomega" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//videomega.tv/iframe.php?ref=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIDME'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vidme" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://vid.me/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIMEO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.vimeo.com/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VINE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" src="https://vine.co/v/$1/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VK'=>['(^[^ ]+(?> (?!(?>hash|oid|vid)=)[^=]+="[^"]*")*(?> hash="([^"]*)")?(?> (?![ov]id=)[^=]+="[^"]*")*(?> oid="([^"]*)")?(?> (?!vid=)[^=]+="[^"]*")*(?> vid="([^"]*)")?.*)s','<span data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:607px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:59.308072%"><iframe allowfullscreen="" scrolling="no" src="//vk.com/video_ext.php?oid=$2&amp;id=$3&amp;hash=$1&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VOCAROO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vocaroo" style="display:inline-block;width:100%;max-width:148px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:29.72973%"><object data="//vocaroo.com/player.swf?playMediaID=$1&amp;autoplay=0" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>'],'VOX'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WASHINGTONPOST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.washingtonpost.com/video/c/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WSHH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.worldstarhiphop.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WSJ'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXCLIPS'=>['(^[^ ]+(?> (?!(?>id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxclips.com/$2/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXDVR'=>['(^[^ ]+(?> (?!(?>id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//xboxdvr.com/gamer/$2/video/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'YAHOOSCREEN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="yahooscreen" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="https://screen.yahoo.com/$1.html?format=embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'YOUKU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><iframe allowfullscreen="" scrolling="no" src="https://players.youku.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'ZIPPYSHARE'=>['(^[^ ]+(?> (?!(?>file|server)=)[^=]+="[^"]*")*(?> file="([^"]*)")?(?> (?!server=)[^=]+="[^"]*")*(?> server="([^"]*)")?.*)s','<object data-s9e-mediaembed="zippyshare" data="//api.zippyshare.com/api/player.swf" style="height:80px;max-width:900px;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="file=$1&amp;server=$2&amp;autostart=false"></object>']];
	protected $quickRegexp='(<(?:(?!/)((?:A(?>BCNEWS|MAZON|UDIO(?>BOOM|MACK))|B(?>ANDCAMP|BCNEWS|L(?>AB|EACHERREPORT)|R(?>EAK|IGHTCOVE))|C(?:BSNEWS|N(?:BC|N(?>MONEY)?)|O(?>LLEGEHUMOR|MEDYCENTRAL|UB))|D(?>AILYMOTION|EMOCRACYNOW|UMPERT)|E(?>IGHTTRACKS|SPN)|F(?>ACEBOOK|LICKR|O(?>RATV|XNEWS)|UNNYORDIE)|G(?>AME(?>SPOT|TRAILERS)|ETTY|FYCAT|I(?>FS|ST)|LOBALNEWS|O(?>FUNDME|OGLE(?>DRIVE|PLUS|SHEETS)))|H(?>EALTHGURU|U(?>DL|LU|MORTVNL))|I(?>GN|M(?>DB|GUR)|N(?>DIEGOGO|STAGRAM|TERNETARCHIVE)|ZLESENE)|JWPLATFORM|K(?>HL|I(?>CKSTARTER|SSVIDEO))|LI(?>BSYN|VE(?>CAP|LEAK|STREAM))|M(?>AILRU|E(?>DIUM|TACAFE)|IXCLOUD|LB|RCTV|SNBC)|N(?>ATGEO(?>CHANNEL|VIDEO)|BC(?>NEW|SPORT)S|HL|PR|YTIMES)|O(?>DDSHOT|RFIUM)|P(?>ASTEBIN|INTEREST|LAYSTV|ODBEAN|REZI)|R(?>EDDIT|UTUBE)|S(?>CRIBD|LIDESHARE|OUNDCLOUD|PO(?>RTSNET|TIFY)|T(?>EAMSTORE|ITCHER|R(?>AWPOLL|EAMABLE)))|T(?>E(?>D|AMCOCO)|HE(?>ATLANTIC|GUARDIAN|ONION)|INYPIC|MZ|RAILERADDICT|UMBLR|WIT(?>CH|TER))|USTREAM|V(?>K|BOX7|E(?>OH|VO)|I(?>AGAME|D(?>EO(?>DETECTIVE|MEGA)|ME)|MEO|NE)|O(?>X|CAROO))|W(?>ASHINGTONPOST|S(?>J|HH))|XBOX(?>CLIPS|DVR)|Y(?>AHOOSCREEN|OU(?>KU|TUBE))|ZIPPYSHARE))(?: [^>]*)?>.*?</\\1|(/?(?!br/|p>)[^ />]+)[^>]*?(/)?)>)s';
	protected function renderQuickTemplate($id, $xml)
	{
		$attributes=$this->matchAttributes($xml);
		$html='';switch($id){case'AMAZON':$attributes+=['tld'=>\null,'id'=>\null];$html.='<span data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($attributes['tld']==='es'||$attributes['tld']==='it'){$html.='rcm-eu.amazon-adsystem.com/e/cm?lt1=_blank&amp;bc1=FFFFFF&amp;bg1=FFFFFF&amp;fc1=000000&amp;lc1=0000FF&amp;p=8&amp;l=as1&amp;f=ifr&amp;asins='.$attributes['id'].'&amp;o=';if($attributes['tld']==='es')$html.='30';else$html.='29';$html.='&amp;t=';if($attributes['tld']==='es'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_ES']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);elseif($attributes['tld']==='it'&&!empty($this->params['AMAZON_ASSOCIATE_TAG_IT']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);else$html.='_';}else{$html.='ws-';if($attributes['tld']==='in')$html.='in';elseif($attributes['tld']==='jp')$html.='fe';elseif(isset($attributes['tld'])&&(\strpos('desfrituk',$attributes['tld'])!==\false))$html.='eu';else$html.='na';$html.='.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&amp;OneJS=1&amp;Operation=GetAdHtml&amp;MarketPlace=';if(isset($attributes['tld']))$html.=\htmlspecialchars(\strtr(\htmlspecialchars_decode($attributes['tld']),'acdefijknprstu','ACDEFIJBNPRSTG'),2);else$html.='US';$html.='&amp;ad_type=product_link&amp;tracking_id=';if($attributes['tld']==='ca')$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);elseif($attributes['tld']==='de')$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);elseif($attributes['tld']==='fr')$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);elseif($attributes['tld']==='in')$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IN'],2);elseif($attributes['tld']==='jp')$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);elseif($attributes['tld']==='uk')$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);elseif(!empty($this->params['AMAZON_ASSOCIATE_TAG']))$html.=\htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);else$html.='-20';$html.='&amp;marketplace=amazon&amp;region=';if(isset($attributes['tld']))$html.=\htmlspecialchars(\strtr(\htmlspecialchars_decode($attributes['tld']),'acdefijknprstu','ACDEFIJBNPRSTG'),2);else$html.='US';$html.='&amp;asins='.$attributes['id'].'&amp;show_border=true&amp;link_opens_in_new_window=true';}$html.='"></iframe></span></span>';break;case'AUDIOMACK':$attributes+=['mode'=>\null,'id'=>\null];$html.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" scrolling="no"';if($attributes['mode']==='album')$html.=' src="https://www.audiomack.com/embed/album/'.$attributes['id'].'" style="border:0;height:400px;max-width:900px;width:100%"';else$html.=' src="https://www.audiomack.com/embed/song/'.$attributes['id'].'" style="border:0;height:252px;max-width:900px;width:100%"';$html.='></iframe>';break;case'BANDCAMP':$attributes+=['track_num'=>\null,'track_id'=>\null];$html.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if(isset($attributes['album_id'])){$html.='album='.$attributes['album_id'];if(isset($attributes['track_num']))$html.='/t='.$attributes['track_num'];}else$html.='track='.$attributes['track_id'];$html.='"></iframe></span></span>';break;case'BBCNEWS':$attributes+=['playlist'=>\null,'id'=>\null];$html.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com';if((\strpos($attributes['playlist'],'/news/')===0)&&(\strpos($attributes['playlist'],'A')!==\false))$html.=\htmlspecialchars(\strstr(\htmlspecialchars_decode($attributes['playlist']),'A',\true),2);else$html.='/news/'.$attributes['id'];$html.='/embed"></iframe></span></span>';break;case'CBSNEWS':$attributes+=['id'=>\null];$html.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if(isset($attributes['pid']))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.$attributes['pid'];else$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.$attributes['id'];$html.='"></object>';$html.='</span></span>';break;case'DEMOCRACYNOW':$attributes+=['id'=>\null];$html.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if((\strpos($attributes['id'],'/headlines')!==\false))$html.='headlines/'.\htmlspecialchars(\strstr(\htmlspecialchars_decode($attributes['id']),'/headlines',\true),2);elseif((\strpos($attributes['id'],'2')===0))$html.='story/'.$attributes['id'];elseif((\strpos($attributes['id'],'shows/')===0))$html.='show/'.\htmlspecialchars(\substr(\strstr(\htmlspecialchars_decode($attributes['id']),'/'),1),2);else$html.=$attributes['id'];$html.='"></iframe></span></span>';break;case'DUMPERT':$attributes+=['id'=>\null];$html.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" src="//www.dumpert.nl/embed/'.\strtr($attributes['id'],'_','/').'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FACEBOOK':$attributes+=['type'=>\null,'id'=>\null];$html.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/facebook.min.html#'.$attributes['type'].$attributes['id'].'" style="border:0;height:360px;max-width:640px;width:100%"></iframe>';break;case'GAMETRAILERS':$attributes+=['id'=>\null];$html.='<span data-s9e-mediaembed="gametrailers" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if((\strpos($attributes['id'],'mgid:')===0))$html.='media.mtvnservices.com/embed/'.$attributes['id'];else$html.='embed.gametrailers.com/embed/'.$attributes['id'].'?embed=1&amp;suppressBumper=1';$html.='"></iframe></span></span>';break;case'GETTY':$attributes+=['width'=>\null,'height'=>\null,'id'=>\null,'et'=>\null,'sig'=>\null];$html.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*($attributes['height']+49)/\htmlspecialchars_decode($attributes['width']),2).'%;padding-bottom:calc('.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'% + 49px)';$html.='"><iframe allowfullscreen="" scrolling="no" src="//embed.gettyimages.com/embed/'.$attributes['id'].'?et='.$attributes['et'].'&amp;sig='.$attributes['sig'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GFYCAT':$attributes+=['width'=>\null,'height'=>\null,'id'=>\null];$html.='<span data-s9e-mediaembed="gfycat" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" scrolling="no" src="//gfycat.com/iframe/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$attributes+=['width'=>\null,'height'=>\null,'id'=>\null];$html.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" scrolling="no" src="//gifs.com/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEPLUS':$attributes+=['name'=>\null,'pid'=>\null];$html.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/googleplus.min.html#';if(isset($attributes['oid']))$html.=$attributes['oid'];else$html.='+'.$attributes['name'];$html.='/posts/'.$attributes['pid'].'"></iframe>';break;case'IMGUR':$attributes+=['type'=>\null,'id'=>\null];$html.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" onload="var b=Math.random();window.addEventListener(\'message\',function(a){a.data.id==b&amp;&amp;(style.height=a.data.height+\'px\',style.width=a.data.width+\'px\')});contentWindow.postMessage(\'s9e:\'+b,\'https://s9e.github.io\')" scrolling="no" style="border:0;height:450px;max-width:100%;width:568px" src="https://s9e.github.io/iframe/imgur.min.html#';if($attributes['type']==='album'&&!((\strpos($attributes['id'],'a/')===0)))$html.='a/';$html.=$attributes['id'].'"></iframe>';break;case'INTERNETARCHIVE':$attributes+=['width'=>\null,'height'=>\null,'id'=>\null];$html.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(\htmlspecialchars_decode($attributes['width'])>0)$html.='padding-bottom:'.\htmlspecialchars(100*$attributes['height']/\htmlspecialchars_decode($attributes['width']),2).'%';$html.='"><iframe allowfullscreen="" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KICKSTARTER':$attributes+=['id'=>\null];$html.='<span data-s9e-mediaembed="kickstarter"';if(isset($attributes['video']))$html.=' style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$html.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$html.='</span>';break;case'LIVESTREAM':$attributes+=['channel'=>\null,'account_id'=>\null,'event_id'=>\null];$html.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if(isset($attributes['clip_id']))$html.='cdn.livestream.com/embed/'.$attributes['channel'].'?layout=4&amp;autoplay=false&amp;clip='.$attributes['clip_id'];else{$html.='livestream.com/accounts/'.$attributes['account_id'].'/events/'.$attributes['event_id'];if(isset($attributes['video_id']))$html.='/videos/'.$attributes['video_id'];$html.='/player?autoPlay=false';}$html.='"></iframe></span></span>';break;case'MEDIUM':$attributes+=['id'=>\null];$html.='<iframe data-s9e-mediaembed="medium" allowfullscreen="" onload="window.addEventListener(\'message\',function(a){a=a.data.split(\'::\');\'m\'===a[0]&amp;&amp;0&lt;src.indexOf(a[1])&amp;&amp;a[2]&amp;&amp;(style.height=a[2]+\'px\')})" scrolling="no" src="https://api.medium.com/embed?type=story&amp;path=%2F%2F'.$attributes['id'].'&amp;id='.\htmlspecialchars(\strtr(\htmlspecialchars_decode($attributes['id']),'abcdef','111111'),2).'" style="border:1px solid;border-color:#eee #ddd #bbb;border-radius:5px;box-shadow:rgba(0,0,0,.15) 0 1px 3px;height:400px;max-width:400px;width:100%"></iframe>';break;case'NHL':$html.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if(isset($attributes['t']))$html.='/t-'.$attributes['t'];if(isset($attributes['c']))$html.='/c-'.$attributes['c'];$html.='?autostart=false"></iframe></span></span>';break;case'ORFIUM':$attributes+=['track_id'=>\null];$html.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" scrolling="no" src="https://www.orfium.com/embedded/';if(isset($attributes['album_id']))$html.='album/'.$attributes['album_id'];elseif(isset($attributes['playlist_id']))$html.='playlist/'.$attributes['playlist_id'];elseif(isset($attributes['set_id']))$html.='live-set/'.$attributes['set_id'];else$html.='track/'.$attributes['track_id'];$html.='" style="border:0;height:';if(isset($attributes['album_id']))$html.='550';else$html.='275';$html.='px;max-width:900px;width:100%"></iframe>';break;case'PINTEREST':$attributes+=['id'=>\null];$html.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" onload="var a=Math.random();window.addEventListener(\'message\',function(b){if(b.data.id==a)style.height=b.data.height+\'px\'});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')" scrolling="no" src="https://s9e.github.io/iframe/pinterest.min.html#'.$attributes['id'].'" style="border:0;height:360px;max-width:';if((\strpos($attributes['id'],'/')!==\false))$html.='730';else$html.='345';$html.='px;width:100%"></iframe>';break;case'SOUNDCLOUD':$attributes+=['secret_token'=>\null,'id'=>\null];$html.='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" scrolling="no" src="https://w.soundcloud.com/player/?url=';if(isset($attributes['playlist_id']))$html.='https%3A//api.soundcloud.com/playlists/'.$attributes['playlist_id'];elseif(isset($attributes['track_id']))$html.='https%3A//api.soundcloud.com/tracks/'.$attributes['track_id'].'&amp;secret_token='.$attributes['secret_token'];else{if((\strpos($attributes['id'],'://')===\false))$html.='https%3A//soundcloud.com/';$html.=$attributes['id'];}$html.='" style="border:0;height:';if(isset($attributes['playlist_id'])||(\strpos($attributes['id'],'/sets/')!==\false))$html.='450';else$html.='166';$html.='px;max-width:900px;width:100%"></iframe>';break;case'SPOTIFY':$attributes+=['path'=>\null];$html.='<span data-s9e-mediaembed="spotify" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:120%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://embed.spotify.com/?view=coverart&amp;uri=';if(isset($attributes['uri']))$html.=$attributes['uri'];else$html.='spotify:'.\strtr($attributes['path'],'/',':');$html.='"></iframe></span></span>';break;case'TED':$attributes+=['id'=>\null];$html.='<span data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.$attributes['id'];if((\strpos($attributes['id'],'.html')===\false))$html.='.html';$html.='"></iframe></span></span>';break;case'TWITCH':$attributes+=['channel'=>\null,'clip_id'=>\null];$html.='<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if(isset($attributes['clip_id'])){$html.='clips.twitch.tv/embed?autoplay=false&amp;clip=';if(isset($attributes['channel']))$html.=$attributes['channel'].'/';$html.=$attributes['clip_id'];}else{$html.='player.twitch.tv/?autoplay=false&amp;';if(isset($attributes['video_id']))$html.='video=v'.$attributes['video_id'];else$html.='channel='.$attributes['channel'];if(isset($attributes['t']))$html.='&amp;time='.$attributes['t'];}$html.='"></iframe></span></span>';break;case'USTREAM':$attributes+=['cid'=>\null];$html.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if(isset($attributes['vid']))$html.='recorded/'.$attributes['vid'];else$html.=$attributes['cid'];$html.='?html5ui"></iframe></span></span>';break;case'YOUTUBE':$attributes+=['id'=>\null,'t'=>\null];$html.='<span data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.$attributes['id'].'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube.com/embed/'.$attributes['id'];if(isset($attributes['list']))$html.='?list='.$attributes['list'];if(isset($attributes['t'])){if(isset($attributes['list']))$html.='&amp;';else$html.='?';$html.='start='.$attributes['t'];}$html.='"></iframe></span></span>';}
		return $html;
	}
}