/* Generated by re2c 2.2 */
/*
  +----------------------------------------------------------------------+
  | Copyright (c) The PHP Group                                          |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | https://www.php.net/license/3_01.txt                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Jakub Zelenka <bukka@php.net>                                |
  +----------------------------------------------------------------------+
*/

#include "php.h"
#include "php_json_scanner.h"
#include "php_json_scanner_defs.h"
#include "php_json_parser.h"
#include "json_parser.tab.h"

#define	YYCTYPE     php_json_ctype
#define	YYCURSOR    s->cursor
#define	YYLIMIT     s->limit
#define	YYMARKER    s->marker
#define	YYCTXMARKER s->ctxmarker

#define YYGETCONDITION()        s->state
#define YYSETCONDITION(yystate) s->state = yystate

#define	YYFILL(n)

#define PHP_JSON_CONDITION_SET(condition) YYSETCONDITION(yyc##condition)
#define PHP_JSON_CONDITION_GOTO(condition) goto yyc_##condition
#define PHP_JSON_CONDITION_SET_AND_GOTO(condition) \
	PHP_JSON_CONDITION_SET(condition); \
	PHP_JSON_CONDITION_GOTO(condition)
#define PHP_JSON_CONDITION_GOTO_STR_P2() \
	do { \
		if (s->utf8_invalid) { \
			PHP_JSON_CONDITION_GOTO(STR_P2_BIN); \
		} else { \
			PHP_JSON_CONDITION_GOTO(STR_P2_UTF); \
		} \
	} while(0)


#define PHP_JSON_SCANNER_COPY_ESC() php_json_scanner_copy_string(s, 0)
#define PHP_JSON_SCANNER_COPY_UTF() php_json_scanner_copy_string(s, 5)
#define PHP_JSON_SCANNER_COPY_UTF_SP() php_json_scanner_copy_string(s, 11)

#define PHP_JSON_INT_MAX_LENGTH (MAX_LENGTH_OF_LONG - 1)


static void php_json_scanner_copy_string(php_json_scanner *s, int esc_size)
{
	size_t len = s->cursor - s->str_start - esc_size - 1;
	if (len) {
		memcpy(s->pstr, s->str_start, len);
		s->pstr += len;
	}
}

static int php_json_hex_to_int(char code)
{
	if (code >= '0' && code <= '9') {
		return code - '0';
	} else if (code >= 'A' && code <= 'F') {
		return code - ('A' - 10);
	} else if (code >= 'a' && code <= 'f') {
		return code - ('a' - 10);
	} else {
		/* this should never happened (just to suppress compiler warning) */
		return -1;
	}
}

static int php_json_ucs2_to_int_ex(php_json_scanner *s, int size, int start)
{
	int i, code = 0;
	php_json_ctype *pc = s->cursor - start;
	for (i = 0; i < size; i++) {
		code |= php_json_hex_to_int(*(pc--)) << (i * 4);
	}
	return code;
}

static int php_json_ucs2_to_int(php_json_scanner *s, int size)
{
	return php_json_ucs2_to_int_ex(s, size, 1);
}

void php_json_scanner_init(php_json_scanner *s, const char *str, size_t str_len, int options)
{
	s->cursor = (php_json_ctype *) str;
	s->limit = (php_json_ctype *) str + str_len;
	s->options = options;
	PHP_JSON_CONDITION_SET(JS);
}

int php_json_scan(php_json_scanner *s)
{
	ZVAL_NULL(&s->value);

std:
	s->token = s->cursor;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_JS;
			} else {
				goto yyc_STR_P1;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_STR_P2_BIN;
			} else {
				goto yyc_STR_P2_UTF;
			}
		}
/* *********************************** */
yyc_JS:
		{
			static const unsigned char yybm[] = {
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,  64,   0,   0,   0,  64,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				 64,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				128, 128, 128, 128, 128, 128, 128, 128, 
				128, 128,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
			};
			yych = *YYCURSOR;
			if (yych <= ']') {
				if (yych <= '"') {
					if (yych <= '\f') {
						if (yych <= 0x08) {
							if (yych >= 0x01) goto yy4;
						} else {
							if (yych <= '\t') goto yy6;
							if (yych <= '\n') goto yy9;
							goto yy4;
						}
					} else {
						if (yych <= 0x1F) {
							if (yych <= '\r') goto yy10;
							goto yy4;
						} else {
							if (yych <= ' ') goto yy6;
							if (yych <= '!') goto yy11;
							goto yy13;
						}
					}
				} else {
					if (yych <= '0') {
						if (yych <= ',') {
							if (yych <= '+') goto yy11;
							goto yy15;
						} else {
							if (yych <= '-') goto yy17;
							if (yych <= '/') goto yy11;
							goto yy18;
						}
					} else {
						if (yych <= 'Z') {
							if (yych <= '9') goto yy20;
							if (yych <= ':') goto yy22;
							goto yy11;
						} else {
							if (yych <= '[') goto yy24;
							if (yych <= '\\') goto yy11;
							goto yy26;
						}
					}
				}
			} else {
				if (yych <= '}') {
					if (yych <= 's') {
						if (yych <= 'f') {
							if (yych <= 'e') goto yy11;
							goto yy28;
						} else {
							if (yych == 'n') goto yy29;
							goto yy11;
						}
					} else {
						if (yych <= 'z') {
							if (yych <= 't') goto yy30;
							goto yy11;
						} else {
							if (yych <= '{') goto yy31;
							if (yych <= '|') goto yy11;
							goto yy33;
						}
					}
				} else {
					if (yych <= 0xEC) {
						if (yych <= 0xC1) {
							if (yych <= 0x7F) goto yy11;
							goto yy35;
						} else {
							if (yych <= 0xDF) goto yy37;
							if (yych <= 0xE0) goto yy38;
							goto yy39;
						}
					} else {
						if (yych <= 0xF0) {
							if (yych <= 0xED) goto yy40;
							if (yych <= 0xEF) goto yy39;
							goto yy41;
						} else {
							if (yych <= 0xF3) goto yy42;
							if (yych <= 0xF4) goto yy43;
							goto yy35;
						}
					}
				}
			}
			++YYCURSOR;
			{
		if (s->limit < s->cursor) {
			return PHP_JSON_T_EOI;
		} else {
			s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
			return PHP_JSON_T_ERROR;
		}
	}
yy4:
			++YYCURSOR;
			{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy6:
			yych = *++YYCURSOR;
yy7:
			if (yybm[0+yych] & 64) {
				goto yy6;
			}
yy8:
			{ goto std; }
yy9:
			++YYCURSOR;
			goto yy8;
yy10:
			yych = *++YYCURSOR;
			if (yych == '\n') goto yy9;
			goto yy7;
yy11:
			++YYCURSOR;
yy12:
			{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy13:
			++YYCURSOR;
			{
		s->str_start = s->cursor;
		s->str_esc = 0;
		s->utf8_invalid = 0;
		s->utf8_invalid_count = 0;
		PHP_JSON_CONDITION_SET_AND_GOTO(STR_P1);
	}
yy15:
			++YYCURSOR;
			{ return ','; }
yy17:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy12;
			if (yych <= '0') goto yy18;
			if (yych <= '9') goto yy20;
			goto yy12;
yy18:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych == '.') goto yy44;
			} else {
				if (yych <= 'E') goto yy46;
				if (yych == 'e') goto yy46;
			}
yy19:
			{
		bool bigint = 0, negative = s->token[0] == '-';
		size_t digits = (size_t) (s->cursor - s->token - negative);
		if (digits >= PHP_JSON_INT_MAX_LENGTH) {
			if (digits == PHP_JSON_INT_MAX_LENGTH) {
				int cmp = strncmp((char *) (s->token + negative), LONG_MIN_DIGITS, PHP_JSON_INT_MAX_LENGTH);
				if (!(cmp < 0 || (cmp == 0 && negative))) {
					bigint = 1;
				}
			} else {
				bigint = 1;
			}
		}
		if (!bigint) {
			ZVAL_LONG(&s->value, ZEND_STRTOL((char *) s->token, NULL, 10));
			return PHP_JSON_T_INT;
		} else if (s->options & PHP_JSON_BIGINT_AS_STRING) {
			ZVAL_STRINGL(&s->value, (char *) s->token, s->cursor - s->token);
			return PHP_JSON_T_STRING;
		} else {
			ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
			return PHP_JSON_T_DOUBLE;
		}
	}
yy20:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yybm[0+yych] & 128) {
				goto yy20;
			}
			if (yych <= 'D') {
				if (yych == '.') goto yy44;
				goto yy19;
			} else {
				if (yych <= 'E') goto yy46;
				if (yych == 'e') goto yy46;
				goto yy19;
			}
yy22:
			++YYCURSOR;
			{ return ':'; }
yy24:
			++YYCURSOR;
			{ return '['; }
yy26:
			++YYCURSOR;
			{ return ']'; }
yy28:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'a') goto yy47;
			goto yy12;
yy29:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'u') goto yy48;
			goto yy12;
yy30:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'r') goto yy49;
			goto yy12;
yy31:
			++YYCURSOR;
			{ return '{'; }
yy33:
			++YYCURSOR;
			{ return '}'; }
yy35:
			++YYCURSOR;
yy36:
			{
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy37:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy36;
			if (yych <= 0xBF) goto yy11;
			goto yy36;
yy38:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x9F) goto yy36;
			if (yych <= 0xBF) goto yy50;
			goto yy36;
yy39:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy36;
			if (yych <= 0xBF) goto yy50;
			goto yy36;
yy40:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy36;
			if (yych <= 0x9F) goto yy50;
			goto yy36;
yy41:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x8F) goto yy36;
			if (yych <= 0xBF) goto yy51;
			goto yy36;
yy42:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy36;
			if (yych <= 0xBF) goto yy51;
			goto yy36;
yy43:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 0x7F) goto yy36;
			if (yych <= 0x8F) goto yy51;
			goto yy36;
yy44:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy45;
			if (yych <= '9') goto yy52;
yy45:
			YYCURSOR = YYMARKER;
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy19;
				} else {
					goto yy12;
				}
			} else {
				if (yyaccept == 2) {
					goto yy36;
				} else {
					goto yy54;
				}
			}
yy46:
			yych = *++YYCURSOR;
			if (yych <= ',') {
				if (yych == '+') goto yy55;
				goto yy45;
			} else {
				if (yych <= '-') goto yy55;
				if (yych <= '/') goto yy45;
				if (yych <= '9') goto yy56;
				goto yy45;
			}
yy47:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy58;
			goto yy45;
yy48:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy59;
			goto yy45;
yy49:
			yych = *++YYCURSOR;
			if (yych == 'u') goto yy60;
			goto yy45;
yy50:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy11;
			goto yy45;
yy51:
			yych = *++YYCURSOR;
			if (yych <= 0x7F) goto yy45;
			if (yych <= 0xBF) goto yy50;
			goto yy45;
yy52:
			yyaccept = 3;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych <= '/') goto yy54;
				if (yych <= '9') goto yy52;
			} else {
				if (yych <= 'E') goto yy46;
				if (yych == 'e') goto yy46;
			}
yy54:
			{
		ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
		return PHP_JSON_T_DOUBLE;
	}
yy55:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy45;
			if (yych >= ':') goto yy45;
yy56:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy54;
			if (yych <= '9') goto yy56;
			goto yy54;
yy58:
			yych = *++YYCURSOR;
			if (yych == 's') goto yy61;
			goto yy45;
yy59:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy62;
			goto yy45;
yy60:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy64;
			goto yy45;
yy61:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy66;
			goto yy45;
yy62:
			++YYCURSOR;
			{
		ZVAL_NULL(&s->value);
		return PHP_JSON_T_NUL;
	}
yy64:
			++YYCURSOR;
			{
		ZVAL_TRUE(&s->value);
		return PHP_JSON_T_TRUE;
	}
yy66:
			++YYCURSOR;
			{
		ZVAL_FALSE(&s->value);
		return PHP_JSON_T_FALSE;
	}
		}
/* *********************************** */
yyc_STR_P1:
		yych = *YYCURSOR;
		if (yych <= 0xDF) {
			if (yych <= '[') {
				if (yych <= 0x1F) goto yy70;
				if (yych == '"') goto yy74;
				goto yy72;
			} else {
				if (yych <= '\\') goto yy76;
				if (yych <= 0x7F) goto yy72;
				if (yych <= 0xC1) goto yy78;
				goto yy80;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xE0) goto yy81;
				if (yych == 0xED) goto yy83;
				goto yy82;
			} else {
				if (yych <= 0xF0) goto yy84;
				if (yych <= 0xF3) goto yy85;
				if (yych <= 0xF4) goto yy86;
				goto yy78;
			}
		}
yy70:
		++YYCURSOR;
		{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy72:
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P1); }
yy74:
		++YYCURSOR;
		{
		zend_string *str;
		size_t len = s->cursor - s->str_start - s->str_esc - 1 + s->utf8_invalid_count;
		if (len == 0) {
			PHP_JSON_CONDITION_SET(JS);
			ZVAL_EMPTY_STRING(&s->value);
			return PHP_JSON_T_ESTRING;
		}
		str = zend_string_alloc(len, 0);
		ZSTR_VAL(str)[len] = '\0';
		ZVAL_STR(&s->value, str);
		if (s->str_esc || s->utf8_invalid) {
			s->pstr = (php_json_ctype *) Z_STRVAL(s->value);
			s->cursor = s->str_start;
			PHP_JSON_CONDITION_GOTO_STR_P2();
		} else {
			memcpy(Z_STRVAL(s->value), s->str_start, len);
			PHP_JSON_CONDITION_SET(JS);
			return PHP_JSON_T_STRING;
		}
	}
yy76:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'e') {
			if (yych <= '/') {
				if (yych == '"') goto yy87;
				if (yych >= '/') goto yy87;
			} else {
				if (yych <= '\\') {
					if (yych >= '\\') goto yy87;
				} else {
					if (yych == 'b') goto yy87;
				}
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy87;
				if (yych == 'n') goto yy87;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy87;
				} else {
					if (yych <= 't') goto yy87;
					if (yych <= 'u') goto yy89;
				}
			}
		}
yy77:
		{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy78:
		++YYCURSOR;
yy79:
		{
		if (s->options & (PHP_JSON_INVALID_UTF8_IGNORE | PHP_JSON_INVALID_UTF8_SUBSTITUTE)) {
			if (s->options & PHP_JSON_INVALID_UTF8_SUBSTITUTE) {
				if (s->utf8_invalid_count > INT_MAX - 2) {
					s->errcode = PHP_JSON_ERROR_UTF8;
					return PHP_JSON_T_ERROR;
				}
				s->utf8_invalid_count += 2;
			} else {
				s->utf8_invalid_count--;
			}
			s->utf8_invalid = 1;
			PHP_JSON_CONDITION_GOTO(STR_P1);
		}
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy80:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy79;
		if (yych <= 0xBF) goto yy72;
		goto yy79;
yy81:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy79;
		if (yych <= 0xBF) goto yy91;
		goto yy79;
yy82:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy79;
		if (yych <= 0xBF) goto yy91;
		goto yy79;
yy83:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy79;
		if (yych <= 0x9F) goto yy91;
		goto yy79;
yy84:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy79;
		if (yych <= 0xBF) goto yy92;
		goto yy79;
yy85:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy79;
		if (yych <= 0xBF) goto yy92;
		goto yy79;
yy86:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy79;
		if (yych <= 0x8F) goto yy92;
		goto yy79;
yy87:
		++YYCURSOR;
		{
		s->str_esc++;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy89:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy90;
				if (yych <= '0') goto yy93;
				goto yy94;
			} else {
				if (yych <= '@') goto yy90;
				if (yych <= 'C') goto yy94;
				goto yy95;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy94;
				if (yych >= 'a') goto yy94;
			} else {
				if (yych <= 'd') goto yy95;
				if (yych <= 'f') goto yy94;
			}
		}
yy90:
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy77;
			} else {
				goto yy79;
			}
		} else {
			goto yy113;
		}
yy91:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy90;
		if (yych <= 0xBF) goto yy72;
		goto yy90;
yy92:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy90;
		if (yych <= 0xBF) goto yy91;
		goto yy90;
yy93:
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy90;
			if (yych <= '0') goto yy96;
			if (yych <= '7') goto yy97;
			goto yy98;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy90;
				goto yy98;
			} else {
				if (yych <= '`') goto yy90;
				if (yych <= 'f') goto yy98;
				goto yy90;
			}
		}
yy94:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy98;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy98;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy98;
			goto yy90;
		}
yy95:
		yych = *++YYCURSOR;
		if (yych <= 'B') {
			if (yych <= '7') {
				if (yych <= '/') goto yy90;
				goto yy98;
			} else {
				if (yych <= '9') goto yy99;
				if (yych <= '@') goto yy90;
				goto yy99;
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'F') goto yy100;
				goto yy90;
			} else {
				if (yych <= 'b') goto yy99;
				if (yych <= 'f') goto yy100;
				goto yy90;
			}
		}
yy96:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '7') goto yy101;
			if (yych <= '9') goto yy102;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy102;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy102;
			goto yy90;
		}
yy97:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy102;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy102;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy102;
			goto yy90;
		}
yy98:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy103;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy103;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy103;
			goto yy90;
		}
yy99:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy104;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy104;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy104;
			goto yy90;
		}
yy100:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy105;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy105;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy105;
			goto yy90;
		}
yy101:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy106;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy106;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy106;
			goto yy90;
		}
yy102:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy108;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy108;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy108;
			goto yy90;
		}
yy103:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy110;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy110;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy110;
			goto yy90;
		}
yy104:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy112;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy112;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy112;
			goto yy90;
		}
yy105:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych <= '9') goto yy114;
			goto yy90;
		} else {
			if (yych <= 'F') goto yy114;
			if (yych <= '`') goto yy90;
			if (yych <= 'f') goto yy114;
			goto yy90;
		}
yy106:
		++YYCURSOR;
		{
		s->str_esc += 5;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy108:
		++YYCURSOR;
		{
		s->str_esc += 4;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy110:
		++YYCURSOR;
		{
		s->str_esc += 3;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy112:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '\\') goto yy115;
yy113:
		{
		s->errcode = PHP_JSON_ERROR_UTF16;
		return PHP_JSON_T_ERROR;
	}
yy114:
		++YYCURSOR;
		goto yy113;
yy115:
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy90;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy117;
		if (yych != 'd') goto yy90;
yy117:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy90;
		if (yych <= 'F') goto yy118;
		if (yych <= 'b') goto yy90;
		if (yych >= 'g') goto yy90;
yy118:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych >= ':') goto yy90;
		} else {
			if (yych <= 'F') goto yy119;
			if (yych <= '`') goto yy90;
			if (yych >= 'g') goto yy90;
		}
yy119:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy90;
			if (yych >= ':') goto yy90;
		} else {
			if (yych <= 'F') goto yy120;
			if (yych <= '`') goto yy90;
			if (yych >= 'g') goto yy90;
		}
yy120:
		++YYCURSOR;
		{
		s->str_esc += 8;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
/* *********************************** */
yyc_STR_P2_BIN:
		yych = *YYCURSOR;
		if (yych <= 0xDF) {
			if (yych <= '[') {
				if (yych == '"') goto yy126;
			} else {
				if (yych <= '\\') goto yy128;
				if (yych <= 0x7F) goto yy124;
				if (yych <= 0xC1) goto yy130;
				goto yy132;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xE0) goto yy133;
				if (yych == 0xED) goto yy135;
				goto yy134;
			} else {
				if (yych <= 0xF0) goto yy136;
				if (yych <= 0xF3) goto yy137;
				if (yych <= 0xF4) goto yy138;
				goto yy130;
			}
		}
yy124:
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2_BIN); }
yy126:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy128:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy139;
yy129:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy130:
		++YYCURSOR;
yy131:
		{
		if (s->utf8_invalid) {
			PHP_JSON_SCANNER_COPY_ESC();
			if (s->options & PHP_JSON_INVALID_UTF8_SUBSTITUTE) {
				*(s->pstr++) = (char) (0xe0 | (0xfffd >> 12));
				*(s->pstr++) = (char) (0x80 | ((0xfffd >> 6) & 0x3f));
				*(s->pstr++) = (char) (0x80 | (0xfffd & 0x3f));
			}
			s->str_start = s->cursor;
		}
		PHP_JSON_CONDITION_GOTO(STR_P2_BIN);
	}
yy132:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy124;
		goto yy131;
yy133:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy131;
		if (yych <= 0xBF) goto yy141;
		goto yy131;
yy134:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy141;
		goto yy131;
yy135:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0x9F) goto yy141;
		goto yy131;
yy136:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy131;
		if (yych <= 0xBF) goto yy142;
		goto yy131;
yy137:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0xBF) goto yy142;
		goto yy131;
yy138:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy131;
		if (yych <= 0x8F) goto yy142;
		goto yy131;
yy139:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy140;
				if (yych <= '0') goto yy143;
				goto yy144;
			} else {
				if (yych <= '@') goto yy140;
				if (yych <= 'C') goto yy144;
				goto yy145;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy144;
				if (yych >= 'a') goto yy144;
			} else {
				if (yych <= 'd') goto yy145;
				if (yych <= 'f') goto yy144;
			}
		}
yy140:
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy129;
		} else {
			goto yy131;
		}
yy141:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy140;
		if (yych <= 0xBF) goto yy124;
		goto yy140;
yy142:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy140;
		if (yych <= 0xBF) goto yy141;
		goto yy140;
yy143:
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy140;
			if (yych <= '0') goto yy146;
			if (yych <= '7') goto yy147;
			goto yy148;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy140;
				goto yy148;
			} else {
				if (yych <= '`') goto yy140;
				if (yych <= 'f') goto yy148;
				goto yy140;
			}
		}
yy144:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy148;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy148;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy148;
			goto yy140;
		}
yy145:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '7') goto yy148;
			if (yych <= '9') goto yy149;
			goto yy140;
		} else {
			if (yych <= 'B') goto yy149;
			if (yych <= '`') goto yy140;
			if (yych <= 'b') goto yy149;
			goto yy140;
		}
yy146:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '7') goto yy150;
			if (yych <= '9') goto yy151;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy151;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy151;
			goto yy140;
		}
yy147:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy151;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy151;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy151;
			goto yy140;
		}
yy148:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy152;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy152;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy152;
			goto yy140;
		}
yy149:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy153;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy153;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy153;
			goto yy140;
		}
yy150:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy154;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy154;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy154;
			goto yy140;
		}
yy151:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy156;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy156;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy156;
			goto yy140;
		}
yy152:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy158;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy158;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy158;
			goto yy140;
		}
yy153:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy160;
			goto yy140;
		} else {
			if (yych <= 'F') goto yy160;
			if (yych <= '`') goto yy140;
			if (yych <= 'f') goto yy160;
			goto yy140;
		}
yy154:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy156:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy158:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy160:
		yych = *++YYCURSOR;
		if (yych != '\\') goto yy140;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy140;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy163;
		if (yych != 'd') goto yy140;
yy163:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy140;
		if (yych <= 'F') goto yy164;
		if (yych <= 'b') goto yy140;
		if (yych >= 'g') goto yy140;
yy164:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych >= ':') goto yy140;
		} else {
			if (yych <= 'F') goto yy165;
			if (yych <= '`') goto yy140;
			if (yych >= 'g') goto yy140;
		}
yy165:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy140;
			if (yych >= ':') goto yy140;
		} else {
			if (yych <= 'F') goto yy166;
			if (yych <= '`') goto yy140;
			if (yych >= 'g') goto yy140;
		}
yy166:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
/* *********************************** */
yyc_STR_P2_UTF:
		yych = *YYCURSOR;
		if (yych == '"') goto yy172;
		if (yych == '\\') goto yy174;
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2_UTF); }
yy172:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy174:
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy176;
yy175:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy176:
		yych = *++YYCURSOR;
		if (yych <= 'D') {
			if (yych <= '9') {
				if (yych <= '/') goto yy177;
				if (yych <= '0') goto yy178;
				goto yy179;
			} else {
				if (yych <= '@') goto yy177;
				if (yych <= 'C') goto yy179;
				goto yy180;
			}
		} else {
			if (yych <= 'c') {
				if (yych <= 'F') goto yy179;
				if (yych >= 'a') goto yy179;
			} else {
				if (yych <= 'd') goto yy180;
				if (yych <= 'f') goto yy179;
			}
		}
yy177:
		YYCURSOR = YYMARKER;
		goto yy175;
yy178:
		yych = *++YYCURSOR;
		if (yych <= '9') {
			if (yych <= '/') goto yy177;
			if (yych <= '0') goto yy181;
			if (yych <= '7') goto yy182;
			goto yy183;
		} else {
			if (yych <= 'F') {
				if (yych <= '@') goto yy177;
				goto yy183;
			} else {
				if (yych <= '`') goto yy177;
				if (yych <= 'f') goto yy183;
				goto yy177;
			}
		}
yy179:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy183;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy183;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy183;
			goto yy177;
		}
yy180:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '7') goto yy183;
			if (yych <= '9') goto yy184;
			goto yy177;
		} else {
			if (yych <= 'B') goto yy184;
			if (yych <= '`') goto yy177;
			if (yych <= 'b') goto yy184;
			goto yy177;
		}
yy181:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '7') goto yy185;
			if (yych <= '9') goto yy186;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy186;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy186;
			goto yy177;
		}
yy182:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy186;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy186;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy186;
			goto yy177;
		}
yy183:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy187;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy187;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy187;
			goto yy177;
		}
yy184:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy188;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy188;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy188;
			goto yy177;
		}
yy185:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy189;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy189;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy189;
			goto yy177;
		}
yy186:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy191;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy191;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy191;
			goto yy177;
		}
yy187:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy193;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy193;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy193;
			goto yy177;
		}
yy188:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych <= '9') goto yy195;
			goto yy177;
		} else {
			if (yych <= 'F') goto yy195;
			if (yych <= '`') goto yy177;
			if (yych <= 'f') goto yy195;
			goto yy177;
		}
yy189:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy191:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy193:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
yy195:
		yych = *++YYCURSOR;
		if (yych != '\\') goto yy177;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy177;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy198;
		if (yych != 'd') goto yy177;
yy198:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy177;
		if (yych <= 'F') goto yy199;
		if (yych <= 'b') goto yy177;
		if (yych >= 'g') goto yy177;
yy199:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych >= ':') goto yy177;
		} else {
			if (yych <= 'F') goto yy200;
			if (yych <= '`') goto yy177;
			if (yych >= 'g') goto yy177;
		}
yy200:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy177;
			if (yych >= ':') goto yy177;
		} else {
			if (yych <= 'F') goto yy201;
			if (yych <= '`') goto yy177;
			if (yych >= 'g') goto yy177;
		}
yy201:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO_STR_P2();
	}
	}


}
