/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.polyglot.PolyglotProxy;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PolyglotProxy.class)
final class PolyglotProxyGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private PolyglotProxyGen() {
    }

    static {
        LibraryExport.register(PolyglotProxy.class, new InteropLibraryExports());
    }

    @GeneratedBy(value=PolyglotProxy.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, PolyglotProxy.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof PolyglotProxy);
            return new Uncached();
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof PolyglotProxy);
            return new Cached();
        }

        @GeneratedBy(value=PolyglotProxy.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof PolyglotProxy) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.polyglot.PolyglotProxy'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotProxy;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isInstantiable();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.instantiate(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isExecutable();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.execute(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isPointer();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asPointer(this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).hasArrayElements();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.writeArrayElement(arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.removeArrayElement(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.getArraySize(this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementInsertable(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).hasMembers();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.getMembers(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.readMember(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, this, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, this, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.removeMember(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isDate();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isTime();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isTimeZone();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asTimeZone(this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asDate(this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asTime(this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asInstant(this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDuration(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isDuration();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asDuration(this);
            }
        }

        @GeneratedBy(value=PolyglotProxy.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private InteropLibrary executables;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof PolyglotProxy) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.polyglot.PolyglotProxy'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotProxy;
            }

            @Override
            public boolean isInstantiable(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isInstantiable();
            }

            @Override
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.instantiate(arg1Value, this);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.execute(arg1Value, this);
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isPointer();
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asPointer(this);
            }

            @Override
            public boolean hasArrayElements(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).hasArrayElements();
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, this);
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.writeArrayElement(arg1Value, arg2Value, this);
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.removeArrayElement(arg1Value, this);
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.getArraySize(this);
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this);
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this);
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementExisting(arg1Value, this);
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isArrayElementInsertable(arg1Value, this);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).hasMembers();
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.getMembers(arg1Value, this);
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.readMember(arg1Value, this);
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, this);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this, this.executables);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(PolyglotProxy arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.executables == null) {
                        this.executables = super.insert((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.invokeMember(arg1Value, arg2Value, this, this.executables);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    return arg0Value.isMemberInvocable(arg1Value, this, this.executables);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInvocableNode_AndSpecialize(PolyglotProxy arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.executables == null) {
                        this.executables = super.insert((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5));
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberInvocable(arg1Value, this, this.executables);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                arg0Value.removeMember(arg1Value, this);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this);
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this);
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberExisting(arg1Value, this);
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, this);
            }

            @Override
            public boolean isDate(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isDate();
            }

            @Override
            public boolean isTime(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isTime();
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isTimeZone();
            }

            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asTimeZone(this);
            }

            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asDate(this);
            }

            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asTime(this);
            }

            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asInstant(this);
            }

            @Override
            public boolean isDuration(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy)receiver).isDuration();
            }

            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = (PolyglotProxy)arg0Value_;
                return arg0Value.asDuration(this);
            }
        }
    }
}

