/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.nativeapi;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

public class PolyglotNativeAPIFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (!NativeImageOptions.getCStandard().compatibleWith(NativeImageOptions.CStandards.C11)) {
            throw UserError.abort((String)"Polyglot native API supports only the C11 standard. Pass -H:CStandard=C11 on the command line to make the build work.");
        }
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        List<String> headerFiles = Collections.singletonList("polyglot_types.h");
        Path imagePath = access.getImagePath();
        headerFiles.forEach(headerFile -> {
            Path source = Paths.get(System.getProperty("org.graalvm.polyglot.nativeapi.libraryPath"), headerFile);
            Path destination = imagePath.getParent().resolve((String)headerFile);
            try {
                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (Platform.includedIn(InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class)) {
            String id = System.getProperty("org.graalvm.polyglot.install_name_id");
            if (id == null) {
                String msg = String.format("Warning: no id passed through `org.graalvm.polyglot.install_name_id`:\n%s might include its absolute path as id (see man install_name_tool)", imagePath);
                System.err.println(msg);
            } else {
                Process process = null;
                try {
                    process = new ProcessBuilder("install_name_tool", "-id", id, imagePath.toString()).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
                    int exitCode = process.waitFor();
                    if (exitCode != 0) {
                        System.err.println(String.format("Failed to set `id` install name. install_name_tool exited with code %d", exitCode));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    process.destroy();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

